/* Copyright (c) 2002,2007-2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if !defined (_yamato_ENUM_HEADER)
#define _yamato_ENUM_HEADER



#ifndef _DRIVER_BUILD
#ifndef GL_ZERO
#define GL__ZERO                      BLEND_ZERO
#define GL__ONE                       BLEND_ONE
#define GL__SRC_COLOR                 BLEND_SRC_COLOR
#define GL__ONE_MINUS_SRC_COLOR       BLEND_ONE_MINUS_SRC_COLOR
#define GL__DST_COLOR                 BLEND_DST_COLOR
#define GL__ONE_MINUS_DST_COLOR       BLEND_ONE_MINUS_DST_COLOR
#define GL__SRC_ALPHA                 BLEND_SRC_ALPHA
#define GL__ONE_MINUS_SRC_ALPHA       BLEND_ONE_MINUS_SRC_ALPHA
#define GL__DST_ALPHA                 BLEND_DST_ALPHA
#define GL__ONE_MINUS_DST_ALPHA       BLEND_ONE_MINUS_DST_ALPHA
#define GL__SRC_ALPHA_SATURATE        BLEND_SRC_ALPHA_SATURATE
#define GL__CONSTANT_COLOR            BLEND_CONSTANT_COLOR
#define GL__ONE_MINUS_CONSTANT_COLOR  BLEND_ONE_MINUS_CONSTANT_COLOR
#define GL__CONSTANT_ALPHA            BLEND_CONSTANT_ALPHA
#define GL__ONE_MINUS_CONSTANT_ALPHA  BLEND_ONE_MINUS_CONSTANT_ALPHA
#endif
#endif

/*******************************************************
 * PA Enums
 *******************************************************/
#ifndef ENUMS_SU_PERFCNT_SELECT_H
#define ENUMS_SU_PERFCNT_SELECT_H
typedef enum SU_PERFCNT_SELECT {
 PERF_PAPC_PASX_REQ = 0,
 UNUSED1 = 1,
 PERF_PAPC_PASX_FIRST_VECTOR = 2,
 PERF_PAPC_PASX_SECOND_VECTOR = 3,
 PERF_PAPC_PASX_FIRST_DEAD = 4,
 PERF_PAPC_PASX_SECOND_DEAD = 5,
 PERF_PAPC_PASX_VTX_KILL_DISCARD = 6,
 PERF_PAPC_PASX_VTX_NAN_DISCARD = 7,
 PERF_PAPC_PA_INPUT_PRIM = 8,
 PERF_PAPC_PA_INPUT_NULL_PRIM = 9,
 PERF_PAPC_PA_INPUT_EVENT_FLAG = 10,
 PERF_PAPC_PA_INPUT_FIRST_PRIM_SLOT = 11,
 PERF_PAPC_PA_INPUT_END_OF_PACKET = 12,
 PERF_PAPC_CLPR_CULL_PRIM = 13,
 UNUSED2 = 14,
 PERF_PAPC_CLPR_VV_CULL_PRIM = 15,
 UNUSED3 = 16,
 PERF_PAPC_CLPR_VTX_KILL_CULL_PRIM = 17,
 PERF_PAPC_CLPR_VTX_NAN_CULL_PRIM = 18,
 PERF_PAPC_CLPR_CULL_TO_NULL_PRIM = 19,
 UNUSED4 = 20,
 PERF_PAPC_CLPR_VV_CLIP_PRIM = 21,
 UNUSED5 = 22,
 PERF_PAPC_CLPR_POINT_CLIP_CANDIDATE = 23,
 PERF_PAPC_CLPR_CLIP_PLANE_CNT_1 = 24,
 PERF_PAPC_CLPR_CLIP_PLANE_CNT_2 = 25,
 PERF_PAPC_CLPR_CLIP_PLANE_CNT_3 = 26,
 PERF_PAPC_CLPR_CLIP_PLANE_CNT_4 = 27,
 PERF_PAPC_CLPR_CLIP_PLANE_CNT_5 = 28,
 PERF_PAPC_CLPR_CLIP_PLANE_CNT_6 = 29,
 PERF_PAPC_CLPR_CLIP_PLANE_NEAR = 30,
 PERF_PAPC_CLPR_CLIP_PLANE_FAR = 31,
 PERF_PAPC_CLPR_CLIP_PLANE_LEFT = 32,
 PERF_PAPC_CLPR_CLIP_PLANE_RIGHT = 33,
 PERF_PAPC_CLPR_CLIP_PLANE_TOP = 34,
 PERF_PAPC_CLPR_CLIP_PLANE_BOTTOM = 35,
 PERF_PAPC_CLSM_NULL_PRIM = 36,
 PERF_PAPC_CLSM_TOTALLY_VISIBLE_PRIM = 37,
 PERF_PAPC_CLSM_CLIP_PRIM = 38,
 PERF_PAPC_CLSM_CULL_TO_NULL_PRIM = 39,
 PERF_PAPC_CLSM_OUT_PRIM_CNT_1 = 40,
 PERF_PAPC_CLSM_OUT_PRIM_CNT_2 = 41,
 PERF_PAPC_CLSM_OUT_PRIM_CNT_3 = 42,
 PERF_PAPC_CLSM_OUT_PRIM_CNT_4 = 43,
 PERF_PAPC_CLSM_OUT_PRIM_CNT_5 = 44,
 PERF_PAPC_CLSM_OUT_PRIM_CNT_6_7 = 45,
 PERF_PAPC_CLSM_NON_TRIVIAL_CULL = 46,
 PERF_PAPC_SU_INPUT_PRIM = 47,
 PERF_PAPC_SU_INPUT_CLIP_PRIM = 48,
 PERF_PAPC_SU_INPUT_NULL_PRIM = 49,
 PERF_PAPC_SU_ZERO_AREA_CULL_PRIM = 50,
 PERF_PAPC_SU_BACK_FACE_CULL_PRIM = 51,
 PERF_PAPC_SU_FRONT_FACE_CULL_PRIM = 52,
 PERF_PAPC_SU_POLYMODE_FACE_CULL = 53,
 PERF_PAPC_SU_POLYMODE_BACK_CULL = 54,
 PERF_PAPC_SU_POLYMODE_FRONT_CULL = 55,
 PERF_PAPC_SU_POLYMODE_INVALID_FILL = 56,
 PERF_PAPC_SU_OUTPUT_PRIM = 57,
 PERF_PAPC_SU_OUTPUT_CLIP_PRIM = 58,
 PERF_PAPC_SU_OUTPUT_NULL_PRIM = 59,
 PERF_PAPC_SU_OUTPUT_EVENT_FLAG = 60,
 PERF_PAPC_SU_OUTPUT_FIRST_PRIM_SLOT = 61,
 PERF_PAPC_SU_OUTPUT_END_OF_PACKET = 62,
 PERF_PAPC_SU_OUTPUT_POLYMODE_FACE = 63,
 PERF_PAPC_SU_OUTPUT_POLYMODE_BACK = 64,
 PERF_PAPC_SU_OUTPUT_POLYMODE_FRONT = 65,
 PERF_PAPC_SU_OUT_CLIP_POLYMODE_FACE = 66,
 PERF_PAPC_SU_OUT_CLIP_POLYMODE_BACK = 67,
 PERF_PAPC_SU_OUT_CLIP_POLYMODE_FRONT = 68,
 PERF_PAPC_PASX_REQ_IDLE = 69,
 PERF_PAPC_PASX_REQ_BUSY = 70,
 PERF_PAPC_PASX_REQ_STALLED = 71,
 PERF_PAPC_PASX_REC_IDLE = 72,
 PERF_PAPC_PASX_REC_BUSY = 73,
 PERF_PAPC_PASX_REC_STARVED_SX = 74,
 PERF_PAPC_PASX_REC_STALLED = 75,
 PERF_PAPC_PASX_REC_STALLED_POS_MEM = 76,
 PERF_PAPC_PASX_REC_STALLED_CCGSM_IN = 77,
 PERF_PAPC_CCGSM_IDLE = 78,
 PERF_PAPC_CCGSM_BUSY = 79,
 PERF_PAPC_CCGSM_STALLED = 80,
 PERF_PAPC_CLPRIM_IDLE = 81,
 PERF_PAPC_CLPRIM_BUSY = 82,
 PERF_PAPC_CLPRIM_STALLED = 83,
 PERF_PAPC_CLPRIM_STARVED_CCGSM = 84,
 PERF_PAPC_CLIPSM_IDLE = 85,
 PERF_PAPC_CLIPSM_BUSY = 86,
 PERF_PAPC_CLIPSM_WAIT_CLIP_VERT_ENGH = 87,
 PERF_PAPC_CLIPSM_WAIT_HIGH_PRI_SEQ = 88,
 PERF_PAPC_CLIPSM_WAIT_CLIPGA = 89,
 PERF_PAPC_CLIPSM_WAIT_AVAIL_VTE_CLIP = 90,
 PERF_PAPC_CLIPSM_WAIT_CLIP_OUTSM = 91,
 PERF_PAPC_CLIPGA_IDLE = 92,
 PERF_PAPC_CLIPGA_BUSY = 93,
 PERF_PAPC_CLIPGA_STARVED_VTE_CLIP = 94,
 PERF_PAPC_CLIPGA_STALLED = 95,
 PERF_PAPC_CLIP_IDLE = 96,
 PERF_PAPC_CLIP_BUSY = 97,
 PERF_PAPC_SU_IDLE = 98,
 PERF_PAPC_SU_BUSY = 99,
 PERF_PAPC_SU_STARVED_CLIP = 100,
 PERF_PAPC_SU_STALLED_SC = 101,
 PERF_PAPC_SU_FACENESS_CULL = 102,
} SU_PERFCNT_SELECT;
#endif /*ENUMS_SU_PERFCNT_SELECT_H*/

#ifndef ENUMS_SC_PERFCNT_SELECT_H
#define ENUMS_SC_PERFCNT_SELECT_H
typedef enum SC_PERFCNT_SELECT {
 SC_SR_WINDOW_VALID = 0,
 SC_CW_WINDOW_VALID = 1,
 SC_QM_WINDOW_VALID = 2,
 SC_FW_WINDOW_VALID = 3,
 SC_EZ_WINDOW_VALID = 4,
 SC_IT_WINDOW_VALID = 5,
 SC_STARVED_BY_PA = 6,
 SC_STALLED_BY_RB_TILE = 7,
 SC_STALLED_BY_RB_SAMP = 8,
 SC_STARVED_BY_RB_EZ = 9,
 SC_STALLED_BY_SAMPLE_FF = 10,
 SC_STALLED_BY_SQ = 11,
 SC_STALLED_BY_SP = 12,
 SC_TOTAL_NO_PRIMS = 13,
 SC_NON_EMPTY_PRIMS = 14,
 SC_NO_TILES_PASSING_QM = 15,
 SC_NO_PIXELS_PRE_EZ = 16,
 SC_NO_PIXELS_POST_EZ = 17,
} SC_PERFCNT_SELECT;
#endif /*ENUMS_SC_PERFCNT_SELECT_H*/

/*******************************************************
 * VGT Enums
 *******************************************************/
#ifndef ENUMS_VGT_DI_PRIM_TYPE_H
#define ENUMS_VGT_DI_PRIM_TYPE_H
typedef enum VGT_DI_PRIM_TYPE {
 DI_PT_NONE = 0,
 DI_PT_POINTLIST = 1,
 DI_PT_LINELIST = 2,
 DI_PT_LINESTRIP = 3,
 DI_PT_TRILIST = 4,
 DI_PT_TRIFAN = 5,
 DI_PT_TRISTRIP = 6,
 DI_PT_UNUSED_1 = 7,
 DI_PT_RECTLIST = 8,
 DI_PT_UNUSED_2 = 9,
 DI_PT_UNUSED_3 = 10,
 DI_PT_UNUSED_4 = 11,
 DI_PT_UNUSED_5 = 12,
 DI_PT_QUADLIST = 13,
 DI_PT_QUADSTRIP = 14,
 DI_PT_POLYGON = 15,
 DI_PT_2D_COPY_RECT_LIST_V0 = 16,
 DI_PT_2D_COPY_RECT_LIST_V1 = 17,
 DI_PT_2D_COPY_RECT_LIST_V2 = 18,
 DI_PT_2D_COPY_RECT_LIST_V3 = 19,
 DI_PT_2D_FILL_RECT_LIST = 20,
 DI_PT_2D_LINE_STRIP = 21,
 DI_PT_2D_TRI_STRIP = 22,
} VGT_DI_PRIM_TYPE;
#endif /*ENUMS_VGT_DI_PRIM_TYPE_H*/

#ifndef ENUMS_VGT_DI_SOURCE_SELECT_H
#define ENUMS_VGT_DI_SOURCE_SELECT_H
typedef enum VGT_DI_SOURCE_SELECT {
 DI_SRC_SEL_DMA = 0,
 DI_SRC_SEL_IMMEDIATE = 1,
 DI_SRC_SEL_AUTO_INDEX = 2,
 DI_SRC_SEL_RESERVED = 3
} VGT_DI_SOURCE_SELECT;
#endif /*ENUMS_VGT_DI_SOURCE_SELECT_H*/

#ifndef ENUMS_VGT_DI_FACENESS_CULL_SELECT_H
#define ENUMS_VGT_DI_FACENESS_CULL_SELECT_H
typedef enum VGT_DI_FACENESS_CULL_SELECT {
 DI_FACE_CULL_NONE = 0,
 DI_FACE_CULL_FETCH = 1,
 DI_FACE_BACKFACE_CULL = 2,
 DI_FACE_FRONTFACE_CULL = 3
} VGT_DI_FACENESS_CULL_SELECT;
#endif /*ENUMS_VGT_DI_FACENESS_CULL_SELECT_H*/

#ifndef ENUMS_VGT_DI_INDEX_SIZE_H
#define ENUMS_VGT_DI_INDEX_SIZE_H
typedef enum VGT_DI_INDEX_SIZE {
 DI_INDEX_SIZE_16_BIT = 0,
 DI_INDEX_SIZE_32_BIT = 1
} VGT_DI_INDEX_SIZE;
#endif /*ENUMS_VGT_DI_INDEX_SIZE_H*/

#ifndef ENUMS_VGT_DI_SMALL_INDEX_H
#define ENUMS_VGT_DI_SMALL_INDEX_H
typedef enum VGT_DI_SMALL_INDEX {
 DI_USE_INDEX_SIZE = 0,
 DI_INDEX_SIZE_8_BIT = 1
} VGT_DI_SMALL_INDEX;
#endif /*ENUMS_VGT_DI_SMALL_INDEX_H*/

#ifndef ENUMS_VGT_DI_PRE_FETCH_CULL_ENABLE_H
#define ENUMS_VGT_DI_PRE_FETCH_CULL_ENABLE_H
typedef enum VGT_DI_PRE_FETCH_CULL_ENABLE {
 DISABLE_PRE_FETCH_CULL_ENABLE = 0,
 PRE_FETCH_CULL_ENABLE = 1
} VGT_DI_PRE_FETCH_CULL_ENABLE;
#endif /*ENUMS_VGT_DI_PRE_FETCH_CULL_ENABLE_H*/

#ifndef ENUMS_VGT_DI_GRP_CULL_ENABLE_H
#define ENUMS_VGT_DI_GRP_CULL_ENABLE_H
typedef enum VGT_DI_GRP_CULL_ENABLE {
 DISABLE_GRP_CULL_ENABLE = 0,
 GRP_CULL_ENABLE = 1
} VGT_DI_GRP_CULL_ENABLE;
#endif /*ENUMS_VGT_DI_GRP_CULL_ENABLE_H*/

#ifndef ENUMS_VGT_EVENT_TYPE_H
#define ENUMS_VGT_EVENT_TYPE_H
typedef enum VGT_EVENT_TYPE {
 VS_DEALLOC = 0,
 PS_DEALLOC = 1,
 VS_DONE_TS = 2,
 PS_DONE_TS = 3,
 CACHE_FLUSH_TS = 4,
 CONTEXT_DONE = 5,
 CACHE_FLUSH = 6,
 VIZQUERY_START = 7,
 VIZQUERY_END = 8,
 SC_WAIT_WC = 9,
 RST_PIX_CNT = 13,
 RST_VTX_CNT = 14,
 TILE_FLUSH = 15,
 CACHE_FLUSH_AND_INV_TS_EVENT = 20,
 ZPASS_DONE = 21,
 CACHE_FLUSH_AND_INV_EVENT = 22,
 PERFCOUNTER_START = 23,
 PERFCOUNTER_STOP = 24,
 VS_FETCH_DONE = 27,
 FACENESS_FLUSH = 28,
} VGT_EVENT_TYPE;
#endif /*ENUMS_VGT_EVENT_TYPE_H*/

#ifndef ENUMS_VGT_DMA_SWAP_MODE_H
#define ENUMS_VGT_DMA_SWAP_MODE_H
typedef enum VGT_DMA_SWAP_MODE {
 VGT_DMA_SWAP_NONE = 0,
 VGT_DMA_SWAP_16_BIT = 1,
 VGT_DMA_SWAP_32_BIT = 2,
 VGT_DMA_SWAP_WORD = 3
} VGT_DMA_SWAP_MODE;
#endif /*ENUMS_VGT_DMA_SWAP_MODE_H*/

#ifndef ENUMS_VGT_PERFCOUNT_SELECT_H
#define ENUMS_VGT_PERFCOUNT_SELECT_H
typedef enum VGT_PERFCOUNT_SELECT {
 VGT_SQ_EVENT_WINDOW_ACTIVE = 0,
 VGT_SQ_SEND = 1,
 VGT_SQ_STALLED = 2,
 VGT_SQ_STARVED_BUSY = 3,
 VGT_SQ_STARVED_IDLE = 4,
 VGT_SQ_STATIC = 5,
 VGT_PA_EVENT_WINDOW_ACTIVE = 6,
 VGT_PA_CLIP_V_SEND = 7,
 VGT_PA_CLIP_V_STALLED = 8,
 VGT_PA_CLIP_V_STARVED_BUSY = 9,
 VGT_PA_CLIP_V_STARVED_IDLE = 10,
 VGT_PA_CLIP_V_STATIC = 11,
 VGT_PA_CLIP_P_SEND = 12,
 VGT_PA_CLIP_P_STALLED = 13,
 VGT_PA_CLIP_P_STARVED_BUSY = 14,
 VGT_PA_CLIP_P_STARVED_IDLE = 15,
 VGT_PA_CLIP_P_STATIC = 16,
 VGT_PA_CLIP_S_SEND = 17,
 VGT_PA_CLIP_S_STALLED = 18,
 VGT_PA_CLIP_S_STARVED_BUSY = 19,
 VGT_PA_CLIP_S_STARVED_IDLE = 20,
 VGT_PA_CLIP_S_STATIC = 21,
 RBIU_FIFOS_EVENT_WINDOW_ACTIVE = 22,
 RBIU_IMMED_DATA_FIFO_STARVED = 23,
 RBIU_IMMED_DATA_FIFO_STALLED = 24,
 RBIU_DMA_REQUEST_FIFO_STARVED = 25,
 RBIU_DMA_REQUEST_FIFO_STALLED = 26,
 RBIU_DRAW_INITIATOR_FIFO_STARVED = 27,
 RBIU_DRAW_INITIATOR_FIFO_STALLED = 28,
 BIN_PRIM_NEAR_CULL = 29,
 BIN_PRIM_ZERO_CULL = 30,
 BIN_PRIM_FAR_CULL = 31,
 BIN_PRIM_BIN_CULL = 32,
 BIN_PRIM_FACE_CULL = 33,
 SPARE34 = 34,
 SPARE35 = 35,
 SPARE36 = 36,
 SPARE37 = 37,
 SPARE38 = 38,
 SPARE39 = 39,
 TE_SU_IN_VALID = 40,
 TE_SU_IN_READ = 41,
 TE_SU_IN_PRIM = 42,
 TE_SU_IN_EOP = 43,
 TE_SU_IN_NULL_PRIM = 44,
 TE_WK_IN_VALID = 45,
 TE_WK_IN_READ = 46,
 TE_OUT_PRIM_VALID = 47,
 TE_OUT_PRIM_READ = 48,
} VGT_PERFCOUNT_SELECT;
#endif /*ENUMS_VGT_PERFCOUNT_SELECT_H*/

/*******************************************************
 * TP Enums
 *******************************************************/
#ifndef ENUMS_TCR_PERFCOUNT_SELECT_H
#define ENUMS_TCR_PERFCOUNT_SELECT_H
typedef enum TCR_PERFCOUNT_SELECT {
 DGMMPD_IPMUX0_STALL = 0,
 reserved_46 = 1,
 reserved_47 = 2,
 reserved_48 = 3,
 DGMMPD_IPMUX_ALL_STALL = 4,
 OPMUX0_L2_WRITES = 5,
 reserved_49 = 6,
 reserved_50 = 7,
 reserved_51 = 8,
} TCR_PERFCOUNT_SELECT;
#endif /*ENUMS_TCR_PERFCOUNT_SELECT_H*/

#ifndef ENUMS_TP_PERFCOUNT_SELECT_H
#define ENUMS_TP_PERFCOUNT_SELECT_H
typedef enum TP_PERFCOUNT_SELECT {
 POINT_QUADS = 0,
 BILIN_QUADS = 1,
 ANISO_QUADS = 2,
 MIP_QUADS = 3,
 VOL_QUADS = 4,
 MIP_VOL_QUADS = 5,
 MIP_ANISO_QUADS = 6,
 VOL_ANISO_QUADS = 7,
 ANISO_2_1_QUADS = 8,
 ANISO_4_1_QUADS = 9,
 ANISO_6_1_QUADS = 10,
 ANISO_8_1_QUADS = 11,
 ANISO_10_1_QUADS = 12,
 ANISO_12_1_QUADS = 13,
 ANISO_14_1_QUADS = 14,
 ANISO_16_1_QUADS = 15,
 MIP_VOL_ANISO_QUADS = 16,
 ALIGN_2_QUADS = 17,
 ALIGN_4_QUADS = 18,
 PIX_0_QUAD = 19,
 PIX_1_QUAD = 20,
 PIX_2_QUAD = 21,
 PIX_3_QUAD = 22,
 PIX_4_QUAD = 23,
 TP_MIPMAP_LOD0 = 24,
 TP_MIPMAP_LOD1 = 25,
 TP_MIPMAP_LOD2 = 26,
 TP_MIPMAP_LOD3 = 27,
 TP_MIPMAP_LOD4 = 28,
 TP_MIPMAP_LOD5 = 29,
 TP_MIPMAP_LOD6 = 30,
 TP_MIPMAP_LOD7 = 31,
 TP_MIPMAP_LOD8 = 32,
 TP_MIPMAP_LOD9 = 33,
 TP_MIPMAP_LOD10 = 34,
 TP_MIPMAP_LOD11 = 35,
 TP_MIPMAP_LOD12 = 36,
 TP_MIPMAP_LOD13 = 37,
 TP_MIPMAP_LOD14 = 38,
} TP_PERFCOUNT_SELECT;
#endif /*ENUMS_TP_PERFCOUNT_SELECT_H*/

#ifndef ENUMS_TCM_PERFCOUNT_SELECT_H
#define ENUMS_TCM_PERFCOUNT_SELECT_H
typedef enum TCM_PERFCOUNT_SELECT {
 QUAD0_RD_LAT_FIFO_EMPTY = 0,
 reserved_01 = 1,
 reserved_02 = 2,
 QUAD0_RD_LAT_FIFO_4TH_FULL = 3,
 QUAD0_RD_LAT_FIFO_HALF_FULL = 4,
 QUAD0_RD_LAT_FIFO_FULL = 5,
 QUAD0_RD_LAT_FIFO_LT_4TH_FULL = 6,
 reserved_07 = 7,
 reserved_08 = 8,
 reserved_09 = 9,
 reserved_10 = 10,
 reserved_11 = 11,
 reserved_12 = 12,
 reserved_13 = 13,
 reserved_14 = 14,
 reserved_15 = 15,
 reserved_16 = 16,
 reserved_17 = 17,
 reserved_18 = 18,
 reserved_19 = 19,
 reserved_20 = 20,
 reserved_21 = 21,
 reserved_22 = 22,
 reserved_23 = 23,
 reserved_24 = 24,
 reserved_25 = 25,
 reserved_26 = 26,
 reserved_27 = 27,
 READ_STARVED_QUAD0 = 28,
 reserved_29 = 29,
 reserved_30 = 30,
 reserved_31 = 31,
 READ_STARVED = 32,
 READ_STALLED_QUAD0 = 33,
 reserved_34 = 34,
 reserved_35 = 35,
 reserved_36 = 36,
 READ_STALLED = 37,
 VALID_READ_QUAD0 = 38,
 reserved_39 = 39,
 reserved_40 = 40,
 reserved_41 = 41,
 TC_TP_STARVED_QUAD0 = 42,
 reserved_43 = 43,
 reserved_44 = 44,
 reserved_45 = 45,
 TC_TP_STARVED = 46,
} TCM_PERFCOUNT_SELECT;
#endif /*ENUMS_TCM_PERFCOUNT_SELECT_H*/

#ifndef ENUMS_TCF_PERFCOUNT_SELECT_H
#define ENUMS_TCF_PERFCOUNT_SELECT_H
typedef enum TCF_PERFCOUNT_SELECT {
 VALID_CYCLES = 0,
 SINGLE_PHASES = 1,
 ANISO_PHASES = 2,
 MIP_PHASES = 3,
 VOL_PHASES = 4,
 MIP_VOL_PHASES = 5,
 MIP_ANISO_PHASES = 6,
 VOL_ANISO_PHASES = 7,
 ANISO_2_1_PHASES = 8,
 ANISO_4_1_PHASES = 9,
 ANISO_6_1_PHASES = 10,
 ANISO_8_1_PHASES = 11,
 ANISO_10_1_PHASES = 12,
 ANISO_12_1_PHASES = 13,
 ANISO_14_1_PHASES = 14,
 ANISO_16_1_PHASES = 15,
 MIP_VOL_ANISO_PHASES = 16,
 ALIGN_2_PHASES = 17,
 ALIGN_4_PHASES = 18,
 TPC_BUSY = 19,
 TPC_STALLED = 20,
 TPC_STARVED = 21,
 TPC_WORKING = 22,
 TPC_WALKER_BUSY = 23,
 TPC_WALKER_STALLED = 24,
 TPC_WALKER_WORKING = 25,
 TPC_ALIGNER_BUSY = 26,
 TPC_ALIGNER_STALLED = 27,
 TPC_ALIGNER_STALLED_BY_BLEND = 28,
 TPC_ALIGNER_STALLED_BY_CACHE = 29,
 TPC_ALIGNER_WORKING = 30,
 TPC_BLEND_BUSY = 31,
 TPC_BLEND_SYNC = 32,
 TPC_BLEND_STARVED = 33,
 TPC_BLEND_WORKING = 34,
 OPCODE_0x00 = 35,
 OPCODE_0x01 = 36,
 OPCODE_0x04 = 37,
 OPCODE_0x10 = 38,
 OPCODE_0x11 = 39,
 OPCODE_0x12 = 40,
 OPCODE_0x13 = 41,
 OPCODE_0x18 = 42,
 OPCODE_0x19 = 43,
 OPCODE_0x1A = 44,
 OPCODE_OTHER = 45,
 IN_FIFO_0_EMPTY = 56,
 IN_FIFO_0_LT_HALF_FULL = 57,
 IN_FIFO_0_HALF_FULL = 58,
 IN_FIFO_0_FULL = 59,
 IN_FIFO_TPC_EMPTY = 72,
 IN_FIFO_TPC_LT_HALF_FULL = 73,
 IN_FIFO_TPC_HALF_FULL = 74,
 IN_FIFO_TPC_FULL = 75,
 TPC_TC_XFC = 76,
 TPC_TC_STATE = 77,
 TC_STALL = 78,
 QUAD0_TAPS = 79,
 QUADS = 83,
 TCA_SYNC_STALL = 84,
 TAG_STALL = 85,
 TCB_SYNC_STALL = 88,
 TCA_VALID = 89,
 PROBES_VALID = 90,
 MISS_STALL = 91,
 FETCH_FIFO_STALL = 92,
 TCO_STALL = 93,
 ANY_STALL = 94,
 TAG_MISSES = 95,
 TAG_HITS = 96,
 SUB_TAG_MISSES = 97,
 SET0_INVALIDATES = 98,
 SET1_INVALIDATES = 99,
 SET2_INVALIDATES = 100,
 SET3_INVALIDATES = 101,
 SET0_TAG_MISSES = 102,
 SET1_TAG_MISSES = 103,
 SET2_TAG_MISSES = 104,
 SET3_TAG_MISSES = 105,
 SET0_TAG_HITS = 106,
 SET1_TAG_HITS = 107,
 SET2_TAG_HITS = 108,
 SET3_TAG_HITS = 109,
 SET0_SUB_TAG_MISSES = 110,
 SET1_SUB_TAG_MISSES = 111,
 SET2_SUB_TAG_MISSES = 112,
 SET3_SUB_TAG_MISSES = 113,
 SET0_EVICT1 = 114,
 SET0_EVICT2 = 115,
 SET0_EVICT3 = 116,
 SET0_EVICT4 = 117,
 SET0_EVICT5 = 118,
 SET0_EVICT6 = 119,
 SET0_EVICT7 = 120,
 SET0_EVICT8 = 121,
 SET1_EVICT1 = 130,
 SET1_EVICT2 = 131,
 SET1_EVICT3 = 132,
 SET1_EVICT4 = 133,
 SET1_EVICT5 = 134,
 SET1_EVICT6 = 135,
 SET1_EVICT7 = 136,
 SET1_EVICT8 = 137,
 SET2_EVICT1 = 146,
 SET2_EVICT2 = 147,
 SET2_EVICT3 = 148,
 SET2_EVICT4 = 149,
 SET2_EVICT5 = 150,
 SET2_EVICT6 = 151,
 SET2_EVICT7 = 152,
 SET2_EVICT8 = 153,
 SET3_EVICT1 = 162,
 SET3_EVICT2 = 163,
 SET3_EVICT3 = 164,
 SET3_EVICT4 = 165,
 SET3_EVICT5 = 166,
 SET3_EVICT6 = 167,
 SET3_EVICT7 = 168,
 SET3_EVICT8 = 169,
 FF_EMPTY = 178,
 FF_LT_HALF_FULL = 179,
 FF_HALF_FULL = 180,
 FF_FULL = 181,
 FF_XFC = 182,
 FF_STALLED = 183,
 FG_MASKS = 184,
 FG_LEFT_MASKS = 185,
 FG_LEFT_MASK_STALLED = 186,
 FG_LEFT_NOT_DONE_STALL = 187,
 FG_LEFT_FG_STALL = 188,
 FG_LEFT_SECTORS = 189,
 FG0_REQUESTS = 195,
 FG0_STALLED = 196,
 MEM_REQ512 = 199,
 MEM_REQ_SENT = 200,
 MEM_LOCAL_READ_REQ = 202,
 TC0_MH_STALLED = 203,
} TCF_PERFCOUNT_SELECT;
#endif /*ENUMS_TCF_PERFCOUNT_SELECT_H*/

/*******************************************************
 * TC Enums
 *******************************************************/
/*******************************************************
 * SQ Enums
 *******************************************************/
#ifndef ENUMS_SQ_PERFCNT_SELECT_H
#define ENUMS_SQ_PERFCNT_SELECT_H
typedef enum SQ_PERFCNT_SELECT {
 SQ_PIXEL_VECTORS_SUB = 0,
 SQ_VERTEX_VECTORS_SUB = 1,
 SQ_ALU0_ACTIVE_VTX_SIMD0 = 2,
 SQ_ALU1_ACTIVE_VTX_SIMD0 = 3,
 SQ_ALU0_ACTIVE_PIX_SIMD0 = 4,
 SQ_ALU1_ACTIVE_PIX_SIMD0 = 5,
 SQ_ALU0_ACTIVE_VTX_SIMD1 = 6,
 SQ_ALU1_ACTIVE_VTX_SIMD1 = 7,
 SQ_ALU0_ACTIVE_PIX_SIMD1 = 8,
 SQ_ALU1_ACTIVE_PIX_SIMD1 = 9,
 SQ_EXPORT_CYCLES = 10,
 SQ_ALU_CST_WRITTEN = 11,
 SQ_TEX_CST_WRITTEN = 12,
 SQ_ALU_CST_STALL = 13,
 SQ_ALU_TEX_STALL = 14,
 SQ_INST_WRITTEN = 15,
 SQ_BOOLEAN_WRITTEN = 16,
 SQ_LOOPS_WRITTEN = 17,
 SQ_PIXEL_SWAP_IN = 18,
 SQ_PIXEL_SWAP_OUT = 19,
 SQ_VERTEX_SWAP_IN = 20,
 SQ_VERTEX_SWAP_OUT = 21,
 SQ_ALU_VTX_INST_ISSUED = 22,
 SQ_TEX_VTX_INST_ISSUED = 23,
 SQ_VC_VTX_INST_ISSUED = 24,
 SQ_CF_VTX_INST_ISSUED = 25,
 SQ_ALU_PIX_INST_ISSUED = 26,
 SQ_TEX_PIX_INST_ISSUED = 27,
 SQ_VC_PIX_INST_ISSUED = 28,
 SQ_CF_PIX_INST_ISSUED = 29,
 SQ_ALU0_FIFO_EMPTY_SIMD0 = 30,
 SQ_ALU1_FIFO_EMPTY_SIMD0 = 31,
 SQ_ALU0_FIFO_EMPTY_SIMD1 = 32,
 SQ_ALU1_FIFO_EMPTY_SIMD1 = 33,
 SQ_ALU_NOPS = 34,
 SQ_PRED_SKIP = 35,
 SQ_SYNC_ALU_STALL_SIMD0_VTX = 36,
 SQ_SYNC_ALU_STALL_SIMD1_VTX = 37,
 SQ_SYNC_TEX_STALL_VTX = 38,
 SQ_SYNC_VC_STALL_VTX = 39,
 SQ_CONSTANTS_USED_SIMD0 = 40,
 SQ_CONSTANTS_SENT_SP_SIMD0 = 41,
 SQ_GPR_STALL_VTX = 42,
 SQ_GPR_STALL_PIX = 43,
 SQ_VTX_RS_STALL = 44,
 SQ_PIX_RS_STALL = 45,
 SQ_SX_PC_FULL   = 46,
 SQ_SX_EXP_BUFF_FULL = 47,
 SQ_SX_POS_BUFF_FULL = 48,
 SQ_INTERP_QUADS = 49,
 SQ_INTERP_ACTIVE = 50,
 SQ_IN_PIXEL_STALL = 51,
 SQ_IN_VTX_STALL = 52,
 SQ_VTX_CNT = 53,
 SQ_VTX_VECTOR2 = 54,
 SQ_VTX_VECTOR3 = 55,
 SQ_VTX_VECTOR4 = 56,
 SQ_PIXEL_VECTOR1 = 57,
 SQ_PIXEL_VECTOR23 = 58,
 SQ_PIXEL_VECTOR4 = 59,
 SQ_CONSTANTS_USED_SIMD1 = 60,
 SQ_CONSTANTS_SENT_SP_SIMD1 = 61,
 SQ_SX_MEM_EXP_FULL = 62,
 SQ_ALU0_ACTIVE_VTX_SIMD2 = 63,
 SQ_ALU1_ACTIVE_VTX_SIMD2 = 64,
 SQ_ALU0_ACTIVE_PIX_SIMD2 = 65,
 SQ_ALU1_ACTIVE_PIX_SIMD2 = 66,
 SQ_ALU0_ACTIVE_VTX_SIMD3 = 67,
 SQ_PERFCOUNT_VTX_QUAL_TP_DONE = 68,
 SQ_ALU0_ACTIVE_PIX_SIMD3 = 69,
 SQ_PERFCOUNT_PIX_QUAL_TP_DONE = 70,
 SQ_ALU0_FIFO_EMPTY_SIMD2 = 71,
 SQ_ALU1_FIFO_EMPTY_SIMD2 = 72,
 SQ_ALU0_FIFO_EMPTY_SIMD3 = 73,
 SQ_ALU1_FIFO_EMPTY_SIMD3 = 74,
 SQ_SYNC_ALU_STALL_SIMD2_VTX = 75,
 SQ_PERFCOUNT_VTX_POP_THREAD = 76,
 SQ_SYNC_ALU_STALL_SIMD0_PIX = 77,
 SQ_SYNC_ALU_STALL_SIMD1_PIX = 78,
 SQ_SYNC_ALU_STALL_SIMD2_PIX = 79,
 SQ_PERFCOUNT_PIX_POP_THREAD = 80,
 SQ_SYNC_TEX_STALL_PIX = 81,
 SQ_SYNC_VC_STALL_PIX = 82,
 SQ_CONSTANTS_USED_SIMD2 = 83,
 SQ_CONSTANTS_SENT_SP_SIMD2 = 84,
 SQ_PERFCOUNT_VTX_DEALLOC_ACK = 85,
 SQ_PERFCOUNT_PIX_DEALLOC_ACK = 86,
 SQ_ALU0_FIFO_FULL_SIMD0 = 87,
 SQ_ALU1_FIFO_FULL_SIMD0 = 88,
 SQ_ALU0_FIFO_FULL_SIMD1 = 89,
 SQ_ALU1_FIFO_FULL_SIMD1 = 90,
 SQ_ALU0_FIFO_FULL_SIMD2 = 91,
 SQ_ALU1_FIFO_FULL_SIMD2 = 92,
 SQ_ALU0_FIFO_FULL_SIMD3 = 93,
 SQ_ALU1_FIFO_FULL_SIMD3 = 94,
 VC_PERF_STATIC = 95,
 VC_PERF_STALLED = 96,
 VC_PERF_STARVED = 97,
 VC_PERF_SEND = 98,
 VC_PERF_ACTUAL_STARVED = 99,
 PIXEL_THREAD_0_ACTIVE   = 100,
 VERTEX_THREAD_0_ACTIVE  = 101,
 PIXEL_THREAD_0_NUMBER   = 102,
 VERTEX_THREAD_0_NUMBER  = 103,
 VERTEX_EVENT_NUMBER     = 104,
 PIXEL_EVENT_NUMBER  = 105,
 PTRBUFF_EF_PUSH = 106,
 PTRBUFF_EF_POP_EVENT = 107,
 PTRBUFF_EF_POP_NEW_VTX = 108,
 PTRBUFF_EF_POP_DEALLOC = 109,
 PTRBUFF_EF_POP_PVECTOR = 110,
 PTRBUFF_EF_POP_PVECTOR_X = 111,
 PTRBUFF_EF_POP_PVECTOR_VNZ = 112,
 PTRBUFF_PB_DEALLOC = 113,
 PTRBUFF_PI_STATE_PPB_POP = 114,
 PTRBUFF_PI_RTR = 115,
 PTRBUFF_PI_READ_EN = 116,
 PTRBUFF_PI_BUFF_SWAP = 117,
 PTRBUFF_SQ_FREE_BUFF = 118,
 PTRBUFF_SQ_DEC = 119,
 PTRBUFF_SC_VALID_CNTL_EVENT = 120,
 PTRBUFF_SC_VALID_IJ_XFER = 121,
 PTRBUFF_SC_NEW_VECTOR_1_Q = 122,
 PTRBUFF_QUAL_NEW_VECTOR = 123,
 PTRBUFF_QUAL_EVENT = 124,
 PTRBUFF_END_BUFFER = 125,
 PTRBUFF_FILL_QUAD = 126,
 VERTS_WRITTEN_SPI = 127,
 TP_FETCH_INSTR_EXEC = 128,
 TP_FETCH_INSTR_REQ = 129,
 TP_DATA_RETURN = 130,
 SPI_WRITE_CYCLES_SP = 131,
 SPI_WRITES_SP = 132,
 SP_ALU_INSTR_EXEC = 133,
 SP_CONST_ADDR_TO_SQ = 134,
 SP_PRED_KILLS_TO_SQ = 135,
 SP_EXPORT_CYCLES_TO_SX = 136,
 SP_EXPORTS_TO_SX = 137,
 SQ_CYCLES_ELAPSED = 138,
 SQ_TCFS_OPT_ALLOC_EXEC = 139,
 SQ_TCFS_NO_OPT_ALLOC = 140,
 SQ_ALU0_NO_OPT_ALLOC = 141,
 SQ_ALU1_NO_OPT_ALLOC = 142,
 SQ_TCFS_ARB_XFC_CNT = 143,
 SQ_ALU0_ARB_XFC_CNT = 144,
 SQ_ALU1_ARB_XFC_CNT = 145,
 SQ_TCFS_CFS_UPDATE_CNT = 146,
 SQ_ALU0_CFS_UPDATE_CNT = 147,
 SQ_ALU1_CFS_UPDATE_CNT = 148,
 SQ_VTX_PUSH_THREAD_CNT = 149,
 SQ_VTX_POP_THREAD_CNT = 150,
 SQ_PIX_PUSH_THREAD_CNT = 151,
 SQ_PIX_POP_THREAD_CNT = 152,
 SQ_PIX_TOTAL = 153,
 SQ_PIX_KILLED = 154,
} SQ_PERFCNT_SELECT;
#endif /*ENUMS_SQ_PERFCNT_SELECT_H*/

#ifndef ENUMS_SX_PERFCNT_SELECT_H
#define ENUMS_SX_PERFCNT_SELECT_H
typedef enum SX_PERFCNT_SELECT {
 SX_EXPORT_VECTORS = 0,
 SX_DUMMY_QUADS  = 1,
 SX_ALPHA_FAIL = 2,
 SX_RB_QUAD_BUSY = 3,
 SX_RB_COLOR_BUSY = 4,
 SX_RB_QUAD_STALL = 5,
 SX_RB_COLOR_STALL = 6,
} SX_PERFCNT_SELECT;
#endif /*ENUMS_SX_PERFCNT_SELECT_H*/

#ifndef ENUMS_Abs_modifier_H
#define ENUMS_Abs_modifier_H
typedef enum Abs_modifier {
 NO_ABS_MOD = 0,
 ABS_MOD = 1
} Abs_modifier;
#endif /*ENUMS_Abs_modifier_H*/

#ifndef ENUMS_Exporting_H
#define ENUMS_Exporting_H
typedef enum Exporting {
 NOT_EXPORTING = 0,
 EXPORTING = 1
} Exporting;
#endif /*ENUMS_Exporting_H*/

#ifndef ENUMS_ScalarOpcode_H
#define ENUMS_ScalarOpcode_H
typedef enum ScalarOpcode {
 ADDs = 0,
 ADD_PREVs = 1,
 MULs = 2,
 MUL_PREVs = 3,
 MUL_PREV2s = 4,
 MAXs = 5,
 MINs = 6,
 SETEs = 7,
 SETGTs = 8,
 SETGTEs = 9,
 SETNEs = 10,
 FRACs = 11,
 TRUNCs = 12,
 FLOORs = 13,
 EXP_IEEE = 14,
 LOG_CLAMP = 15,
 LOG_IEEE = 16,
 RECIP_CLAMP = 17,
 RECIP_FF = 18,
 RECIP_IEEE = 19,
 RECIPSQ_CLAMP = 20,
 RECIPSQ_FF = 21,
 RECIPSQ_IEEE = 22,
 MOVAs = 23,
 MOVA_FLOORs = 24,
 SUBs = 25,
 SUB_PREVs = 26,
 PRED_SETEs = 27,
 PRED_SETNEs = 28,
 PRED_SETGTs = 29,
 PRED_SETGTEs = 30,
 PRED_SET_INVs = 31,
 PRED_SET_POPs = 32,
 PRED_SET_CLRs = 33,
 PRED_SET_RESTOREs = 34,
 KILLEs = 35,
 KILLGTs = 36,
 KILLGTEs = 37,
 KILLNEs = 38,
 KILLONEs = 39,
 SQRT_IEEE = 40,
 MUL_CONST_0 = 42,
 MUL_CONST_1 = 43,
 ADD_CONST_0 = 44,
 ADD_CONST_1 = 45,
 SUB_CONST_0 = 46,
 SUB_CONST_1 = 47,
 SIN = 48,
 COS = 49,
 RETAIN_PREV = 50,
} ScalarOpcode;
#endif /*ENUMS_ScalarOpcode_H*/

#ifndef ENUMS_SwizzleType_H
#define ENUMS_SwizzleType_H
typedef enum SwizzleType {
 NO_SWIZZLE = 0,
 SHIFT_RIGHT_1 = 1,
 SHIFT_RIGHT_2 = 2,
 SHIFT_RIGHT_3 = 3
} SwizzleType;
#endif /*ENUMS_SwizzleType_H*/

#ifndef ENUMS_InputModifier_H
#define ENUMS_InputModifier_H
typedef enum InputModifier {
 NIL = 0,
 NEGATE = 1
} InputModifier;
#endif /*ENUMS_InputModifier_H*/

#ifndef ENUMS_PredicateSelect_H
#define ENUMS_PredicateSelect_H
typedef enum PredicateSelect {
 NO_PREDICATION = 0,
 PREDICATE_QUAD = 1,
 PREDICATED_2 = 2,
 PREDICATED_3 = 3
} PredicateSelect;
#endif /*ENUMS_PredicateSelect_H*/

#ifndef ENUMS_OperandSelect1_H
#define ENUMS_OperandSelect1_H
typedef enum OperandSelect1 {
 ABSOLUTE_REG = 0,
 RELATIVE_REG = 1
} OperandSelect1;
#endif /*ENUMS_OperandSelect1_H*/

#ifndef ENUMS_VectorOpcode_H
#define ENUMS_VectorOpcode_H
typedef enum VectorOpcode {
 ADDv = 0,
 MULv = 1,
 MAXv = 2,
 MINv = 3,
 SETEv = 4,
 SETGTv = 5,
 SETGTEv = 6,
 SETNEv = 7,
 FRACv = 8,
 TRUNCv = 9,
 FLOORv = 10,
 MULADDv = 11,
 CNDEv = 12,
 CNDGTEv = 13,
 CNDGTv = 14,
 DOT4v = 15,
 DOT3v = 16,
 DOT2ADDv = 17,
 CUBEv = 18,
 MAX4v = 19,
 PRED_SETE_PUSHv = 20,
 PRED_SETNE_PUSHv = 21,
 PRED_SETGT_PUSHv = 22,
 PRED_SETGTE_PUSHv = 23,
 KILLEv = 24,
 KILLGTv = 25,
 KILLGTEv = 26,
 KILLNEv = 27,
 DSTv = 28,
 MOVAv = 29,
} VectorOpcode;
#endif /*ENUMS_VectorOpcode_H*/

#ifndef ENUMS_OperandSelect0_H
#define ENUMS_OperandSelect0_H
typedef enum OperandSelect0 {
 CONSTANT = 0,
 NON_CONSTANT = 1
} OperandSelect0;
#endif /*ENUMS_OperandSelect0_H*/

#ifndef ENUMS_Ressource_type_H
#define ENUMS_Ressource_type_H
typedef enum Ressource_type {
 ALU = 0,
 TEXTURE = 1
} Ressource_type;
#endif /*ENUMS_Ressource_type_H*/

#ifndef ENUMS_Instruction_serial_H
#define ENUMS_Instruction_serial_H
typedef enum Instruction_serial {
 NOT_SERIAL = 0,
 SERIAL = 1
} Instruction_serial;
#endif /*ENUMS_Instruction_serial_H*/

#ifndef ENUMS_VC_type_H
#define ENUMS_VC_type_H
typedef enum VC_type {
 ALU_TP_REQUEST = 0,
 VC_REQUEST = 1
} VC_type;
#endif /*ENUMS_VC_type_H*/

#ifndef ENUMS_Addressing_H
#define ENUMS_Addressing_H
typedef enum Addressing {
 RELATIVE_ADDR = 0,
 ABSOLUTE_ADDR = 1
} Addressing;
#endif /*ENUMS_Addressing_H*/

#ifndef ENUMS_CFOpcode_H
#define ENUMS_CFOpcode_H
typedef enum CFOpcode {
 NOP = 0,
 EXECUTE = 1,
 EXECUTE_END = 2,
 COND_EXECUTE = 3,
 COND_EXECUTE_END = 4,
 COND_PRED_EXECUTE = 5,
 COND_PRED_EXECUTE_END = 6,
 LOOP_START = 7,
 LOOP_END = 8,
 COND_CALL = 9,
 RETURN = 10,
 COND_JMP = 11,
 ALLOCATE = 12,
 COND_EXECUTE_PRED_CLEAN = 13,
 COND_EXECUTE_PRED_CLEAN_END = 14,
 MARK_VS_FETCH_DONE = 15
} CFOpcode;
#endif /*ENUMS_CFOpcode_H*/

#ifndef ENUMS_Allocation_type_H
#define ENUMS_Allocation_type_H
typedef enum Allocation_type {
 SQ_NO_ALLOC = 0,
 SQ_POSITION = 1,
 SQ_PARAMETER_PIXEL = 2,
 SQ_MEMORY = 3
} Allocation_type;
#endif /*ENUMS_Allocation_type_H*/

#ifndef ENUMS_TexInstOpcode_H
#define ENUMS_TexInstOpcode_H
typedef enum TexInstOpcode {
 TEX_INST_FETCH = 1,
 TEX_INST_RESERVED_1 = 2,
 TEX_INST_RESERVED_2 = 3,
 TEX_INST_RESERVED_3 = 4,
 TEX_INST_GET_BORDER_COLOR_FRAC = 16,
 TEX_INST_GET_COMP_TEX_LOD = 17,
 TEX_INST_GET_GRADIENTS = 18,
 TEX_INST_GET_WEIGHTS = 19,
 TEX_INST_SET_TEX_LOD = 24,
 TEX_INST_SET_GRADIENTS_H = 25,
 TEX_INST_SET_GRADIENTS_V = 26,
 TEX_INST_RESERVED_4 = 27,
} TexInstOpcode;
#endif /*ENUMS_TexInstOpcode_H*/

#ifndef ENUMS_Addressmode_H
#define ENUMS_Addressmode_H
typedef enum Addressmode {
 LOGICAL = 0,
 LOOP_RELATIVE = 1
} Addressmode;
#endif /*ENUMS_Addressmode_H*/

#ifndef ENUMS_TexCoordDenorm_H
#define ENUMS_TexCoordDenorm_H
typedef enum TexCoordDenorm {
 TEX_COORD_NORMALIZED = 0,
 TEX_COORD_UNNORMALIZED = 1
} TexCoordDenorm;
#endif /*ENUMS_TexCoordDenorm_H*/

#ifndef ENUMS_SrcSel_H
#define ENUMS_SrcSel_H
typedef enum SrcSel {
 SRC_SEL_X = 0,
 SRC_SEL_Y = 1,
 SRC_SEL_Z = 2,
 SRC_SEL_W = 3
} SrcSel;
#endif /*ENUMS_SrcSel_H*/

#ifndef ENUMS_DstSel_H
#define ENUMS_DstSel_H
typedef enum DstSel {
 DST_SEL_X = 0,
 DST_SEL_Y = 1,
 DST_SEL_Z = 2,
 DST_SEL_W = 3,
 DST_SEL_0 = 4,
 DST_SEL_1 = 5,
 DST_SEL_RSVD = 6,
 DST_SEL_MASK = 7
} DstSel;
#endif /*ENUMS_DstSel_H*/

#ifndef ENUMS_MagFilter_H
#define ENUMS_MagFilter_H
typedef enum MagFilter {
 MAG_FILTER_POINT = 0,
 MAG_FILTER_LINEAR = 1,
 MAG_FILTER_RESERVED_0 = 2,
 MAG_FILTER_USE_FETCH_CONST = 3
} MagFilter;
#endif /*ENUMS_MagFilter_H*/

#ifndef ENUMS_MinFilter_H
#define ENUMS_MinFilter_H
typedef enum MinFilter {
 MIN_FILTER_POINT = 0,
 MIN_FILTER_LINEAR = 1,
 MIN_FILTER_RESERVED_0 = 2,
 MIN_FILTER_USE_FETCH_CONST = 3
} MinFilter;
#endif /*ENUMS_MinFilter_H*/

#ifndef ENUMS_MipFilter_H
#define ENUMS_MipFilter_H
typedef enum MipFilter {
 MIP_FILTER_POINT = 0,
 MIP_FILTER_LINEAR = 1,
 MIP_FILTER_BASEMAP = 2,
 MIP_FILTER_USE_FETCH_CONST = 3
} MipFilter;
#endif /*ENUMS_MipFilter_H*/

#ifndef ENUMS_AnisoFilter_H
#define ENUMS_AnisoFilter_H
typedef enum AnisoFilter {
 ANISO_FILTER_DISABLED = 0,
 ANISO_FILTER_MAX_1_1 = 1,
 ANISO_FILTER_MAX_2_1 = 2,
 ANISO_FILTER_MAX_4_1 = 3,
 ANISO_FILTER_MAX_8_1 = 4,
 ANISO_FILTER_MAX_16_1 = 5,
 ANISO_FILTER_USE_FETCH_CONST = 7
} AnisoFilter;
#endif /*ENUMS_AnisoFilter_H*/

#ifndef ENUMS_ArbitraryFilter_H
#define ENUMS_ArbitraryFilter_H
typedef enum ArbitraryFilter {
 ARBITRARY_FILTER_2X4_SYM = 0,
 ARBITRARY_FILTER_2X4_ASYM = 1,
 ARBITRARY_FILTER_4X2_SYM = 2,
 ARBITRARY_FILTER_4X2_ASYM = 3,
 ARBITRARY_FILTER_4X4_SYM = 4,
 ARBITRARY_FILTER_4X4_ASYM = 5,
 ARBITRARY_FILTER_USE_FETCH_CONST = 7
} ArbitraryFilter;
#endif /*ENUMS_ArbitraryFilter_H*/

#ifndef ENUMS_VolMagFilter_H
#define ENUMS_VolMagFilter_H
typedef enum VolMagFilter {
 VOL_MAG_FILTER_POINT = 0,
 VOL_MAG_FILTER_LINEAR = 1,
 VOL_MAG_FILTER_USE_FETCH_CONST = 3
} VolMagFilter;
#endif /*ENUMS_VolMagFilter_H*/

#ifndef ENUMS_VolMinFilter_H
#define ENUMS_VolMinFilter_H
typedef enum VolMinFilter {
 VOL_MIN_FILTER_POINT = 0,
 VOL_MIN_FILTER_LINEAR = 1,
 VOL_MIN_FILTER_USE_FETCH_CONST = 3
} VolMinFilter;
#endif /*ENUMS_VolMinFilter_H*/

#ifndef ENUMS_PredSelect_H
#define ENUMS_PredSelect_H
typedef enum PredSelect {
 NOT_PREDICATED = 0,
 PREDICATED = 1
} PredSelect;
#endif /*ENUMS_PredSelect_H*/

#ifndef ENUMS_SampleLocation_H
#define ENUMS_SampleLocation_H
typedef enum SampleLocation {
 SAMPLE_CENTROID = 0,
 SAMPLE_CENTER = 1
} SampleLocation;
#endif /*ENUMS_SampleLocation_H*/

#ifndef ENUMS_VertexMode_H
#define ENUMS_VertexMode_H
typedef enum VertexMode {
 POSITION_1_VECTOR = 0,
 POSITION_2_VECTORS_UNUSED = 1,
 POSITION_2_VECTORS_SPRITE = 2,
 POSITION_2_VECTORS_EDGE = 3,
 POSITION_2_VECTORS_KILL = 4,
 POSITION_2_VECTORS_SPRITE_KILL = 5,
 POSITION_2_VECTORS_EDGE_KILL = 6,
 MULTIPASS = 7
} VertexMode;
#endif /*ENUMS_VertexMode_H*/

#ifndef ENUMS_Sample_Cntl_H
#define ENUMS_Sample_Cntl_H
typedef enum Sample_Cntl {
 CENTROIDS_ONLY = 0,
 CENTERS_ONLY = 1,
 CENTROIDS_AND_CENTERS = 2,
 UNDEF = 3
} Sample_Cntl;
#endif /*ENUMS_Sample_Cntl_H*/

/*******************************************************
 * SX Enums
 *******************************************************/
/*******************************************************
 * MH Enums
 *******************************************************/
#ifndef ENUMS_MhPerfEncode_H
#define ENUMS_MhPerfEncode_H
typedef enum MhPerfEncode {
 CP_R0_REQUESTS = 0,
 CP_R1_REQUESTS = 1,
 CP_R2_REQUESTS = 2,
 CP_R3_REQUESTS = 3,
 CP_R4_REQUESTS = 4,
 CP_TOTAL_READ_REQUESTS = 5,
 CP_TOTAL_WRITE_REQUESTS = 6,
 CP_TOTAL_REQUESTS = 7,
 CP_DATA_BYTES_WRITTEN = 8,
 CP_WRITE_CLEAN_RESPONSES = 9,
 CP_R0_READ_BURSTS_RECEIVED = 10,
 CP_R1_READ_BURSTS_RECEIVED = 11,
 CP_R2_READ_BURSTS_RECEIVED = 12,
 CP_R3_READ_BURSTS_RECEIVED = 13,
 CP_R4_READ_BURSTS_RECEIVED = 14,
 CP_TOTAL_READ_BURSTS_RECEIVED = 15,
 CP_R0_DATA_BEATS_READ = 16,
 CP_R1_DATA_BEATS_READ = 17,
 CP_R2_DATA_BEATS_READ = 18,
 CP_R3_DATA_BEATS_READ = 19,
 CP_R4_DATA_BEATS_READ = 20,
 CP_TOTAL_DATA_BEATS_READ = 21,
 VGT_R0_REQUESTS = 22,
 VGT_R1_REQUESTS = 23,
 VGT_TOTAL_REQUESTS = 24,
 VGT_R0_READ_BURSTS_RECEIVED = 25,
 VGT_R1_READ_BURSTS_RECEIVED = 26,
 VGT_TOTAL_READ_BURSTS_RECEIVED = 27,
 VGT_R0_DATA_BEATS_READ = 28,
 VGT_R1_DATA_BEATS_READ = 29,
 VGT_TOTAL_DATA_BEATS_READ = 30,
 TC_TOTAL_REQUESTS = 31,
 TC_ROQ_REQUESTS = 32,
 TC_INFO_SENT = 33,
 TC_READ_BURSTS_RECEIVED = 34,
 TC_DATA_BEATS_READ = 35,
 TCD_BURSTS_READ = 36,
 RB_REQUESTS = 37,
 RB_DATA_BYTES_WRITTEN = 38,
 RB_WRITE_CLEAN_RESPONSES = 39,
 AXI_READ_REQUESTS_ID_0 = 40,
 AXI_READ_REQUESTS_ID_1 = 41,
 AXI_READ_REQUESTS_ID_2 = 42,
 AXI_READ_REQUESTS_ID_3 = 43,
 AXI_READ_REQUESTS_ID_4 = 44,
 AXI_READ_REQUESTS_ID_5 = 45,
 AXI_READ_REQUESTS_ID_6 = 46,
 AXI_READ_REQUESTS_ID_7 = 47,
 AXI_TOTAL_READ_REQUESTS = 48,
 AXI_WRITE_REQUESTS_ID_0 = 49,
 AXI_WRITE_REQUESTS_ID_1 = 50,
 AXI_WRITE_REQUESTS_ID_2 = 51,
 AXI_WRITE_REQUESTS_ID_3 = 52,
 AXI_WRITE_REQUESTS_ID_4 = 53,
 AXI_WRITE_REQUESTS_ID_5 = 54,
 AXI_WRITE_REQUESTS_ID_6 = 55,
 AXI_WRITE_REQUESTS_ID_7 = 56,
 AXI_TOTAL_WRITE_REQUESTS = 57,
 AXI_TOTAL_REQUESTS_ID_0 = 58,
 AXI_TOTAL_REQUESTS_ID_1 = 59,
 AXI_TOTAL_REQUESTS_ID_2 = 60,
 AXI_TOTAL_REQUESTS_ID_3 = 61,
 AXI_TOTAL_REQUESTS_ID_4 = 62,
 AXI_TOTAL_REQUESTS_ID_5 = 63,
 AXI_TOTAL_REQUESTS_ID_6 = 64,
 AXI_TOTAL_REQUESTS_ID_7 = 65,
 AXI_TOTAL_REQUESTS = 66,
 AXI_READ_CHANNEL_BURSTS_ID_0 = 67,
 AXI_READ_CHANNEL_BURSTS_ID_1 = 68,
 AXI_READ_CHANNEL_BURSTS_ID_2 = 69,
 AXI_READ_CHANNEL_BURSTS_ID_3 = 70,
 AXI_READ_CHANNEL_BURSTS_ID_4 = 71,
 AXI_READ_CHANNEL_BURSTS_ID_5 = 72,
 AXI_READ_CHANNEL_BURSTS_ID_6 = 73,
 AXI_READ_CHANNEL_BURSTS_ID_7 = 74,
 AXI_READ_CHANNEL_TOTAL_BURSTS = 75,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_0 = 76,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_1 = 77,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_2 = 78,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_3 = 79,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_4 = 80,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_5 = 81,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_6 = 82,
 AXI_READ_CHANNEL_DATA_BEATS_READ_ID_7 = 83,
 AXI_READ_CHANNEL_TOTAL_DATA_BEATS_READ = 84,
 AXI_WRITE_CHANNEL_BURSTS_ID_0 = 85,
 AXI_WRITE_CHANNEL_BURSTS_ID_1 = 86,
 AXI_WRITE_CHANNEL_BURSTS_ID_2 = 87,
 AXI_WRITE_CHANNEL_BURSTS_ID_3 = 88,
 AXI_WRITE_CHANNEL_BURSTS_ID_4 = 89,
 AXI_WRITE_CHANNEL_BURSTS_ID_5 = 90,
 AXI_WRITE_CHANNEL_BURSTS_ID_6 = 91,
 AXI_WRITE_CHANNEL_BURSTS_ID_7 = 92,
 AXI_WRITE_CHANNEL_TOTAL_BURSTS = 93,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_0 = 94,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_1 = 95,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_2 = 96,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_3 = 97,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_4 = 98,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_5 = 99,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_6 = 100,
 AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_7 = 101,
 AXI_WRITE_CHANNEL_TOTAL_DATA_BYTES_WRITTEN = 102,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_0 = 103,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_1 = 104,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_2 = 105,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_3 = 106,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_4 = 107,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_5 = 108,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_6 = 109,
 AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_7 = 110,
 AXI_WRITE_RESPONSE_CHANNEL_TOTAL_RESPONSES = 111,
 TOTAL_MMU_MISSES = 112,
 MMU_READ_MISSES = 113,
 MMU_WRITE_MISSES = 114,
 TOTAL_MMU_HITS = 115,
 MMU_READ_HITS = 116,
 MMU_WRITE_HITS = 117,
 SPLIT_MODE_TC_HITS = 118,
 SPLIT_MODE_TC_MISSES = 119,
 SPLIT_MODE_NON_TC_HITS = 120,
 SPLIT_MODE_NON_TC_MISSES = 121,
 STALL_AWAITING_TLB_MISS_FETCH = 122,
 MMU_TLB_MISS_READ_BURSTS_RECEIVED = 123,
 MMU_TLB_MISS_DATA_BEATS_READ = 124,
 CP_CYCLES_HELD_OFF = 125,
 VGT_CYCLES_HELD_OFF = 126,
 TC_CYCLES_HELD_OFF = 127,
 TC_ROQ_CYCLES_HELD_OFF = 128,
 TC_CYCLES_HELD_OFF_TCD_FULL = 129,
 RB_CYCLES_HELD_OFF = 130,
 TOTAL_CYCLES_ANY_CLNT_HELD_OFF = 131,
 TLB_MISS_CYCLES_HELD_OFF = 132,
 AXI_READ_REQUEST_HELD_OFF = 133,
 AXI_WRITE_REQUEST_HELD_OFF = 134,
 AXI_REQUEST_HELD_OFF = 135,
 AXI_REQUEST_HELD_OFF_INFLIGHT_LIMIT = 136,
 AXI_WRITE_DATA_HELD_OFF = 137,
 CP_SAME_PAGE_BANK_REQUESTS = 138,
 VGT_SAME_PAGE_BANK_REQUESTS = 139,
 TC_SAME_PAGE_BANK_REQUESTS = 140,
 TC_ARB_HOLD_SAME_PAGE_BANK_REQUESTS = 141,
 RB_SAME_PAGE_BANK_REQUESTS = 142,
 TOTAL_SAME_PAGE_BANK_REQUESTS = 143,
 CP_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT = 144,
 VGT_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT = 145,
 TC_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT = 146,
 RB_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT = 147,
 TOTAL_SAME_PAGE_BANK_KILLED_FAIRNESS_LIMIT = 148,
 TOTAL_MH_READ_REQUESTS = 149,
 TOTAL_MH_WRITE_REQUESTS = 150,
 TOTAL_MH_REQUESTS = 151,
 MH_BUSY = 152,
 CP_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE = 153,
 VGT_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE = 154,
 TC_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE = 155,
 RB_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE = 156,
 TC_ROQ_N_VALID_ENTRIES = 157,
 ARQ_N_ENTRIES = 158,
 WDB_N_ENTRIES = 159,
 MH_READ_LATENCY_OUTST_REQ_SUM = 160,
 MC_READ_LATENCY_OUTST_REQ_SUM = 161,
 MC_TOTAL_READ_REQUESTS = 162,
 ELAPSED_CYCLES_MH_GATED_CLK = 163,
 ELAPSED_CLK_CYCLES = 164,
 CP_W_16B_REQUESTS = 165,
 CP_W_32B_REQUESTS = 166,
 TC_16B_REQUESTS = 167,
 TC_32B_REQUESTS = 168,
 PA_REQUESTS = 169,
 PA_DATA_BYTES_WRITTEN = 170,
 PA_WRITE_CLEAN_RESPONSES = 171,
 PA_CYCLES_HELD_OFF = 172,
 AXI_READ_REQUEST_DATA_BEATS_ID_0 = 173,
 AXI_READ_REQUEST_DATA_BEATS_ID_1 = 174,
 AXI_READ_REQUEST_DATA_BEATS_ID_2 = 175,
 AXI_READ_REQUEST_DATA_BEATS_ID_3 = 176,
 AXI_READ_REQUEST_DATA_BEATS_ID_4 = 177,
 AXI_READ_REQUEST_DATA_BEATS_ID_5 = 178,
 AXI_READ_REQUEST_DATA_BEATS_ID_6 = 179,
 AXI_READ_REQUEST_DATA_BEATS_ID_7 = 180,
 AXI_TOTAL_READ_REQUEST_DATA_BEATS = 181,
} MhPerfEncode;
#endif /*ENUMS_MhPerfEncode_H*/

#ifndef ENUMS_MmuClntBeh_H
#define ENUMS_MmuClntBeh_H
typedef enum MmuClntBeh {
 BEH_NEVR = 0,
 BEH_TRAN_RNG = 1,
 BEH_TRAN_FLT = 2,
} MmuClntBeh;
#endif /*ENUMS_MmuClntBeh_H*/

/*******************************************************
 * RBBM Enums
 *******************************************************/
#ifndef ENUMS_RBBM_PERFCOUNT1_SEL_H
#define ENUMS_RBBM_PERFCOUNT1_SEL_H
typedef enum RBBM_PERFCOUNT1_SEL {
 RBBM1_COUNT = 0,
 RBBM1_NRT_BUSY = 1,
 RBBM1_RB_BUSY = 2,
 RBBM1_SQ_CNTX0_BUSY = 3,
 RBBM1_SQ_CNTX17_BUSY = 4,
 RBBM1_VGT_BUSY = 5,
 RBBM1_VGT_NODMA_BUSY = 6,
 RBBM1_PA_BUSY = 7,
 RBBM1_SC_CNTX_BUSY = 8,
 RBBM1_TPC_BUSY = 9,
 RBBM1_TC_BUSY = 10,
 RBBM1_SX_BUSY = 11,
 RBBM1_CP_COHER_BUSY = 12,
 RBBM1_CP_NRT_BUSY = 13,
 RBBM1_GFX_IDLE_STALL = 14,
 RBBM1_INTERRUPT = 15,
} RBBM_PERFCOUNT1_SEL;
#endif /*ENUMS_RBBM_PERFCOUNT1_SEL_H*/

/*******************************************************
 * CP Enums
 *******************************************************/
#ifndef ENUMS_CP_PERFCOUNT_SEL_H
#define ENUMS_CP_PERFCOUNT_SEL_H
typedef enum CP_PERFCOUNT_SEL {
 ALWAYS_COUNT = 0,
 TRANS_FIFO_FULL = 1,
 TRANS_FIFO_AF = 2,
 RCIU_PFPTRANS_WAIT = 3,
 Reserved_04 = 4,
 Reserved_05 = 5,
 RCIU_NRTTRANS_WAIT = 6,
 Reserved_07 = 7,
 CSF_NRT_READ_WAIT = 8,
 CSF_I1_FIFO_FULL = 9,
 CSF_I2_FIFO_FULL = 10,
 CSF_ST_FIFO_FULL = 11,
 Reserved_12 = 12,
 CSF_RING_ROQ_FULL = 13,
 CSF_I1_ROQ_FULL = 14,
 CSF_I2_ROQ_FULL = 15,
 CSF_ST_ROQ_FULL = 16,
 Reserved_17 = 17,
 MIU_TAG_MEM_FULL = 18,
 MIU_WRITECLEAN = 19,
 Reserved_20 = 20,
 Reserved_21 = 21,
 MIU_NRT_WRITE_STALLED = 22,
 MIU_NRT_READ_STALLED = 23,
 ME_WRITE_CONFIRM_FIFO_FULL = 24,
 ME_VS_DEALLOC_FIFO_FULL = 25,
 ME_PS_DEALLOC_FIFO_FULL = 26,
 ME_REGS_VS_EVENT_FIFO_FULL = 27,
 ME_REGS_PS_EVENT_FIFO_FULL = 28,
 ME_REGS_CF_EVENT_FIFO_FULL = 29,
 ME_MICRO_RB_STARVED = 30,
 ME_MICRO_I1_STARVED = 31,
 ME_MICRO_I2_STARVED = 32,
 ME_MICRO_ST_STARVED = 33,
 Reserved_34 = 34,
 Reserved_35 = 35,
 Reserved_36 = 36,
 Reserved_37 = 37,
 Reserved_38 = 38,
 Reserved_39 = 39,
 RCIU_RBBM_DWORD_SENT = 40,
 ME_BUSY_CLOCKS = 41,
 ME_WAIT_CONTEXT_AVAIL = 42,
 PFP_TYPE0_PACKET = 43,
 PFP_TYPE3_PACKET = 44,
 CSF_RB_WPTR_NEQ_RPTR = 45,
 CSF_I1_SIZE_NEQ_ZERO = 46,
 CSF_I2_SIZE_NEQ_ZERO = 47,
 CSF_RBI1I2_FETCHING = 48,
 Reserved_49 = 49,
 Reserved_50 = 50,
 Reserved_51 = 51,
 Reserved_52 = 52,
 Reserved_53 = 53,
 Reserved_54 = 54,
 Reserved_55 = 55,
 Reserved_56 = 56,
 Reserved_57 = 57,
 Reserved_58 = 58,
 Reserved_59 = 59,
 Reserved_60 = 60,
 Reserved_61 = 61,
 Reserved_62 = 62,
 Reserved_63 = 63
} CP_PERFCOUNT_SEL;
#endif /*ENUMS_CP_PERFCOUNT_SEL_H*/

/*******************************************************
 * SC Enums
 *******************************************************/
/*******************************************************
 * BC Enums
 *******************************************************/
#ifndef ENUMS_ColorformatX_H
#define ENUMS_ColorformatX_H
typedef enum ColorformatX {
 COLORX_4_4_4_4 = 0,
 COLORX_1_5_5_5 = 1,
 COLORX_5_6_5 = 2,
 COLORX_8 = 3,
 COLORX_8_8 = 4,
 COLORX_8_8_8_8 = 5,
 COLORX_S8_8_8_8 = 6,
 COLORX_16_FLOAT = 7,
 COLORX_16_16_FLOAT = 8,
 COLORX_16_16_16_16_FLOAT = 9,
 COLORX_32_FLOAT = 10,
 COLORX_32_32_FLOAT = 11,
 COLORX_32_32_32_32_FLOAT = 12,
 COLORX_2_3_3 = 13,
 COLORX_8_8_8 = 14,
} ColorformatX;
#endif /*ENUMS_ColorformatX_H*/

#ifndef ENUMS_DepthformatX_H
#define ENUMS_DepthformatX_H
typedef enum DepthformatX {
 DEPTHX_16 = 0,
 DEPTHX_24_8 = 1
} DepthformatX;
#endif /*ENUMS_DepthformatX_H*/

#ifndef ENUMS_CompareFrag_H
#define ENUMS_CompareFrag_H
typedef enum CompareFrag {
 FRAG_NEVER = 0,
 FRAG_LESS = 1,
 FRAG_EQUAL = 2,
 FRAG_LEQUAL = 3,
 FRAG_GREATER = 4,
 FRAG_NOTEQUAL = 5,
 FRAG_GEQUAL = 6,
 FRAG_ALWAYS = 7
} CompareFrag;
#endif /*ENUMS_CompareFrag_H*/

#ifndef ENUMS_CompareRef_H
#define ENUMS_CompareRef_H
typedef enum CompareRef {
 REF_NEVER = 0,
 REF_LESS = 1,
 REF_EQUAL = 2,
 REF_LEQUAL = 3,
 REF_GREATER = 4,
 REF_NOTEQUAL = 5,
 REF_GEQUAL = 6,
 REF_ALWAYS = 7
} CompareRef;
#endif /*ENUMS_CompareRef_H*/

#ifndef ENUMS_StencilOp_H
#define ENUMS_StencilOp_H
typedef enum StencilOp {
 STENCIL_KEEP = 0,
 STENCIL_ZERO = 1,
 STENCIL_REPLACE = 2,
 STENCIL_INCR_CLAMP = 3,
 STENCIL_DECR_CLAMP = 4,
 STENCIL_INVERT = 5,
 STENCIL_INCR_WRAP = 6,
 STENCIL_DECR_WRAP = 7
} StencilOp;
#endif /*ENUMS_StencilOp_H*/

#ifndef ENUMS_BlendOpX_H
#define ENUMS_BlendOpX_H
typedef enum BlendOpX {
 BLENDX_ZERO = 0,
 BLENDX_ONE = 1,
 BLENDX_SRC_COLOR = 4,
 BLENDX_ONE_MINUS_SRC_COLOR = 5,
 BLENDX_SRC_ALPHA = 6,
 BLENDX_ONE_MINUS_SRC_ALPHA = 7,
 BLENDX_DST_COLOR = 8,
 BLENDX_ONE_MINUS_DST_COLOR = 9,
 BLENDX_DST_ALPHA = 10,
 BLENDX_ONE_MINUS_DST_ALPHA = 11,
 BLENDX_CONSTANT_COLOR = 12,
 BLENDX_ONE_MINUS_CONSTANT_COLOR = 13,
 BLENDX_CONSTANT_ALPHA = 14,
 BLENDX_ONE_MINUS_CONSTANT_ALPHA = 15,
 BLENDX_SRC_ALPHA_SATURATE = 16,
} BlendOpX;
#endif /*ENUMS_BlendOpX_H*/

#ifndef ENUMS_CombFuncX_H
#define ENUMS_CombFuncX_H
typedef enum CombFuncX {
 COMB_DST_PLUS_SRC = 0,
 COMB_SRC_MINUS_DST = 1,
 COMB_MIN_DST_SRC = 2,
 COMB_MAX_DST_SRC = 3,
 COMB_DST_MINUS_SRC = 4,
 COMB_DST_PLUS_SRC_BIAS = 5,
} CombFuncX;
#endif /*ENUMS_CombFuncX_H*/

#ifndef ENUMS_DitherModeX_H
#define ENUMS_DitherModeX_H
typedef enum DitherModeX {
 DITHER_DISABLE = 0,
 DITHER_ALWAYS = 1,
 DITHER_IF_ALPHA_OFF = 2,
} DitherModeX;
#endif /*ENUMS_DitherModeX_H*/

#ifndef ENUMS_DitherTypeX_H
#define ENUMS_DitherTypeX_H
typedef enum DitherTypeX {
 DITHER_PIXEL = 0,
 DITHER_SUBPIXEL = 1,
} DitherTypeX;
#endif /*ENUMS_DitherTypeX_H*/

#ifndef ENUMS_EdramMode_H
#define ENUMS_EdramMode_H
typedef enum EdramMode {
 EDRAM_NOP = 0,
 COLOR_DEPTH = 4,
 DEPTH_ONLY = 5,
 EDRAM_COPY = 6,
} EdramMode;
#endif /*ENUMS_EdramMode_H*/

#ifndef ENUMS_SurfaceEndian_H
#define ENUMS_SurfaceEndian_H
typedef enum SurfaceEndian {
 ENDIAN_NONE = 0,
 ENDIAN_8IN16 = 1,
 ENDIAN_8IN32 = 2,
 ENDIAN_16IN32 = 3,
 ENDIAN_8IN64 = 4,
 ENDIAN_8IN128 = 5,
} SurfaceEndian;
#endif /*ENUMS_SurfaceEndian_H*/

#ifndef ENUMS_EdramSizeX_H
#define ENUMS_EdramSizeX_H
typedef enum EdramSizeX {
 EDRAMSIZE_16KB = 0,
 EDRAMSIZE_32KB = 1,
 EDRAMSIZE_64KB = 2,
 EDRAMSIZE_128KB = 3,
 EDRAMSIZE_256KB = 4,
 EDRAMSIZE_512KB = 5,
 EDRAMSIZE_1MB = 6,
 EDRAMSIZE_2MB = 7,
 EDRAMSIZE_4MB = 8,
 EDRAMSIZE_8MB = 9,
 EDRAMSIZE_16MB = 10,
} EdramSizeX;
#endif /*ENUMS_EdramSizeX_H*/

#ifndef ENUMS_RB_PERFCNT_SELECT_H
#define ENUMS_RB_PERFCNT_SELECT_H
typedef enum RB_PERFCNT_SELECT {
 RBPERF_CNTX_BUSY = 0,
 RBPERF_CNTX_BUSY_MAX = 1,
 RBPERF_SX_QUAD_STARVED = 2,
 RBPERF_SX_QUAD_STARVED_MAX = 3,
 RBPERF_GA_GC_CH0_SYS_REQ = 4,
 RBPERF_GA_GC_CH0_SYS_REQ_MAX = 5,
 RBPERF_GA_GC_CH1_SYS_REQ = 6,
 RBPERF_GA_GC_CH1_SYS_REQ_MAX = 7,
 RBPERF_MH_STARVED = 8,
 RBPERF_MH_STARVED_MAX = 9,
 RBPERF_AZ_BC_COLOR_BUSY = 10,
 RBPERF_AZ_BC_COLOR_BUSY_MAX = 11,
 RBPERF_AZ_BC_Z_BUSY = 12,
 RBPERF_AZ_BC_Z_BUSY_MAX = 13,
 RBPERF_RB_SC_TILE_RTR_N = 14,
 RBPERF_RB_SC_TILE_RTR_N_MAX = 15,
 RBPERF_RB_SC_SAMP_RTR_N = 16,
 RBPERF_RB_SC_SAMP_RTR_N_MAX = 17,
 RBPERF_RB_SX_QUAD_RTR_N = 18,
 RBPERF_RB_SX_QUAD_RTR_N_MAX = 19,
 RBPERF_RB_SX_COLOR_RTR_N = 20,
 RBPERF_RB_SX_COLOR_RTR_N_MAX = 21,
 RBPERF_RB_SC_SAMP_LZ_BUSY = 22,
 RBPERF_RB_SC_SAMP_LZ_BUSY_MAX = 23,
 RBPERF_ZXP_STALL = 24,
 RBPERF_ZXP_STALL_MAX = 25,
 RBPERF_EVENT_PENDING = 26,
 RBPERF_EVENT_PENDING_MAX = 27,
 RBPERF_RB_MH_VALID = 28,
 RBPERF_RB_MH_VALID_MAX = 29,
 RBPERF_SX_RB_QUAD_SEND = 30,
 RBPERF_SX_RB_COLOR_SEND = 31,
 RBPERF_SC_RB_TILE_SEND = 32,
 RBPERF_SC_RB_SAMPLE_SEND = 33,
 RBPERF_SX_RB_MEM_EXPORT = 34,
 RBPERF_SX_RB_QUAD_EVENT = 35,
 RBPERF_SC_RB_TILE_EVENT_FILTERED = 36,
 RBPERF_SC_RB_TILE_EVENT_ALL = 37,
 RBPERF_RB_SC_EZ_SEND = 38,
 RBPERF_RB_SX_INDEX_SEND = 39,
 RBPERF_GMEM_INTFO_RD = 40,
 RBPERF_GMEM_INTF1_RD = 41,
 RBPERF_GMEM_INTFO_WR = 42,
 RBPERF_GMEM_INTF1_WR = 43,
 RBPERF_RB_CP_CONTEXT_DONE = 44,
 RBPERF_RB_CP_CACHE_FLUSH = 45,
 RBPERF_ZPASS_DONE = 46,
 RBPERF_ZCMD_VALID = 47,
 RBPERF_CCMD_VALID = 48,
 RBPERF_ACCUM_GRANT = 49,
 RBPERF_ACCUM_C0_GRANT = 50,
 RBPERF_ACCUM_C1_GRANT = 51,
 RBPERF_ACCUM_FULL_BE_WR = 52,
 RBPERF_ACCUM_REQUEST_NO_GRANT = 53,
 RBPERF_ACCUM_TIMEOUT_PULSE = 54,
 RBPERF_ACCUM_LIN_TIMEOUT_PULSE = 55,
 RBPERF_ACCUM_CAM_HIT_FLUSHING = 56,
} RB_PERFCNT_SELECT;
#endif /*ENUMS_RB_PERFCNT_SELECT_H*/

#ifndef ENUMS_DepthFormat_H
#define ENUMS_DepthFormat_H
typedef enum DepthFormat {
 DEPTH_24_8 = 22,
 DEPTH_24_8_FLOAT = 23,
 DEPTH_16 = 24,
} DepthFormat;
#endif /*ENUMS_DepthFormat_H*/

#ifndef ENUMS_SurfaceSwap_H
#define ENUMS_SurfaceSwap_H
typedef enum SurfaceSwap {
 SWAP_LOWRED = 0,
 SWAP_LOWBLUE = 1
} SurfaceSwap;
#endif /*ENUMS_SurfaceSwap_H*/

#ifndef ENUMS_DepthArray_H
#define ENUMS_DepthArray_H
typedef enum DepthArray {
 ARRAY_2D_ALT_DEPTH = 0,
 ARRAY_2D_DEPTH = 1,
} DepthArray;
#endif /*ENUMS_DepthArray_H*/

#ifndef ENUMS_ColorArray_H
#define ENUMS_ColorArray_H
typedef enum ColorArray {
 ARRAY_2D_ALT_COLOR = 0,
 ARRAY_2D_COLOR = 1,
 ARRAY_3D_SLICE_COLOR = 3
} ColorArray;
#endif /*ENUMS_ColorArray_H*/

#ifndef ENUMS_ColorFormat_H
#define ENUMS_ColorFormat_H
typedef enum ColorFormat {
 COLOR_8 = 2,
 COLOR_1_5_5_5 = 3,
 COLOR_5_6_5 = 4,
 COLOR_6_5_5 = 5,
 COLOR_8_8_8_8 = 6,
 COLOR_2_10_10_10 = 7,
 COLOR_8_A = 8,
 COLOR_8_B = 9,
 COLOR_8_8 = 10,
 COLOR_8_8_8 = 11,
 COLOR_8_8_8_8_A = 14,
 COLOR_4_4_4_4 = 15,
 COLOR_10_11_11 = 16,
 COLOR_11_11_10 = 17,
 COLOR_16 = 24,
 COLOR_16_16 = 25,
 COLOR_16_16_16_16 = 26,
 COLOR_16_FLOAT = 30,
 COLOR_16_16_FLOAT = 31,
 COLOR_16_16_16_16_FLOAT = 32,
 COLOR_32_FLOAT = 36,
 COLOR_32_32_FLOAT = 37,
 COLOR_32_32_32_32_FLOAT = 38,
 COLOR_2_3_3 = 39,
} ColorFormat;
#endif /*ENUMS_ColorFormat_H*/

#ifndef ENUMS_SurfaceNumber_H
#define ENUMS_SurfaceNumber_H
typedef enum SurfaceNumber {
 NUMBER_UREPEAT = 0,
 NUMBER_SREPEAT = 1,
 NUMBER_UINTEGER = 2,
 NUMBER_SINTEGER = 3,
 NUMBER_GAMMA = 4,
 NUMBER_FIXED = 5,
 NUMBER_FLOAT = 7
} SurfaceNumber;
#endif /*ENUMS_SurfaceNumber_H*/

#ifndef ENUMS_SurfaceFormat_H
#define ENUMS_SurfaceFormat_H
typedef enum SurfaceFormat {
 FMT_1_REVERSE = 0,
 FMT_1 = 1,
 FMT_8 = 2,
 FMT_1_5_5_5 = 3,
 FMT_5_6_5 = 4,
 FMT_6_5_5 = 5,
 FMT_8_8_8_8 = 6,
 FMT_2_10_10_10 = 7,
 FMT_8_A = 8,
 FMT_8_B = 9,
 FMT_8_8 = 10,
 FMT_Cr_Y1_Cb_Y0 = 11,
 FMT_Y1_Cr_Y0_Cb = 12,
 FMT_5_5_5_1 = 13,
 FMT_8_8_8_8_A = 14,
 FMT_4_4_4_4 = 15,
 FMT_8_8_8 = 16,
 FMT_DXT1 = 18,
 FMT_DXT2_3 = 19,
 FMT_DXT4_5 = 20,
 FMT_10_10_10_2 = 21,
 FMT_24_8 = 22,
 FMT_16 = 24,
 FMT_16_16 = 25,
 FMT_16_16_16_16 = 26,
 FMT_16_EXPAND = 27,
 FMT_16_16_EXPAND = 28,
 FMT_16_16_16_16_EXPAND = 29,
 FMT_16_FLOAT = 30,
 FMT_16_16_FLOAT = 31,
 FMT_16_16_16_16_FLOAT = 32,
 FMT_32 = 33,
 FMT_32_32 = 34,
 FMT_32_32_32_32 = 35,
 FMT_32_FLOAT = 36,
 FMT_32_32_FLOAT = 37,
 FMT_32_32_32_32_FLOAT = 38,
 FMT_ATI_TC_RGB = 39,
 FMT_ATI_TC_RGBA = 40,
 FMT_ATI_TC_555_565_RGB = 41,
 FMT_ATI_TC_555_565_RGBA = 42,
 FMT_ATI_TC_RGBA_INTERP = 43,
 FMT_ATI_TC_555_565_RGBA_INTERP = 44,
 FMT_ETC1_RGBA_INTERP = 46,
 FMT_ETC1_RGB = 47,
 FMT_ETC1_RGBA = 48,
 FMT_DXN = 49,
 FMT_2_3_3 = 51,
 FMT_2_10_10_10_AS_16_16_16_16 = 54,
 FMT_10_10_10_2_AS_16_16_16_16 = 55,
 FMT_32_32_32_FLOAT = 57,
 FMT_DXT3A = 58,
 FMT_DXT5A = 59,
 FMT_CTX1 = 60,
} SurfaceFormat;
#endif /*ENUMS_SurfaceFormat_H*/

#ifndef ENUMS_SurfaceTiling_H
#define ENUMS_SurfaceTiling_H
typedef enum SurfaceTiling {
 ARRAY_LINEAR = 0,
 ARRAY_TILED = 1
} SurfaceTiling;
#endif /*ENUMS_SurfaceTiling_H*/

#ifndef ENUMS_SurfaceArray_H
#define ENUMS_SurfaceArray_H
typedef enum SurfaceArray {
 ARRAY_1D = 0,
 ARRAY_2D = 1,
 ARRAY_3D = 2,
 ARRAY_3D_SLICE = 3
} SurfaceArray;
#endif /*ENUMS_SurfaceArray_H*/

#ifndef ENUMS_SurfaceNumberX_H
#define ENUMS_SurfaceNumberX_H
typedef enum SurfaceNumberX {
 NUMBERX_UREPEAT = 0,
 NUMBERX_SREPEAT = 1,
 NUMBERX_UINTEGER = 2,
 NUMBERX_SINTEGER = 3,
 NUMBERX_FLOAT = 7
} SurfaceNumberX;
#endif /*ENUMS_SurfaceNumberX_H*/

#ifndef ENUMS_ColorArrayX_H
#define ENUMS_ColorArrayX_H
typedef enum ColorArrayX {
 ARRAYX_2D_COLOR = 0,
 ARRAYX_3D_SLICE_COLOR = 1,
} ColorArrayX;
#endif /*ENUMS_ColorArrayX_H*/

#endif /*_yamato_ENUM_HEADER*/

