/*
 * Freescale GPMI NAND Flash Driver
 *
 * Copyright 2008-2012 Freescale Semiconductor, Inc.
 * Copyright 2008 Embedded Alley Solutions, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
#ifndef __GPMI_NAND_GPMI_REGS_H
#define __GPMI_NAND_GPMI_REGS_H

#define HW_GPMI_CTRL0					0x00000000
#define HW_GPMI_CTRL0_SET				0x00000004
#define HW_GPMI_CTRL0_CLR				0x00000008
#define HW_GPMI_CTRL0_TOG				0x0000000c

#define BP_GPMI_CTRL0_COMMAND_MODE			24
#define BM_GPMI_CTRL0_COMMAND_MODE	(3 << BP_GPMI_CTRL0_COMMAND_MODE)
#define BF_GPMI_CTRL0_COMMAND_MODE(v)	\
	(((v) << BP_GPMI_CTRL0_COMMAND_MODE) & BM_GPMI_CTRL0_COMMAND_MODE)
#define BV_GPMI_CTRL0_COMMAND_MODE__WRITE		0x0
#define BV_GPMI_CTRL0_COMMAND_MODE__READ		0x1
#define BV_GPMI_CTRL0_COMMAND_MODE__READ_AND_COMPARE	0x2
#define BV_GPMI_CTRL0_COMMAND_MODE__WAIT_FOR_READY	0x3

#define BM_GPMI_CTRL0_WORD_LENGTH			(1 << 23)
#define BV_GPMI_CTRL0_WORD_LENGTH__16_BIT		0x0
#define BV_GPMI_CTRL0_WORD_LENGTH__8_BIT		0x1

/*
 *  Difference in LOCK_CS between imx23 and imx28 :
 *  This bit may impact the _POWER_ consumption. So some chips
 *  do not set it.
 */
#define MX23_BP_GPMI_CTRL0_LOCK_CS			22
#define MX28_BP_GPMI_CTRL0_LOCK_CS			27
#define LOCK_CS_ENABLE					0x1
#define BF_GPMI_CTRL0_LOCK_CS(v, x)			0x0

/* Difference in CS between imx23 and imx28 */
#define BP_GPMI_CTRL0_CS				20
#define MX23_BM_GPMI_CTRL0_CS		(3 << BP_GPMI_CTRL0_CS)
#define MX28_BM_GPMI_CTRL0_CS		(7 << BP_GPMI_CTRL0_CS)
#define BF_GPMI_CTRL0_CS(v, x)		(((v) << BP_GPMI_CTRL0_CS) & \
						(GPMI_IS_MX23((x)) \
						? MX23_BM_GPMI_CTRL0_CS	\
						: MX28_BM_GPMI_CTRL0_CS))

#define BP_GPMI_CTRL0_ADDRESS				17
#define BM_GPMI_CTRL0_ADDRESS		(3 << BP_GPMI_CTRL0_ADDRESS)
#define BF_GPMI_CTRL0_ADDRESS(v)	\
		(((v) << BP_GPMI_CTRL0_ADDRESS) & BM_GPMI_CTRL0_ADDRESS)
#define BV_GPMI_CTRL0_ADDRESS__NAND_DATA		0x0
#define BV_GPMI_CTRL0_ADDRESS__NAND_CLE			0x1
#define BV_GPMI_CTRL0_ADDRESS__NAND_ALE			0x2

#define BM_GPMI_CTRL0_ADDRESS_INCREMENT			(1 << 16)
#define BV_GPMI_CTRL0_ADDRESS_INCREMENT__DISABLED	0x0
#define BV_GPMI_CTRL0_ADDRESS_INCREMENT__ENABLED	0x1

#define BP_GPMI_CTRL0_XFER_COUNT			0
#define BM_GPMI_CTRL0_XFER_COUNT	(0xffff << BP_GPMI_CTRL0_XFER_COUNT)
#define BF_GPMI_CTRL0_XFER_COUNT(v)	\
		(((v) << BP_GPMI_CTRL0_XFER_COUNT) & BM_GPMI_CTRL0_XFER_COUNT)

#define HW_GPMI_COMPARE					0x00000010

#define HW_GPMI_ECCCTRL					0x00000020
#define HW_GPMI_ECCCTRL_SET				0x00000024
#define HW_GPMI_ECCCTRL_CLR				0x00000028
#define HW_GPMI_ECCCTRL_TOG				0x0000002c

#define BP_GPMI_ECCCTRL_ECC_CMD				13
#define BM_GPMI_ECCCTRL_ECC_CMD		(3 << BP_GPMI_ECCCTRL_ECC_CMD)
#define BF_GPMI_ECCCTRL_ECC_CMD(v)	\
		(((v) << BP_GPMI_ECCCTRL_ECC_CMD) & BM_GPMI_ECCCTRL_ECC_CMD)
#define BV_GPMI_ECCCTRL_ECC_CMD__BCH_DECODE		0x0
#define BV_GPMI_ECCCTRL_ECC_CMD__BCH_ENCODE		0x1

#define BM_GPMI_ECCCTRL_ENABLE_ECC			(1 << 12)
#define BV_GPMI_ECCCTRL_ENABLE_ECC__ENABLE		0x1
#define BV_GPMI_ECCCTRL_ENABLE_ECC__DISABLE		0x0

#define BP_GPMI_ECCCTRL_BUFFER_MASK			0
#define BM_GPMI_ECCCTRL_BUFFER_MASK	(0x1ff << BP_GPMI_ECCCTRL_BUFFER_MASK)
#define BF_GPMI_ECCCTRL_BUFFER_MASK(v)	\
	(((v) << BP_GPMI_ECCCTRL_BUFFER_MASK) & BM_GPMI_ECCCTRL_BUFFER_MASK)
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BCH_AUXONLY	0x100
#define BV_GPMI_ECCCTRL_BUFFER_MASK__BCH_PAGE		0x1FF

#define HW_GPMI_ECCCOUNT				0x00000030
#define HW_GPMI_PAYLOAD					0x00000040
#define HW_GPMI_AUXILIARY				0x00000050
#define HW_GPMI_CTRL1					0x00000060
#define HW_GPMI_CTRL1_SET				0x00000064
#define HW_GPMI_CTRL1_CLR				0x00000068
#define HW_GPMI_CTRL1_TOG				0x0000006c

#define BM_GPMI_CTRL1_DEV_CLK_STOP 0x80000000
#define BM_GPMI_CTRL1_SSYNC_CLK_STOP 0x40000000
#define BM_GPMI_CTRL1_WRITE_CLK_STOP 0x20000000
#define BM_GPMI_CTRL1_TOGGLE_MODE 0x10000000
#define BM_GPMI_CTRL1_GPMI_CLK_DIV2_EN 0x08000000
#define BM_GPMI_CTRL1_UPDATE_CS 0x04000000
#define BM_GPMI_CTRL1_SSYNCMODE 0x02000000
#define BV_GPMI_CTRL1_SSYNCMODE__ASYNC 0x0
#define BV_GPMI_CTRL1_SSYNCMODE__SSYNC 0x1
#define BM_GPMI_CTRL1_DECOUPLE_CS 0x01000000
#define BP_GPMI_CTRL1_WRN_DLY_SEL      22
#define BM_GPMI_CTRL1_WRN_DLY_SEL 0x00C00000
#define BF_GPMI_CTRL1_WRN_DLY_SEL(v)  \
	(((v) << 22) & BM_GPMI_CTRL1_WRN_DLY_SEL)
#define BM_GPMI_CTRL1_RSVD1 0x00200000
#define BM_GPMI_CTRL1_TIMEOUT_IRQ_EN 0x00100000
#define BM_GPMI_CTRL1_GANGED_RDYBUSY 0x00080000
#define BM_GPMI_CTRL1_BCH_MODE 0x00040000
#define BM_GPMI_CTRL1_DLL_ENABLE 0x00020000
#define BP_GPMI_CTRL1_HALF_PERIOD       16
#define BM_GPMI_CTRL1_HALF_PERIOD 0x00010000
#define BP_GPMI_CTRL1_RDN_DELAY      12
#define BM_GPMI_CTRL1_RDN_DELAY 0x0000F000
#define BF_GPMI_CTRL1_RDN_DELAY(v)  \
	(((v) << 12) & BM_GPMI_CTRL1_RDN_DELAY)
#define BM_GPMI_CTRL1_DMA2ECC_MODE 0x00000800
#define BM_GPMI_CTRL1_DEV_IRQ 0x00000400
#define BM_GPMI_CTRL1_TIMEOUT_IRQ 0x00000200
#define BM_GPMI_CTRL1_BURST_EN 0x00000100
#define BM_GPMI_CTRL1_ABORT_WAIT_REQUEST 0x00000080
#define BP_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL      4
#define BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL 0x00000070
#define BF_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL(v)  \
	(((v) << 4) & BM_GPMI_CTRL1_ABORT_WAIT_FOR_READY_CHANNEL)
#define BM_GPMI_CTRL1_DEV_RESET 0x00000008
#define BV_GPMI_CTRL1_DEV_RESET__ENABLED  0x0
#define BV_GPMI_CTRL1_DEV_RESET__DISABLED 0x1
#define BM_GPMI_CTRL1_ATA_IRQRDY_POLARITY 0x00000004
#define BV_GPMI_CTRL1_ATA_IRQRDY_POLARITY__ACTIVELOW  0x0
#define BV_GPMI_CTRL1_ATA_IRQRDY_POLARITY__ACTIVEHIGH 0x1
#define BM_GPMI_CTRL1_CAMERA_MODE 0x00000002
#define BM_GPMI_CTRL1_GPMI_MODE 0x00000001
#define BV_GPMI_CTRL1_GPMI_MODE__NAND 0x0
#define BV_GPMI_CTRL1_GPMI_MODE__ATA  0x1

#define HW_GPMI_TIMING0					0x00000070

#define BP_GPMI_TIMING0_ADDRESS_SETUP			16
#define BM_GPMI_TIMING0_ADDRESS_SETUP	(0xff << BP_GPMI_TIMING0_ADDRESS_SETUP)
#define BF_GPMI_TIMING0_ADDRESS_SETUP(v)	\
	(((v) << BP_GPMI_TIMING0_ADDRESS_SETUP) & BM_GPMI_TIMING0_ADDRESS_SETUP)

#define BP_GPMI_TIMING0_DATA_HOLD			8
#define BM_GPMI_TIMING0_DATA_HOLD	(0xff << BP_GPMI_TIMING0_DATA_HOLD)
#define BF_GPMI_TIMING0_DATA_HOLD(v)		\
	(((v) << BP_GPMI_TIMING0_DATA_HOLD) & BM_GPMI_TIMING0_DATA_HOLD)

#define BP_GPMI_TIMING0_DATA_SETUP			0
#define BM_GPMI_TIMING0_DATA_SETUP	(0xff << BP_GPMI_TIMING0_DATA_SETUP)
#define BF_GPMI_TIMING0_DATA_SETUP(v)		\
	(((v) << BP_GPMI_TIMING0_DATA_SETUP) & BM_GPMI_TIMING0_DATA_SETUP)

#define HW_GPMI_TIMING1					0x00000080
#define BP_GPMI_TIMING1_BUSY_TIMEOUT			16
#define BM_GPMI_TIMING1_DEVICE_BUSY_TIMEOUT 0xFFFF0000
#define BF_GPMI_TIMING1_DEVICE_BUSY_TIMEOUT(v) \
	(((v) << 16) & BM_GPMI_TIMING1_DEVICE_BUSY_TIMEOUT)

#define HW_GPMI_TIMING2					0x00000090

#define BP_GPMI_TIMING2_RSVD1      27
#define BM_GPMI_TIMING2_RSVD1 0xF8000000
#define BF_GPMI_TIMING2_RSVD1(v) \
	(((v) << 27) & BM_GPMI_TIMING2_RSVD1)
#define BP_GPMI_TIMING2_READ_LATENCY      24
#define BM_GPMI_TIMING2_READ_LATENCY 0x07000000
#define BF_GPMI_TIMING2_READ_LATENCY(v)  \
	(((v) << 24) & BM_GPMI_TIMING2_READ_LATENCY)
#define BP_GPMI_TIMING2_RSVD0      21
#define BM_GPMI_TIMING2_RSVD0 0x00E00000
#define BF_GPMI_TIMING2_RSVD0(v)  \
	(((v) << 21) & BM_GPMI_TIMING2_RSVD0)
#define BP_GPMI_TIMING2_CE_DELAY      16
#define BM_GPMI_TIMING2_CE_DELAY 0x001F0000
#define BF_GPMI_TIMING2_CE_DELAY(v)  \
	(((v) << 16) & BM_GPMI_TIMING2_CE_DELAY)
#define BP_GPMI_TIMING2_PREAMBLE_DELAY      12
#define BM_GPMI_TIMING2_PREAMBLE_DELAY 0x0000F000
#define BF_GPMI_TIMING2_PREAMBLE_DELAY(v)  \
	(((v) << 12) & BM_GPMI_TIMING2_PREAMBLE_DELAY)
#define BP_GPMI_TIMING2_POSTAMBLE_DELAY      8
#define BM_GPMI_TIMING2_POSTAMBLE_DELAY 0x00000F00
#define BF_GPMI_TIMING2_POSTAMBLE_DELAY(v)  \
	(((v) << 8) & BM_GPMI_TIMING2_POSTAMBLE_DELAY)
#define BP_GPMI_TIMING2_CMDADD_PAUSE      4
#define BM_GPMI_TIMING2_CMDADD_PAUSE 0x000000F0
#define BF_GPMI_TIMING2_CMDADD_PAUSE(v)  \
	(((v) << 4) & BM_GPMI_TIMING2_CMDADD_PAUSE)
#define BP_GPMI_TIMING2_DATA_PAUSE      0
#define BM_GPMI_TIMING2_DATA_PAUSE 0x0000000F
#define BF_GPMI_TIMING2_DATA_PAUSE(v)  \
	(((v) << 0) & BM_GPMI_TIMING2_DATA_PAUSE)

#define HW_GPMI_DATA					0x000000a0

/* MX28 uses this to detect READY. */
#define HW_GPMI_STAT					0x000000b0
#define MX28_BP_GPMI_STAT_READY_BUSY			24
#define MX28_BM_GPMI_STAT_READY_BUSY	(0xff << MX28_BP_GPMI_STAT_READY_BUSY)
#define MX28_BF_GPMI_STAT_READY_BUSY(v)		\
	(((v) << MX28_BP_GPMI_STAT_READY_BUSY) & MX28_BM_GPMI_STAT_READY_BUSY)

/* MX23 uses this to detect READY. */
#define HW_GPMI_DEBUG					0x000000c0
#define MX23_BP_GPMI_DEBUG_READY0			28
#define MX23_BM_GPMI_DEBUG_READY0	(1 << MX23_BP_GPMI_DEBUG_READY0)

#define HW_GPMI_READ_DDR_DLL_CTRL	(0x00000100)

#define BP_GPMI_READ_DDR_DLL_CTRL_REF_UPDATE_INT      28
#define BM_GPMI_READ_DDR_DLL_CTRL_REF_UPDATE_INT 0xF0000000
#define BF_GPMI_READ_DDR_DLL_CTRL_REF_UPDATE_INT(v) \
	(((v) << 28) & BM_GPMI_READ_DDR_DLL_CTRL_REF_UPDATE_INT)
#define BP_GPMI_READ_DDR_DLL_CTRL_SLV_UPDATE_INT      20
#define BM_GPMI_READ_DDR_DLL_CTRL_SLV_UPDATE_INT 0x0FF00000
#define BF_GPMI_READ_DDR_DLL_CTRL_SLV_UPDATE_INT(v)  \
	(((v) << 20) & BM_GPMI_READ_DDR_DLL_CTRL_SLV_UPDATE_INT)
#define BP_GPMI_READ_DDR_DLL_CTRL_RSVD1      18
#define BM_GPMI_READ_DDR_DLL_CTRL_RSVD1 0x000C0000
#define BF_GPMI_READ_DDR_DLL_CTRL_RSVD1(v)  \
	(((v) << 18) & BM_GPMI_READ_DDR_DLL_CTRL_RSVD1)
#define BP_GPMI_READ_DDR_DLL_CTRL_SLV_OVERRIDE_VAL      10
#define BM_GPMI_READ_DDR_DLL_CTRL_SLV_OVERRIDE_VAL 0x0003FC00
#define BF_GPMI_READ_DDR_DLL_CTRL_SLV_OVERRIDE_VAL(v)  \
	(((v) << 10) & BM_GPMI_READ_DDR_DLL_CTRL_SLV_OVERRIDE_VAL)
#define BM_GPMI_READ_DDR_DLL_CTRL_SLV_OVERRIDE 0x00000200
#define BM_GPMI_READ_DDR_DLL_CTRL_REFCLK_ON 0x00000100
#define BM_GPMI_READ_DDR_DLL_CTRL_GATE_UPDATE 0x00000080
#define BP_GPMI_READ_DDR_DLL_CTRL_SLV_DLY_TARGET      3
#define BM_GPMI_READ_DDR_DLL_CTRL_SLV_DLY_TARGET 0x00000078
#define BF_GPMI_READ_DDR_DLL_CTRL_SLV_DLY_TARGET(v)  \
	(((v) << 3) & BM_GPMI_READ_DDR_DLL_CTRL_SLV_DLY_TARGET)
#define BM_GPMI_READ_DDR_DLL_CTRL_SLV_FORCE_UPD 0x00000004
#define BM_GPMI_READ_DDR_DLL_CTRL_RESET 0x00000002
#define BM_GPMI_READ_DDR_DLL_CTRL_ENABLE 0x00000001

#define HW_GPMI_WRITE_DDR_DLL_CTRL	(0x00000110)

#define BP_GPMI_WRITE_DDR_DLL_CTRL_REF_UPDATE_INT      28
#define BM_GPMI_WRITE_DDR_DLL_CTRL_REF_UPDATE_INT 0xF0000000
#define BF_GPMI_WRITE_DDR_DLL_CTRL_REF_UPDATE_INT(v) \
	(((v) << 28) & BM_GPMI_WRITE_DDR_DLL_CTRL_REF_UPDATE_INT)
#define BP_GPMI_WRITE_DDR_DLL_CTRL_SLV_UPDATE_INT      20
#define BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_UPDATE_INT 0x0FF00000
#define BF_GPMI_WRITE_DDR_DLL_CTRL_SLV_UPDATE_INT(v)  \
	(((v) << 20) & BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_UPDATE_INT)
#define BP_GPMI_WRITE_DDR_DLL_CTRL_RSVD1      18
#define BM_GPMI_WRITE_DDR_DLL_CTRL_RSVD1 0x000C0000
#define BF_GPMI_WRITE_DDR_DLL_CTRL_RSVD1(v)  \
	(((v) << 18) & BM_GPMI_WRITE_DDR_DLL_CTRL_RSVD1)
#define BP_GPMI_WRITE_DDR_DLL_CTRL_SLV_OVERRIDE_VAL      10
#define BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_OVERRIDE_VAL 0x0003FC00
#define BF_GPMI_WRITE_DDR_DLL_CTRL_SLV_OVERRIDE_VAL(v)  \
	(((v) << 10) & BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_OVERRIDE_VAL)
#define BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_OVERRIDE 0x00000200
#define BM_GPMI_WRITE_DDR_DLL_CTRL_REFCLK_ON 0x00000100
#define BM_GPMI_WRITE_DDR_DLL_CTRL_GATE_UPDATE 0x00000080
#define BP_GPMI_WRITE_DDR_DLL_CTRL_SLV_DLY_TARGET      3
#define BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_DLY_TARGET 0x00000078
#define BF_GPMI_WRITE_DDR_DLL_CTRL_SLV_DLY_TARGET(v)  \
	(((v) << 3) & BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_DLY_TARGET)
#define BM_GPMI_WRITE_DDR_DLL_CTRL_SLV_FORCE_UPD 0x00000004
#define BM_GPMI_WRITE_DDR_DLL_CTRL_RESET 0x00000002
#define BM_GPMI_WRITE_DDR_DLL_CTRL_ENABLE 0x00000001

#define HW_GPMI_READ_DDR_DLL_STS	(0x00000120)

#define BP_GPMI_READ_DDR_DLL_STS_RSVD1      25
#define BM_GPMI_READ_DDR_DLL_STS_RSVD1 0xFE000000
#define BF_GPMI_READ_DDR_DLL_STS_RSVD1(v) \
	(((v) << 25) & BM_GPMI_READ_DDR_DLL_STS_RSVD1)
#define BP_GPMI_READ_DDR_DLL_STS_REF_SEL      17
#define BM_GPMI_READ_DDR_DLL_STS_REF_SEL 0x01FE0000
#define BF_GPMI_READ_DDR_DLL_STS_REF_SEL(v)  \
	(((v) << 17) & BM_GPMI_READ_DDR_DLL_STS_REF_SEL)
#define BM_GPMI_READ_DDR_DLL_STS_REF_LOCK 0x00010000
#define BP_GPMI_READ_DDR_DLL_STS_RSVD0      9
#define BM_GPMI_READ_DDR_DLL_STS_RSVD0 0x0000FE00
#define BF_GPMI_READ_DDR_DLL_STS_RSVD0(v)  \
	(((v) << 9) & BM_GPMI_READ_DDR_DLL_STS_RSVD0)
#define BP_GPMI_READ_DDR_DLL_STS_SLV_SEL      1
#define BM_GPMI_READ_DDR_DLL_STS_SLV_SEL 0x000001FE
#define BF_GPMI_READ_DDR_DLL_STS_SLV_SEL(v)  \
	(((v) << 1) & BM_GPMI_READ_DDR_DLL_STS_SLV_SEL)
#define BM_GPMI_READ_DDR_DLL_STS_SLV_LOCK 0x00000001

#define HW_GPMI_WRITE_DDR_DLL_STS	(0x00000130)

#define BP_GPMI_WRITE_DDR_DLL_STS_RSVD1      25
#define BM_GPMI_WRITE_DDR_DLL_STS_RSVD1 0xFE000000
#define BF_GPMI_WRITE_DDR_DLL_STS_RSVD1(v) \
	(((v) << 25) & BM_GPMI_WRITE_DDR_DLL_STS_RSVD1)
#define BP_GPMI_WRITE_DDR_DLL_STS_REF_SEL      17
#define BM_GPMI_WRITE_DDR_DLL_STS_REF_SEL 0x01FE0000
#define BF_GPMI_WRITE_DDR_DLL_STS_REF_SEL(v)  \
	(((v) << 17) & BM_GPMI_WRITE_DDR_DLL_STS_REF_SEL)
#define BM_GPMI_WRITE_DDR_DLL_STS_REF_LOCK 0x00010000
#define BP_GPMI_WRITE_DDR_DLL_STS_RSVD0      9
#define BM_GPMI_WRITE_DDR_DLL_STS_RSVD0 0x0000FE00
#define BF_GPMI_WRITE_DDR_DLL_STS_RSVD0(v)  \
	(((v) << 9) & BM_GPMI_WRITE_DDR_DLL_STS_RSVD0)
#define BP_GPMI_WRITE_DDR_DLL_STS_SLV_SEL      1
#define BM_GPMI_WRITE_DDR_DLL_STS_SLV_SEL 0x000001FE
#define BF_GPMI_WRITE_DDR_DLL_STS_SLV_SEL(v)  \
	(((v) << 1) & BM_GPMI_WRITE_DDR_DLL_STS_SLV_SEL)
#define BM_GPMI_WRITE_DDR_DLL_STS_SLV_LOCK 0x00000001
#endif
