/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpchannel_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimpchannel
 * @title: gimpchannel
 * @short_description: Functions for manipulating channels.
 *
 * Functions for manipulating channels.
 **/


/**
 * _gimp_channel_new:
 * @image: The image to which to add the channel.
 * @width: The channel width.
 * @height: The channel height.
 * @name: The channel name.
 * @opacity: The channel opacity.
 * @color: The channel compositing color.
 *
 * Create a new channel.
 *
 * This procedure creates a new channel with the specified width,
 * height, name, opacity and color.
 * The new channel still needs to be added to the image, as this is not
 * automatic. Add the new channel with gimp_image_insert_channel().
 * Other attributes, such as channel visibility, should be set with
 * explicit procedure calls.
 * The channel's contents are undefined initially.
 *
 * Returns: (transfer none): The newly created channel.
 **/
GimpChannel *
_gimp_channel_new (GimpImage     *image,
                   gint           width,
                   gint           height,
                   const gchar   *name,
                   gdouble        opacity,
                   const GimpRGB *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpChannel *channel = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          G_TYPE_INT, width,
                                          G_TYPE_INT, height,
                                          G_TYPE_STRING, name,
                                          G_TYPE_DOUBLE, opacity,
                                          GIMP_TYPE_RGB, color,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-new",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    channel = GIMP_VALUES_GET_CHANNEL (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return channel;
}

/**
 * gimp_channel_new_from_component:
 * @image: The image to which to add the channel.
 * @component: The image component.
 * @name: The channel name.
 *
 * Create a new channel from a color component
 *
 * This procedure creates a new channel from a color component.
 * The new channel still needs to be added to the image, as this is not
 * automatic. Add the new channel with gimp_image_insert_channel().
 * Other attributes, such as channel visibility, should be set with
 * explicit procedure calls.
 *
 * Returns: (transfer none): The newly created channel.
 *
 * Since: 2.4
 **/
GimpChannel *
gimp_channel_new_from_component (GimpImage       *image,
                                 GimpChannelType  component,
                                 const gchar     *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpChannel *channel = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_CHANNEL_TYPE, component,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-new-from-component",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    channel = GIMP_VALUES_GET_CHANNEL (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return channel;
}

/**
 * gimp_channel_copy:
 * @channel: The channel to copy.
 *
 * Copy a channel.
 *
 * This procedure copies the specified channel and returns the copy.
 * The new channel still needs to be added to the image, as this is not
 * automatic. Add the new channel with gimp_image_insert_channel().
 *
 * Returns: (transfer none): The newly copied channel.
 **/
GimpChannel *
gimp_channel_copy (GimpChannel *channel)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpChannel *channel_copy = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-copy",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    channel_copy = GIMP_VALUES_GET_CHANNEL (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return channel_copy;
}

/**
 * gimp_channel_combine_masks:
 * @channel1: The channel1.
 * @channel2: The channel2.
 * @operation: The selection operation.
 * @offx: x offset between upper left corner of channels: (second - first).
 * @offy: y offset between upper left corner of channels: (second - first).
 *
 * Combine two channel masks.
 *
 * This procedure combines two channel masks. The result is stored in
 * the first channel.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_combine_masks (GimpChannel    *channel1,
                            GimpChannel    *channel2,
                            GimpChannelOps  operation,
                            gint            offx,
                            gint            offy)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel1,
                                          GIMP_TYPE_CHANNEL, channel2,
                                          GIMP_TYPE_CHANNEL_OPS, operation,
                                          G_TYPE_INT, offx,
                                          G_TYPE_INT, offy,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-combine-masks",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_get_show_masked:
 * @channel: The channel.
 *
 * Get the composite method of the specified channel.
 *
 * This procedure returns the specified channel's composite method. If
 * it is TRUE, then the channel is composited with the image so that
 * masked regions are shown. Otherwise, selected regions are shown.
 *
 * Returns: The channel composite method.
 **/
gboolean
gimp_channel_get_show_masked (GimpChannel *channel)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean show_masked = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-get-show-masked",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    show_masked = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return show_masked;
}

/**
 * gimp_channel_set_show_masked:
 * @channel: The channel.
 * @show_masked: The new channel composite method.
 *
 * Set the composite method of the specified channel.
 *
 * This procedure sets the specified channel's composite method. If it
 * is TRUE, then the channel is composited with the image so that
 * masked regions are shown. Otherwise, selected regions are shown.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_set_show_masked (GimpChannel *channel,
                              gboolean     show_masked)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel,
                                          G_TYPE_BOOLEAN, show_masked,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-set-show-masked",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_get_opacity:
 * @channel: The channel.
 *
 * Get the opacity of the specified channel.
 *
 * This procedure returns the specified channel's opacity.
 *
 * Returns: The channel opacity.
 **/
gdouble
gimp_channel_get_opacity (GimpChannel *channel)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble opacity = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-get-opacity",
                                              args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    opacity = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return opacity;
}

/**
 * gimp_channel_set_opacity:
 * @channel: The channel.
 * @opacity: The new channel opacity.
 *
 * Set the opacity of the specified channel.
 *
 * This procedure sets the specified channel's opacity.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_set_opacity (GimpChannel *channel,
                          gdouble      opacity)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel,
                                          G_TYPE_DOUBLE, opacity,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-set-opacity",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_get_color:
 * @channel: The channel.
 * @color: (out caller-allocates): The channel compositing color.
 *
 * Get the compositing color of the specified channel.
 *
 * This procedure returns the specified channel's compositing color.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_get_color (GimpChannel *channel,
                        GimpRGB     *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-get-color",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    GIMP_VALUES_GET_RGB (return_vals, 1, &*color);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_channel_set_color:
 * @channel: The channel.
 * @color: The new channel compositing color.
 *
 * Set the compositing color of the specified channel.
 *
 * This procedure sets the specified channel's compositing color.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_channel_set_color (GimpChannel   *channel,
                        const GimpRGB *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_CHANNEL, channel,
                                          GIMP_TYPE_RGB, color,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-channel-set-color",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
