/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ksimdock.h"
#include "ksimdock.moc"

#include <kiconloader.h>
#include <klocale.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kmainwindow.h>

#include <kpopupmenu.h>

KSim::Dock::Dock(QPopupMenu *pluginMenu,
   KMainWindow *parent, const char *name)
   : KSystemTray(parent, name)
{
  setPixmap(SmallIcon("ksim"));
  setAlignment(AlignCenter);

  contextMenu()->insertItem(SmallIcon("configure"), i18n("Configure KSim..."),
     this, SIGNAL(preferences()), 0, 0, 1);
  contextMenu()->insertItem(i18n("Plugins"), pluginMenu, 1, 2);
  contextMenu()->insertSeparator(3);
  contextMenu()->insertItem(SmallIcon("help"), i18n("Help"),
     parent->helpMenu(), 2, 4);
}

KSim::Dock::~Dock()
{
}
