#!/bin/sh
# A simulation of $(OARCH) from the Schily Makefile system
#
# @(#)oarch.sh  1.2 05/04/21 Copyr 2005 J. Schilling
#
###########################################################################
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; see the file COPYING.  If not, write to the Free Software
# Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
###########################################################################

MACHCMD="((mach || uname -p || true)		2> /dev/null)"
ARCHCMD="((arch || /usr/ucb/arch || true)	2> /dev/null)"

XP_ARCH=`eval ${MACHCMD} | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',-'`
XK_ARCH=`uname -m    | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',-'`
XM_ARCH=`eval ${ARCHCMD} | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',-'`

#echo XP_ARCH $XP_ARCH
#echo XK_ARCH $XK_ARCH
#echo XM_ARCH $XM_ARCH

P_ARCH="${XP_ARCH}"
K_ARCH="${XK_ARCH}"
M_ARCH="${XM_ARCH}"

if [ ."$XP_ARCH" = .unknown ]; then
	P_ARCH="${K_ARCH}"
fi
if [ ."$XP_ARCH" = . ]; then
	P_ARCH="${K_ARCH}"
fi

if [ ."${XM_ARCH}" = . ]; then
	M_ARCH="${K_ARCH}"
fi

OSNAME=`uname -s | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',-'`
OSREL=`uname -r | tr '[A-Z]' '[a-z]' | tr ', /\\()"' ',//////' | tr ',/' ',-'`

O_ARCH="$OSNAME"

case "$OSREL" in
	cygwin*) O_ARCH=cygwin32_nt;;
esac
if [ ."$OSNAME" = .bsd-os ]; then
	case "$OSREL" in
		3.*)	O_ARCH=bsd-os3;;
		4.*)	O_ARCH=bsd-os;;
	esac
fi
if [ ."$OSNAME" = .bsd-os ]; then
	case "$OSREL" in
		3.*)	O_ARCH=bsd-os3;;
		4.*)	O_ARCH=bsd-os;;
	esac
fi
if [ ."$OSNAME" = .dgux ]; then
	case "$OSREL" in
		r4.*)	O_ARCH=dgux4;;
		5.4r3*)	O_ARCH=dgux3;;
	esac
fi
if [ ."$OSNAME" = .irix64 ]; then
	O_ARCH=irix
fi
if [ ."$OSNAME" = .mac-os ]; then
	case "$OSREL" in
		9.*)	O_ARCH=mac-os9;;
		10.*)	O_ARCH=mac-os10;;
	esac
fi
case "$OSREL" in
	mingw*) O_ARCH= mingw32_nt;;
esac
if [ ."$OSNAME" = .newsos ]; then
	case "$OSREL" in
		5.*)	O_ARCH=newsos5;;
		6.*)	O_ARCH=newsos6;;
	esac
fi
if [ ."$OSNAME" = .openunix ]; then
	O_ARCH=unixware
fi
if [ ."$OSNAME" = .os-2 ]; then
	O_ARCH=os2
fi
if [ ."$OSNAME" = .sco_sv ]; then
	O_ARCH=openserver
fi
if [ ."$OSNAME" = .sunos ]; then
	case "$OSREL" in
		4.*)	O_ARCH=sunos4;;
		5.*)	O_ARCH=sunos5;;
	esac
fi
if [ ."$OSNAME" = .unix_sv ]; then
	O_ARCH=unixware
fi

C_ARCH=cc
PARCH="$P_ARCH"

OARCH="${PARCH}-${O_ARCH}-${C_ARCH}"

#echo
#echo P_ARCH $P_ARCH
#echo K_ARCH $K_ARCH
#echo M_ARCH $M_ARCH
#echo OSNAME $OSNAME
#echo OSREL  $OSREL
#echo OARCH  "$OARCH"

echo "$OARCH"
