import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import QtQuick.Timeline
import QtQuick.Studio.Components
import QtQuick.Studio.DesignEffects

Item {
    width: 1560
    height: 860

    Rectangle {
        id: background
        color: "#e6ebef"
        anchors.fill: parent

        Item {
            id: shade
            anchors.fill: parent

            Rectangle {
                id: rectangle
                color: "#e5e5e5"
                radius: 26
                anchors.fill: parent
            }
            Item {
                id: shadowButton
                width: 138
                height: 138
                anchors.verticalCenter: parent.verticalCenter
                anchors.horizontalCenter: parent.horizontalCenter

                EllipseItem {
                    id: buttonBack
                    x: 155
                    y: 112
                    anchors.fill: parent
                    antialiasing: true
                    fillColor: "#e4e4e4"
                    strokeColor: "#00ff0000"

                    DesignEffect {
                        id: designEffectUnder
                        x: 25
                        y: 25
                        layerBlurRadius: 0

                        effects: [
                            DesignDropShadow {
                                id: designInnerShadowUnder
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#2a0d2750"
                                showBehind: false
                                spread: 0
                            },
                            DesignDropShadow {
                                id: designInnerShadowUnder1
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#ffffff"
                                showBehind: false
                            },
                            DesignInnerShadow {
                                id: designInnerShadowUnder1232
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#290d2750"
                            },
                            DesignInnerShadow {
                                id: designInnerShadowUnder1565
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#a3ffffff"
                            }
                        ]
                    }
                }

                EllipseItem {
                    id: buttonTop
                    y: 112
                    width: 88
                    height: 88
                    anchors.verticalCenter: parent.verticalCenter
                    antialiasing: true
                    anchors.horizontalCenter: parent.horizontalCenter
                    strokeColor: "#00ff0000"
                    fillColor: "#e4e4e4"

                    DesignEffect {
                        id: designEffectUnder454
                        x: 25
                        y: 25
                        layerBlurRadius: 0

                        effects: [
                            DesignDropShadow {
                                id: designInnerShadowUnder655
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#300d2750"
                                showBehind: false
                            },
                            DesignDropShadow {
                                id: designInnerShadowUnder13434
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#ffffff"
                                showBehind: false
                            },
                            DesignInnerShadow {
                                id: designInnerShadowUnder1232787
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#290d2750"
                            },
                            DesignInnerShadow {
                                id: designInnerShadowUnder1565232
                                blur: 0
                                offsetX: 0
                                offsetY: 0
                                color: "#a3ffffff"
                            }
                        ]
                    }
                }
            }

            Item {
                id: circleGroup
                width: 500
                height: 500
                visible: false
                anchors.verticalCenter: parent.verticalCenter
                anchors.horizontalCenter: parent.horizontalCenter

                EllipseItem {
                    id: ellipse
                    width: 286
                    height: 286
                    anchors.verticalCenter: parent.verticalCenter
                    antialiasing: true
                    anchors.horizontalCenter: parent.horizontalCenter
                    fillColor: "#e5e5e5"
                    strokeColor: "#00ff0000"

                    DesignEffect {
                        id: de0
                        layerBlurRadius: 0

                        effects: [
                            DesignDropShadow {
                                id: ds00
                                color: "#ccffffff"
                                showBehind: false
                                blur: 10
                                spread: 0
                                offsetY: -6
                                offsetX: -6
                            },
                            DesignDropShadow {
                                id: ds11
                                color: "#53000000"
                                showBehind: false
                                blur: 10
                                spread: 0
                                offsetY: 6
                                offsetX: 6
                            }
                        ]
                    }
                }

                EllipseItem {
                    id: ellipse1
                    x: 262
                    y: 228
                    width: 222
                    height: 222
                    antialiasing: true
                    strokeColor: "#00ff0000"
                    fillColor: "#e5e5e5"
                    DesignEffect {
                        id: de2
                        layerBlurRadius: 0
                        effects: [
                            DesignDropShadow {
                                id: ds2
                                color: "#ccffffff"
                                showBehind: false
                                spread: 0
                                offsetY: 0
                                offsetX: 0
                                blur: 0
                            },
                            DesignDropShadow {
                                id: ds12
                                color: "#53000000"
                                showBehind: false
                                spread: 0
                                offsetY: 0
                                offsetX: 0
                                blur: 0
                            }
                        ]
                    }
                }

                EllipseItem {

                    id: ellipse2
                    x: 86
                    y: 113
                    width: 144
                    height: 144
                    antialiasing: true
                    strokeColor: "#00ff0000"
                    fillColor: "#e5e5e5"
                    DesignEffect {
                        id: de3
                        layerBlurRadius: 0
                        effects: [
                            DesignDropShadow {
                                id: ds3
                                color: "#ccffffff"
                                showBehind: false
                                spread: 0
                                offsetY: 0
                                offsetX: 0
                                blur: 0
                            },
                            DesignDropShadow {
                                id: ds13
                                color: "#53000000"
                                showBehind: false
                                spread: 0
                                offsetY: 0
                                offsetX: 0
                                blur: 0
                            }
                        ]
                    }
                }

                Text {
                    id: neuText
                    visible: true
                    color: "#e5e5e5"
                    text: qsTr("NEUMORPHISM")
                    anchors.verticalCenter: parent.verticalCenter
                    font.pixelSize: 128
                    renderType: Text.NativeRendering
                    font.hintingPreference: Font.PreferNoHinting
                    antialiasing: true
                    font.styleName: "Bold"
                    font.family: "Victor Mono"
                    anchors.horizontalCenter: parent.horizontalCenter

                    DesignEffect {
                        id: de111
                        visible: true
                        layerBlurRadius: 0
                        effects: [
                            DesignDropShadow {
                                id: ds211
                                color: "#41000000"
                                showBehind: false
                                spread: 0
                                offsetY: 2
                                offsetX: 2
                                blur: 4
                            },
                            DesignDropShadow {
                                id: ds221
                                color: "#fdfdfd"
                                showBehind: false
                                spread: 0
                                offsetY: -2
                                offsetX: -2
                                blur: 4
                            }
                        ]
                    }
                }
            }
        }
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                pingPong: false
                running: true
                loops: -1
                duration: 3000
                to: 6000
                from: 0
            }
        ]
        startFrame: 0
        endFrame: 6000
        enabled: true

        KeyframeGroup {
            target: designInnerShadowUnder
            property: "offsetX"
            Keyframe {
                value: 11
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 11
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder
            property: "blur"
            Keyframe {
                value: 20
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 20
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder
            property: "offsetY"
            Keyframe {
                value: 12
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 12
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1
            property: "offsetX"
            Keyframe {
                value: -13
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -13
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1
            property: "blur"
            Keyframe {
                value: 26
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 26
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1
            property: "offsetY"
            Keyframe {
                value: -14
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -14
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1232
            property: "offsetX"
            Keyframe {
                value: 5
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 5
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1232
            property: "blur"
            Keyframe {
                value: 22.4
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 22.4
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1232
            property: "offsetY"
            Keyframe {
                value: 4
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 4
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1565
            property: "offsetX"
            Keyframe {
                value: -8
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -8
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1565
            property: "blur"
            Keyframe {
                value: 9.6
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 9.6
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1565
            property: "offsetY"
            Keyframe {
                value: -8
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -8
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder655
            property: "offsetX"
            Keyframe {
                value: 6
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 6
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder655
            property: "blur"
            Keyframe {
                value: 9.5
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 9.5
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder655
            property: "offsetY"
            Keyframe {
                value: 5
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 5
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder13434
            property: "offsetX"
            Keyframe {
                value: -5
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -5
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder13434
            property: "blur"
            Keyframe {
                value: 14.3
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 14.3
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder13434
            property: "offsetY"
            Keyframe {
                value: -5
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -5
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1232787
            property: "offsetX"
            Keyframe {
                value: 4
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 4
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1232787
            property: "blur"
            Keyframe {
                value: 22.4
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 22.4
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1232787
            property: "offsetY"
            Keyframe {
                value: 4
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 4
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1565232
            property: "offsetX"
            Keyframe {
                value: -8
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -8
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1565232
            property: "blur"
            Keyframe {
                value: 9.5
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: 9.5
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: designInnerShadowUnder1565232
            property: "offsetY"
            Keyframe {
                value: -8
                easing.bezierCurve: [0.444, 0.00407, 0.554, 0.997, 1, 1]
                frame: 3907
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 2721
            }

            Keyframe {
                value: -8
                easing.bezierCurve: [0.25, 0.46, 0.555, 1.01, 1, 1]
                frame: 4916
            }

            Keyframe {
                value: 0
                frame: 5493
            }
        }

        KeyframeGroup {
            target: ds211
            property: "offsetX"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                easing.bezierCurve: [0.25, 0.46, 0.555, 1, 1, 1]
                frame: 1720
            }

            Keyframe {
                value: 0
                frame: 2190
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.448, 0.0065, 0.443, 1, 1, 1]
                frame: 797
            }
        }

        KeyframeGroup {
            target: ds211
            property: "offsetY"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                easing.bezierCurve: [0.25, 0.46, 0.555, 1, 1, 1]
                frame: 1720
            }

            Keyframe {
                value: 0
                frame: 2190
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.448, 0.0065, 0.443, 1, 1, 1]
                frame: 797
            }
        }

        KeyframeGroup {
            target: ds211
            property: "blur"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 8
                easing.bezierCurve: [0.25, 0.46, 0.555, 1, 1, 1]
                frame: 1720
            }

            Keyframe {
                value: 0
                frame: 2190
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.448, 0.0065, 0.443, 1, 1, 1]
                frame: 797
            }
        }

        KeyframeGroup {
            target: ds221
            property: "offsetX"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: -6
                easing.bezierCurve: [0.25, 0.46, 0.555, 1, 1, 1]
                frame: 1717
            }

            Keyframe {
                value: 0
                frame: 2190
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.448, 0.0065, 0.443, 1, 1, 1]
                frame: 794
            }
        }

        KeyframeGroup {
            target: ds221
            property: "offsetY"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: -6
                easing.bezierCurve: [0.25, 0.46, 0.555, 1, 1, 1]
                frame: 1717
            }

            Keyframe {
                value: 0
                frame: 2190
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.448, 0.0065, 0.443, 1, 1, 1]
                frame: 794
            }
        }

        KeyframeGroup {
            target: ds221
            property: "blur"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 8
                easing.bezierCurve: [0.25, 0.46, 0.555, 1, 1, 1]
                frame: 1717
            }

            Keyframe {
                value: 0
                frame: 2190
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.448, 0.0065, 0.443, 1, 1, 1]
                frame: 794
            }
        }

        KeyframeGroup {
            target: ds11
            property: "offsetX"
            Keyframe {
                value: 6
                frame: 260
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                frame: 1312
            }

            Keyframe {
                value: 0
                frame: 1574
            }
        }

        KeyframeGroup {
            target: ds11
            property: "offsetY"
            Keyframe {
                value: 6
                frame: 260
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                frame: 1312
            }

            Keyframe {
                value: 0
                frame: 1574
            }
        }

        KeyframeGroup {
            target: ds00
            property: "offsetX"
            Keyframe {
                value: -6
                easing.bezierCurve: [0.451, 0.00163, 0.558, 1, 1, 1]
                frame: 260
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: -6
                frame: 1312
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.25, 0.46, 0.556, 1, 1, 1]
                frame: 1574
            }
        }

        KeyframeGroup {
            target: ds00
            property: "offsetY"
            Keyframe {
                value: -6
                easing.bezierCurve: [0.451, 0.00163, 0.558, 1, 1, 1]
                frame: 260
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: -6
                frame: 1312
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.25, 0.46, 0.556, 1, 1, 1]
                frame: 1574
            }
        }

        KeyframeGroup {
            target: ds00
            property: "blur"
            Keyframe {
                value: 10
                easing.bezierCurve: [0.451, 0.00163, 0.558, 1, 1, 1]
                frame: 260
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 10
                frame: 1312
            }

            Keyframe {
                value: 0
                easing.bezierCurve: [0.25, 0.46, 0.556, 1, 1, 1]
                frame: 1574
            }
        }

        KeyframeGroup {
            target: ds11
            property: "blur"
            Keyframe {
                value: 10
                frame: 260
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 10
                frame: 1312
            }

            Keyframe {
                value: 0
                frame: 1574
            }
        }

        KeyframeGroup {
            target: ds2
            property: "blur"
            Keyframe {
                value: 10
                frame: 917
            }

            Keyframe {
                value: 0
                frame: 196
            }

            Keyframe {
                value: 0
                frame: 8
            }

            Keyframe {
                value: 10
                frame: 1340
            }

            Keyframe {
                value: 0
                frame: 1544
            }
        }

        KeyframeGroup {
            target: ds2
            property: "offsetX"
            Keyframe {
                value: -6
                frame: 917
            }

            Keyframe {
                value: 0
                frame: 196
            }

            Keyframe {
                value: 0
                frame: 8
            }

            Keyframe {
                value: -6
                frame: 1340
            }

            Keyframe {
                value: 0
                frame: 1544
            }
        }

        KeyframeGroup {
            target: ds2
            property: "offsetY"
            Keyframe {
                value: -6
                frame: 917
            }

            Keyframe {
                value: 0
                frame: 196
            }

            Keyframe {
                value: 0
                frame: 8
            }

            Keyframe {
                value: -6
                frame: 1340
            }

            Keyframe {
                value: 0
                frame: 1544
            }
        }

        KeyframeGroup {
            target: ds12
            property: "blur"
            Keyframe {
                value: 10
                frame: 909
            }

            Keyframe {
                value: 0
                frame: 187
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 10
                frame: 1446
            }

            Keyframe {
                value: 0
                frame: 1650
            }
        }

        KeyframeGroup {
            target: ds12
            property: "offsetX"
            Keyframe {
                value: 6
                frame: 909
            }

            Keyframe {
                value: 0
                frame: 187
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                frame: 1446
            }

            Keyframe {
                value: 0
                frame: 1650
            }
        }

        KeyframeGroup {
            target: ds12
            property: "offsetY"
            Keyframe {
                value: 6
                frame: 909
            }

            Keyframe {
                value: 0
                frame: 187
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                frame: 1446
            }

            Keyframe {
                value: 0
                frame: 1650
            }
        }

        KeyframeGroup {
            target: ds3
            property: "blur"
            Keyframe {
                value: 10
                frame: 400
            }

            Keyframe {
                value: 0
                frame: 101
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 10
                frame: 1535
            }

            Keyframe {
                value: 0
                frame: 1709
            }
        }

        KeyframeGroup {
            target: ds3
            property: "offsetX"
            Keyframe {
                value: -6
                frame: 400
            }

            Keyframe {
                value: 0
                frame: 101
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: -6
                frame: 1535
            }

            Keyframe {
                value: 0
                frame: 1709
            }
        }

        KeyframeGroup {
            target: ds3
            property: "offsetY"
            Keyframe {
                value: -6
                frame: 400
            }

            Keyframe {
                value: 0
                frame: 101
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: -6
                frame: 1535
            }

            Keyframe {
                value: 0
                frame: 1709
            }
        }

        KeyframeGroup {
            target: ds13
            property: "blur"
            Keyframe {
                value: 10
                frame: 467
            }

            Keyframe {
                value: 0
                frame: 67
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 10
                frame: 1538
            }

            Keyframe {
                value: 0
                frame: 1712
            }
        }

        KeyframeGroup {
            target: ds13
            property: "offsetX"
            Keyframe {
                value: 6
                frame: 467
            }

            Keyframe {
                value: 0
                frame: 67
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                frame: 1538
            }

            Keyframe {
                value: 0
                frame: 1712
            }
        }

        KeyframeGroup {
            target: ds13
            property: "offsetY"
            Keyframe {
                value: 6
                frame: 467
            }

            Keyframe {
                value: 0
                frame: 67
            }

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 6
                frame: 1538
            }

            Keyframe {
                value: 0
                frame: 1712
            }
        }

        KeyframeGroup {
            target: circleGroup
            property: "visible"
            Keyframe {
                value: true
                frame: 2741
            }

            Keyframe {
                value: false
                frame: 2757
            }

            Keyframe {
                value: true
                frame: 0
            }
        }

        KeyframeGroup {
            target: neuText
            property: "visible"
            Keyframe {
                value: true
                frame: 709
            }

            Keyframe {
                value: false
                frame: 0
            }

            Keyframe {
                value: true
                frame: 710
            }
        }
    }
}

/*##^##
Designer {
    D{i:0}D{i:37;property:"offsetX";target:"designInnerShadowUnder"}D{i:38;property:"offsetX";target:"designInnerShadowUnder"}
D{i:39;property:"offsetX";target:"designInnerShadowUnder"}D{i:43;property:"blur";target:"designInnerShadowUnder"}
D{i:44;property:"blur";target:"designInnerShadowUnder"}D{i:45;property:"blur";target:"designInnerShadowUnder"}
D{i:49;property:"offsetY";target:"designInnerShadowUnder"}D{i:50;property:"offsetY";target:"designInnerShadowUnder"}
D{i:51;property:"offsetY";target:"designInnerShadowUnder"}D{i:55;property:"offsetX";target:"designInnerShadowUnder1"}
D{i:56;property:"offsetX";target:"designInnerShadowUnder1"}D{i:57;property:"offsetX";target:"designInnerShadowUnder1"}
D{i:61;property:"blur";target:"designInnerShadowUnder1"}D{i:62;property:"blur";target:"designInnerShadowUnder1"}
D{i:63;property:"blur";target:"designInnerShadowUnder1"}D{i:67;property:"offsetY";target:"designInnerShadowUnder1"}
D{i:68;property:"offsetY";target:"designInnerShadowUnder1"}D{i:69;property:"offsetY";target:"designInnerShadowUnder1"}
D{i:73;property:"offsetX";target:"designInnerShadowUnder1232"}D{i:74;property:"offsetX";target:"designInnerShadowUnder1232"}
D{i:75;property:"offsetX";target:"designInnerShadowUnder1232"}D{i:79;property:"blur";target:"designInnerShadowUnder1232"}
D{i:80;property:"blur";target:"designInnerShadowUnder1232"}D{i:81;property:"blur";target:"designInnerShadowUnder1232"}
D{i:85;property:"offsetY";target:"designInnerShadowUnder1232"}D{i:86;property:"offsetY";target:"designInnerShadowUnder1232"}
D{i:87;property:"offsetY";target:"designInnerShadowUnder1232"}D{i:91;property:"offsetX";target:"designInnerShadowUnder1565"}
D{i:92;property:"offsetX";target:"designInnerShadowUnder1565"}D{i:93;property:"offsetX";target:"designInnerShadowUnder1565"}
D{i:97;property:"blur";target:"designInnerShadowUnder1565"}D{i:98;property:"blur";target:"designInnerShadowUnder1565"}
D{i:99;property:"blur";target:"designInnerShadowUnder1565"}D{i:103;property:"offsetY";target:"designInnerShadowUnder1565"}
D{i:104;property:"offsetY";target:"designInnerShadowUnder1565"}D{i:105;property:"offsetY";target:"designInnerShadowUnder1565"}
D{i:109;property:"offsetX";target:"designInnerShadowUnder655"}D{i:110;property:"offsetX";target:"designInnerShadowUnder655"}
D{i:111;property:"offsetX";target:"designInnerShadowUnder655"}D{i:115;property:"blur";target:"designInnerShadowUnder655"}
D{i:116;property:"blur";target:"designInnerShadowUnder655"}D{i:117;property:"blur";target:"designInnerShadowUnder655"}
D{i:121;property:"offsetY";target:"designInnerShadowUnder655"}D{i:122;property:"offsetY";target:"designInnerShadowUnder655"}
D{i:123;property:"offsetY";target:"designInnerShadowUnder655"}D{i:127;property:"offsetX";target:"designInnerShadowUnder13434"}
D{i:128;property:"offsetX";target:"designInnerShadowUnder13434"}D{i:129;property:"offsetX";target:"designInnerShadowUnder13434"}
D{i:133;property:"blur";target:"designInnerShadowUnder13434"}D{i:134;property:"blur";target:"designInnerShadowUnder13434"}
D{i:135;property:"blur";target:"designInnerShadowUnder13434"}D{i:139;property:"offsetY";target:"designInnerShadowUnder13434"}
D{i:140;property:"offsetY";target:"designInnerShadowUnder13434"}D{i:141;property:"offsetY";target:"designInnerShadowUnder13434"}
D{i:145;property:"offsetX";target:"designInnerShadowUnder1232787"}D{i:146;property:"offsetX";target:"designInnerShadowUnder1232787"}
D{i:147;property:"offsetX";target:"designInnerShadowUnder1232787"}D{i:151;property:"blur";target:"designInnerShadowUnder1232787"}
D{i:152;property:"blur";target:"designInnerShadowUnder1232787"}D{i:153;property:"blur";target:"designInnerShadowUnder1232787"}
D{i:157;property:"offsetY";target:"designInnerShadowUnder1232787"}D{i:158;property:"offsetY";target:"designInnerShadowUnder1232787"}
D{i:159;property:"offsetY";target:"designInnerShadowUnder1232787"}D{i:163;property:"offsetX";target:"designInnerShadowUnder1565232"}
D{i:164;property:"offsetX";target:"designInnerShadowUnder1565232"}D{i:165;property:"offsetX";target:"designInnerShadowUnder1565232"}
D{i:169;property:"blur";target:"designInnerShadowUnder1565232"}D{i:170;property:"blur";target:"designInnerShadowUnder1565232"}
D{i:171;property:"blur";target:"designInnerShadowUnder1565232"}D{i:175;property:"offsetY";target:"designInnerShadowUnder1565232"}
D{i:176;property:"offsetY";target:"designInnerShadowUnder1565232"}D{i:177;property:"offsetY";target:"designInnerShadowUnder1565232"}
D{i:181;property:"offsetX";target:"ds211"}D{i:186;property:"offsetY";target:"ds211"}
D{i:191;property:"blur";target:"ds211"}D{i:196;property:"offsetX";target:"ds221"}
D{i:201;property:"offsetY";target:"ds221"}D{i:206;property:"blur";target:"ds221"}
D{i:211;property:"offsetX";target:"ds11"}D{i:212;property:"offsetX";target:"ds11"}
D{i:216;property:"offsetY";target:"ds11"}D{i:217;property:"offsetY";target:"ds11"}
D{i:221;property:"offsetX";target:"ds00"}D{i:222;property:"offsetX";target:"ds00"}
D{i:226;property:"offsetY";target:"ds00"}D{i:227;property:"offsetY";target:"ds00"}
D{i:231;property:"blur";target:"ds00"}D{i:232;property:"blur";target:"ds00"}D{i:236;property:"blur";target:"ds11"}
D{i:237;property:"blur";target:"ds11"}
}
##^##*/

