

/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/
import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts
import DesignEffectsDemo

Item {
    id: root
    width: 1560
    height: 860

    Rectangle {
        id: rectangle
        color: "#e5eaee"
        anchors.fill: parent

        Image {
            id: referenceControls
            x: 170
            y: 136
            source: "../images/referenceControls.png"
            fillMode: Image.PreserveAspectFit
        }
    }

    ColumnLayout {
        id: column
        x: 925
        y: 233
        spacing: 30

        RowLayout {
            id: row
            spacing: 30

            SearchBar {
                id: searchBar
                withIcon: false
            }

            SearchButton {
                id: searchButton
            }
        }

        RowLayout {
            id: row1
            spacing: 30
            SearchBar {
                id: searchBar1
                withIcon: false
                searchBarRadius: 15
            }

            SearchButton {
                id: searchButton1
                rectangleRadius: 15
            }
        }

        SearchBar {
            id: searchBar2
            Layout.fillWidth: true
        }

        SearchBar {
            id: searchBar3
            searchBarRadius: 15
            Layout.fillWidth: true
        }
    }

    Text {
        id: dsLabel
        x: 882
        y: 736
        width: 514
        height: 58
        text: qsTr("Design Studio Implementation")
        font.pixelSize: 28
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.family: "Victor Mono"
    }

    Text {
        id: dsLabel1
        x: 144
        y: 736
        width: 514
        height: 58
        text: qsTr("Figma Reference Image")
        font.pixelSize: 28
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        font.family: "Victor Mono"
    }
}
