import QtQuick
import QtQuick.Controls
import DesignEffectsDemo

Item {
    id: root
    property alias mainBackground: variables.mainBackgroundCurrent
    property alias mainHighlight1: variables.mainHighlight1Current
    property alias mainHighlight2: variables.mainHighlight2Current
    property alias angleIndicatorDotHigh: variables.angleIndicatorDotHighCurrent
    property alias angleIndicatorDotTone: variables.angleIndicatorDotToneCurrent
    property alias highButton1: variables.highButton1Current
    property alias highButton2: variables.highButton2Current
    property alias midButton1: variables.midButton1Current
    property alias midButton2: variables.midButton2Current
    property alias lowButton1: variables.lowButton1Current
    property alias lowButton2: variables.lowButton2Current
    property alias highButtonText: variables.highButtonTextCurrent
    property alias midButtonText: variables.midButtonTextCurrent
    property alias lowButtonText: variables.lowButtonTextCurrent
    property alias themeString: variables.currentTheme
    property alias surfaceText: variables.surfaceTextCurrent
    property alias acronym: variables.acronymCurrent

    property alias dark: variables.dark

    QtObject {
    id: variables

        property bool dark: false

        //colors
        //dark

        //main panel background
        property color mainBackgroundDark: "#282828"

        //control colors
        property color mainHighlight1Dark: "#770bb9"
        property color mainHighlight2Dark: "#770bb9"
        property color angleIndicatorDotHighDark: "#979595"
        property color angleIndicatorDotToneDark: "#952FD3"
        property color highButton1Dark: "#858585"
        property color highButton2Dark: "#858585"
        property color midButton1Dark: "#5F5D5D"
        property color midButton2Dark: "#5C5A5B"
        property color lowButton1Dark: "#2C2C2C"
        property color lowButton2Dark: "#282828"

        //text colors
        property color highButtonTextDark: "#BABABA"
        property color midButtonTextDark: "#BABABA"
        property color lowButtonTextDark: "#D7D6D6"
        property color acronymDark: "#8E8E8E"
        property color surfaceTextDark: "#525151"


        //light
        property color mainBackgroundLight: "#C3C1C0"
        property color mainHighlight1Light: "#fb5020"
        property color mainHighlight2Light: "#fb5020"
        property color angleIndicatorDotHighLight: "#F8F8F8"
        property color angleIndicatorDotToneLight: "#F9774A"

        property color highButton1Light: "#E9E5E2"
        property color highButton2Light: "#E5E5E5"
        property color midButton1Light: "#C1BDBC"
        property color midButton2Light: "#C0BCBB"
        property color lowButton1Light: "#545454"
        property color lowButton2Light: "#484848"

        property color highButtonTextLight: "#505050"
        property color midButtonTextLight: "#505050"
        property color lowButtonTextLight: "#D7D6D6"
        property color acronymLight: "#4D4D4D"
        property color surfaceTextLight: "#8E8E8E"

        //current
        property color mainBackgroundCurrent: variables.dark ? mainBackgroundDark : mainBackgroundLight
        property color mainHighlight1Current: variables.dark ? mainHighlight1Dark : mainHighlight1Light
        property color mainHighlight2Current: variables.dark ? mainHighlight2Dark : mainHighlight2Light
        property color angleIndicatorDotHighCurrent: variables.dark ? angleIndicatorDotHighDark : angleIndicatorDotHighLight
        property color angleIndicatorDotToneCurrent: variables.dark ? angleIndicatorDotToneDark : angleIndicatorDotToneLight
        property color highButton1Current: variables.dark ? highButton1Dark : highButton1Light
        property color highButton2Current: variables.dark ? highButton2Dark : highButton2Light
        property color midButton1Current: variables.dark ? midButton1Dark : midButton1Light
        property color midButton2Current: variables.dark ? midButton2Dark : midButton2Light
        property color lowButton1Current: variables.dark ? lowButton1Dark : lowButton1Light
        property color lowButton2Current: variables.dark ? lowButton2Dark : lowButton2Light
        property color highButtonTextCurrent: variables.dark ? highButtonTextDark : highButtonTextLight
        property color midButtonTextCurrent: variables.dark ? midButtonTextDark : midButtonTextLight
        property color lowButtonTextCurrent: variables.dark ? lowButtonTextDark : lowButtonTextLight
        property color acronymCurrent: variables.dark ? acronymDark : acronymLight
        property color surfaceTextCurrent: variables.dark ? surfaceTextDark : surfaceTextLight


        //strings

        //current theme
        property string lightTheme: "LIGHT"
        property string darkTheme: "DARK"
        property string currentTheme: variables.dark ? darkTheme : lightTheme

    }
}
