import QtQuick
import QtQuick.Controls
import QtQuick.Studio.Components 1.0
import QtQuick.Shapes 1.0
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: neuDrop
    width: 138
    height: 138
    color: "transparent"

    ArcItem {
        id: dropBottom
        width: 138
        height: 138
        anchors.verticalCenter: parent.verticalCenter
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#e6ebef"
        end: 450.00001
        DesignEffect {
            id: dropBottom_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: dropBottom_DesignDropShadow_0
                    visible: true
                    color: "#290d2750"
                    spread: 0
                    offsetY: 12
                    offsetX: 11
                    blur: 20
                },
                DesignDropShadow {
                    id: dropBottom_DesignDropShadow_1
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: -14
                    offsetX: -13
                    blur: 26
                },
                DesignInnerShadow {
                    id: dropBottom_DesignInnerShadow_2
                    visible: true
                    color: "#290d2750"
                    spread: 0
                    offsetY: 4
                    offsetX: 5
                    blur: 22.4
                },
                DesignInnerShadow {
                    id: dropBottom_DesignInnerShadow_3
                    visible: true
                    color: "#a3ffffff"
                    spread: 0
                    offsetY: -8
                    offsetX: -8
                    blur: 9.6
                }
            ]
        }
        begin: 90
        arcWidth: 69
        antialiasing: true
        anchors.horizontalCenter: parent.horizontalCenter
    }

    ArcItem {
        id: dropTop
        width: 88
        height: 88
        anchors.verticalCenter: parent.verticalCenter
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#e6ebef"
        end: 450.00001
        DesignEffect {
            id: dropTop_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: dropTop_DesignDropShadow_0
                    visible: true
                    color: "#290d2750"
                    spread: 0
                    offsetY: 5
                    offsetX: 6
                    blur: 9.5
                },
                DesignDropShadow {
                    id: dropTop_DesignDropShadow_1
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: -5
                    offsetX: -5
                    blur: 14.3
                },
                DesignInnerShadow {
                    id: dropTop_DesignInnerShadow_2
                    visible: true
                    color: "#290d2750"
                    spread: 0
                    offsetY: 4
                    offsetX: 4
                    blur: 22.4
                },
                DesignInnerShadow {
                    id: dropTop_DesignInnerShadow_3
                    visible: true
                    color: "#a3ffffff"
                    spread: 0
                    offsetY: -8
                    offsetX: -8
                    blur: 9.5
                }
            ]
        }
        begin: 90
        arcWidth: 44
        antialiasing: true
        anchors.horizontalCenter: parent.horizontalCenter
    }
}

/*##^##
Designer {
    D{i:0;uuid:"b38cfef9-c7fd-5595-a079-5b6a3faf7c73"}D{i:1;uuid:"ba81c503-e9de-50dd-9912-3dcb01382985"}
D{i:2;uuid:"ba81c503-e9de-50dd-9912-3dcb01382985_DesignEffect"}D{i:3;uuid:"ba81c503-e9de-50dd-9912-3dcb01382985_DesignDropShadow_0"}
D{i:4;uuid:"ba81c503-e9de-50dd-9912-3dcb01382985_DesignDropShadow_1"}D{i:5;uuid:"ba81c503-e9de-50dd-9912-3dcb01382985_DesignInnerShadow_2"}
D{i:6;uuid:"ba81c503-e9de-50dd-9912-3dcb01382985_DesignInnerShadow_3"}D{i:7;uuid:"93503d37-3218-567f-a135-87266850b5a6"}
D{i:8;uuid:"93503d37-3218-567f-a135-87266850b5a6_DesignEffect"}D{i:9;uuid:"93503d37-3218-567f-a135-87266850b5a6_DesignDropShadow_0"}
D{i:10;uuid:"93503d37-3218-567f-a135-87266850b5a6_DesignDropShadow_1"}D{i:11;uuid:"93503d37-3218-567f-a135-87266850b5a6_DesignInnerShadow_2"}
D{i:12;uuid:"93503d37-3218-567f-a135-87266850b5a6_DesignInnerShadow_3"}
}
##^##*/

