import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Shapes 1.0

Rectangle {
    id: effectSlider
    width: 90
    height: 220
    color: "transparent"

    Rectangle {
        id: groove
        color: "#1d1712"
        radius: 8
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 40
        anchors.rightMargin: 37
        DesignEffect {
            id: groove_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: groove_DesignDropShadow_0
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 1
                    offsetX: 1
                    blur: 5
                },
                DesignInnerShadow {
                    id: groove_DesignInnerShadow_1
                    visible: true
                    color: "#a3ffffff"
                    spread: 0
                    offsetY: 0
                    offsetX: -1
                    blur: 1
                }
            ]
        }
    }

    SvgPathItem {
        id: markerL_Stroke_
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.rightMargin: 60
        anchors.topMargin: 110
        anchors.bottomMargin: 108
        strokeWidth: 2
        strokeStyle: 1
        strokeColor: "transparent"
        path: "M 29.834253311157227 2 L 0 2 L 0 0 L 29.834253311157227 0 L 29.834253311157227 2 Z"
        joinStyle: 0
        fillColor: "#848893"
        antialiasing: true
    }

    SvgPathItem {
        id: markerR_Stroke_
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 60
        anchors.rightMargin: 0
        anchors.topMargin: 110
        anchors.bottomMargin: 108
        strokeWidth: 2
        strokeStyle: 1
        strokeColor: "transparent"
        path: "M 29.834253311157227 2 L 0 2 L 0 0 L 29.834253311157227 0 L 29.834253311157227 2 Z"
        joinStyle: 0
        fillColor: "#848893"
        antialiasing: true
    }

    ArcItem {
        id: handle
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 22
        anchors.rightMargin: 20
        anchors.topMargin: 86
        anchors.bottomMargin: 85
        strokeWidth: 0
        strokeStyle: 0
        strokeColor: "transparent"
        outlineArc: true
        fillColor: "#7a7977"
        end: 450.00001
        DesignEffect {
            id: handle_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: handle_DesignDropShadow_0
                    visible: true
                    color: "#40000000"
                    showBehind: false
                    spread: 0
                    offsetY: 3
                    offsetX: 2
                    blur: 3
                },
                DesignDropShadow {
                    id: handle_DesignDropShadow_1
                    visible: true
                    color: "#85000000"
                    showBehind: false
                    spread: 0
                    offsetY: 21
                    offsetX: 13
                    blur: 17
                },
                DesignInnerShadow {
                    id: handle_DesignInnerShadow_2
                    visible: true
                    color: "#40000000"
                    spread: 0
                    offsetY: -5
                    offsetX: 0
                    blur: 4
                },
                DesignInnerShadow {
                    id: handle_DesignInnerShadow_3
                    visible: true
                    color: "#61ffffff"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 2
                },
                DesignInnerShadow {
                    id: handle_DesignInnerShadow_4
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 1
                    blur: 2
                }
            ]
        }
        begin: 90
        arcWidth: 24
        antialiasing: true
    }
}

/*##^##
Designer {
    D{i:0;uuid:"ca981f09-b400-5248-84c4-a981e6201ae7"}D{i:1;uuid:"9bd10757-5046-58d8-b73b-10877af4a871"}
D{i:2;uuid:"9bd10757-5046-58d8-b73b-10877af4a871_DesignEffect"}D{i:3;uuid:"9bd10757-5046-58d8-b73b-10877af4a871_DesignDropShadow_0"}
D{i:4;uuid:"9bd10757-5046-58d8-b73b-10877af4a871_DesignInnerShadow_1"}D{i:5;uuid:"5fcd310b-e865-5c25-aefc-ab6f6dc8f312"}
D{i:6;uuid:"4b1c4663-f5ad-56f3-aaa8-1cf28b3100b8"}D{i:7;uuid:"a231058d-e905-5c7c-9bd4-3798ab5a83f3"}
D{i:8;uuid:"a231058d-e905-5c7c-9bd4-3798ab5a83f3_DesignEffect"}D{i:9;uuid:"a231058d-e905-5c7c-9bd4-3798ab5a83f3_DesignDropShadow_0"}
D{i:10;uuid:"a231058d-e905-5c7c-9bd4-3798ab5a83f3_DesignDropShadow_1"}D{i:11;uuid:"a231058d-e905-5c7c-9bd4-3798ab5a83f3_DesignInnerShadow_2"}
D{i:12;uuid:"a231058d-e905-5c7c-9bd4-3798ab5a83f3_DesignInnerShadow_3"}D{i:13;uuid:"a231058d-e905-5c7c-9bd4-3798ab5a83f3_DesignInnerShadow_4"}
}
##^##*/

