/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.mc;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.sqlite.SQLiteConfig;
import org.sqlite.mc.CipherAlgorithm;
import org.sqlite.mc.HmacAlgorithm;
import org.sqlite.mc.HmacPgno;
import org.sqlite.mc.KdfAlgorithm;

public class SQLiteMCConfig
extends SQLiteConfig {
    private static final SQLiteConfig.Pragma[] CIPHER_PRAGMA_ORDER = new SQLiteConfig.Pragma[]{SQLiteConfig.Pragma.CIPHER, SQLiteConfig.Pragma.LEGACY, SQLiteConfig.Pragma.HMAC_CHECK, SQLiteConfig.Pragma.MC_LEGACY_WAL, SQLiteConfig.Pragma.LEGACY_PAGE_SIZE, SQLiteConfig.Pragma.KDF_ITER, SQLiteConfig.Pragma.FAST_KDF_ITER, SQLiteConfig.Pragma.HMAC_USE, SQLiteConfig.Pragma.HMAC_PGNO, SQLiteConfig.Pragma.HMAC_SALT_MASK, SQLiteConfig.Pragma.KDF_ALGORITHM, SQLiteConfig.Pragma.HMAC_ALGORITHM, SQLiteConfig.Pragma.PLAINTEXT_HEADER_SIZE};

    public SQLiteMCConfig() {
    }

    public SQLiteMCConfig(Properties existingProperties) {
        super(existingProperties);
    }

    @Override
    public Properties toProperties() {
        Properties props = super.toProperties();
        props.put("config_class_name", this.getClass().getName());
        return props;
    }

    @Override
    protected void setupConnection(Connection conn, HashSet<String> pragmaParams, Properties pragmaTable) throws SQLException {
        pragmaParams.remove(SQLiteConfig.Pragma.KEY.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.REKEY.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.CIPHER.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.HMAC_CHECK.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.MC_LEGACY_WAL.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.LEGACY.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.LEGACY_PAGE_SIZE.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.KDF_ITER.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.FAST_KDF_ITER.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.HMAC_USE.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.HMAC_PGNO.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.HMAC_SALT_MASK.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.KDF_ALGORITHM.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.HMAC_ALGORITHM.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.PLAINTEXT_HEADER_SIZE.pragmaName);
        pragmaParams.remove(SQLiteConfig.Pragma.MC_USE_SQL_INTERFACE.pragmaName);
        try (Statement statement = conn.createStatement();){
            boolean useSQLInterface = Boolean.parseBoolean(pragmaTable.getProperty(SQLiteConfig.Pragma.MC_USE_SQL_INTERFACE.getPragmaName(), "false"));
            String cipherProperty = pragmaTable.getProperty(SQLiteConfig.Pragma.CIPHER.getPragmaName(), null);
            for (SQLiteConfig.Pragma pragma : CIPHER_PRAGMA_ORDER) {
                String sql;
                String property = pragmaTable.getProperty(pragma.getPragmaName(), null);
                if (property == null) continue;
                if (!useSQLInterface) {
                    statement.execute(String.format("PRAGMA %s = %s", pragma.getPragmaName(), property));
                    continue;
                }
                if (pragma.equals((Object)SQLiteConfig.Pragma.CIPHER)) {
                    sql = String.format("SELECT sqlite3mc_config('default:%s', '%s');", pragma.getPragmaName(), cipherProperty);
                    statement.execute(sql);
                    continue;
                }
                sql = String.format("SELECT sqlite3mc_config('%s', 'default:%s', %s);", cipherProperty, pragma.getPragmaName(), property);
                statement.execute(sql);
            }
        }
        if (pragmaTable.containsKey(SQLiteConfig.Pragma.PASSWORD.pragmaName) || pragmaTable.containsKey(SQLiteConfig.Pragma.KEY.pragmaName)) {
            this.applyPassword(conn, pragmaTable.getProperty(SQLiteConfig.Pragma.KEY.pragmaName));
        }
        this.applyRemainingPragmas(conn, pragmaParams);
    }

    public static class Builder {
        private Properties existingProperties = new Properties();

        private void setPragma(SQLiteConfig.Pragma pragma, String value) {
            this.existingProperties.put(pragma.pragmaName, value);
        }

        protected boolean isValid(Integer value, int min, int max) {
            return value >= min && value <= max;
        }

        protected String toHexString(byte[] key) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(key);
            StringBuilder hexString = new StringBuilder();
            while (byteBuffer.hasRemaining()) {
                hexString.append(String.format("%02x", byteBuffer.get()));
            }
            return hexString.toString();
        }

        public Builder fromExistingProperties(Properties props) {
            this.existingProperties.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder setPlaintextHeaderSize(int value) {
            this.setPragma(SQLiteConfig.Pragma.PLAINTEXT_HEADER_SIZE, String.valueOf(value));
            return this;
        }

        public Builder setLegacy(int value) {
            this.setPragma(SQLiteConfig.Pragma.LEGACY, String.valueOf(value));
            return this;
        }

        public Builder setKdfIter(int value) {
            this.setPragma(SQLiteConfig.Pragma.KDF_ITER, String.valueOf(value));
            return this;
        }

        public Builder setKdfAlgorithm(KdfAlgorithm value) {
            this.setPragma(SQLiteConfig.Pragma.KDF_ALGORITHM, String.valueOf(value.ordinal()));
            return this;
        }

        public Builder setHmacUse(boolean value) {
            this.setPragma(SQLiteConfig.Pragma.HMAC_USE, String.valueOf(value ? 1 : 0));
            return this;
        }

        public Builder setHmacSaltMask(int value) {
            this.setPragma(SQLiteConfig.Pragma.HMAC_SALT_MASK, String.valueOf(value));
            return this;
        }

        public Builder setHmacPgno(HmacPgno value) {
            this.setPragma(SQLiteConfig.Pragma.HMAC_PGNO, String.valueOf(value.ordinal()));
            return this;
        }

        public Builder setHmacAlgorithm(HmacAlgorithm value) {
            this.setPragma(SQLiteConfig.Pragma.HMAC_ALGORITHM, String.valueOf(value.ordinal()));
            return this;
        }

        public Builder setFastKdfIter(int value) {
            this.setPragma(SQLiteConfig.Pragma.FAST_KDF_ITER, String.valueOf(value));
            return this;
        }

        public Builder setLegacyPageSize(int value) {
            if (value < 0 || value > 65536 || (value & value - 1) != 0) {
                throw new IllegalArgumentException("legacy_page_size must be a power of 2 between 0 and 65536");
            }
            this.setPragma(SQLiteConfig.Pragma.LEGACY_PAGE_SIZE, String.valueOf(value));
            return this;
        }

        public Builder setCipher(CipherAlgorithm cipherAlgorithm) {
            this.setPragma(SQLiteConfig.Pragma.CIPHER, cipherAlgorithm.getValue());
            return this;
        }

        public Builder useSQLInterface() {
            return this.useSQLInterface(true);
        }

        public Builder useSQLInterface(boolean sqlInterface) {
            this.setPragma(SQLiteConfig.Pragma.MC_USE_SQL_INTERFACE, sqlInterface ? "true" : "false");
            return this;
        }

        public Builder withKey(String key) {
            this.setPragma(SQLiteConfig.Pragma.HEXKEY_MODE, String.valueOf(SQLiteConfig.HexKeyMode.NONE));
            this.setPragma(SQLiteConfig.Pragma.KEY, key);
            this.setPragma(SQLiteConfig.Pragma.PASSWORD, key);
            return this;
        }

        public Builder withHexKey(byte[] key) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(key);
            StringBuilder hexString = new StringBuilder();
            while (byteBuffer.hasRemaining()) {
                hexString.append(String.format("%02X", byteBuffer.get()));
            }
            return this.withHexKey(hexString.toString());
        }

        public Builder withHexKey(String hexkey) {
            this.withKey(hexkey);
            this.setPragma(SQLiteConfig.Pragma.HEXKEY_MODE, String.valueOf(SQLiteConfig.HexKeyMode.SSE));
            return this;
        }

        @Deprecated
        public SQLiteMCConfig toSQLiteMCConfig() {
            return this.build();
        }

        public SQLiteMCConfig build() {
            return new SQLiteMCConfig(this.existingProperties);
        }
    }
}

