/*
 * Decompiled with CFR 0.152.
 */
package esecurity.trustloader;

import esecurity.trustloader.SQLLITEURLStreamHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.sqlite.SQLiteConfig;

public class SqlLiteClassLoader
extends ClassLoader {
    private ClassLoader parent;
    private String db;
    private String pwd;
    Connection objConn = null;

    public SqlLiteClassLoader(String db, String key, String pwd) throws ClassNotFoundException, SQLException {
        this(db, key, pwd, null);
    }

    public SqlLiteClassLoader(String db, String key, String pwd, ClassLoader parent) throws ClassNotFoundException, SQLException {
        super(parent);
        this.db = db;
        this.pwd = pwd;
        SQLiteConfig config = new SQLiteConfig();
        config.setReadOnly(true);
        config.setSharedCache(true);
        config.setCacheSize(10000);
        String driver = "org.sqlite.JDBC";
        String url = "jdbc:sqlite:file:" + db;
        Class.forName(driver);
        this.objConn = DriverManager.getConnection(url + "?cipher=aes128cbc&kdf_iter=1&key=" + key, "sa", pwd);
        config.apply(this.objConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ResultSet res = null;
        try {
            String resourceName = name.replace(".", "/") + ".class";
            res = this.objConn.prepareStatement("select blob from class where name  ='" + resourceName + "'").executeQuery();
            if (res.next()) {
                byte[] cls = SqlLiteClassLoader.unCompress(res.getBytes(1));
                Class<?> clazz = this.defineClass(name, cls, 0, cls.length);
                return clazz;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Enumeration<URL> findResources(String name) {
        ArrayList<URL> resource = new ArrayList<URL>();
        ResultSet res = null;
        try {
            res = this.objConn.prepareStatement("select name from class where name  like'" + name + "%'").executeQuery();
            while (res.next()) {
                URL url = new URL("sqllite", "", 0, res.getString("name"), new SQLLITEURLStreamHandler(this.objConn));
                resource.add(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                res.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return Collections.enumeration(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL findResource(String name) {
        ResultSet res = null;
        try {
            res = this.objConn.prepareStatement("select name from class where name  ='" + name + "'").executeQuery();
            if (res.next()) {
                URL url;
                URL uRL = url = new URL("sqllite", "", 0, res.getString("name"), new SQLLITEURLStreamHandler(this.objConn));
                return uRL;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                res.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] compress(byte[] in) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(os);
        gzos.write(in);
        gzos.close();
        return os.toByteArray();
    }

    public static byte[] unCompress(byte[] in) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int len = -1;
        byte[] buffer = new byte[1024];
        ByteArrayInputStream is = new ByteArrayInputStream(in);
        GZIPInputStream gzin = new GZIPInputStream(is);
        while ((len = gzin.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        os.close();
        gzin.close();
        return os.toByteArray();
    }
}

