/**** AUTO GENERATED ****/

/*****************************************************************************

Copyright (c) 2004 by Nanoradio AB  

This software is copyrighted by and is the sole property of Nanoradio AB.
All rights, title, ownership, or other interests in the
software remain the property of Nanoradio AB.  This software may
only be used in accordance with the corresponding license agreement.  Any
unauthorized use, duplication, transmission, distribution, or disclosure of
this software is expressly forbidden.

This Copyright notice may not be removed or modified without prior written
consent of Nanoradio AB.

Nanoradio AB reserves the right to modify this software without
notice.
 
Nanoradio AB
Torshamnsgatan 39                       info@nanoradio.se
164 40 Kista                            http://www.nanoradio.se
SWEDEN

Module Description :
==================
This module is autogenerated and implements fuctions to pack and unpack HIC
frames.

*****************************************************************************/
#include "driverenv.h"
#include "hicWrapper.h"
#include <stddef.h> // for offsetof(...)


/*****************************************************************************
T E M P O R A R Y   T E S T V A R I A B L E S
*****************************************************************************/

/*****************************************************************************
C O N S T A N T S / M A C R O S
*****************************************************************************/
/*****************************************************************************
L O C A L   D A T A T Y P E S
*****************************************************************************/

/*****************************************************************************
L O C A L   F U N C T I O N   P R O T O T Y P E S
*****************************************************************************/

/*****************************************************************************
 M O D U L E   V A R I A B L E S
*****************************************************************************/

/*****************************************************************************
G L O B A L   C O N S T A N T S / V A R I A B L E S
*****************************************************************************/

/*****************************************************************************
G L O B A L   F U N C T I O N S (Hand Coded)
*****************************************************************************/
bool_t HicWrapper_VerifyInterfaceVersion(uint32_t version)
{
   return (HicWrapper_VERSION_ID == version);
}


void HicWrapper_uint8_t(uint8_t* object_p, Blob_t* blob, WrapperAction_t action)
{ 
   switch (action)
   {
      case ACTION_PACK:
         if (blob->index + 1 > blob->length) 
         {
            blob->status = FALSE;
         }
         else
         {
            *((uint8_t*)&blob->buffer[blob->index]) = *object_p;
         }
         break;

      case ACTION_UNPACK:
         if (blob->index + 1 > blob->length) 
         {
            blob->status = FALSE;
            *object_p = 0;
         }
         else
         {
            *object_p = (uint8_t)blob->buffer[blob->index];
         }
         break;
      case ACTION_GET_SIZE:
         break;
   }
   blob->index += 1;
} /* HicWrapper_uint8_t */ 

void HicWrapper_uint16_t(uint16_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   switch (action)
   {
      case ACTION_PACK:
         if (blob->index + 2 > blob->length) 
         {
            blob->status = FALSE;
         }
         else
         {
            /* Use a method for copying that is endian and alignment agnostic. */
         	blob->buffer[blob->index + 0] = (char)(*object_p);
         	blob->buffer[blob->index + 1] = (char)(*object_p >> 8);
         }
         break;

      case ACTION_UNPACK:
         if (blob->index + 2 > blob->length) 
         {
            blob->status = FALSE;
            *object_p = 0;
         }
         else
         {
            /* Use a method for copying that is endian and alignment agnostic. */
         	*object_p = ((uint8_t)blob->buffer[blob->index + 0])
                      | ((uint8_t)blob->buffer[blob->index + 1] << 8);
         }
         break;
      case ACTION_GET_SIZE:
         break;
   }
   blob->index += 2;
} /* HicWrapper_uint16_t */ 

void HicWrapper_uint32_t(uint32_t* object_p, Blob_t* blob, WrapperAction_t action)
{ 
   switch (action)
   {
      case ACTION_PACK:
         if (blob->index + 4 > blob->length) 
         {
            blob->status = FALSE;
         }
         else
         {
            /* Use a method for copying that is endian and alignment agnostic. */
         	blob->buffer[blob->index + 0] = (char)(*object_p);
         	blob->buffer[blob->index + 1] = (char)(*object_p >> 8);
         	blob->buffer[blob->index + 2] = (char)(*object_p >> 16);
         	blob->buffer[blob->index + 3] = (char)(*object_p >> 24);
         }
         break;

      case ACTION_UNPACK:
         if (blob->index + 4 > blob->length) 
         {
            blob->status = FALSE;
            *object_p = 0;
         }
         else
         {
            /* Use a method for copying that is endian and alignment agnostic. */
         	*object_p = ((uint8_t)blob->buffer[blob->index + 0])
                      | ((uint8_t)blob->buffer[blob->index + 1] << 8)
                      | ((uint8_t)blob->buffer[blob->index + 2] << 16)
                      | ((uint8_t)blob->buffer[blob->index + 3] << 24);
         }
         break;
      case ACTION_GET_SIZE:
         break;
   }
   blob->index += 4;
} /* HicWrapper_uint32_t */ 

void HicWrapper_uint64_t(uint64_t* object_p, Blob_t* blob, WrapperAction_t action) 
{ 
   switch (action)
   {
      case ACTION_PACK:
         if (blob->index + 8 > blob->length) 
         {
            blob->status = FALSE;
         }
         else
         {
            /* Use a method for copying that is endian and alignment agnostic. */
#ifdef HAVE_ANSI_INTTYPES
            uint32_t low, hi;
            low = (uint32_t)*object_p;
            hi  = (uint32_t)(*object_p >> 32);
            HicWrapper_uint32_t(&low, blob, action);
            HicWrapper_uint32_t(&hi,  blob, action);
#else
            HicWrapper_uint32_t(&object_p->low, blob, action);
            HicWrapper_uint32_t(&object_p->hi,  blob, action);
#endif /* HAVE_ANSI_INTTYPES */
         }
         break;

      case ACTION_UNPACK:
         if (blob->index + 8 > blob->length) 
         {
            blob->status = FALSE;
            blob->index  = blob->length;
#ifdef HAVE_ANSI_INTTYPES
            DE_MEMSET(object_p, 0x00, 8);
#else
            object_p->low  = 0;
            object_p->hi   = 0;
#endif
         }
         else
         {
            /* Use a method for copying that is endian and alignment agnostic. */
#ifdef HAVE_ANSI_INTTYPES
            uint32_t low, hi;
            HicWrapper_uint32_t(&low, blob, action);
            HicWrapper_uint32_t(&hi,  blob, action);
            *object_p = low | ((uint64_t)hi << 32);
#else
            HicWrapper_uint32_t(&object_p->low, blob, action);
            HicWrapper_uint32_t(&object_p->hi,  blob, action);
#endif
         }
         break;
      case ACTION_GET_SIZE:
         blob->index += 8;
         break;
   }
} /* HicWrapper_uint64_t */ 

void HicWrapper_array_t(char* object_p, int length, Blob_t* blob, WrapperAction_t action)
{
   if (blob->status)
   {
      if (blob->index + length > blob->length)
      {
         length = blob->length - blob->index;
         blob->status = FALSE;
      }
      if (object_p != NULL)
      {
         switch (action)
         {
            case ACTION_PACK:
               /* The length of the virtual bitmap shall be subtracted with three bytes for the fixed fields. */
               DE_MEMCPY(&blob->buffer[blob->index], object_p, length);
               break;

            case ACTION_UNPACK:
               /* The length of the virtual bitmap shall be subtracted with three bytes for the fixed fields. */
               DE_MEMCPY(object_p, &blob->buffer[blob->index], length);
               break;
            case ACTION_GET_SIZE:
               break;
         }
      }
   }
   blob->index += length;
} /* HicWrapper_array_t */

void WrapperCopy_mlme_bss_description_t(void * context_p, mlme_bss_description_t* dest, mlme_bss_description_t* source)
{
   *dest = *source;

   dest->bss_description_p = (m80211_bss_description_t*)WrapperAttachStructure(context_p, sizeof(m80211_bss_description_t));
   if (dest->bss_description_p != NULL)
   {
      /* doubble work here:
       * ie's are copied in WrapperCopy_common_IEs_t also but
       * not all members in mac_mmpdu_beacon_ind_t so do that here */
      DE_MEMCPY(dest->bss_description_p, source->bss_description_p, sizeof(m80211_bss_description_t) - sizeof(common_IEs_t));

      /* Beware, these elements have dynamically allocated substructures. */
      WrapperCopy_common_IEs_t(dest->bss_description_p, &dest->bss_description_p->ie, &source->bss_description_p->ie);
   }
}

void HicWrapper_mlme_bss_description_t(mlme_bss_description_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   Blob_t local_blob;
 
   INIT_BLOB(&local_blob, NULL, BLOB_UNKNOWN_SIZE);

   HicWrapper_m80211_mac_addr_t(&object_p->bssId, blob, action);
   HicWrapper_uint8_t(&object_p->bssType, blob, action);
   HicWrapper_uint8_t(&object_p->dtim_period, blob, action); 
   HicWrapper_uint64_t(&object_p->local_timestamp, blob, action);   
   HicWrapper_uint32_t((uint32_t *)&object_p->rssi_info, blob, action);  
   HicWrapper_uint32_t((uint32_t *)&object_p->snr_info, blob, action);

   /* Since we do not know the real size of the encoded data, 
      we must use a local blob to remember where the size field shall be stored.
    */
   DE_MEMCPY(&local_blob, blob, sizeof(*blob));
   HicWrapper_uint32_t(&object_p->size_of_packed_bss_description, &local_blob, action);
   
   if (action == ACTION_UNPACK)
   {
      /* Limit the blob to the actual size of this field, 
         including what ever is before it. 
       */
      BLOB_BUF_RESIZE(&local_blob, BLOB_CURRENT_SIZE(blob)
         + object_p->size_of_packed_bss_description + sizeof(object_p->size_of_packed_bss_description));

      /* Before unpacking the elements of this IE, allocate a buffer for it. */
      object_p->bss_description_p = (m80211_bss_description_t*) 
               WrapperAttachStructure(blob->structure, sizeof(m80211_bss_description_t));

      /* Attach any dynamic structure to the bss_description_p rather than the parent structure. */
      BLOB_ATTACH_WRAPPER_STRUCTURE(&local_blob, object_p->bss_description_p);
   }

   /* Pack/unpack the data. */
   HicWrapper_m80211_bss_description_t(object_p->bss_description_p, &local_blob, action);


   /**********************************************************************/
   /* Note that the original blob is still positioned at the size field. */
   
   /* Update size field. */
   if (action != ACTION_UNPACK)
   {
      object_p->size_of_packed_bss_description = BLOB_CURRENT_SIZE(&local_blob) 
                                               - BLOB_CURRENT_SIZE(blob) 
                                               - (uint16_t)sizeof(object_p->size_of_packed_bss_description);
   }

   /* Pack the updated size field. */
   HicWrapper_uint32_t(&object_p->size_of_packed_bss_description, blob, action);

   /* Skip the bss_description to get to the index rigth after the messy 
      bss_description field. 
    */
   BLOB_PAD(blob, object_p->size_of_packed_bss_description);      
   /**********************************************************************/
   
} /* HicWrapper_mlme_bss_description_t */


void HicWrapper_m80211_mlme_scan_ind_t(m80211_mlme_scan_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint32_t(&object_p->trans_id, blob, action);
   
   HicWrapper_mlme_bss_description_t(&object_p->scan_ind_body, blob, action);
} /* HicWrapper_m80211_mlme_scan_ind_t */

void HicWrapper_varstring_t(varstring_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint32_t(&object_p->size, blob, action);
   if (object_p->ref != NULL)
   {
      HicWrapper_array_t(object_p->ref, object_p->size, blob, action);
   }
   else
   {
      /* Let the "ref" pointer point into the packed buffer. */
      if (action == ACTION_UNPACK)
      {
         object_p->ref = &blob->buffer[blob->index];
         blob->index += object_p->size;
      }
   }
}

void WrapperCopy_common_IEs_t(void* context_p, common_IEs_t* dest, common_IEs_t* source)
{
   *dest = *source;
   WrapperCopy_m80211_ie_country_t(context_p, &dest->country_info_set, &source->country_info_set);
   WrapperCopy_m80211_ie_tim_t(context_p, &dest->tim_parameter_set, &source->tim_parameter_set);
   WrapperCopy_m80211_ie_wpa_parameter_set_t(context_p, &dest->wpa_parameter_set, &source->wpa_parameter_set);
   WrapperCopy_m80211_ie_wps_parameter_set_t(context_p, &dest->wps_parameter_set, &source->wps_parameter_set);
   WrapperCopy_m80211_ie_rsn_parameter_set_t(context_p, &dest->rsn_parameter_set, &source->rsn_parameter_set);
   WrapperCopy_m80211_ie_wapi_parameter_set_t(context_p, &dest->wapi_parameter_set, &source->wapi_parameter_set);
#if (DE_CCX == CFG_INCLUDED)
   WrapperCopy_m80211_ie_qbss_load_t(context_p, &dest->qbss_parameter_set, &source->qbss_parameter_set);
   WrapperCopy_m80211_ie_ccx_parameter_set_t(context_p, &dest->ccx_parameter_set, &source->ccx_parameter_set);
   WrapperCopy_m80211_ie_ccx_rm_parameter_set_t(context_p, &dest->ccx_rm_parameter_set, &source->ccx_rm_parameter_set);
   WrapperCopy_m80211_ie_ccx_cpl_parameter_set_t(context_p, &dest->ccx_cpl_parameter_set, &source->ccx_cpl_parameter_set);
   WrapperCopy_m80211_ie_ccx_tsm_parameter_set_t(context_p, &dest->ccx_tsm_parameter_set, &source->ccx_tsm_parameter_set);
   WrapperCopy_m80211_ie_wmm_tspec_parameter_set_t(context_p, &dest->wmm_tspec_parameter_set, &source->wmm_tspec_parameter_set);
   WrapperCopy_m80211_ie_ccx_reassoc_req_parameter_set_t(context_p, &dest->ccx_reassoc_req_parameter_set, &source->ccx_reassoc_req_parameter_set);
   WrapperCopy_m80211_ie_ccx_reassoc_rsp_parameter_set_t(context_p, &dest->ccx_reassoc_rsp_parameter_set, &source->ccx_reassoc_rsp_parameter_set);
#if 0  
   WrapperCopy_m80211_ie_ccx_adj_parameter_set_t(context_p, &dest->ccx_adj_parameter_set, &source->ccx_adj_parameter_set);
#endif //0
#endif //DE_CCX
   WrapperCopy_m80211_remaining_IEs_t(context_p, &dest->remaining_sets, &source->remaining_sets);
}

void HicWrapper_m80211_mlme_host_header_t(m80211_mlme_host_header_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   int idx = blob->index;
   HicWrapper_uint16_t(&object_p->length, blob, action);
   HicWrapper_hic_message_control_t(&object_p->hic, blob, action);
   /* Fix padding */
   if (object_p->hic.header_size)
   {
      blob->index = idx + object_p->hic.header_size;
   }
} /* HicWrapper_m80211_mlme_host_header_t */

/*****************************************************************************
G L O B A L   C A C H E   F U N C T I O N S
*****************************************************************************/
#define HicWrapper_bool_t HicWrapper_int

#define HicWrapper_m80211_std_rate_encoding_t HicWrapper_uint8_t

#define HicWrapper_m80211_tu16_t HicWrapper_uint16_t

#define HicWrapper_m80211_ie_id_t HicWrapper_uint8_t

#define HicWrapper_m80211_ie_len_t HicWrapper_uint8_t

void HicWrapper_m80211_tbtt_timing_t(m80211_tbtt_timing_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint8_t(&object_p->count, blob, action);
   HicWrapper_uint8_t(&object_p->period, blob, action);
} /* HicWrapper_m80211_tbtt_timing_t */

void HicWrapper_m80211_oui_id_t(m80211_oui_id_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_array_t((char*)object_p->octet, (sizeof(char)*3), blob, action);
} /* HicWrapper_m80211_oui_id_t */

#define HicWrapper_m80211_rsn_version_t HicWrapper_uint16_t

#define HicWrapper_m80211_cipher_suite_t HicWrapper_uint8_t

#define HicWrapper_m80211_protect_type_t HicWrapper_uint8_t

void HicWrapper_m80211_cipher_suite_selector_t(m80211_cipher_suite_selector_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_m80211_oui_id_t(&object_p->id, blob, action);
   HicWrapper_m80211_cipher_suite_t(&object_p->type, blob, action);
} /* HicWrapper_m80211_cipher_suite_selector_t */

void HicWrapper_m80211_country_string_t(m80211_country_string_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_array_t((char*)object_p->string, (sizeof(char)*M80211_IE_LEN_COUNTRY_STRING), blob, action);
} /* HicWrapper_m80211_country_string_t */

void HicWrapper_m80211_country_channels_t(m80211_country_channels_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint8_t(&object_p->first_channel, blob, action);
   HicWrapper_uint8_t(&object_p->num_channels, blob, action);
   HicWrapper_int8_t(&object_p->max_tx_power, blob, action);
} /* HicWrapper_m80211_country_channels_t */

void HicWrapper_AC_parameters_t(AC_parameters_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint8_t(&object_p->ACI_ACM_AIFSN, blob, action);
   HicWrapper_uint8_t(&object_p->ECWmin_ECWmax, blob, action);
   HicWrapper_uint16_t(&object_p->TXOP_Limit, blob, action);
} /* HicWrapper_AC_parameters_t */

void HicWrapper_m80211_key_t(m80211_key_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_array_t((char*)object_p->part, (sizeof(uint8_t)*32), blob, action);
} /* HicWrapper_m80211_key_t */

#define HicWrapper_m80211_key_type_t HicWrapper_uint8_t

#define HicWrapper_hic_message_length_t HicWrapper_uint16_t

#define HicWrapper_hic_message_type_t HicWrapper_uint8_t

#define HicWrapper_hic_message_id_t HicWrapper_uint8_t

#define HicWrapper_hic_message_ul_header_size_t HicWrapper_uint8_t

#define HicWrapper_hic_message_nr_padding_bytes_added_t HicWrapper_uint16_t

void HicWrapper_hic_message_control_t(hic_message_control_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_hic_message_type_t(&object_p->type, blob, action);
   HicWrapper_hic_message_id_t(&object_p->id, blob, action);
   HicWrapper_hic_message_ul_header_size_t(&object_p->header_size, blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
   HicWrapper_hic_message_nr_padding_bytes_added_t(&object_p->nr_padding_bytes_added, blob, action);
} /* HicWrapper_hic_message_control_t */

void HicWrapper_hic_message_header_t(hic_message_header_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_hic_message_length_t(&object_p->len, blob, action);
   HicWrapper_hic_message_control_t(&object_p->control, blob, action);
} /* HicWrapper_hic_message_header_t */

#define HicWrapper_mac_api_transid_t HicWrapper_uint32_t
#if (DE_CCX == CFG_INCLUDED)
#define HicWrapper_m80211_mlme_result_t HicWrapper_uint16_t
#endif //DE_CCX

void HicWrapper_hic_interface_wrapper_t(hic_interface_wrapper_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_m80211_mlme_host_header_t(&object_p->hic_host_header, blob, action);
   HicWrapper_m80211_mlme_status_cfm_t(&object_p->hic_status_cfm, blob, action);
   HicWrapper_m80211_mlme_addr_and_short_ind_t(&object_p->hic_addr_and_type_ind, blob, action);
   HicWrapper_m80211_mlme_parameter_cfm_t(&object_p->hic_parameter_cfm, blob, action);
   HicWrapper_m80211_mlme_association_cfm_t(&object_p->hic_association_cfm, blob, action);
   HicWrapper_hic_message_header_t(&object_p->hic_message_header, blob, action);
   HicWrapper_hic_message_control_t(&object_p->hic_message_ctrl, blob, action);
   HicWrapper_mlme_mgmt_body_t(&object_p->hic_mlme_mgmt_body, blob, action);
   HicWrapper_hic_ctrl_msg_t(&object_p->hic_ctrl_msg, blob, action);
   HicWrapper_mac_mmpdu_beacon_ind_t(&object_p->beacon_ind, blob, action);
} /* HicWrapper_hic_interface_wrapper_t */

void HicWrapper_m80211_mlme_status_cfm_t(m80211_mlme_status_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_m80211_mlme_status_cfm_t */

void HicWrapper_m80211_mlme_addr_and_short_ind_t(m80211_mlme_addr_and_short_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_sta, blob, action);
   HicWrapper_uint16_t(&object_p->value, blob, action);
} /* HicWrapper_m80211_mlme_addr_and_short_ind_t */

void HicWrapper_m80211_mlme_parameter_cfm_t(m80211_mlme_parameter_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->par, blob, action);
} /* HicWrapper_m80211_mlme_parameter_cfm_t */

void HicWrapper_m80211_mlme_association_cfm_t(m80211_mlme_association_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint16_t(&object_p->aid, blob, action);
   HicWrapper_uint8_t(&object_p->result, blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
   HicWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* HicWrapper_m80211_mlme_association_cfm_t */

void HicWrapper_mlme_mgmt_body_t(mlme_mgmt_body_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mlme_direct_scan_req_t(&object_p->mlme_direct_scan_req, blob, action);
} /* HicWrapper_mlme_mgmt_body_t */

void HicWrapper_hic_ctrl_msg_t(hic_ctrl_msg_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_hic_ctrl_msg_body_t(&object_p->hic_ctrl_msg_body, blob, action);
} /* HicWrapper_hic_ctrl_msg_t */

void HicWrapper_mac_mmpdu_beacon_ind_t(mac_mmpdu_beacon_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
#if (DE_CCX == CFG_INCLUDED)
   object_p->driverenv_timestamp = DriverEnvironment_GetTimestamp_msec();
#endif
   HicWrapper_uint64_t(&object_p->timestamp, blob, action);
   HicWrapper_uint16_t(&object_p->beacon_period, blob, action);
   HicWrapper_uint16_t(&object_p->capability_info, blob, action);
   HicWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* HicWrapper_mac_mmpdu_beacon_ind_t */

#define HicWrapper_mlme_snr_db_t HicWrapper_int32_t

#define HicWrapper_mlme_peer_status_t HicWrapper_uint8_t

void HicWrapper_common_IEs_t(common_IEs_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_m80211_ie_ssid_t(&object_p->ssid, blob, action);
   HicWrapper_m80211_ie_supported_rates_t(&object_p->supported_rate_set, blob, action);
   HicWrapper_m80211_ie_ext_supported_rates_t(&object_p->ext_supported_rate_set, blob, action);
   HicWrapper_m80211_ie_request_info_t(&object_p->req_info_set, blob, action);
   HicWrapper_m80211_ie_erp_t(&object_p->erp_info_set, blob, action);
   HicWrapper_m80211_ie_tim_t(&object_p->tim_parameter_set, blob, action);
   HicWrapper_m80211_ie_ds_par_set_t(&object_p->ds_parameter_set, blob, action);
   HicWrapper_m80211_ie_cf_par_set_t(&object_p->cf_parameter_set, blob, action);
   HicWrapper_m80211_ie_fh_par_set_t(&object_p->fh_parameter_set, blob, action);
   HicWrapper_m80211_ie_ibss_par_set_t(&object_p->ibss_parameter_set, blob, action);
   HicWrapper_m80211_ie_country_t(&object_p->country_info_set, blob, action);
   HicWrapper_m80211_ie_WMM_parameter_element_t(&object_p->wmm_parameter_element, blob, action);
   HicWrapper_m80211_ie_WMM_information_element_t(&object_p->wmm_information_element, blob, action);
   HicWrapper_m80211_ie_qos_capability_t(&object_p->qos_capability, blob, action);
   HicWrapper_m80211_ie_wpa_parameter_set_t(&object_p->wpa_parameter_set, blob, action);
   HicWrapper_m80211_ie_rsn_parameter_set_t(&object_p->rsn_parameter_set, blob, action);
   HicWrapper_m80211_ie_wps_parameter_set_t(&object_p->wps_parameter_set, blob, action); /*not needed yet*/
#if (DE_CCX == CFG_INCLUDED)
   HicWrapper_m80211_ie_qbss_load_t(&object_p->qbss_parameter_set, blob, action);
   HicWrapper_m80211_ie_ccx_cpl_parameter_set_t(&object_p->ccx_cpl_parameter_set, blob, action);
   HicWrapper_m80211_ie_ccx_tsm_parameter_set_t(&object_p->ccx_tsm_parameter_set, blob, action);
   HicWrapper_m80211_ie_ccx_parameter_set_t(&object_p->ccx_parameter_set, blob, action);
   HicWrapper_m80211_ie_ccx_rm_parameter_set_t(&object_p->ccx_rm_parameter_set, blob, action);
   HicWrapper_m80211_wmm_tspec_ie_t(&object_p->wmm_tspec_parameter_set, blob, action);
   HicWrapper_m80211_ie_ccx_reassoc_req_parameter_set_t(&object_p->ccx_reassoc_req_parameter_set, blob, action);
   HicWrapper_m80211_ie_ccx_reassoc_rsp_parameter_set_t(&object_p->ccx_reassoc_rsp_parameter_set, blob, action);
#if 0  
   HicWrapper_m80211_ie_ccx_adj_parameter_set_t(&object_p->ccx_adj_parameter_set, blob, action);
#endif //0
#endif //DE_CCX

   HicWrapper_m80211_ie_wapi_parameter_set_t(&object_p->wapi_parameter_set, blob, action);
   HicWrapper_m80211_ie_ht_capabilities_t(&object_p->ht_capabilities, blob, action);
   HicWrapper_m80211_ie_ht_operation_t(&object_p->ht_operation, blob, action);
   HicWrapper_m80211_remaining_IEs_t(&object_p->remaining_sets, blob, action);
} /* HicWrapper_common_IEs_t */

void HicWrapper_receive_seq_cnt_t(receive_seq_cnt_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_array_t((char*)object_p->octet, sizeof(object_p->octet), blob, action);
} /* HicWrapper_receive_seq_cnt_t */

void HicWrapper_m80211_set_key_descriptor_t(m80211_set_key_descriptor_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_m80211_key_t(&object_p->key, blob, action);
   HicWrapper_uint16_t(&object_p->key_len, blob, action);
   HicWrapper_uint8_t(&object_p->key_id, blob, action);
   HicWrapper_m80211_key_type_t(&object_p->key_type, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->mac_addr, blob, action);
   HicWrapper_receive_seq_cnt_t(&object_p->receive_seq_cnt, blob, action);
   HicWrapper_uint8_t(&object_p->config_by_authenticator, blob, action);
   HicWrapper_m80211_cipher_suite_t(&object_p->cipher_suite, blob, action);
} /* HicWrapper_m80211_set_key_descriptor_t */

void HicWrapper_m80211_delete_key_descriptor_t(m80211_delete_key_descriptor_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint8_t(&object_p->key_id, blob, action);
   HicWrapper_m80211_key_type_t(&object_p->key_type, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->mac_addr, blob, action);
} /* HicWrapper_m80211_delete_key_descriptor_t */

void HicWrapper_m80211_protect_list_element_t(m80211_protect_list_element_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_m80211_mac_addr_t(&object_p->mac_addr, blob, action);
   HicWrapper_m80211_protect_type_t(&object_p->protect_type, blob, action);
   HicWrapper_m80211_key_type_t(&object_p->key_type, blob, action);
} /* HicWrapper_m80211_protect_list_element_t */

void HicWrapper_m80211_michael_mic_failure_ind_descriptor_t(m80211_michael_mic_failure_ind_descriptor_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint8_t(&object_p->count, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->mac_addr, blob, action);
   HicWrapper_m80211_key_type_t(&object_p->key_type, blob, action);
   HicWrapper_uint8_t(&object_p->key_id, blob, action);
   HicWrapper_array_t((char*)object_p->tsc, (sizeof(uint8_t)*6), blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
} /* HicWrapper_m80211_michael_mic_failure_ind_descriptor_t */

void HicWrapper_m80211_mlme_power_mgmt_req_t(m80211_mlme_power_mgmt_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint16_t(&object_p->power_mgmt_mode, blob, action);
   HicWrapper_uint8_t(&object_p->use_ps_poll, blob, action);
   HicWrapper_uint8_t(&object_p->receive_all_dtim, blob, action);
} /* HicWrapper_m80211_mlme_power_mgmt_req_t */

void HicWrapper_m80211_mlme_join_req_t(m80211_mlme_join_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint16_t(&object_p->join_timeout, blob, action);
   HicWrapper_uint16_t(&object_p->probe_delay, blob, action);
   HicWrapper_uint32_t(&object_p->operational_rate_mask, blob, action);   
   HicWrapper_uint32_t(&object_p->basic_rate_mask, blob, action);   
   HicWrapper_mlme_bss_description_t(&object_p->bss, blob, action);
} /* HicWrapper_m80211_mlme_join_req_t */

void HicWrapper_m80211_mlme_authenticate_req_t(m80211_mlme_authenticate_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint16_t(&object_p->type, blob, action);
   HicWrapper_uint16_t(&object_p->timeout, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_sta, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
} /* HicWrapper_m80211_mlme_authenticate_req_t */

void HicWrapper_m80211_mlme_associate_req_t(m80211_mlme_associate_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint16_t(&object_p->timeout, blob, action);
   HicWrapper_uint16_t(&object_p->capability_info, blob, action);
   HicWrapper_uint16_t(&object_p->listen_interval, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_sta, blob, action);
   HicWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* HicWrapper_m80211_mlme_associate_req_t */

void HicWrapper_m80211_mlme_disassociate_req_t(m80211_mlme_disassociate_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_sta, blob, action);
   HicWrapper_uint8_t(&object_p->reason, blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
} /* HicWrapper_m80211_mlme_disassociate_req_t */

void HicWrapper_m80211_mlme_reset_req_t(m80211_mlme_reset_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->bssId, blob, action);
   HicWrapper_uint8_t(&object_p->set_default_mib, blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
} /* HicWrapper_m80211_mlme_reset_req_t */

void HicWrapper_m80211_mlme_start_req_t(m80211_mlme_start_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint16_t(&object_p->beacon_period, blob, action);
   HicWrapper_uint16_t(&object_p->probe_delay, blob, action);
   HicWrapper_uint16_t(&object_p->capability_info, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->bssid, blob, action);
   HicWrapper_uint8_t(&object_p->bss_type, blob, action);
   HicWrapper_uint8_t(&object_p->dtim_period, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
   HicWrapper_uint32_t(&object_p->supported_rate_mask, blob, action);   
   HicWrapper_uint32_t(&object_p->basic_rate_mask, blob, action);   
   HicWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* HicWrapper_m80211_mlme_start_req_t */

void HicWrapper_m80211_mlme_set_key_req_t(m80211_mlme_set_key_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_set_key_descriptor_t(&object_p->set_key_descriptor, blob, action);
} /* HicWrapper_m80211_mlme_set_key_req_t */

void HicWrapper_m80211_mlme_delete_key_req_t(m80211_mlme_delete_key_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_delete_key_descriptor_t(&object_p->delete_key_descriptor, blob, action);
} /* HicWrapper_m80211_mlme_delete_key_req_t */

void HicWrapper_m80211_mlme_set_protection_req_t(m80211_mlme_set_protection_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_protect_list_element_t(&object_p->protect_list_element, blob, action);
} /* HicWrapper_m80211_mlme_set_protection_req_t */

void HicWrapper_m80211_nrp_mlme_bss_leave_req_t(m80211_nrp_mlme_bss_leave_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->bssId, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
} /* HicWrapper_m80211_nrp_mlme_bss_leave_req_t */

void HicWrapper_m80211_nrp_mlme_ibss_leave_req_t(m80211_nrp_mlme_ibss_leave_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->bssId, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
} /* HicWrapper_m80211_nrp_mlme_ibss_leave_req_t */

void HicWrapper_mlme_direct_scan_req_t(mlme_direct_scan_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
   HicWrapper_uint16_t(&object_p->channel_interval, blob, action);
   HicWrapper_uint16_t(&object_p->use_default_params, blob, action);
   HicWrapper_uint32_t(&object_p->probe_delay, blob, action);
   HicWrapper_uint16_t(&object_p->min_ch_time, blob, action);
   HicWrapper_uint16_t(&object_p->max_ch_time, blob, action);
} /* HicWrapper_mlme_direct_scan_req_t */

void HicWrapper_m80211_mlme_authenticate_cfm_t(m80211_mlme_authenticate_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_sta, blob, action);
   HicWrapper_uint16_t(&object_p->type, blob, action);
   HicWrapper_uint16_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
} /* HicWrapper_m80211_mlme_authenticate_cfm_t */

void HicWrapper_m80211_mlme_associate_ind_t(m80211_mlme_associate_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_sta, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
   HicWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* HicWrapper_m80211_mlme_associate_ind_t */

void HicWrapper_m80211_mlme_reassociate_ind_t(m80211_mlme_reassociate_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_sta, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
   HicWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* HicWrapper_m80211_mlme_reassociate_ind_t */

void HicWrapper_m80211_mlme_disassociate_ind_t(m80211_mlme_disassociate_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->bssId, blob, action);
   HicWrapper_uint8_t(&object_p->reason, blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
} /* HicWrapper_m80211_mlme_disassociate_ind_t */

void HicWrapper_m80211_mlme_michael_mic_failure_ind_t(m80211_mlme_michael_mic_failure_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_michael_mic_failure_ind_descriptor_t(&object_p->michael_mic_failure_ind_descriptor, blob, action);
} /* HicWrapper_m80211_mlme_michael_mic_failure_ind_t */

void HicWrapper_m80211_nrp_mlme_peer_status_ind_t(m80211_nrp_mlme_peer_status_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_mlme_peer_status_t(&object_p->status, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->peer_mac, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->bssid, blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
} /* HicWrapper_m80211_nrp_mlme_peer_status_ind_t */

void HicWrapper_mlme_direct_scan_cfm_t(mlme_direct_scan_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint32_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_mlme_direct_scan_cfm_t */

#define HicWrapper_mib_result_t HicWrapper_uint8_t

void HicWrapper_mlme_mib_get_req_t(mlme_mib_get_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_array_t((char*)object_p->identifier, (sizeof(char)*MIB_IDENTIFIER_MAX_LENGTH), blob, action);
} /* HicWrapper_mlme_mib_get_req_t */

void HicWrapper_mlme_mib_get_raw_req_t(mlme_mib_get_raw_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_array_t((char*)object_p->identifier, (sizeof(char)*MIB_IDENTIFIER_MAX_LENGTH), blob, action);
   HicWrapper_uint32_t(&object_p->object.reference, blob, action);
   HicWrapper_uint32_t(&object_p->object.storage_description, blob, action);
#if defined (WIN_SIMULATION)
   HicWrapper_uint32_t((uint32_t* )&object_p->object.ev_func, blob, action);
#endif
} /* HicWrapper_mlme_mib_get_raw_req_t */

void HicWrapper_mlme_mib_set_req_t(mlme_mib_set_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_array_t((char*)object_p->identifier, (sizeof(char)*MIB_IDENTIFIER_MAX_LENGTH), blob, action);
   HicWrapper_varstring_t(&object_p->value, blob, action);
} /* HicWrapper_mlme_mib_set_req_t */

void HicWrapper_mlme_mib_set_raw_req_t(mlme_mib_set_raw_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_array_t((char*)object_p->identifier, (sizeof(char)*MIB_IDENTIFIER_MAX_LENGTH), blob, action);
   HicWrapper_uint32_t(&object_p->object.reference, blob, action);
   HicWrapper_uint32_t(&object_p->object.storage_description, blob, action);
#if defined (WIN_SIMULATION)
   HicWrapper_uint32_t((uint32_t* )&object_p->object.ev_func, blob, action);
#endif
   HicWrapper_varstring_t(&object_p->value, blob, action);
} /* HicWrapper_mlme_mib_set_req_t */


void HicWrapper_mlme_mib_get_next_req_t(mlme_mib_get_next_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->getFirst, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_mlme_mib_get_next_req_t */

void HicWrapper_mlme_mib_set_trigger_req_t(mlme_mib_set_trigger_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
#if 1
   if(object_p->reference_type == MIB_REFERENCE_BY_IDENTIFIER)
   {
      HicWrapper_uint32_t(&object_p->reference.object.reference, blob, action);
      HicWrapper_uint32_t(&object_p->reference.object.storage_description, blob, action);
   } else {
      HicWrapper_array_t(&object_p->reference.identifier[0],MIB_IDENTIFIER_MAX_LENGTH, blob, action);
   }
#else
   HicWrapper_array_t(&object_p->reference.identifier[0],MIB_IDENTIFIER_MAX_LENGTH, blob, action);
#endif
   HicWrapper_uint32_t(&object_p->trigger_id, blob, action);
   HicWrapper_uint32_t(&object_p->gating_trigger_id, blob, action);
   HicWrapper_uint32_t(&object_p->supv_interval, blob, action);
   HicWrapper_uint32_t(&object_p->ind_cb, blob, action);
   HicWrapper_uint32_t(&object_p->level, blob, action);
   HicWrapper_uint16_t(&object_p->event, blob, action);
   HicWrapper_uint16_t(&object_p->event_count, blob, action);
   HicWrapper_uint16_t(&object_p->triggmode, blob, action);
   HicWrapper_uint8_t(&object_p->reference_type, blob, action);
   HicWrapper_uint8_t(&object_p->reserved, blob, action);
} /* HicWrapper_mlme_mib_set_trigger_req_t */

void HicWrapper_mlme_mib_set_gatingtrigger_req_t(mlme_mib_set_gatingtrigger_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->trigger_id, blob, action);
   HicWrapper_uint32_t(&object_p->gating_trigger_id, blob, action);
} /* HicWrapper_mlme_mib_set_gatingtrigger_req_t */

void HicWrapper_mlme_mib_remove_trigger_req_t(mlme_mib_remove_trigger_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->trigger_id, blob, action);
} /* HicWrapper_mlme_mib_remove_trigger_req_t */

void HicWrapper_mlme_mib_get_cfm_t(mlme_mib_get_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_mib_result_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
   HicWrapper_array_t((char*)object_p->identifier, (sizeof(char)*MIB_IDENTIFIER_MAX_LENGTH), blob, action);
   HicWrapper_varstring_t(&object_p->value, blob, action);
} /* HicWrapper_mlme_mib_get_cfm_t */

void HicWrapper_mlme_mib_set_cfm_t(mlme_mib_set_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_mib_result_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
   HicWrapper_array_t((char*)object_p->identifier, (sizeof(char)*MIB_IDENTIFIER_MAX_LENGTH), blob, action);
} /* HicWrapper_mlme_mib_set_cfm_t */

void HicWrapper_mlme_mib_set_trigger_cfm_t(mlme_mib_set_trigger_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->trigger_id, blob, action);
   HicWrapper_mib_result_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_mlme_mib_set_trigger_cfm_t */

void HicWrapper_mlme_mib_set_gatingtrigger_cfm_t(mlme_mib_set_gatingtrigger_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->trigger_id, blob, action);
   HicWrapper_mib_result_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_mlme_mib_set_gatingtrigger_cfm_t */

void HicWrapper_mlme_mib_remove_trigger_cfm_t(mlme_mib_remove_trigger_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->trigger_id, blob, action);
   HicWrapper_mib_result_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_mlme_mib_remove_trigger_cfm_t */

void HicWrapper_mlme_mib_trigger_ind_t(mlme_mib_trigger_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->trigger_id, blob, action);
   HicWrapper_uint32_t(&object_p->varsize, blob, action);
   HicWrapper_int32_t(&object_p->value, blob, action);
} /* HicWrapper_mlme_mib_trigger_ind_t */

void HicWrapper_mac_mib_body_t(mac_mib_body_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mlme_mib_get_req_t(&object_p->mlme_mib_get_req, blob, action);
} /* HicWrapper_mac_mib_body_t */

void HicWrapper_m80211_nrp_mlme_scan_config_t(m80211_nrp_mlme_scan_config_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_uint32_t(&object_p->probe_delay, blob, action);
   HicWrapper_uint32_t(&object_p->discon_scan_period, blob, action);
   HicWrapper_uint32_t(&object_p->conn_scan_period, blob, action);
   HicWrapper_uint16_t(&object_p->rate, blob, action);
   HicWrapper_uint16_t(&object_p->probes_per_ch, blob, action);
   HicWrapper_uint16_t(&object_p->notification_policy, blob, action);
   HicWrapper_uint16_t(&object_p->pa_min_ch_time, blob, action);
   HicWrapper_uint16_t(&object_p->pa_max_ch_time, blob, action);
   HicWrapper_uint16_t(&object_p->ac_min_ch_time, blob, action);
   HicWrapper_uint16_t(&object_p->ac_max_ch_time, blob, action);
   HicWrapper_uint16_t(&object_p->as_min_ch_time, blob, action);
   HicWrapper_uint16_t(&object_p->as_max_ch_time, blob, action);
   HicWrapper_uint8_t(&object_p->preamble, blob, action);
   HicWrapper_uint8_t(&object_p->deliv_pol, blob, action);
   HicWrapper_uint32_t(&object_p->max_disconnect_period, blob, action);
   HicWrapper_uint32_t(&object_p->max_connect_period, blob, action);
   HicWrapper_uint8_t(&object_p->period_repetition, blob, action);
} /* HicWrapper_m80211_nrp_mlme_scan_config_t */

void HicWrapper_hic_ctrl_version_req_t(hic_ctrl_version_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->control, blob, action);
} /* HicWrapper_hic_ctrl_version_req_t */

void HicWrapper_hic_ctrl_heartbeat_req_t(hic_ctrl_heartbeat_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->interval, blob, action);
   HicWrapper_uint8_t(&object_p->control, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_hic_ctrl_heartbeat_req_t */


void HicWrapper_hic_ctrl_set_alignment_req_t(hic_ctrl_set_alignment_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint16_t(&object_p->min_sz, blob, action);
   HicWrapper_uint16_t(&object_p->padding_sz, blob, action);
   HicWrapper_uint8_t(&object_p->hAttention, blob, action);
   HicWrapper_uint8_t(&object_p->ul_header_size, blob, action);
   HicWrapper_uint8_t(&object_p->swap, blob, action);
   HicWrapper_uint8_t(&object_p->hWakeup, blob, action);
   HicWrapper_uint8_t(&object_p->hForceInterval, blob, action);
   HicWrapper_uint8_t(&object_p->tx_window_size, blob, action);
   HicWrapper_uint16_t(&object_p->block_mode_bug_workaround_block_size, blob, action);
   HicWrapper_array_t((char*)&object_p->reserved[0], sizeof(object_p->reserved), blob, action);
} /* HicWrapper_hic_ctrl_set_alignment_req_t */

void HicWrapper_hic_ctrl_init_completed_req_t(hic_ctrl_init_completed_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->dummy, blob, action);
} 
void HicWrapper_hic_ctrl_init_completed_cfm_t(hic_ctrl_init_completed_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* hic_ctrl_init_completed_cfm_t */
void HicWrapper_hic_ctrl_interface_down_t(hic_ctrl_interface_down_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->reserved, blob, action);
} /* HicWrapper_hic_ctrl_interface_down_t */

void HicWrapper_hic_ctrl_commit_suicide_req_t(hic_ctrl_commit_suicide_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->dummy, blob, action);
} /* HicWrapper_hic_ctrl_commit_suicide_req_t */

void HicWrapper_hic_ctrl_scb_error_req_t(hic_ctrl_scb_error_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_varstring_t(&object_p->keyString, blob, action);
} /* HicWrapper_hic_ctrl_scb_error_req_t */

void HicWrapper_hic_ctrl_sleep_forever_req_t(hic_ctrl_sleep_forever_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->control, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_hic_ctrl_sleep_forever_req_t */

void HicWrapper_m80211_nrp_mlme_wmm_ps_period_start_req_t(m80211_nrp_mlme_wmm_ps_period_start_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->activity, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_m80211_nrp_mlme_wmm_ps_period_start_req_t */

void HicWrapper_hic_ctrl_wakeup_ind_t(hic_ctrl_wakeup_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->reasons, blob, action);
} /* HicWrapper_hic_ctrl_wakeup_ind_t */

void HicWrapper_hic_ctrl_version_cfm_t(hic_ctrl_version_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->version, blob, action);
} /* HicWrapper_hic_ctrl_version_cfm_t */

void HicWrapper_hic_ctrl_heartbeat_ind_t(hic_ctrl_heartbeat_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->tsf_tmr, blob, action);
} /* HicWrapper_hic_ctrl_heartbeat_ind_t */

void HicWrapper_hic_ctrl_heartbeat_cfm_t(hic_ctrl_heartbeat_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->status, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_hic_ctrl_heartbeat_cfm_t */

void HicWrapper_hic_ctrl_set_alignment_cfm_t(hic_ctrl_set_alignment_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->result, blob, action);
   HicWrapper_uint8_t(&object_p->min_sz, blob, action);
   HicWrapper_uint8_t(&object_p->initial_gpio_state, blob, action);
   HicWrapper_array_t((char*)&object_p->reserved, sizeof(object_p->reserved), blob, action);
} /* HicWrapper_hic_ctrl_set_alignment_cfm_t */

void HicWrapper_hic_ctrl_scb_error_cfm_t(hic_ctrl_scb_error_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->objId, blob, action);
   HicWrapper_uint8_t(&object_p->errCode, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
   HicWrapper_uint32_t(&object_p->txDescriptorAddress, blob, action);
   HicWrapper_uint32_t(&object_p->signalHostAttentionAddress, blob, action);
} /* HicWrapper_hic_ctrl_scb_error_cfm_t */

void HicWrapper_hic_ctrl_sleep_forever_cfm_t(hic_ctrl_sleep_forever_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_hic_ctrl_sleep_forever_cfm_t */

void HicWrapper_m80211_nrp_mlme_wmm_ps_period_start_cfm_t(m80211_nrp_mlme_wmm_ps_period_start_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->result, blob, action);
   HicWrapper_array_t((char*)object_p->filler, 3, blob, action);
} /* HicWrapper_m80211_nrp_mlme_wmm_ps_period_start_cfm_t */

void HicWrapper_hic_ctrl_scb_error_ind_t(hic_ctrl_scb_error_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->objId, blob, action);
   HicWrapper_uint8_t(&object_p->errCode, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*2), blob, action);
   HicWrapper_uint32_t(&object_p->txDescriptorAddress, blob, action);
   HicWrapper_uint32_t(&object_p->signalHostAttentionAddress, blob, action);
} /* HicWrapper_hic_ctrl_scb_error_ind_t */

void HicWrapper_m80211_nrp_mlme_set_scanparam_req_t(m80211_nrp_mlme_set_scanparam_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_nrp_mlme_scan_config_t(&object_p->config, blob, action);
} /* HicWrapper_m80211_nrp_mlme_set_scanparam_req_t */

void HicWrapper_m80211_nrp_mlme_set_scanparam_cfm_t(m80211_nrp_mlme_set_scanparam_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_m80211_nrp_mlme_set_scanparam_cfm_t */

void HicWrapper_m80211_nrp_mlme_add_scanfilter_req_t(m80211_nrp_mlme_add_scanfilter_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->filter_id, blob, action);
   HicWrapper_int32_t(&object_p->rssi_threshold, blob, action);
   HicWrapper_uint32_t(&object_p->snr_threshold, blob, action);
   HicWrapper_uint16_t(&object_p->threshold_type, blob, action);
   HicWrapper_uint8_t(&object_p->bss_type, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_m80211_nrp_mlme_add_scanfilter_req_t */

void HicWrapper_m80211_nrp_mlme_add_scanfilter_cfm_t(m80211_nrp_mlme_add_scanfilter_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->filter_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_m80211_nrp_mlme_add_scanfilter_cfm_t */

void HicWrapper_m80211_nrp_mlme_remove_scanfilter_req_t(m80211_nrp_mlme_remove_scanfilter_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->filter_id, blob, action);
} /* HicWrapper_m80211_nrp_mlme_remove_scanfilter_req_t */

void HicWrapper_m80211_nrp_mlme_remove_scanfilter_cfm_t(m80211_nrp_mlme_remove_scanfilter_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->filter_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_m80211_nrp_mlme_remove_scanfilter_cfm_t */

void HicWrapper_m80211_nrp_mlme_add_scanjob_req_t(m80211_nrp_mlme_add_scanjob_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
   HicWrapper_uint32_t(&object_p->filter_id, blob, action);
   HicWrapper_uint16_t(&object_p->channels, blob, action);
   HicWrapper_uint8_t(&object_p->prio, blob, action);
   HicWrapper_uint8_t(&object_p->as_exclude, blob, action);
   HicWrapper_uint8_t(&object_p->scan_type, blob, action);
   HicWrapper_uint8_t(&object_p->scan_mode, blob, action);
   HicWrapper_uint8_t(&object_p->run_every_nth_period, blob, action);
   HicWrapper_array_t((char*)object_p->bssid, (sizeof(char)*M802_ADDRESS_SIZE), blob, action);
   HicWrapper_uint8_t(&object_p->ssid_id, blob, action);
   HicWrapper_uint8_t(&object_p->ssid_len, blob, action);
   HicWrapper_array_t((char*)object_p->ssid, (sizeof(char)*M80211_IE_MAX_LENGTH_SSID), blob, action);
} /* HicWrapper_m80211_nrp_mlme_add_scanjob_req_t */

void HicWrapper_m80211_nrp_mlme_add_scanjob_cfm_t(m80211_nrp_mlme_add_scanjob_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_m80211_nrp_mlme_add_scanjob_cfm_t */

void HicWrapper_m80211_nrp_mlme_remove_scanjob_req_t(m80211_nrp_mlme_remove_scanjob_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
} /* HicWrapper_m80211_nrp_mlme_remove_scanjob_req_t */

void HicWrapper_m80211_nrp_mlme_remove_scanjob_cfm_t(m80211_nrp_mlme_remove_scanjob_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_m80211_nrp_mlme_remove_scanjob_cfm_t */

void HicWrapper_m80211_nrp_mlme_get_scanfilter_req_t(m80211_nrp_mlme_get_scanfilter_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->filter_id, blob, action);
} /* HicWrapper_m80211_nrp_mlme_get_scanfilter_req_t */

void HicWrapper_m80211_nrp_mlme_get_scanfilter_cfm_t(m80211_nrp_mlme_get_scanfilter_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->filter_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
   HicWrapper_int32_t(&object_p->rssi_threshold, blob, action);
   HicWrapper_uint32_t(&object_p->snr_threshold, blob, action);
   HicWrapper_uint16_t(&object_p->threshold_type, blob, action);
   HicWrapper_uint8_t(&object_p->bss_type, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_hic_ctrl_get_scanfilter_cfm_t */

void HicWrapper_m80211_nrp_mlme_set_scanjobstate_req_t(m80211_nrp_mlme_set_scanjobstate_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
   HicWrapper_uint8_t(&object_p->state, blob, action);
   HicWrapper_array_t((char*)object_p->reserved, (sizeof(uint8_t)*3), blob, action);
} /* HicWrapper_m80211_nrp_mlme_set_scanjobstate_req_t */

void HicWrapper_m80211_nrp_mlme_set_scanjobstate_cfm_t(m80211_nrp_mlme_set_scanjobstate_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_m80211_nrp_mlme_set_scanjobstate_cfm_t */

void HicWrapper_m80211_nrp_mlme_scannotification_ind_t(m80211_nrp_mlme_scannotification_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->job_id, blob, action);
   HicWrapper_uint16_t(&object_p->flags, blob, action);
   HicWrapper_array_t((char*)object_p->filler, 2, blob, action);
} /* HicWrapper_m80211_nrp_mlme_scannotification_ind_t */

void HicWrapper_m80211_nrp_mlme_set_scancountryinfo_req_t(m80211_nrp_mlme_set_scancountryinfo_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_ie_country_t(&object_p->country_info_set, blob, action);
} /* HicWrapper_m80211_nrp_mlme_set_scancountryinfo_req_t */

void HicWrapper_m80211_nrp_mlme_set_scancountryinfo_cfm_t(m80211_nrp_mlme_set_scancountryinfo_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
} /* HicWrapper_m80211_nrp_mlme_set_scancountryinfo_cfm_t */

#if (DE_CCX == CFG_INCLUDED)
void HicWrapper_m80211_nrp_mlme_addts_cfm_t(m80211_nrp_mlme_addts_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_m80211_mlme_result_t(&object_p->value, blob, action);
   HicWrapper_uint16_t(&object_p->padding, blob, action);
} /* HicWrapper_m80211_nrp_mlme_addts_cfm_t */

void HicWrapper_m80211_nrp_mlme_addts_ind_t(m80211_nrp_mlme_addts_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
    HicWrapper_uint32_t(&object_p->action_code, blob, action);
    HicWrapper_m80211_nrp_mlme_addts_req_body_t(&object_p->body, blob, action);
}

void HicWrapper_m80211_nrp_mlme_delts_cfm_t (m80211_nrp_mlme_delts_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
   HicWrapper_uint32_t(&object_p->value, blob, action);
} /* HicWrapper_m80211_nrp_mlme_delts_cfm_t */

void HicWrapper_m80211_nrp_mlme_addts_req_t (m80211_nrp_mlme_addts_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
    HicWrapper_uint32_t(&object_p->action_code, blob, action);
    HicWrapper_m80211_nrp_mlme_addts_req_body_t(&object_p->body, blob, action);

} /* HicWrapper_m80211_mlme_addts_req_t */

void HicWrapper_m80211_wmm_action_t (m80211_wmm_action_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    HicWrapper_uint8_t(&object_p->category, blob, action);
    HicWrapper_uint8_t(&object_p->action_code, blob, action);
    HicWrapper_uint8_t(&object_p->dialog_token, blob, action);
    HicWrapper_uint8_t(&object_p->status_code, blob, action);
}
/* HicWrapper_m80211_wmm_action_t */

void HicWrapper_m80211_nrp_mlme_addts_req_body_t(m80211_nrp_mlme_addts_req_body_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    HicWrapper_uint8_t(&object_p->dialog_token, blob, action);
    HicWrapper_uint8_t(&object_p->status_code, blob, action);
    HicWrapper_m80211_wmm_tspec_ie_t(&object_p->wmm_tspec_ie, blob, action);
}/*HicWrapper_m80211_nrp_mlme_addts_req_body_t*/

void HicWrapper_m80211_nrp_mlme_delts_req_t(m80211_nrp_mlme_delts_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
    HicWrapper_uint32_t(&object_p->action_code, blob, action);
    HicWrapper_uint8_t(&object_p->dialog_token, blob, action);
    HicWrapper_uint8_t(&object_p->status_code, blob, action);
    HicWrapper_m80211_wmm_tspec_ie_t(&object_p->wmm_tspec_ie, blob, action);
/*
    MacWrapper_m80211_ie_WMM_header_t(&object_p->WMM_hdr, blob, action, WMM_IE_OUI_SUBTYPE_TSPEC);
    HicWrapper_uint8_t(&object_p->WMM_Protocol_Version, blob, action);
    HicWrapper_array_t((char*)object_p->ts_info, (sizeof(uint8_t)*3), blob, action);
    HicWrapper_uint8_t(&object_p->reason_code, blob, action);
*/
}

void HicWrapper_m80211_nrp_mlme_fw_stats_req_t(m80211_nrp_mlme_fw_stats_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
    HicWrapper_uint32_t(&object_p->init, blob, action);
} /* HicWrapper_m80211_nrp_mlme_get_fw_stats_req_t */

void HicWrapper_m80211_nrp_mlme_fw_stats_cfm_t(m80211_nrp_mlme_fw_stats_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
    HicWrapper_uint32_t(&object_p->pkt_xmit_delay_total, blob, action);
    HicWrapper_uint16_t(&object_p->pkt_xmitted_cnt, blob, action);
    HicWrapper_bool_t(&object_p->init, blob, action);
    HicWrapper_uint8_t(&object_p->padding, blob, action);
} /* HicWrapper_m80211_mlme_send_fw_stats_ind_t */
#endif //DE_CCX
void HicWrapper_hic_ctrl_msg_body_t(hic_ctrl_msg_body_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->transid, blob, action);
} /* HicWrapper_hic_ctrl_msg_body_t */

void HicWrapper_hic_ctrl_hl_sync_req_t(hic_ctrl_hl_sync_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
}

void HicWrapper_hic_ctrl_hl_sync_cfm_t(hic_ctrl_hl_sync_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint32_t(&object_p->result, blob, action);
   HicWrapper_m80211_mac_addr_t(&object_p->src_addr, blob, action);
   HicWrapper_uint16_t(&object_p->seqno, blob, action);
   HicWrapper_uint32_t(&object_p->rx_timestamp, blob, action);
   HicWrapper_array_t((char*)object_p->pad, sizeof(object_p->pad), blob, action);
   HicWrapper_uint32_t(&object_p->hic_timestamp, blob, action);
}

static void HicWrapper_string(char *object_p, Blob_t* blob, WrapperAction_t action)
{
   int length;
   if(action == ACTION_UNPACK) {
      length = BLOB_REMAINING_SIZE(blob);
      HicWrapper_array_t(object_p, length, blob, action);
      object_p[length] = '\0';
   } else {
      length = DE_STRLEN(object_p); /* must not include
				       zero-termination */
      HicWrapper_array_t(object_p, length, blob, action);
   }
}

void HicWrapper_hic_mac_console_req_t(hic_mac_console_req_t *object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_string(((char*)object_p + offsetof(hic_mac_console_req_t, string)) , blob, action);
} /* HicWrapper_hic_mac_console_req_t */

void HicWrapper_hic_mac_console_cfm_t(hic_mac_console_cfm_t *object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_uint8_t(&object_p->result, blob, action);
} /* HicWrapper_hic_mac_console_cfm_t */

void HicWrapper_hic_mac_console_ind_t(hic_mac_console_ind_t *object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->trans_id, blob, action);
   HicWrapper_string(((char*)object_p + offsetof(hic_mac_console_req_t, string)) , blob, action);
} /* HicWrapper_hic_mac_console_ind_t */

void HicWrapper_hic_dlm_load_req_t(hic_dlm_load_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->transid, blob, action);
   HicWrapper_uint32_t(&object_p->address, blob, action);
   HicWrapper_uint32_t(&object_p->remaining_size, blob, action);
   HicWrapper_uint32_t(&object_p->checksum, blob, action);
   HicWrapper_uint32_t(&object_p->reserved, blob, action);
   HicWrapper_varstring_t(&object_p->page, blob, action);
} /* HicWrapper_hic_dlm_load_req_t */

void HicWrapper_hic_dlm_load_failed_ind_t(hic_dlm_load_failed_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->transid, blob, action);
} /* HicWrapper_hic_dlm_load_failed_ind_t */



void HicWrapper_hic_dlm_load_cfm_t(hic_dlm_load_cfm_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->transid, blob, action);
   HicWrapper_uint32_t(&object_p->address, blob, action);
   HicWrapper_uint32_t(&object_p->size, blob, action);
   HicWrapper_uint32_t(&object_p->remaining_size, blob, action);
} /* HicWrapper_mlme_mib_set_req_t */

void HicWrapper_hic_dlm_swap_ind_t(hic_dlm_swap_ind_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   HicWrapper_mac_api_transid_t(&object_p->transid, blob, action);
   HicWrapper_uint32_t(&object_p->load_memory_address, blob, action);
   HicWrapper_uint32_t(&object_p->size, blob, action);
   HicWrapper_uint32_t(&object_p->reserved, blob, action);
} /* HicWrapper_mlme_mib_set_req_t */


/*****************************************************************************
G L O B A L   A C C E S S   F U N C T I O N S
*****************************************************************************/

/******************************* END OF FILE ********************************/


