static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2017 Thomas Manni <thomas.manni@free.fr>                         \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_boolean (squared, _(\"squared integral\"), FALSE)                    \n"
"  description (_(\"Add squared values sum to the output\"))                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME         integral_image                                   \n"
"#define GEGL_OP_C_SOURCE     integral-image.c                                 \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define SQR(x) ((x) * (x))                                                    \n"
"                                                                              \n"
"static inline void                                                            \n"
"compute_row_integral (gdouble  *src_row,                                      \n"
"                      gdouble  *top_row,                                      \n"
"                      gdouble  *dst_row,                                      \n"
"                      gint      width,                                        \n"
"                      gint      n_components,                                 \n"
"                      gboolean  squared)                                      \n"
"{                                                                             \n"
"  gint b;                                                                     \n"
"                                                                              \n"
"  if (squared)                                                                \n"
"    {                                                                         \n"
"      while (width--)                                                         \n"
"        {                                                                     \n"
"          for (b = 0; b < n_components; b++)                                  \n"
"            {                                                                 \n"
"              dst_row[b] = src_row[b] +                                       \n"
"                           dst_row[b - n_components] +                        \n"
"                           top_row[b] -                                       \n"
"                           top_row[b - n_components];                         \n"
"                                                                              \n"
"              dst_row[b + n_components] =   SQR(src_row[b])                   \n"
"                                          + dst_row[b - n_components * 2]     \n"
"                                          + top_row[b + n_components]         \n"
"                                          - top_row[b - n_components * 2];    \n"
"            }                                                                 \n"
"                                                                              \n"
"          src_row += n_components;                                            \n"
"          top_row += n_components * 2;                                        \n"
"          dst_row += n_components * 2;                                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      while (width--)                                                         \n"
"        {                                                                     \n"
"          for (b = 0; b < n_components; b++)                                  \n"
"            dst_row[b] =   src_row[b]                                         \n"
"                         + dst_row[b - n_components]                          \n"
"                         + top_row[b]                                         \n"
"                         - top_row[b - n_components];                         \n"
"                                                                              \n"
"          src_row += n_components;                                            \n"
"          top_row += n_components;                                            \n"
"          dst_row += n_components;                                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *src_format   = gegl_operation_get_source_format (operation, \"input\");\n"
"  const Babl *input_format = babl_format (\"RGB double\");                    \n"
"  gint        n_components = 3;                                               \n"
"  const Babl *output_format;                                                  \n"
"                                                                              \n"
"  if (src_format)                                                             \n"
"    {                                                                         \n"
"      const Babl *model = babl_format_get_model (src_format);                 \n"
"                                                                              \n"
"      if (model == babl_model (\"RGB\") || model == babl_model (\"R'G'B'\") ||\n"
"          model == babl_model (\"RGBA\") || model == babl_model (\"R'G'B'A\"))\n"
"        {                                                                     \n"
"          input_format = babl_format (\"RGB double\");                        \n"
"          n_components = 3;                                                   \n"
"        }                                                                     \n"
"      else if (model == babl_model (\"Y\") || model == babl_model (\"Y'\") || \n"
"               model == babl_model (\"YA\") || model == babl_model (\"Y'A\")) \n"
"        {                                                                     \n"
"          input_format = babl_format (\"Y double\");                          \n"
"          n_components = 1;                                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (o->squared)                                                             \n"
"    n_components *= 2;                                                        \n"
"                                                                              \n"
"  output_format = babl_format_n (babl_type (\"double\"), n_components);       \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", input_format);             \n"
"  gegl_operation_set_format (operation, \"output\", output_format);           \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o        = GEGL_PROPERTIES (operation);                     \n"
"  const Babl *src_format   = gegl_operation_get_source_format (operation, \"input\");\n"
"  const Babl *dst_format   = gegl_operation_get_format (operation, \"output\");\n"
"  gint        src_components = babl_format_get_n_components (src_format);     \n"
"  gint        dst_components = babl_format_get_n_components (dst_format);     \n"
"                                                                              \n"
"  gint     width, height;                                                     \n"
"  gint     row_size;                                                          \n"
"  gint     y;                                                                 \n"
"  gdouble *top_row  = NULL;                                                   \n"
"  gdouble *dst_row  = NULL;                                                   \n"
"  gdouble *src_row  = NULL;                                                   \n"
"  gdouble *p_top    = NULL;                                                   \n"
"  gdouble *p_dst    = NULL;                                                   \n"
"                                                                              \n"
"  width = gegl_buffer_get_width (input);                                      \n"
"  height = gegl_buffer_get_height (input);                                    \n"
"  row_size = width + 1;                                                       \n"
"                                                                              \n"
"  top_row = g_new0 (gdouble, row_size * dst_components);                      \n"
"  dst_row = g_new0 (gdouble, row_size * dst_components);                      \n"
"  src_row = g_new  (gdouble, row_size * src_components);                      \n"
"                                                                              \n"
"  p_top = top_row;                                                            \n"
"  p_dst = dst_row;                                                            \n"
"                                                                              \n"
"  for (y = 0; y < height; y++)                                                \n"
"    {                                                                         \n"
"      GeglRectangle row_rect = {-1, y, width + 1, 1};                         \n"
"                                                                              \n"
"      gegl_buffer_get (input, &row_rect, 1.0, src_format, src_row,            \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"                                                                              \n"
"      compute_row_integral (src_row + src_components,                         \n"
"                            p_top + dst_components,                           \n"
"                            p_dst + dst_components,                           \n"
"                            width,                                            \n"
"                            src_components,                                   \n"
"                            o->squared);                                      \n"
"                                                                              \n"
"      gegl_buffer_set (output, &row_rect, 0, dst_format, p_dst,               \n"
"                       GEGL_AUTO_ROWSTRIDE);                                  \n"
"                                                                              \n"
"      p_top = p_dst;                                                          \n"
"                                                                              \n"
"      if (p_dst == top_row)                                                   \n"
"        p_dst = dst_row;                                                      \n"
"      else                                                                    \n"
"        p_dst = top_row;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (top_row);                                                           \n"
"  g_free (dst_row);                                                           \n"
"  g_free (src_row);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *region)                         \n"
"{                                                                             \n"
"  GeglRectangle result;                                                       \n"
"  result.x = 0;                                                               \n"
"  result.y = 0;                                                               \n"
"  result.width = region->x + region->width;                                   \n"
"  result.height = region->y + region->height;                                 \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_invalidated_by_change (GeglOperation       *operation,                    \n"
"                           const gchar         *input_pad,                    \n"
"                           const GeglRectangle *input_region)                 \n"
"{                                                                             \n"
"  GeglRectangle  result;                                                      \n"
"  GeglRectangle *src = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (!src)                                                                   \n"
"    return *input_region;                                                     \n"
"                                                                              \n"
"  result.x = input_region->x;                                                 \n"
"  result.y = input_region->y;                                                 \n"
"  result.width  = src->width - input_region->x;                               \n"
"  result.height = src->height - input_region->y;                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process                      = process;                       \n"
"  operation_class->get_cached_region         = get_cached_region;             \n"
"  operation_class->get_invalidated_by_change = get_invalidated_by_change;     \n"
"  operation_class->get_required_for_output   = get_required_for_output;       \n"
"  operation_class->prepare                   = prepare;                       \n"
"  operation_class->threaded                  = FALSE;                         \n"
"  operation_class->opencl_support            = FALSE;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:integral-image\",                                 \n"
"    \"title\",       _(\"Integral Image\"),                                   \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", _(\"Compute integral and squared integral image\"),      \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
