static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2011 Jon Nordby <jononor@gmail.com>                              \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"property_string  (window_title, _(\"Window title\"), \"window_title\")        \n"
"    description(_(\"Title to be given to output window\"))                    \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_NAME     display                                              \n"
"#define GEGL_OP_C_SOURCE display.c                                            \n"
"                                                                              \n"
"#include \"gegl-plugin.h\"                                                    \n"
"                                                                              \n"
"/* gegl:display                                                               \n"
" * Meta operation for displaying the output of a buffer.                      \n"
" * Will use one of several well-known display operations                      \n"
" * to actually display the output. */                                         \n"
"                                                                              \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationSink parent_instance;                                          \n"
"  gpointer          properties;                                               \n"
"                                                                              \n"
"  GeglNode *input; /* The node to show the output of. */                      \n"
"  GeglNode *display; /* The node actually acting as the display op. */        \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationSinkClass parent_class;                                        \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"GEGL_DEFINE_DYNAMIC_OPERATION(GEGL_TYPE_OPERATION_SINK)                       \n"
"                                                                              \n"
"/* Set the correct display handler operation. */                              \n"
"static void                                                                   \n"
"set_display_handler (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties  *o    = GEGL_PROPERTIES (operation);                        \n"
"  GeglOp   *self = GEGL_OP (operation);                                       \n"
"  const gchar *known_handlers[] = {\"gegl-gtk3:display\",                     \n"
"                                   \"gegl-gtk2:display\",                     \n"
"                                   \"gegl:sdl-display\"};                     \n"
"  char *handler = NULL;                                                       \n"
"  gchar **operations = NULL;                                                  \n"
"  guint   n_operations;                                                       \n"
"  gint i, j;                                                                  \n"
"                                                                              \n"
"  /* FIXME: Allow operations to register as a display handler. */             \n"
"  operations = gegl_list_operations (&n_operations);                          \n"
"                                                                              \n"
"  for (i=0; !handler && i < G_N_ELEMENTS(known_handlers); i++)                \n"
"    {                                                                         \n"
"      for (j=0; j < n_operations; j++)                                        \n"
"      {                                                                       \n"
"         if (g_strcmp0(operations[j], known_handlers[i]) == 0)                \n"
"           {                                                                  \n"
"             handler = operations[j];                                         \n"
"             break;                                                           \n"
"           }                                                                  \n"
"      }                                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (handler)                                                                \n"
"      gegl_node_set (self->display, \"operation\", handler,                   \n"
"                     \"window-title\", o->window_title, NULL);                \n"
"  else                                                                        \n"
"      g_warning (\"No display handler operation found for gegl:display\");    \n"
"                                                                              \n"
"  g_free (operations);                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"/* Create an input proxy, and initial display operation, and link together.   \n"
" * These will be passed control when process is called later. */              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglOp   *self = GEGL_OP (operation);                                       \n"
"                                                                              \n"
"  g_assert (!self->input);                                                    \n"
"  g_assert (!self->display);                                                  \n"
"                                                                              \n"
"  self->input   = gegl_node_get_input_proxy (operation->node, \"input\");     \n"
"  self->display = gegl_node_new_child (operation->node,                       \n"
"                                       \"operation\", \"gegl:nop\",           \n"
"                                       NULL);                                 \n"
"  gegl_node_link (self->input, self->display);                                \n"
"                                                                              \n"
"  set_display_handler (operation);                                            \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* Forward processing to the handler operation. */                            \n"
"static gboolean                                                               \n"
"process (GeglOperation        *operation,                                     \n"
"         GeglOperationContext *context,                                       \n"
"         const gchar          *output_pad,                                    \n"
"         const GeglRectangle  *roi,                                           \n"
"         gint                  level)                                         \n"
"{                                                                             \n"
"  GeglOp   *self = GEGL_OP (operation);                                       \n"
"                                                                              \n"
"  return gegl_operation_process (gegl_node_get_gegl_operation (self->display),\n"
"                                 context, output_pad, roi, level);            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class = GEGL_OPERATION_CLASS (klass);     \n"
"  GeglOperationSinkClass *sink_class = GEGL_OPERATION_SINK_CLASS (klass);     \n"
"                                                                              \n"
"  operation_class->attach  = attach;                                          \n"
"  operation_class->process = process;                                         \n"
"                                                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"        , \"gegl:display\",                                       \n"
"    \"categories\"  , \"meta:display\",                                       \n"
"    \"title\"       , _(\"Display\"),                                         \n"
"    \"description\" ,                                                         \n"
"    _(\"Display the input buffer in a window.\"),                             \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
