static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2012 Pavel Roschin <roshin@scriptumplus.ru>                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (radius, _(\"Radius\"), 4)                                       \n"
"   description(_(\"Radius of square pixel region, (width and height will be radius*2+1)\"))\n"
"   value_range (0, 1000)                                                      \n"
"   ui_range    (0, 100)                                                       \n"
"   ui_gamma   (1.5)                                                           \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     box_blur                                             \n"
"#define GEGL_OP_C_SOURCE box-blur.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define SRC_OFFSET (row + u + radius * 2) * 4                                 \n"
"                                                                              \n"
"static void                                                                   \n"
"hor_blur (GeglBuffer          *src,                                           \n"
"          const GeglRectangle *src_rect,                                      \n"
"          GeglBuffer          *dst,                                           \n"
"          const GeglRectangle *dst_rect,                                      \n"
"          gint                 radius)                                        \n"
"{                                                                             \n"
"  gint u,v;                                                                   \n"
"  gint i;                                                                     \n"
"  gint offset;                                                                \n"
"  gint src_offset;                                                            \n"
"  gint prev_rad = radius * 4 + 4;                                             \n"
"  gint next_rad = radius * 4;                                                 \n"
"  gint row;                                                                   \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"  gfloat rad1 = 1.0 / (gfloat)(radius * 2 + 1);                               \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, src_rect->width * src_rect->height * 4);          \n"
"  dst_buf = g_new0 (gfloat, dst_rect->width * dst_rect->height * 4);          \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0, babl_format (\"RaGaBaA float\"),       \n"
"                   src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);           \n"
"                                                                              \n"
"  offset = 0;                                                                 \n"
"  for (v = 0; v < dst_rect->height; v++)                                      \n"
"    {                                                                         \n"
"      /* here just radius, not radius * 2 as in ver_blur beacuse              \n"
"       * we enlarged dst_buf by y earlier */                                  \n"
"      row = (v + radius) * src_rect->width;                                   \n"
"      /* prepare - set first column of pixels */                              \n"
"      for (u = -radius; u <= radius; u++)                                     \n"
"        {                                                                     \n"
"          src_offset = SRC_OFFSET;                                            \n"
"          for (i = 0; i < 4; i++)                                             \n"
"            dst_buf[offset + i] += src_buf[src_offset + i] * rad1;            \n"
"        }                                                                     \n"
"      offset += 4;                                                            \n"
"      /* iterate other pixels by moving a window - very fast */               \n"
"      for (u = 1; u < dst_rect->width; u++)                                   \n"
"        {                                                                     \n"
"          src_offset = SRC_OFFSET;                                            \n"
"          for (i = 0; i < 4; i++)                                             \n"
"          {                                                                   \n"
"            dst_buf[offset] = dst_buf[offset - 4]                             \n"
"                            - src_buf[src_offset - prev_rad] * rad1           \n"
"                            + src_buf[src_offset + next_rad] * rad1;          \n"
"            src_offset++;                                                     \n"
"            offset++;                                                         \n"
"          }                                                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (dst, dst_rect, 0, babl_format (\"RaGaBaA float\"),         \n"
"                   dst_buf, GEGL_AUTO_ROWSTRIDE);                             \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"ver_blur (GeglBuffer          *src,                                           \n"
"          const GeglRectangle *src_rect,                                      \n"
"          GeglBuffer          *dst,                                           \n"
"          const GeglRectangle *dst_rect,                                      \n"
"          gint                 radius)                                        \n"
"{                                                                             \n"
"  gint u, v;                                                                  \n"
"  gint i;                                                                     \n"
"  gint offset;                                                                \n"
"  gint src_offset;                                                            \n"
"  gint prev_rad = (radius * 4 + 4) * src_rect->width;                         \n"
"  gint next_rad = (radius * 4) * src_rect->width;                             \n"
"  gint row;                                                                   \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"  gfloat rad1 = 1.0 / (gfloat)(radius * 2 + 1);                               \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, src_rect->width * src_rect->height * 4);          \n"
"  dst_buf = g_new0 (gfloat, dst_rect->width * dst_rect->height * 4);          \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0, babl_format (\"RaGaBaA float\"),       \n"
"                   src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);           \n"
"                                                                              \n"
"  /* prepare: set first row of pixels */                                      \n"
"  for (v = -radius; v <= radius; v++)                                         \n"
"    {                                                                         \n"
"      row = (v + radius * 2) * src_rect->width;                               \n"
"      for (u = 0; u < dst_rect->width; u++)                                   \n"
"        {                                                                     \n"
"          src_offset = SRC_OFFSET;                                            \n"
"          for (i = 0; i < 4; i++)                                             \n"
"            dst_buf[u * 4 + i] += src_buf[src_offset + i] * rad1;             \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  /* skip first row */                                                        \n"
"  offset = dst_rect->width * 4;                                               \n"
"  for (v = 1; v < dst_rect->height; v++)                                      \n"
"    {                                                                         \n"
"      row = (v + radius * 2) * src_rect->width;                               \n"
"      for (u = 0; u < dst_rect->width; u++)                                   \n"
"        {                                                                     \n"
"          src_offset = SRC_OFFSET;                                            \n"
"          for (i = 0; i < 4; i++)                                             \n"
"          {                                                                   \n"
"            dst_buf[offset] = dst_buf[offset - 4 * dst_rect->width]           \n"
"                            - src_buf[src_offset - prev_rad] * rad1           \n"
"                            + src_buf[src_offset + next_rad] * rad1;          \n"
"            src_offset++;                                                     \n"
"            offset++;                                                         \n"
"          }                                                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (dst, dst_rect, 0, babl_format (\"RaGaBaA float\"),         \n"
"                   dst_buf, GEGL_AUTO_ROWSTRIDE);                             \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#undef SRC_OFFSET                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties              *o;                                             \n"
"  GeglOperationAreaFilter *op_area;                                           \n"
"                                                                              \n"
"  op_area = GEGL_OPERATION_AREA_FILTER (operation);                           \n"
"  o       = GEGL_PROPERTIES (operation);                                      \n"
"                                                                              \n"
"  op_area->left   =                                                           \n"
"  op_area->right  =                                                           \n"
"  op_area->top    =                                                           \n"
"  op_area->bottom = o->radius;                                                \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RaGaBaA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/box-blur.cl.h\"                                             \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"static gboolean                                                               \n"
"cl_box_blur (cl_mem                in_tex,                                    \n"
"             cl_mem                aux_tex,                                   \n"
"             cl_mem                out_tex,                                   \n"
"             size_t                global_worksize,                           \n"
"             const GeglRectangle  *roi,                                       \n"
"             gint                  radius)                                    \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  size_t global_ws_hor[2], global_ws_ver[2], global_ws[2];                    \n"
"  size_t local_ws_hor[2], local_ws_ver[2], local_ws[2];                       \n"
"  size_t step_size ;                                                          \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = { \"kernel_blur_hor\", \"kernel_blur_ver\",\"kernel_box_blur_fast\", NULL};\n"
"      cl_data = gegl_cl_compile_and_build (box_blur_cl_source, kernel_name);  \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"  step_size = 64;                                                             \n"
"  local_ws[0]=256;                                                            \n"
"  local_ws[1]=1;                                                              \n"
"                                                                              \n"
"                                                                              \n"
"  if( radius <=110 )                                                          \n"
"  {                                                                           \n"
"    global_ws[0] = (roi->width + local_ws[0] - 2 * radius - 1) / ( local_ws[0] - 2 * radius ) * local_ws[0];\n"
"    global_ws[1] = (roi->height + step_size - 1) / step_size;                 \n"
"    cl_err = gegl_cl_set_kernel_args(cl_data->kernel[2],                      \n"
"                                     sizeof(cl_mem), (void *)&in_tex,         \n"
"                                     sizeof(cl_mem), (void *)&out_tex,        \n"
"                                     sizeof(cl_float4)*local_ws[0], (void *)NULL,\n"
"                                     sizeof(cl_int), (void *)&roi->width,     \n"
"                                     sizeof(cl_int), (void *)&roi->height,    \n"
"                                     sizeof(cl_int), (void *)&radius,         \n"
"                                     sizeof(cl_int), (void *)&step_size, NULL);\n"
"    CL_CHECK;                                                                 \n"
"    cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue(),         \n"
"                                         cl_data->kernel[2], 2,               \n"
"                                         NULL, global_ws, local_ws, 0, NULL, NULL );\n"
"       CL_CHECK;                                                              \n"
"                                                                              \n"
"  }                                                                           \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    local_ws_hor[0] = 1;                                                      \n"
"    local_ws_hor[1] = 256;                                                    \n"
"    global_ws_hor[0] = roi->height + 2 * radius;                              \n"
"    global_ws_hor[1] = ((roi->width + local_ws_hor[1] -1)/local_ws_hor[1]) * local_ws_hor[1];\n"
"                                                                              \n"
"    local_ws_ver[0] = 1;                                                      \n"
"    local_ws_ver[1] = 256;                                                    \n"
"    global_ws_ver[0] = roi->height;                                           \n"
"    global_ws_ver[1] = ((roi->width + local_ws_ver[1] -1)/local_ws_ver[1]) * local_ws_ver[1];\n"
"                                                                              \n"
"                                                                              \n"
"    cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                     \n"
"                                      sizeof(cl_mem), (void*)&in_tex,         \n"
"                                      sizeof(cl_mem), (void*)&aux_tex,        \n"
"                                      sizeof(cl_int), (void*)&roi->width,     \n"
"                                      sizeof(cl_int), (void*)&radius,         \n"
"                                      NULL);                                  \n"
"    CL_CHECK;                                                                 \n"
"    cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),       \n"
"                                          cl_data->kernel[0], 2,              \n"
"                                          NULL, global_ws_hor, local_ws_hor,  \n"
"                                          0, NULL, NULL);                     \n"
"    CL_CHECK;                                                                 \n"
"                                                                              \n"
"                                                                              \n"
"    cl_err = gegl_cl_set_kernel_args (cl_data->kernel[1],                     \n"
"                                      sizeof(cl_mem), (void*)&aux_tex,        \n"
"                                      sizeof(cl_mem), (void*)&out_tex,        \n"
"                                      sizeof(cl_int), (void*)&roi->width,     \n"
"                                      sizeof(cl_int), (void*)&radius,         \n"
"                                      NULL);                                  \n"
"    CL_CHECK;                                                                 \n"
"                                                                              \n"
"    cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),       \n"
"                                          cl_data->kernel[1], 2,              \n"
"                                          NULL, global_ws_ver, local_ws_ver,  \n"
"                                          0, NULL, NULL);                     \n"
"    CL_CHECK;                                                                 \n"
"  }                                                                           \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"                                                                              \n"
"  gint err = 0;                                                               \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_CLAMP);               \n"
"                                                                              \n"
"  gint aux = gegl_buffer_cl_iterator_add_aux (i,                              \n"
"                                              result,                         \n"
"                                              in_format,                      \n"
"                                              0,                              \n"
"                                              0,                              \n"
"                                              op_area->top,                   \n"
"                                              op_area->bottom);               \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err) && !err)                      \n"
"    {                                                                         \n"
"      err = cl_box_blur (i->tex[read],                                        \n"
"                         i->tex[aux],                                         \n"
"                         i->tex[0],                                           \n"
"                         i->size[0],                                          \n"
"                         &i->roi[0],                                          \n"
"                         o->radius);                                          \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        {                                                                     \n"
"          gegl_buffer_cl_iterator_stop (i);                                   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return !err;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglRectangle rect;                                                         \n"
"  GeglRectangle tmprect;                                                      \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglBuffer *temp;                                                           \n"
"  GeglOperationAreaFilter *op_area;                                           \n"
"  op_area = GEGL_OPERATION_AREA_FILTER (operation);                           \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, output, result))                        \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  rect = *result;                                                             \n"
"  tmprect = *result;                                                          \n"
"                                                                              \n"
"  rect.x       -= op_area->left * 2;                                          \n"
"  rect.y       -= op_area->top * 2;                                           \n"
"  rect.width   += (op_area->left + op_area->right) * 2;                       \n"
"  rect.height  += (op_area->top + op_area->bottom) * 2;                       \n"
"  /* very tricky: enlarge temp buffer to avoid seams in second pass */        \n"
"  tmprect.y      -= o->radius;                                                \n"
"  tmprect.height += o->radius * 2;                                            \n"
"                                                                              \n"
"  temp  = gegl_buffer_new (&tmprect,                                          \n"
"                           babl_format (\"RaGaBaA float\"));                  \n"
"                                                                              \n"
"  /* doing second pass in separate gegl op may be significantly faster */     \n"
"  hor_blur (input, &rect, temp, &tmprect, o->radius);                         \n"
"  ver_blur (temp, &rect, output, result, o->radius);                          \n"
"                                                                              \n"
"  g_object_unref (temp);                                                      \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",        \"gegl:box-blur\",                                     \n"
"      \"title\",       _(\"Box Blur\"),                                       \n"
"      \"categories\",  \"blur\",                                              \n"
"      \"description\", _(\"Blur resulting from averaging the colors of a square neighbourhood.\"),\n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
