static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" *                                                                            \n"
" * Copyright 2012 Maxime Nicco <maxime.nicco@gmail.com>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int   (holdness, _(\"Holdness\"), 2)                                 \n"
"   value_range (1, 8)                                                         \n"
"                                                                              \n"
"property_double (lightness_distance, _(\"Lightness\"), 40.0)                  \n"
"   value_range  (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (chroma_distance, _(\"Chroma\"), 40.0)                        \n"
"   value_range  (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (hue_distance, _(\"Hue\"), 3.0)                               \n"
"   value_range  (0.0, 180.0)                                                  \n"
"                                                                              \n"
"property_seed   (seed, _(\"Random seed\"), rand)                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     noise_cie_lch                                        \n"
"#define GEGL_OP_C_SOURCE noise-cie-lch.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include \"gegl.h\"                                                           \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"static gfloat                                                                 \n"
"randomize_value (gfloat      now,                                             \n"
"                 gfloat      min,                                             \n"
"                 gfloat      max,                                             \n"
"                 gboolean    wraps_around,                                    \n"
"                 gfloat      rand_max,                                        \n"
"                 gint        holdness,                                        \n"
"                 gint        x,                                               \n"
"                 gint        y,                                               \n"
"                 gint        n,                                               \n"
"                 GeglRandom *rand)                                            \n"
"{                                                                             \n"
"  gint    flag, i;                                                            \n"
"  gfloat rand_val, new_val, steps;                                            \n"
"                                                                              \n"
"  steps = max - min + 0.5;                                                    \n"
"  rand_val = gegl_random_float (rand, x, y, 0, n++);                          \n"
"                                                                              \n"
"  for (i = 1; i < holdness; i++)                                              \n"
"  {                                                                           \n"
"    float tmp = gegl_random_float (rand, x, y, 0, n++);                       \n"
"    if (tmp < rand_val)                                                       \n"
"      rand_val = tmp;                                                         \n"
"  }                                                                           \n"
"                                                                              \n"
"  flag = (gegl_random_float (rand, x, y, 0, n) < 0.5) ? -1 : 1;               \n"
"  new_val = now + flag * fmod (rand_max * rand_val, steps);                   \n"
"                                                                              \n"
"  if (new_val < min)                                                          \n"
"  {                                                                           \n"
"    if (wraps_around)                                                         \n"
"      new_val += steps;                                                       \n"
"    else                                                                      \n"
"      new_val = min;                                                          \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (max < new_val)                                                          \n"
"  {                                                                           \n"
"    if (wraps_around)                                                         \n"
"      new_val -= steps;                                                       \n"
"    else                                                                      \n"
"      new_val = max;                                                          \n"
"  }                                                                           \n"
"                                                                              \n"
"  return new_val;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\" ,                           \n"
"                             babl_format (\"CIE LCH(ab) alpha float\"));      \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"CIE LCH(ab) alpha float\"));      \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat         *GEGL_ALIGNED in_pixel;                                      \n"
"  gfloat         *GEGL_ALIGNED out_pixel;                                     \n"
"  GeglRectangle   whole_region;                                               \n"
"  gfloat          lightness, chroma, hue, alpha;                              \n"
"  gint            i;                                                          \n"
"  gint            x, y;                                                       \n"
"                                                                              \n"
"  in_pixel  = in_buf;                                                         \n"
"  out_pixel = out_buf;                                                        \n"
"                                                                              \n"
"  x = roi->x;                                                                 \n"
"  y = roi->y;                                                                 \n"
"                                                                              \n"
"  whole_region = *(gegl_operation_source_get_bounding_box (operation, \"input\"));\n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"  {                                                                           \n"
"    /* n is independent from the roi, but from the whole image */             \n"
"    gint n = (3 * o->holdness + 4) * (x + whole_region.width * y);            \n"
"                                                                              \n"
"    lightness = in_pixel[0];                                                  \n"
"    chroma    = in_pixel[1];                                                  \n"
"    hue       = in_pixel[2];                                                  \n"
"    alpha     = in_pixel[3];                                                  \n"
"                                                                              \n"
"    if ((o->hue_distance > 0) && (chroma > 0))                                \n"
"      hue = randomize_value (hue, 0.0, 359.0, TRUE, o->hue_distance,          \n"
"                             o->holdness, x, y, n, o->rand);                  \n"
"                                                                              \n"
"    n += o->holdness + 1;                                                     \n"
"    if (o->chroma_distance > 0) {                                             \n"
"      if (chroma == 0)                                                        \n"
"        hue = gegl_random_float_range (o->rand, x, y, 0, n, 0.0, 360.0);      \n"
"      chroma = randomize_value (chroma, 0.0, 100.0, FALSE, o->chroma_distance,\n"
"                                o->holdness, x, y, n+1, o->rand);             \n"
"    }                                                                         \n"
"                                                                              \n"
"    n += o->holdness + 2;                                                     \n"
"    if (o->lightness_distance > 0)                                            \n"
"      lightness = randomize_value (lightness, 0.0, 100.0, FALSE,              \n"
"                                   o->lightness_distance, o->holdness,        \n"
"                                   x, y, n, o->rand);                         \n"
"                                                                              \n"
"    /*n += o->holdness + 1*/                                                  \n"
"    out_pixel[0] = lightness;                                                 \n"
"    out_pixel[1] = chroma;                                                    \n"
"    out_pixel[2] = hue;                                                       \n"
"    out_pixel[3] = alpha;                                                     \n"
"                                                                              \n"
"    in_pixel  += 4;                                                           \n"
"    out_pixel += 4;                                                           \n"
"                                                                              \n"
"    x++;                                                                      \n"
"    if (x >= roi->x + roi->width)                                             \n"
"      {                                                                       \n"
"        x = roi->x;                                                           \n"
"        y++;                                                                  \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare    = prepare;                                      \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:noise-cie-lch\",                                  \n"
"    \"title\",       _(\"Add CIE Lch Noise\"),                                \n"
"    \"categories\",  \"noise\",                                               \n"
"    \"description\", _(\"Randomize lightness, chroma and hue independently\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
