static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2014 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include \"gegl.h\"                                                           \n"
"#include \"gegl-node-private.h\" /* to fish out the cache */                  \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"  property_object (cache, _(\"Cache\"), GEGL_TYPE_BUFFER)                     \n"
"      description (_(\"NULL or a GeglBuffer containing cached rendering results, this is a special buffer where gegl_buffer_list_valid_rectangles returns the part of the cache that is valid.\"))\n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     cache                                                \n"
"#define GEGL_OP_C_SOURCE cache.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format = gegl_operation_get_source_format (operation, \"input\");\n"
"                                                                              \n"
"  if (! format)                                                               \n"
"    format = babl_format (\"RGBA float\");                                    \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  format);                  \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o  = GEGL_PROPERTIES (operation);                           \n"
"  const Babl *format = gegl_operation_get_format (operation, \"input\");      \n"
"                                                                              \n"
"  memcpy (out_buf, in_buf, n_pixels * babl_format_get_bytes_per_pixel (format));\n"
"                                                                              \n"
"  if (o->cache != (void *) operation->node->cache)                            \n"
"    {                                                                         \n"
"      if (o->cache)                                                           \n"
"        {                                                                     \n"
"          g_object_unref (o->cache);                                          \n"
"          o->cache = NULL;                                                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (operation->node->cache)                                             \n"
"        o->cache = g_object_ref (operation->node->cache);                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->no_cache      = FALSE;                                     \n"
"  operation_class->want_in_place = FALSE;                                     \n"
"  operation_class->prepare       = prepare;                                   \n"
"  point_filter_class->process    = process;                                   \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:cache\",                                          \n"
"    \"title\",       _(\"Explicit cache of results at this point of graph.\"),\n"
"    \"categories\",  \"programming\",                                         \n"
"    \"description\", _(\"An explicit caching node\"),                         \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
