static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007 Mark Probst <mark.probst@gmail.com>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (sampling_points, _(\"Sample points\"), 0)                       \n"
"  description (_(\"Number of curve sampling points.  0 for exact calculation.\"))\n"
"  value_range (0, 65536)                                                      \n"
"                                                                              \n"
"property_curve (curve, _(\"Curve\"), NULL)                                    \n"
"  description (_(\"The contrast curve.\"))                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     contrast_curve                                       \n"
"#define GEGL_OP_C_SOURCE contrast-curve.c                                     \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"YA float\");                            \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl/gegl-debug.h\"                                                \n"
"                                                                              \n"
"#include \"opencl/contrast-curve.cl.h\"                                       \n"
"                                                                              \n"
"/* TODO : Replace gegl_curve_calc_values and gegl_curve_calc_value in cl_process\n"
"          with something more suitable for the cl version*/                   \n"
"                                                                              \n"
"static void                                                                   \n"
"copy_double_array_to_float_array (gdouble *in,                                \n"
"                                  gfloat  *out,                               \n"
"                                  gint     size)                              \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"  for (i = 0; i < size; ++i)                                                  \n"
"    out[i] = (gfloat) in[i];                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglClRunData * cl_data = NULL;                                        \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *self,                                        \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (self);                                 \n"
"  gint       num_sampling_points;                                             \n"
"  gdouble    *xs, *ys;                                                        \n"
"  gfloat     *ysf = NULL;                                                     \n"
"  cl_mem     cl_curve = NULL;                                                 \n"
"  cl_ulong   cl_max_constant_size;                                            \n"
"  cl_int     cl_err = 0;                                                      \n"
"                                                                              \n"
"  num_sampling_points = o->sampling_points;                                   \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"cl_contrast_curve\",NULL};               \n"
"      cl_data = gegl_cl_compile_and_build (contrast_curve_cl_source,          \n"
"                                           kernel_name);                      \n"
"    }                                                                         \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  if (num_sampling_points > 0)                                                \n"
"    {                                                                         \n"
"      xs = g_new (gdouble, num_sampling_points);                              \n"
"      ys = g_new (gdouble, num_sampling_points);                              \n"
"                                                                              \n"
"      gegl_curve_calc_values (o->curve, 0.0, 1.0, num_sampling_points, xs, ys);\n"
"      g_free (xs);                                                            \n"
"                                                                              \n"
"      /*We need to downscale the array to pass it to the GPU*/                \n"
"      ysf = g_new (gfloat, num_sampling_points);                              \n"
"      copy_double_array_to_float_array (ys, ysf, num_sampling_points);        \n"
"      g_free (ys);                                                            \n"
"                                                                              \n"
"      cl_err = gegl_clGetDeviceInfo (gegl_cl_get_device (),                   \n"
"                                     CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE,      \n"
"                                     sizeof (cl_ulong),                       \n"
"                                     &cl_max_constant_size,                   \n"
"                                     NULL);                                   \n"
"      CL_CHECK;                                                               \n"
"                                                                              \n"
"      GEGL_NOTE (GEGL_DEBUG_OPENCL, \"Max Constant Mem Size: %lu bytes\",     \n"
"                 (unsigned long) cl_max_constant_size);                       \n"
"                                                                              \n"
"      if (sizeof (cl_float) * num_sampling_points < cl_max_constant_size)     \n"
"        {                                                                     \n"
"          cl_curve = gegl_clCreateBuffer (gegl_cl_get_context (),             \n"
"                                          CL_MEM_USE_HOST_PTR | CL_MEM_READ_ONLY,\n"
"                                          num_sampling_points * sizeof (cl_float),\n"
"                                          ysf, &cl_err);                      \n"
"          CL_CHECK;                                                           \n"
"          cl_err = gegl_clSetKernelArg (cl_data->kernel[0], 0, sizeof (cl_mem),\n"
"                                        (void*) &in_tex);                     \n"
"          CL_CHECK;                                                           \n"
"          cl_err = gegl_clSetKernelArg (cl_data->kernel[0], 1, sizeof (cl_mem),\n"
"                                        (void*) &out_tex);                    \n"
"          CL_CHECK;                                                           \n"
"          cl_err = gegl_clSetKernelArg (cl_data->kernel[0], 2, sizeof (cl_mem),\n"
"                                        (void*) &cl_curve);                   \n"
"          CL_CHECK;                                                           \n"
"          cl_err = gegl_clSetKernelArg (cl_data->kernel[0], 3, sizeof (gint), \n"
"                                        (void*) &num_sampling_points);        \n"
"          CL_CHECK;                                                           \n"
"          cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (), \n"
"                                                cl_data->kernel[0], 1,        \n"
"                                                NULL, &global_worksize, NULL, \n"
"                                                0, NULL, NULL);               \n"
"          CL_CHECK;                                                           \n"
"                                                                              \n"
"          cl_err = gegl_clFinish (gegl_cl_get_command_queue ());              \n"
"          CL_CHECK;                                                           \n"
"                                                                              \n"
"          cl_err = gegl_clReleaseMemObject (cl_curve);                        \n"
"          CL_CHECK_ONLY (cl_err);                                             \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          /*If the curve size doesn't fit constant memory is better to use CPU*/\n"
"          GEGL_NOTE (GEGL_DEBUG_OPENCL,                                       \n"
"                     \"Not enough constant memory for the curve\");           \n"
"          g_free (ysf);                                                       \n"
"          return TRUE;                                                        \n"
"        }                                                                     \n"
"                                                                              \n"
"      g_free (ysf);                                                           \n"
"      return FALSE;                                                           \n"
"error:                                                                        \n"
"      if (ysf)                                                                \n"
"        g_free (ysf);                                                         \n"
"      if (cl_curve)                                                           \n"
"        gegl_clReleaseMemObject (cl_curve);                                   \n"
"                                                                              \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"  else  /*If the curve doesn't have a lookup table is better to use CPU*/     \n"
"    {                                                                         \n"
"      GEGL_NOTE (GEGL_DEBUG_OPENCL,                                           \n"
"                 \"Curve not suitable to be computed in the GPU\");           \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  gint        num_sampling_points;                                            \n"
"  GeglCurve  *curve;                                                          \n"
"  gint i;                                                                     \n"
"  gfloat  *in  = in_buf;                                                      \n"
"  gfloat  *out = out_buf;                                                     \n"
"  gdouble *xs, *ys;                                                           \n"
"                                                                              \n"
"  num_sampling_points = o->sampling_points;                                   \n"
"  curve = o->curve;                                                           \n"
"                                                                              \n"
"  if (num_sampling_points > 0)                                                \n"
"  {                                                                           \n"
"    xs = g_new(gdouble, num_sampling_points);                                 \n"
"    ys = g_new(gdouble, num_sampling_points);                                 \n"
"                                                                              \n"
"    gegl_curve_calc_values(o->curve, 0.0, 1.0, num_sampling_points, xs, ys);  \n"
"                                                                              \n"
"    g_free(xs);                                                               \n"
"                                                                              \n"
"    for (i=0; i<samples; i++)                                                 \n"
"    {                                                                         \n"
"      gint x = in[0] * num_sampling_points;                                   \n"
"      gfloat y;                                                               \n"
"                                                                              \n"
"      if (x < 0)                                                              \n"
"       y = ys[0];                                                             \n"
"      else if (x >= num_sampling_points)                                      \n"
"       y = ys[num_sampling_points - 1];                                       \n"
"      else                                                                    \n"
"       y = ys[x];                                                             \n"
"                                                                              \n"
"      out[0] = y;                                                             \n"
"      out[1]=in[1];                                                           \n"
"                                                                              \n"
"      in += 2;                                                                \n"
"      out+= 2;                                                                \n"
"    }                                                                         \n"
"                                                                              \n"
"    g_free(ys);                                                               \n"
"  }                                                                           \n"
"  else                                                                        \n"
"    for (i=0; i<samples; i++)                                                 \n"
"    {                                                                         \n"
"      gfloat u = in[0];                                                       \n"
"                                                                              \n"
"      out[0] = gegl_curve_calc_value(curve, u);                               \n"
"      out[1]=in[1];                                                           \n"
"                                                                              \n"
"      in += 2;                                                                \n"
"      out+= 2;                                                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:contrast-curve\",                                 \n"
"    \"title\",       _(\"Contrast Curve\"),                                   \n"
"    \"categories\" , \"color\",                                               \n"
"    \"description\",                                                          \n"
"        _(\"Adjusts the contrast of a grayscale image with a curve specifying contrast for intensity.\"),\n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
