static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * This operation is a port of the GIMP Apply lens plug-in                    \n"
" * Copyright (C) 1997 Morten Eriksen mortene@pvv.ntnu.no                      \n"
" *                                                                            \n"
" * Porting to GEGL:                                                           \n"
" * Copyright 2013 Emanuel Schrade <emanuel.schrade@student.kit.edu>           \n"
" * Copyright 2013 Stephan Seifermann <stephan.seifermann@student.kit.edu>     \n"
" * Copyright 2013 Bastian Pirk <bastian.pirk@student.kit.edu>                 \n"
" * Copyright 2013 Pascal Giessler <pascal.giessler@student.kit.edu>           \n"
" * Copyright 2015 Thomas Manni <thomas.manni@free.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
"/* TODO: Find some better algorithm to calculate the roi for each dest        \n"
" *       rectangle. Right now it simply asks for the entire image...          \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (refraction_index, _(\"Lens refraction index\"), 1.7)         \n"
"  value_range (1.0, 100.0)                                                    \n"
"  ui_range    (1.0, 10.0)                                                     \n"
"  ui_gamma    (3.0)                                                           \n"
"                                                                              \n"
"property_boolean (keep_surroundings, _(\"Keep original surroundings\"), FALSE)\n"
"  description(_(\"Keep image unchanged, where not affected by the lens.\"))   \n"
"                                                                              \n"
"property_color (background_color, _(\"Background color\"), \"none\")          \n"
"  ui_meta (\"role\", \"color-secondary\")                                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     apply_lens                                           \n"
"#define GEGL_OP_C_SOURCE apply-lens.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gfloat  bg_color[4];                                                        \n"
"  gdouble a, b, c;                                                            \n"
"  gdouble asqr, bsqr, csqr;                                                   \n"
"} AlParamsType;                                                               \n"
"                                                                              \n"
"/**                                                                           \n"
" * Computes the original position (ox, oy) of the                             \n"
" * distorted point (x, y) after passing through the lens                      \n"
" * which is given by its center and its refraction index.                     \n"
" * See: Ellipsoid formula: x^2/a^2 + y^2/b^2 + z^2/c^2 = 1.                   \n"
" */                                                                           \n"
"static void                                                                   \n"
"find_undistorted_pos (gdouble       x,                                        \n"
"                      gdouble       y,                                        \n"
"                      gdouble       refraction,                               \n"
"                      AlParamsType *params,                                   \n"
"                      gdouble      *ox,                                       \n"
"                      gdouble      *oy)                                       \n"
"{                                                                             \n"
"  gdouble z;                                                                  \n"
"  gdouble nxangle, nyangle, theta1, theta2;                                   \n"
"  gdouble ri1 = 1.0;                                                          \n"
"  gdouble ri2 = refraction;                                                   \n"
"                                                                              \n"
"  z = sqrt ((1 - x * x / params->asqr - y * y / params->bsqr) * params->csqr);\n"
"                                                                              \n"
"  nxangle = acos (x / sqrt(x * x + z * z));                                   \n"
"  theta1 = G_PI / 2.0 - nxangle;                                              \n"
"  theta2 = asin (sin (theta1) * ri1 / ri2);                                   \n"
"  theta2 = G_PI / 2.0 - nxangle - theta2;                                     \n"
"  *ox = x - tan (theta2) * z;                                                 \n"
"                                                                              \n"
"  nyangle = acos (y / sqrt (y * y + z * z));                                  \n"
"  theta1 = G_PI / 2.0 - nyangle;                                              \n"
"  theta2 = asin (sin (theta1) * ri1 / ri2);                                   \n"
"  theta2 = G_PI / 2.0 - nyangle - theta2;                                     \n"
"  *oy = y - tan (theta2) * z;                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"                                                                              \n"
"  GeglRectangle  *whole_region;                                               \n"
"  AlParamsType   *params;                                                     \n"
"                                                                              \n"
"  if (! o->user_data)                                                         \n"
"    o->user_data = g_slice_new0 (AlParamsType);                               \n"
"                                                                              \n"
"  params = (AlParamsType *) o->user_data;                                     \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (whole_region)                                                           \n"
"    {                                                                         \n"
"      params->a = 0.5 * whole_region->width;                                  \n"
"      params->b = 0.5 * whole_region->height;                                 \n"
"      params->c = MIN (params->a, params->b);                                 \n"
"      params->asqr = params->a * params->a;                                   \n"
"      params->bsqr = params->b * params->b;                                   \n"
"      params->csqr = params->c * params->c;                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->background_color, format, params->bg_color);       \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_slice_free (AlParamsType, o->user_data);                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"  else                                                                        \n"
"    return *in_rect;                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties       *o = GEGL_PROPERTIES (operation);                      \n"
"  AlParamsType    *params = (AlParamsType *) o->user_data;                    \n"
"  const Babl      *format = babl_format (\"RGBA float\");                     \n"
"                                                                              \n"
"  GeglSampler        *sampler;                                                \n"
"  GeglBufferIterator *iter;                                                   \n"
"  gint                x, y;                                                   \n"
"                                                                              \n"
"  sampler = gegl_buffer_sampler_new_at_level (input, format,                  \n"
"                                              GEGL_SAMPLER_CUBIC, level);     \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (output, roi, level, format,                \n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, input, roi, level, format,                  \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gfloat *out_pixel = iter->data[0];                                      \n"
"      gfloat *in_pixel  = iter->data[1];                                      \n"
"                                                                              \n"
"      for (y = iter->roi->y; y < iter->roi->y + iter->roi->height; y++)       \n"
"        {                                                                     \n"
"          gdouble dy, dysqr;                                                  \n"
"                                                                              \n"
"          dy = -((gdouble) y - params->b + 0.5);                              \n"
"          dysqr = dy * dy;                                                    \n"
"                                                                              \n"
"          for (x = iter->roi->x; x < iter->roi->x + iter->roi->width; x++)    \n"
"            {                                                                 \n"
"              gdouble dx, dxsqr;                                              \n"
"                                                                              \n"
"              dx = (gdouble) x - params->a + 0.5;                             \n"
"              dxsqr = dx * dx;                                                \n"
"                                                                              \n"
"              if (dysqr < (params->bsqr - (params->bsqr * dxsqr) / params->asqr))\n"
"                {                                                             \n"
"                  /**                                                         \n"
"                   * If (x, y) is inside the affected region, we can find its original\n"
"                   * position and fetch the pixel with the sampler            \n"
"                   */                                                         \n"
"                  gdouble ox, oy;                                             \n"
"                  find_undistorted_pos (dx, dy, o->refraction_index, params,  \n"
"                                        &ox, &oy);                            \n"
"                                                                              \n"
"                  gegl_sampler_get (sampler, ox + params->a, params->b - oy,  \n"
"                                    NULL, out_pixel, GEGL_ABYSS_NONE);        \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  /**                                                         \n"
"                   * Otherwise (that is for pixels outside the lens), we could either leave\n"
"                   * the image data unchanged, or set it to a specified 'background_color',\n"
"                   * depending on the user input.                             \n"
"                   */                                                         \n"
"                  if (o->keep_surroundings)                                   \n"
"                    memcpy (out_pixel, in_pixel, sizeof (gfloat) * 4);        \n"
"                  else                                                        \n"
"                    memcpy (out_pixel, params->bg_color, sizeof (gfloat) * 4);\n"
"                }                                                             \n"
"                                                                              \n"
"              out_pixel += 4;                                                 \n"
"              in_pixel  += 4;                                                 \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass             *object_class;                                     \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"  gchar                    *composition =                                     \n"
"    \"<?xml version='1.0' encoding='UTF-8'?>\"                                \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:apply-lens'>\"                                    \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='refraction_index'>1.7</param>\"                        \n"
"    \"    <param name='keep_surroundings'>false</param>\"                     \n"
"    \"    <param name='background_color'>rgba(0, 0.50196, 0.50196, 0.75)</param>\"\n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  object_class->finalize                   = finalize;                        \n"
"  operation_class->threaded                = FALSE;                           \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  filter_class->process                    = process;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:apply-lens\",                                     \n"
"    \"title\",       _(\"Apply Lens\"),                                       \n"
"    \"categories\",  \"map\",                                                 \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Simulates the optical distortion caused by having \" \n"
"                     \"an elliptical lens over the image\"),                  \n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
