
enum sndrv_pcm_format
{
  SNDRV_PCM_FORMAT_S8 = 0,
  SNDRV_PCM_FORMAT_U8,
  SNDRV_PCM_FORMAT_S16_LE,
  SNDRV_PCM_FORMAT_S16_BE,
  SNDRV_PCM_FORMAT_U16_LE,
  SNDRV_PCM_FORMAT_U16_BE,
  SNDRV_PCM_FORMAT_S24_LE,	/* low three bytes */
  SNDRV_PCM_FORMAT_S24_BE,	/* low three bytes */
  SNDRV_PCM_FORMAT_U24_LE,	/* low three bytes */
  SNDRV_PCM_FORMAT_U24_BE,	/* low three bytes */
  SNDRV_PCM_FORMAT_S32_LE,
  SNDRV_PCM_FORMAT_S32_BE,
  SNDRV_PCM_FORMAT_U32_LE,
  SNDRV_PCM_FORMAT_U32_BE,
  SNDRV_PCM_FORMAT_FLOAT_LE,	/* 4-byte float, IEEE-754 32-bit, range -1.0 to 1.0 */
  SNDRV_PCM_FORMAT_FLOAT_BE,	/* 4-byte float, IEEE-754 32-bit, range -1.0 to 1.0 */
  SNDRV_PCM_FORMAT_FLOAT64_LE,	/* 8-byte float, IEEE-754 64-bit, range -1.0 to 1.0 */
  SNDRV_PCM_FORMAT_FLOAT64_BE,	/* 8-byte float, IEEE-754 64-bit, range -1.0 to 1.0 */
  SNDRV_PCM_FORMAT_IEC958_SUBFRAME_LE,	/* IEC-958 subframe, Little Endian */
  SNDRV_PCM_FORMAT_IEC958_SUBFRAME_BE,	/* IEC-958 subframe, Big Endian */
  SNDRV_PCM_FORMAT_MU_LAW,
  SNDRV_PCM_FORMAT_A_LAW,
  SNDRV_PCM_FORMAT_IMA_ADPCM,
  SNDRV_PCM_FORMAT_MPEG,
  SNDRV_PCM_FORMAT_GSM,
  SNDRV_PCM_FORMAT_SPECIAL = 31,
  SNDRV_PCM_FORMAT_S24_3LE = 32,	/* in three bytes */
  SNDRV_PCM_FORMAT_S24_3BE,	/* in three bytes */
  SNDRV_PCM_FORMAT_U24_3LE,	/* in three bytes */
  SNDRV_PCM_FORMAT_U24_3BE,	/* in three bytes */
  SNDRV_PCM_FORMAT_S20_3LE,	/* in three bytes */
  SNDRV_PCM_FORMAT_S20_3BE,	/* in three bytes */
  SNDRV_PCM_FORMAT_U20_3LE,	/* in three bytes */
  SNDRV_PCM_FORMAT_U20_3BE,	/* in three bytes */
  SNDRV_PCM_FORMAT_S18_3LE,	/* in three bytes */
  SNDRV_PCM_FORMAT_S18_3BE,	/* in three bytes */
  SNDRV_PCM_FORMAT_U18_3LE,	/* in three bytes */
  SNDRV_PCM_FORMAT_U18_3BE,	/* in three bytes */
  SNDRV_PCM_FORMAT_LAST = SNDRV_PCM_FORMAT_U18_3BE,

#ifdef SNDRV_LITTLE_ENDIAN
  SNDRV_PCM_FORMAT_S16 = SNDRV_PCM_FORMAT_S16_LE,
  SNDRV_PCM_FORMAT_U16 = SNDRV_PCM_FORMAT_U16_LE,
  SNDRV_PCM_FORMAT_S24 = SNDRV_PCM_FORMAT_S24_LE,
  SNDRV_PCM_FORMAT_U24 = SNDRV_PCM_FORMAT_U24_LE,
  SNDRV_PCM_FORMAT_S32 = SNDRV_PCM_FORMAT_S32_LE,
  SNDRV_PCM_FORMAT_U32 = SNDRV_PCM_FORMAT_U32_LE,
  SNDRV_PCM_FORMAT_FLOAT = SNDRV_PCM_FORMAT_FLOAT_LE,
  SNDRV_PCM_FORMAT_FLOAT64 = SNDRV_PCM_FORMAT_FLOAT64_LE,
  SNDRV_PCM_FORMAT_IEC958_SUBFRAME = SNDRV_PCM_FORMAT_IEC958_SUBFRAME_LE,
#endif
#ifdef SNDRV_BIG_ENDIAN
  SNDRV_PCM_FORMAT_S16 = SNDRV_PCM_FORMAT_S16_BE,
  SNDRV_PCM_FORMAT_U16 = SNDRV_PCM_FORMAT_U16_BE,
  SNDRV_PCM_FORMAT_S24 = SNDRV_PCM_FORMAT_S24_BE,
  SNDRV_PCM_FORMAT_U24 = SNDRV_PCM_FORMAT_U24_BE,
  SNDRV_PCM_FORMAT_S32 = SNDRV_PCM_FORMAT_S32_BE,
  SNDRV_PCM_FORMAT_U32 = SNDRV_PCM_FORMAT_U32_BE,
  SNDRV_PCM_FORMAT_FLOAT = SNDRV_PCM_FORMAT_FLOAT_BE,
  SNDRV_PCM_FORMAT_FLOAT64 = SNDRV_PCM_FORMAT_FLOAT64_BE,
  SNDRV_PCM_FORMAT_IEC958_SUBFRAME = SNDRV_PCM_FORMAT_IEC958_SUBFRAME_BE,
#endif
};

#define FORMAT(v) [SND_PCM_FORMAT_##v] = #v
static const char *snd_pcm_format_names[] = {
  FORMAT (S8),
  FORMAT (U8),
  FORMAT (S16_LE),
  FORMAT (S16_BE),
  FORMAT (U16_LE),
  FORMAT (U16_BE),
  FORMAT (S24_LE),
  FORMAT (S24_BE),
  FORMAT (U24_LE),
  FORMAT (U24_BE),
  FORMAT (S32_LE),
  FORMAT (S32_BE),
  FORMAT (U32_LE),
  FORMAT (U32_BE),
  FORMAT (FLOAT_LE),
  FORMAT (FLOAT_BE),
  FORMAT (FLOAT64_LE),
  FORMAT (FLOAT64_BE),
  FORMAT (IEC958_SUBFRAME_LE),
  FORMAT (IEC958_SUBFRAME_BE),
  FORMAT (MU_LAW),
  FORMAT (A_LAW),
  FORMAT (IMA_ADPCM),
  FORMAT (MPEG),
  FORMAT (GSM),
  FORMAT (SPECIAL),
  FORMAT (S24_3LE),
  FORMAT (S24_3BE),
  FORMAT (U24_3LE),
  FORMAT (U24_3BE),
  FORMAT (S20_3LE),
  FORMAT (S20_3BE),
  FORMAT (U20_3LE),
  FORMAT (U20_3BE),
  FORMAT (S18_3LE),
  FORMAT (S18_3BE),
  FORMAT (U18_3LE),
  FORMAT (U18_3BE),
};
