/*
 * Copyright (C) 2014 Michael Brown <mbrown@fensystems.co.uk>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

FILE_LICENCE ( GPL2_OR_LATER );

/** @file
 *
 * PNG self-tests
 *
 */

/* Forcibly enable assertions */
#undef NDEBUG

#include <string.h>
#include <assert.h>
#include <ipxe/pixbuf.h>
#include <ipxe/png.h>
#include <ipxe/test.h>
#include "pixbuf_test.h"

/** Define inline pixel data */
#define DATA(...) { __VA_ARGS__ }

/* Non-opaque alpha channel */
PIX ( alpha, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x06, 0x00, 0x00, 0x00, 0xf3, 0x1b, 0xaf, 0xbc,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x06,
	     0x62, 0x4b, 0x47, 0x44, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xa0,
	     0xbd, 0xa7, 0x93, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73,
	     0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a,
	     0x9c, 0x18, 0x00, 0x00, 0x01, 0x25, 0x49, 0x44, 0x41, 0x54, 0x18,
	     0xd3, 0x05, 0xc1, 0xcb, 0x2e, 0x03, 0x51, 0x00, 0x80, 0xe1, 0x7f,
	     0x6e, 0xa9, 0xe9, 0x65, 0x32, 0x53, 0x6d, 0xa5, 0x42, 0xd3, 0x34,
	     0x12, 0x0b, 0x0b, 0x1b, 0x04, 0x3b, 0x3b, 0x3b, 0x8f, 0xe1, 0x35,
	     0xbc, 0x81, 0x67, 0xf1, 0x10, 0x22, 0x11, 0x0b, 0x42, 0x68, 0x17,
	     0x5a, 0x42, 0x94, 0xd0, 0x9e, 0xe9, 0xf4, 0x4c, 0x67, 0x3a, 0x39,
	     0x33, 0xc7, 0xf7, 0x19, 0x97, 0xd7, 0xc5, 0x45, 0x7b, 0x3c, 0xc0,
	     0xd2, 0x8a, 0xa8, 0xea, 0xa3, 0x6d, 0x87, 0xc2, 0x6f, 0xe2, 0xa9,
	     0x39, 0x58, 0x0e, 0x69, 0x6e, 0xa0, 0x55, 0x42, 0xb8, 0xb0, 0x70,
	     0xa5, 0x60, 0xa5, 0xa4, 0x31, 0xea, 0x75, 0xec, 0x2c, 0xd7, 0x28,
	     0x95, 0x51, 0xff, 0x19, 0xd2, 0x7b, 0xba, 0x25, 0x2b, 0xb9, 0x8c,
	     0x8e, 0xcf, 0xf0, 0xc2, 0x2f, 0x6a, 0x71, 0x88, 0xca, 0x73, 0x22,
	     0xbf, 0xc9, 0x9a, 0x08, 0xf1, 0x3e, 0x5f, 0x49, 0x82, 0x26, 0x62,
	     0x77, 0x1f, 0x33, 0x13, 0x92, 0xd5, 0xc1, 0x3d, 0xe6, 0xf4, 0x8f,
	     0x49, 0x63, 0x93, 0xd8, 0xa9, 0xa0, 0xbf, 0xc7, 0xf4, 0xbb, 0x07,
	     0xd4, 0x06, 0x0f, 0x68, 0x39, 0xa7, 0xdf, 0xdd, 0xc3, 0x1b, 0x8f,
	     0x58, 0x3a, 0x65, 0x26, 0xc1, 0x06, 0x1f, 0xc1, 0x16, 0x26, 0xe1,
	     0x0c, 0x33, 0x92, 0x58, 0x51, 0x4c, 0x25, 0x9a, 0x32, 0xa9, 0xae,
	     0xf3, 0xdc, 0x39, 0x22, 0xff, 0x15, 0x68, 0x29, 0x11, 0x6e, 0x83,
	     0x74, 0xa9, 0x58, 0xa6, 0x19, 0x9f, 0xe5, 0x16, 0x33, 0xa3, 0x44,
	     0x94, 0x80, 0x1d, 0xfc, 0xbd, 0x93, 0x2a, 0x13, 0x65, 0x3a, 0xdc,
	     0x9c, 0x9c, 0x23, 0xdc, 0x06, 0x85, 0x08, 0xd9, 0xb9, 0xb9, 0xe2,
	     0x76, 0xfb, 0x94, 0xe6, 0xd7, 0x90, 0xb6, 0x75, 0x87, 0x23, 0xe7,
	     0xa4, 0x75, 0x93, 0xb0, 0x1c, 0x10, 0xe3, 0x60, 0x0b, 0xd7, 0x27,
	     0xe9, 0xee, 0xa1, 0x0d, 0x93, 0xa9, 0xe3, 0x43, 0x01, 0x5e, 0x26,
	     0x19, 0x74, 0xf6, 0x79, 0xe9, 0x1d, 0xd2, 0x7a, 0x7b, 0xc4, 0x4d,
	     0x26, 0x58, 0x9d, 0x1d, 0x72, 0x39, 0x63, 0x11, 0x67, 0x14, 0x96,
	     0xcd, 0x3f, 0x0a, 0xd4, 0x8b, 0x0b, 0x4d, 0xd7, 0xb9, 0xb6, 0x00,
	     0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65,
	     0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31,
	     0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a,
	     0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30,
	     0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58,
	     0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	     0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31,
	     0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b,
	     0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00,
	     0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x48637f, 0x54566c, 0x56566a, 0x4f5c72, 0x4e5e74, 0x4d667f,
	     0x546478, 0x54657b, 0x50647b, 0x506277, 0x485d78, 0x4c5770,
	     0x505a6f, 0x516378, 0x45617f, 0x525469, 0x5d4958, 0x67333d,
	     0x643641, 0x535369, 0x5b4b5c, 0x624654, 0x604452, 0x594c5d,
	     0x5b4455, 0x623643, 0x5e3e4e, 0x555668, 0x425979, 0x5c4151,
	     0x5e404e, 0x5d3d4b, 0x5e3947, 0x53475c, 0x475b77, 0x68323c,
	     0x5f3e4c, 0x455c77, 0x623744, 0x5f3848, 0x54475c, 0x475e7a,
	     0x425171, 0x5d3a4b, 0x603948, 0x633642, 0x553f54, 0x3e5679,
	     0x46516e, 0x682c36, 0x574356, 0x415975, 0x5f3341, 0x513d53,
	     0x4d475f, 0x405a7a, 0x4a4762, 0x59384c, 0x5b394b, 0x435676,
	     0x3b5b80, 0x3a5278, 0x5b3447, 0x4d405a, 0x573649, 0x4d445b,
	     0x612d3b, 0x4d3c54, 0x454c68, 0x3a5a7d, 0x424b6a, 0x464866,
	     0x454867, 0x3a597e, 0x3a5a80, 0x414f72, 0x484361, 0x33547d,
	     0x3e4467, 0x43405d, 0x4f3c50, 0x4b364d, 0x404765, 0x395b7f ) );

/* Colour type 0, bit depth 1 */
PIX ( ctype_0_1, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0xdb, 0x60, 0x92, 0x11,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x01, 0x86,
	     0xa0, 0x31, 0xe8, 0x96, 0x5f, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4b,
	     0x47, 0x44, 0x00, 0x01, 0xdd, 0x8a, 0x13, 0xa4, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x0e,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0xf8, 0xff, 0x87, 0x01,
	     0x15, 0x01, 0x00, 0x6b, 0x0d, 0x0b, 0xe3, 0xeb, 0x45, 0x62, 0x80,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45,
	     0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69,
	     0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d,
	     0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33,
	     0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00,
	     0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff ) );

/* Colour type 0, bit depth 16 */
PIX ( ctype_0_16, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x10, 0x00, 0x00, 0x00, 0x00, 0x86, 0xe0, 0x2c, 0x23,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x01, 0x86,
	     0xa0, 0x31, 0xe8, 0x96, 0x5f, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4b,
	     0x47, 0x44, 0xff, 0xff, 0x14, 0xab, 0x31, 0xcd, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x85,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x1d, 0x8e, 0xc9, 0x0a, 0xc2,
	     0x50, 0x0c, 0x45, 0xdf, 0x5f, 0xb9, 0x52, 0xea, 0xac, 0x88, 0xad,
	     0x58, 0x41, 0x70, 0x5e, 0x89, 0xb3, 0x82, 0x82, 0xa0, 0x9b, 0xb3,
	     0xe9, 0x42, 0x44, 0xc4, 0x3f, 0xf6, 0xb4, 0x84, 0x0c, 0x37, 0xb9,
	     0x37, 0x49, 0xc8, 0x38, 0x6b, 0x77, 0x9e, 0x7c, 0xf9, 0xf0, 0xe3,
	     0x4d, 0x26, 0x3a, 0x70, 0xe3, 0x45, 0x80, 0x2d, 0x33, 0xda, 0x74,
	     0xcc, 0x4b, 0xa6, 0x8c, 0x8d, 0xa9, 0xb8, 0xcf, 0x89, 0x70, 0x24,
	     0xd1, 0x7a, 0xc2, 0x94, 0xab, 0x94, 0xb8, 0x88, 0x39, 0x7a, 0x10,
	     0xe6, 0x85, 0x2a, 0xf7, 0x35, 0x0b, 0x6a, 0x12, 0x77, 0x54, 0xa9,
	     0x33, 0xc8, 0x95, 0xb1, 0x8d, 0x06, 0x1b, 0x2e, 0x8e, 0x22, 0x9a,
	     0x54, 0xdc, 0x52, 0xb6, 0x1a, 0x79, 0x37, 0x0c, 0x5d, 0x94, 0xb0,
	     0x97, 0x37, 0x51, 0xbd, 0xa2, 0xe5, 0x20, 0xa2, 0x44, 0xd7, 0x37,
	     0xff, 0x4c, 0xf2, 0x48, 0x0d, 0x2c, 0x7a, 0x80, 0xe2, 0x00, 0x00,
	     0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a,
	     0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34,
	     0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34,
	     0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2,
	     0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74,
	     0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	     0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32,
	     0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30,
	     0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00,
	     0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x858585, 0x6f6f6f, 0x6f6f6f, 0x777777, 0x7b7b7b, 0x8f8f8f,
	     0x8d8d8d, 0x919191, 0x8b8b8b, 0x858585, 0x777777, 0x6c6c6c,
	     0x747474, 0x898989, 0x808080, 0x696969, 0x5c5c5c, 0x474747,
	     0x484848, 0x696969, 0x5f5f5f, 0x5b5b5b, 0x575757, 0x5f5f5f,
	     0x535353, 0x474747, 0x4d4d4d, 0x6e6e6e, 0x6d6d6d, 0x4f4f4f,
	     0x4f4f4f, 0x4b4b4b, 0x474747, 0x535353, 0x737373, 0x484848,
	     0x4e4e4e, 0x737373, 0x484848, 0x474747, 0x535353, 0x7a7a7a,
	     0x5d5d5d, 0x474747, 0x484848, 0x474747, 0x484848, 0x666666,
	     0x5e5e5e, 0x424242, 0x4f4f4f, 0x6a6a6a, 0x414141, 0x434343,
	     0x505050, 0x6e6e6e, 0x4e4e4e, 0x424242, 0x444444, 0x686868,
	     0x707070, 0x5e5e5e, 0x404040, 0x454545, 0x3e3e3e, 0x4b4b4b,
	     0x3d3d3d, 0x404040, 0x545454, 0x6c6c6c, 0x525252, 0x4e4e4e,
	     0x4f4f4f, 0x6b6b6b, 0x6e6e6e, 0x5a5a5a, 0x484848, 0x606060,
	     0x464646, 0x404040, 0x404040, 0x373737, 0x494949, 0x6f6f6f ) );

/* Colour type 0, bit depth 2 */
PIX ( ctype_0_2, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x9c, 0xc0, 0xe8, 0xc1,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x01, 0x86,
	     0xa0, 0x31, 0xe8, 0x96, 0x5f, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4b,
	     0x47, 0x44, 0x00, 0x03, 0x33, 0x84, 0x72, 0x88, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x24,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x08, 0x0d, 0x0d, 0x0d,
	     0x60, 0x08, 0x11, 0x0d, 0x11, 0x60, 0x08, 0x10, 0x11, 0x08, 0x60,
	     0x70, 0x10, 0x09, 0x08, 0x60, 0x70, 0x0c, 0x00, 0xb2, 0x42, 0x43,
	     0x1d, 0x02, 0x00, 0x59, 0xc5, 0x06, 0x00, 0x68, 0xee, 0x01, 0x07,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45,
	     0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69,
	     0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d,
	     0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33,
	     0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00,
	     0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x555555, 0x555555, 0x555555, 0x555555, 0x555555, 0x555555,
	     0x555555, 0x555555, 0x555555, 0x555555, 0x555555, 0x555555,
	     0x555555, 0x555555, 0x555555, 0x555555, 0x555555, 0x000000,
	     0x000000, 0x555555, 0x555555, 0x555555, 0x555555, 0x555555,
	     0x555555, 0x000000, 0x000000, 0x555555, 0x555555, 0x555555,
	     0x000000, 0x000000, 0x000000, 0x555555, 0x555555, 0x000000,
	     0x000000, 0x555555, 0x000000, 0x000000, 0x555555, 0x555555,
	     0x555555, 0x000000, 0x000000, 0x000000, 0x000000, 0x555555,
	     0x555555, 0x000000, 0x555555, 0x555555, 0x000000, 0x000000,
	     0x555555, 0x555555, 0x555555, 0x000000, 0x000000, 0x555555,
	     0x555555, 0x555555, 0x000000, 0x000000, 0x000000, 0x555555,
	     0x000000, 0x000000, 0x555555, 0x555555, 0x555555, 0x555555,
	     0x555555, 0x555555, 0x555555, 0x555555, 0x555555, 0x555555,
	     0x555555, 0x000000, 0x000000, 0x000000, 0x555555, 0x555555 ) );

/* Colour type 0, bit depth 4 */
PIX ( ctype_0_4, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x13, 0x80, 0x1d, 0x61,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x01, 0x86,
	     0xa0, 0x31, 0xe8, 0x96, 0x5f, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4b,
	     0x47, 0x44, 0x00, 0x0f, 0x3a, 0x32, 0x3e, 0xa3, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x37,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x68, 0x4f, 0xaf, 0x9c,
	     0xd9, 0x5e, 0x56, 0xc1, 0x50, 0x96, 0xe2, 0x96, 0x1a, 0x1a, 0xe2,
	     0xc6, 0x90, 0xea, 0xe2, 0x5a, 0xe2, 0xee, 0x12, 0xce, 0x10, 0xe2,
	     0xe2, 0x16, 0xec, 0xe6, 0xe2, 0xce, 0xe0, 0xe2, 0x56, 0xe6, 0x62,
	     0x62, 0x02, 0xe4, 0xbb, 0x95, 0xba, 0x39, 0x1b, 0xbb, 0x03, 0x00,
	     0x7a, 0x4c, 0x0e, 0x45, 0x5a, 0x3c, 0xd1, 0xca, 0x00, 0x00, 0x00,
	     0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63,
	     0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d,
	     0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33,
	     0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4,
	     0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
	     0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00,
	     0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54,
	     0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31,
	     0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00,
	     0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x888888, 0x777777, 0x666666, 0x777777, 0x777777, 0x999999,
	     0x999999, 0x999999, 0x888888, 0x777777, 0x777777, 0x666666,
	     0x777777, 0x888888, 0x777777, 0x666666, 0x666666, 0x444444,
	     0x444444, 0x666666, 0x666666, 0x555555, 0x555555, 0x555555,
	     0x555555, 0x444444, 0x444444, 0x666666, 0x666666, 0x555555,
	     0x444444, 0x444444, 0x444444, 0x555555, 0x777777, 0x444444,
	     0x444444, 0x777777, 0x444444, 0x444444, 0x555555, 0x777777,
	     0x555555, 0x444444, 0x444444, 0x444444, 0x444444, 0x666666,
	     0x555555, 0x333333, 0x444444, 0x666666, 0x444444, 0x444444,
	     0x444444, 0x777777, 0x444444, 0x444444, 0x444444, 0x666666,
	     0x777777, 0x666666, 0x444444, 0x444444, 0x333333, 0x444444,
	     0x333333, 0x444444, 0x555555, 0x777777, 0x555555, 0x444444,
	     0x444444, 0x666666, 0x777777, 0x555555, 0x444444, 0x666666,
	     0x444444, 0x333333, 0x333333, 0x333333, 0x444444, 0x777777 ) );

/* Colour type 0, bit depth 8 */
PIX ( ctype_0_8, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0xd6, 0x70, 0xf0, 0x60,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x01, 0x86,
	     0xa0, 0x31, 0xe8, 0x96, 0x5f, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4b,
	     0x47, 0x44, 0x00, 0xff, 0x87, 0x8f, 0xcc, 0xbf, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x62,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x68, 0xcd, 0xcf, 0x2f,
	     0xaf, 0xee, 0xef, 0x9d, 0xd8, 0xdd, 0x5a, 0x9e, 0x53, 0xd2, 0xc9,
	     0xd0, 0x90, 0x19, 0xe3, 0xe1, 0x91, 0x19, 0x1f, 0x1d, 0x1e, 0x1f,
	     0xec, 0xee, 0x97, 0xc7, 0x90, 0xeb, 0x1f, 0xe0, 0xed, 0x1e, 0x5c,
	     0xec, 0xe9, 0x57, 0xec, 0xe9, 0x1e, 0x52, 0xc5, 0x10, 0xeb, 0xee,
	     0xe9, 0xee, 0x91, 0x16, 0xe7, 0xec, 0x9f, 0xe5, 0xe8, 0x1c, 0x90,
	     0xc7, 0xe0, 0xe7, 0xe4, 0x9a, 0x51, 0x10, 0xe7, 0xe0, 0x6a, 0xef,
	     0x6d, 0xe7, 0x10, 0x92, 0xc3, 0x10, 0xe4, 0xe7, 0x9f, 0x9d, 0x17,
	     0xe5, 0x91, 0xe8, 0xe6, 0xe0, 0x60, 0xee, 0x99, 0x0f, 0x00, 0xb8,
	     0xaa, 0x1e, 0x19, 0xe8, 0x28, 0x25, 0xa0, 0x00, 0x00, 0x00, 0x25,
	     0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72,
	     0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30,
	     0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a,
	     0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66,
	     0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
	     0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32,
	     0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32,
	     0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a,
	     0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49,
	     0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x858585, 0x6f6f6f, 0x6f6f6f, 0x777777, 0x7b7b7b, 0x8f8f8f,
	     0x8d8d8d, 0x919191, 0x8b8b8b, 0x858585, 0x777777, 0x6c6c6c,
	     0x747474, 0x898989, 0x808080, 0x696969, 0x5c5c5c, 0x484848,
	     0x484848, 0x696969, 0x5f5f5f, 0x5b5b5b, 0x575757, 0x5f5f5f,
	     0x535353, 0x474747, 0x4e4e4e, 0x6e6e6e, 0x6d6d6d, 0x4f4f4f,
	     0x505050, 0x4b4b4b, 0x474747, 0x535353, 0x737373, 0x494949,
	     0x4e4e4e, 0x737373, 0x494949, 0x474747, 0x545454, 0x7a7a7a,
	     0x5d5d5d, 0x474747, 0x494949, 0x474747, 0x484848, 0x666666,
	     0x5e5e5e, 0x434343, 0x4f4f4f, 0x6a6a6a, 0x414141, 0x434343,
	     0x505050, 0x6e6e6e, 0x4e4e4e, 0x424242, 0x454545, 0x686868,
	     0x707070, 0x5e5e5e, 0x404040, 0x454545, 0x3f3f3f, 0x4b4b4b,
	     0x3e3e3e, 0x404040, 0x545454, 0x6c6c6c, 0x525252, 0x4e4e4e,
	     0x4f4f4f, 0x6b6b6b, 0x6e6e6e, 0x5a5a5a, 0x484848, 0x616161,
	     0x464646, 0x404040, 0x404040, 0x373737, 0x494949, 0x6f6f6f ) );

/* Colour type 2, bit depth 16 */
PIX ( ctype_2_16, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x10, 0x02, 0x00, 0x00, 0x00, 0x2c, 0xe9, 0xe4, 0xa8,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x06,
	     0x62, 0x4b, 0x47, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x09,
	     0x58, 0xf7, 0xdc, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73,
	     0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a,
	     0x9c, 0x18, 0x00, 0x00, 0x01, 0x45, 0x49, 0x44, 0x41, 0x54, 0x18,
	     0xd3, 0x2d, 0xcb, 0xc1, 0x6e, 0xd2, 0x00, 0x00, 0x00, 0xd0, 0x47,
	     0x4b, 0x83, 0xb0, 0x8d, 0x00, 0x8e, 0x99, 0x19, 0x25, 0x64, 0x31,
	     0xf1, 0xb0, 0x83, 0x97, 0xcd, 0xa8, 0x37, 0x6f, 0xde, 0xfc, 0x0c,
	     0x7f, 0x83, 0x3f, 0xf0, 0x5b, 0xfc, 0x08, 0xb3, 0x64, 0xf1, 0xa0,
	     0xd1, 0xe8, 0x38, 0xb8, 0x69, 0x5c, 0x86, 0xc6, 0x41, 0x4b, 0x29,
	     0x83, 0x35, 0x2d, 0xf5, 0xe2, 0xbb, 0xbf, 0xda, 0xdb, 0xd1, 0xfb,
	     0xd1, 0x66, 0xb4, 0x6f, 0x62, 0x2c, 0x54, 0x29, 0xa4, 0xb6, 0x75,
	     0x54, 0xea, 0x22, 0x1b, 0x1d, 0x7d, 0x6d, 0x85, 0x05, 0x42, 0x91,
	     0xb5, 0x52, 0x4d, 0xa5, 0xb0, 0x92, 0xb8, 0x11, 0x6a, 0xca, 0xc4,
	     0xee, 0x68, 0xa8, 0xd4, 0xf4, 0xf4, 0xd4, 0x73, 0xa5, 0x4a, 0xa1,
	     0x90, 0xeb, 0xf9, 0xe3, 0xdc, 0x81, 0x2f, 0x4e, 0xe5, 0x1a, 0x9a,
	     0x2e, 0xbc, 0xf0, 0x5a, 0x5b, 0xe2, 0xca, 0x8e, 0xa5, 0x44, 0xa1,
	     0x54, 0x4a, 0x75, 0xf4, 0xdd, 0x13, 0x4b, 0xb4, 0x5d, 0xfa, 0x6e,
	     0xa5, 0xab, 0x2f, 0xf6, 0xc4, 0xb1, 0x20, 0x17, 0xcb, 0xdc, 0x35,
	     0xf6, 0x51, 0x60, 0xe6, 0xda, 0xd4, 0xae, 0x87, 0x96, 0x22, 0x5b,
	     0x2a, 0xbf, 0x4d, 0x9c, 0x19, 0x7a, 0x6a, 0xc7, 0xd8, 0x27, 0x95,
	     0xcc, 0xc2, 0x99, 0xa1, 0x23, 0x6d, 0x13, 0x17, 0x6e, 0x45, 0x5a,
	     0xa6, 0xba, 0x1e, 0xf8, 0xa5, 0xeb, 0x91, 0x80, 0xc4, 0x5c, 0x20,
	     0x95, 0x09, 0xa5, 0x96, 0xb6, 0xa4, 0x66, 0xa6, 0xb6, 0xdd, 0xf7,
	     0xd5, 0xc0, 0x73, 0xa5, 0xbf, 0x62, 0x95, 0x4c, 0x26, 0xd6, 0xb4,
	     0x6b, 0xed, 0x56, 0xe1, 0xd6, 0x5a, 0xee, 0x52, 0xcb, 0x9e, 0xb9,
	     0x9a, 0x86, 0xd4, 0x0a, 0xf5, 0xae, 0x6b, 0x3f, 0xad, 0x15, 0x02,
	     0x85, 0x40, 0xe4, 0xc4, 0x4b, 0x6f, 0xfe, 0xe7, 0x8d, 0x58, 0xe2,
	     0xd0, 0x89, 0x77, 0x4e, 0x3d, 0xf6, 0x4a, 0xdf, 0x95, 0x73, 0xfb,
	     0x42, 0x1f, 0x44, 0x32, 0x0b, 0x6b, 0x3d, 0x81, 0x44, 0x4b, 0xd7,
	     0x12, 0x91, 0x7a, 0xac, 0xa9, 0x63, 0x65, 0xe8, 0x48, 0xa5, 0x26,
	     0x30, 0x13, 0xe9, 0x60, 0x83, 0xb6, 0x5c, 0x66, 0x6c, 0xe0, 0xd8,
	     0x37, 0x07, 0x9e, 0xd9, 0xf3, 0xc3, 0x67, 0x4d, 0x2b, 0x53, 0xa1,
	     0x81, 0x43, 0xa5, 0xcc, 0xdc, 0x8d, 0xa5, 0xdc, 0x46, 0xa8, 0xee,
	     0x1f, 0x17, 0x48, 0x8c, 0x0b, 0x6d, 0x83, 0xc4, 0x70, 0x00, 0x00,
	     0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a,
	     0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34,
	     0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34,
	     0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2,
	     0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74,
	     0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79,
	     0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32,
	     0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30,
	     0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00,
	     0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Colour type 2, bit depth 8 */
PIX ( ctype_2_8, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x02, 0x00, 0x00, 0x00, 0x7c, 0x79, 0x38, 0xeb,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x06,
	     0x62, 0x4b, 0x47, 0x44, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xa0,
	     0xbd, 0xa7, 0x93, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73,
	     0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a,
	     0x9c, 0x18, 0x00, 0x00, 0x01, 0x04, 0x49, 0x44, 0x41, 0x54, 0x18,
	     0xd3, 0x05, 0xc1, 0xc1, 0x4e, 0x83, 0x30, 0x00, 0x00, 0x50, 0x68,
	     0x69, 0xb0, 0x6c, 0x23, 0x80, 0x30, 0x33, 0xa3, 0x84, 0x2c, 0x26,
	     0x1e, 0x76, 0xf0, 0xb2, 0x19, 0xf5, 0xe6, 0xcd, 0x9b, 0x9f, 0xe1,
	     0xe7, 0xf8, 0x2d, 0x7e, 0x84, 0x59, 0xb2, 0x78, 0xd0, 0x68, 0x74,
	     0x1c, 0xdc, 0x34, 0x2e, 0x63, 0xc6, 0x41, 0x0b, 0x94, 0x01, 0x4d,
	     0xa1, 0xbe, 0xa7, 0xde, 0x3f, 0xb6, 0x83, 0x28, 0x84, 0x52, 0x64,
	     0x5d, 0x4b, 0x6a, 0xa8, 0xb5, 0x3c, 0x53, 0xe4, 0x0a, 0x44, 0x55,
	     0xa3, 0x4a, 0x51, 0xd2, 0x1d, 0xc4, 0x8c, 0xec, 0xe9, 0x52, 0x75,
	     0x1c, 0x8d, 0x37, 0x52, 0x08, 0xee, 0xfc, 0x2e, 0x86, 0x6f, 0x33,
	     0xae, 0xe3, 0xe5, 0xd5, 0xad, 0x49, 0xd7, 0xbd, 0x82, 0x8a, 0xa6,
	     0xc9, 0x2c, 0xef, 0x80, 0x50, 0x73, 0xf5, 0x59, 0xda, 0x1e, 0x39,
	     0x9b, 0x00, 0x4e, 0xd8, 0x7e, 0xf8, 0x0c, 0x92, 0x6d, 0xec, 0x1e,
	     0x17, 0xa8, 0x23, 0x37, 0xd1, 0x3c, 0x38, 0xef, 0x85, 0x2f, 0x92,
	     0xe5, 0xf3, 0x60, 0x6c, 0x46, 0xcb, 0x1a, 0x19, 0xb1, 0x7d, 0xf4,
	     0x63, 0x9f, 0x00, 0x85, 0xa6, 0x20, 0x63, 0x30, 0x2b, 0x3a, 0x59,
	     0x12, 0x77, 0x0f, 0xdf, 0xfd, 0xcb, 0xe6, 0x8f, 0x48, 0xc6, 0x08,
	     0x76, 0xab, 0x5a, 0xd4, 0x15, 0x5f, 0x19, 0xfd, 0x54, 0xd5, 0xb3,
	     0x52, 0xd1, 0xec, 0xed, 0x77, 0x25, 0x80, 0x00, 0x68, 0x7a, 0x7d,
	     0x47, 0xb0, 0xdb, 0x12, 0x3a, 0x9a, 0x3e, 0xcc, 0x4e, 0x6f, 0xbc,
	     0xf5, 0x62, 0x00, 0x9f, 0x10, 0xcb, 0x2b, 0x07, 0x50, 0xc3, 0x2e,
	     0x14, 0xa4, 0x11, 0x6c, 0x95, 0xc1, 0x58, 0xaa, 0x20, 0x41, 0x96,
	     0xd2, 0x2a, 0x26, 0x67, 0xa1, 0x3f, 0xf9, 0x18, 0x5e, 0xf4, 0xbf,
	     0x5e, 0x71, 0x19, 0x43, 0x7f, 0xd4, 0xb0, 0x74, 0x57, 0xf0, 0x16,
	     0x6a, 0xff, 0xc1, 0x85, 0x8a, 0x8b, 0x87, 0xa4, 0x8a, 0x0e, 0x00,
	     0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65,
	     0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31,
	     0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a,
	     0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30,
	     0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58,
	     0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	     0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31,
	     0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b,
	     0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00,
	     0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Colour type 3, bit depth 1 */
PIX ( ctype_3_1, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x02, 0x03, 0x00, 0x00, 0x00, 0x8e, 0x75, 0x47, 0x2f,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x0c,
	     0x50, 0x4c, 0x54, 0x45, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff,
	     0x00, 0xff, 0x00, 0xff, 0xff, 0x35, 0x24, 0xb1, 0xc4, 0x00, 0x00,
	     0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x00, 0x88, 0x05, 0x1d, 0x48,
	     0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b,
	     0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00,
	     0x00, 0x00, 0x24, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x60,
	     0x00, 0x01, 0xc6, 0x06, 0xa6, 0x06, 0x06, 0xae, 0xc6, 0x2e, 0x06,
	     0x06, 0xad, 0x8d, 0x5c, 0x06, 0x0c, 0x1a, 0xbf, 0xda, 0x0c, 0x18,
	     0x98, 0x0f, 0xbf, 0xfa, 0x00, 0x00, 0x4a, 0x48, 0x07, 0xa6, 0x66,
	     0x5c, 0x57, 0x79, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74,
	     0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	     0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32,
	     0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30,
	     0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00,
	     0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d,
	     0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d,
	     0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33,
	     0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9,
	     0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae,
	     0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xff0000,
	     0xff00ff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff,
	     0xffffff, 0xff00ff, 0xff00ff, 0xffffff, 0xffffff, 0xffffff,
	     0xff00ff, 0xff00ff, 0xff00ff, 0xffffff, 0xffffff, 0xff0000,
	     0xff00ff, 0xffffff, 0xff00ff, 0xff00ff, 0xffffff, 0xffffff,
	     0xffffff, 0xff00ff, 0xff00ff, 0xff00ff, 0xff00ff, 0x00ffff,
	     0xffffff, 0xff0000, 0xffffff, 0xffffff, 0xff00ff, 0xff00ff,
	     0xffffff, 0x00ffff, 0xffffff, 0xff00ff, 0xff00ff, 0xffffff,
	     0x00ffff, 0x00ffff, 0xff00ff, 0xff00ff, 0xff00ff, 0xffffff,
	     0xff0000, 0xff00ff, 0xffffff, 0x00ffff, 0xffffff, 0xffffff,
	     0xffffff, 0x00ffff, 0x00ffff, 0xffffff, 0xffffff, 0x00ffff,
	     0x00ffff, 0xff00ff, 0xff00ff, 0xff00ff, 0x00ffff, 0x00ffff ) );

/* Colour type 3, bit depth 2 */
PIX ( ctype_3_2, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x04, 0x03, 0x00, 0x00, 0x00, 0x01, 0x35, 0xb2, 0x8f,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x15,
	     0x50, 0x4c, 0x54, 0x45, 0xaa, 0xaa, 0xff, 0xaa, 0xaa, 0xaa, 0xaa,
	     0x55, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0xff, 0x55, 0xaa, 0xaa,
	     0xff, 0xff, 0xff, 0xef, 0x1e, 0x2f, 0x5e, 0x00, 0x00, 0x00, 0x01,
	     0x62, 0x4b, 0x47, 0x44, 0x06, 0x61, 0x66, 0xb8, 0x7d, 0x00, 0x00,
	     0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00,
	     0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00,
	     0x34, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x60, 0x10, 0x60,
	     0x00, 0x03, 0x46, 0x21, 0x43, 0x41, 0x41, 0x61, 0x43, 0x06, 0x46,
	     0x63, 0x43, 0x26, 0x03, 0x63, 0x01, 0x06, 0x66, 0x63, 0x13, 0x26,
	     0x01, 0x63, 0x11, 0x06, 0x61, 0x03, 0x17, 0x63, 0x43, 0x65, 0x11,
	     0x06, 0x41, 0x11, 0x07, 0x91, 0x60, 0xe3, 0x10, 0x00, 0x53, 0x53,
	     0x04, 0xcd, 0x45, 0xaa, 0x11, 0x71, 0x00, 0x00, 0x00, 0x25, 0x74,
	     0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65,
	     0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31,
	     0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30,
	     0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
	     0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0xaaaaff, 0xaaaaff, 0xaaaaaa, 0xaaaaff, 0xaaaaff, 0xaaaaff,
	     0xaaaaff, 0xaaaaff, 0xaaaaff, 0xaaaaff, 0xaaaaff, 0xaaaaff,
	     0xaaaaff, 0xaaaaff, 0xaaaaff, 0xaaaaaa, 0xaaaaaa, 0xaa5555,
	     0xaa55aa, 0xaaaaaa, 0xaaaaaa, 0xaaaaaa, 0xaaaaaa, 0xaaaaaa,
	     0xaaaaaa, 0xaa55aa, 0xaa55aa, 0xaaaaaa, 0xaaaaff, 0xaaaaaa,
	     0xaa55aa, 0xaa55aa, 0xaa55aa, 0xaaaaaa, 0xaaaaff, 0xaa5555,
	     0xaa55aa, 0xaaaaff, 0xaa55aa, 0xaa55aa, 0xaaaaaa, 0xaaaaff,
	     0xaaaaff, 0xaa55aa, 0xaa55aa, 0xaa55aa, 0xaa55aa, 0x55aaff,
	     0xaaaaff, 0xaa5555, 0xaaaaaa, 0xaaaaff, 0xaa55aa, 0xaa55aa,
	     0xaaaaaa, 0x55aaff, 0xaaaaaa, 0xaa55aa, 0xaa55aa, 0xaaaaff,
	     0x55aaff, 0x55aaff, 0xaa55aa, 0xaa55aa, 0xaa55aa, 0xaaaaaa,
	     0xaa5555, 0xaa55aa, 0xaaaaaa, 0x55aaff, 0xaaaaaa, 0xaaaaaa,
	     0xaaaaaa, 0x55aaff, 0x55aaff, 0xaaaaff, 0xaaaaaa, 0x55aaff,
	     0x55aaaa, 0xaa55aa, 0xaa55aa, 0xaa55aa, 0x55aaaa, 0x55aaff ) );

/* Colour type 3, bit depth 4 */
PIX ( ctype_3_4, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x8a,
	     0x50, 0x4c, 0x54, 0x45, 0x88, 0xcc, 0xff, 0xaa, 0xaa, 0xdd, 0xaa,
	     0xaa, 0xcc, 0x99, 0xbb, 0xdd, 0x99, 0xbb, 0xee, 0x99, 0xcc, 0xff,
	     0xaa, 0xcc, 0xee, 0x99, 0xcc, 0xee, 0x88, 0xbb, 0xee, 0x99, 0xaa,
	     0xdd, 0x88, 0xbb, 0xff, 0xbb, 0x99, 0xaa, 0xcc, 0x66, 0x77, 0xcc,
	     0x66, 0x88, 0xbb, 0x99, 0xbb, 0xbb, 0x88, 0xaa, 0xaa, 0x99, 0xbb,
	     0xbb, 0x77, 0x99, 0x88, 0xaa, 0xee, 0xbb, 0x88, 0x99, 0xbb, 0x77,
	     0x88, 0xaa, 0x88, 0xbb, 0x88, 0x99, 0xdd, 0xaa, 0x77, 0xaa, 0x77,
	     0xaa, 0xee, 0xcc, 0x55, 0x66, 0xaa, 0x88, 0xaa, 0xbb, 0x66, 0x88,
	     0x99, 0x77, 0xaa, 0x99, 0x88, 0xbb, 0x77, 0xbb, 0xee, 0xaa, 0x77,
	     0x99, 0x77, 0xbb, 0xff, 0x99, 0x77, 0xbb, 0xaa, 0x66, 0x99, 0xbb,
	     0x55, 0x77, 0x88, 0x99, 0xcc, 0x88, 0x88, 0xcc, 0x77, 0xaa, 0xff,
	     0x88, 0x88, 0xbb, 0x66, 0xaa, 0xff, 0x77, 0x88, 0xcc, 0x88, 0x77,
	     0xbb, 0x99, 0x77, 0x99, 0x99, 0x66, 0x99, 0xff, 0xff, 0xff, 0xac,
	     0x68, 0xae, 0x0f, 0x00, 0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44,
	     0x2d, 0xcd, 0xda, 0x41, 0x3d, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48,
	     0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01,
	     0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x59, 0x49, 0x44, 0x41,
	     0x54, 0x08, 0xd7, 0x0d, 0xc5, 0xd9, 0x02, 0x40, 0x20, 0x10, 0x00,
	     0xc0, 0x95, 0x2b, 0x47, 0xb2, 0x49, 0xce, 0x08, 0xe5, 0xfe, 0xff,
	     0xef, 0x63, 0x5e, 0x06, 0xc0, 0x23, 0x7e, 0x10, 0x46, 0x51, 0x1c,
	     0xd0, 0xc4, 0x8f, 0x21, 0x25, 0x59, 0xce, 0x48, 0xc1, 0x79, 0xc9,
	     0x19, 0x12, 0x10, 0x15, 0xa2, 0xac, 0x69, 0x8e, 0x94, 0xfd, 0x81,
	     0x42, 0xc9, 0x9a, 0x56, 0x75, 0xbd, 0x18, 0x46, 0x3d, 0x81, 0x9e,
	     0x51, 0x98, 0x76, 0x58, 0x56, 0xbd, 0x8d, 0xd6, 0x80, 0x75, 0x6e,
	     0x37, 0xea, 0x38, 0xaf, 0xfb, 0x79, 0x2f, 0xf3, 0x01, 0xcb, 0xd6,
	     0x06, 0x9f, 0x93, 0x26, 0xe0, 0xd0, 0x00, 0x00, 0x00, 0x25, 0x74,
	     0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65,
	     0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31,
	     0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30,
	     0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
	     0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x88ccff, 0xaaaadd, 0xaaaacc, 0x99bbdd, 0x99bbee, 0x99ccff,
	     0xaaccee, 0xaaccee, 0x99ccee, 0x99bbee, 0x88bbee, 0x99aadd,
	     0x99bbdd, 0x99ccee, 0x88bbff, 0xaaaacc, 0xbb99aa, 0xcc6677,
	     0xcc6688, 0xaaaacc, 0xbb99bb, 0xbb88aa, 0xbb88aa, 0xaa99bb,
	     0xbb88aa, 0xcc6688, 0xbb7799, 0xaaaacc, 0x88aaee, 0xbb8899,
	     0xbb7799, 0xbb7799, 0xbb7788, 0xaa88bb, 0x88bbee, 0xcc6677,
	     0xbb7799, 0x88bbee, 0xcc6688, 0xbb7788, 0xaa88bb, 0x88bbee,
	     0x8899dd, 0xbb7799, 0xbb7788, 0xcc6688, 0xaa77aa, 0x77aaee,
	     0x8899dd, 0xcc5566, 0xaa88aa, 0x88aaee, 0xbb6688, 0x9977aa,
	     0x9988bb, 0x77bbee, 0x9988bb, 0xaa7799, 0xbb7799, 0x88aaee,
	     0x77bbff, 0x77aaee, 0xbb6688, 0x9977bb, 0xaa6699, 0x9988bb,
	     0xbb5577, 0x9977aa, 0x8899cc, 0x77bbff, 0x8899cc, 0x8888cc,
	     0x8888cc, 0x77aaff, 0x77bbff, 0x8899dd, 0x8888bb, 0x66aaff,
	     0x7788cc, 0x8877bb, 0x997799, 0x996699, 0x7788cc, 0x77bbff ) );

/* Colour type 3, bit depth 8 */
PIX ( ctype_3_8, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x62, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63,
	     0x60, 0x60, 0x64, 0x62, 0x66, 0x61, 0x65, 0x63, 0xe7, 0xe0, 0xe4,
	     0xe2, 0xe6, 0xe1, 0x65, 0xe0, 0xe3, 0x17, 0x10, 0x14, 0x12, 0x16,
	     0x11, 0x15, 0x13, 0x97, 0x90, 0x94, 0x92, 0x66, 0x90, 0x91, 0x95,
	     0x93, 0x57, 0x50, 0x54, 0x52, 0x56, 0x51, 0x55, 0x53, 0xd7, 0xd0,
	     0x64, 0xd0, 0xd2, 0xd6, 0xd1, 0xd5, 0xd3, 0x37, 0x30, 0x34, 0x32,
	     0x36, 0x31, 0x35, 0x33, 0x67, 0xb0, 0xb0, 0xb4, 0xb2, 0xb6, 0xb1,
	     0xb5, 0xb3, 0x77, 0x70, 0x74, 0x72, 0x76, 0x71, 0x65, 0x70, 0x73,
	     0xf7, 0xf0, 0xf4, 0xf2, 0xf6, 0xf1, 0xf5, 0xf3, 0x0f, 0x08, 0x0c,
	     0x0a, 0x06, 0x00, 0x96, 0xe0, 0x0d, 0x9f, 0x37, 0x73, 0x30, 0xa4,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45,
	     0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69,
	     0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d,
	     0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33,
	     0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00,
	     0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Colour type 4, bit depth 16 */
PIX ( ctype_4_16, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x10, 0x04, 0x00, 0x00, 0x00, 0x09, 0x82, 0xbb, 0x74,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x01, 0x86,
	     0xa0, 0x31, 0xe8, 0x96, 0x5f, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4b,
	     0x47, 0x44, 0xff, 0xff, 0x14, 0xab, 0x31, 0xcd, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x93,
	     0x49, 0x44, 0x41, 0x54, 0x18, 0xd3, 0x4d, 0xcf, 0xc1, 0x4e, 0xc2,
	     0x60, 0x10, 0x04, 0xe0, 0x8f, 0xf2, 0x0b, 0x24, 0x72, 0x13, 0x4f,
	     0x9e, 0x48, 0x78, 0xd0, 0x5e, 0x78, 0x51, 0x0f, 0x1e, 0x4a, 0xaa,
	     0x80, 0x96, 0x22, 0x68, 0xeb, 0xc1, 0x39, 0x74, 0x93, 0xc9, 0x4e,
	     0x76, 0x76, 0x33, 0xb3, 0xb3, 0x7d, 0x3d, 0xd6, 0x8d, 0xff, 0x5a,
	     0xa1, 0x60, 0x83, 0x21, 0xfc, 0x16, 0x9c, 0xd1, 0x65, 0xe7, 0x19,
	     0xe5, 0x1e, 0xe1, 0x13, 0x07, 0xcc, 0xb0, 0xc5, 0x05, 0x3f, 0xc1,
	     0x0a, 0x5f, 0xc1, 0x22, 0xfb, 0x55, 0x8b, 0xb7, 0x1c, 0x16, 0x8c,
	     0x68, 0xe2, 0xda, 0xa2, 0x0f, 0xef, 0x92, 0x6a, 0x81, 0x35, 0xca,
	     0x11, 0xd7, 0x38, 0x8d, 0xe9, 0x4f, 0x71, 0xbf, 0x61, 0x99, 0xe3,
	     0x6f, 0x54, 0xf8, 0x8d, 0x73, 0x39, 0xe1, 0x9e, 0xe1, 0x2e, 0xb1,
	     0xde, 0xf1, 0x8a, 0x07, 0x7c, 0x4c, 0x22, 0xcf, 0x93, 0x6a, 0x40,
	     0x55, 0x62, 0xfd, 0x18, 0x61, 0x98, 0xfc, 0xf5, 0x92, 0xde, 0x45,
	     0xeb, 0x27, 0xfc, 0x0f, 0x08, 0x4c, 0x30, 0x03, 0xe4, 0x95, 0x23,
	     0xfb, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
	     0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32,
	     0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32,
	     0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a,
	     0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74,
	     0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64,
	     0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31,
	     0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30,
	     0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94,
	     0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60,
	     0x82 ),
      14, 6,
      DATA ( 0x858585, 0x6f6f6f, 0x6f6f6f, 0x777777, 0x7b7b7b, 0x8f8f8f,
	     0x8d8d8d, 0x919191, 0x8b8b8b, 0x858585, 0x777777, 0x6c6c6c,
	     0x747474, 0x898989, 0x808080, 0x696969, 0x5c5c5c, 0x474747,
	     0x484848, 0x696969, 0x5f5f5f, 0x5b5b5b, 0x575757, 0x5f5f5f,
	     0x535353, 0x474747, 0x4d4d4d, 0x6e6e6e, 0x6d6d6d, 0x4f4f4f,
	     0x4f4f4f, 0x4b4b4b, 0x474747, 0x535353, 0x737373, 0x484848,
	     0x4e4e4e, 0x737373, 0x484848, 0x474747, 0x535353, 0x7a7a7a,
	     0x5d5d5d, 0x474747, 0x484848, 0x474747, 0x484848, 0x666666,
	     0x5e5e5e, 0x424242, 0x4f4f4f, 0x6a6a6a, 0x414141, 0x434343,
	     0x505050, 0x6e6e6e, 0x4e4e4e, 0x424242, 0x444444, 0x686868,
	     0x707070, 0x5e5e5e, 0x404040, 0x454545, 0x3e3e3e, 0x4b4b4b,
	     0x3d3d3d, 0x404040, 0x545454, 0x6c6c6c, 0x525252, 0x4e4e4e,
	     0x4f4f4f, 0x6b6b6b, 0x6e6e6e, 0x5a5a5a, 0x484848, 0x606060,
	     0x464646, 0x404040, 0x404040, 0x373737, 0x494949, 0x6f6f6f ) );

/* Colour type 4, bit depth 8 */
PIX ( ctype_4_8, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x04, 0x00, 0x00, 0x00, 0x59, 0x12, 0x67, 0x37,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x01, 0x86,
	     0xa0, 0x31, 0xe8, 0x96, 0x5f, 0x00, 0x00, 0x00, 0x02, 0x62, 0x4b,
	     0x47, 0x44, 0x00, 0xff, 0x87, 0x8f, 0xcc, 0xbf, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x72,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x05, 0xc1, 0xbb, 0x0e, 0x82,
	     0x30, 0x00, 0x00, 0xc0, 0xa3, 0x54, 0x6d, 0x0c, 0x9b, 0xb8, 0xb9,
	     0x18, 0xbf, 0xd5, 0x1f, 0x75, 0x70, 0xf0, 0x15, 0x1f, 0x20, 0xa6,
	     0x56, 0xf0, 0xae, 0xda, 0x4f, 0x27, 0x24, 0x51, 0x6b, 0x14, 0x65,
	     0xd9, 0x53, 0x2f, 0x59, 0x8b, 0x5f, 0xd9, 0xcb, 0x05, 0x5b, 0x6f,
	     0x45, 0x91, 0x74, 0x3a, 0x0b, 0x59, 0xb8, 0x3a, 0xea, 0xd4, 0x26,
	     0x27, 0xad, 0x9b, 0x41, 0xeb, 0x8d, 0xb9, 0x46, 0xbc, 0xfb, 0x08,
	     0x46, 0x95, 0x95, 0xb3, 0x6c, 0x6e, 0xf0, 0x11, 0x14, 0x9d, 0xf8,
	     0xf0, 0x55, 0xdb, 0x49, 0x6e, 0x0e, 0x66, 0xee, 0x8a, 0x9f, 0x49,
	     0x34, 0x0a, 0x51, 0x63, 0xa9, 0x36, 0x2a, 0x92, 0x8d, 0x85, 0x5e,
	     0x30, 0xe8, 0xd5, 0xfe, 0x3c, 0xbb, 0x2f, 0xff, 0xe5, 0xd1, 0x65,
	     0x25, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
	     0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32,
	     0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32,
	     0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a,
	     0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74,
	     0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64,
	     0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31,
	     0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30,
	     0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94,
	     0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60,
	     0x82 ),
      14, 6,
      DATA ( 0x858585, 0x6f6f6f, 0x6f6f6f, 0x777777, 0x7b7b7b, 0x8f8f8f,
	     0x8d8d8d, 0x919191, 0x8b8b8b, 0x858585, 0x777777, 0x6c6c6c,
	     0x747474, 0x898989, 0x808080, 0x696969, 0x5c5c5c, 0x484848,
	     0x484848, 0x696969, 0x5f5f5f, 0x5b5b5b, 0x575757, 0x5f5f5f,
	     0x535353, 0x474747, 0x4e4e4e, 0x6e6e6e, 0x6d6d6d, 0x4f4f4f,
	     0x505050, 0x4b4b4b, 0x474747, 0x535353, 0x737373, 0x494949,
	     0x4e4e4e, 0x737373, 0x494949, 0x474747, 0x545454, 0x7a7a7a,
	     0x5d5d5d, 0x474747, 0x494949, 0x474747, 0x484848, 0x666666,
	     0x5e5e5e, 0x434343, 0x4f4f4f, 0x6a6a6a, 0x414141, 0x434343,
	     0x505050, 0x6e6e6e, 0x4e4e4e, 0x424242, 0x454545, 0x686868,
	     0x707070, 0x5e5e5e, 0x404040, 0x454545, 0x3f3f3f, 0x4b4b4b,
	     0x3e3e3e, 0x404040, 0x545454, 0x6c6c6c, 0x525252, 0x4e4e4e,
	     0x4f4f4f, 0x6b6b6b, 0x6e6e6e, 0x5a5a5a, 0x484848, 0x616161,
	     0x464646, 0x404040, 0x404040, 0x373737, 0x494949, 0x6f6f6f ) );

/* Colour type 6, bit depth 16 */
PIX ( ctype_6_16, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x10, 0x06, 0x00, 0x00, 0x00, 0xa3, 0x8b, 0x73, 0xff,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x06,
	     0x62, 0x4b, 0x47, 0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x09,
	     0x58, 0xf7, 0xdc, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73,
	     0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a,
	     0x9c, 0x18, 0x00, 0x00, 0x01, 0x5f, 0x49, 0x44, 0x41, 0x54, 0x28,
	     0xcf, 0x4d, 0xd0, 0x31, 0x6e, 0xd3, 0x00, 0x00, 0x85, 0xe1, 0x2f,
	     0x76, 0xac, 0x90, 0xb4, 0x8d, 0x92, 0xd0, 0x14, 0x15, 0x41, 0x84,
	     0x2a, 0x24, 0x86, 0x0e, 0x2c, 0x14, 0x01, 0x1b, 0x1b, 0x1b, 0xc7,
	     0xe0, 0x1a, 0xb9, 0x01, 0x67, 0xe1, 0x10, 0xa8, 0x52, 0xc5, 0x00,
	     0x02, 0x01, 0x19, 0x68, 0x41, 0xad, 0x1a, 0x10, 0x4d, 0xec, 0xb8,
	     0x4e, 0x93, 0x58, 0x4e, 0xcc, 0xe2, 0x81, 0xf5, 0x0d, 0xef, 0xfd,
	     0xef, 0xaf, 0xbd, 0x1d, 0xbe, 0x1f, 0x6e, 0x86, 0xe5, 0x70, 0xdf,
	     0xd8, 0x08, 0xa1, 0x52, 0x81, 0xd4, 0xb6, 0x0e, 0x4a, 0x75, 0x11,
	     0x36, 0x3a, 0xfa, 0x68, 0x2b, 0x5c, 0x83, 0x50, 0x84, 0xa5, 0xb5,
	     0x1a, 0x4a, 0x85, 0x05, 0x12, 0x37, 0x42, 0x34, 0x65, 0x62, 0xdc,
	     0xd2, 0x50, 0xa2, 0xa6, 0xa7, 0x87, 0x7a, 0x6e, 0xad, 0x44, 0xa1,
	     0x90, 0xa3, 0xe7, 0x8f, 0x53, 0x1c, 0xf8, 0xe2, 0x04, 0xb9, 0x86,
	     0x26, 0xce, 0xbc, 0xf0, 0x1a, 0x6d, 0x89, 0x4b, 0xec, 0x98, 0x4b,
	     0x50, 0x58, 0x5b, 0x23, 0xad, 0x80, 0xee, 0x88, 0x25, 0x68, 0xbb,
	     0xf0, 0x03, 0x0b, 0x5d, 0x7d, 0xc4, 0x1e, 0x3b, 0x42, 0x90, 0x8b,
	     0x65, 0xb8, 0x6d, 0xe4, 0x23, 0x02, 0x53, 0x57, 0x98, 0xd8, 0x75,
	     0x1f, 0x73, 0x91, 0x2d, 0x94, 0x7e, 0x1b, 0xe3, 0xbb, 0x07, 0x9e,
	     0x62, 0xc7, 0xc8, 0x27, 0x94, 0x32, 0xd7, 0x55, 0xfe, 0x04, 0x6d,
	     0x63, 0x67, 0x58, 0x89, 0xb4, 0x30, 0xd1, 0x75, 0x0f, 0xe7, 0xba,
	     0x1e, 0x22, 0x20, 0x31, 0x43, 0x20, 0x95, 0x21, 0x94, 0x9a, 0x63,
	     0x4b, 0x6a, 0x8a, 0x89, 0x6d, 0x77, 0xf1, 0xd5, 0xc0, 0x73, 0xac,
	     0xfd, 0x15, 0x57, 0x43, 0x19, 0x62, 0x4d, 0xbb, 0x58, 0x5a, 0x29,
	     0xb0, 0xb2, 0x94, 0xe3, 0x42, 0xcb, 0x1e, 0x66, 0x6a, 0x1a, 0x48,
	     0x2d, 0x40, 0xbd, 0xeb, 0xca, 0x2f, 0x2c, 0x15, 0x02, 0x14, 0x02,
	     0x11, 0x8e, 0xbd, 0xf4, 0xe6, 0xbf, 0xc2, 0x4d, 0xa5, 0xea, 0xd0,
	     0xb1, 0x77, 0x38, 0xf1, 0xc8, 0x2b, 0xf4, 0x5d, 0x3a, 0xc5, 0xbe,
	     0xd0, 0x07, 0x44, 0xd5, 0xe3, 0xa5, 0x9e, 0x00, 0x89, 0x96, 0x2e,
	     0xe6, 0x88, 0x50, 0x8f, 0x35, 0x75, 0xb0, 0xa8, 0x94, 0x94, 0x6a,
	     0x02, 0x4c, 0x45, 0x3a, 0x60, 0x03, 0xda, 0x72, 0x19, 0x46, 0x06,
	     0x8e, 0xf0, 0xcd, 0x81, 0x67, 0xd8, 0xf3, 0xd3, 0x67, 0x34, 0x2d,
	     0x4c, 0x10, 0x1a, 0x38, 0xc4, 0x5a, 0x66, 0x86, 0x1b, 0x73, 0x39,
	     0x36, 0x42, 0x75, 0xfc, 0x03, 0x3f, 0x65, 0x8d, 0x8a, 0xc6, 0x64,
	     0x55, 0xda, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
	     0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00,
	     0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54,
	     0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31,
	     0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25,
	     0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f,
	     0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30,
	     0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a,
	     0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde,
	     0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
	     0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Colour type 6, bit depth 8 */
PIX ( ctype_6_8, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x06, 0x00, 0x00, 0x00, 0xf3, 0x1b, 0xaf, 0xbc,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x06,
	     0x62, 0x4b, 0x47, 0x44, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0xa0,
	     0xbd, 0xa7, 0x93, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73,
	     0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a,
	     0x9c, 0x18, 0x00, 0x00, 0x01, 0x23, 0x49, 0x44, 0x41, 0x54, 0x18,
	     0xd3, 0x05, 0xc1, 0x4d, 0x4e, 0xc2, 0x40, 0x00, 0x80, 0xd1, 0xaf,
	     0x7f, 0xc1, 0x22, 0x36, 0x2d, 0x02, 0x06, 0xa3, 0x84, 0x10, 0x13,
	     0x17, 0x2e, 0xdc, 0x80, 0x51, 0x77, 0xee, 0xdc, 0x79, 0x0c, 0x8f,
	     0xe3, 0x59, 0x3c, 0x84, 0x31, 0x21, 0x2e, 0x34, 0x1a, 0x95, 0x85,
	     0xa8, 0x91, 0x88, 0x46, 0x60, 0x4a, 0x99, 0xd2, 0xd2, 0x4c, 0x3b,
	     0xbe, 0x67, 0x5c, 0xdd, 0x14, 0xba, 0x39, 0x1e, 0x60, 0x69, 0x45,
	     0x54, 0xf1, 0xd1, 0xb6, 0x43, 0xe1, 0xd7, 0xf1, 0xd4, 0x02, 0x2c,
	     0x87, 0x34, 0x37, 0xd0, 0x2a, 0x21, 0x5c, 0x5a, 0xb8, 0x52, 0xb0,
	     0x56, 0xd2, 0x18, 0xd5, 0x2a, 0x76, 0x96, 0x6b, 0x94, 0xca, 0xa8,
	     0xfe, 0x0e, 0xe9, 0x3c, 0xf5, 0xc9, 0x4a, 0x2e, 0xef, 0xa7, 0x17,
	     0x78, 0xe1, 0x37, 0x1b, 0x71, 0x88, 0xca, 0x73, 0x22, 0xbf, 0xce,
	     0x96, 0x08, 0xf1, 0x46, 0x6f, 0x24, 0x41, 0x1d, 0x71, 0xd8, 0xc3,
	     0xcc, 0x84, 0x64, 0x73, 0x70, 0x8f, 0x39, 0x9b, 0x30, 0xad, 0xed,
	     0x12, 0x3b, 0xeb, 0xe8, 0x9f, 0x31, 0xaf, 0xed, 0x23, 0x36, 0x06,
	     0x0f, 0x68, 0xb9, 0xe0, 0xb5, 0xdd, 0xc5, 0x1b, 0xbf, 0xb3, 0x72,
	     0xca, 0x4c, 0x83, 0x1d, 0xbe, 0x82, 0x3d, 0x4c, 0xc2, 0x39, 0x66,
	     0x24, 0xb1, 0xa2, 0x98, 0xf5, 0x68, 0xc6, 0xb4, 0xb2, 0xcd, 0x73,
	     0xeb, 0x84, 0xfc, 0x4f, 0xa0, 0xa5, 0x44, 0xb8, 0x35, 0xd2, 0x95,
	     0x62, 0x95, 0x66, 0x8c, 0xca, 0x0d, 0xe6, 0x46, 0x89, 0x28, 0x01,
	     0x3b, 0x98, 0x7c, 0x92, 0x2a, 0x13, 0x65, 0x3a, 0xdc, 0x9e, 0x5d,
	     0x22, 0xdc, 0x1a, 0x85, 0x08, 0x39, 0xb8, 0xbd, 0xa6, 0xbf, 0x7f,
	     0x4e, 0xfd, 0x7b, 0x48, 0xd3, 0xba, 0xc3, 0x91, 0x0b, 0xd2, 0xaa,
	     0x49, 0x58, 0x0e, 0x88, 0x71, 0xb0, 0x85, 0xeb, 0x93, 0xb4, 0xbb,
	     0x68, 0xc3, 0x64, 0xe6, 0xf8, 0x50, 0x80, 0x97, 0x49, 0x06, 0xad,
	     0x1e, 0x2f, 0x9d, 0x63, 0x1a, 0x1f, 0x8f, 0xb8, 0xc9, 0x14, 0xab,
	     0x75, 0x40, 0x2e, 0xe7, 0x2c, 0xe3, 0x8c, 0xc2, 0xb2, 0xf9, 0x07,
	     0xb2, 0x82, 0x8b, 0x8a, 0x51, 0x8a, 0xfe, 0x2f, 0x00, 0x00, 0x00,
	     0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63,
	     0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d,
	     0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33,
	     0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4,
	     0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
	     0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00,
	     0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54,
	     0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31,
	     0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00,
	     0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Filter method 0 */
PIX ( filter_0, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x62, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63,
	     0x60, 0x60, 0x64, 0x62, 0x66, 0x61, 0x65, 0x63, 0xe7, 0xe0, 0xe4,
	     0xe2, 0xe6, 0xe1, 0x65, 0xe0, 0xe3, 0x17, 0x10, 0x14, 0x12, 0x16,
	     0x11, 0x15, 0x13, 0x97, 0x90, 0x94, 0x92, 0x66, 0x90, 0x91, 0x95,
	     0x93, 0x57, 0x50, 0x54, 0x52, 0x56, 0x51, 0x55, 0x53, 0xd7, 0xd0,
	     0x64, 0xd0, 0xd2, 0xd6, 0xd1, 0xd5, 0xd3, 0x37, 0x30, 0x34, 0x32,
	     0x36, 0x31, 0x35, 0x33, 0x67, 0xb0, 0xb0, 0xb4, 0xb2, 0xb6, 0xb1,
	     0xb5, 0xb3, 0x77, 0x70, 0x74, 0x72, 0x76, 0x71, 0x65, 0x70, 0x73,
	     0xf7, 0xf0, 0xf4, 0xf2, 0xf6, 0xf1, 0xf5, 0xf3, 0x0f, 0x08, 0x0c,
	     0x0a, 0x06, 0x00, 0x96, 0xe0, 0x0d, 0x9f, 0x37, 0x73, 0x30, 0xa4,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45,
	     0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69,
	     0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d,
	     0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33,
	     0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00,
	     0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Filter method 1 */
PIX ( filter_1, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x1b, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63,
	     0x64, 0x60, 0x44, 0x01, 0x7c, 0xa8, 0x5c, 0x19, 0x54, 0xae, 0x16,
	     0x2a, 0xd7, 0x02, 0x95, 0xeb, 0x86, 0xc2, 0x03, 0x00, 0x2b, 0x08,
	     0x01, 0x27, 0x21, 0x1c, 0x62, 0x0d, 0x00, 0x00, 0x00, 0x25, 0x74,
	     0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65,
	     0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31,
	     0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30,
	     0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
	     0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Filter method 2 */
PIX ( filter_2, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x1c, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63,
	     0x62, 0x60, 0x64, 0x62, 0x66, 0x61, 0x65, 0x63, 0xe7, 0xe0, 0xe4,
	     0xe2, 0xe6, 0xe1, 0x65, 0xe2, 0x43, 0x01, 0x94, 0x70, 0x01, 0xae,
	     0xce, 0x04, 0x3c, 0x32, 0x9e, 0x82, 0x4f, 0x00, 0x00, 0x00, 0x25,
	     0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72,
	     0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30,
	     0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a,
	     0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66,
	     0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
	     0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32,
	     0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32,
	     0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a,
	     0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49,
	     0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Filter method 3 */
PIX ( filter_3, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x28, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63,
	     0x66, 0x60, 0x64, 0x62, 0x62, 0x66, 0x66, 0x61, 0x61, 0x65, 0x65,
	     0x63, 0x63, 0x67, 0x67, 0xe6, 0xe3, 0x40, 0x06, 0xcc, 0xa2, 0xa8,
	     0x5c, 0x19, 0x54, 0xae, 0x32, 0x2a, 0x57, 0x0b, 0x85, 0x0b, 0x00,
	     0x74, 0x6c, 0x02, 0xde, 0x3a, 0xf5, 0xbf, 0x99, 0x00, 0x00, 0x00,
	     0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63,
	     0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d,
	     0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33,
	     0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4,
	     0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
	     0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00,
	     0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54,
	     0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31,
	     0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00,
	     0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Filter method 4 */
PIX ( filter_4, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x11, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63,
	     0x61, 0x60, 0x44, 0x06, 0x2c, 0x7c, 0x54, 0xe3, 0x02, 0x00, 0x1e,
	     0xdd, 0x00, 0xad, 0x19, 0xa1, 0xfb, 0x47, 0x00, 0x00, 0x00, 0x25,
	     0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72,
	     0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30,
	     0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a,
	     0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66,
	     0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
	     0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32,
	     0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32,
	     0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a,
	     0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49,
	     0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Interlaced */
PIX ( interlaced, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x01, 0xb3, 0xc2, 0x6f, 0x18,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x68, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63,
	     0x60, 0xe0, 0x60, 0x60, 0xe1, 0x61, 0xb0, 0xb0, 0x71, 0x70, 0x61,
	     0x60, 0x62, 0xe3, 0x62, 0xb0, 0xb2, 0x73, 0x62, 0x90, 0x91, 0x53,
	     0x50, 0x52, 0x51, 0xd3, 0x60, 0x60, 0x64, 0x66, 0x65, 0xe7, 0xe4,
	     0xe6, 0x65, 0x90, 0x95, 0x57, 0x54, 0x56, 0x55, 0xd7, 0x64, 0xb0,
	     0xb4, 0xb6, 0xb5, 0x77, 0x74, 0x76, 0x65, 0xe0, 0xe3, 0x17, 0x10,
	     0x14, 0x12, 0x16, 0x11, 0x15, 0x13, 0x97, 0x90, 0x94, 0x92, 0x66,
	     0xd0, 0xd2, 0xd6, 0xd1, 0xd5, 0xd3, 0x37, 0x30, 0x34, 0x32, 0x36,
	     0x31, 0x35, 0x33, 0x67, 0x70, 0x73, 0xf7, 0xf0, 0xf4, 0xf2, 0xf6,
	     0xf1, 0xf5, 0xf3, 0x0f, 0x08, 0x0c, 0x0a, 0x06, 0x00, 0xf9, 0xc2,
	     0x0d, 0x9f, 0x36, 0xdc, 0x4b, 0x87, 0x00, 0x00, 0x00, 0x25, 0x74,
	     0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65,
	     0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31,
	     0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30,
	     0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
	     0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Interlaced (height 1) */
PIX ( interlaced_h1, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
	     0x00, 0x01, 0x04, 0x03, 0x00, 0x00, 0x01, 0x66, 0x29, 0xc2, 0xe6,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x1b,
	     0x50, 0x4c, 0x54, 0x45, 0x9a, 0x9a, 0xcd, 0xae, 0x88, 0xae, 0x9f,
	     0x94, 0xc3, 0x9a, 0x9d, 0xcf, 0xab, 0x8a, 0xb3, 0xa2, 0x91, 0xbb,
	     0xa9, 0x7f, 0xa6, 0x93, 0xa4, 0xd7, 0xff, 0xff, 0xff, 0x01, 0x68,
	     0x32, 0x1c, 0x00, 0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x08,
	     0x86, 0xde, 0x95, 0x7a, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59,
	     0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00,
	     0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x11, 0x49, 0x44, 0x41, 0x54,
	     0x08, 0xd7, 0x63, 0x60, 0x60, 0x70, 0x60, 0x50, 0x63, 0x10, 0x0e,
	     0x07, 0x00, 0x02, 0x9e, 0x00, 0xd1, 0x1a, 0x21, 0xdf, 0x5d, 0x00,
	     0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65,
	     0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31,
	     0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a,
	     0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30,
	     0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58,
	     0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	     0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31,
	     0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b,
	     0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00,
	     0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      8, 1,
      DATA ( 0x9a9acd, 0xae88ae, 0x9f94c3, 0x9a9dcf, 0xab8ab3, 0xa291bb,
	     0xa97fa6, 0x93a4d7,    ) );

/* Interlaced (height 2) */
PIX ( interlaced_h2, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
	     0x00, 0x02, 0x08, 0x03, 0x00, 0x00, 0x01, 0x25, 0x4d, 0x5d, 0x49,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x33,
	     0x50, 0x4c, 0x54, 0x45, 0x9b, 0xa9, 0xda, 0xb7, 0x8b, 0xab, 0xb1,
	     0x8b, 0xae, 0xa4, 0xa6, 0xd2, 0xb7, 0x94, 0xb5, 0xa7, 0x9e, 0xc5,
	     0xb0, 0x86, 0xab, 0xa2, 0xa5, 0xd0, 0x99, 0x8b, 0xbe, 0xa7, 0x82,
	     0xae, 0x8e, 0x9b, 0xd5, 0x90, 0x92, 0xcb, 0xa0, 0x7e, 0xad, 0x9e,
	     0x82, 0xae, 0xa4, 0x76, 0x9f, 0x85, 0xa2, 0xde, 0xff, 0xff, 0xff,
	     0xf3, 0x35, 0x13, 0x79, 0x00, 0x00, 0x00, 0x01, 0x62, 0x4b, 0x47,
	     0x44, 0x10, 0x95, 0xb2, 0x0d, 0x2c, 0x00, 0x00, 0x00, 0x09, 0x70,
	     0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13,
	     0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x1d, 0x49, 0x44,
	     0x41, 0x54, 0x08, 0xd7, 0x63, 0x60, 0x60, 0x60, 0x61, 0x60, 0x62,
	     0x63, 0x60, 0x64, 0x66, 0x65, 0x67, 0xe0, 0xe0, 0xe4, 0xe2, 0xe6,
	     0xe1, 0xe5, 0xe3, 0x07, 0x00, 0x02, 0xf9, 0x00, 0x79, 0x11, 0xe8,
	     0xb8, 0x97, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
	     0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00,
	     0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54,
	     0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31,
	     0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25,
	     0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f,
	     0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30,
	     0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a,
	     0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde,
	     0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
	     0x60, 0x82 ),
      8, 2,
      DATA ( 0x9ba9da, 0xb78bab, 0xb18bae, 0xa4a6d2, 0xb794b5, 0xa79ec5,
	     0xb086ab, 0xa2a5d0, 0x998bbe, 0xa782ae, 0x8e9bd5, 0x9092cb,
	     0xa07ead, 0x9e82ae, 0xa4769f, 0x85a2de,  ) );

/* Interlaced (height 3) */
PIX ( interlaced_h3, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
	     0x00, 0x03, 0x08, 0x03, 0x00, 0x00, 0x01, 0xee, 0x11, 0x8e, 0xec,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x4b,
	     0x50, 0x4c, 0x54, 0x45, 0x99, 0xb4, 0xe6, 0xb3, 0x97, 0xb9, 0xb1,
	     0x95, 0xb7, 0xa9, 0xaf, 0xd7, 0xb4, 0xa4, 0xc7, 0xa8, 0xa6, 0xce,
	     0xad, 0x90, 0xb7, 0xa8, 0xa8, 0xcf, 0x9d, 0x94, 0xc5, 0xbc, 0x78,
	     0x97, 0xac, 0x81, 0xa8, 0x9a, 0x98, 0xca, 0xb9, 0x79, 0x99, 0xa5,
	     0x8f, 0xb6, 0xb1, 0x76, 0x9a, 0x94, 0xa1, 0xd4, 0x96, 0x87, 0xbc,
	     0x9a, 0x8a, 0xbe, 0x7d, 0xaa, 0xef, 0x8c, 0x8f, 0xcc, 0x91, 0x83,
	     0xbc, 0x9b, 0x7c, 0xaa, 0x9c, 0x76, 0xa2, 0x7d, 0xa3, 0xe2, 0xff,
	     0xff, 0xff, 0x53, 0xa1, 0xdb, 0xb9, 0x00, 0x00, 0x00, 0x01, 0x62,
	     0x4b, 0x47, 0x44, 0x18, 0x9b, 0x69, 0x85, 0x1e, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x26,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x05, 0xc1, 0x85, 0x01, 0x00,
	     0x20, 0x00, 0xc0, 0xa0, 0xd9, 0xdd, 0xf5, 0xff, 0xa7, 0x02, 0xa0,
	     0x91, 0x96, 0x3e, 0xf7, 0x45, 0x28, 0xe3, 0x18, 0xeb, 0x3c, 0x7c,
	     0x88, 0x29, 0x97, 0xda, 0x3e, 0x0d, 0xb1, 0x01, 0x15, 0x29, 0x54,
	     0xbc, 0x10, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64,
	     0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x00,
	     0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54,
	     0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31,
	     0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00, 0x25,
	     0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d, 0x6f,
	     0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30,
	     0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a,
	     0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9, 0xde,
	     0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
	     0x60, 0x82 ),
      8, 3,
      DATA ( 0x99b4e6, 0xb397b9, 0xb195b7, 0xa9afd7, 0xb4a4c7, 0xa8a6ce,
	     0xad90b7, 0xa8a8cf, 0x9d94c5, 0xbc7897, 0xac81a8, 0x9a98ca,
	     0xb97999, 0xa58fb6, 0xb1769a, 0x94a1d4, 0x9687bc, 0x9a8abe,
	     0x7daaef, 0x8c8fcc, 0x9183bc, 0x9b7caa, 0x9c76a2, 0x7da3e2 ) );

/* Interlaced (height 4) */
PIX ( interlaced_h4, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
	     0x00, 0x04, 0x08, 0x03, 0x00, 0x00, 0x01, 0xf3, 0x14, 0xbe, 0x54,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x63,
	     0x50, 0x4c, 0x54, 0x45, 0x99, 0xb8, 0xea, 0xaf, 0xa0, 0xc4, 0xab,
	     0xa1, 0xc7, 0xa8, 0xb7, 0xe0, 0xaf, 0xb1, 0xd7, 0xa5, 0xae, 0xd7,
	     0xa6, 0x9b, 0xc5, 0xa8, 0xad, 0xd3, 0x9a, 0xa3, 0xd4, 0xbd, 0x7e,
	     0x9b, 0xbb, 0x77, 0x94, 0xa4, 0x9b, 0xc6, 0xbe, 0x80, 0x9d, 0xaa,
	     0x93, 0xb9, 0xba, 0x76, 0x96, 0xa2, 0x9e, 0xca, 0x9f, 0x87, 0xb7,
	     0xb7, 0x76, 0x99, 0x99, 0x91, 0xc5, 0x91, 0x94, 0xcc, 0xb1, 0x76,
	     0x9a, 0xa2, 0x88, 0xb1, 0xa7, 0x77, 0x9f, 0x87, 0xa3, 0xde, 0x92,
	     0x8a, 0xc1, 0x91, 0x91, 0xca, 0x77, 0xb0, 0xf8, 0x8a, 0x8f, 0xce,
	     0x87, 0x89, 0xc8, 0x97, 0x7a, 0xaa, 0x99, 0x76, 0xa3, 0x7b, 0xa2,
	     0xe3, 0xff, 0xff, 0xff, 0xfa, 0x09, 0xb4, 0x8e, 0x00, 0x00, 0x00,
	     0x01, 0x62, 0x4b, 0x47, 0x44, 0x20, 0xb3, 0x6b, 0x3d, 0x80, 0x00,
	     0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13,
	     0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00,
	     0x00, 0x30, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x60, 0x60,
	     0x60, 0x61, 0x60, 0x62, 0x63, 0x10, 0x10, 0x12, 0x11, 0x63, 0x60,
	     0x64, 0x66, 0x65, 0x67, 0x10, 0x14, 0x16, 0x15, 0x67, 0xe0, 0xe0,
	     0xe4, 0xe2, 0xe6, 0xe1, 0xe5, 0xe3, 0x67, 0x90, 0x90, 0x94, 0x92,
	     0x96, 0x91, 0x95, 0x93, 0x07, 0x00, 0x1b, 0x22, 0x01, 0xf1, 0x69,
	     0x98, 0xfa, 0x95, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74,
	     0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	     0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32,
	     0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30,
	     0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00, 0x00,
	     0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x6d,
	     0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d,
	     0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33,
	     0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3, 0xe9,
	     0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae,
	     0x42, 0x60, 0x82 ),
      8, 4,
      DATA ( 0x99b8ea, 0xafa0c4, 0xaba1c7, 0xa8b7e0, 0xafb1d7, 0xa5aed7,
	     0xa69bc5, 0xa8add3, 0x9aa3d4, 0xbd7e9b, 0xbb7794, 0xa49bc6,
	     0xbe809d, 0xaa93b9, 0xba7696, 0xa29eca, 0x9f87b7, 0xb77699,
	     0x9991c5, 0x9194cc, 0xb1769a, 0xa288b1, 0xa7779f, 0x87a3de,
	     0x928ac1, 0x9191ca, 0x77b0f8, 0x8a8fce, 0x8789c8, 0x977aaa,
	     0x9976a3, 0x7ba2e3,    ) );

/* Interlaced (width 1) */
PIX ( interlaced_w1, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	     0x00, 0x08, 0x04, 0x03, 0x00, 0x00, 0x01, 0xbd, 0x33, 0xb8, 0xe4,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x1b,
	     0x50, 0x4c, 0x54, 0x45, 0x9f, 0xbd, 0xeb, 0xae, 0xa0, 0xc5, 0xb4,
	     0x8a, 0xac, 0xac, 0x8a, 0xb0, 0xa5, 0x87, 0xb2, 0x9d, 0x86, 0xb6,
	     0x90, 0x8c, 0xc3, 0x82, 0x93, 0xd3, 0xff, 0xff, 0xff, 0xac, 0xaf,
	     0x93, 0xf1, 0x00, 0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x08,
	     0x86, 0xde, 0x95, 0x7a, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59,
	     0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00,
	     0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x18, 0x49, 0x44, 0x41, 0x54,
	     0x08, 0xd7, 0x63, 0x60, 0x60, 0x70, 0x60, 0x50, 0x60, 0x48, 0x60,
	     0x10, 0x60, 0x30, 0x60, 0x08, 0x60, 0x28, 0x00, 0x00, 0x0a, 0xd0,
	     0x01, 0xc1, 0x05, 0xa2, 0x99, 0xc6, 0x00, 0x00, 0x00, 0x25, 0x74,
	     0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65,
	     0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31,
	     0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30,
	     0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28,
	     0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74,
	     0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30,
	     0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32,
	     0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30,
	     0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
	     0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      1, 8,
      DATA ( 0x9fbdeb, 0xaea0c5, 0xb48aac, 0xac8ab0, 0xa587b2, 0x9d86b6,
	     0x908cc3, 0x8293d3,    ) );

/* Interlaced (width 2) */
PIX ( interlaced_w2, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	     0x00, 0x08, 0x08, 0x03, 0x00, 0x00, 0x01, 0x93, 0xf4, 0xee, 0xe6,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x33,
	     0x50, 0x4c, 0x54, 0x45, 0xa0, 0xbc, 0xe9, 0x9e, 0xbe, 0xec, 0xad,
	     0xa1, 0xc7, 0xaf, 0x9e, 0xc2, 0xb4, 0x8b, 0xad, 0xb6, 0x88, 0xa9,
	     0xae, 0x87, 0xac, 0xac, 0x8b, 0xb1, 0xa9, 0x83, 0xad, 0xa1, 0x8a,
	     0xb6, 0x9e, 0x87, 0xb8, 0x9d, 0x84, 0xb3, 0x8e, 0x92, 0xcc, 0x92,
	     0x85, 0xba, 0x80, 0x9b, 0xde, 0x84, 0x8b, 0xc7, 0xff, 0xff, 0xff,
	     0xa3, 0x2a, 0xf5, 0x35, 0x00, 0x00, 0x00, 0x01, 0x62, 0x4b, 0x47,
	     0x44, 0x10, 0x95, 0xb2, 0x0d, 0x2c, 0x00, 0x00, 0x00, 0x09, 0x70,
	     0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13,
	     0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x20, 0x49, 0x44,
	     0x41, 0x54, 0x08, 0xd7, 0x05, 0xc1, 0x05, 0x01, 0x00, 0x20, 0x00,
	     0x00, 0x20, 0xec, 0xd6, 0xff, 0x6f, 0x05, 0x74, 0xd9, 0x16, 0x14,
	     0xc3, 0x11, 0x93, 0xda, 0xcc, 0xe5, 0xbe, 0x0f, 0x04, 0xf2, 0x00,
	     0x79, 0x83, 0x54, 0x1a, 0x1e, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45,
	     0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61,
	     0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d,
	     0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33,
	     0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00,
	     0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65,
	     0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31,
	     0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a,
	     0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30,
	     0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e,
	     0x44, 0xae, 0x42, 0x60, 0x82 ),
      2, 8,
      DATA ( 0xa0bce9, 0x9ebeec, 0xada1c7, 0xaf9ec2, 0xb48bad, 0xb688a9,
	     0xae87ac, 0xac8bb1, 0xa983ad, 0xa18ab6, 0x9e87b8, 0x9d84b3,
	     0x8e92cc, 0x9285ba, 0x809bde, 0x848bc7,  ) );

/* Interlaced (width 3) */
PIX ( interlaced_w3, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
	     0x00, 0x08, 0x08, 0x03, 0x00, 0x00, 0x01, 0x7c, 0x36, 0x85, 0xd8,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x4b,
	     0x50, 0x4c, 0x54, 0x45, 0xa0, 0xb7, 0xe4, 0xa1, 0xc4, 0xf1, 0x9c,
	     0xba, 0xe9, 0xab, 0xa0, 0xc7, 0xb1, 0xa1, 0xc5, 0xae, 0x9b, 0xc0,
	     0xb1, 0x8d, 0xb0, 0xb8, 0x88, 0xa8, 0xb5, 0x87, 0xa9, 0xae, 0x86,
	     0xab, 0xae, 0x88, 0xad, 0xaa, 0x8c, 0xb4, 0xac, 0x80, 0xa9, 0xa5,
	     0x88, 0xb2, 0x9f, 0x8b, 0xb7, 0xa0, 0x88, 0xb8, 0x9e, 0x84, 0xb5,
	     0x9c, 0x85, 0xb4, 0x8f, 0x94, 0xce, 0x8f, 0x8a, 0xc4, 0x93, 0x84,
	     0xb6, 0x81, 0x9d, 0xdf, 0x7e, 0x95, 0xd8, 0x88, 0x86, 0xbe, 0xff,
	     0xff, 0xff, 0xef, 0xfb, 0x85, 0x9c, 0x00, 0x00, 0x00, 0x01, 0x62,
	     0x4b, 0x47, 0x44, 0x18, 0x9b, 0x69, 0x85, 0x1e, 0x00, 0x00, 0x00,
	     0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00,
	     0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x28,
	     0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x05, 0xc1, 0x85, 0x01, 0x00,
	     0x20, 0x00, 0xc0, 0xa0, 0xd9, 0xdd, 0xf5, 0xff, 0xa7, 0x02, 0x90,
	     0x91, 0x54, 0xac, 0x67, 0x6e, 0x04, 0x8e, 0xc2, 0x42, 0x69, 0x43,
	     0x88, 0x89, 0xd6, 0x07, 0xe7, 0xbe, 0x0f, 0x0f, 0x68, 0x01, 0x15,
	     0x06, 0x65, 0x37, 0x5a, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58,
	     0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72, 0x65, 0x61, 0x74,
	     0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31,
	     0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b,
	     0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66, 0x28, 0x00, 0x00,
	     0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a,
	     0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x31, 0x34,
	     0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34,
	     0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xd3,
	     0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
	     0xae, 0x42, 0x60, 0x82 ),
      3, 8,
      DATA ( 0xa0b7e4, 0xa1c4f1, 0x9cbae9, 0xaba0c7, 0xb1a1c5, 0xae9bc0,
	     0xb18db0, 0xb888a8, 0xb587a9, 0xae86ab, 0xae88ad, 0xaa8cb4,
	     0xac80a9, 0xa588b2, 0x9f8bb7, 0xa088b8, 0x9e84b5, 0x9c85b4,
	     0x8f94ce, 0x8f8ac4, 0x9384b6, 0x819ddf, 0x7e95d8, 0x8886be ) );

/* Interlaced (width 4) */
PIX ( interlaced_w4, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
	     0x00, 0x08, 0x08, 0x03, 0x00, 0x00, 0x01, 0x9e, 0xea, 0x9e, 0xa1,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0x63,
	     0x50, 0x4c, 0x54, 0x45, 0xa0, 0xb4, 0xe1, 0xa1, 0xc1, 0xee, 0x9f,
	     0xc3, 0xf1, 0x9b, 0xb8, 0xe6, 0xa8, 0xa3, 0xcc, 0xb2, 0x9d, 0xc1,
	     0xb0, 0xa2, 0xc6, 0xad, 0x99, 0xbe, 0xae, 0x92, 0xb7, 0xb9, 0x84,
	     0xa4, 0xb8, 0x89, 0xa9, 0xb4, 0x87, 0xa9, 0xae, 0x87, 0xac, 0xae,
	     0x86, 0xab, 0xaf, 0x88, 0xac, 0xa8, 0x8d, 0xb7, 0xaf, 0x7e, 0xa5,
	     0xa4, 0x88, 0xb5, 0xa8, 0x85, 0xad, 0x9c, 0x8d, 0xbc, 0xa6, 0x81,
	     0xae, 0x94, 0x90, 0xc7, 0xa8, 0x79, 0xa2, 0x96, 0x8b, 0xbd, 0x94,
	     0x8e, 0xc4, 0x85, 0x9b, 0xdb, 0x99, 0x7b, 0xac, 0x8f, 0x89, 0xbe,
	     0x84, 0x99, 0xd9, 0x7c, 0xa1, 0xe8, 0x83, 0x87, 0xc5, 0x88, 0x89,
	     0xbf, 0xff, 0xff, 0xff, 0xec, 0xf4, 0xb8, 0xe8, 0x00, 0x00, 0x00,
	     0x01, 0x62, 0x4b, 0x47, 0x44, 0x20, 0xb3, 0x6b, 0x3d, 0x80, 0x00,
	     0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13,
	     0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00,
	     0x00, 0x34, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x05, 0xc1, 0x09,
	     0x02, 0x80, 0x10, 0x00, 0x00, 0xc1, 0x4d, 0x85, 0x0e, 0x8a, 0xa2,
	     0xc3, 0xf5, 0xff, 0x5f, 0x9a, 0x01, 0x4e, 0x04, 0x1e, 0xbd, 0xf2,
	     0xfe, 0x0c, 0x23, 0xcb, 0x86, 0xbb, 0xf8, 0x12, 0xd3, 0x2c, 0x15,
	     0xbb, 0xb1, 0x07, 0x77, 0x88, 0x0f, 0xb9, 0xd4, 0xd6, 0x01, 0x21,
	     0x30, 0x01, 0xf1, 0x50, 0x46, 0x7a, 0xbf, 0x00, 0x00, 0x00, 0x25,
	     0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3a, 0x63, 0x72,
	     0x65, 0x61, 0x74, 0x65, 0x00, 0x32, 0x30, 0x31, 0x34, 0x2d, 0x30,
	     0x31, 0x2d, 0x31, 0x32, 0x54, 0x32, 0x32, 0x3a, 0x34, 0x33, 0x3a,
	     0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a, 0x30, 0x30, 0xa2, 0xb4, 0x66,
	     0x28, 0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61,
	     0x74, 0x65, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x00, 0x32,
	     0x30, 0x31, 0x34, 0x2d, 0x30, 0x31, 0x2d, 0x31, 0x32, 0x54, 0x32,
	     0x32, 0x3a, 0x34, 0x33, 0x3a, 0x30, 0x33, 0x2b, 0x30, 0x31, 0x3a,
	     0x30, 0x30, 0xd3, 0xe9, 0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x49,
	     0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      4, 8,
      DATA ( 0xa0b4e1, 0xa1c1ee, 0x9fc3f1, 0x9bb8e6, 0xa8a3cc, 0xb29dc1,
	     0xb0a2c6, 0xad99be, 0xae92b7, 0xb984a4, 0xb889a9, 0xb487a9,
	     0xae87ac, 0xae86ab, 0xaf88ac, 0xa88db7, 0xaf7ea5, 0xa488b5,
	     0xa885ad, 0x9c8dbc, 0xa681ae, 0x9490c7, 0xa879a2, 0x968bbd,
	     0x948ec4, 0x859bdb, 0x997bac, 0x8f89be, 0x8499d9, 0x7ca1e8,
	     0x8387c5, 0x8889bf,    ) );

/* Multiple IDAT sections */
PIX ( multi_idat, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	     0x00, 0x06, 0x08, 0x03, 0x00, 0x00, 0x00, 0xc4, 0xc5, 0x5f, 0x8e,
	     0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4d, 0x41, 0x00, 0x00, 0xb1,
	     0x8f, 0x0b, 0xfc, 0x61, 0x05, 0x00, 0x00, 0x00, 0x01, 0x73, 0x52,
	     0x47, 0x42, 0x00, 0xae, 0xce, 0x1c, 0xe9, 0x00, 0x00, 0x00, 0x20,
	     0x63, 0x48, 0x52, 0x4d, 0x00, 0x00, 0x7a, 0x26, 0x00, 0x00, 0x80,
	     0x84, 0x00, 0x00, 0xfa, 0x00, 0x00, 0x00, 0x80, 0xe8, 0x00, 0x00,
	     0x75, 0x30, 0x00, 0x00, 0xea, 0x60, 0x00, 0x00, 0x3a, 0x98, 0x00,
	     0x00, 0x17, 0x70, 0x9c, 0xba, 0x51, 0x3c, 0x00, 0x00, 0x00, 0xff,
	     0x50, 0x4c, 0x54, 0x45, 0x8f, 0xc5, 0xfe, 0xa8, 0xac, 0xd7, 0xab,
	     0xab, 0xd3, 0x9d, 0xb7, 0xe3, 0x9c, 0xbb, 0xe8, 0x9a, 0xcb, 0xfd,
	     0xa8, 0xc7, 0xf0, 0xa8, 0xca, 0xf5, 0xa0, 0xc7, 0xf6, 0x9f, 0xc3,
	     0xed, 0x8f, 0xb9, 0xf0, 0x98, 0xad, 0xdf, 0xa0, 0xb4, 0xde, 0xa1,
	     0xc6, 0xf0, 0x89, 0xc2, 0xfd, 0xa4, 0xa8, 0xd1, 0xba, 0x91, 0xaf,
	     0xcd, 0x65, 0x79, 0xc7, 0x6c, 0x82, 0xa6, 0xa6, 0xd1, 0xb6, 0x96,
	     0xb7, 0xc3, 0x8b, 0xa7, 0xbf, 0x88, 0xa4, 0xb1, 0x98, 0xb9, 0xb6,
	     0x87, 0xa9, 0xc4, 0x6b, 0x86, 0xbb, 0x7c, 0x9b, 0xaa, 0xab, 0xd0,
	     0x83, 0xb1, 0xf1, 0xb7, 0x81, 0xa1, 0xbc, 0x7f, 0x9b, 0xba, 0x79,
	     0x96, 0xbc, 0x71, 0x8d, 0xa5, 0x8e, 0xb8, 0x8e, 0xb6, 0xed, 0xd0,
	     0x64, 0x78, 0xbe, 0x7c, 0x97, 0x89, 0xb8, 0xed, 0xc4, 0x6e, 0x88,
	     0xbd, 0x70, 0x90, 0xa8, 0x8d, 0xb7, 0x8d, 0xbc, 0xf4, 0x83, 0xa1,
	     0xe2, 0xb9, 0x73, 0x95, 0xbf, 0x71, 0x90, 0xc5, 0x6b, 0x84, 0xa9,
	     0x7d, 0xa7, 0x7b, 0xac, 0xf1, 0x8b, 0xa1, 0xdc, 0xcf, 0x58, 0x6c,
	     0xad, 0x85, 0xab, 0x81, 0xb1, 0xe9, 0xbd, 0x66, 0x82, 0xa1, 0x7a,
	     0xa6, 0x99, 0x8e, 0xbe, 0x7f, 0xb3, 0xf4, 0x94, 0x8d, 0xc3, 0xb1,
	     0x6f, 0x97, 0xb5, 0x71, 0x95, 0x86, 0xac, 0xeb, 0x75, 0xb5, 0xff,
	     0x73, 0xa4, 0xef, 0xb6, 0x68, 0x8d, 0x99, 0x7f, 0xb4, 0xae, 0x6b,
	     0x92, 0x9a, 0x88, 0xb5, 0xc2, 0x5a, 0x75, 0x99, 0x78, 0xa8, 0x89,
	     0x98, 0xcf, 0x74, 0xb3, 0xf9, 0x83, 0x96, 0xd3, 0x8b, 0x8f, 0xcb,
	     0x8a, 0x90, 0xcd, 0x74, 0xb1, 0xfb, 0x74, 0xb3, 0xff, 0x81, 0x9e,
	     0xe3, 0x8f, 0x86, 0xc2, 0x66, 0xa8, 0xfa, 0x7c, 0x88, 0xcd, 0x85,
	     0x7f, 0xba, 0x9d, 0x78, 0xa0, 0x96, 0x6c, 0x99, 0x7f, 0x8d, 0xc9,
	     0x72, 0xb6, 0xfd, 0xff, 0xff, 0xff, 0xdb, 0x2a, 0x9f, 0xad, 0x00,
	     0x00, 0x00, 0x01, 0x62, 0x4b, 0x47, 0x44, 0x54, 0xe4, 0x03, 0x88,
	     0xa5, 0x00, 0x00, 0x00, 0x09, 0x70, 0x48, 0x59, 0x73, 0x00, 0x00,
	     0x0b, 0x13, 0x00, 0x00, 0x0b, 0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18,
	     0x00, 0x00, 0x00, 0x07, 0x49, 0x44, 0x41, 0x54, 0x08, 0x5b, 0x63,
	     0x64, 0x60, 0x44, 0x01, 0xdd, 0xe3, 0x71, 0x09, 0x00, 0x00, 0x00,
	     0x07, 0x49, 0x44, 0x41, 0x54, 0x7c, 0x28, 0x3c, 0x16, 0x0a, 0xb8,
	     0x00, 0xb9, 0x49, 0x1a, 0x82, 0x00, 0x00, 0x00, 0x04, 0x49, 0x44,
	     0x41, 0x54, 0x1c, 0xee, 0x00, 0xa7, 0x1b, 0x22, 0xc4, 0xc1, 0x00,
	     0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82 ),
      14, 6,
      DATA ( 0x8fc5fe, 0xa8acd7, 0xababd3, 0x9db7e3, 0x9cbbe8, 0x9acbfd,
	     0xa8c7f0, 0xa8caf5, 0xa0c7f6, 0x9fc3ed, 0x8fb9f0, 0x98addf,
	     0xa0b4de, 0xa1c6f0, 0x89c2fd, 0xa4a8d1, 0xba91af, 0xcd6579,
	     0xc76c82, 0xa6a6d1, 0xb696b7, 0xc38ba7, 0xbf88a4, 0xb198b9,
	     0xb687a9, 0xc46b86, 0xbb7c9b, 0xaaabd0, 0x83b1f1, 0xb781a1,
	     0xbc7f9b, 0xba7996, 0xbc718d, 0xa58eb8, 0x8eb6ed, 0xd06478,
	     0xbe7c97, 0x89b8ed, 0xc46e88, 0xbd7090, 0xa88db7, 0x8dbcf4,
	     0x83a1e2, 0xb97395, 0xbf7190, 0xc56b84, 0xa97da7, 0x7bacf1,
	     0x8ba1dc, 0xcf586c, 0xad85ab, 0x81b1e9, 0xbd6682, 0xa17aa6,
	     0x998ebe, 0x7fb3f4, 0x948dc3, 0xb16f97, 0xb57195, 0x86aceb,
	     0x75b5ff, 0x73a4ef, 0xb6688d, 0x997fb4, 0xae6b92, 0x9a88b5,
	     0xc25a75, 0x9978a8, 0x8998cf, 0x74b3f9, 0x8396d3, 0x8b8fcb,
	     0x8a90cd, 0x74b1fb, 0x74b3ff, 0x819ee3, 0x8f86c2, 0x66a8fa,
	     0x7c88cd, 0x857fba, 0x9d78a0, 0x966c99, 0x7f8dc9, 0x72b6fd ) );

/* Original large image */
PIX ( original, &png_image_type,
      DATA ( 0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00,
	     0x0d, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00,
	     0x00, 0x0c, 0x08, 0x06, 0x00, 0x00, 0x00, 0x71, 0xdb, 0xdd, 0x0f,
	     0x00, 0x00, 0x00, 0x06, 0x62, 0x4b, 0x47, 0x44, 0x00, 0xff, 0x00,
	     0xff, 0x00, 0xff, 0xa0, 0xbd, 0xa7, 0x93, 0x00, 0x00, 0x00, 0x09,
	     0x70, 0x48, 0x59, 0x73, 0x00, 0x00, 0x0b, 0x13, 0x00, 0x00, 0x0b,
	     0x13, 0x01, 0x00, 0x9a, 0x9c, 0x18, 0x00, 0x00, 0x00, 0x07, 0x74,
	     0x49, 0x4d, 0x45, 0x07, 0xde, 0x01, 0x06, 0x10, 0x37, 0x03, 0xe9,
	     0xc3, 0xf3, 0x6d, 0x00, 0x00, 0x00, 0x1d, 0x69, 0x54, 0x58, 0x74,
	     0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x00, 0x00, 0x00, 0x00,
	     0x00, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69,
	     0x74, 0x68, 0x20, 0x47, 0x49, 0x4d, 0x50, 0x64, 0x2e, 0x65, 0x07,
	     0x00, 0x00, 0x04, 0x14, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0x35,
	     0xcd, 0x5d, 0x4c, 0x56, 0x65, 0x00, 0xc0, 0xf1, 0xff, 0xf3, 0x9c,
	     0x6f, 0x10, 0x04, 0x14, 0x14, 0x03, 0x11, 0xc9, 0x8f, 0x54, 0x96,
	     0x42, 0x5a, 0x2d, 0x5d, 0x19, 0xa6, 0x76, 0xd1, 0xec, 0xc6, 0x34,
	     0x6b, 0xf3, 0xa3, 0x39, 0xb3, 0x69, 0x6b, 0x6b, 0xb3, 0xac, 0x95,
	     0x5b, 0x8b, 0x5a, 0xb9, 0xd2, 0x0b, 0xaf, 0x32, 0xbd, 0xc0, 0xa5,
	     0xd5, 0x85, 0xce, 0x69, 0xf8, 0xb1, 0x35, 0x96, 0x92, 0x3a, 0x33,
	     0xdd, 0x50, 0xd4, 0xa5, 0x94, 0x86, 0x06, 0xa8, 0x7c, 0xc8, 0xfb,
	     0xf2, 0xbe, 0xe7, 0x9c, 0xe7, 0x9c, 0xe7, 0xe9, 0xa2, 0x75, 0xf5,
	     0xbb, 0xfc, 0x89, 0x9d, 0xed, 0xda, 0x08, 0x93, 0xe2, 0x49, 0x70,
	     0x03, 0x9b, 0x54, 0x43, 0x12, 0x2b, 0x54, 0xa2, 0x71, 0x3d, 0x17,
	     0x23, 0x04, 0x49, 0xa2, 0x29, 0xf0, 0x25, 0xd2, 0x80, 0x30, 0x9a,
	     0x02, 0x5f, 0x20, 0xb5, 0x60, 0x24, 0x34, 0x24, 0x06, 0x6c, 0x0f,
	     0x84, 0x05, 0xc3, 0x23, 0x8a, 0x5c, 0x5e, 0xa3, 0x8d, 0x8b, 0x6b,
	     0x49, 0xd2, 0x44, 0x61, 0xd9, 0x8a, 0xb2, 0xb2, 0x00, 0x93, 0x6a,
	     0xa2, 0x48, 0x62, 0x1b, 0x21, 0xd0, 0xa9, 0x26, 0xb2, 0x2c, 0xe6,
	     0xef, 0xfe, 0x08, 0x30, 0xb4, 0xbf, 0xf1, 0x29, 0x39, 0x17, 0x42,
	     0x09, 0xb6, 0x0b, 0x26, 0x94, 0x48, 0xa5, 0x09, 0x3c, 0x89, 0x52,
	     0x20, 0x02, 0x81, 0x0f, 0x10, 0x19, 0x4c, 0xaa, 0xc9, 0x69, 0x0b,
	     0xab, 0x48, 0x60, 0xa5, 0x2e, 0x22, 0x1f, 0x93, 0xb3, 0x24, 0x89,
	     0x07, 0x56, 0xe0, 0x90, 0x0d, 0x1d, 0x1c, 0x0b, 0x02, 0xdf, 0x42,
	     0x2a, 0x83, 0x1d, 0x27, 0x06, 0xd7, 0x76, 0xd0, 0x02, 0x12, 0xad,
	     0xb1, 0x2c, 0x0b, 0x27, 0x97, 0xe5, 0xbd, 0x55, 0x93, 0xd1, 0x5e,
	     0x80, 0xb2, 0x5c, 0x6e, 0x3d, 0xf1, 0x02, 0x27, 0xd7, 0x7c, 0x46,
	     0x54, 0x5a, 0x42, 0xd1, 0x40, 0x1f, 0xcb, 0xd6, 0x2d, 0xa6, 0x67,
	     0xde, 0x62, 0xce, 0x6e, 0xfa, 0x8a, 0x54, 0x6b, 0x1a, 0x5a, 0x3e,
	     0x67, 0x76, 0xeb, 0x5e, 0x8e, 0x6e, 0x3b, 0x40, 0xb6, 0x6a, 0x0e,
	     0x1b, 0xb7, 0x2d, 0xa5, 0xe2, 0xee, 0x75, 0xd0, 0x1a, 0x21, 0x04,
	     0x26, 0xd5, 0x74, 0x37, 0x2c, 0xe4, 0xc4, 0xb6, 0x16, 0xec, 0x30,
	     0x52, 0xb8, 0xae, 0x83, 0x46, 0x70, 0xf4, 0xcd, 0x66, 0xc6, 0x4a,
	     0xa8, 0x6b, 0x3b, 0xc4, 0x50, 0x65, 0x1d, 0x47, 0x56, 0x37, 0xe3,
	     0xa1, 0x59, 0xb2, 0xef, 0x63, 0x9e, 0xfc, 0x71, 0x3b, 0xa7, 0xd6,
	     0x35, 0x23, 0xca, 0x2b, 0xe9, 0x7c, 0x7e, 0x15, 0xd3, 0xcf, 0x1d,
	     0xc1, 0x7e, 0x38, 0xc0, 0x84, 0xae, 0x2b, 0xcc, 0x3e, 0xb6, 0x97,
	     0xd6, 0xcd, 0x3b, 0xe8, 0x9d, 0x3e, 0x97, 0xc2, 0xbe, 0x07, 0xb8,
	     0xe1, 0x08, 0x3f, 0x2f, 0xdb, 0xca, 0xed, 0x99, 0xcf, 0x62, 0x5b,
	     0x9a, 0x34, 0xce, 0x23, 0xc6, 0x8f, 0xc5, 0x06, 0x64, 0x2e, 0x4c,
	     0xc8, 0x8c, 0xc0, 0xb4, 0x4b, 0xc7, 0xd8, 0xb2, 0xa2, 0x8e, 0xfe,
	     0x14, 0x26, 0x74, 0xb4, 0x33, 0x52, 0x36, 0x8e, 0xee, 0xba, 0x46,
	     0x3a, 0xa6, 0xcc, 0x67, 0xa0, 0xbc, 0x86, 0xd1, 0xfd, 0x77, 0xc8,
	     0x86, 0x29, 0x99, 0x1c, 0x9c, 0x5e, 0xbe, 0x15, 0x19, 0x87, 0x4c,
	     0x39, 0xde, 0xc2, 0xc2, 0x1d, 0x6f, 0xd1, 0xfe, 0xda, 0x07, 0x5c,
	     0x9d, 0xbb, 0x94, 0xa1, 0x4c, 0x44, 0x41, 0x38, 0xc8, 0xa8, 0xe1,
	     0xfb, 0x9c, 0x99, 0xb7, 0x92, 0x9e, 0xda, 0xe9, 0xdc, 0xad, 0x99,
	     0x41, 0xf7, 0xc4, 0xc7, 0xe9, 0x0d, 0xca, 0xc9, 0x47, 0x06, 0xdb,
	     0x71, 0x7d, 0x32, 0x89, 0xa0, 0xec, 0xf2, 0x05, 0x6e, 0x34, 0x2e,
	     0xc5, 0x0c, 0x19, 0x4a, 0xfe, 0xbe, 0x41, 0xcf, 0xd4, 0x46, 0xa2,
	     0xb2, 0xd1, 0x54, 0x5d, 0x3c, 0xc7, 0x98, 0x9e, 0x2e, 0xce, 0x2f,
	     0x5a, 0x4b, 0xa4, 0xc0, 0xa8, 0x98, 0xa2, 0xd1, 0x2e, 0xc7, 0x57,
	     0x7f, 0xc1, 0x4b, 0xdf, 0xbc, 0xcd, 0xd5, 0x05, 0xcb, 0xb9, 0xd4,
	     0xb4, 0x86, 0x28, 0x93, 0x25, 0x36, 0x1e, 0xc5, 0x37, 0xaf, 0xa0,
	     0x2d, 0x8b, 0x95, 0x2d, 0x9b, 0xb1, 0x45, 0x8a, 0x30, 0x86, 0x7b,
	     0x15, 0xb5, 0xb4, 0xbe, 0xde, 0x4c, 0x41, 0x62, 0xb0, 0xb5, 0x11,
	     0x64, 0x14, 0x54, 0x5f, 0x3b, 0x4b, 0xe7, 0xc2, 0x95, 0xf8, 0x0f,
	     0x07, 0x71, 0xf2, 0x19, 0xea, 0xdb, 0xf6, 0x33, 0xe7, 0xc4, 0x1e,
	     0xa2, 0x82, 0x62, 0xfe, 0xaa, 0xaa, 0xa7, 0x6d, 0xc9, 0x46, 0x44,
	     0xa8, 0xc9, 0xc5, 0x20, 0x0b, 0xc0, 0xef, 0xef, 0x45, 0x0a, 0xe8,
	     0x2f, 0x7d, 0x84, 0x10, 0x09, 0x32, 0x20, 0x13, 0x0b, 0x2a, 0x2f,
	     0xb4, 0x31, 0x5c, 0x52, 0x09, 0x46, 0x13, 0xa7, 0x06, 0xcf, 0x86,
	     0xfe, 0xa2, 0x0a, 0x54, 0xac, 0xc9, 0x03, 0x76, 0x9c, 0x08, 0xac,
	     0x38, 0xa5, 0xb2, 0xf7, 0x0f, 0x5a, 0xab, 0xe7, 0x50, 0x38, 0xf2,
	     0x80, 0x92, 0xfe, 0x6e, 0x5a, 0xb6, 0x1c, 0x02, 0xd7, 0x62, 0xd8,
	     0x04, 0xfc, 0x69, 0x8f, 0xc5, 0x1e, 0xd6, 0xf8, 0xae, 0x44, 0x49,
	     0x97, 0xaa, 0xd3, 0x27, 0x59, 0x74, 0x78, 0x3b, 0x17, 0x67, 0xbd,
	     0x48, 0x43, 0xdb, 0x3e, 0xce, 0xcc, 0x5d, 0x8e, 0xa8, 0x28, 0xc5,
	     0xb8, 0x82, 0xfa, 0x6b, 0x6d, 0x1c, 0x58, 0xbb, 0x93, 0x8b, 0x33,
	     0x9a, 0x78, 0xf8, 0x20, 0xa6, 0xba, 0xca, 0x25, 0x8d, 0xc0, 0x89,
	     0x14, 0xd9, 0x44, 0x21, 0x35, 0x30, 0xb5, 0xaf, 0x83, 0x9c, 0x5f,
	     0x4c, 0x0f, 0xe5, 0x4c, 0xe8, 0xfa, 0x9d, 0xc1, 0xb2, 0x89, 0xdc,
	     0x9c, 0x54, 0xcf, 0x3f, 0xe3, 0x1f, 0x63, 0xb0, 0xa2, 0x16, 0xdb,
	     0x2f, 0x24, 0x0c, 0x15, 0xd9, 0x9c, 0xa6, 0x78, 0xb0, 0x8f, 0x97,
	     0x0f, 0x7f, 0xc2, 0x8d, 0xba, 0xa7, 0xd8, 0xb3, 0xe2, 0x6b, 0xac,
	     0x24, 0x66, 0xda, 0xaf, 0x07, 0x19, 0x88, 0x04, 0x95, 0x77, 0x6e,
	     0x63, 0xe9, 0x94, 0x2b, 0xfe, 0x14, 0xa2, 0x08, 0x62, 0x63, 0xb8,
	     0xdb, 0x17, 0xe2, 0xf9, 0x90, 0x1a, 0x8b, 0x30, 0x9f, 0x60, 0x47,
	     0x06, 0x26, 0x75, 0x9d, 0x27, 0x5b, 0x58, 0x46, 0x7f, 0x30, 0x86,
	     0x49, 0x1d, 0xbf, 0x70, 0x7d, 0xc6, 0x73, 0xc4, 0x31, 0x48, 0x23,
	     0x40, 0x18, 0x3c, 0x4b, 0xa2, 0x8c, 0x21, 0x8b, 0x64, 0xd3, 0x81,
	     0x77, 0xc0, 0x18, 0xbe, 0x7d, 0x65, 0x17, 0x8e, 0x80, 0xef, 0x9a,
	     0x3e, 0x64, 0xfd, 0x4f, 0xef, 0xd3, 0xd6, 0xb0, 0x82, 0xc9, 0xd7,
	     0x4f, 0xa1, 0x2d, 0x9b, 0x0d, 0x07, 0xdf, 0xc5, 0x38, 0x1e, 0xda,
	     0x68, 0x4c, 0x9a, 0x72, 0x74, 0xc3, 0x97, 0x0c, 0x16, 0x56, 0xa3,
	     0x22, 0x89, 0x0c, 0x55, 0x8c, 0x9f, 0x19, 0xe0, 0x56, 0x6d, 0x23,
	     0x19, 0xcf, 0xc1, 0xc9, 0x0c, 0x71, 0x69, 0xe6, 0x12, 0x12, 0x05,
	     0xa1, 0x02, 0xa5, 0x04, 0xc2, 0x18, 0x1c, 0xd7, 0xa5, 0xe9, 0xb7,
	     0xef, 0xb1, 0x13, 0xc5, 0xae, 0x57, 0x77, 0x13, 0x5a, 0x2e, 0x69,
	     0x62, 0xb8, 0xfc, 0xe8, 0x02, 0x3a, 0x6a, 0x9e, 0xe6, 0x99, 0xd3,
	     0x2d, 0x04, 0xf7, 0xfb, 0xe8, 0xae, 0x99, 0x85, 0xb2, 0x1d, 0x42,
	     0xa5, 0x10, 0x52, 0x10, 0xd9, 0x3e, 0xf7, 0x43, 0x17, 0x3b, 0x90,
	     0xd8, 0x9e, 0x8f, 0x58, 0xff, 0x43, 0xc6, 0x38, 0xc1, 0x28, 0x3c,
	     0x0f, 0xa2, 0x61, 0x43, 0x2e, 0x85, 0xc2, 0x40, 0xe0, 0x59, 0x06,
	     0xc1, 0x7f, 0xd9, 0xff, 0x46, 0x5a, 0x90, 0x4f, 0xc1, 0x28, 0x83,
	     0x11, 0x60, 0x10, 0x24, 0x1a, 0x06, 0x43, 0x43, 0x3e, 0x9f, 0xa3,
	     0xa0, 0xb4, 0x90, 0x31, 0xe3, 0x20, 0x1f, 0x43, 0x67, 0xe7, 0x3d,
	     0x6a, 0x6b, 0x2b, 0x50, 0x0a, 0xc8, 0x85, 0xd4, 0x57, 0xf9, 0x88,
	     0xc4, 0xf0, 0x2f, 0xb4, 0x16, 0xf4, 0xd5, 0x82, 0x00, 0xa9, 0x50,
	     0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60,
	     0x82 ),
      28, 12,
      DATA ( 0x90c4fe, 0x91c3fb, 0x98c5fb, 0x9eceff, 0x9bccff, 0x97c6fa,
	     0x92c2f8, 0x98c9fe, 0x97caff, 0x93c6fd, 0x9dceff, 0x9fcdff,
	     0xa0ccfd, 0xaad4fe, 0xacd2ff, 0xa1cafe, 0x9dc9fe, 0xa1d0fe,
	     0xa2d3fe, 0x94c8f9, 0x8abff7, 0x88befd, 0x8ec1ff, 0x8bbdfa,
	     0x8ec1f5, 0xa0d3fe, 0x9fd0fc, 0x98c9fe, 0x8fc5ff, 0x8ec1f9,
	     0x91c6fc, 0xd4697c, 0xd4697b, 0x98ccff, 0x88ccff, 0x8aceff,
	     0x8ed4ff, 0x8dccff, 0x95c9fd, 0x9ed0ff, 0x9acbfd, 0xa1ddff,
	     0xa9ddff, 0xa1cbfd, 0x9cc7fb, 0x97cefe, 0x9addff, 0x97d0ff,
	     0x8bbff9, 0x7ec1ff, 0x84c8ff, 0x87caff, 0x7fc2ff, 0x93d6ff,
	     0x9cdbff, 0x9acbfe, 0x89c1fe, 0x8fc5fe, 0x8fc7fe, 0xd0677a,
	     0xd36a7d, 0x9dc2f3, 0xff1c15, 0xfd231e, 0xf82624, 0xd85a69,
	     0x92baef, 0x97cbff, 0xa4b9e6, 0xf32d2c, 0xda6372, 0xa1cfff,
	     0x99c9fb, 0xc97085, 0xf92623, 0xada5ca, 0x8bc1fb, 0xe74047,
	     0xfd251f, 0xfd231d, 0xfe241e, 0xfd211c, 0xe0535d, 0x99d2ff,
	     0x81baf9, 0x8fc7fe, 0x8dc7ff, 0x84cfff, 0x98d1ff, 0xbb90ae,
	     0xef3538, 0xa294bd, 0xa994bb, 0xf03739, 0xc9647a, 0x8bc6ff,
	     0x98ceff, 0xc86f86, 0xf03739, 0xa5c0ed, 0xb39dc1, 0xf92723,
	     0xaf93b2, 0x95cdff, 0x96b6eb, 0xed383c, 0xba7498, 0x9b9fd7,
	     0x9fa2d5, 0x9c9ccc, 0x9db4e0, 0x9dd2ff, 0x77b2f5, 0x82bcfe,
	     0xb496b6, 0xfa2622, 0x85ceff, 0xd56272, 0xe4474f, 0x85b7f0,
	     0x7bb9f7, 0xde4c58, 0xd8515e, 0x7fbefc, 0x8bc4ff, 0x8bc4ff,
	     0xf23131, 0xca788f, 0xf42c2b, 0xbd829d, 0x85c8fa, 0x85c0f8,
	     0xa0aeda, 0xf92a27, 0x80aaf0, 0x82c0ff, 0x84c1ff, 0x7fbafb,
	     0x85bdf5, 0x94cbfe, 0x7cb8fd, 0x75b8ff, 0xc66982, 0xd5596a,
	     0x84befe, 0xe5444d, 0xcc6a80, 0x7ec9ff, 0x9797c7, 0xf13335,
	     0xbb7796, 0x78b9fc, 0x7eb9f9, 0x8bc8ff, 0xaa90ba, 0xf72a28,
	     0xcd677d, 0x8cc5fd, 0x7ebbf1, 0x78baf8, 0xae8aae, 0xf72d2a,
	     0xd84c5d, 0xdc4d5a, 0xdd4c59, 0xc7627a, 0x7dbeff, 0x8fc7fe,
	     0x7ab7fe, 0x68b2ff, 0xe34049, 0xb881a1, 0x8cafed, 0xea3b40,
	     0xf92926, 0xfd231d, 0xf62d2b, 0xd54958, 0x7abeff, 0x79b6fd,
	     0x74b0f9, 0x80c3ff, 0xb27da2, 0xf92b28, 0xba7898, 0x84c5ff,
	     0x7ebdfa, 0x6bb7fb, 0xc7566d, 0xe93d43, 0xd84b5b, 0xd64959,
	     0xdd4d59, 0xb46f90, 0x78b8fd, 0x86befd, 0x74b3ff, 0x6bacfc,
	     0xfc2823, 0x999ed2, 0x97a4d9, 0xfa2823, 0x9c9ed2, 0x9ca4d5,
	     0x8ea3de, 0x6ca7f2, 0x70b0fd, 0x78b6ff, 0x6fb2ff, 0x9c86b9,
	     0xf62e2d, 0xc75771, 0xec373b, 0x80aded, 0x7fc3fe, 0x6ac3ff,
	     0xf42d2c, 0x9b8ebc, 0x69b8ff, 0x5aa4f9, 0x77c0ff, 0x74b9ff,
	     0x79b2fa, 0x7ab4f5, 0x72b3ff, 0x9195ce, 0xf23031, 0x809ee7,
	     0xb181a6, 0xe93a41, 0x78beff, 0x82bcfe, 0x7db9ff, 0x70affd,
	     0x68a8f8, 0x6cacfd, 0x7da1e8, 0xec373b, 0xd15165, 0x64aeff,
	     0xef3335, 0xa7729b, 0x6dbcff, 0x83a7e0, 0xf72b29, 0x6f96e1,
	     0x62b1ff, 0x54a3f8, 0x5ca9f7, 0x7bc1ff, 0x76b1fd, 0x72abf1,
	     0x6bb2ff, 0xb17298, 0xe63b43, 0x6da7fa, 0xd15367, 0xc16481,
	     0x72b8ff, 0x7ab7ff, 0x7ab8fe, 0x77b2ff, 0x6ba7f7, 0x60acff,
	     0xd84858, 0xec363a, 0x6da7f9, 0x69afff, 0x9476b0, 0xf92b28,
	     0x66a4f2, 0xa57ca2, 0xf52e2d, 0xd64454, 0xd5495b, 0xd34859,
	     0xd24556, 0x86ace0, 0x75b7fd, 0x6daaf3, 0x63adf9, 0xb96586,
	     0xc65c76, 0x60aeff, 0xd64657, 0x908fc8, 0x6eb3ff, 0x72b2ff,
	     0x75b3ff, 0x78b1fe, 0x70adfd, 0xa377a7, 0xdc4453, 0x808fd5,
	     0x65aaff, 0x66abfe, 0x679aed, 0xcb4a61, 0xa16794, 0xae678b,
	     0xd84d59, 0xd14859, 0xcd4456, 0xd44a5a, 0xcb495e, 0x71a4e6,
	     0x79c0ff, 0x71b1fb, 0x65a9f3, 0x6ab2ff, 0x71b9ff, 0x6aabfe,
	     0x60a8fe, 0x6bb1ff, 0x72b4fe, 0x73b4ff, 0x74b3fe, 0x75b3ff,
	     0x76b2fe, 0x6fb0ff, 0x66adff, 0x65a8fe, 0x64a9fe, 0x63a9ff,
	     0x5fa7ff, 0x4e9ffe, 0x4596f4, 0x4fa7ff, 0x62beff, 0x59b8ff,
	     0x2e8de9, 0x4faeff, 0x4aa9ff, 0x4a9ff7, 0x77bbff, 0x78b7fe ) );

/**
 * Perform PNG self-test
 *
 */
static void png_test_exec ( void ) {

	/* Original image */
	pixbuf_ok ( &original );

	/* All allowed colour type and bit depth combinations */
	pixbuf_ok ( &ctype_0_1 );
	pixbuf_ok ( &ctype_0_2 );
	pixbuf_ok ( &ctype_0_4 );
	pixbuf_ok ( &ctype_0_8 );
	pixbuf_ok ( &ctype_0_16 );
	pixbuf_ok ( &ctype_2_8 );
	pixbuf_ok ( &ctype_2_16 );
	pixbuf_ok ( &ctype_3_1 );
	pixbuf_ok ( &ctype_3_2 );
	pixbuf_ok ( &ctype_3_4 );
	pixbuf_ok ( &ctype_3_8 );
	pixbuf_ok ( &ctype_4_8 );
	pixbuf_ok ( &ctype_4_16 );
	pixbuf_ok ( &ctype_6_8 );
	pixbuf_ok ( &ctype_6_16 );

	/* All basic filter types */
	pixbuf_ok ( &filter_0 );
	pixbuf_ok ( &filter_1 );
	pixbuf_ok ( &filter_2 );
	pixbuf_ok ( &filter_3 );
	pixbuf_ok ( &filter_4 );

	/* Multiple IDAT sections */
	pixbuf_ok ( &multi_idat );

	/* Interlaced */
	pixbuf_ok ( &interlaced );
	pixbuf_ok ( &interlaced_w1 );
	pixbuf_ok ( &interlaced_w2 );
	pixbuf_ok ( &interlaced_w3 );
	pixbuf_ok ( &interlaced_w4 );
	pixbuf_ok ( &interlaced_h1 );
	pixbuf_ok ( &interlaced_h2 );
	pixbuf_ok ( &interlaced_h3 );
	pixbuf_ok ( &interlaced_h4 );

	/* Alpha channel */
	pixbuf_ok ( &alpha );
}

/** PNG self-test */
struct self_test png_test __self_test = {
	.name = "png",
	.exec = png_test_exec,
};
