.\"
.\" "$Id: cups.man 11822 2014-04-21 11:49:06Z msweet $"
.\"
.\" cups (intro) man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cups 1 "CUPS" "16 April 2014" "Apple Inc."
.SH NAME
cups \- a standards-based, open source printing system
.SH DESCRIPTION
.B CUPS
is the software you use to print from applications like word processors, email readers, photo editors, and web browsers. It converts the page descriptions produced by your application (put a paragraph here, draw a line there, and so forth) into something your printer can understand and then sends the information to the printer for printing.
.LP
Now, since every printer manufacturer does things differently, printing can be very complicated.
.B CUPS
does its best to hide this from you and your application so that you can concentrate on printing and less on how to print. Generally, the only time you need to know anything about your printer is when you use it for the first time, and even then
.B CUPS
can often figure things out on its own.
.SS HOW DOES IT WORK?
The first time you print to a printer,
.B CUPS
creates a queue to keep track of the current status of the printer (everything OK, out of paper, etc.) and any pages you have printed. Most of the time the queue points to a printer connected directly to your computer via a USB port, however it can also point to a printer on your network, a printer on the Internet, or multiple printers depending on the configuration. Regardless of where the queue points, it will look like any other printer to you and your applications.
.LP
Every time you print something,
.B CUPS
creates a job which contains the queue you are sending the print to, the name of the document you are printing, and the page descriptions. Job are numbered (queue-1, queue-2, and so forth) so you can monitor the job as it is printed or cancel it if you see a mistake. When
.B CUPS
gets a job for printing, it determines the best programs (filters, printer drivers, port monitors, and backends) to convert the pages into a printable format and then runs them to actually print the job.
.LP
When the print job is completely printed,
.B CUPS
removes the job from the queue and moves on to any other jobs you have submitted. You can also be notified when the job is finished, or if there are any errors during printing, in several different ways.
.SS WHERE DO I BEGIN?
The easiest way to start is by using the web interface to configure your printer. Go to "http://localhost:631" and choose the Administration tab at the top of the page. Click/press on the Add Printer button and follow the prompts.
.LP
When you are asked for a username and password, enter your login username and password or the "root" username and password.
.LP
After the printer is added you will be asked to set the default printer options (paper size, output mode, etc.) for the printer. Make any changes as needed and then click/press on the Set Default Options button to save them. Some printers also support auto-configuration - click/press on the Query Printer for Default Options button to update the options automatically.
.LP
Once you have added the printer, you can print to it from any application. You can also choose Print Test Page from the maintenance menu to print a simple test page and verify that everything is working properly.
.LP
You can also use the
.BR lpadmin (8)
and
.BR lpinfo (8)
commands to add printers to
.BR CUPS .
Additionally, your operating system may include graphical user interfaces or automatically create printer queues when you connect a printer to your computer.
.SS HOW DO I GET HELP?
The
.B CUPS
web site (http://www.CUPS.org) provides access to the
.I cups
and
.I cups-devel
mailing lists, additional documentation and resources, and a bug report database. Most vendors also provide online discussion forums to ask printing questions for your operating system of choice.
.SH ENVIRONMENT
.B CUPS
commands use the following environment variables to override the default locations of files and so forth. For security reasons, these environment variables are ignored for setuid programs:
.TP 5
.B CUPS_ANYROOT
Whether to allow any X.509 certificate root (Y or N).
.TP 5
.B CUPS_CACHEDIR
The directory where semi-persistent cache files can be found.
.TP 5
.B CUPS_DATADIR
The directory where data files can be found.
.TP 5
.B CUPS_ENCRYPTION
The default level of encryption (Always, IfRequested, Never, Required).
.TP 5
.B CUPS_EXPIREDCERTS
Whether to allow expired X.509 certificates (Y or N).
.TP 5
.B CUPS_GSSSERVICENAME
The Kerberos service name used for authentication.
.TP 5
.B CUPS_SERVER
The hostname/IP address and port number of the CUPS scheduler (hostname:port or ipaddress:port).
.TP 5
.B CUPS_SERVERBIN
The directory where server helper programs, filters, backend, etc. can be found.
.TP 5
.B CUPS_SERVERROOT
The root directory of the server.
.TP 5
.B CUPS_STATEDIR
The directory where state files can be found.
.TP 5
.B CUPS_USER
Specifies the name of the user for print requests.
.TP 5
.B HOME
Specifies the home directory of the current user.
.TP 5
.B IPP_PORT
Specifies the default port number for IPP requests.
.TP 5
.B LOCALEDIR
Specifies the location of localization files.
.TP 5
.B LPDEST
Specifies the default print queue (System V standard).
.TP 5
.B PRINTER
Specifies the default print queue (Berkeley standard).
.TP 5
.B TMPDIR
Specifies the location of temporary files.
.SH FILES
.nf
.I ~/.cups/client.conf
.I ~/.cups/lpoptions
.fi
.SH CONFORMING TO
.B CUPS
conforms to the Internet Printing Protocol version 2.1 and implements the Berkeley and System V UNIX print commands.
.SH SEE ALSO
.BR cancel (1),
.BR client.conf (7),
.BR cupsctl (8),
.BR cupsd (8),
.BR lp (1),
.BR lpadmin (8),
.BR lpinfo (8),
.BR lpoptions (1),
.BR lpr (1),
.BR lprm (1),
.BR lpq (1),
.BR lpstat (1),
CUPS Online Help (http://localhost:631/help),
CUPS Web Site (http://www.CUPS.org),
PWG Internet Printing Protocol Workgroup (http://www.pwg.org/ipp)
.SH COPYRIGHT
Copyright \[co] 2007-2014 by Apple Inc.
.\"
.\" End of "$Id: cups.man 11822 2014-04-21 11:49:06Z msweet $".
.\"
