.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtSet-Keyboard-Focus wid-get
.na
.TH XtSetKeyboardFocus __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtSetKeyboardFocus \- focus events on a child widget
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtSetKeyboardFocus(Widget \fIsubtree\fP, Widget \fIdescendant\fP);
.SH ARGUMENTS
.IP \fIsubtree\fP 1i
Specifies either the widget in the subtree structure which is to receive the
keyboard event, or
.BR None .
Note that it is not an error to specify
.B None
when no input focus was previously set.
.IP \fIdescendant\fP 1i
Specifies the widget for which the keyboard focus is to be set.
.SH DESCRIPTION
If a future
.B KeyPress
or
.B KeyRelease
event occurs within the specified subtree,
.B XtSetKeyboardFocus
causes
.B XtDispatchEvent
to remap and send the event to the specified descendant widget.
.LP
When there is no modal cascade,
keyboard events can occur within a widget W in one of three ways:
.IP \(bu 5
W has the X input focus.
.IP \(bu 5
W has the keyboard focus of one of its ancestors,
and the event occurs within the ancestor or one of the ancestor's descendants.
.IP \(bu 5
No ancestor of W has a descendant within the keyboard focus,
and the pointer is within W.
.LP
When there is a modal cascade,
a widget W receives keyboard events if an ancestor of W is in the active
subset of the modal cascade and one or more of the previous conditions is
.BR True .
.LP
When subtree or one of its descendants acquires the X input focus
or the pointer moves into the subtree such that keyboard events would
now be delivered to subtree, a
.B FocusIn
event is generated for the descendant if
.B FocusNotify
events have been selected by the descendant.
Similarly, when W loses the X input focus
or the keyboard focus for one of its ancestors, a
.B FocusOut
event is generated for descendant if
.B FocusNotify
events have been selected by the descendant.
.SH "SEE ALSO"
XtCallAcceptFocus(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
