import QtQuick
import QtQuick3D
import Generated.ComponentBundles.MaterialBundle

Node {
    id: node
    property bool computerOn
    scale.x: 20
    scale.y: 20
    scale.z: 20

    // Resources
    property url textureData: "maps/textureData.png"
    Texture {
        id: _0_texture
        generateMipmaps: true
        mipFilter: Texture.Linear
        source: node.textureData
    }

    // Nodes:
    Node {
        id: root
        objectName: "ROOT"
        Model {
            id: shelf
            objectName: "shelf"
            x: 0.8612052202224731
            y: 2.2086312770843506
            z: 14.904927253723145
            rotation: Qt.quaternion(0.962235, 0, 0.272219, 0)
            scale.x: 3.49546
            scale.y: 0.306295
            scale.z: 3.42443
            source: "meshes/cube_009_mesh.mesh"
            receivesShadows: true
            materials: darkWood
        }

        Model {
            id: stool
            objectName: "stool"
            x: 23.590526580810547
            y: 8.943203926086426
            z: 29.924942016601562
            rotation: Qt.quaternion(0.989037, 0, 0.147666, 0)
            scale.x: 3.2509
            scale.y: 0.548692
            scale.z: 3.2509
            source: "meshes/stool_mesh.mesh"
            receivesShadows: true
            materials: [fabric,darkWood]
        }

        Model {
            id: bigCandle
            objectName: "bigCandle"
            x: -6.650283336639404
            y: 31.326107025146484
            z: 15.047586441040039
            scale.x: 0.779315
            scale.y: 0.965801
            scale.z: 0.858924
            source: "meshes/bigCandle_mesh.mesh"
            receivesShadows: true
            materials: [waxCopy,ceramic]
        }

        Model {
            id: tallCandle
            objectName: "tallCandle"
            x: 38.54404830932617
            y: 14.028493881225586
            z: 16.586271286010742
            rotation: Qt.quaternion(0.646027, 0, 0.763315, 0)
            scale.x: 1.60416
            scale.y: 0.0372449
            scale.z: 1.51943
            source: "meshes/tallCandle_mesh.mesh"
            receivesShadows: true
            materials: [wax,copper]
        }

        Model {
            id: table
            objectName: "table"
            x: 26.997087478637695
            y: 2.30503249168396
            z: 18.224262237548828
            rotation: Qt.quaternion(0.166655, 0, 0.986015, 0)
            scale.x: 7.18176
            scale.y: 0.207605
            scale.z: 4.38158
            source: "meshes/cube_001_mesh.mesh"
            receivesShadows: true
            materials: darkWood
        }

        Model {
            id: coffeeCup
            objectName: "coffeeCup"
            x: 15.513427734375
            y: 14.027426719665527
            z: 20.39453125
            rotation: Qt.quaternion(-0.18195, 0, 0.983308, 0)
            scale.x: 0.639906
            scale.y: 0.0234309
            scale.z: 0.639891
            source: "meshes/coffeeCup_mesh.mesh"
            receivesShadows: true
            materials: [ceramic,rubber]
        }

        Model {
            id: book
            objectName: "book"
            x: 5.756752014160156
            y: 19.152517318725586
            z: 8.733080863952637
            rotation: Qt.quaternion(0.448905, -0.132351, 0.858767, 0.208533)
            scale.x: 0.583392
            scale.y: 0.583392
            scale.z: 0.583392
            source: "meshes/book_mesh.mesh"
            receivesShadows: true
            materials: [paper1,acrylicPaint1]
        }

        Model {
            id: book_002
            objectName: "book.002"
            x: 3.990490198135376
            y: 18.987133026123047
            z: 10.860294342041016
            rotation: Qt.quaternion(0.474645, -0.0354606, 0.87945, 0.00473273)
            scale.x: 0.583392
            scale.y: 0.583392
            scale.z: 0.583392
            source: "meshes/book_002_mesh.mesh"
            receivesShadows: true
            materials: [paper1,acrylicPaint1]
        }

        Model {
            id: book_003
            objectName: "book.003"
            x: -2.5132369995117188
            y: 17.08222198486328
            z: 14.278441429138184
            rotation: Qt.quaternion(0.462656, 0.188434, 0.792117, -0.350703)
            scale.x: 0.583392
            scale.y: 0.583392
            scale.z: 0.583392
            source: "meshes/book_003_mesh.mesh"
            receivesShadows: true
            materials: [paper,acrylicPaint3]
        }
        Model {
            id: book_004
            objectName: "book.004"
            x: 3.107
            y: 10.332
            z: 10.85843
            scale.x: 0.363335
            scale.y: 0.363335
            scale.z: 0.363335
            source: "meshes/book_004_mesh.mesh"
            receivesShadows: true
            eulerRotation.z: -6.56897
            eulerRotation.y: -112.64462
            eulerRotation.x: 43.92728
            materials: [paper2,acrylicPaint3]
        }
        Model {
            id: book_005
            objectName: "book.005"
            x: -5.086559772491455
            y: 10.270957946777344
            z: 14.614971160888672
            rotation: Qt.quaternion(-0.368716, 0.861019, 0.161606, 0.31077)
            scale.x: 0.44612
            scale.y: 0.44612
            scale.z: 0.44612
            source: "meshes/book_005_mesh.mesh"
            receivesShadows: true
            materials: [paper2,acrylicPaint1]
        }

        Model {
            id: book_006
            objectName: "book.006"
            x: -6.760748863220215
            y: 11.327892303466797
            z: 16.434104919433594
            rotation: Qt.quaternion(0.447866, -0.0917207, 0.88152, 0.11801)
            scale.x: 0.363335
            scale.y: 0.363335
            scale.z: 0.363335
            source: "meshes/book_006_mesh.mesh"
            receivesShadows: true
            materials: [paper2,acrylicPaint3]
        }

        Model {
            id: book_007
            objectName: "book.007"
            x: -1.0116069316864014
            y: 3.480590343475342
            z: 14.002421379089355
            rotation: Qt.quaternion(-0.368716, 0.861019, 0.161606, 0.31077)
            scale.x: 0.44612
            scale.y: 0.44612
            scale.z: 0.44612
            source: "meshes/book_007_mesh.mesh"
            receivesShadows: true
            materials: [paper1,acrylicPaint3]
        }

        Model {
            id: book_008
            objectName: "book.008"
            x: 0.27849817276000977
            y: 4.36872673034668
            z: 11.34302806854248
            rotation: Qt.quaternion(-0.165277, 0.912121, 0.0721117, 0.368128)
            scale.x: 0.44612
            scale.y: 0.44612
            scale.z: 0.44612
            source: "meshes/book_008_mesh.mesh"
            receivesShadows: true
            materials: [paper2,acrylicPaint2]
        }

        Model {
            id: book_009
            objectName: "book.009"
            x: 5.809816837310791
            y: 5.0655107498168945
            z: 8.126066207885742
            rotation: Qt.quaternion(-0.166529, -0.55137, -0.295772, 0.762088)
            scale.x: 0.44612
            scale.y: 0.44612
            scale.z: 0.44612
            source: "meshes/book_009_mesh.mesh"
            receivesShadows: true
            materials: [paper2,acrylicPaint1]
        }

        Model {
            id: keyboard
            objectName: "keyboard"
            x: 21.7282657623291
            y: 14.471997261047363
            z: 23.340158462524414
            rotation: Qt.quaternion(0.996854, 0.0792551, 0, 0)
            scale.x: 4.03661
            scale.y: 1.43318
            scale.z: 1.43318
            source: "meshes/keyboard_mesh.mesh"
            receivesShadows: true
            materials: [plasticMatte,plasticTextured]
        }

        Model {
            id: monitor
            objectName: "monitor"
            x: 26.503435134887695
            y: 20.149261474609375
            z: 16.700363159179688
            rotation: Qt.quaternion(0.631042, -0.086077, -0.76772, 0.0705843)
            scale.x: 3.28239
            scale.y: 2.67299
            scale.z: 3.28239
            source: "meshes/monitor_mesh.mesh"
            receivesShadows: true
            materials: [ledMaterial,plasticTextured,monitorScreenMaterial]
        }

        Model {
            id: mouse
            objectName: "mouse"
            x: 32.512664794921875
            y: 14.60537052154541
            z: 24.130369186401367
            rotation: Qt.quaternion(0.991673, 0, 0.128784, 0)
            scale.x: 0.845858
            scale.y: 0.845857
            scale.z: 0.845858
            source: "meshes/mouse_mesh.mesh"
            receivesShadows: true
            materials: [plasticShiny,plasticTextured]
        }

        Model {
            id: mousePad
            objectName: "mousePad"
            x: 33.37522506713867
            y: 14.169995307922363
            z: 24.25016212463379
            rotation: Qt.quaternion(0, 0.93693, 0, 0.349517)
            scale.x: 4.02394
            scale.y: 0.0572671
            scale.z: 2.7114
            source: "meshes/cube_011_mesh.mesh"
            receivesShadows: true
            materials: fabricRough1
        }

        Model {
            id: suzanne
            objectName: "Suzanne"
            x: 4.074446201324463
            y: 24.36581802368164
            z: 9.318511009216309
            rotation: Qt.quaternion(0.94618, -0.308675, -0.0922936, -0.0307485)
            scale.x: 2.13511
            scale.y: 2.13511
            scale.z: 2.13511
            source: "meshes/suzanne_mesh.mesh"
            receivesShadows: true
            materials: plasticShiny1
        }

        Model {
            id: computer
            objectName: "computer"
            x: 26.898
            y: 15.700957298278809
            z: 15.311223030090332
            rotation: Qt.quaternion(0.976636, 0, -0.2149, 0)
            scale.x: 4.96433
            scale.y: 1.65478
            scale.z: 5.79172
            source: "meshes/computer_mesh.mesh"
            receivesShadows: true
            materials: [plasticMatte,plasticTextured,plasticShiny,ledMaterial,plasticMatte,ledMaterial,ledMaterial]
        }

        Model {
            id: wall
            objectName: "wall"
            x: 1.2337802648544312
            y: 1.3406834602355957
            z: 0.6662785410881042
            rotation: Qt.quaternion(0, 0, 1, 0)
            scale.x: 20.7687
            scale.y: 0.977228
            scale.z: 20.756
            source: "meshes/cube_mesh.mesh"
            receivesShadows: true
            materials: woodPlanks
        }

        Model {
            id: floor
            objectName: "floor"
            x: 1.2337802648544312
            y: 1.3406834602355957
            z: 0.6662785410881042
            rotation: Qt.quaternion(0, 0, 1, 0)
            scale.x: 20.7687
            scale.y: 0.977228
            scale.z: 20.756
            source: "meshes/cube_012_mesh.mesh"
            receivesShadows: true
            materials: woodParquet
        }

        Model {
            id: backWall
            objectName: "backWall"
            x: 1.2337802648544312
            y: 1.3406834602355957
            z: 0.6662785410881042
            rotation: Qt.quaternion(0, 0, 1, 0)
            scale.x: 20.7687
            scale.y: 0.977228
            scale.z: 20.756
            source: "meshes/cube_013_mesh.mesh"
            receivesShadows: true
            materials: woodPlanks
        }

        Model {
            id: window
            objectName: "window"
            x: 1.2337802648544312
            y: 1.3406834602355957
            z: 0.6662785410881042
            rotation: Qt.quaternion(0, 0, 1, 0)
            scale.x: 20.7687
            scale.y: 0.977228
            scale.z: 20.756
            source: "meshes/cube_010_mesh.mesh"
            receivesShadows: true
            materials: windowMaterial
        }
    }

    Node {
        id: __materialLibrary__

        PrincipledMaterial {
            id: monitorScreenMaterial
            baseColor: "#ffffff"
            attenuationColor: "#ffffff"
            objectName: "monitorScreenMaterial"
            baseColorMap: _0_texture
            roughness: 0.5
            cullMode: PrincipledMaterial.NoCulling
            alphaMode: PrincipledMaterial.Opaque
            emissiveFactor: computerOn ? Qt.vector3d(1, 2, 3) : Qt.vector3d(0, 0, 0)
        }

        PrincipledMaterial {
            id: windowMaterial
            opacity: 0.35
            roughness: 0.6
            clearcoatRoughnessAmount: 0.02
            clearcoatAmount: 0.3
            objectName: "windowMaterial"
            baseColor: "#383838"
            metalness: 0.2
            cullMode: PrincipledMaterial.NoCulling
            alphaMode: PrincipledMaterial.Blend
            indexOfRefraction: 1.5
        }

        WoodMaterial {
            id: wood
            objectName: "Wood"
        }

        WoodParquetMaterial {
            id: woodParquet
            objectName: "Wood Parquet"
        }

        WoodPlanksMaterial {
            id: woodPlanks
            objectName: "Wood Planks"
        }

        WaxMaterial {
            id: wax
            objectName: "Wax"
        }

        PlasticTexturedMaterial {
            id: plasticTextured
            baseColor: "#615858"
            objectName: "Plastic Textured"
        }

        PlasticMatteMaterial {
            id: plasticMatte
            baseColor: "#8a8585"
            objectName: "Plastic Matte"
        }

        PlasticShinyMaterial {
            id: plasticShiny
            baseColor: "#c2bcbc"
            objectName: "Plastic Shiny"
        }

        AcrylicPaintMaterial {
            id: acrylicPaint
            objectName: "Acrylic Paint"
        }

        FabricRoughMaterial {
            id: fabricRough
            objectName: "Fabric Rough"
        }

        FabricMaterial {
            id: fabric
            baseColor: "#7390b6"
            objectName: "Fabric"
        }

        CopperMaterial {
            id: copper
            objectName: "Copper"
        }

        WoodMaterial {
            id: darkWood
            baseColor: "#9e6a2a"
            objectName: "darkWood"
        }

        WaxMaterial {
            id: waxCopy
            subsurfaceColor: "#c44f07"
            baseColor: "#c20909"
            objectName: "Wax copy"
        }

        CeramicMaterial {
            id: ceramic
            baseColor: "#2a4f79"
            objectName: "Ceramic"
        }

        FabricRoughMaterial {
            id: fabricRough1
            baseColor: "#05510a"
            objectName: "Fabric Rough"
        }

        PaperMaterial {
            id: paper
            objectName: "Paper"
        }

        PaperMaterial {
            id: paper1
            baseColor: "#736e6e"
            objectName: "Paper"
        }

        PaperMaterial {
            id: paper2
            baseColor: "#e0d385"
            objectName: "Paper"
        }

        AcrylicPaintMaterial {
            id: acrylicPaint1
            objectName: "Acrylic Paint"
        }

        AcrylicPaintMaterial {
            id: acrylicPaint2
            baseColor: "#f15609"
            objectName: "Acrylic Paint 2"
        }

        AcrylicPaintMaterial {
            id: acrylicPaint3
            objectName: "Acrylic Paint 3"
            baseColor: "#b90000"
        }

        RubberMaterial {
            id: rubber
            objectName: "Rubber"
        }

        PaperMaterial {
            id: paper3
            objectName: "Paper"
        }

        PrincipledMaterial {
            id: ledMaterial
            emissiveFactor.y: computerOn ? 7.7053 : 0
            objectName: "ledMaterial"
        }

        RubberMaterial {
            id: rubber1
            objectName: "Rubber"
        }

        PlasticShinyMaterial {
            id: plasticShiny1
            baseColor: "#ffd400"
            objectName: "Plastic Shiny"
        }
    }

    // Animations:
}

/*##^##
Designer {
    D{i:0;cameraSpeed3d:25;cameraSpeed3dMultiplier:1;matPrevEnvDoc:"SkyBox";matPrevEnvValueDoc:"preview_studio";matPrevModelDoc:"#Sphere"}
}
##^##*/
