import QtQuick
import QtQuick.Shapes
import QtQuick.Timeline
import QtQuick.Studio.Components
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo

Item {
    id: root
    width: 495
    height: 222
    property color partyMode: "#58ea1b"
    property bool pulse: false
    property bool themeSwitch: false
    property int timing: 550
    property color highlightFront: "#fb5020"
    property bool paused: false
    property bool effectsOn: true

    Rectangle {
        id: glassPanel
        x: 0
        y: 0
        width: 495
        height: 222
        color: "#171717"
        radius: 55

        DesignEffect {
            id: glassEffect
            layerBlurRadius: 3
            visible: root.effectsOn
        }

        EllipseItem {
            id: ellipse
            x: 354
            y: 24
            width: 50
            height: 50
            strokeColor: "#00ff0000"
            preferredRendererType: Shape.GeometryRenderer
            gradient: LinearGradient {
                y2: ellipse.height * 1
                y1: ellipse.height * 0
                x2: ellipse.width * 1
                x1: ellipse.width * 0
                GradientStop {
                    id: grad2
                    position: 0
                    color: root.highlightFront
                }

                GradientStop {
                    position: 1
                    color: "#000000"
                }
            }
        }

        EllipseItem {
            id: ellipse2
            x: 158
            y: 24
            width: 180
            height: 180
            strokeColor: "#00ff0000"
            preferredRendererType: Shape.GeometryRenderer
            gradient: LinearGradient {
                y2: ellipse2.height * 1
                y1: ellipse2.height * 0
                x2: ellipse2.width * 1
                x1: ellipse2.width * 0
                GradientStop {
                    id: grad1
                    position: 0
                    color: root.highlightFront
                }

                GradientStop {
                    position: 1
                    color: "#000000"
                }
            }
        }
    }

    ThemeEngine {
        id: themeEngine
    }

    Text {
        id: qt
        x: 0
        y: -28
        width: 257
        height: 242
        color: "#23ffffff"
        text: qsTr("Qt")
        font.pixelSize: 243
        verticalAlignment: Text.AlignVCenter
        renderType: Text.NativeRendering
        font.styleName: "Bold"
        font.family: "Titillium Web"

        DesignEffect {
            id: de1
            layerBlurRadius: 2
            backgroundBlurRadius: 60
            backgroundLayer: glassPanel
            visible: root.effectsOn

            effects: [
                DesignInnerShadow {
                    id: is1
                    color: "#efffffff"
                    blur: 0
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                }
            ]
        }
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                pingPong: true
                running: true
                loops: -1
                duration: 5000
                to: 1000
                from: 0
            }
        ]
        startFrame: 0
        endFrame: 1000
        enabled: true

        KeyframeGroup {
            target: qt
            property: "x"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 240
                easing.bezierCurve: [0.895, 0.03, 0.685, 0.22, 1, 1]
                frame: 1000
            }
        }

        KeyframeGroup {
            target: qt
            property: "y"
            Keyframe {
                value: -27
                frame: 0
            }

            Keyframe {
                value: -27
                easing.bezierCurve: [0.895, 0.03, 0.685, 0.22, 1, 1]
                frame: 1000
            }
        }
    }

    NumberAnimation {
        id: numberAnimation
        target: de1
        property: "layerBlurRadius"
        alwaysRunToEnd: true
        duration: root.timing
        running: root.pulse
        loops: -1
        to: 2
        from: 20
    }

    NumberAnimation {
        id: numberAnimation1
        target: glassEffect
        property: "layerBlurRadius"
        running: root.pulse
        loops: -1
        duration: root.timing
        alwaysRunToEnd: true
        to: 2
        from: 20
    }

    ColorAnimation {
        id: colorAnimation
        target: grad1
        property: "color"
        from: root.partyMode
        to: root.highlightFront
        running: root.pulse
        loops: -1
        duration: root.timing
        alwaysRunToEnd: true
    }

    Connections {
        target: Constants
        function onStopAni() {
            colorAnimation.alwaysRunToEnd = false
            colorAnimation2.alwaysRunToEnd = false
            colorAnimation.stop()
            colorAnimation2.stop()
            console.log("color stop")
        }
        function onStartAni() {
            colorAnimation.alwaysRunToEnd = true
            colorAnimation2.alwaysRunToEnd = true
            colorAnimation.start()
            colorAnimation2.start()
            console.log("color start")
        }
    }

    ColorAnimation {
        id: colorAnimation2
        target: grad2
        property: "color"
        from: root.partyMode
        to: root.highlightFront
        running: root.pulse
        loops: -1
        duration: root.timing
        alwaysRunToEnd: true
    }

    ColorAnimation {
        id: colorAnimation3
        target: qt
        property: "color"
        to: "#23ffffff"
        from: "#47ea1bde"
        running: root.pulse
        loops: -1
        duration: root.timing
        alwaysRunToEnd: true
        paused: root.paused
    }
}
