/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick 2.0

ListModel {
    ListElement {
        displayName: "Learn to use Qt Design Studio (Part 1)"
        thumbnail: "images/tutorial1.png"
        url: "https://www.youtube.com/watch?v=aV6kFxH3Xws"
    }

    ListElement {
        displayName: "Learn to use Qt Design Studio (Part 2)"
        thumbnail: "images/tutorial2.png"
        url: "https://www.youtube.com/watch?v=Z3uPoe-4UAw"
    }

    ListElement {
        displayName: "Learn to use Qt Design Studio (Part 3)"
        thumbnail: "images/tutorial3.png"
        url: "https://www.youtube.com/watch?v=9AjvxoeqAKo"
    }

    ListElement {
        displayName: "Learn to use Qt Design Studio (Part 4)"
        thumbnail: "images/tutorial4.png"
        url: "https://www.youtube.com/watch?v=8pJpdMwLaAg"
    }

    ListElement {
        displayName: "Learn to use Qt Design Studio (Part 5)"
        thumbnail: "images/tutorial5.png"
        url: "https://www.youtube.com/watch?v=U91nAFReAoU"
    }

    ListElement {
        displayName: "The Designer Tool Developers Love"
        thumbnail: "images/webinar1.png"
        url: "https://youtu.be/gU_tDbebAzM"
    }

    ListElement {
        displayName: "From Photoshop to Prototype"
        thumbnail: "images/webinar2.png"
        url: "https://youtu.be/ZzbucmQPU44"
    }

    ListElement {
        displayName: "Qt for Designers and Developers"
        thumbnail: "images/designer_and_developers.png"
        url: "https://www.youtube.com/watch?v=EgjCvZWEPWk"
    }

    ListElement {
        displayName: "QTWS - Designer and Developer Workflow"
        thumbnail: "images/qtws_video_thumbnail.png"
        url: "https://www.youtube.com/watch?v=4ug0EUdS2RM"
    }

    ListElement {
        displayName: "QTWS - Turn UI designs into working prototypes"
        thumbnail: "images/bridging_the_gap.png"
        url: "https://www.youtube.com/watch?v=qQM2oEWRBOw&feature=emb_logo"
    }

    ListElement {
        displayName: "What's New in Design Studio 1.5"
        thumbnail: "images/what_is_new_15.png"
        url: "https://www.youtube.com/watch?v=e-HAZrisi5o"
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: UI Navigation"
        thumbnail: "images/Qt_QT_nav.png"
        url: "https://youtu.be/RfEYO-5Mw6s"
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Text Element"
        thumbnail: "images/Qt_QT_textElement.png"
        url: "https://youtu.be/yOUdg1o2KJM"
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Animated Image"
        thumbnail: "images/Qt_QT_animatedImage.png"
        url: "https://youtu.be/DVWd_xMMgvg"
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Slider Control"
        thumbnail: "images/Qt_QT_sliderControl.png"
        url: "https://youtu.be/Ed8WS03C-Vk"
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Bindings"
        thumbnail: "images/Qt_QT_bindings.png"
        url: "https://youtu.be/UfvA04CIXv0"
    }

    ListElement {
        displayName: "Qt Design Studio QuickTip: Interactive 3D"
        thumbnail: "images/Qt_QT_interactive3d.png"
        url: "https://youtu.be/w1yhDl93YI0"
    }

    ListElement {
        displayName: "Sketch Bridge Tutorial - Part 1"
        thumbnail: "images/sketchTutorial_1.png"
        url: "https://www.qt.io/blog/qt-design-studio-sketch-bridge-tutorial-part-1"
    }

    ListElement {
        displayName: "Sketch Bridge Tutorial - Part 2"
        thumbnail: "images/sketchTutorial_2.png"
        url: "https://www.qt.io/blog/qt-design-studio-sketch-bridge-tutorial-part-2"
    }

    ListElement {
        displayName: "Create New Project"
        thumbnail: "images/gettingStarted_newProject.png"
        url: "https://youtu.be/9ihYeC0YJ0M"
    }

    ListElement {
        displayName: "Using Qt Quick 3D Components"
        thumbnail: "images/gettingStarted_3dComponents.png"
        url: "https://youtu.be/u3kZJjlk3CY"
    }

    ListElement {
        displayName: "Using Custom Shaders, Materials, and Effects"
        thumbnail: "images/gettingStarted_shaders.png"
        url: "https://youtu.be/bMXeeQw6BYs"
    }
}
