/* $Id: utils.h,v 1.4 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/utils.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/utils.h,v 1.3 2004/11/09 20:21:21 flaw
 * if/src/utils.h,v 1.19 2004/09/28 15:49:30 flaw
 *//*
 * various utilities
 */
#ifndef PyPg_utils_H
#define PyPg_utils_H 0
#ifdef __cplusplus
extern "C" {
#endif

PyObj Py_RETURN_SELF(PyObj, ...);
void PySpec(PyObj);
#define PythonMemoryContext(CODE) \
do{ \
		MemoryContext _oldmcxt = MemoryContextSwitchTo(PythonMemoryContext); \
		CODE; \
		MemoryContextSwitchTo(_oldmcxt); \
}while(0)

Oid TypeOidMod_FromPyObject(PyObj, int32 *);
Oid TypeOid_FromPyObject(PyObj);

Datum Datum_Cast(Datum, Oid, Oid);
HeapTupleHeader HeapTupleHeader_FromHeapTuple(HeapTuple);
Oid RelationId_FromTypeOid(Oid);

Oid RelationId_FetchTypeOid(Oid);
ParamListInfo ParamListInfo_FromPyTuple(PyObj);
char * PgTypeName_FromOid(Oid);

PyObj PyPgTypeTuple_FromPyObject(PyObj);
PyObj PyPgSearchSysCache(int, Datum, Datum, Datum, Datum);

PyObj pg_attribute_PyPgType(void);

/* Direct Receiver */
typedef void (*DRReceive)	(HeapTuple, TupleDesc, DestReceiver *);
typedef void (*DRStartup)	(DestReceiver *, int, TupleDesc);
typedef void (*DRShutdown)	(DestReceiver *);
typedef void (*DRDestroy)	(DestReceiver *);

struct DirectReceiver
{
	DRReceive	receive;
	DRStartup	startup;
	DRShutdown	shutdown;
	DRDestroy	destroy;
	CommandDest	dest;

	int startupOperation;
	TupleDesc startupDescriptor;

	TupleDesc tupd;
	HeapTuple htup;
};

void DirectR_InitReceiver(struct DirectReceiver *);
void DirectR_Receive(HeapTuple, TupleDesc, struct DirectReceiver *);
void DirectR_Startup(struct DirectReceiver *, int, TupleDesc);
void DirectR_Shutdown(struct DirectReceiver *);
void DirectR_Destroy(struct DirectReceiver *);

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_utils_H */
/*
 * vim: ts=3:sw=3:noet:
 */
