/* $Id: constants.c,v 1.8 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * imp/src/constants.c,v 1.2 2004/11/18 22:08:59 flaw
 * if/src/constants.c,v 1.10 2004/08/10 16:32:00 flaw
 *//*
 * Flexible source meant to be #include'd into a main
 * file that #define's TARGET and APFUNC.
 */
#define OBJECTIFY(ARG) (PyInt_FromLong(ARG))
#define C(V) APFUNC(TARGET, #V, OBJECTIFY(V));
/* utils/elog.h */
	C(DEBUG1)
	C(DEBUG2)
	C(DEBUG3)
	C(DEBUG4)
	C(DEBUG5)
	C(LOG)
	C(INFO)
	C(NOTICE)
	C(WARNING)
	C(ERROR)
	C(FATAL)
	C(PANIC)

/* access/htup.h */
#define CC(V) C(V##AttributeNumber)
	CC(SelfItemPointer)
	CC(ObjectId)
	CC(MinTransactionId)
	CC(MinCommandId)
	CC(MaxTransactionId)
	CC(MaxCommandId)
	CC(TableOid)
	CC(FirstLowInvalidHeap)

	CC(MaxTuple)
	CC(MaxHeap)
#undef CC

	C(MaxTupleSize)
	C(MaxAttrSize)
	C(MaxSpecialSpace)
	C(HEAPTUPLESIZE)

#define CC(V) C(SizeOfHeap##V)
	CC(Tid)
	CC(Clean)
	CC(Insert)
	CC(Delete)
	CC(Update)
	CC(Header)
#undef CC

#define CC(V) C(XLOG_HEAP_##V)
	CC(INSERT)
	CC(DELETE)
	CC(UPDATE)
	CC(MOVE)
	CC(CLEAN)
	CC(OPMASK)
	CC(INIT_PAGE)
#undef CC

#define CC(V) C(HEAP_##V)
	CC(HASNULL)
	CC(HASVARWIDTH)
	CC(HASEXTERNAL)
	CC(HASCOMPRESSED)
	CC(HASEXTENDED)
	CC(HASOID)
#ifdef HEAP_XMAX_IS_XMIN
	CC(XMAX_IS_XMIN)
#endif
#ifdef HEAP_XMAX_UNLOGGED
	CC(XMAX_UNLOGGED)
#endif
#ifdef HEAP_MARKED_FOR_UPDATE
	CC(MARKED_FOR_UPDATE)
#endif
	CC(XMIN_COMMITTED)
	CC(XMIN_INVALID)
	CC(XMAX_COMMITTED)
	CC(XMAX_INVALID)
	CC(UPDATED)
	CC(MOVED_OFF)
	CC(MOVED_IN)
	CC(MOVED)
	CC(XACT_MASK)
#undef CC
	C(NAMEDATALEN)
	C(INDEX_MAX_KEYS)
	C(RI_MAX_NUMKEYS)
	C(MAXDIM)
	C(VARHDRSZ)
	C(MAXTZLEN)

#define CC(V) C(STATUS_##V)
	CC(OK)
	CC(ERROR)
	CC(EOF)
	CC(FOUND)
#undef CC

#define CC(V) C(USE_##V##_DATES)
	CC(POSTGRES)
	CC(ISO)
	CC(SQL)
	CC(GERMAN)
#undef CC

/* commands/trigger.h */
#define CC(V) C(TRIGGER_EVENT_##V)
	CC(INSERT)
	CC(DELETE)
	CC(UPDATE)
	CC(OPMASK)
	CC(ROW)
	CC(BEFORE)
#undef CC

/* utils/syscache.h */
#ifdef PROCNAMENSP
	C(PROCNAMENSP)
#endif
#ifdef PROCNAMEARGSNSP
	C(PROCNAMEARGSNSP)
#endif
	C(AGGFNOID)
	C(AMNAME)
	C(AMOID)
	C(AMOPOPID)
	C(AMOPSTRATEGY)
	C(AMPROCNUM)
	C(ATTNAME)
	C(ATTNUM)
	C(CASTSOURCETARGET)
	C(CLAAMNAMENSP)
	C(CLAOID)
	C(CONDEFAULT)
	C(CONNAMENSP)
	C(CONOID)
	C(GRONAME)
	C(GROSYSID)
	C(INDEXRELID)
	C(INHRELID)
	C(LANGNAME)
	C(LANGOID)
	C(NAMESPACENAME)
	C(NAMESPACEOID)
	C(OPERNAMENSP)
	C(OPEROID)
	C(PROCOID)
	C(RELNAMENSP)
	C(RELOID)
	C(RULERELNAME)
	C(SHADOWNAME)
	C(SHADOWSYSID)
	C(STATRELATT)
	C(TYPENAMENSP)
	C(TYPEOID)

/* catalog/pg_type.h */
	C(BOOLOID)
	C(BYTEAOID)
	C(CHAROID)
	C(NAMEOID)
	C(INT8OID)
	C(INT2OID)
	C(INT4OID)
	C(TEXTOID)
	C(OIDOID)
	C(TIDOID)
	C(XIDOID)
	C(CIDOID)
	C(POINTOID)
	C(LSEGOID)
	C(PATHOID)
	C(BOXOID)
	C(POLYGONOID)
	C(LINEOID)
	C(FLOAT4OID)
	C(ABSTIMEOID)
	C(RELTIMEOID)
	C(TINTERVALOID)
	C(UNKNOWNOID)
	C(CIRCLEOID)
	C(CASHOID)
	C(MACADDROID)
	C(INETOID)
	C(CIDROID)
	C(ACLITEMOID)
	C(BPCHAROID)
	C(VARCHAROID)
	C(DATEOID)
	C(TIMEOID)
	C(TIMESTAMPOID)
	C(TIMESTAMPTZOID)
	C(INTERVALOID)
	C(TIMETZOID)
	C(BITOID)
	C(VARBITOID)
	C(NUMERICOID)
	C(REFCURSOROID)
	C(REGPROCEDUREOID)
	C(REGOPEROID)
	C(REGOPERATOROID)
	C(REGTYPEOID)
	C(RECORDOID)
	C(CSTRINGOID)
	C(ANYOID)
	C(ANYARRAYOID)
	C(VOIDOID)
	C(TRIGGEROID)
	C(LANGUAGE_HANDLEROID)
	C(INTERNALOID)
	C(OPAQUEOID)
	C(ANYELEMENTOID)
	C(PG_TYPE_RELTYPE_OID)
	C(PG_ATTRIBUTE_RELTYPE_OID)
	C(PG_PROC_RELTYPE_OID)
	C(PG_CLASS_RELTYPE_OID)

/* catalog/pg_namespace.h */
	C(PG_CATALOG_NAMESPACE)
	C(PG_TOAST_NAMESPACE)
	C(PG_PUBLIC_NAMESPACE)

/* storage/off.h */
	C(InvalidOffsetNumber)
	C(FirstOffsetNumber)
	C(MaxOffsetNumber)
	C(OffsetNumberMask)

/* storage/lock.h */
	C(MAX_LOCKMODES)
	C(MAX_LOCK_METHODS)
	C(INVALID_LOCKMETHOD)
	C(DEFAULT_LOCKMETHOD)
	C(USER_LOCKMETHOD)

/* storage/lmgr.h */
#define CC(V) C(V##Lock)
	CC(No)
	CC(Exclusive)
	CC(AccessShare)
	CC(AccessExclusive)
	CC(RowShare)
	CC(RowExclusive)
	CC(Share)
	CC(ShareRowExclusive)
	CC(ShareUpdateExclusive)
#undef CC

/* storage/buf.h */
	C(InvalidBuffer)

/* storage/backendid.h */
	C(InvalidBackendId)

/* storage/large_object.h */
	C(LOBLKSIZE)

/* End Of ints */
#undef OBJECTIFY

#define OBJECTIFY(ARG) (PyLong_FromUnsignedLong(ARG))
/* storage/block.h */
	C(InvalidBlockNumber)
	C(MaxBlockNumber)
/* End of unsigned long */
#undef OBJECTIFY

#define OBJECTIFY(ARG) (PyString_FromString(ARG))
	APFUNC(TARGET, "VERSION", OBJECTIFY(PG_VERSION));
	APFUNC(TARGET, "VERSION_STR", OBJECTIFY(PG_VERSION_STR));

/* catname.h */
#if PGV_MM <= 80
#include <catalog/catname.h>
#define CC(V) C(V##RelationName)
	CC(Aggregate)
	CC(AccessMethod)
	CC(AccessMethodOperator)
	CC(AccessMethodProcedure)
	CC(Attribute)
	CC(Cast)
	CC(Constraint)
	CC(Conversion)
	CC(Database)
	CC(Depend)
	CC(Description)
	CC(Group)
	CC(Index)
	CC(Inherits)
	CC(Language)
	CC(LargeObject)
	CC(Listener)
	CC(Namespace)
	CC(OperatorClass)
	CC(Operator)
	CC(Procedure)
	CC(Relation)
	CC(Rewrite)
	CC(Shadow)
	CC(Statistic)
	CC(Type)
	CC(Version)
	CC(AttrDefault)
	CC(Trigger)
#undef CC
#endif /* 8.0 */
#undef C
#undef OBJECTIFY
