/* $Id: type.h,v 1.7 2005/06/19 19:35:21 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/type.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/type.h,v 1.4 2004/10/17 12:54:51 flaw
 * if/src/type.h,v 1.8 2004/09/28 15:45:39 flaw
 *//*
 * Postgres type interface
 */
#ifndef PyPg_type_H
#define PyPg_type_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgType {
	PyPgObject_HEAD
	PyObj pgt_null;	/* Py_None if typnotnull is true, PyPgObject(self) */
	PyObj pgt_desc;	/* Py_None if typrelid is InvalidOid, PyPgTupleDesc */
} * PyPgType;

extern PyTypeObject PyPgType_Type;
PyObj PyPgType_Initialize(PyObj);

#define PyPgType_NEW() \
	((PyObj) PyPgType_Type.tp_alloc(&PyPgType_Type, 0))
#define PyPgType_New(TTO) (PyPgType_Initialize(PyPgType_NEW(), TTO))

PyObj PyPgType_FromOid(Oid);
PyObj PyPgType_FromRelationOid(Oid);
PyObj PyPgType_FromPyObject(PyObj);

#define PyPgType(SELF) ((PyPgType) SELF)

#define PyPgType_Check(SELF) (PyObject_TypeCheck(SELF, &PyPgType_Type))
#define PyPgType_CheckExact(SELF) (((SELF)->ob_type) == &PyPgType_Type)

#define PyPgType_FetchPyPgTupleDesc(SELF) \
	(PyPgType(SELF)->pgt_desc)
#define PyPgType_FetchNULL(SELF) \
	(PyPgType(SELF)->pgt_null)
#define PyPgType_FetchTypeOid(SELF) \
	(HeapTupleHeaderGetTypeId(PyPgObject_FetchHeapTupleHeader(SELF)))

#define PyPgType_FixPyPgTupleDesc(SELF, OB) (PyPgType(SELF)->pgt_desc = OB)
#define PyPgType_FixNULL(SELF, OB) (PyPgType(SELF)->pgt_null = OB)

#define PyPgType_FetchTypeStruct(SELF) \
	((Form_pg_type) PyPgObject_FetchStructure(SELF))

#define PyPgType_FetchName(SELF) \
	(NameStr(PyPgType_FetchTypeStruct(SELF)->typname))
#define PyPgType_FetchTupleDesc(SELF) \
	(PyPgTupleDesc_FetchTupleDesc(PyPgType_FetchPyPgTupleDesc(SELF)))

#define PyPgType_IsComposite(SELF) \
	(PyPgType_FetchTypeStruct(SELF)->typrelid != 0)
#define PyPgType_IsArray(SELF) \
	(PyPgType_FetchTypeStruct(SELF)->typelem != 0)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_H */
/*
 * vim: ts=3:sw=3:noet:
 */
