/* $Id: postgres.h,v 1.6 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/include/pg.h,v 1.1.1.1 2004/12/16 00:32:17 flaw
 * imp/include/pg.h,v 1.6 2004/12/15 04:51:58 flaw
 * if/include/pg.h,v 1.19 2004/09/28 16:05:12 flaw
 *//*
 * Few Postgres utilities
 */
#ifndef PyPg_postgres_H
#define PyPg_postgres_H 0
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Use a bit of fingerprinting to identify if the Postgres uses the old list
 * implementation. FastLists don't exist in the new implementation, nor does the
 * forboth macro.
 */
#if defined(PG_LIST_H) && defined(FastListInit) && !defined(forboth)
/*
 * In the old list implementation, a ListCell is a List
 */
#	define ListCell List
#	define linitial(LIST) (LIST)
#	define list_length(L)	length(L)
#	define list_copy(L)		listCopy(L)
#	define list_free(L)		freeList(L)
#	define forboth(cell1, list1, cell2, list2)						\
	for (	cell1 = linitial(list1), cell2 = linitial(list2);	\
			cell1 != NULL && cell2 != NULL;							\
			cell1 = lnext(cell1), cell2 = lnext(cell2) )
#	define list_make1(x1) lcons(x1, NIL)
#	define list_make2(x1,x2) lcons(x1, list_make1(x2))
#	define list_make3(x1,x2,x3) lcons(x1, list_make2(x2,x3))
#	define list_make4(x1,x2,x3,x4) lcons(x1, list_make3(x2,x3,x4))
#endif /* USING OLD LISTS */

/* Post 7.5 */
#if (PGV_MM >= 75)
#	define TupleDescInitEntry(DESC,ATTNUM,ATTNAME,TYPOID,TYPMOD,DIM,ISSET) \
		TupleDescInitEntry(DESC,ATTNUM,ATTNAME,TYPOID,TYPMOD,DIM)
#else
#	define work_mem 1024
#	define pg_plan_query(QTREE, PLI) pg_plan_query(QTREE)
#endif

#if !defined(PG_TRY)
#	define PG_TRY() \
	do { \
		sigjmp_buf _saved_sigjmp_buf_; \
		memcpy(&_saved_sigjmp_buf_, &Warn_restart, sizeof(sigjmp_buf)); \
		if (sigsetjmp(Warn_restart, 1) == 0) \
		{ \

#	define PG_CATCH() \
		} \
		else \
		{ \
			memcpy(&Warn_restart, &_saved_sigjmp_buf_, sizeof(sigjmp_buf)) \

#	define PG_END_TRY() \
		} \
		memcpy(&Warn_restart, &_saved_sigjmp_buf_, sizeof(sigjmp_buf)); \
	} while(0)

#	define PG_RE_THROW() siglongjmp(Warn_restart, 1)
#endif /* !defined(PG_TRY) */

/*
 * PyPgObject's are exclusively Datums, so a HeapTupleData structure must be
 * filled in when there is a need to use HeapTuple routines.
 */
#define	HeapTupleData_FromHeader(HTD, HEAD) do { \
	(HTD).t_len = (HEAD)->t_choice.t_datum.datum_len; \
	(HTD).t_tableOid = \
		RelationId_FromTypeOid((HEAD)->t_choice.t_datum.datum_typeid); \
	(HTD).t_datamcxt = TopMemoryContext; \
	(HTD).t_data = HEAD; \
} while(0)

#define	HeapTupleHeaderStructure(HEAD) \
	((char *) (HEAD) + (HEAD)->t_hoff)

#define	HeapTuple_FetchLength(ht) (ht->t_len)
#define	HeapTuple_FetchTableOid(ht) (ht->t_tableOid)
#define	HeapTuple_FetchOid(ht) HeapTupleGetOid(ht)
#define	HeapTuple_FetchNatts(ht) (ht->t_data->t_natts)
#define	HeapTuple_FetchXmin(ht) HeapTupleHeaderGetXmin(ht->t_data)
#define	HeapTuple_FetchXmax(ht) HeapTupleHeaderGetXmax(ht->t_data)
#define	HeapTuple_FetchXvac(ht) HeapTupleHeaderGetXvac(ht->t_data)
#define	HeapTuple_FetchCmin(ht) HeapTupleHeaderGetCmin(ht->t_data)
#define	HeapTuple_FetchCmax(ht) HeapTupleHeaderGetCmax(ht->t_data)
#define	HeapTuple_FetchTID(ht) (ht->t_data->t_ctid)

#define	HeapTuple_FixOid(ht, oid) HeapTupleSetOid(ht, oid)
#define	HeapTuple_FixTableOid(ht, oid) (HeapTuple_FetchTableOid(ht) = oid)

#define	PROCSTRUCT(V) ((Form_pg_proc) GETSTRUCT(V))
#define	TYPESTRUCT(V) ((Form_pg_type) GETSTRUCT(V))
#define	LANGSTRUCT(V) ((Form_pg_language) GETSTRUCT(V))
#define	OPERSTRUCT(V) ((Form_pg_operator) GETSTRUCT(V))
#define	CASTSTRUCT(V) ((Form_pg_cast) GETSTRUCT(V))

#define	SysRelTupleDesc(F_) (RelationNameGetTupleDesc(F_##RelationName))
#define	SysTupleDesc(_F) (RelationOidGetDescr(RelOid_pg_##_F))

#if PGV_MM < 80
#	define PortalStart(port, pli, snap) PortalStart(port, pli)
#	define CreateQueryDesc(Q,P,S,SC,D,PLI,I) CreateQueryDesc(Q,P,D,PLI,I)
#	define ProcessUtility(PT, PLI, DR, CTAG) ProcessUtility(PT,DR,CTAG)
#endif

#ifndef PG_FEATURE_ERRORDATA
#	if (PGV_MM >= 75)
#		define PG_FEATURE_ERRORDATA 1
#	else
#		define PG_FEATURE_ERRORDATA 0
#	endif
#endif

#ifndef PG_FEATURE_TABLESPACES
#	if PGV_MM >= 75
#		define PG_FEATURE_TABLESPACES 1
#	else
#		define PG_FEATURE_TABlESPACES 0
#	endif
#endif

#ifndef PG_FEATURE_SAVEPOINTS
#	if PGV_MM >= 75
#		define PG_FEATURE_SAVEPOINTS 1
#	else
#		define PG_FEATURE_SAVEPOINTS 0
#	endif
#endif

#ifndef PG_FEATURE_PROARGNAMES
#	if defined(Anum_pg_proc_proargnames)
#		define PG_FEATURE_PROARGNAMES 1
#	else
#		define PG_FEATURE_PROARGNAMES 0
#	endif
#endif

#if PGV_MM == 80
#define TypeRelationId RelOid_pg_type
#define RelationRelationId RelOid_pg_class
#define ProcedureRelationId RelOid_pg_proc
#define AttributeRelationId RelOid_pg_attribute
#endif

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_postgres_H */
/*
 * vim: ts=3:sw=3:noet:
 */
