/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import org.apache.calcite.adapter.enumerable.EnumerableAsofJoin;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalAsofJoin;

class EnumerableAsofJoinRule
extends ConverterRule {
    public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalAsofJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableAsofJoinRule").withRuleFactory(EnumerableAsofJoinRule::new);

    protected EnumerableAsofJoinRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalAsofJoin join = (LogicalAsofJoin)rel;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : join.getInputs()) {
            if (!(input.getConvention() instanceof EnumerableConvention)) {
                input = EnumerableAsofJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
            }
            newInputs.add(input);
        }
        RelNode left = (RelNode)newInputs.get(0);
        RelNode right = (RelNode)newInputs.get(1);
        return EnumerableAsofJoin.create(left, right, join.getCondition(), join.getMatchCondition(), join.getVariablesSet(), join.getJoinType());
    }
}

