/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;
import org.opensearch.sql.opensearch.planner.physical.CalciteEnumerableTopK;
import org.opensearch.sql.opensearch.planner.rules.ImmutableEnumerableTopKMergeRule;
import org.opensearch.sql.opensearch.planner.rules.InterruptibleRelRule;

@Value.Enclosing
public class EnumerableTopKMergeRule
extends InterruptibleRelRule<Config> {
    protected EnumerableTopKMergeRule(Config config) {
        super(config);
    }

    @Override
    protected void onMatchImpl(RelOptRuleCall call) {
        EnumerableLimit limit = (EnumerableLimit)call.rel(0);
        EnumerableSort sort = (EnumerableSort)call.rel(1);
        CalciteEnumerableTopK topK = CalciteEnumerableTopK.create(sort.getInput(), sort.getCollation(), limit.offset, limit.fetch);
        call.transformTo((RelNode)topK);
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Config DEFAULT = ImmutableEnumerableTopKMergeRule.Config.builder().build().withDescription("EnumerableTopKMerge").withOperandSupplier(b0 -> b0.operand(EnumerableLimit.class).oneInput(b1 -> b1.operand(EnumerableSort.class).predicate(sort -> sort.fetch == null).anyInputs()));

        default public EnumerableTopKMergeRule toRule() {
            return new EnumerableTopKMergeRule(this);
        }
    }
}

