/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import mediathek.Main;
import mediathek.config.Konstanten;
import mediathek.tool.UIProgressState;
import mediathek.tool.timer.TimerPool;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.swingx.StackLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J\u001a\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lmediathek/SplashScreen;", "Ljavax/swing/JWindow;", "<init>", "()V", "versionLabel", "Ljavax/swing/JLabel;", "curSteps", "", "appTitleLabel", "imageLabel", "progressBar", "Ljavax/swing/JProgressBar;", "statusLabel", "stackPanel", "Ljavax/swing/JPanel;", "backgroundPanel", "splashContent", "update", "", "state", "Lmediathek/tool/UIProgressState;", "close", "osName", "", "getOsName", "()Ljava/lang/String;", "updateStatus", "statusText", "percentComplete", "", "initComponents", "Companion", "MediathekView"})
public final class SplashScreen
extends JWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JLabel versionLabel = new JLabel();
    private double curSteps;
    @NotNull
    private final JLabel appTitleLabel = new JLabel();
    @NotNull
    private final JLabel imageLabel = new JLabel();
    @NotNull
    private final JProgressBar progressBar = new JProgressBar();
    @NotNull
    private final JLabel statusLabel = new JLabel();
    @NotNull
    private final JPanel stackPanel = new JPanel((LayoutManager)new StackLayout());
    @NotNull
    private final JPanel backgroundPanel = new JPanel();
    @NotNull
    private final JPanel splashContent = new JPanel();
    private static final double MAXIMUM_STEPS = (double)EnumSet.allOf(UIProgressState.class).size() - 1.0;

    public SplashScreen() {
        this.initComponents();
        this.getContentPane().setBackground(Color.BLACK);
        String string = "Version: %s (%s %s)";
        Object[] objectArray = new Object[]{Konstanten.MVVERSION, this.getOsName(), SystemUtils.OS_ARCH};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String res = string2;
        this.versionLabel.setText(res);
        this.progressBar.setValue(0);
        this.setLocationRelativeTo(null);
        if (SystemUtils.IS_OS_WINDOWS && this.isAlwaysOnTopSupported()) {
            this.setAlwaysOnTop(true);
        }
    }

    public final void update(@NotNull UIProgressState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        double d = this.curSteps;
        this.curSteps = d + 1.0;
        int pct = MathKt.roundToInt((double)((double)100 * (this.curSteps / MAXIMUM_STEPS)));
        this.updateStatus(state.toString(), pct);
    }

    public final void close() {
        TimerPool.getTimerPool().schedule(() -> SplashScreen.close$lambda$0(this), 2L, TimeUnit.SECONDS);
        Main.splashScreen = Optional.empty();
    }

    private final String getOsName() {
        String string;
        if (SystemUtils.IS_OS_MAC_OSX) {
            string = "macOS";
        } else {
            String string2 = SystemUtils.OS_NAME;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"OS_NAME");
        }
        return string;
    }

    private final void updateStatus(String statusText, int percentComplete) {
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.backgroundPanel.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }
        this.appTitleLabel.paintImmediately(0, 0, this.appTitleLabel.getWidth(), this.appTitleLabel.getHeight());
        this.imageLabel.paintImmediately(0, 0, this.imageLabel.getWidth(), this.imageLabel.getHeight());
        this.versionLabel.paintImmediately(0, 0, this.versionLabel.getWidth(), this.versionLabel.getHeight());
        this.statusLabel.setText(statusText);
        this.statusLabel.paintImmediately(0, 0, this.statusLabel.getWidth(), this.statusLabel.getHeight());
        this.progressBar.setValue(percentComplete);
        this.progressBar.paintImmediately(0, 0, this.progressBar.getWidth(), this.progressBar.getHeight());
    }

    private final void initComponents() {
        this.setMinimumSize(new Dimension(640, 480));
        this.setBackground(Color.black);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setAutoRequestFocus(false);
        this.setForeground(Color.black);
        this.appTitleLabel.setText("MediathekView");
        this.appTitleLabel.setFont(this.appTitleLabel.getFont().deriveFont(this.appTitleLabel.getFont().getStyle() | 1, (float)this.appTitleLabel.getFont().getSize() + 45.0f));
        this.appTitleLabel.setForeground(Color.white);
        this.appTitleLabel.setBackground(Color.black);
        this.appTitleLabel.setOpaque(true);
        this.versionLabel.setText("Version");
        this.versionLabel.setOpaque(true);
        this.versionLabel.setForeground(Color.white);
        this.versionLabel.setBackground(Color.black);
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/MediathekView.png")));
        this.imageLabel.setBackground(Color.black);
        this.imageLabel.setOpaque(true);
        this.progressBar.setValue(50);
        this.progressBar.setPreferredSize(new Dimension(146, 10));
        this.statusLabel.setText("Status Text Message is here");
        this.statusLabel.setForeground(Color.white);
        this.statusLabel.setBackground(Color.black);
        this.statusLabel.setOpaque(true);
        this.backgroundPanel.setBackground(Color.black);
        this.splashContent.setBackground(Color.black);
        this.stackPanel.add((Component)this.backgroundPanel, "bottom");
        this.stackPanel.add((Component)this.splashContent, "top");
        this.setContentPane(this.stackPanel);
        GroupLayout contentPaneLayout = new GroupLayout(this.splashContent);
        this.splashContent.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup().addComponent(this.versionLabel, -1, 628, Short.MAX_VALUE).addComponent(this.progressBar, -1, 628, Short.MAX_VALUE).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.appTitleLabel).addGap(0, 257, Short.MAX_VALUE)).addComponent(this.statusLabel, -1, 628, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 372, Short.MAX_VALUE).addComponent(this.imageLabel))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.appTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 94, Integer.MAX_VALUE).addComponent(this.imageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private static final void close$lambda$0(SplashScreen this$0) {
        SwingUtilities.invokeLater(() -> SplashScreen.close$lambda$0$0(this$0));
    }

    private static final void close$lambda$0$0(SplashScreen this$0) {
        this$0.setVisible(false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/SplashScreen$Companion;", "", "<init>", "()V", "MAXIMUM_STEPS", "", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

