﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/Database.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class GetDatabasesResult {
 public:
  AWS_GLUE_API GetDatabasesResult() = default;
  AWS_GLUE_API GetDatabasesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API GetDatabasesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of <code>Database</code> objects from the specified catalog.</p>
   */
  inline const Aws::Vector<Database>& GetDatabaseList() const { return m_databaseList; }
  template <typename DatabaseListT = Aws::Vector<Database>>
  void SetDatabaseList(DatabaseListT&& value) {
    m_databaseListHasBeenSet = true;
    m_databaseList = std::forward<DatabaseListT>(value);
  }
  template <typename DatabaseListT = Aws::Vector<Database>>
  GetDatabasesResult& WithDatabaseList(DatabaseListT&& value) {
    SetDatabaseList(std::forward<DatabaseListT>(value));
    return *this;
  }
  template <typename DatabaseListT = Database>
  GetDatabasesResult& AddDatabaseList(DatabaseListT&& value) {
    m_databaseListHasBeenSet = true;
    m_databaseList.emplace_back(std::forward<DatabaseListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A continuation token for paginating the returned list of tokens, returned if
   * the current segment of the list is not the last.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetDatabasesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetDatabasesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Database> m_databaseList;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_databaseListHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
