/* Smalltalk from Squeak4.6 with VMMaker 4.20.6 translated as C source on 24 November 2023 3:42:34 pm */
/* Automatically generated by
	VMPluginCodeGenerator VMMaker-dtl.440 uuid: d347df2d-ee8f-4564-8178-f628d7327704
   from
	XDisplayControlPlugin VMConstruction-Plugins-XDisplayControlPlugin-dtl.18 uuid: becfaae4-b33a-46ee-aa8f-c042084167bc
 */
static char __buildInfo[] = "XDisplayControlPlugin VMConstruction-Plugins-XDisplayControlPlugin-dtl.18 uuid: becfaae4-b33a-46ee-aa8f-c042084167bc " __DATE__ ;




/* Configuration options */
#include "sqConfig.h"

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Default EXPORT macro that does nothing (see comment in sq.h): */
#define EXPORT(returnType) returnType

/* Do not include the entire sq.h file but just those parts needed. */
/*  The virtual machine proxy definition */
#include "sqVirtualMachine.h"
/* Platform specific definitions */
#include "sqPlatformSpecific.h"

#define true 1
#define false 0
#define null 0  /* using 'null' because nil is predefined in Think C */
#ifdef SQUEAK_BUILTIN_PLUGIN
#undef EXPORT
// was #undef EXPORT(returnType) but screws NorCroft cc
#define EXPORT(returnType) static returnType
#endif
#include <X11/Xlib.h>

#include "sqMemoryAccess.h"


/*** Constants ***/

/*** Function Prototypes ***/
#pragma export on
EXPORT(const char*) getModuleName(void);
#pragma export off
static sqInt halt(void);
#pragma export on
EXPORT(sqInt) initialiseModule(void);
EXPORT(sqInt) moduleUnloaded(char *aModuleName);
EXPORT(sqInt) primitiveCanConnectToDisplay(void);
EXPORT(sqInt) primitiveDisconnectDisplay(void);
EXPORT(sqInt) primitiveFlushDisplay(void);
EXPORT(sqInt) primitiveGetDisplayName(void);
EXPORT(sqInt) primitiveIsConnectedToDisplay(void);
EXPORT(sqInt) primitiveKillDisplay(void);
EXPORT(sqInt) primitiveModuleName(void);
EXPORT(sqInt) primitiveOpenDisplay(void);
EXPORT(sqInt) primitiveSetDisplayName(void);
EXPORT(sqInt) primitiveVersionString(void);
#pragma export off
static sqInt sandboxSecurity(void);
static sqInt securityHeurisitic(void);
#pragma export on
EXPORT(sqInt) setInterpreter(struct VirtualMachine*anInterpreter);
#pragma export off
static sqInt stringFromCString(const char *aCString);
static char * transientCStringFromString(sqInt aString);
static char * versionString(void);
/*** Variables ***/

#ifdef SQUEAK_BUILTIN_PLUGIN
extern
#endif
struct VirtualMachine* interpreterProxy;
static const char *moduleName =
#ifdef SQUEAK_BUILTIN_PLUGIN
	"XDisplayControlPlugin 24 November 2023 (i)"
#else
	"XDisplayControlPlugin 24 November 2023 (e)"
#endif
;
static int osprocessSandboxSecurity;



/*	Note: This is hardcoded so it can be run from Squeak.
	The module name is used for validating a module *after*
	it is loaded to check if it does really contain the module
	we're thinking it contains. This is important! */

EXPORT(const char*) getModuleName(void) {
	return moduleName;
}

static sqInt halt(void) {
	;
	return null;
}

EXPORT(sqInt) initialiseModule(void) {
	osprocessSandboxSecurity = -1;
	return 1;
}


/*	The module with the given name was just unloaded.
	Make sure we have no dangling references. */

EXPORT(sqInt) moduleUnloaded(char *aModuleName) {
	return null;
}


/*	Open and close a connection to displayName. It the connection was successfully
	opened, answer true; otherwise false. This is intended to check for the ability
	to open an X display prior to actually making the attempt. */

EXPORT(sqInt) primitiveCanConnectToDisplay(void) {
    Display *d;
    sqInt name;
    char * namePtr;


	/* Do not allow this if running in secure mode */

	if ((sandboxSecurity()) == 1) {
		interpreterProxy->pop(2);
		interpreterProxy->push(interpreterProxy->falseObject());
	} else {
		name = interpreterProxy->stackObjectValue(0);
		namePtr = transientCStringFromString(name);
		d = XOpenDisplay(namePtr);
		if (d == 0) {

			/* Failed to make connection to server, answer false */

			interpreterProxy->pop(2);
			interpreterProxy->push(interpreterProxy->falseObject());
		} else {

			/* Successfully opened connection; close it and answer true */

			XCloseDisplay(d);
			interpreterProxy->pop(2);
			interpreterProxy->push(interpreterProxy->trueObject());
		}
	}
	return null;
}


/*	Call an internal function which will disconnect the X display session. The actual
	Squeak window on the X server is not effected, but this instance of Squeak will
	not have any further interaction with it. */
/*	Do not allow this if running in secure mode */

EXPORT(sqInt) primitiveDisconnectDisplay(void) {
	if (!((sandboxSecurity()) == 1)) {
		forgetXDisplay();
	}
	return null;
}


/*	Call an internal function to synchronize output to the X display. */

EXPORT(sqInt) primitiveFlushDisplay(void) {
	synchronizeXDisplay();
	return null;
}


/*	Answer a string containing the name for the X display, or nil if the display was opened
	using the $DISPLAY environment variable. This answers the name of the X display as of
	the time it was last opened, which may be different from the current setting of $DISPLAY. */

EXPORT(sqInt) primitiveGetDisplayName(void) {
    extern char *displayName;

	if (displayName == 0) {
		interpreterProxy->pop(1);
		interpreterProxy->push(interpreterProxy->nilObject());
	} else {
		interpreterProxy->pop(1);
		interpreterProxy->push(stringFromCString(displayName));
	}
	return null;
}


/*	Answer true if VM is currently connected to an X server. */

EXPORT(sqInt) primitiveIsConnectedToDisplay(void) {
    extern int isConnectedToXServer;

	if (isConnectedToXServer != 0) {
		interpreterProxy->pop(1);
		interpreterProxy->push(interpreterProxy->trueObject());
	} else {
		interpreterProxy->pop(1);
		interpreterProxy->push(interpreterProxy->falseObject());
	}
	return null;
}


/*	Call an internal function to disconnect the X display session and destroy
	the Squeak window on the X display. */
/*	Do not allow this if running in secure mode */

EXPORT(sqInt) primitiveKillDisplay(void) {
	if (!((sandboxSecurity()) == 1)) {
		disconnectXDisplay();
	}
	return null;
}


/*	Answer a string containing the module name string for this plugin. */

EXPORT(sqInt) primitiveModuleName(void) {
	interpreterProxy->popthenPush(1, stringFromCString(moduleName));
	return null;
}


/*	Call an internal function which will open the X display session. */
/*	Do not allow this if running in secure mode */

EXPORT(sqInt) primitiveOpenDisplay(void) {
	if (!((sandboxSecurity()) == 1)) {
		openXDisplay();
	}
	return null;
}


/*	Set the name for the X display for use in the next call to primitiveOpenXDisplay. Expects
	one parameter which must be either a String or nil. */

EXPORT(sqInt) primitiveSetDisplayName(void) {
    extern char *displayName;
    sqInt name;
    static char nameBuffer[501];
    char * namePtr;


	/* Do not allow this if running in secure mode */

	if ((sandboxSecurity()) == 1) {
		interpreterProxy->pop(2);
		interpreterProxy->pushInteger(-1);
	} else {
		name = interpreterProxy->stackObjectValue(0);
		if (name == (interpreterProxy->nilObject())) {
			displayName = 0;
		} else {
			namePtr = transientCStringFromString(name);
			strncpy(nameBuffer, namePtr, 500);
			nameBuffer[500] = 0;
			displayName = nameBuffer;
		}
		interpreterProxy->pop(1);
	}
	return null;
}


/*	Answer a string containing the version string for this plugin. */

EXPORT(sqInt) primitiveVersionString(void) {
	interpreterProxy->pop(1);
	interpreterProxy->push(stringFromCString(versionString()));
	return null;
}


/*	Answer 1 if running in secure mode, else 0. The osprocessSandboxSecurity
	variable is initialized to -1. On the first call to this method, set its value to
	either 0 (user has full access to the plugin) or 1 (user is not permitted to do
	dangerous things). */

static sqInt sandboxSecurity(void) {
	if (osprocessSandboxSecurity < 0) {
		osprocessSandboxSecurity = (int)securityHeurisitic();
	}
	return osprocessSandboxSecurity;
}


/*	Answer 0 to permit full access to OSProcess functions, or 1 if access should be
	restricted for dangerous functions. The rules are:
		- If the security plugin is not present, grant full access
		- If the security plugin can be loaded, restrict access unless user has all
		  of secCanWriteImage, secHasFileAccess and secHasSocketAccess */
/*	FIXME: This function has not been tested. -dtl */
/*	If the security plugin can be loaded, use it to check. If not, assume it's ok */

static sqInt securityHeurisitic(void) {
    sqInt canWriteImage;
    sqInt hasFileAccess;
    sqInt hasSocketAccess;
    void (*sCWIfn)(void);
    void (*sHFAfn)(void);
    void (*sHSAfn)(void);

	sCWIfn = interpreterProxy->ioLoadFunctionFrom("secCanWriteImage", "SecurityPlugin");
	if (sCWIfn == 0) {
		return 0;
	}
	canWriteImage = ((sqInt (*) (void)) sCWIfn)();
	sHFAfn = interpreterProxy->ioLoadFunctionFrom("secHasFileAccess", "SecurityPlugin");
	if (sHFAfn == 0) {
		return 0;
	}
	hasFileAccess = ((sqInt (*) (void)) sHFAfn)();
	sHSAfn = interpreterProxy->ioLoadFunctionFrom("secHasSocketAccess", "SecurityPlugin");
	if (sHSAfn == 0) {
		return 0;
	}
	hasSocketAccess = ((sqInt (*) (void)) sHSAfn)();
	return ((canWriteImage && (hasFileAccess)) && (hasSocketAccess)
		? 0
		: 1);
}


/*	Note: This is coded so that is can be run from Squeak. */

EXPORT(sqInt) setInterpreter(struct VirtualMachine*anInterpreter) {
    sqInt ok;

	interpreterProxy = anInterpreter;
	ok = interpreterProxy->majorVersion() == VM_PROXY_MAJOR;
	if (ok == 0) {
		return 0;
	}
	ok = interpreterProxy->minorVersion() >= VM_PROXY_MINOR;
	return ok;
}


/*	Answer a new String copied from a null-terminated C string.
	Caution: This may invoke the garbage collector. */

static sqInt stringFromCString(const char *aCString) {
    sqInt len;
    sqInt newString;

	len = strlen(aCString);
	newString = interpreterProxy->instantiateClassindexableSize(interpreterProxy->classString(), len);
	strncpy(interpreterProxy->arrayValueOf(newString), aCString, len);
	return newString;
}


/*	Answer a new null-terminated C string copied from aString.
	The string is allocated in object memory, and will be moved
	without warning by the garbage collector. Any C pointer
	reference the the result is valid only until the garbage
	collector next runs. Therefore, this method should only be used
	within a single primitive in a section of code in which the
	garbage collector is guaranteed not to run. Note also that
	this method may itself invoke the garbage collector prior
	to allocating the new C string.

	Warning: The result of this method will be invalidated by the
	next garbage collection, including a GC triggered by creation
	of a new object within a primitive. Do not call this method
	twice to obtain two string pointers. */

static char * transientCStringFromString(sqInt aString) {
    char *cString;
    sqInt len;
    sqInt newString;
    char *stringPtr;


	/* Allocate space for a null terminated C string. */

	len = interpreterProxy->sizeOfSTArrayFromCPrimitive(interpreterProxy->arrayValueOf(aString));
	interpreterProxy->pushRemappableOop(aString);
	newString = interpreterProxy->instantiateClassindexableSize(interpreterProxy->classString(), len + 1);
	stringPtr = interpreterProxy->arrayValueOf(interpreterProxy->popRemappableOop());

	/* Point to the actual C string. */

	cString = interpreterProxy->arrayValueOf(newString);
	(char *)strncpy(cString, stringPtr, len);
	cString[len] = 0;
	return cString;
}


/*	Answer a string containing the version string for this plugin. Handle MNU
	errors, which can occur if class InterpreterPlugin has been removed from
	the system.

	Important: When this method is changed, the class side method must also be
	changed to match. */
/*	2.0 supports 64bit code base */

static char * versionString(void) {
    static char version[]= "2.1.6";

	return version;
}


#ifdef SQUEAK_BUILTIN_PLUGIN


void* XDisplayControlPlugin_exports[][3] = {
	{"XDisplayControlPlugin", "primitiveSetDisplayName", (void*)primitiveSetDisplayName},
	{"XDisplayControlPlugin", "getModuleName", (void*)getModuleName},
	{"XDisplayControlPlugin", "primitiveFlushDisplay", (void*)primitiveFlushDisplay},
	{"XDisplayControlPlugin", "primitiveIsConnectedToDisplay", (void*)primitiveIsConnectedToDisplay},
	{"XDisplayControlPlugin", "primitiveDisconnectDisplay", (void*)primitiveDisconnectDisplay},
	{"XDisplayControlPlugin", "primitiveVersionString", (void*)primitiveVersionString},
	{"XDisplayControlPlugin", "setInterpreter", (void*)setInterpreter},
	{"XDisplayControlPlugin", "primitiveModuleName", (void*)primitiveModuleName},
	{"XDisplayControlPlugin", "moduleUnloaded", (void*)moduleUnloaded},
	{"XDisplayControlPlugin", "primitiveCanConnectToDisplay", (void*)primitiveCanConnectToDisplay},
	{"XDisplayControlPlugin", "primitiveOpenDisplay", (void*)primitiveOpenDisplay},
	{"XDisplayControlPlugin", "primitiveGetDisplayName", (void*)primitiveGetDisplayName},
	{"XDisplayControlPlugin", "initialiseModule", (void*)initialiseModule},
	{"XDisplayControlPlugin", "primitiveKillDisplay", (void*)primitiveKillDisplay},
	{NULL, NULL, NULL}
};


#endif /* ifdef SQ_BUILTIN_PLUGIN */

