/* powerpc64le-linux.elf-fold.h
   created from powerpc64le-linux.elf-fold.bin, 20737 (0x5101) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC64LE_LINUX_ELF_FOLD_SIZE    20737
#define STUB_POWERPC64LE_LINUX_ELF_FOLD_ADLER32 0xf30a6206
#define STUB_POWERPC64LE_LINUX_ELF_FOLD_CRC32   0xf8762311

unsigned char stub_powerpc64le_linux_elf_fold[20737] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 21,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,240, 55,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 22,  0, 19,  0,
/* 0x0040 */   0,  0,255,255,255,255,255,255,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */ 172,  0,  0, 72,166,  2,  8,124,  5,  0,  0, 72,166,  2,104,124,
/* 0x0060 */ 166,  3,  8,124,228,255, 99,232, 32,  0,128, 78,166,  2,  8,124,
/* 0x0070 */   5,  0,  0, 72,166,  2,200,124,166,  3,  8,124,204,255,  6,232,
/* 0x0080 */ 120,  0, 96,124, 80, 24, 96,124, 20,  2,132,124,  0,  0,  0, 72,
/* 0x0090 */ 166,  2,  8,124,  5,  0,  0, 72,166,  2,200,124,166,  3,  8,124,
/* 0x00a0 */ 168,255,  6,232,120,  0, 96,124, 80, 24, 96,124, 20,  2,132,124,
/* 0x00b0 */   0,  0,  0, 72,166,  2,  8,124,  5,  0,  0, 72,166,  2,200,124,
/* 0x00c0 */ 166,  3,  8,124,132,255,  6,232,120,  0, 96,124, 80, 24, 96,124,
/* 0x00d0 */  20,  2,132,124,  0,  0,  0, 72,166,  2,  8,124,  5,  0,  0, 72,
/* 0x00e0 */ 166,  2,200,124,166,  3,  8,124, 96,255,  6,232,120,  0, 96,124,
/* 0x00f0 */  80, 24, 96,124, 20,  2,132,124,  0,  0,  0, 72,166,  3,  9,124,
/* 0x0100 */   0,  0, 22,128, 38, 96,  0, 84, 32,129, 16,124, 25,  0,  0, 72,
/* 0x0110 */  32, 32, 32, 61, 47,112,114,111, 99, 47,115,101,108,102, 47,101,
/* 0x0120 */ 120,101,  0,  0,166,  2,200,126,  4,  0,214, 58,248,255,129, 56,
/* 0x0130 */  16,  0,146, 65,  4, 16,  0, 56, 80,  8, 32,124,228,  6, 33,120,
/* 0x0140 */ 248,255, 97, 56,248,255, 90, 59,  9,  0,  4,232, 64,208,164,127,
/* 0x0150 */   9,  0,  3,248,244,255,156, 65, 16,  0, 67, 59,  9,  0,  3,248,
/* 0x0160 */   8,  0,  4,232,  0,  0,160, 43,  8,  0,  3,248, 17,  0,  4,232,
/* 0x0170 */  17,  0,  3,248,236,255,158, 64,  8,  0,163, 58,180,  0,146, 65,
/* 0x0180 */  80,168,122,126,252,255, 22,128,  8,  0, 68, 58,  8,  0,  3,148,
/* 0x0190 */   4,  0,195, 59,  0,  0,128, 56,120,179,195,126,  1,  0,  0, 72,
/* 0x01a0 */ 120, 27,123,124,255, 15,160, 56,120,243,196,127,120,179,195,126,
/* 0x01b0 */   1,  0,  0, 72,252,255,190, 56,  0,  0, 35, 44, 12,  0,129, 65,
/* 0x01c0 */ 252,255,182, 56, 12,  0, 96, 56,  4,  0, 99, 56, 20, 26,133,124,
/* 0x01d0 */ 166,  3,105,124,120,147, 67,126,  0,  0,160, 56,255,255,163,156,
/* 0x01e0 */ 255,255,  4,140,255,255,  3,156,248,255,  0, 66,240,255,122,248,
/* 0x01f0 */  36,  7, 99,120,120, 34, 32,124,120, 26,  0,124, 32,  7,  0,120,
/* 0x0200 */  80, 24, 96,124,120,171,164,126,  0,  0,  0, 56,249,255,  3,248,
/* 0x0210 */ 249,255,  3,248,120, 27,117,124, 80, 24, 83,127,249,255,  4,232,
/* 0x0220 */  64,  8,164,127,249,255,  3,248,244,255,253, 65,120, 27, 97,124,
/* 0x0230 */ 136,  1, 33, 57,  0,  0, 41,251,113,247, 33,248,120,195,  3,127,
/* 0x0240 */ 120,187,228,126,144,  0,161, 56,120,211, 70,127, 24, 10,225, 56,
/* 0x0250 */   0,  0, 39,251,  1,  0,  0, 72,144,  8, 33, 56,120, 27,127,124,
/* 0x0260 */ 120,203, 35,127,  1,  0,  0, 72,160,  0,153,232,120,203, 35,127,
/* 0x0270 */   1,  0,  0, 72, 48,  0,146, 65,  0,  0,  0, 57,120,219,103,127,
/* 0x0280 */   0,  0,  7, 44, 32,  0,128, 65,  2,  0,192, 56,  1,  0,160, 56,
/* 0x0290 */ 208,  0,148,124,  0,  0, 96, 56,  1,  0,  0, 72,120,219, 99,127,
/* 0x02a0 */   1,  0,  0, 72,248,255, 21,232,166,  3,  9,124,128,  1,225,251,
/* 0x02b0 */ 120,235,163,127,120,227,132,127, 91,  0,  0, 56,166,  3,232,127,
/* 0x02c0 */ 176,  0,161,232,184,  0,193,232,192,  0,225,232,200,  0,  1,233,
/* 0x02d0 */ 208,  0, 33,233,216,  0, 65,233,224,  0, 97,233,232,  0,129,233,
/* 0x02e0 */ 240,  0,161,233,248,  0,193,233,  0,  1,225,233,  8,  1,  1,234,
/* 0x02f0 */  16,  1, 33,234, 24,  1, 65,234, 32,  1, 97,234, 40,  1,129,234,
/* 0x0300 */  48,  1,161,234, 56,  1,193,234, 64,  1,225,234, 72,  1,  1,235,
/* 0x0310 */  80,  1, 33,235, 88,  1, 65,235, 96,  1, 97,235,104,  1,129,235,
/* 0x0320 */ 112,  1,161,235,120,  1,193,235,128,  1,225,235,144,  1, 33, 56,
/* 0x0330 */  32,  4,128, 78,  8,  0,  3,233,  0,  0, 67,233, 64, 40,170,127,
/* 0x0340 */  40,  0,220, 65,255,255, 37, 57,255,255, 72, 57,255,255,132, 56,
/* 0x0350 */  20, 74, 40,125, 80, 72, 42,125,166,  3, 41,125,  0,  0,165, 47,
/* 0x0360 */  32,  0,158, 64, 40,  0,  0, 72,166,  2,  8,124, 16,  0,  1,248,
/* 0x0370 */ 145,255, 33,248,127,  0, 96, 56,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0380 */   1,  0, 42,141,  1,  0, 36,157,248,255,  0, 66,  8,  0, 35,233,
/* 0x0390 */  20, 42, 41,125,  8,  0, 35,249,  0,  0, 35,233, 80, 72,165,124,
/* 0x03a0 */   0,  0,163,248, 32,  0,128, 78,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x03b0 */ 128,  0,  0,  0,  0,  0, 35, 44, 32,  0,130, 77,225,  7,105,120,
/* 0x03c0 */  32,  0,130, 76,  0,  0,  0, 57,  0,  0,192, 56,  0,  0, 35,233,
/* 0x03d0 */ 120, 35,135,124, 64, 32,169,127, 20,  0,158, 64,  8,  0,163,248,
/* 0x03e0 */   1,  0,  8, 57,180,  7,  8,125, 12,  0,  0, 72,  1,  0,169, 43,
/* 0x03f0 */  64,  0,158, 65,  0,  0,169, 47, 60,  0,158, 64,  0,  0,168, 47,
/* 0x0400 */  32,  0,158, 76,  0,  0,166, 47, 16,  0,222, 65,  0,  0,230,248,
/* 0x0410 */   8,  0,166,248, 32,  0,128, 78,166,  2,  8,124, 16,  0,  1,248,
/* 0x0420 */ 145,255, 33,248,127,  0, 96, 56,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0430 */ 120, 27,102,124, 16,  0, 99, 56,148,255,255, 75,  0,  0,  0,  0,
/* 0x0440 */   0,  0,  0,  1,128,  0,  0,  0,  0,  0, 36,233,  0,  0,169, 47,
/* 0x0450 */  32,  0,158, 77,166,  2,  8,124, 16,  0,  1,248,240,255,193,251,
/* 0x0460 */ 248,255,225,251, 97,255, 33,248,120, 35,159,124,120, 27,126,124,
/* 0x0470 */ 120,243,195,127,112,  0,129, 56, 12,  0,160, 56,185,254,255, 75,
/* 0x0480 */ 112,  0, 33,129,  0,  0,169, 47, 40,  0,158, 64,116,  0, 33,129,
/* 0x0490 */  88, 33, 64, 61, 85, 80, 74, 97,  0, 80,137,127, 32,  0,222, 64,
/* 0x04a0 */   0,  0, 62,233,  0,  0,169, 47,204,  0,254, 65, 16,  0,  0, 72,
/* 0x04b0 */ 116,  0,161,128,  0,  0,165, 47, 16,  0,254, 64,127,  0, 96, 56,
/* 0x04c0 */   1,  0,  0, 72,  0,  0,  0, 96, 64, 40,137,127,240,255,220, 65,
/* 0x04d0 */   0,  0, 95,233, 64, 80,169,127,228,255,221, 65, 64, 40,137,127,
/* 0x04e0 */  88,  0,157, 64,128,  0, 33,249,  8,  0,126,232,244,255, 99, 56,
/* 0x04f0 */   8,  0,159,232,128,  0,161, 56,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0500 */   0,  0,163, 47,184,255,222, 64,112,  0, 33,129,128,  0, 65,233,
/* 0x0510 */   0, 80,169,127,168,255,222, 64,116,  0,  1,129,  8,  0, 94,233,
/* 0x0520 */  20, 66, 74,125,  8,  0, 94,249,  0,  0, 62,233, 80, 72, 40,125,
/* 0x0530 */   0,  0, 62,249, 28,  0,  0, 72,  0,  0, 62,233, 12,  0, 41, 57,
/* 0x0540 */   0,  0, 62,249,120,243,195,127,  8,  0,159,232,233,253,255, 75,
/* 0x0550 */ 112,  0,  1,129,  8,  0, 95,233, 20, 66, 74,125,  8,  0, 95,249,
/* 0x0560 */   0,  0, 63,233, 80, 72, 40,125,  0,  0, 63,249,  0,  0,169, 47,
/* 0x0570 */   0,255,158, 64,160,  0, 33, 56, 16,  0,  1,232,166,  3,  8,124,
/* 0x0580 */ 240,255,193,235,248,255,225,235, 32,  0,128, 78,  0,  0,  0,  0,
/* 0x0590 */   0,  0,  0,  1,128,  2,  0,  0,166,  2,  8,124, 16,  0,  1,248,
/* 0x05a0 */  38,  0,128,125,112,255,193,249,120,255,225,249,128,255,  1,250,
/* 0x05b0 */ 136,255, 33,250,144,255, 65,250,152,255, 97,250,160,255,129,250,
/* 0x05c0 */ 168,255,161,250,176,255,193,250,184,255,225,250,192,255,  1,251,
/* 0x05d0 */ 200,255, 33,251,208,255, 65,251,216,255, 97,251,224,255,129,251,
/* 0x05e0 */ 232,255,161,251,240,255,193,251,248,255,225,251,  8,  0,129,145,
/* 0x05f0 */ 193,254, 33,248,120, 27,122,124,128,  1,161,248,120, 51,211,124,
/* 0x0600 */ 144,  1,225,248, 32,  0,227,235, 20,250,227,127,121, 35,136,124,
/* 0x0610 */ 128,  0,  1,249, 64,  0,130, 65,  0,  0,  7,233, 64,  0, 72, 57,
/* 0x0620 */  72,  0,202,234, 16,  0, 35,161,  2,  0,137, 47, 16,  0,158, 65,
/* 0x0630 */  80, 64,214,126,120,179,195,126, 12,  0,  0, 72, 16,  0,106,232,
/* 0x0640 */   0,  0,192, 58, 40,  0,138,232,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0650 */ 124,  1,  0, 72, 16,  0, 35,161, 16,  0,160, 59,  3,  0,137, 47,
/* 0x0660 */   8,  0,158, 64,  0,  0,160, 59, 56,  0,218,163,180,  7,220,127,
/* 0x0670 */   1,  0,  0, 72,  0,  0,  0, 96,255,255,156, 59,  0,  0,156, 47,
/* 0x0680 */ 136,  0,156, 65,255,255, 62, 57, 32,  0, 41,121,  1,  0, 41, 57,
/* 0x0690 */  36, 31, 40,121,100, 54, 41,121, 80, 72,  8,125, 20, 66, 31,125,
/* 0x06a0 */ 120,251,233,127,  0, 16,192, 59,  0,  0,224, 56,255,255, 96, 59,
/* 0x06b0 */   0,  0, 73,129,  1,  0,138, 47, 64,  0,158, 64, 40,  0, 73,233,
/* 0x06c0 */   0,  0,170, 47, 52,  0,158, 65, 16,  0,201,232, 64, 48,187,127,
/* 0x06d0 */   8,  0,157, 64,120, 51,219,124, 20, 82, 70,125, 64, 80,167,127,
/* 0x06e0 */   8,  0,156, 64,120, 83, 71,125, 48,  0, 73,233, 64, 80,190,127,
/* 0x06f0 */   8,  0,156, 64,120, 83, 94,125, 56,  0, 41, 57, 64, 64,169,127,
/* 0x0700 */ 176,255,158, 64, 16,  0,  0, 72,  0, 16,192, 59,  0,  0,224, 56,
/* 0x0710 */ 255,255, 96, 59,208,  0,  3,125, 56, 24,123,127,248, 24,105,124,
/* 0x0720 */  20, 58, 41,125, 80, 72, 59,125, 56, 24, 57,125, 64,240,168,127,
/* 0x0730 */  24,  5,156, 64,  1,  0, 64, 57, 40,  8, 74,121,210, 81, 40,125,
/* 0x0740 */  64,240,169,127,244,255,156, 65, 32,  0, 56,123,255,255, 74, 57,
/* 0x0750 */ 214, 65, 74,125, 20,194,138,127, 32,  0,151,123, 34,  0,166, 99,
/* 0x0760 */ 120,219, 99,127,120,187,228,126,  0,  0,160, 56,180,  7,198,124,
/* 0x0770 */ 255,255,224, 56,  0,  0,  0, 57,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0780 */ 120, 27,117,124,120, 27,118,124,208,  0,163,127,255,255,222, 59,
/* 0x0790 */  57,240,189,127, 28,  0,130, 65,120,235,164,127,  1,  0,  0, 72,
/* 0x07a0 */   0,  0,  0, 96, 20,234,213,126, 80,224,221,127, 32,  0,215,123,
/* 0x07b0 */  80,184, 24,127, 33,  0,  4,123, 16,  0,130, 65, 20,202,118,124,
/* 0x07c0 */   1,  0,  0, 72,  0,  0,  0, 96, 80,176,219,126,  1,  0,  0, 72,
/* 0x07d0 */   0,  0,  0, 96, 56,  0, 58,161,  0,  0,137, 47, 80,  4,157, 64,
/* 0x07e0 */   0,  0,192, 59,128,  0, 33,233,  0,  0, 41, 46, 81,115,  0, 62,
/* 0x07f0 */  64, 98, 16, 98,248, 24,117,124, 21,  0,  0, 72,  2,  0,  0, 68,
/* 0x0800 */ 120,251,236,127,  0,  0,128, 56, 32,  0,128, 78,166,  2,200,125,
/* 0x0810 */   1,  0,224, 61,228,131,239,121,  1,  0,239, 97,164,  7,106,122,
/* 0x0820 */ 152,  0, 65,249,248, 24, 99,124,136,  0, 97,144, 32,  0,104,120,
/* 0x0830 */ 160,  0,  1,249,  9,  0,  0, 72,117,112,120,  0,166,  2, 40,125,
/* 0x0840 */ 168,  0, 33,249,  0,  0,128, 58,  9,  0,  0, 72,117,112,120,  0,
/* 0x0850 */ 166,  2, 72,125,144,  0, 65,249, 40,  0,146, 65,  0,  0, 63,129,
/* 0x0860 */   6,  0,137, 47, 28,  0,158, 64, 16,  0,191,232,120,155, 99,126,
/* 0x0870 */   3,  0,128, 56, 20, 42,182,124, 61,251,255, 75,152,  3,  0, 72,
/* 0x0880 */   0,  0, 63,129,  1,  0,137, 47,140,  3,158, 64, 40,  0, 63,233,
/* 0x0890 */   0,  0,169, 47,128,  3,158, 65,  4,  0,159,131,250, 22,156, 87,
/* 0x08a0 */  48,228, 28,126,126,  7,151, 87, 32,  0,241,122, 76,  0,146, 65,
/* 0x08b0 */   8,  0, 63,233,  0,  0,169, 47, 64,  0,158, 64, 32,  0, 58,233,
/* 0x08c0 */  20, 74, 54,125, 16,  0,191,232,120,155, 99,126,  3,  0,128, 56,
/* 0x08d0 */  20, 42,169,124,225,250,255, 75,120,155, 99,126,  5,  0,128, 56,
/* 0x08e0 */  56,  0,186,160,209,250,255, 75,120,155, 99,126,  4,  0,128, 56,
/* 0x08f0 */  54,  0,186,160,193,250,255, 75, 32,  0,127,235,112,  0, 97,251,
/* 0x0900 */  16,  0,191,235, 20,234,182,127,120,  0,161,251, 40,  0, 31,235,
/* 0x0910 */  20,194, 29,127, 20,218, 61,127, 56,168,170,127, 20,218,106,127,
/* 0x0920 */  80,232,170,127, 20,218, 61,125,208,  0, 41,125, 56,168, 41,125,
/* 0x0930 */  20,218,105,127,144,  0,146, 65,  4,  0, 63,129,225,  7, 40,121,
/* 0x0940 */  80,  0,130, 65,144,  0, 97,232, 16,  0,128, 56,  1,  0,  0, 72,
/* 0x0950 */   0,  0,  0, 96,120, 27,114,124,120,219,100,127,  1,  0,  0, 72,
/* 0x0960 */   0,  0,  0, 96,120,235,163,127,120,219,100,127,  3,  0,160, 56,
/* 0x0970 */  17,  0,192, 56,120,147, 71,126,  0,  0,  0, 57,  1,  0,  0, 72,
/* 0x0980 */   0,  0,  0, 96,  0, 24,189,127,236,  2,254, 65, 76,  2,  0, 72,
/* 0x0990 */ 224,  7,133,123,120,235,163,127,120,219,100,127,  2,  0,165, 96,
/* 0x09a0 */  50,  0,192, 56,255,255,224, 56,  0,  0,  0, 57,  1,  0,  0, 72,
/* 0x09b0 */   0,  0,  0, 96,  0, 24,189,127, 32,  2,222, 64,  0,  0, 64, 58,
/* 0x09c0 */ 180,  2,  0, 72,  8,  0, 31,233,120,235,163,127,120,219,100,127,
/* 0x09d0 */ 180,  7,229,126, 18,  0,192, 56,128,  1,225,232, 80, 64, 10,125,
/* 0x09e0 */   1,  0,  0, 72,  0,  0,  0, 96,  0, 24,189,127,236,  1,222, 64,
/* 0x09f0 */ 227,255,137,123,192,  1,130, 65,  0,  0, 64, 58,208,  0, 57,125,
/* 0x0a00 */ 136,  0, 65,129, 56, 80, 41,125, 33,  0, 42,121, 20,  0,130, 65,
/* 0x0a10 */ 255,255, 57, 57,166,  3, 73,125,  1,  0,137,158,252,255,  0, 66,
/* 0x0a20 */  20, 82, 57,127,144,  1,210, 65,  4,  0, 63,129,225,  7, 40,121,
/* 0x0a30 */ 132,  1,130, 65,120,  0, 33,233,  3,  0, 41, 57,100,  7, 41,121,
/* 0x0a40 */ 120, 75, 60,125,  0,  0, 95,233,192,  7, 74,121,  0,120,170,127,
/* 0x0a50 */ 240,  0,158, 64,208,  0, 73,125,160,  0,  1,233, 56, 80, 10,125,
/* 0x0a60 */  15,  0,170, 47,136,  0,157, 64,  0,  0,206,136,  1,  0,238,136,
/* 0x0a70 */   2,  0, 14,137,  3,  0, 78,137,  0,  0,201,152,  1,  0,233,152,
/* 0x0a80 */   2,  0,  9,153,  3,  0, 73,153,  4,  0,206,136,  5,  0,238,136,
/* 0x0a90 */   6,  0, 14,137,  7,  0, 78,137,  4,  0,201,152,  5,  0,233,152,
/* 0x0aa0 */   6,  0,  9,153,  7,  0, 73,153,  8,  0,206,136,  9,  0,238,136,
/* 0x0ab0 */  10,  0, 14,137, 11,  0, 78,137,  8,  0,201,152,  9,  0,233,152,
/* 0x0ac0 */  10,  0,  9,153, 11,  0, 73,153, 12,  0,206,136, 13,  0,238,136,
/* 0x0ad0 */  14,  0, 14,137, 15,  0, 78,137, 12,  0,201,152, 13,  0,233,152,
/* 0x0ae0 */  14,  0,  9,153, 15,  0, 73,153, 88,  0,  0, 72,168,  0, 97,232,
/* 0x0af0 */  16,  0,128, 56,  1,  0,  0, 72,  0,  0,  0, 96,120, 27,113,124,
/* 0x0b00 */ 120,115,196,125, 16,  0,160, 56,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0b10 */   0,  0, 96, 56, 16,  0,128, 56,  5,  0,160, 56,  1,  0,192, 56,
/* 0x0b20 */ 120,139, 39,126,  0,  0,  0, 57,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0b30 */ 120, 27,124,124,120,139, 35,126,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0b40 */   0,  0,188, 47, 20,  0,158, 65,152,  0, 97,232,  0,  0,128, 56,
/* 0x0b50 */ 120,227,133,127, 97,248,255, 75,120,235,163,127,120,219,100,127,
/* 0x0b60 */   4,  0,160, 56,  1,  0,  0, 72,  0,  0,  0, 96,120,235,163,127,
/* 0x0b70 */ 120,219,100,127,  1,  0,  0, 72,  0,  0,  0, 96,120,235,163,127,
/* 0x0b80 */ 120,219,100,127,180,  7,229,126, 17,  0,192, 56,120,147, 71,126,
/* 0x0b90 */   0,  0,  0, 57,  1,  0,  0, 72,  0,  0,  0, 96,  0, 24,189,127,
/* 0x0ba0 */  56,  0,222, 64,120,147, 67,126,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0bb0 */  52,  0,  0, 72,  3,  0,151, 43, 44,  0,158, 65,120,235,163,127,
/* 0x0bc0 */ 120,219,100,127,120,139, 37,126,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0bd0 */   0,  0,163, 47, 16,  0,254, 65,127,  0, 96, 56,  1,  0,  0, 72,
/* 0x0be0 */   0,  0,  0, 96, 64,200,184,127, 44,  0,157, 64,120,203, 35,127,
/* 0x0bf0 */  80,192,153,124,180,  7,229,126, 50,  0,192, 56,255,255,224, 56,
/* 0x0c00 */   0,  0,  0, 57,  1,  0,  0, 72,  0,  0,  0, 96,  0, 24,185,127,
/* 0x0c10 */ 200,255,222, 64, 56,  0,255, 59,  1,  0, 94, 57,180,  7, 94,125,
/* 0x0c20 */  56,  0, 58,161,  0, 80,137,127, 48,252,157, 65,144,  1, 33,233,
/* 0x0c30 */   0,  0,169, 47,  8,  0,158, 65,  0,  0,201,250, 24,  0,122,232,
/* 0x0c40 */  20, 26,118,124, 72,  0,  0, 72, 34,  0,166, 99,120,219, 99,127,
/* 0x0c50 */  32,  0, 36,123,  0,  0,160, 56,180,  7,198,124,255,255,224, 56,
/* 0x0c60 */   0,  0,  0, 57,  1,  0,  0, 72,  0,  0,  0, 96,120, 27,118,124,
/* 0x0c70 */  88,251,255, 75,128,  0, 97,232,112,  0,129, 56,205,247,255, 75,
/* 0x0c80 */ 227,255,138,123,164,253,130, 65,116,253,255, 75, 64,  1, 33, 56,
/* 0x0c90 */  16,  0,  1,232,  8,  0,129,129,166,  3,  8,124,112,255,193,233,
/* 0x0ca0 */ 120,255,225,233,128,255,  1,234,136,255, 33,234,144,255, 65,234,
/* 0x0cb0 */ 152,255, 97,234,160,255,129,234,168,255,161,234,176,255,193,234,
/* 0x0cc0 */ 184,255,225,234,192,255,  1,235,200,255, 33,235,208,255, 65,235,
/* 0x0cd0 */ 216,255, 97,235,224,255,129,235,232,255,161,235,240,255,193,235,
/* 0x0ce0 */ 248,255,225,235, 32,129,144,125, 32,  0,128, 78,  0,  0,  0,  0,
/* 0x0cf0 */   0,  0,  0,  3,128, 18,  0,  0,166,  2,  8,124, 16,  0,  1,248,
/* 0x0d00 */ 232,255,161,251,240,255,193,251,248,255,225,251,113,239, 33,248,
/* 0x0d10 */ 120, 27,125,124,120, 35,159,124,120, 43,190,124,112,  0, 97, 56,
/* 0x0d20 */   1,  0,  0, 72,  0,  0,  0, 96,120,251,227,127,120,235,164,127,
/* 0x0d30 */   3,  0,160, 56, 50,  0,192, 56,255,255,224, 56,  0,  0,  0, 57,
/* 0x0d40 */   1,  0,  0, 72,  0,  0,  0, 96,120,251,227,127,112,  0,129, 56,
/* 0x0d50 */ 120,243,197,127,  1,  0,  0, 72,  0,  0,  0, 96,144, 16, 33, 56,
/* 0x0d60 */  16,  0,  1,232,166,  3,  8,124,232,255,161,235,240,255,193,235,
/* 0x0d70 */ 248,255,225,235, 32,  0,128, 78,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x0d80 */ 128,  3,  0,  0,166,  2,  8,124, 16,  0,  1,248,200,255, 33,251,
/* 0x0d90 */ 208,255, 65,251,216,255, 97,251,224,255,129,251,232,255,161,251,
/* 0x0da0 */ 240,255,193,251,248,255,225,251, 33,255, 33,248,120, 43,189,124,
/* 0x0db0 */ 120, 51,217,124,120, 59,251,124,120,  0,161,248,  0,  0, 35,129,
/* 0x0dc0 */ 112,  0, 33,249,152,  0, 97,248,  4,  0, 35,129, 12,  0, 41, 57,
/* 0x0dd0 */ 144,  0, 33,249,136,  0, 97,248,128,  0,129,248,144,  0, 97, 56,
/* 0x0de0 */ 112,  0,129, 56,101,246,255, 75,  1,  0,  0, 72,  0,  0,  0, 96,
/* 0x0df0 */ 120,235,163,127,128,  0,129, 56,  0,  0,160, 56,120,203, 38,127,
/* 0x0e00 */ 120,219,103,127,149,247,255, 75,120, 27,122,124,120,203, 35,127,
/* 0x0e10 */   9,  0,128, 56,120,211, 69,127,157,245,255, 75, 64,  0,253, 59,
/* 0x0e20 */  56,  0, 61,161,  0,  0,137, 47,184,  0,158, 65,  0,  0,192, 59,
/* 0x0e30 */   0,  0, 63,129,  3,  0,137, 47,144,  0,158, 64, 16,  0, 95,233,
/* 0x0e40 */   0,  0,123,232, 20, 26,106,124,  0,  0,128, 56,  0,  0,160, 56,
/* 0x0e50 */   1,  0,  0, 72,  0,  0,  0, 96,120, 27,124,124,  0,  0,131, 47,
/* 0x0e60 */  28,  0,220, 65,120,235,164,127,  0,  4,160, 56,  1,  0,  0, 72,
/* 0x0e70 */   0,  0,  0, 96,  0,  4,163, 47, 16,  0,254, 65,127,  0, 96, 56,
/* 0x0e80 */   1,  0,  0, 72,  0,  0,  0, 96,  0,  0, 32, 57,  0,  0, 59,249,
/* 0x0e90 */ 120,235,163,127,  0,  0,128, 56,120,227,133,127,  0,  0,192, 56,
/* 0x0ea0 */ 120,219,103,127,245,246,255, 75,120, 27,122,124,120,203, 35,127,
/* 0x0eb0 */   7,  0,128, 56,  0,  0,187,232,253,244,255, 75,120,227,131,127,
/* 0x0ec0 */   1,  0,  0, 72,  0,  0,  0, 96, 56,  0,255, 59,  1,  0, 94, 57,
/* 0x0ed0 */  32,  0, 94,121, 56,  0, 61,161, 64, 80,137,127, 84,255,157, 65,
/* 0x0ee0 */ 120,211, 67,127,224,  0, 33, 56, 16,  0,  1,232,166,  3,  8,124,
/* 0x0ef0 */ 200,255, 33,235,208,255, 65,235,216,255, 97,235,224,255,129,235,
/* 0x0f00 */ 232,255,161,235,240,255,193,235,248,255,225,235, 32,  0,128, 78,
/* 0x0f10 */   0,  0,  0,  0,  0,  0,  0,  1,128,  7,  0,  0,153,  9,  0, 56,
/* 0x0f20 */   8,  0,128,124, 32,  0,231,120, 90,  0,  0, 56,  2,  0,  0, 68,
/* 0x0f30 */   8,  0,227, 64,255,255, 96, 56, 32,  0,128, 78, 91,  0,  0, 56,
/* 0x0f40 */   8,  0,  0, 72,125,  0,  0, 56,  8,  0,  0, 72,144,  0,  0, 56,
/* 0x0f50 */   8,  0,  0, 72, 93,  0,  0, 56,  8,  0,  0, 72,  1,  0,  0, 56,
/* 0x0f60 */   8,  0,  0, 72, 45,  0,  0, 56,  8,  0,  0, 72, 85,  0,  0, 56,
/* 0x0f70 */   8,  0,  0, 72,  4,  0,  0, 56,  8,  0,  0, 72,  3,  0,  0, 56,
/* 0x0f80 */   8,  0,  0, 72,  5,  0,  0, 56,  8,  0,  0, 72,  6,  0,  0, 56,
/* 0x0f90 */ 156,255,255, 75,104,  1,  0, 56,  2,  0,  0, 68, 76,  0,227, 64,
/* 0x0fa0 */   0,  0,  5, 44, 12,  0,130, 65,  0,  0,160, 56,232,255,255, 75,
/* 0x0fb0 */ 166,  2,200,124, 17,  0,  0, 72, 47,100,101,118, 47,115,104,109,
/* 0x0fc0 */   0,  0,  0,  0,166,  2,136,124,166,  3,200,124,192,  1,160, 56,
/* 0x0fd0 */  65,  0,192, 60,  2,  0,198, 96,  5,  0,  0, 56,  2,  0,  0, 68,
/* 0x0fe0 */   8,  0,227, 64,  8,  0,128,124, 32,  0,128, 78,166,  2,200,124,
/* 0x0ff0 */  16,  0,128, 56,  9,  0,  0, 72,117,112,120,  0,166,  2,104,124,
/* 0x1000 */ 104,  1,  0, 56,  2,  0,  0, 68, 32,  0,227, 64,  0,  0,132, 47,
/* 0x1010 */   8,  0,158, 64,  8,  0,128,124, 22,  0,131, 47,248,255,158, 64,
/* 0x1020 */   0,  0,128, 56,208,255,255, 75,166,  3,200,124, 32,  0,128, 78,
/* 0x1030 */   0,  0,  5, 44, 28,  0,194, 65,166,  3,169,124,255,255,195, 56,
/* 0x1040 */ 255,255,132, 56,  1,  0,  4,140,  1,  0,  6,156,248,255,  0, 66,
/* 0x1050 */  32,  0,128, 78,  8,  0,128,124, 32,  0,128, 78,166,  2,  8,124,
/* 0x1060 */ 225,255, 97,248,  8,  0,129,248, 16,  0,161,248, 24,  0,  1,248,
/* 0x1070 */   8,  0,227,136,120, 43,166,124,120, 35,133,124,  4,  0,131,128,
/* 0x1080 */  12,  0, 99, 56,129,  0,  0, 72,120, 27,102,124,  0,  0,161,232,
/* 0x1090 */   8,  0, 97,232, 16,  0,129,232, 24,  0, 33, 56,  0,  0,132,232,
/* 0x10a0 */ 233,255, 97,248,  8,  0,129,248, 16,  0,193,248,  9,  0,197,136,
/* 0x10b0 */  10,  0,165,136,  0,  0,  6, 44,  8,  0,130, 65,  1,  0,  0, 72,
/* 0x10c0 */   0,  0, 97,232,  8,  0,129,232, 16,  0, 33, 56, 20, 26,132,124,
/* 0x10d0 */  31,  0, 99, 96,108, 24,  0,124, 64, 32,  3,124,172, 31,  0,124,
/* 0x10e0 */  32,  0, 99, 56,240,255,128, 65,172,  4,  0,124, 44,  1,  0, 76,
/* 0x10f0 */   0,  0, 97,232,  8,  0,  1,232, 16,  0, 33, 56,166,  3,  8,124,
/* 0x1100 */  32,  0,128, 78,120, 59,227,124,  8, 24,131,124,  0,  0,230,232,
/* 0x1110 */ 166,  3,168,125, 80, 24,100,124, 80, 40,135,124,  1,  0, 99, 56,
/* 0x1120 */   1,  0,132, 56,  0,  0,134,248, 32,  0,128, 78,208,  0,  6, 40,
/* 0x1130 */  32,  0,194, 76,191,240,132, 84, 32,  0,194, 77, 16,  0,  0, 60,
/* 0x1140 */  64,  0,  4,124,  8,  0,128, 65,120,  3,  4,124, 32,  1,165, 56,
/* 0x1150 */ 120, 27,103,124,252,255, 99, 56,166,  3,137,124, 28,  0,  0, 72,
/* 0x1160 */ 186,  2, 11, 84, 80, 88, 99,125, 20, 58,107,125,186,  1, 96, 81,
/* 0x1170 */   0,  0,  3,144, 32,  0, 64, 79,  4,  0,  3,132,190, 85, 11, 84,
/* 0x1180 */  64, 40, 11,124,220,255,194, 65,240,255, 32, 67, 32,  0,128, 78,
/* 0x1190 */   8,  0,  7, 44, 88,  1,130, 64,236, 41,  0,124,166,  2,168,125,
/* 0x11a0 */   8,  0,  7, 40, 72,  1,130, 64,  0,  0,166,248, 20, 26,132,124,
/* 0x11b0 */   0,128,  0, 60,198,  7,  0,120,120,  3,  9,124,255,255, 99, 56,
/* 0x11c0 */ 255,255,165, 56,255,255, 64, 57, 20,  1,  0, 72,  1,  0, 32, 57,
/* 0x11d0 */  46, 24, 41,125,  4,  0, 99, 56, 20, 73, 41,125, 36,248, 41,121,
/* 0x11e0 */  64,  0, 41,124, 20, 72, 41,125, 32,  0,128, 78,  1,  0,  3,141,
/* 0x11f0 */   1,  0,  5,157, 64,  0, 41,124, 20, 72, 41,125,209,255,194, 65,
/* 0x1200 */ 236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,255,255,231, 56,
/* 0x1210 */  21, 72, 41,125,185,255,194, 65, 20, 57,231,124, 21, 72, 41,125,
/* 0x1220 */ 173,255,194, 65, 20, 57,231,124, 64,  0, 41,124, 20, 72, 41,125,
/* 0x1230 */ 157,255,194, 65,216,255,192, 65,253,255,231, 52,  0,  0,  0, 57,
/* 0x1240 */  40,  0,192, 65,  1,  0, 99,141,198, 69,231,120,118,  6,231,124,
/* 0x1250 */ 249, 88,234,124,116, 14, 74,125,  0,  0,194, 65,  1,  0,107,113,
/* 0x1260 */  80,  0,226, 65, 20,  0,  0, 72, 64,  0, 41,124, 20, 72, 41,125,
/* 0x1270 */  93,255,194, 65, 60,  0,225, 65,  1,  0,  0, 57, 64,  0, 41,124,
/* 0x1280 */  20, 72, 41,125, 73,255,194, 65, 40,  0,225, 65, 21, 72, 41,125,
/* 0x1290 */  61,255,194, 65, 20, 65,  8,125, 64,  0, 41,124, 20, 72, 41,125,
/* 0x12a0 */  45,255,194, 65,232,255,192, 65,  2,  0,  8, 57, 16,  0,  0, 72,
/* 0x12b0 */  21, 72, 41,125, 25,255,194, 65, 20, 65,  8,125,255,250,106, 33,
/* 0x12c0 */   2,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,166,  3,  9,125,
/* 0x12d0 */   1,  0,103,141,  1,  0,101,157,248,255, 32, 67,  0,  1,224, 56,
/* 0x12e0 */ 236, 41,  7,124, 44, 26,  7,124, 12,255,255, 75,  5,  0,  7, 44,
/* 0x12f0 */  64,  1,130, 64,236, 41,  0,124,166,  2,168,125,  5,  0,  7, 40,
/* 0x1300 */  48,  1,130, 64,  0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,
/* 0x1310 */ 198,  7,  0,120,  0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,
/* 0x1320 */ 255,255,165, 56,255,255, 64, 57,248,  0,  0, 72,  1,  0, 32, 57,
/* 0x1330 */  46, 24, 41,125,  4,  0, 99, 56, 20, 73, 41,125, 36,248, 41,121,
/* 0x1340 */  64,  0, 41,124, 20, 72, 41,125, 32,  0,128, 78,  1,  0,  3,141,
/* 0x1350 */   1,  0,  5,157, 64,  0, 41,124, 20, 72, 41,125,209,255,194, 65,
/* 0x1360 */ 236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,255,255,231, 56,
/* 0x1370 */  21, 72, 41,125,185,255,194, 65, 21, 57,231,124, 21, 72, 41,125,
/* 0x1380 */ 173,255,194, 65, 21, 57,231,124, 64,  0, 41,124, 20, 72, 41,125,
/* 0x1390 */ 157,255,194, 65,216,255,192, 65,  0,  0,  0, 57,253,255,231, 52,
/* 0x13a0 */  46, 64,231, 84, 28,  0,192, 65,  1,  0, 99,141,249, 88,234,124,
/* 0x13b0 */ 112, 14, 74,125,  0,  0, 42, 44,  0,  0,194, 65, 12,  0,  0, 72,
/* 0x13c0 */  21, 72, 41,125,105,255,194, 65, 21, 65,  8,125, 21, 72, 41,125,
/* 0x13d0 */  93,255,194, 65, 21, 65,  8,125, 40,  0,130, 64,  1,  0,  0, 57,
/* 0x13e0 */  21, 72, 41,125, 73,255,194, 65, 21, 65,  8,125, 64,  0, 41,124,
/* 0x13f0 */  20, 72, 41,125, 57,255,194, 65,232,255,192, 65,  2,  0,  8, 57,
/* 0x1400 */ 255,250,234, 32,  1,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,
/* 0x1410 */ 166,  3,  9,125,  1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,
/* 0x1420 */   0,  1,224, 56,236, 41,  7,124, 44, 26,  7,124, 40,255,255, 75,
/* 0x1430 */   2,  0,  7, 44,252,  0,130, 64,236, 41,  0,124,166,  2,168,125,
/* 0x1440 */   2,  0,  7, 40,236,  0,130, 64,  0,  0,166,248, 20, 26,132,124,
/* 0x1450 */   0,128,  0, 60,198,  7,  0,120,120,  3,  9,124,255,255, 99, 56,
/* 0x1460 */ 255,255,165, 56,255,255, 64, 57,184,  0,  0, 72, 20, 73, 41,125,
/* 0x1470 */  36,248, 41,121, 64,  0, 41,124, 20, 72, 41,125, 32,  0,226, 76,
/* 0x1480 */   1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,224,255,255, 75,
/* 0x1490 */   1,  0,  3,141,  1,  0,  5,157,221,255,255, 75,244,255,225, 65,
/* 0x14a0 */   1,  0,224, 56,209,255,255, 75, 21, 57,231,124,201,255,255, 75,
/* 0x14b0 */ 244,255,192, 65,253,255,231, 52,  0,  0,  0, 57, 24,  0,192, 65,
/* 0x14c0 */   1,  0, 99,141, 46, 64,231, 84,248, 88,234,124, 63,  0, 75, 85,
/* 0x14d0 */   0,  0,194, 65,161,255,255, 75, 21, 65,  8,125,153,255,255, 75,
/* 0x14e0 */  21, 65,  8,125,  1,  0,224, 56, 28,  0,194, 64,  3,  0,224, 56,
/* 0x14f0 */   1,  0,  0, 57,129,255,255, 75, 21, 65,  8,125,121,255,255, 75,
/* 0x1500 */ 244,255,192, 65,255,242,106, 33, 20, 57,  8,125, 20, 42,234,124,
/* 0x1510 */ 166,  3,  9,125,  1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,
/* 0x1520 */   0,  1,224, 56,236, 41,  7,124, 44, 26,  7,124,108,255,255, 75,
/* 0x1530 */  14,  0,  7, 44,  0,  0,130, 64,120, 11, 42,124,  0,  0, 38, 57,
/* 0x1540 */   0,  0,  6,129,120, 43,167,124,254,255,164, 56,  2,  0,131, 56,
/* 0x1550 */   0,  0,131,137,194,232,139,121, 96,  7,140,121,  0,250, 96, 56,
/* 0x1560 */  54, 88, 99,124,100,241, 99, 56, 20, 26, 33,124,100,  6, 33,120,
/* 0x1570 */   0,  0,  0, 56,120, 83, 67,125,  0,  0,  9,144,249,255,  3,248,
/* 0x1580 */  64, 24, 33,124,248,255,128, 65,255,255,  4,136, 32,  0,193, 56,
/* 0x1590 */  40,  0, 97, 56,  2,  0,131,153, 16,  0,225,248, 24,  0, 33,249,
/* 0x15a0 */   2,225, 11,120, 32,  7,  0,120,  1,  0, 99,153,  0,  0,  3,152,
/* 0x15b0 */ 145,255, 65,249,166,  2,  8,124, 16,  0,  1,248, 21,  0,  0, 72,
/* 0x15c0 */  16,  0,  1,232,  0,  0, 33,232,166,  3,  8,124, 32,  0,128, 78,
/* 0x15d0 */ 112,  0, 33, 56, 24,  0,161,232, 16,  0,225,232,  0,  0,165,128,
/* 0x15e0 */   0,  0, 33,232, 20, 58,165,124, 16,  0,  1,232,255,255,165, 56,
/* 0x15f0 */ 166,  3,  8,124,  0,  0, 33,232, 32,  0,128, 78, 32,  0,128, 78,
/* 0x1600 */ 166,  2,  8,124,  1,  0, 64, 57,  1,  0,  0, 72,  4,  0, 99, 59,
/* 0x1610 */   2,  0,227, 59,  0,  4,  0, 56,  2,  0, 99,137, 48, 88, 75,125,
/* 0x1620 */ 255,255,107, 57, 32,  0,107,121, 96,255, 97,249,  1,  0, 99,137,
/* 0x1630 */  48, 88, 74,125,  0,  0, 96, 57,255,255, 74, 57, 32,  0, 74,121,
/* 0x1640 */ 104,255, 65,249,  0,  0, 67,137,  0,  0,102,145,  0,  0,105,145,
/* 0x1650 */ 180,  7, 85,125,  1,  0, 99,137, 20, 82, 75,125,  0,  3, 96, 57,
/* 0x1660 */  48, 80,106,125, 54,  7, 74, 57, 32,  0, 74,121,  0,  0,138, 47,
/* 0x1670 */   1,  0,106, 57,  8,  0,254, 64,  1,  0, 96, 57,255,255,107, 53,
/* 0x1680 */  12,  0,130, 65,  2,  0, 31,180,244,255,255, 75,  5,  0,  0, 56,
/* 0x1690 */  20, 42,164,124,166,  3,  9,124,  5,  0,100, 57,120, 35,159,124,
/* 0x16a0 */   0,  0, 64, 57, 64, 40,191,127, 12,  0,158, 64,  1,  0, 96, 56,
/* 0x16b0 */  88, 10,  0, 72,  1,  0,255, 59,255,255, 31,136, 46, 64, 74, 85,
/* 0x16c0 */ 120, 83, 10,124, 32,  0, 74,121,220,255,  0, 66,255,255,  0, 56,
/* 0x16d0 */ 255,  0, 32, 63, 32,  0,  0,120,  1,  0,192, 58,  1,  0,  0, 59,
/* 0x16e0 */   1,  0,224, 58,  1,  0, 64, 58,  0,  0,128, 57,  0,  0,192, 59,
/* 0x16f0 */   0,  0, 64, 59,255,255, 57, 99,  1,  0,128, 58,  8,  0,117, 34,
/* 0x1700 */  64, 64,154,127,216,  9,156, 64, 96,255,161,235, 64,200,128,127,
/* 0x1710 */  56,232, 95,127, 54, 32,157, 85,180,  7,252,127,180,  7,189,127,
/* 0x1720 */  20,234,188,127,164, 15,189,123, 36,  0,157, 65, 64, 40,171,127,
/* 0x1730 */ 124,255,158, 65,  0,  0,139,139, 46, 64, 74, 85, 40, 64,  0,120,
/* 0x1740 */   1,  0,107, 57,120, 83,138,127, 32,  0, 74,121, 46,234,251,125,
/* 0x1750 */ 254,170, 16, 84,214,121, 16,126, 64,128,138,127, 32,  0, 28,122,
/* 0x1760 */ 228,  1,156, 64,  0,  8, 15, 32,104,255,225,235, 48,158,222,127,
/* 0x1770 */ 112, 46,  0,124, 20,122,224,125, 56,248, 64,127, 46,235,251,125,
/* 0x1780 */  48,168, 29,124,  6,  0,140, 47, 20,234,190,127,  0,  3,189, 31,
/* 0x1790 */  32,  0,189,123, 54,  7,189, 59,164, 15,189,123, 20,234,187,127,
/* 0x17a0 */  16,  0,157, 65,  1,  0,192, 59,120,227,128,127, 12,  1,  0, 72,
/* 0x17b0 */  80,208, 18,124,  1,  0,192, 59, 32,  0,  0,120,174,  0,231,125,
/* 0x17c0 */  60,  8,255, 85,180,  7,239,127,238,  5,255, 87, 64,200,156,127,
/* 0x17d0 */ 180,  7,255,127,  0,  1, 63, 58, 20,242, 49,126,164, 15, 49,122,
/* 0x17e0 */  36,  0,157, 65, 64, 40,171,127,196,254,158, 65,  0,  0, 11,136,
/* 0x17f0 */  46, 64, 74, 85, 40, 64,156,123,  1,  0,107, 57,120, 83, 10,124,
/* 0x1800 */  32,  0, 74,121, 46,138, 29,126,254,170,128, 87, 60,  8,222, 87,
/* 0x1810 */ 214,129,  0,124, 64,  0, 10,127, 32,  0, 14,120,  0,  0,191, 47,
/* 0x1820 */  36,  0,152, 64,  0,  8, 16, 32,180,  7,222,127,112, 46,  0,124,
/* 0x1830 */  20,130,  0,126,120,115,220,125, 46,139, 29,126, 48,  0,158, 65,
/* 0x1840 */ 104,255,255, 75, 80,224,128,127, 80, 80, 64,125,126,217,  0, 86,
/* 0x1850 */  80,128,  0,126,  1,  0,222, 59, 32,  0,156,123, 32,  0, 74,121,
/* 0x1860 */  46,139, 29,126,180,  7,222,127, 64,255,158, 65,255,  0,158, 47,
/* 0x1870 */  80,255,157, 64, 52,255,255, 75, 64,200,128,127,164, 15,208,123,
/* 0x1880 */  68,  0,157, 64, 46,130,157,127,254,170, 31, 84, 60,  8,222, 87,
/* 0x1890 */ 214,225,255,127, 64,248,138,127, 32,  0,241,123, 76,  0,156, 64,
/* 0x18a0 */   0,  8, 28, 32,180,  7,222,127,112, 46,  0,124, 20,226,128,127,
/* 0x18b0 */  46,131,157,127,120,139, 32,126,255,  0,158, 47,188,255,157, 64,
/* 0x18c0 */  80,  0,  0, 72, 64, 40,171,127,228,253,158, 65,  0,  0,235,139,
/* 0x18d0 */  46, 64, 74, 85, 40, 64,  0,120,  1,  0,107, 57,120, 83,234,127,
/* 0x18e0 */  32,  0, 74,121,160,255,255, 75, 80,  0, 31,124, 80, 80, 95,125,
/* 0x18f0 */ 126,217,159, 87, 80,224,159,127,  1,  0,222, 59, 32,  0, 74,121,
/* 0x1900 */  46,131,157,127,180,  7,222,127, 32,  0, 17,120,168,255,255, 75,
/* 0x1910 */  32,  6,222,123,  1,  0,250, 59,  3,  0,140, 47, 32,  0,255,123,
/* 0x1920 */ 174,209,199,127,172,  7,157, 64,  9,  0,140, 47, 12,  0,157, 65,
/* 0x1930 */ 253,255,140, 57,  8,  0,  0, 72,250,255,140, 57,180,  7,140,125,
/* 0x1940 */ 148,  7,  0, 72, 80,  0, 16,124,126,217,254, 85, 80, 80, 16,126,
/* 0x1950 */  80,120,254,125,192,  0,140, 59, 64,200,128,127, 46,235,251,125,
/* 0x1960 */  32,  0, 17,120, 32,  0, 10,122,164, 15,156,123, 36,  0,157, 65,
/* 0x1970 */  64, 40,171,127, 56,253,158, 65,  0,  0, 75,137, 46, 64, 16, 86,
/* 0x1980 */  40, 64, 17,120,  1,  0,107, 57,120,131, 74,125, 32,  0, 74,121,
/* 0x1990 */  46,226, 27,126,254,170, 32, 86,214,129,  0,124, 64,  0,138,127,
/* 0x19a0 */  32,  0, 30,120, 68,  0,156, 64,  7,  0,140, 47,  0,  8, 16, 32,
/* 0x19b0 */  38, 16,144,125,254,239,140, 85,112, 46,  0,124, 20,130,  0,126,
/* 0x19c0 */ 120,195, 22,127,208,  0,140,125,120,187,248,126, 46,227, 27,126,
/* 0x19d0 */  66,240,140,121,104,  6,163, 59,  0, 16,140,121,120,147, 87,126,
/* 0x19e0 */   3,  0,140, 57,124,  2,  0, 72, 80,136,192,127,126,217, 15, 86,
/* 0x19f0 */  80,128, 15,126, 80, 80,  0,124, 64,200,158,127, 46,227, 27,126,
/* 0x1a00 */  32,  0,209,123, 32,  0, 10,120, 24,  0, 28, 58, 36,  0,157, 65,
/* 0x1a10 */  64, 40,171,127,152,252,158, 65,  0,  0, 75,137, 46, 64,  0, 84,
/* 0x1a20 */  40, 64,209,123,  1,  0,107, 57,120,  3, 74,125, 32,  0, 74,121,
/* 0x1a30 */  46,130,251,125,254,170, 32, 86,214,121,  0,124, 64,  0,138,127,
/* 0x1a40 */  32,  0, 30,120,208,  0,156, 64,  0,  8,143, 35, 64,200,128,127,
/* 0x1a50 */ 112, 46,156,127, 20,122,252,125,224,  1,189, 59, 46,131,251,125,
/* 0x1a60 */  36,  0,157, 65, 64, 40,171,127, 68,252,158, 65, 40, 64, 30,120,
/* 0x1a70 */   0,  0, 11,136, 46, 64, 74, 85,  1,  0,107, 57,120, 83, 10,124,
/* 0x1a80 */  32,  0, 74,121, 46,234, 59,126,254,170,220, 87,214,137,156,127,
/* 0x1a90 */  64,224,138,127, 32,  0,128,123, 80,  0,156, 64,  0,  8,241, 35,
/* 0x1aa0 */   0,  0,186, 47,112, 46,255,127, 20,138, 63,126, 46,235, 59,126,
/* 0x1ab0 */ 252,251,158, 65,  7,  0,140, 47, 80,208,242,127, 38, 16,144,125,
/* 0x1ac0 */ 254,239,140, 85, 32,  0,255,123,208,  0,140,125,174,248,199,127,
/* 0x1ad0 */ 164,  7,140,121,  1,  0,250, 59, 11,  0,140, 57, 32,  0,255,123,
/* 0x1ae0 */ 174,209,199,127,240,  5,  0, 72,126,217, 32, 86, 80,136,  0,124,
/* 0x1af0 */  80,240,220,127, 80, 80, 92,125, 46,235, 27,124, 32,  0,222,123,
/* 0x1b00 */ 120,195,  0,127, 32,  0, 74,121,120,147, 88,126,120,187,242,126,
/* 0x1b10 */ 124,  0,  0, 72, 80,136, 32,126,126,217,254, 85, 80, 80,  0,124,
/* 0x1b20 */  80,120,254,125, 64,200,145,127, 46,131,251,125, 32,  0, 61,122,
/* 0x1b30 */  32,  0, 10,120, 48,  0, 28, 58, 36,  0,157, 65, 64, 40,171,127,
/* 0x1b40 */ 108,251,158, 65,  0,  0, 75,137, 46, 64,  0, 84, 40, 64, 61,122,
/* 0x1b50 */   1,  0,107, 57,120,  3, 74,125, 32,  0, 74,121, 46,130, 59,126,
/* 0x1b60 */ 254,170,160, 87,214,137,  0,124, 64,  0,138,127, 32,  0, 30,120,
/* 0x1b70 */  36,  0,156, 64,  0,  8, 17, 32,112, 46,  0,124, 20,138, 32,126,
/* 0x1b80 */ 120,195,  0,127, 46,131, 59,126,120,187,248,126,120,  3, 23,124,
/* 0x1b90 */ 160,  0,  0, 72, 80,232,160,127,126,217, 62, 86, 80, 80,  0,124,
/* 0x1ba0 */  80,136, 62,126, 64,200,157,127, 32,  0,175,123, 46,131, 59,126,
/* 0x1bb0 */  32,  0, 10,120, 72,  0,156, 59, 36,  0,157, 65, 64, 40,171,127,
/* 0x1bc0 */ 236,250,158, 65,  0,  0, 75,137, 46, 64,  0, 84, 40, 64,175,123,
/* 0x1bd0 */   1,  0,107, 57,120,  3, 74,125, 32,  0, 74,121, 46,226,187,127,
/* 0x1be0 */ 254,170,224, 85,214,233,  0,124, 64,  0,138,127, 32,  0, 30,120,
/* 0x1bf0 */  24,  0,156, 64,  0,  8, 29, 32,112, 46,  0,124, 20,234,  0,124,
/* 0x1c00 */  46,227, 27,124, 44,  0,  0, 72, 80,120,192,127, 80, 80, 64,125,
/* 0x1c10 */ 126,217,160, 87, 80,232,  0,124, 32,  0, 74,121, 46,227, 27,124,
/* 0x1c20 */ 120,195,  0,127, 32,  0,222,123,120,179,216,126,120,  3, 22,124,
/* 0x1c30 */   7,  0,140, 47,120,147, 64,126, 38, 16,144,125,254,239,140, 85,
/* 0x1c40 */ 120,195, 18,127,108, 10,163, 59,120,187,248,126,120,  3, 23,124,
/* 0x1c50 */ 208,  0,140,125, 66,240,140,121,  0, 16,140,121, 11,  0,140, 57,
/* 0x1c60 */  64,200,158,127, 36,  0,157, 65, 64, 40,171,127, 64,250,158, 65,
/* 0x1c70 */   0,  0, 11,136, 46, 64, 74, 85, 40, 64,222,123,  1,  0,107, 57,
/* 0x1c80 */ 120, 83, 10,124, 32,  0, 74,121,  0,  0,253,161,254,170,220, 87,
/* 0x1c90 */ 214,121,156,127, 64,224,138,127, 32,  0,128,123, 48,  0,156, 64,
/* 0x1ca0 */  56, 24,255, 87,  0,  8, 47, 34,180,  7,255,127,112, 46, 49,126,
/* 0x1cb0 */   2,  0,255, 59, 20,122, 49,126,164, 15,255,123,  0,  0, 61,178,
/* 0x1cc0 */   0,  0,  0, 58, 20,250,189,127,136,  0,  0, 72, 80,240,220,127,
/* 0x1cd0 */ 126,217,241, 85, 80, 80,156,127, 80,120, 49,126, 64,200,158,127,
/* 0x1ce0 */  32,  0,208,123,  0,  0, 61,178, 32,  0,138,123, 36,  0,157, 65,
/* 0x1cf0 */  64, 40,171,127,184,249,158, 65,  0,  0, 75,137, 46, 64,156, 87,
/* 0x1d00 */  40, 64,208,123,  1,  0,107, 57,120,227, 74,125, 32,  0, 74,121,
/* 0x1d10 */   2,  0,157,163,254,170, 30, 86,214,225,222,127, 64,240,138,127,
/* 0x1d20 */  32,  0,192,123, 52,  0,156, 64, 56, 24,255, 87,  0,  8,220, 35,
/* 0x1d30 */ 180,  7,255,127,112, 46,222,127,130,  0,255, 59, 20,226,158,127,
/* 0x1d40 */ 164, 15,255,123,  2,  0,157,179,  8,  0,  0, 58, 20,250,189,127,
/* 0x1d50 */   3,  0, 32, 58, 44,  0,  0, 72,126,217,159, 87, 80,128, 30,124,
/* 0x1d60 */  80, 80, 94,125, 80,224,255,127, 32,  0, 74,121,  2,  0,253,179,
/* 0x1d70 */  32,  0,  0,120,  4,  2,189, 59, 16,  0,  0, 58,  8,  0, 32, 58,
/* 0x1d80 */ 255,255,241, 59,  1,  0,192, 59, 32,  0,255,123,  1,  0,255, 59,
/* 0x1d90 */ 166,  3,233,127,164, 15,220,123, 64,200,128,127, 20,226,157,127,
/* 0x1da0 */  36,  0,157, 65, 64, 40,171,127,  4,249,158, 65,  0,  0,235,139,
/* 0x1db0 */  46, 64, 74, 85, 40, 64,  0,120,  1,  0,107, 57,120, 83,234,127,
/* 0x1dc0 */  32,  0, 74,121,  0,  0,252,161,254,170, 31, 84, 60,  8,222, 87,
/* 0x1dd0 */ 214,121,255,127, 64,248,138,127, 32,  0,238,123, 32,  0,156, 64,
/* 0x1de0 */   0,  8, 15, 32,180,  7,222,127,112, 46,  0,124, 20,122,224,125,
/* 0x1df0 */ 120,115,192,125,  0,  0,252,177, 40,  0,  0, 72, 80,  0, 31,124,
/* 0x1e00 */  80, 80, 95,125,126,217,255, 85, 80,120,255,125,  1,  0,222, 59,
/* 0x1e10 */   0,  0,252,177, 32,  0,  0,120, 32,  0, 74,121,180,  7,222,127,
/* 0x1e20 */ 116,255,  0, 66, 48,136,145,126,  3,  0,140, 47, 80,128, 49,126,
/* 0x1e30 */  20,242,145,127, 80,  2,157, 65,  3,  0,156, 47,120,227,158,127,
/* 0x1e40 */   8,  0,157, 64,  3,  0,192, 59, 50, 48,222, 87,180,  7,222,127,
/* 0x1e50 */   6,  0,160, 59,176,  1,222, 59,166,  3,169,127,164, 15,222,123,
/* 0x1e60 */   1,  0,224, 59,164, 15,241,123, 64,200,128,127, 20,242, 49,126,
/* 0x1e70 */  36,  0,157, 65, 64, 40,171,127, 52,248,158, 65,  0,  0,171,139,
/* 0x1e80 */  46, 64, 74, 85, 40, 64,  0,120,  1,  0,107, 57,120, 83,170,127,
/* 0x1e90 */  32,  0, 74,121, 46,138, 91,126,254,170, 29, 84, 60,  8,255, 87,
/* 0x1ea0 */ 214,145,189,127, 64,232,138,127, 32,  0,176,123, 32,  0,156, 64,
/* 0x1eb0 */   0,  8, 18, 32,180,  7,255,127,112, 46,  0,124, 20,146, 64,126,
/* 0x1ec0 */ 120,131,  0,126, 46,139, 91,126, 40,  0,  0, 72, 80,  0, 29,124,
/* 0x1ed0 */  80, 80, 93,125,126,217, 93, 86, 80,144, 93,126,  1,  0,255, 59,
/* 0x1ee0 */  46,139, 91,126, 32,  0,  0,120, 32,  0, 74,121,180,  7,255,127,
/* 0x1ef0 */ 116,255,  0, 66,192,255,255, 59,  3,  0,159, 47,180,  7,242,127,
/* 0x1f00 */ 108,  1,157, 64,254,  7,241, 87, 13,  0,159, 47,  2,  0, 49, 98,
/* 0x1f10 */ 112, 14,254,127, 32,  0, 61,122, 40,  0,157, 65,255,255,254, 59,
/* 0x1f20 */ 176,  2,210, 35,180,  7,253,127, 48,248, 63,126, 20,250,222,127,
/* 0x1f30 */ 164, 15,222,123,254,255,222, 59, 20,242,219,127,116,  0,  0, 72,
/* 0x1f40 */ 250,255,222, 59, 32,  0,222,123,  1,  0,222, 59,166,  3,201,127,
/* 0x1f50 */  64,200,128,127, 36,  0,157, 65, 64, 40,171,127, 80,247,158, 65,
/* 0x1f60 */   0,  0,235,139, 46, 64, 74, 85, 40, 64,  0,120,  1,  0,107, 57,
/* 0x1f70 */ 120, 83,234,127, 32,  0, 74,121,126,248, 30, 84, 60,  8,191, 87,
/* 0x1f80 */  64,240,138,127, 32,  0,192,123, 32,  0,253,123, 20,  0,156, 65,
/* 0x1f90 */  80, 80, 94,125,  1,  0,255, 99, 32,  0, 74,121, 32,  0,253,123,
/* 0x1fa0 */ 176,255,  0, 66, 40, 32,191,123, 72,  6,195, 59,  4,  0,160, 59,
/* 0x1fb0 */ 255,255,189, 59,  1,  0, 64, 58, 32,  0,189,123,  1,  0, 32, 58,
/* 0x1fc0 */   1,  0,189, 59,166,  3,169,127,164, 15, 80,122, 64,200,128,127,
/* 0x1fd0 */  20,130, 30,126, 36,  0,157, 65, 64, 40,171,127,208,246,158, 65,
/* 0x1fe0 */   0,  0,171,139, 46, 64, 74, 85, 40, 64,  0,120,  1,  0,107, 57,
/* 0x1ff0 */ 120, 83,170,127, 32,  0, 74,121,  0,  0,240,161,254,170, 29, 84,
/* 0x2000 */  60,  8, 82, 86,214,121,189,127, 64,232,138,127, 32,  0,174,123,
/* 0x2010 */  32,  0,156, 64,  0,  8, 15, 32,180,  7, 82,126,112, 46,  0,124,
/* 0x2020 */  20,122,224,125,120,115,192,125,  0,  0,240,177, 48,  0,  0, 72,
/* 0x2030 */  80,  0, 29,124, 80, 80, 93,125,126,217,253, 85, 80,120,253,125,
/* 0x2040 */   1,  0, 82, 58,  0,  0,240,177,120,251, 63,126, 32,  0,  0,120,
/* 0x2050 */  32,  0, 74,121,180,  7, 82,126, 32,  0,255,123, 60,  8, 49, 86,
/* 0x2060 */ 180,  7, 49,126,100,255,  0, 66,  8,  0,  0, 72, 32,  0,255,123,
/* 0x2070 */   1,  0,255, 59, 33,  0,242,123,100,  0,130, 65,  7,  0,140, 57,
/* 0x2080 */ 180,  7,140,125,  2,  0,220, 59, 64,208,146,127,180,  7,222,127,
/* 0x2090 */  28,246,157, 65,255,255,222, 59, 32,  0,222,123,  1,  0,222, 59,
/* 0x20a0 */ 166,  3,201,127, 80,208,242,127,  1,  0,186, 59, 32,  0,255,123,
/* 0x20b0 */ 174,248,199,127, 32,  0,191,123,174,209,199,127, 24,  0, 64, 66,
/* 0x20c0 */  64, 64,157,127,120,251,250,127,220,255,156, 65,  8,  0,  0, 72,
/* 0x20d0 */   0,  0,128, 57,120,251,250,127, 40,246,255, 75,255,  0, 64, 61,
/* 0x20e0 */ 255,255, 74, 97, 64, 80,128,127, 16,  0,157, 65, 64, 40,171,127,
/* 0x20f0 */ 188,245,158, 65,  1,  0,107, 57, 80, 88,132,124,  0,  0, 96, 56,
/* 0x2100 */   0,  0,134,144,  0,  0, 73,147,  0,  0,  0, 72,112,255,193,249,
/* 0x2110 */ 120,255,225,249,128,255,  1,250,136,255, 33,250,144,255, 65,250,
/* 0x2120 */ 152,255, 97,250,160,255,129,250,168,255,161,250,176,255,193,250,
/* 0x2130 */ 184,255,225,250,192,255,  1,251,200,255, 33,251,208,255, 65,251,
/* 0x2140 */ 216,255, 97,251,224,255,129,251,232,255,161,251,240,255,193,251,
/* 0x2150 */ 248,255,225,251, 16,  0,  1,248, 32,  0,128, 78,112,255,193,233,
/* 0x2160 */ 120,255,225,233,128,255,  1,234,136,255, 33,234,144,255, 65,234,
/* 0x2170 */ 152,255, 97,234,160,255,129,234,168,255,161,234,176,255,193,234,
/* 0x2180 */ 184,255,225,234,192,255,  1,235,200,255, 33,235,208,255, 65,235,
/* 0x2190 */ 216,255, 97,235,224,255,129,235, 16,  0,  1,232,232,255,161,235,
/* 0x21a0 */ 166,  3,  8,124,240,255,193,235,248,255,225,235, 32,  0,128, 78,
/* 0x21b0 */   0,  0,  0,  0,  0,  0,  0,  1,120,255,225,249,112,255,193,249,
/* 0x21c0 */   0,  0,  0, 56,  1,  0, 96, 57,152,255, 97,250,144,255, 65,250,
/* 0x21d0 */   4,  0, 99, 58,248,255,225,251,240,255,193,251,  2,  0,227, 59,
/* 0x21e0 */ 128,255,  1,250,136,255, 33,250,160,255,129,250,168,255,161,250,
/* 0x21f0 */ 176,255,193,250,184,255,225,250,192,255,  1,251,200,255, 33,251,
/* 0x2200 */ 208,255, 65,251,216,255, 97,251,224,255,129,251,232,255,161,251,
/* 0x2210 */   0,  0, 67,137,  1,  0, 67,138,  2,  0, 35,138,  0,  0,  6,144,
/* 0x2220 */   0,  0,  9,144,180,  7, 79,125, 48,136,113,125, 48,144,107,125,
/* 0x2230 */ 255,255, 49, 58,255,255,107, 57, 32,  0, 49,122, 32,  0,114,121,
/* 0x2240 */   1,  0, 99,137, 20, 82,107,125,  0,  3, 64, 57, 48, 88, 74,125,
/* 0x2250 */  54,  7, 74, 57, 33,  0, 75,121, 40,  0,130, 65,255,255, 75, 57,
/* 0x2260 */   0,  4, 96, 57, 32,  0, 74,121,  1,  0, 74, 57,166,  3, 73,125,
/* 0x2270 */   0,  0,  0, 96,  0,  0,  0, 96,  2,  0,127,181,252,255,  0, 66,
/* 0x2280 */  20, 42,164,124, 64, 40,164,127,240,  2,158, 65,  4,  0,224, 59,
/* 0x2290 */   0,  0, 68,137,  1,  0,100, 57,166,  3,233,127,  5,  0,132, 57,
/* 0x22a0 */  64, 40,171,127, 46, 64, 74, 85,  1,  0,107, 57,204,  2,158, 65,
/* 0x22b0 */ 255,255, 11,136,120, 83, 10,124, 32,  0, 74,121,228,255,  0, 66,
/* 0x22c0 */   0,  0,168, 47, 80, 11,158, 65,  1,  0,  0, 56,  1,  0, 96, 57,
/* 0x22d0 */  96,255,  1,248, 88,255, 97,249,  8,  0, 15, 32,255,255,224, 59,
/* 0x22e0 */  84,255,  1,144,255,  0, 32, 63, 32,  0,255,123,  1,  0,192, 57,
/* 0x22f0 */   1,  0,  0, 58,  0,  0,160, 58,  0,  0, 96, 57,  0,  0,192, 58,
/* 0x2300 */ 255,255, 57, 99, 56,136,221,126, 54, 32,160, 86,180,  7,190,127,
/* 0x2310 */ 180,  7,  0,124, 20,  2,222,127, 64,200,159,127,164, 15,222,123,
/* 0x2320 */  36,  0,157, 65, 64, 40,172,127, 80,  2,158, 65,  0,  0, 12,136,
/* 0x2330 */  46, 64, 74, 85, 40, 64,255,123,  1,  0,140, 57,120, 83, 10,124,
/* 0x2340 */  32,  0, 74,121, 46,242,147,127,254,170,251, 87,214,225,123,127,
/* 0x2350 */  64,216,138,127, 32,  0, 96,123,112,  2,156, 64, 84,255,225,131,
/* 0x2360 */  56,144,221,126,  6,  0,149, 47, 48,120,189,127, 48,254,107,125,
/* 0x2370 */   0,  8,252, 35,112, 46,255,127, 20,226,255,127, 20,234,107,125,
/* 0x2380 */  46,243,243,127, 46, 64,125, 85, 42, 80,107, 85, 80, 88,189,127,
/* 0x2390 */   1,  0, 96, 57, 32,  0,189,123, 54,  7,189, 59,164, 15,189,123,
/* 0x23a0 */  20,234,179,127, 40,  1,157, 64, 80,176,240,127,  1,  0, 96, 57,
/* 0x23b0 */  32,  0,255,123,174,248, 71,127, 40,  0,  0, 72,  0,  0,  0, 96,
/* 0x23c0 */   0,  0,  0, 96,  0,  0,  0, 96, 46,243,125,127,180,  7,107,125,
/* 0x23d0 */ 120,251,224,127,172,  0,130, 64,255,  0,139, 47,172,  0,157, 65,
/* 0x23e0 */  60,  8, 90, 87,238,  5, 95, 87, 60,  8,120, 85,180,  7,255,127,
/* 0x23f0 */   0,  1,223, 59,  0,  0, 63, 44, 20, 90,222,127, 64,200,  0,127,
/* 0x2400 */   0,  0,128, 79,120,195, 11,127, 64, 40,172,124,  1,  0, 24, 59,
/* 0x2410 */  46, 64, 95, 85,164, 15,222,123,180,  7, 90,127, 28,  0,153, 65,
/* 0x2420 */  88,  1,134, 65,  0,  0, 76,137, 40, 64,  0,120,  1,  0,140, 57,
/* 0x2430 */ 120,251, 74,125, 32,  0, 74,121, 46,242,157,127,254,170, 27, 84,
/* 0x2440 */ 214,225,251,127,  0,  8,124, 35,126,217,151, 87,112, 46,123,127,
/* 0x2450 */  64,248, 10,127, 20,226,123,127, 80,  0, 31,124, 80, 80,159,126,
/* 0x2460 */  80,224,151,127, 32,  0,255,123, 96,255,152, 65, 46,243,157,127,
/* 0x2470 */ 180,  7, 11,127, 32,  0,  0,120, 32,  0,138,122, 92,255,158, 64,
/* 0x2480 */ 255,  0,139, 47, 72,  0,253, 64, 32,  6,107,121,  1,  0,214, 59,
/* 0x2490 */ 174,177,103,125,120,  3, 31,124, 32,  0,214,123,  9,  0,149, 47,
/* 0x24a0 */ 104,  8,157, 65,253,255,181, 58,180,  7,181,126, 84,  6,  0, 72,
/* 0x24b0 */   0,  0,  0, 96,  0,  0,  0, 96,180,  7,107,127,255,  0,139, 47,
/* 0x24c0 */  46,227,221,127,120,211, 64,127,136,  0,157, 65, 60,  8,123, 85,
/* 0x24d0 */  64,200,128,127, 64, 40, 44,127,120,219,120,127, 46, 64, 95, 85,
/* 0x24e0 */ 164, 15,124,121, 28,  0,157, 65,144,  0,154, 65,  0,  0, 76,137,
/* 0x24f0 */  40, 64,  0,120,  1,  0,140, 57,120,251, 74,125, 32,  0, 74,121,
/* 0x2500 */  46,226, 93,127,254,170, 31, 84,  1,  0,120, 57,214,209,255,127,
/* 0x2510 */   0,  8,218, 35,126,217, 88, 87,112, 46,222,127, 64,248,138,127,
/* 0x2520 */  80,208, 24,127, 20,210,222,127, 32,  0,250,123,140,255,156, 65,
/* 0x2530 */ 180,  7,107,125, 80,  0, 31,124, 80, 80, 95,125, 46,227, 29,127,
/* 0x2540 */ 255,  0,139, 47, 32,  0,  0,120, 32,  0, 74,121,128,255,157, 64,
/* 0x2550 */   1,  0,214, 59, 32,  6,107,121, 32,  0,222,123,  3,  0,149, 47,
/* 0x2560 */ 174,177,103,125,120,  3, 31,124,120,243,214,127, 48,255,157, 65,
/* 0x2570 */   0,  0,160, 58,140,  5,  0, 72,  1,  0, 96, 56,112,255,193,233,
/* 0x2580 */ 120,255,225,233,128,255,  1,234,136,255, 33,234,144,255, 65,234,
/* 0x2590 */ 152,255, 97,234,160,255,129,234,168,255,161,234,176,255,193,234,
/* 0x25a0 */ 184,255,225,234,192,255,  1,235,200,255, 33,235,208,255, 65,235,
/* 0x25b0 */ 216,255, 97,235,224,255,129,235,232,255,161,235,240,255,193,235,
/* 0x25c0 */ 248,255,225,235, 32,  0,128, 78, 80,248, 27,124,126,217,159, 87,
/* 0x25d0 */  80, 80,123,127, 80,224,255,127,192,  0,117, 57, 64,200,128,127,
/* 0x25e0 */  46,243,243,127, 32,  0, 26,120, 32,  0,106,123,164, 15,107,121,
/* 0x25f0 */  36,  0,157, 65, 64, 40,172,127,128,255,158, 65,  0,  0, 76,137,
/* 0x2600 */  46, 64,123, 87, 40, 64, 26,120,  1,  0,140, 57,120,219, 74,125,
/* 0x2610 */  32,  0, 74,121, 46, 90,115,127,254,170, 64, 87,214,217,  0,124,
/* 0x2620 */  64,  0,138,127, 32,  0, 28,120, 16,  3,156, 64,  0,  8, 27, 32,
/* 0x2630 */ 104,255,  1,250,  7,  0,149, 47,112, 46,  0,124, 20,218, 96,127,
/* 0x2640 */ 104,  6,  3, 59, 46, 91,115,127, 38, 16,176,126,254,239,181, 86,
/* 0x2650 */ 208,  0,181,126, 66,240,181,122,  0, 16,181,122,  3,  0,181, 58,
/* 0x2660 */  64,200,156,127, 36,  0,157, 65, 64, 40,172,127, 12,255,158, 65,
/* 0x2670 */   0,  0,108,137, 46, 64, 74, 85, 40, 64,156,123,  1,  0,140, 57,
/* 0x2680 */ 120, 83,106,125, 32,  0, 74,121,  0,  0, 24,160,254,170,139, 87,
/* 0x2690 */ 214,  1,107,125, 64, 88,138,127, 32,  0,127,121,156,  4,156, 64,
/* 0x26a0 */  56, 24,171, 87,  0,  8,192, 35,180,  7,107,125,112, 46,222,127,
/* 0x26b0 */   2,  0,107, 57, 20,  2, 30,124,164, 15,107,121,  0,  0, 24,176,
/* 0x26c0 */   0,  0,128, 58, 20, 90, 24,127,  3,  0,224, 58,255,255,119, 57,
/* 0x26d0 */   1,  0,  0, 56, 32,  0,107,121,  1,  0,107, 57,166,  3,105,125,
/* 0x26e0 */   0,  0,  0, 96,  0,  0,  0, 96,164, 15, 28,120, 60,  8, 26, 84,
/* 0x26f0 */  64,200,159,127, 64, 40, 44,127,120,211, 93,127, 46, 64, 75, 85,
/* 0x2700 */  20,226,152,127, 28,  0,157, 65,112,254,154, 65,  0,  0, 76,137,
/* 0x2710 */  40, 64,255,123,  1,  0,140, 57,120, 91, 74,125, 32,  0, 74,121,
/* 0x2720 */   0,  0,220,163,254,170,235, 87,  1,  0, 29, 56,214,241,107,125,
/* 0x2730 */   0,  8,190, 35,126,217,219, 87,112, 46,189,127, 64, 88,138,127,
/* 0x2740 */  80,240,123,127, 20,242,221,127, 32,  0,125,121,236,  2,156, 64,
/* 0x2750 */ 180,  7, 64,127,  0,  0,220,179,120,235,191,127,140,255,  0, 66,
/* 0x2760 */   1,  0, 96, 57,  3,  0,149, 47, 48,184,119,125, 80,160,247,126,
/* 0x2770 */  20,  2,247,126, 80,255,225,146, 24,  3,157, 65,  3,  0,151, 47,
/* 0x2780 */  32,  0,235,122,148,  5,157, 65, 50, 48,120, 85,180,  7, 24,127,
/* 0x2790 */   6,  0,  0, 56,176,  1, 24, 59,166,  3,  9,124,164, 15, 24,123,
/* 0x27a0 */   1,  0, 96, 57,  0,  0,  0, 96,164, 15,124,121, 60,  8,119, 85,
/* 0x27b0 */  64,200,159,127, 64, 40, 44,127,120,187,235,126, 46, 64, 64, 85,
/* 0x27c0 */  20,194,156,127, 28,  0,157, 65,176,253,154, 65,  0,  0, 76,137,
/* 0x27d0 */  40, 64,255,123,  1,  0,140, 57,120,  3, 74,125, 32,  0, 74,121,
/* 0x27e0 */  46,226,211,127,254,170,224, 87,  1,  0,107, 57,214,241,  0,124,
/* 0x27f0 */   0,  8,190, 35,126,217,219, 87,112, 46,189,127, 64,  0,138,127,
/* 0x2800 */  80,240,123,127, 20,242,221,127, 32,  0, 29,120, 76,  2,156, 64,
/* 0x2810 */ 180,  7,235,126, 46,227,211,127,120,235,191,127,140,255,  0, 66,
/* 0x2820 */ 192,255,107, 57,  3,  0,139, 47,180,  7,126,125, 76,  2,157, 64,
/* 0x2830 */ 254,  7,122, 85, 13,  0,139, 47,  2,  0, 90, 99,112, 14,107,125,
/* 0x2840 */  32,  0, 64,123, 48,  5,157, 65,255,255,107, 57,176,  2, 30, 34,
/* 0x2850 */  48, 88, 90,127,180,  7,107,125, 20,210, 16,126,164, 15, 16,122,
/* 0x2860 */ 254,255, 16, 58, 20,130, 19,126,255,255,107, 57,  1,  0,192, 59,
/* 0x2870 */  32,  0,107,121,  1,  0,128, 59,  1,  0,107, 57,166,  3,105,125,
/* 0x2880 */  32,  0,  0, 72,  0,  0,  0, 96,  0,  0, 27,176,180,  7,254,126,
/* 0x2890 */ 120,235,191,127, 60,  8,156, 87,180,  7,156,127,224,  1, 64, 66,
/* 0x28a0 */ 164, 15,219,123, 60,  8,215, 87, 64,200,159,127, 64, 40, 44,127,
/* 0x28b0 */ 120,187,254,126, 46, 64, 75, 85, 20,218,112,127, 28,  0,157, 65,
/* 0x28c0 */ 184,252,154, 65,  0,  0, 76,137, 40, 64,255,123,  1,  0,140, 57,
/* 0x28d0 */ 120, 91, 74,125, 32,  0, 74,121,  0,  0, 27,160,254,170,235, 87,
/* 0x28e0 */ 120,211,148,127,214,  1,107,125,  0,  8,160, 35,126,217, 24, 84,
/* 0x28f0 */ 112, 46,189,127, 64, 88,138,127, 80,  0, 24,127, 20,  2, 29,124,
/* 0x2900 */  32,  0,125,121,132,255,156, 65, 80,248,235,127, 80, 80, 75,125,
/* 0x2910 */   0,  0, 27,179,  1,  0,222, 59, 32,  0,255,123, 32,  0, 74,121,
/* 0x2920 */ 180,  7,222,127, 32,  0,154,122,108,255,255, 75,  0,  0,  0, 96,
/* 0x2930 */   0,  0,  0, 96,  0,  0,  0, 96, 80,208,224,127,126,217,124, 87,
/* 0x2940 */  80,216,124,127, 80, 80,  0,124, 64,200,159,127, 32,  0,250,123,
/* 0x2950 */  46, 91,115,127, 32,  0, 10,120, 24,  0,139, 59, 36,  0,157, 65,
/* 0x2960 */  64, 40,172,127, 20,252,158, 65,  0,  0, 76,137, 46, 64,  0, 84,
/* 0x2970 */  40, 64,250,123,  1,  0,140, 57,120,  3, 74,125, 32,  0, 74,121,
/* 0x2980 */  46,226,243,127,254,170, 64, 87,214,249,  0,124, 64,  0,138,127,
/* 0x2990 */  32,  0, 27,120, 52,  2,156, 64,  0,  8,127, 33, 64,200,128,127,
/* 0x29a0 */ 112, 46,107,125, 20,250,235,127,224,  1,222, 59, 46,227,243,127,
/* 0x29b0 */  36,  0,157, 65, 64, 40,172,127,192,251,158, 65,  0,  0,108,137,
/* 0x29c0 */  46, 64, 74, 85, 40, 64, 27,120,  1,  0,140, 57,120, 83,106,125,
/* 0x29d0 */  32,  0, 74,121, 46,242, 19,124,254,170,107, 87,214,  1,107,125,
/* 0x29e0 */  64, 88,138,127, 32,  0,127,121, 56,  3,156, 64,  0,  8, 96, 33,
/* 0x29f0 */   0,  0,182, 47,112, 46,107,125, 20,  2, 11,124, 46,243, 19,124,
/* 0x2a00 */ 120,251,158, 65,  7,  0,149, 47, 80,176,112,125, 38, 16,176,126,
/* 0x2a10 */ 254,239,181, 86, 32,  0,107,121,  1,  0, 22, 56,208,  0,181,126,
/* 0x2a20 */ 164,  7,181,122,174, 88,103,125,174,177,103,125, 11,  0,181, 58,
/* 0x2a30 */  32,  0, 22,120,204,  0,  0, 72, 80,248,235,127, 80, 80, 75,125,
/* 0x2a40 */   0,  0,124,179, 32,  0,255,123, 32,  0, 74,121,180,  7,  0,124,
/* 0x2a50 */ 152,252,  0, 66, 12,253,255, 75, 80,248,224,127, 80, 80, 64,125,
/* 0x2a60 */  46,227,115,127, 32,  0,255,123, 32,  0, 74,121,180,  7,107,125,
/* 0x2a70 */  56,253,  0, 66,172,253,255, 75, 32,  0,122,121,  1,  0, 90, 59,
/* 0x2a80 */  33,  0, 80,123,132,  0,130, 65,  7,  0,181, 58,180,  7,181,126,
/* 0x2a90 */  64,176,144,127,228,250,157, 65, 80,255,  1,128,  1,  0,182, 59,
/* 0x2aa0 */  80,176,208,127, 32,  0,222,123,120,179,220,126, 20,  2,125,125,
/* 0x2ab0 */  80, 88,112,125, 80, 88,126,125, 32,  0,107,121,  1,  0,107, 57,
/* 0x2ac0 */ 166,  3,105,125, 20,  0,  0, 72,120,179,220,126, 32,  0,222,123,
/* 0x2ad0 */  56,  0,157, 64,  1,  0,182, 59,174,240,103,125, 64,232,136,127,
/* 0x2ae0 */   1,  0,222, 59, 32,  0,182,123,174,225,103,125,220,255,  0, 66,
/* 0x2af0 */ 104,255,  1,232, 96,255,193,249, 88,255,193,233, 88,255,  1,248,
/* 0x2b00 */  64,176,136,127,  0,248,253, 65,255,  0, 64, 61,255,255, 74, 97,
/* 0x2b10 */  64, 80,159,127, 16,  0,157, 65, 64, 40,172,127, 92,250,158, 65,
/* 0x2b20 */   1,  0,140, 57, 80, 96,132,124,  0,  0, 96, 56,  0,  0,134,144,
/* 0x2b30 */   0,  0,201,146, 72,250,255, 75, 80,224,139,127,126,217, 31, 84,
/* 0x2b40 */  80, 80,107,125, 80,  0, 31,124, 64,200,156,127, 32,  0,158,123,
/* 0x2b50 */   0,  0, 24,176, 32,  0,106,121, 36,  0,157, 65, 64, 40,172,127,
/* 0x2b60 */  24,250,158, 65,  0,  0, 76,137, 46, 64,107, 85, 40, 64,158,123,
/* 0x2b70 */   1,  0,140, 57,120, 91, 74,125, 32,  0, 74,121,  2,  0, 24,160,
/* 0x2b80 */ 254,170,203, 87,214,  1,107,125, 64, 88,138,127, 32,  0,127,121,
/* 0x2b90 */  72,  1,156, 64, 56, 24,171, 87,  0,  8,192, 35,180,  7,107,125,
/* 0x2ba0 */ 112, 46,222,127,130,  0,107, 57, 20,  2, 30,124,164, 15,107,121,
/* 0x2bb0 */   2,  0, 24,176,  8,  0,128, 58, 20, 90, 24,127,  3,  0,224, 58,
/* 0x2bc0 */  12,251,255, 75,  0,  0,  0, 96, 80,208, 64,127,126,217,251, 87,
/* 0x2bd0 */  80, 80,192,127, 80,248,251,127, 64,200,154,127, 46,227,243,127,
/* 0x2be0 */  32,  0, 64,123, 32,  0,202,123, 48,  0,235, 59, 36,  0,157, 65,
/* 0x2bf0 */  64, 40,172,127,132,249,158, 65,  0,  0, 76,137, 46, 64,192, 87,
/* 0x2c00 */   1,  0,140, 57,120,  3, 74,125, 40, 64, 64,123, 32,  0, 74,121,
/* 0x2c10 */  46,250,115,127,254,170, 30, 84,214,217,222,127, 64,240,138,127,
/* 0x2c20 */  32,  0,220,123, 44,  1,156, 65, 80,  0, 30,124,126,217,124, 87,
/* 0x2c30 */  80, 80,222,127, 80,216,156,127, 64,200,128,127, 32,  0, 26,120,
/* 0x2c40 */  46,251,147,127, 32,  0,202,123, 72,  0,107, 57, 36,  0,157, 65,
/* 0x2c50 */  64, 40,172,127, 36,249,158, 65,  0,  0, 76,137, 46, 64,222, 87,
/* 0x2c60 */  40, 64, 26,120,  1,  0,140, 57,120,243, 74,125, 32,  0, 74,121,
/* 0x2c70 */  46, 90,243,127,254,170, 64, 87,214,249,  0,124, 64,  0,138,127,
/* 0x2c80 */  32,  0, 28,120,104,  1,156, 64,  0,  8, 31, 32,104,255,  1,250,
/* 0x2c90 */ 120,115,208,125, 96,255,193,233,112, 46,  0,124, 20,250,224,127,
/* 0x2ca0 */  46, 91,243,127,  0,  0,  0, 96,  7,  0,149, 47,108, 10,  3, 59,
/* 0x2cb0 */  38, 16,176,126,254,239,181, 86,208,  0,181,126, 66,240,181,122,
/* 0x2cc0 */   0, 16,181,122, 11,  0,181, 58,152,249,255, 75,  0,  0,  0, 96,
/* 0x2cd0 */   0,  0,  0, 96,  0,  0,  0, 96,126,217, 31, 84, 80,  0, 31,124,
/* 0x2ce0 */  80, 80, 75,125, 80,240,235,127,  2,  0, 24,176, 32,  0, 74,121,
/* 0x2cf0 */   4,  2, 24, 59, 32,  0,255,123, 16,  0,128, 58,  8,  0,224, 58,
/* 0x2d00 */ 204,249,255, 75,  0,  0,  0, 96,250,255,181, 58,180,  7,181,126,
/* 0x2d10 */ 240,253,255, 75,  0,  0,  0, 96,  3,  0, 96, 57,108,250,255, 75,
/* 0x2d20 */ 126,217, 31, 84, 80,216,139,127, 80, 80, 75,125, 88,255, 97,233,
/* 0x2d30 */  88,255,193,249, 80,  0, 31,124,104,255, 97,249, 32,  0,156,123,
/* 0x2d40 */  96,255,193,233, 32,  0, 74,121, 46,243, 19,124, 92,255,255, 75,
/* 0x2d50 */   0,  8,123, 33,104,255,  1,250, 88,255,  1,234,112, 46,107,125,
/* 0x2d60 */  20,218,107,127, 88,255,193,249, 96,255,193,233, 46,251,115,127,
/* 0x2d70 */  56,255,255, 75,250,255,107, 57, 32,  0,107,121,  1,  0,107, 57,
/* 0x2d80 */ 166,  3,105,125,  0,  0,  0, 96, 64,200,159,127, 60,  8, 26, 84,
/* 0x2d90 */  64, 40, 44,127, 46, 64, 75, 85, 28,  0,157, 65,220,247,154, 65,
/* 0x2da0 */   0,  0, 76,137, 40, 64,255,123,  1,  0,140, 57,120, 91, 74,125,
/* 0x2db0 */  32,  0, 74,121,126,248,235, 87, 64, 88,138,127, 32,  0, 64,123,
/* 0x2dc0 */  32,  0,127,121, 20,  0,156, 65, 80, 80, 75,125,  1,  0, 90, 99,
/* 0x2dd0 */  32,  0, 74,121, 32,  0, 64,123,176,255,  0, 66, 72,  6,  3, 58,
/* 0x2de0 */  40, 32, 26,120,  4,  0, 96, 57,128,250,255, 75,126,217,254, 87,
/* 0x2df0 */  80,248,254,127, 80,208,128,127,104,255,  1,250, 96,255,  1,234,
/* 0x2e00 */  80, 80, 64,125, 46, 91,243,127, 32,  0,156,123, 32,  0, 74,121,
/* 0x2e10 */ 152,254,255, 75,  0,  0,192, 58, 12,253,255, 75,  0,  0,  0,  0,
/* 0x2e20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e40 */   0,  0,  0,  0,  3,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 16,  0,
/* 0x2e60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e70 */   0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,
/* 0x2e90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ea0 */   0,  0,  0,  0,  3,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2eb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  7,  0,
/* 0x2ec0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ed0 */   0,  0,  0,  0,  3,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ee0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 11,  0,
/* 0x2ef0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f00 */   0,  0,  0,  0,  3,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 15,  0,
/* 0x2f20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f30 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 18,  0,
/* 0x2f50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f60 */   1,  0,  0,  0, 16,  0,  1,  0,116,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f70 */   0,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0, 18,  0,  4,  0,
/* 0x2f80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f90 */  15,  0,  0,  0, 16,  0,  1,  0, 20,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fa0 */   0,  0,  0,  0,  0,  0,  0,  0, 29,  0,  0,  0, 16,  0,  3,  0,
/* 0x2fb0 */  32,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fc0 */  36,  0,  0,  0, 16,  0,  3,  0, 20,  1,  0,  0,  0,  0,  0,  0,
/* 0x2fd0 */   0,  0,  0,  0,  0,  0,  0,  0, 43,  0,  0,  0, 16,  0,  3,  0,
/* 0x2fe0 */  80,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ff0 */  52,  0,  0,  0, 16,  0,  1,  0, 80,  0,  0,  0,  0,  0,  0,  0,
/* 0x3000 */   0,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0, 16,  0,  3,  0,
/* 0x3010 */  56,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3020 */  68,  0,  0,  0, 16,  0,  3,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x3030 */   0,  0,  0,  0,  0,  0,  0,  0, 73,  0,  0,  0, 16,  0,  3,  0,
/* 0x3040 */  88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3050 */  79,  0,  0,  0, 18,  0,  1,  0, 68, 13,  0,  0,  0,  0,  0,  0,
/* 0x3060 */ 152,  1,  0,  0,  0,  0,  0,  0, 89,  0,  0,  0, 16,  0,  3,  0,
/* 0x3070 */ 208,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3080 */ 102,  0,  0,  0, 16,  0,  3,  0, 96,  0,  0,  0,  0,  0,  0,  0,
/* 0x3090 */   0,  0,  0,  0,  0,  0,  0,  0,107,  0,  0,  0, 18,  0,  1,  0,
/* 0x30a0 */ 184, 12,  0,  0,  0,  0,  0,  0,140,  0,  0,  0,  0,  0,  0,  0,
/* 0x30b0 */ 116,  0,  0,  0, 16,  0,  3,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x30c0 */   0,  0,  0,  0,  0,  0,  0,  0,122,  0,  0,  0, 16,  0,  3,  0,
/* 0x30d0 */ 120,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x30e0 */ 135,  0,  0,  0, 16,  0,  6,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x30f0 */   0,  0,  0,  0,  0,  0,  0,  0,143,  0,  0,  0, 16,  0,  3,  0,
/* 0x3100 */  56,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3110 */ 151,  0,  0,  0, 16,  0,  1,  0, 44,  0,  0,  0,  0,  0,  0,  0,
/* 0x3120 */   0,  0,  0,  0,  0,  0,  0,  0,160,  0,  0,  0, 16,  0,  1,  0,
/* 0x3130 */ 152,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3140 */ 167,  0,  0,  0, 16,  0,  3,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3150 */   0,  0,  0,  0,  0,  0,  0,  0,172,  0,  0,  0, 16,  0,  3,  0,
/* 0x3160 */  72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3170 */ 176,  0,  0,  0, 16,  0,  3,  0,104,  0,  0,  0,  0,  0,  0,  0,
/* 0x3180 */   0,  0,  0,  0,  0,  0,  0,  0,181,  0,  0,  0, 16,  0,  3,  0,
/* 0x3190 */  40,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x31a0 */ 190,  0,  0,  0, 16,  0,  3,  0,112,  0,  0,  0,  0,  0,  0,  0,
/* 0x31b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 80,109, 97,112,  0,102, 95,
/* 0x31c0 */ 101,120,112, 97,110,100,  0,103,101,116, 95,112, 97,103,101, 95,
/* 0x31d0 */ 109, 97,115,107,  0,109,117,110,109, 97,112,  0,109,101,109, 99,
/* 0x31e0 */ 112,121,  0,114,101, 97,100,108,105,110,107,  0, 80,115,121,110,
/* 0x31f0 */  99,  0,102,116,114,117,110, 99, 97,116,101,  0,109,109, 97,112,
/* 0x3200 */   0,119,114,105,116,101,  0,117,112,120, 95,109, 97,105,110, 50,
/* 0x3210 */   0,109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,114,101,
/* 0x3220 */  97,100,  0,117,110,100,101,114,108, 97,121,  0,109,115,121,110,
/* 0x3230 */  99,  0,117,112,120,102,100, 95, 99,114,101, 97,116,101,  0,101,
/* 0x3240 */ 111,102, 95,110,114,118,  0,109,121, 95, 98,107,112,116,  0, 80,
/* 0x3250 */ 112,114,111,116,101, 99,116,  0, 80,117,110,109, 97,112,  0,101,
/* 0x3260 */ 120,105,116,  0, 98,114,107,  0,111,112,101,110,  0,109,112,114,
/* 0x3270 */ 111,116,101, 99,116,  0, 99,108,111,115,101,  0,  0,  0,  0,  0,
/* 0x3280 */  76,  0,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 36,  0,  0,  0,
/* 0x3290 */   0,  0,  0,  0,  0,  0,  0,  0,112,  0,  0,  0,  0,  0,  0,  0,
/* 0x32a0 */  10,  0,  0,  0, 27,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x32b0 */ 148,  0,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 21,  0,  0,  0,
/* 0x32c0 */   0,  0,  0,  0,  0,  0,  0,  0,184,  0,  0,  0,  0,  0,  0,  0,
/* 0x32d0 */  10,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x32e0 */  92,  1,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 35,  0,  0,  0,
/* 0x32f0 */   0,  0,  0,  0,  0,  0,  0,  0,112,  1,  0,  0,  0,  0,  0,  0,
/* 0x3300 */  10,  0,  0,  0, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3310 */  20,  2,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 23,  0,  0,  0,
/* 0x3320 */   0,  0,  0,  0,  0,  0,  0,  0, 36,  2,  0,  0,  0,  0,  0,  0,
/* 0x3330 */  10,  0,  0,  0, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3340 */  48,  2,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 16,  0,  0,  0,
/* 0x3350 */   0,  0,  0,  0,  0,  0,  0,  0, 88,  2,  0,  0,  0,  0,  0,  0,
/* 0x3360 */  10,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3370 */  96,  2,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 37,  0,  0,  0,
/* 0x3380 */   0,  0,  0,  0,  0,  0,  0,  0, 56,  3,  0,  0,  0,  0,  0,  0,
/* 0x3390 */  10,  0,  0,  0, 33,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x33a0 */ 232,  3,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 33,  0,  0,  0,
/* 0x33b0 */   0,  0,  0,  0,  0,  0,  0,  0,128,  4,  0,  0,  0,  0,  0,  0,
/* 0x33c0 */  10,  0,  0,  0, 33,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x33d0 */ 184,  4,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 14,  0,  0,  0,
/* 0x33e0 */   0,  0,  0,  0,  0,  0,  0,  0,  8,  6,  0,  0,  0,  0,  0,  0,
/* 0x33f0 */  10,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3400 */  48,  6,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 15,  0,  0,  0,
/* 0x3410 */   0,  0,  0,  0,  0,  0,  0,  0, 56,  7,  0,  0,  0,  0,  0,  0,
/* 0x3420 */  10,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3430 */  92,  7,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 16,  0,  0,  0,
/* 0x3440 */   0,  0,  0,  0,  0,  0,  0,  0,128,  7,  0,  0,  0,  0,  0,  0,
/* 0x3450 */  10,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3460 */ 140,  7,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 15,  0,  0,  0,
/* 0x3470 */   0,  0,  0,  0,  0,  0,  0,  0, 12,  9,  0,  0,  0,  0,  0,  0,
/* 0x3480 */  10,  0,  0,  0, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3490 */  28,  9,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 20,  0,  0,  0,
/* 0x34a0 */   0,  0,  0,  0,  0,  0,  0,  0, 60,  9,  0,  0,  0,  0,  0,  0,
/* 0x34b0 */  10,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x34c0 */ 108,  9,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 21,  0,  0,  0,
/* 0x34d0 */   0,  0,  0,  0,  0,  0,  0,  0,160,  9,  0,  0,  0,  0,  0,  0,
/* 0x34e0 */  10,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x34f0 */ 180, 10,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 28,  0,  0,  0,
/* 0x3500 */   0,  0,  0,  0,  0,  0,  0,  0,200, 10,  0,  0,  0,  0,  0,  0,
/* 0x3510 */  10,  0,  0,  0, 22,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3520 */ 232, 10,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 21,  0,  0,  0,
/* 0x3530 */   0,  0,  0,  0,  0,  0,  0,  0,248, 10,  0,  0,  0,  0,  0,  0,
/* 0x3540 */  10,  0,  0,  0, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3550 */  36, 11,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 19,  0,  0,  0,
/* 0x3560 */   0,  0,  0,  0,  0,  0,  0,  0, 52, 11,  0,  0,  0,  0,  0,  0,
/* 0x3570 */  10,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3580 */  84, 11,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 21,  0,  0,  0,
/* 0x3590 */   0,  0,  0,  0,  0,  0,  0,  0,104, 11,  0,  0,  0,  0,  0,  0,
/* 0x35a0 */  10,  0,  0,  0, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x35b0 */ 136, 11,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 31,  0,  0,  0,
/* 0x35c0 */   0,  0,  0,  0,  0,  0,  0,  0,156, 11,  0,  0,  0,  0,  0,  0,
/* 0x35d0 */  10,  0,  0,  0, 33,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x35e0 */ 196, 11,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 21,  0,  0,  0,
/* 0x35f0 */   0,  0,  0,  0,  0,  0,  0,  0, 36, 12,  0,  0,  0,  0,  0,  0,
/* 0x3600 */  10,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3610 */ 224, 12,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 17,  0,  0,  0,
/* 0x3620 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 13,  0,  0,  0,  0,  0,  0,
/* 0x3630 */  10,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3640 */  20, 13,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 17,  0,  0,  0,
/* 0x3650 */   0,  0,  0,  0,  0,  0,  0,  0,168, 13,  0,  0,  0,  0,  0,  0,
/* 0x3660 */  10,  0,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3670 */  16, 14,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 35,  0,  0,  0,
/* 0x3680 */   0,  0,  0,  0,  0,  0,  0,  0, 44, 14,  0,  0,  0,  0,  0,  0,
/* 0x3690 */  10,  0,  0,  0, 25,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x36a0 */  64, 14,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0, 33,  0,  0,  0,
/* 0x36b0 */   0,  0,  0,  0,  0,  0,  0,  0,128, 14,  0,  0,  0,  0,  0,  0,
/* 0x36c0 */  10,  0,  0,  0, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x36d0 */  96,  0,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  1,  0,  0,  0,
/* 0x36e0 */  40,  0,  0,  0,  0,  0,  0,  0,200,  0,  0,  0,  0,  0,  0,  0,
/* 0x36f0 */  11,  0,  0,  0, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3700 */ 204,  0,  0,  0,  0,  0,  0,  0, 11,  0,  0,  0, 29,  0,  0,  0,
/* 0x3710 */   0,  0,  0,  0,  0,  0,  0,  0,160,  0,  0,  0,  0,  0,  0,  0,
/* 0x3720 */  11,  0,  0,  0, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3730 */   4,  0,  0,  0,  0,  0,  0,  0, 11,  0,  0,  0,  2,  0,  0,  0,
/* 0x3740 */  48,  0,  0,  0,  0,  0,  0,  0,  0, 46,115,121,109,116, 97, 98,
/* 0x3750 */   0, 46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116,
/* 0x3760 */  97, 98,  0, 46,114,101,108, 97, 46,116,101,120,116,  0, 83, 89,
/* 0x3770 */  83, 67, 65, 76, 76, 83,  0, 46,114,101,108, 97, 69, 88, 80, 95,
/* 0x3780 */  72, 69, 65, 68,  0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 46,114,
/* 0x3790 */ 101,108, 97, 78, 82, 86, 50, 69,  0, 46,114,101,108, 97, 78, 82,
/* 0x37a0 */  86, 50, 68,  0, 46,114,101,108, 97, 78, 82, 86, 50, 66,  0, 46,
/* 0x37b0 */ 114,101,108, 97, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,  0, 76,
/* 0x37c0 */  90, 77, 65, 95, 69, 76, 70, 48, 48,  0, 76, 90, 77, 65, 95, 68,
/* 0x37d0 */  69, 67, 51, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  0,
/* 0x37e0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,
/* 0x37f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3810 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3820 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3830 */  32,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x3840 */   0,  0,  0,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3850 */ 220, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3860 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3870 */  27,  0,  0,  0,  4,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3880 */   0,  0,  0,  0,  0,  0,  0,  0,128, 50,  0,  0,  0,  0,  0,  0,
/* 0x3890 */  80,  4,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  1,  0,  0,  0,
/* 0x38a0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x38b0 */  38,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38c0 */   0,  0,  0,  0,  0,  0,  0,  0, 28, 15,  0,  0,  0,  0,  0,  0,
/* 0x38d0 */  64,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38e0 */   4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38f0 */  52,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3900 */   0,  0,  0,  0,  0,  0,  0,  0, 92, 16,  0,  0,  0,  0,  0,  0,
/* 0x3910 */ 168,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3920 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3930 */  47,  0,  0,  0,  4,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3940 */   0,  0,  0,  0,  0,  0,  0,  0,208, 54,  0,  0,  0,  0,  0,  0,
/* 0x3950 */  24,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  4,  0,  0,  0,
/* 0x3960 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x3970 */  61,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3980 */   0,  0,  0,  0,  0,  0,  0,  0,  4, 17,  0,  0,  0,  0,  0,  0,
/* 0x3990 */ 140,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39a0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39b0 */  75,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39c0 */   0,  0,  0,  0,  0,  0,  0,  0,144, 17,  0,  0,  0,  0,  0,  0,
/* 0x39d0 */  92,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39e0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39f0 */  70,  0,  0,  0,  4,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a00 */   0,  0,  0,  0,  0,  0,  0,  0,232, 54,  0,  0,  0,  0,  0,  0,
/* 0x3a10 */  24,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  7,  0,  0,  0,
/* 0x3a20 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a30 */  86,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a40 */   0,  0,  0,  0,  0,  0,  0,  0,236, 18,  0,  0,  0,  0,  0,  0,
/* 0x3a50 */  68,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a60 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a70 */  81,  0,  0,  0,  4,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a80 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0,  0,  0,  0,
/* 0x3a90 */  24,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  9,  0,  0,  0,
/* 0x3aa0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ab0 */  97,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ac0 */   0,  0,  0,  0,  0,  0,  0,  0, 48, 20,  0,  0,  0,  0,  0,  0,
/* 0x3ad0 */   0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ae0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3af0 */  92,  0,  0,  0,  4,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b00 */   0,  0,  0,  0,  0,  0,  0,  0, 24, 55,  0,  0,  0,  0,  0,  0,
/* 0x3b10 */  24,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0, 11,  0,  0,  0,
/* 0x3b20 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b30 */ 108,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b40 */   0,  0,  0,  0,  0,  0,  0,  0, 48, 21,  0,  0,  0,  0,  0,  0,
/* 0x3b50 */   8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b60 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b70 */ 103,  0,  0,  0,  4,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b80 */   0,  0,  0,  0,  0,  0,  0,  0, 48, 55,  0,  0,  0,  0,  0,  0,
/* 0x3b90 */  24,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0, 13,  0,  0,  0,
/* 0x3ba0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bb0 */ 119,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bc0 */   0,  0,  0,  0,  0,  0,  0,  0, 56, 21,  0,  0,  0,  0,  0,  0,
/* 0x3bd0 */ 152,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3be0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bf0 */ 130,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c00 */   0,  0,  0,  0,  0,  0,  0,  0,208, 21,  0,  0,  0,  0,  0,  0,
/* 0x3c10 */  48,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c20 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c30 */ 141,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c40 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 22,  0,  0,  0,  0,  0,  0,
/* 0x3c50 */ 184, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c60 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c70 */ 152,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c80 */   0,  0,  0,  0,  0,  0,  0,  0,184, 33,  0,  0,  0,  0,  0,  0,
/* 0x3c90 */ 108, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ca0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3cb0 */  17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3cc0 */   0,  0,  0,  0,  0,  0,  0,  0, 72, 55,  0,  0,  0,  0,  0,  0,
/* 0x3cd0 */ 163,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ce0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3cf0 */   1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d00 */   0,  0,  0,  0,  0,  0,  0,  0, 40, 46,  0,  0,  0,  0,  0,  0,
/* 0x3d10 */ 144,  3,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0, 13,  0,  0,  0,
/* 0x3d20 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d30 */   9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d40 */   0,  0,  0,  0,  0,  0,  0,  0,184, 49,  0,  0,  0,  0,  0,  0,
/* 0x3d50 */ 196,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d60 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d70 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54,
/* 0x3d80 */  52, 45,112,111,119,101,114,112, 99,108,101, 10, 10, 83,101, 99,
/* 0x3d90 */ 116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32,
/* 0x3da0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32,
/* 0x3db0 */  32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3dc0 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3dd0 */  32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32,
/* 0x3de0 */  32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48,
/* 0x3df0 */  32, 46,116,101,120,116, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x3e00 */ 101,100, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32,
/* 0x3e10 */  50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x3e20 */  32, 49, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 32, 32, 32, 32,
/* 0x3e30 */  32, 48, 49, 52, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 49,
/* 0x3e40 */  99, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3e50 */  83, 10, 32, 32, 50, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 32,
/* 0x3e60 */  32, 32, 32, 32, 48, 97, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3e70 */  49, 48, 53, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3e80 */  69, 78, 84, 83, 10, 32, 32, 51, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x3e90 */  76, 32, 32, 32, 32, 32, 32, 48, 56, 99, 32, 32, 48, 32, 32, 48,
/* 0x3ea0 */  32, 32, 48, 49, 49, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3eb0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82, 86, 50,
/* 0x3ec0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 53, 99, 32, 32,
/* 0x3ed0 */  48, 32, 32, 48, 32, 32, 48, 49, 49, 57, 48, 32, 32, 50, 42, 42,
/* 0x3ee0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32,
/* 0x3ef0 */  78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x3f00 */  52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50,101, 99, 32,
/* 0x3f10 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3f20 */  32, 32, 54, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f30 */  32, 32, 48, 49, 48, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3f40 */  52, 51, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3f50 */  78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 68, 65, 73,
/* 0x3f60 */  83, 89, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3f70 */  48, 49, 53, 51, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3f80 */  84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 69,
/* 0x3f90 */  76, 70, 48, 48, 32, 32, 32, 32, 48, 57, 56, 32, 32, 48, 32, 32,
/* 0x3fa0 */  48, 32, 32, 48, 49, 53, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3fb0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76, 90, 77,
/* 0x3fc0 */  65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 51, 48, 32, 32,
/* 0x3fd0 */  48, 32, 32, 48, 32, 32, 48, 49, 53,100, 48, 32, 32, 50, 42, 42,
/* 0x3fe0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32,
/* 0x3ff0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98,
/* 0x4000 */  98, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 54, 48, 48, 32,
/* 0x4010 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x4020 */  32, 49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32,
/* 0x4030 */  32, 32, 48, 99, 54, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x4040 */  49, 98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4050 */  78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,
/* 0x4060 */  58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4070 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 84,
/* 0x4080 */  65, 73, 76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 48,
/* 0x4090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x40a0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x40b0 */  51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10,
/* 0x40c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 46,116,101,120,116, 32, 48,
/* 0x40e0 */  32, 46,116,101,120,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4100 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 83, 89, 83, 67, 65,
/* 0x4110 */  76, 76, 83, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4120 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80,
/* 0x4130 */  95, 72, 69, 65, 68, 32, 48, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x4140 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4150 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32,
/* 0x4160 */  48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4170 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4180 */  32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x4190 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x41a0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32,
/* 0x41b0 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41c0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x41d0 */  90, 77, 65, 95, 68, 65, 73, 83, 89, 32, 48, 32, 76, 90, 77, 65,
/* 0x41e0 */  95, 68, 65, 73, 83, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4200 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77,
/* 0x4210 */  65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4220 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4230 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90,
/* 0x4240 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4250 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4260 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76,
/* 0x4270 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4280 */  48, 48, 48, 48, 48, 48, 48, 48, 55, 52, 32,103, 32, 32, 32, 32,
/* 0x4290 */  32, 32, 32, 46,116,101,120,116, 32, 48, 32, 80,109, 97,112, 10,
/* 0x42a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42b0 */  32,103, 32, 32, 32, 32, 32, 70, 32, 69, 88, 80, 95, 72, 69, 65,
/* 0x42c0 */  68, 32, 48, 32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48,
/* 0x42d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 52, 32,103, 32,
/* 0x42e0 */  32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,103,101,
/* 0x42f0 */ 116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48,
/* 0x4300 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 32,103, 32, 32,
/* 0x4310 */  32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,
/* 0x4320 */ 109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4330 */  48, 48, 48, 48, 49, 49, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x4340 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,101,109, 99,112,
/* 0x4350 */ 121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4360 */  53, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65,
/* 0x4370 */  76, 76, 83, 32, 48, 32,114,101, 97,100,108,105,110,107, 10, 48,
/* 0x4380 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 48, 32,
/* 0x4390 */ 103, 32, 32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,
/* 0x43a0 */  80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43b0 */  48, 48, 48, 48, 51, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x43c0 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32,102,116,114,117,110, 99,
/* 0x43d0 */  97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43e0 */  48, 48, 48, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83,
/* 0x43f0 */  67, 65, 76, 76, 83, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48,
/* 0x4400 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 56, 32,103, 32,
/* 0x4410 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x4420 */  32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4430 */  48, 48, 48, 48,100, 52, 52, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x4440 */  46,116,101,120,116, 32, 48, 49, 57, 56, 32,117,112,120, 95,109,
/* 0x4450 */  97,105,110, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4460 */  48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x4470 */  83, 67, 65, 76, 76, 83, 32, 48, 32,109,101,109,102,100, 95, 99,
/* 0x4480 */ 114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4490 */  48, 48, 48, 48, 54, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x44a0 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32,114,101, 97,100, 10, 48,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 98, 56, 32,
/* 0x44c0 */ 103, 32, 32, 32, 32, 32, 70, 32, 46,116,101,120,116, 32, 48, 56,
/* 0x44d0 */  99, 32,117,110,100,101,114,108, 97,121, 10, 48, 48, 48, 48, 48,
/* 0x44e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 48, 32,103, 32, 32, 32,
/* 0x44f0 */  32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,
/* 0x4500 */ 115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4510 */  48, 48, 48, 55, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x4520 */  83, 67, 65, 76, 76, 83, 32, 48, 32,117,112,120,102,100, 95, 99,
/* 0x4530 */ 114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4540 */  48, 48, 48, 48, 48, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x4550 */  88, 80, 95, 84, 65, 73, 76, 32, 48, 32,101,111,102, 95,110,114,
/* 0x4560 */ 118, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x4570 */  51, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65,
/* 0x4580 */  76, 76, 83, 32, 48, 32,109,121, 95, 98,107,112,116, 10, 48, 48,
/* 0x4590 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 99, 32,103,
/* 0x45a0 */  32, 32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32, 80,
/* 0x45b0 */ 112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45c0 */  48, 48, 48, 48, 48, 48, 57, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x45d0 */  32, 46,116,101,120,116, 32, 48, 32, 80,117,110,109, 97,112, 10,
/* 0x45e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 48,
/* 0x45f0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x4600 */  83, 32, 48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 52, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x4620 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 98,114,107,
/* 0x4630 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x4640 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x4650 */  76, 83, 32, 48, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x4660 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 56, 32,103, 32, 32, 32, 32,
/* 0x4670 */  32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,112,
/* 0x4680 */ 114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4690 */  48, 48, 48, 48, 48, 55, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x46a0 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 99,108,111,115,101,
/* 0x46b0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x46c0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 46,116,101,120,116, 93,
/* 0x46d0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x46e0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x46f0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4700 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 80, 80,
/* 0x4710 */  67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,112,
/* 0x4720 */ 114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4730 */  48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x4740 */  82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,115,121,110, 99, 10,
/* 0x4750 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 52,
/* 0x4760 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4770 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4780 */  48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x4790 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,
/* 0x47a0 */ 112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x47b0 */  53, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x47c0 */  32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x47d0 */  48, 48, 48, 48, 48, 48, 48, 49, 55, 48, 32, 82, 95, 80, 80, 67,
/* 0x47e0 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,114,101, 97,
/* 0x47f0 */ 100,108,105,110,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4800 */  48, 48, 48, 50, 49, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4810 */  69, 76, 50, 52, 32, 32, 32, 32, 32,117,112,120, 95,109, 97,105,
/* 0x4820 */ 110, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4830 */  50, 50, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x4840 */  52, 32, 32, 32, 32, 32, 98,114,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 48, 48, 48, 48, 48, 48, 50, 51, 48, 32, 82, 95, 80, 80, 67,
/* 0x4860 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,
/* 0x4870 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4880 */  48, 50, 53, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4890 */  50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48,
/* 0x48a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 54, 48, 32, 82, 95, 80,
/* 0x48b0 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 99,
/* 0x48c0 */ 108,111,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48d0 */  48, 48, 51, 51, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69,
/* 0x48e0 */  76, 50, 52, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48,
/* 0x48f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95,
/* 0x4900 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4910 */ 101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4920 */  48, 48, 52, 56, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69,
/* 0x4930 */  76, 50, 52, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48,
/* 0x4940 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 98, 56, 32, 82, 95,
/* 0x4950 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4960 */ 102, 95,101,120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4970 */  48, 48, 48, 48, 48, 48, 54, 48, 56, 32, 82, 95, 80, 80, 67, 54,
/* 0x4980 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109,
/* 0x4990 */  97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x49a0 */  54, 51, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x49b0 */  52, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109,
/* 0x49c0 */  97,115,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x49d0 */  48, 55, 51, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x49e0 */  50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48,
/* 0x49f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 53, 99, 32, 82, 95, 80,
/* 0x4a00 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,
/* 0x4a10 */ 117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a20 */  48, 48, 48, 55, 56, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4a30 */  69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,112, 10,
/* 0x4a40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 56, 99,
/* 0x4a50 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4a60 */  32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,
/* 0x4a70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 48,
/* 0x4a80 */  99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4a90 */  32, 32, 32, 32,117,112,120,102,100, 95, 99,114,101, 97,116,101,
/* 0x4aa0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 49,
/* 0x4ab0 */  99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4ac0 */  32, 32, 32, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48,
/* 0x4ad0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 51, 99, 32, 82,
/* 0x4ae0 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4af0 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b00 */  48, 48, 48, 57, 54, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4b10 */  69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48,
/* 0x4b20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 97, 48, 32, 82,
/* 0x4b30 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4b40 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b50 */  48, 48, 48, 97, 98, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4b60 */  69, 76, 50, 52, 32, 32, 32, 32, 32,117,112,120,102,100, 95, 99,
/* 0x4b70 */ 114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b80 */  48, 48, 48, 97, 99, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4b90 */  69, 76, 50, 52, 32, 32, 32, 32, 32,119,114,105,116,101, 10, 48,
/* 0x4ba0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97,101, 56, 32,
/* 0x4bb0 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x4bc0 */  32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4bd0 */  48, 48, 48, 48, 97,102, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x4be0 */  82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 99,108,111,115,101, 10,
/* 0x4bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 50, 52,
/* 0x4c00 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4c10 */  32, 32, 32, 80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c20 */  48, 48, 48, 48, 48, 48, 98, 51, 52, 32, 82, 95, 80, 80, 67, 54,
/* 0x4c30 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109,
/* 0x4c40 */  97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c50 */  98, 53, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x4c60 */  52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x4c70 */  48, 48, 48, 48, 48, 48, 48, 48, 98, 54, 56, 32, 82, 95, 80, 80,
/* 0x4c80 */  67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 99,108,
/* 0x4c90 */ 111,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ca0 */  48, 98, 56, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4cb0 */  50, 52, 32, 32, 32, 32, 32, 80,112,114,111,116,101, 99,116, 10,
/* 0x4cc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 57, 99,
/* 0x4cd0 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4ce0 */  32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4cf0 */  48, 48, 48, 48, 48, 98, 99, 52, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x4d00 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10,
/* 0x4d10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 50, 52,
/* 0x4d20 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4d30 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d40 */  48, 48, 48, 48, 48, 99,101, 48, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x4d50 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,101,109, 99,112,
/* 0x4d60 */ 121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x4d70 */  48, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x4d80 */  32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x4d90 */  48, 48, 48, 48, 48, 48, 48,100, 49, 52, 32, 82, 95, 80, 80, 67,
/* 0x4da0 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,101,109,
/* 0x4db0 */  99,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4dc0 */  48,100, 97, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4dd0 */  50, 52, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x4de0 */ 109, 97,115,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4df0 */  48, 48,101, 49, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69,
/* 0x4e00 */  76, 50, 52, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48,
/* 0x4e10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48,101, 50, 99, 32, 82, 95,
/* 0x4e20 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4e30 */ 114,101, 97,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e40 */  48, 48,101, 52, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69,
/* 0x4e50 */  76, 50, 52, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48,
/* 0x4e60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48,101, 56, 48, 32, 82, 95,
/* 0x4e70 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4e80 */  99,108,111,115,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4e90 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,
/* 0x4ea0 */  88, 80, 95, 72, 69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4eb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4ec0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4ed0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ee0 */  48, 54, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x4ef0 */  52, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,
/* 0x4f00 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x4f10 */  56, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4f20 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69,
/* 0x4f30 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f40 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f50 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4f60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 56, 32, 82, 95, 80,
/* 0x4f70 */  80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32,101,
/* 0x4f80 */ 111,102, 95,110,114,118, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4f90 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4fa0 */  78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4fb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4fc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4fd0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x4fe0 */  99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32,
/* 0x4ff0 */  32, 32, 32, 32,101,111,102, 95,110,114,118, 10, 10, 82, 69, 76,
/* 0x5000 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5010 */  70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70,
/* 0x5020 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x5030 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5040 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5050 */  48, 48, 48, 48, 97, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x5060 */  69, 76, 49, 52, 32, 32, 32, 32, 32,101,111,102, 95,110,114,118,
/* 0x5070 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5080 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68,
/* 0x5090 */  65, 73, 83, 89, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x50a0 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x50b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x50c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x50d0 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32,
/* 0x50e0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120,
/* 0x50f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 48,
/* 0x5100 */  10
};
