/* i386-darwin.macho-entry.h
   created from i386-darwin.macho-entry.bin, 9257 (0x2429) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_DARWIN_MACHO_ENTRY_SIZE    9257
#define STUB_I386_DARWIN_MACHO_ENTRY_ADLER32 0xf635c8bc
#define STUB_I386_DARWIN_MACHO_ENTRY_CRC32   0x656f8a63

unsigned char stub_i386_darwin_macho_entry[9257] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 188, 27,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,232,252,255,255,255,105,  0,139, 68, 36, 16,131,
/* 0x0040 */ 248, 73,116,  7,131,248, 70,116,  2,235, 86, 85,137,229, 83, 86,
/* 0x0050 */  87,139,117,  8,139, 77, 12,139, 85, 16,136,198,141, 76, 14,253,
/* 0x0060 */ 137,243,235, 50, 57,206,115, 53, 86, 94,172,128,254, 73,117, 14,
/* 0x0070 */  60,128,114, 10, 60,143,119,  6,128,126,254, 15,116,  6, 44,232,
/* 0x0080 */  60,  1,119,224, 57,206,115, 21, 86,173, 40,208,117,219, 95, 15,
/* 0x0090 */ 200, 41,248,  1,216,171, 57,206,115,  3,172,235,225, 95, 94, 91,
/* 0x00a0 */  93,195, 96,139,116, 36, 36,139, 76, 36, 40,  1,241,137, 76, 36,
/* 0x00b0 */  36,139,124, 36, 44, 49,219, 49,201,131,205,255,235, 74,  1,219,
/* 0x00c0 */ 116,  2,243,195,139, 30,131,238,252, 17,219, 15,182, 22,243,195,
/* 0x00d0 */ 141,  4, 47,131,249,  5, 15,182, 16,118, 31,131,253,252,119, 26,
/* 0x00e0 */ 131,233,  4,139, 16,131,192,  4,131,233,  4,137, 23,141,127,  4,
/* 0x00f0 */ 115,241,131,193,  4, 15,182, 16,116, 12, 64,136, 23, 73, 15,182,
/* 0x0100 */  16,141,127,  1,117,244,243,195,252,128,124, 36, 52,  8, 15,133,
/* 0x0110 */ 203,  0,  0,  0,235,  4, 70,136, 23, 71, 15,182, 22,  1,219,117,
/* 0x0120 */  10,139, 30,131,238,252, 17,219, 15,182, 22,114,233,106,  1, 88,
/* 0x0130 */ 235, 17, 72,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182,
/* 0x0140 */  22, 17,192,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182,
/* 0x0150 */  22, 17,192,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182,
/* 0x0160 */  22,115,207,131,232,  3,114, 23,193,224,  8, 70,  9,208,131,240,
/* 0x0170 */ 255, 15,132,252,255,255,255,209,248,137,197,114, 63,235, 13,  1,
/* 0x0180 */ 219,117,  7,139, 30,131,238,252, 17,219,114, 48, 65,  1,219,117,
/* 0x0190 */   7,139, 30,131,238,252, 17,219,114, 34,  1,219,117, 10,139, 30,
/* 0x01a0 */ 131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117,  7,139, 30,
/* 0x01b0 */ 131,238,252, 17,219,115,227,131,193,  2,235, 16,  1,219,117, 10,
/* 0x01c0 */ 139, 30,131,238,252, 17,219, 15,182, 22, 17,201,129,253,  0,251,
/* 0x01d0 */ 255,255,131,209,  2,232,147,  0,  0,  0,233, 59,255,255,255, 87,
/* 0x01e0 */  94,128,124, 36, 52,  5, 15,133,191,  0,  0,  0,235,  4, 70,136,
/* 0x01f0 */  23, 71, 15,182, 22,  1,219,117, 10,139, 30,131,238,252, 17,219,
/* 0x0200 */  15,182, 22,114,233,106,  1, 88,235, 17, 72,  1,219,117, 10,139,
/* 0x0210 */  30,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,139,
/* 0x0220 */  30,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 10,139,
/* 0x0230 */  30,131,238,252, 17,219, 15,182, 22,115,207,131,232,  3,114, 21,
/* 0x0240 */ 193,224,  8, 70,  9,208,131,240,255, 15,132,252,255,255,255,209,
/* 0x0250 */ 248,137,197,235, 14,  1,219,117, 10,139, 30,131,238,252, 17,219,
/* 0x0260 */  15,182, 22, 17,201,  1,219,117, 10,139, 30,131,238,252, 17,219,
/* 0x0270 */  15,182, 22, 17,201,117, 33, 65,  1,219,117, 10,139, 30,131,238,
/* 0x0280 */ 252, 17,219, 15,182, 22, 17,201,  1,219,117,  7,139, 30,131,238,
/* 0x0290 */ 252, 17,219,115,227,131,193,  2,129,253,  0,251,255,255,131,209,
/* 0x02a0 */   1,232,147,  0,  0,  0,233, 71,255,255,255, 87, 94,128,124, 36,
/* 0x02b0 */  52,  2, 15,133,171,  0,  0,  0,235,  4, 70,136, 23, 71, 15,182,
/* 0x02c0 */  22,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,182, 22,114,
/* 0x02d0 */ 233,106,  1, 88,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,
/* 0x02e0 */ 182, 22, 17,192,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,
/* 0x02f0 */ 182, 22,115,224,131,232,  3,114, 17,193,224,  8, 70,  9,208,131,
/* 0x0300 */ 240,255, 15,132,252,255,255,255,137,197,106,  1, 88,  1,219,117,
/* 0x0310 */  10,139, 30,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117,
/* 0x0320 */  10,139, 30,131,238,252, 17,219, 15,182, 22, 17,201,117, 34,137,
/* 0x0330 */ 193,131,192,  2,  1,219,117, 10,139, 30,131,238,252, 17,219, 15,
/* 0x0340 */ 182, 22, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,
/* 0x0350 */ 227,129,253,  0,243,255,255, 17,193,232,147,  0,  0,  0,233, 91,
/* 0x0360 */ 255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80, 57,
/* 0x0370 */ 220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,  4, 83,
/* 0x0380 */ 104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,  0,  0,
/* 0x0390 */   0,137,229,139, 85, 40,172, 74,136,193, 36,  7,192,233,  3,187,
/* 0x03a0 */   0,253,255,255,211,227,141,164, 92,144,241,255,255,131,228,224,
/* 0x03b0 */ 106,  0,106,  0,137,227, 83,131,195,  4,139, 77, 48,255, 49, 87,
/* 0x03c0 */  83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,192,
/* 0x03d0 */ 233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87,191,  0,  0,  0,  0,
/* 0x03e0 */  86, 83,131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,
/* 0x03f0 */   0,141, 66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,
/* 0x0400 */   2,137,195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,  1,
/* 0x0410 */ 211,224,139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,132,
/* 0x0420 */  36,132,  0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,
/* 0x0430 */ 199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,
/* 0x0440 */   0,  0,  0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,199,
/* 0x0450 */  68, 36, 64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,
/* 0x0460 */   1,  0,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,
/* 0x0470 */   7,  0,  0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,  0,
/* 0x0480 */   0,  4,131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,  0,
/* 0x0490 */   0,  0,  0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,  0,
/* 0x04a0 */ 137,235,  3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108, 36,
/* 0x04b0 */  56, 15,132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182, 69,
/* 0x04c0 */   0, 69,  9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,  0,
/* 0x04d0 */   0,  0, 57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,136,
/* 0x04e0 */   0,  0,  0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,139,
/* 0x04f0 */  68, 36, 76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,208,
/* 0x0500 */ 129,124, 36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108, 36,
/* 0x0510 */  56, 15,132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,
/* 0x0520 */   8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,
/* 0x0530 */  22,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,
/* 0x0540 */  80,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,138,
/* 0x0550 */  76, 36, 80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,137,
/* 0x0560 */   6,139, 68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,137,
/* 0x0570 */ 249, 15,182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,
/* 0x0580 */ 208,105,192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,108,
/* 0x0590 */  14,  0,  0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68, 36,
/* 0x05a0 */  92, 43, 68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4, 16,
/* 0x05b0 */ 137, 68, 36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,
/* 0x05c0 */ 216,137,251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,  2,
/* 0x05d0 */   0,  0, 15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,143,
/* 0x05e0 */ 143,  0,  0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,139,
/* 0x05f0 */  76, 36, 20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,255,
/* 0x0600 */   0,141,  4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132, 36,
/* 0x0610 */   7,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x0620 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,  0,
/* 0x0630 */   0,193,232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,130,
/* 0x0640 */ 114,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,
/* 0x0650 */ 232,  5,141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,  0,
/* 0x0660 */   0, 15,132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,113,
/* 0x0670 */ 255,255,255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,
/* 0x0680 */ 131,124, 36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,199,
/* 0x0690 */  68, 36, 76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57, 68,
/* 0x06a0 */  36, 92, 15,130, 63,254,255,255,129,124, 36, 52,255,255,255,  0,
/* 0x06b0 */ 119, 12, 59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,108,
/* 0x06c0 */  36,124,184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139, 92,
/* 0x06d0 */  36, 92,139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,100,
/* 0x06e0 */ 233, 46,  8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52, 27,
/* 0x06f0 */ 139, 68, 36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 52,
/* 0x0700 */   6,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x0710 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232, 11,
/* 0x0720 */  15,183,209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,
/* 0x0730 */ 184,  0,  8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,  3,
/* 0x0740 */ 137,243,129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,223,
/* 0x0750 */ 136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24,
/* 0x0760 */  15,142, 41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,  0,
/* 0x0770 */   0,131,108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52, 41,
/* 0x0780 */  68, 36, 48,137,200,102,193,232,  5,102, 41,193,102,137, 11,141,
/* 0x0790 */  94,  1,235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,208,
/* 0x07a0 */ 102,193,232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,255,
/* 0x07b0 */   0,102,137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108, 36,
/* 0x07c0 */  56, 15,132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,
/* 0x07d0 */ 193,227,  8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,137,
/* 0x07e0 */ 216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,
/* 0x07f0 */ 228,  2,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92, 36,
/* 0x0800 */  96,193,248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,
/* 0x0810 */ 139, 84, 36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,137,
/* 0x0820 */  76, 36, 68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,137,
/* 0x0830 */  84, 36, 64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36, 76,
/* 0x0840 */ 129,254,255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,  4,
/* 0x0850 */   0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68,
/* 0x0860 */  36, 48, 69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,175,
/* 0x0870 */ 193, 57, 68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,184,
/* 0x0880 */   0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139, 76,
/* 0x0890 */  36, 44,141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,
/* 0x08a0 */ 141, 92, 25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,
/* 0x08b0 */ 139,124, 36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,
/* 0x08c0 */   0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,102,
/* 0x08d0 */ 137,  3,116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,139,
/* 0x08e0 */  68, 36, 16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,  4,
/* 0x08f0 */   0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x0900 */  69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,
/* 0x0910 */ 183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41,
/* 0x0920 */  68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,
/* 0x0930 */ 141, 86,  1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,224,
/* 0x0940 */  41,194,  3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12, 15,
/* 0x0950 */ 143,254,  3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,126,
/* 0x0960 */   5,184,  3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,  0,
/* 0x0970 */   0,  0,141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,
/* 0x0980 */   0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,
/* 0x0990 */ 248,  5, 79,141,  4,  2,102,137,  3,137,240,116, 97,129,124, 36,
/* 0x09a0 */  52,255,255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,119,
/* 0x09b0 */  29, 59,108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,  8,
/* 0x09c0 */ 193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68,
/* 0x09d0 */  36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68,
/* 0x09e0 */  36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,
/* 0x09f0 */ 232,  5,102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141, 80,
/* 0x0a00 */ 192,131,250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,211,
/* 0x0a10 */ 137,208,131,227,  1,209,248,131,203,  2,131,250, 13,141,120,255,
/* 0x0a20 */  15,143, 66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,210,
/* 0x0a30 */ 141,  4, 94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,  4,
/* 0x0a40 */  36,184,  1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,
/* 0x0a50 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x0a60 */   2,102,137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,  0,
/* 0x0a70 */   0,129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,141,
/* 0x0a80 */  28, 14,119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,100,
/* 0x0a90 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x0aa0 */  48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,
/* 0x0ab0 */ 193, 57, 68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,
/* 0x0ac0 */ 208,102,193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139, 92,
/* 0x0ad0 */  36, 28,  9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,208,
/* 0x0ae0 */ 102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,151,
/* 0x0af0 */ 128,  1,  0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,  0,
/* 0x0b00 */   0,137,218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36, 48,
/* 0x0b10 */  15,131,134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,137,
/* 0x0b20 */ 240,193,248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,  1,
/* 0x0b30 */   0,  0,139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,255,
/* 0x0b40 */ 255,255,  0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,  1,
/* 0x0b50 */   0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68,
/* 0x0b60 */  36, 48, 69,102,139,151,224,  1,  0,  0,137,216,193,232, 11, 15,
/* 0x0b70 */ 183,202, 15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,137,
/* 0x0b80 */  68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x0b90 */ 102,137,135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,148,
/* 0x0ba0 */   1,  0,  0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156, 36,
/* 0x0bb0 */ 136,  0,  0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,137,
/* 0x0bc0 */  68, 36, 76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,
/* 0x0bd0 */ 248,136,  2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,255,
/* 0x0be0 */ 255, 41,198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,
/* 0x0bf0 */ 129,254,255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56, 15,
/* 0x0c00 */ 132, 50,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,
/* 0x0c10 */   8,  9, 68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11, 15,
/* 0x0c20 */ 183,202, 15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,137,
/* 0x0c30 */  68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,
/* 0x0c40 */ 248,  5,139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,
/* 0x0c50 */   0,102,137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,
/* 0x0c60 */ 233, 67,252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,193,
/* 0x0c70 */ 100, 36, 48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,182,
/* 0x0c80 */  69,  0,137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69, 15,
/* 0x0c90 */ 175,208, 57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,211,
/* 0x0ca0 */ 102,193,232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,255,
/* 0x0cb0 */   0,102,137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,119,
/* 0x0cc0 */ 193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48,
/* 0x0cd0 */  69,102,139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,202,
/* 0x0ce0 */  15,175,193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,184,
/* 0x0cf0 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,176,
/* 0x0d00 */   1,  0,  0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,137,
/* 0x0d10 */  84, 36, 68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92, 36,
/* 0x0d20 */  96, 15,159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137, 68,
/* 0x0d30 */  36, 76,233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,233,
/* 0x0d40 */ 207,  1,  0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132, 85,
/* 0x0d50 */ 249,255,255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57, 68,
/* 0x0d60 */  36, 72,119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68, 36,
/* 0x0d70 */  72,  3,148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,
/* 0x0d80 */ 137,251,136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,
/* 0x0d90 */   3,249,255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,114,
/* 0x0da0 */ 219,233,  2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,116,
/* 0x0db0 */  36, 52,102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,
/* 0x0dc0 */ 194,199, 68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,  4,
/* 0x0dd0 */   2,  0,  0,137, 92, 36, 16,233,212,250,255,255,131,108, 36, 76,
/* 0x0de0 */   6,233,177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,
/* 0x0df0 */ 102,193,232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233, 16,
/* 0x0e00 */ 255,255,255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102,
/* 0x0e10 */  41,194,129,251,255,255,255,  0,102,137,151,176,  1,  0,  0, 15,
/* 0x0e20 */ 134,165,  0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,232,
/* 0x0e30 */  11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,  0,
/* 0x0e40 */   0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x0e50 */ 102,137,135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,137,
/* 0x0e60 */  92, 36, 64,233,159,254,255,255,141, 80,251,129,124, 36, 52,255,
/* 0x0e70 */ 255,255,  0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,193,
/* 0x0e80 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x0e90 */  36, 48,209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,
/* 0x0ea0 */ 114,  7, 41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36, 96,
/* 0x0eb0 */ 193,227,  4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,  6,
/* 0x0ec0 */   0,  0,137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,132,
/* 0x0ed0 */  99,254,255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,
/* 0x0ee0 */   9, 68, 36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36, 48,
/* 0x0ef0 */  41,198,137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,139,
/* 0x0f00 */  68, 36, 60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233, 72,
/* 0x0f10 */ 255,255,255, 91, 94, 95, 93, 85, 87,191,  0,  0,  0,  0, 86, 83,
/* 0x0f20 */ 131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,  0,141,
/* 0x0f30 */  66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,  2,137,
/* 0x0f40 */ 195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,  1,211,224,
/* 0x0f50 */ 139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,132, 36,132,
/* 0x0f60 */   0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,199,  0,
/* 0x0f70 */   0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,  0,  0,
/* 0x0f80 */   0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,199, 68, 36,
/* 0x0f90 */  64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,  1,  0,
/* 0x0fa0 */   0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,
/* 0x0fb0 */   0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,  0,  0,  4,
/* 0x0fc0 */ 131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,  0,  0,  0,
/* 0x0fd0 */   0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,  0,137,235,
/* 0x0fe0 */   3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108, 36, 56, 15,
/* 0x0ff0 */ 132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182, 69,  0, 69,
/* 0x1000 */   9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,  0,  0,  0,
/* 0x1010 */  57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,136,  0,  0,
/* 0x1020 */   0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,139, 68, 36,
/* 0x1030 */  76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,208,129,124,
/* 0x1040 */  36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108, 36, 56, 15,
/* 0x1050 */ 132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,
/* 0x1060 */ 182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 22,193,
/* 0x1070 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 80,  2,
/* 0x1080 */   0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,138, 76, 36,
/* 0x1090 */  80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,137,  6,139,
/* 0x10a0 */  68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,137,249, 15,
/* 0x10b0 */ 182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,208,105,
/* 0x10c0 */ 192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,108, 14,  0,
/* 0x10d0 */   0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68, 36, 92, 43,
/* 0x10e0 */  68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4, 16,137, 68,
/* 0x10f0 */  36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,216,137,
/* 0x1100 */ 251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,  2,  0,  0,
/* 0x1110 */  15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,143,143,  0,
/* 0x1120 */   0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,139, 76, 36,
/* 0x1130 */  20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,255,  0,141,
/* 0x1140 */   4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132, 36,  7,  0,
/* 0x1150 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x1160 */   9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,  0,  0,193,
/* 0x1170 */ 232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,130,114,255,
/* 0x1180 */ 255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,
/* 0x1190 */ 141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,  0,  0, 15,
/* 0x11a0 */ 132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,113,255,255,
/* 0x11b0 */ 255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124,
/* 0x11c0 */  36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,199, 68, 36,
/* 0x11d0 */  76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57, 68, 36, 92,
/* 0x11e0 */  15,130, 63,254,255,255,129,124, 36, 52,255,255,255,  0,119, 12,
/* 0x11f0 */  59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,108, 36,124,
/* 0x1200 */ 184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139, 92, 36, 92,
/* 0x1210 */ 139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,100,233, 46,
/* 0x1220 */   8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52, 27,139, 68,
/* 0x1230 */  36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 52,  6,  0,
/* 0x1240 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x1250 */   9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232, 11, 15,183,
/* 0x1260 */ 209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,184,  0,
/* 0x1270 */   8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,  3,137,243,
/* 0x1280 */ 129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,223,136, 26,
/* 0x1290 */  66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,142,
/* 0x12a0 */  41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,  0,  0,131,
/* 0x12b0 */ 108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52, 41, 68, 36,
/* 0x12c0 */  48,137,200,102,193,232,  5,102, 41,193,102,137, 11,141, 94,  1,
/* 0x12d0 */ 235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,208,102,193,
/* 0x12e0 */ 232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,255,  0,102,
/* 0x12f0 */ 137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108, 36, 56, 15,
/* 0x1300 */ 132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,
/* 0x1310 */   8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,137,216,193,
/* 0x1320 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,228,  2,
/* 0x1330 */   0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92, 36, 96,193,
/* 0x1340 */ 248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,139, 84,
/* 0x1350 */  36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,137, 76, 36,
/* 0x1360 */  68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,137, 84, 36,
/* 0x1370 */  64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36, 76,129,254,
/* 0x1380 */ 255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,  4,  0,  0,
/* 0x1390 */ 193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48,
/* 0x13a0 */  69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x13b0 */  68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,184,  0,  8,
/* 0x13c0 */   0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139, 76, 36, 44,
/* 0x13d0 */ 141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,141, 92,
/* 0x13e0 */  25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,139,124,
/* 0x13f0 */  36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,
/* 0x1400 */   0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,102,137,  3,
/* 0x1410 */ 116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,139, 68, 36,
/* 0x1420 */  16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,  4,  0,  0,
/* 0x1430 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x1440 */  68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202,
/* 0x1450 */  15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36,
/* 0x1460 */  48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141, 86,
/* 0x1470 */   1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,224, 41,194,
/* 0x1480 */   3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12, 15,143,254,
/* 0x1490 */   3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,126,  5,184,
/* 0x14a0 */   3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,  0,  0,  0,
/* 0x14b0 */ 141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,
/* 0x14c0 */ 235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x14d0 */  79,141,  4,  2,102,137,  3,137,240,116, 97,129,124, 36, 52,255,
/* 0x14e0 */ 255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,119, 29, 59,
/* 0x14f0 */ 108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x1500 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x1510 */ 102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x1520 */ 114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x1530 */ 102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141, 80,192,131,
/* 0x1540 */ 250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,211,137,208,
/* 0x1550 */ 131,227,  1,209,248,131,203,  2,131,250, 13,141,120,255, 15,143,
/* 0x1560 */  66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,210,141,  4,
/* 0x1570 */  94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,  4, 36,184,
/* 0x1580 */   1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,137, 68,
/* 0x1590 */  36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x15a0 */ 137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,  0,  0,129,
/* 0x15b0 */ 124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,141, 28, 14,
/* 0x15c0 */ 119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,100, 36, 48,
/* 0x15d0 */   8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139,
/* 0x15e0 */  68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x15f0 */  68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,
/* 0x1600 */ 193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139, 92, 36, 28,
/* 0x1610 */   9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,208,102,193,
/* 0x1620 */ 232,  5,102, 41,194,129,251,255,255,255,  0,102,137,151,128,  1,
/* 0x1630 */   0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,  0,  0,137,
/* 0x1640 */ 218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36, 48, 15,131,
/* 0x1650 */ 134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,137,240,193,
/* 0x1660 */ 248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,  1,  0,  0,
/* 0x1670 */ 139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,255,255,255,
/* 0x1680 */   0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,  1,  0,  0,
/* 0x1690 */ 193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48,
/* 0x16a0 */  69,102,139,151,224,  1,  0,  0,137,216,193,232, 11, 15,183,202,
/* 0x16b0 */  15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,137, 68, 36,
/* 0x16c0 */  52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x16d0 */ 135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,148,  1,  0,
/* 0x16e0 */   0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156, 36,136,  0,
/* 0x16f0 */   0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,137, 68, 36,
/* 0x1700 */  76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,248,136,
/* 0x1710 */   2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,255,255, 41,
/* 0x1720 */ 198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,254,
/* 0x1730 */ 255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56, 15,132, 50,
/* 0x1740 */   1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9,
/* 0x1750 */  68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11, 15,183,202,
/* 0x1760 */  15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,137, 68, 36,
/* 0x1770 */  52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,
/* 0x1780 */ 139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,  0,102,
/* 0x1790 */ 137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,233, 67,
/* 0x17a0 */ 252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,193,100, 36,
/* 0x17b0 */  48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,182, 69,  0,
/* 0x17c0 */ 137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69, 15,175,208,
/* 0x17d0 */  57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,211,102,193,
/* 0x17e0 */ 232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,255,  0,102,
/* 0x17f0 */ 137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,119,193,100,
/* 0x1800 */  36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,
/* 0x1810 */ 139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1820 */ 193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,184,  0,  8,
/* 0x1830 */   0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,176,  1,  0,
/* 0x1840 */   0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,137, 84, 36,
/* 0x1850 */  68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92, 36, 96, 15,
/* 0x1860 */ 159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 76,
/* 0x1870 */ 233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,233,207,  1,
/* 0x1880 */   0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132, 85,249,255,
/* 0x1890 */ 255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57, 68, 36, 72,
/* 0x18a0 */ 119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68, 36, 72,  3,
/* 0x18b0 */ 148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,137,251,
/* 0x18c0 */ 136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,  3,249,
/* 0x18d0 */ 255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,114,219,233,
/* 0x18e0 */   2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,116, 36, 52,
/* 0x18f0 */ 102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,194,199,
/* 0x1900 */  68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,  4,  2,  0,
/* 0x1910 */   0,137, 92, 36, 16,233,212,250,255,255,131,108, 36, 76,  6,233,
/* 0x1920 */ 177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,
/* 0x1930 */ 232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233, 16,255,255,
/* 0x1940 */ 255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,
/* 0x1950 */ 129,251,255,255,255,  0,102,137,151,176,  1,  0,  0, 15,134,165,
/* 0x1960 */   0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,232, 11, 15,
/* 0x1970 */ 183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,  0,  0,137,
/* 0x1980 */ 198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x1990 */ 135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,137, 92, 36,
/* 0x19a0 */  64,233,159,254,255,255,141, 80,251,129,124, 36, 52,255,255,255,
/* 0x19b0 */   0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,193,100, 36,
/* 0x19c0 */  48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,
/* 0x19d0 */ 209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,114,  7,
/* 0x19e0 */  41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36, 96,193,227,
/* 0x19f0 */   4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,  6,  0,  0,
/* 0x1a00 */ 137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,132, 99,254,
/* 0x1a10 */ 255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68,
/* 0x1a20 */  36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36, 48, 41,198,
/* 0x1a30 */ 137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,139, 68, 36,
/* 0x1a40 */  60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233, 72,255,255,
/* 0x1a50 */ 255, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140, 36,
/* 0x1a60 */   0,255,255,255,137,236, 80, 57,204,117,251,137,236, 49,201, 43,
/* 0x1a70 */ 124, 36, 44,139, 76, 36, 48,137, 57, 43,116, 36, 36,137,116, 36,
/* 0x1a80 */  28, 97,195, 93,141,117,243, 15,183, 69,  0,141, 77,  2, 81,  1,
/* 0x1a90 */ 197,137,242,137,247,173, 41,199,137,241,173, 41,193, 81, 41,202,
/* 0x1aa0 */  82, 87,235, 95, 91,141,119, 28, 41,201,  1,206,139, 78,  4,131,
/* 0x1ab0 */  62,  1,117,246,129,126, 10, 76, 73, 78, 75,117,237,129,126, 14,
/* 0x1ac0 */  69, 68, 73, 84,117,228,139, 78, 24,137,222,106,  5,173, 80,137,
/* 0x1ad0 */ 226, 81,255,118,  4, 82, 81,173, 80,173, 86,255,213,131,196, 20,
/* 0x1ae0 */  95, 87, 87,176, 74, 15,182,192,137,225, 13,  0,  0, 12,  0,232,
/* 0x1af0 */  12,  0,  0,  0,115,  3,131,200,255,194, 12,  0,176,  4,235,229,
/* 0x1b00 */  90, 15, 52,232,156,255,255,255,102,105,108,101, 32,102,111,114,
/* 0x1b10 */ 109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10,
/* 0x1b20 */  83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,
/* 0x1b30 */ 109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,
/* 0x1b40 */  32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b50 */  76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,
/* 0x1b60 */ 102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,
/* 0x1b70 */  32, 32, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88, 32, 32, 32,
/* 0x1b80 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32,
/* 0x1b90 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1ba0 */  32, 32, 49, 32, 77, 65, 67, 72, 95, 85, 78, 67, 32, 32, 32, 32,
/* 0x1bb0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 57, 32, 32,
/* 0x1bc0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1bd0 */  32, 50, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x1be0 */  32, 48,100, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 57, 32,
/* 0x1bf0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1c00 */  32, 32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c10 */  32, 32, 48,100, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48,
/* 0x1c20 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1c30 */  83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32,
/* 0x1c40 */  32, 32, 32, 32, 48, 99, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1c50 */  49,101, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1c60 */  78, 84, 83, 10, 32, 32, 53, 32, 78, 82, 86, 50, 66, 32, 32, 32,
/* 0x1c70 */  32, 32, 32, 32, 32, 32, 48, 98, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x1c80 */  32, 48, 50, 97,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1c90 */  84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95, 68,
/* 0x1ca0 */  69, 67, 48, 48, 32, 32, 32, 32, 48, 50,101, 32, 32, 48, 32, 32,
/* 0x1cb0 */  48, 32, 32, 48, 51, 54, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1cc0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77, 65,
/* 0x1cd0 */  95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 52, 56, 32, 32, 48,
/* 0x1ce0 */  32, 32, 48, 32, 32, 48, 51, 57, 49, 32, 32, 50, 42, 42, 48, 32,
/* 0x1cf0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 76, 90,
/* 0x1d00 */  77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 51,101,
/* 0x1d10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51,100, 57, 32, 32, 50, 42,
/* 0x1d20 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57,
/* 0x1d30 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48,
/* 0x1d40 */  98, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 49, 55, 32,
/* 0x1d50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1d60 */  32, 49, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32,
/* 0x1d70 */  32, 32, 48, 49, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x1d80 */  53, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1d90 */  84, 83, 10, 32, 49, 49, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32,
/* 0x1da0 */  32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1db0 */  97, 54,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1dc0 */  78, 84, 83, 10, 32, 49, 50, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x1dd0 */  89, 32, 32, 32, 32, 32, 48, 49, 52, 32, 32, 48, 32, 32, 48, 32,
/* 0x1de0 */  32, 48, 49, 97, 54,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1df0 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 77, 65, 67, 72, 77,
/* 0x1e00 */  65, 73, 78, 90, 32, 32, 32, 32, 32, 48, 56, 53, 32, 32, 48, 32,
/* 0x1e10 */  32, 48, 32, 32, 48, 49, 97, 56, 51, 32, 32, 50, 42, 42, 48, 32,
/* 0x1e20 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76,
/* 0x1e30 */  32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e40 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65,
/* 0x1e50 */  68, 32, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x1e60 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65,
/* 0x1e70 */  67, 72, 77, 65, 73, 78, 89, 32, 48, 32, 77, 65, 67, 72, 77, 65,
/* 0x1e80 */  73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1e90 */  32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 32, 48,
/* 0x1ea0 */  32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x1eb0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72,
/* 0x1ec0 */  77, 65, 73, 78, 88, 32, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x1ed0 */  88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1ee0 */ 100, 32, 32, 77, 65, 67, 72, 95, 85, 78, 67, 32, 48, 32, 77, 65,
/* 0x1ef0 */  67, 72, 95, 85, 78, 67, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1f00 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32,
/* 0x1f10 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1f20 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78,
/* 0x1f30 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1f40 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82,
/* 0x1f50 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1f60 */  32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32,
/* 0x1f70 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48,
/* 0x1f80 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x1f90 */  77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x1fa0 */  69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1fb0 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x1fc0 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x1fd0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1fe0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77,
/* 0x1ff0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2000 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2010 */  67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x2020 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2030 */  32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 48, 32, 78, 82, 86,
/* 0x2040 */  95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x2050 */  32, 32, 32, 32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88,
/* 0x2060 */  32, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x2070 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x2080 */  32, 48, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,
/* 0x2090 */ 106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x20a0 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,
/* 0x20b0 */ 109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x20c0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x20d0 */  48, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48,
/* 0x20e0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x20f0 */  78, 68, 42, 32, 48, 32,108,122,109, 97, 95,112,114,111,112,101,
/* 0x2100 */ 114,116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32,103,
/* 0x2110 */  32, 32, 32, 32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89,
/* 0x2120 */  32, 48, 32,101,110,100, 95,100,101, 99,111,109,112,114,101,115,
/* 0x2130 */ 115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x2140 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 77, 65, 67, 72, 77,
/* 0x2150 */  65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x2160 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2170 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x2180 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x2190 */  32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 10, 10, 82, 69,
/* 0x21a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x21b0 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70,
/* 0x21c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x21d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x21e0 */  48, 48, 48, 48, 48, 99,100, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x21f0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69,
/* 0x2200 */  65, 68, 10, 48, 48, 48, 48, 48, 48, 54, 97, 32, 82, 95, 51, 56,
/* 0x2210 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 77, 65,
/* 0x2220 */  67, 72, 77, 65, 73, 78, 89, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x2230 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x2240 */  91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x2250 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2260 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2270 */  99, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x2280 */  32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48,
/* 0x2290 */  48, 48, 48, 48, 54, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x22a0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73,
/* 0x22b0 */  78, 89, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x22c0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,
/* 0x22d0 */  66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x22e0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x22f0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 97,100, 32, 82, 95,
/* 0x2300 */  51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2310 */  78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 53,
/* 0x2320 */  55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x2330 */  32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89, 10, 10, 82,
/* 0x2340 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x2350 */  83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48,
/* 0x2360 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x2370 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x2380 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95,
/* 0x2390 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x23a0 */ 108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,
/* 0x23b0 */ 116, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54,
/* 0x23c0 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x23d0 */  97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49,101,
/* 0x23e0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x23f0 */  32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48,
/* 0x2400 */  48, 48, 48, 48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,
/* 0x2420 */ 111,112,101,114,116,105,101,115, 10
};
