; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

@G1 = global i32 0
@G2 = global i32 0

declare i32 @llvm.ctlz.i32(i32, i1)
declare <2 x i8> @llvm.cttz.v2i8(<2 x i8>, i1)
declare void @use(i8)

define i1 @test0(i1 %A) {
; CHECK-LABEL: @test0(
; CHECK-NEXT:    ret i1 [[A:%.*]]
;
  %B = xor i1 %A, false
  ret i1 %B
}

define i32 @test1(i32 %A) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
  %B = xor i32 %A, 0
  ret i32 %B
}

define i1 @test2(i1 %A) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    ret i1 false
;
  %B = xor i1 %A, %A
  ret i1 %B
}

define i32 @test3(i32 %A) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i32 0
;
  %B = xor i32 %A, %A
  ret i32 %B
}

define i32 @test4(i32 %A) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret i32 -1
;
  %NotA = xor i32 -1, %A
  %B = xor i32 %A, %NotA
  ret i32 %B
}

define i32 @test5(i32 %A) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    [[R:%.*]] = and i32 [[A:%.*]], -124
; CHECK-NEXT:    ret i32 [[R]]
;
  %t1 = or i32 %A, 123
  %r = xor i32 %t1, 123
  ret i32 %r
}

define i8 @test6(i8 %A) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %B = xor i8 %A, 17
  %C = xor i8 %B, 17
  ret i8 %C
}

define i32 @test7(i32 %A, i32 %B) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    [[A1:%.*]] = and i32 [[A:%.*]], 7
; CHECK-NEXT:    [[B1:%.*]] = and i32 [[B:%.*]], 128
; CHECK-NEXT:    [[C1:%.*]] = or disjoint i32 [[A1]], [[B1]]
; CHECK-NEXT:    ret i32 [[C1]]
;
  %A1 = and i32 %A, 7
  %B1 = and i32 %B, 128
  %C1 = xor i32 %A1, %B1
  ret i32 %C1
}

define i8 @test8(i1 %c) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[FALSE:%.*]], label [[TRUE:%.*]]
; CHECK:       True:
; CHECK-NEXT:    ret i8 1
; CHECK:       False:
; CHECK-NEXT:    ret i8 3
;
  %d = xor i1 %c, true
  br i1 %d, label %True, label %False

True:
  ret i8 1

False:
  ret i8 3
}

define i1 @test9(i8 %A) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[A:%.*]], 89
; CHECK-NEXT:    ret i1 [[C]]
;
  %B = xor i8 %A, 123
  %C = icmp eq i8 %B, 34
  ret i1 %C
}

define <2 x i1> @test9vec(<2 x i8> %a) {
; CHECK-LABEL: @test9vec(
; CHECK-NEXT:    [[C:%.*]] = icmp eq <2 x i8> [[A:%.*]], splat (i8 89)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = xor <2 x i8> %a, <i8 123, i8 123>
  %c = icmp eq <2 x i8> %b, <i8 34, i8 34>
  ret <2 x i1> %c
}

define i8 @test10(i8 %A) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:    [[B:%.*]] = and i8 [[A:%.*]], 3
; CHECK-NEXT:    [[C:%.*]] = or disjoint i8 [[B]], 4
; CHECK-NEXT:    ret i8 [[C]]
;
  %B = and i8 %A, 3
  %C = xor i8 %B, 4
  ret i8 %C
}

define i8 @test11(i8 %A) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:    [[B:%.*]] = and i8 [[A:%.*]], -13
; CHECK-NEXT:    [[C:%.*]] = or disjoint i8 [[B]], 8
; CHECK-NEXT:    ret i8 [[C]]
;
  %B = or i8 %A, 12
  %C = xor i8 %B, 4
  ret i8 %C
}

define i1 @test12(i8 %A) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[A:%.*]], 4
; CHECK-NEXT:    ret i1 [[C]]
;
  %B = xor i8 %A, 4
  %c = icmp ne i8 %B, 0
  ret i1 %c
}

define <2 x i1> @test12vec(<2 x i8> %a) {
; CHECK-LABEL: @test12vec(
; CHECK-NEXT:    [[C:%.*]] = icmp ne <2 x i8> [[A:%.*]], splat (i8 4)
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %b = xor <2 x i8> %a, <i8 4, i8 4>
  %c = icmp ne <2 x i8> %b, zeroinitializer
  ret <2 x i1> %c
}

define i32 @test18(i32 %A) {
; CHECK-LABEL: @test18(
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A:%.*]], 124
; CHECK-NEXT:    ret i32 [[C]]
;
  %B = xor i32 %A, -1
  %C = sub i32 123, %B
  ret i32 %C
}

define i32 @test19(i32 %A, i32 %B) {
; CHECK-LABEL: @test19(
; CHECK-NEXT:    ret i32 [[B:%.*]]
;
  %C = xor i32 %A, %B
  %D = xor i32 %C, %A
  ret i32 %D
}

define void @test20(i32 %A, i32 %B) {
; CHECK-LABEL: @test20(
; CHECK-NEXT:    store i32 [[B:%.*]], ptr @G1, align 4
; CHECK-NEXT:    store i32 [[A:%.*]], ptr @G2, align 4
; CHECK-NEXT:    ret void
;
  %t2 = xor i32 %B, %A
  %t5 = xor i32 %t2, %B
  %t8 = xor i32 %t5, %t2
  store i32 %t8, ptr @G1
  store i32 %t5, ptr @G2
  ret void
}

define i32 @test22(i1 %X) {
; CHECK-LABEL: @test22(
; CHECK-NEXT:    [[Z:%.*]] = zext i1 [[X:%.*]] to i32
; CHECK-NEXT:    ret i32 [[Z]]
;
  %Y = xor i1 %X, true
  %Z = zext i1 %Y to i32
  %Q = xor i32 %Z, 1
  ret i32 %Q
}

; Look through a zext between xors.

define i32 @fold_zext_xor_sandwich(i1 %X) {
; CHECK-LABEL: @fold_zext_xor_sandwich(
; CHECK-NEXT:    [[Z:%.*]] = zext i1 [[X:%.*]] to i32
; CHECK-NEXT:    [[Q:%.*]] = xor i32 [[Z]], 3
; CHECK-NEXT:    ret i32 [[Q]]
;
  %Y = xor i1 %X, true
  %Z = zext i1 %Y to i32
  %Q = xor i32 %Z, 2
  ret i32 %Q
}

define <2 x i32> @fold_zext_xor_sandwich_vec(<2 x i1> %X) {
; CHECK-LABEL: @fold_zext_xor_sandwich_vec(
; CHECK-NEXT:    [[Z:%.*]] = zext <2 x i1> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[Q:%.*]] = xor <2 x i32> [[Z]], splat (i32 3)
; CHECK-NEXT:    ret <2 x i32> [[Q]]
;
  %Y = xor <2 x i1> %X, <i1 true, i1 true>
  %Z = zext <2 x i1> %Y to <2 x i32>
  %Q = xor <2 x i32> %Z, <i32 2, i32 2>
  ret <2 x i32> %Q
}

define i1 @test23(i32 %a, i32 %b) {
; CHECK-LABEL: @test23(
; CHECK-NEXT:    [[T4:%.*]] = icmp eq i32 [[B:%.*]], 0
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t2 = xor i32 %b, %a
  %t4 = icmp eq i32 %t2, %a
  ret i1 %t4
}

define i1 @test24(i32 %c, i32 %d) {
; CHECK-LABEL: @test24(
; CHECK-NEXT:    [[T4:%.*]] = icmp ne i32 [[D:%.*]], 0
; CHECK-NEXT:    ret i1 [[T4]]
;
  %t2 = xor i32 %d, %c
  %t4 = icmp ne i32 %t2, %c
  ret i1 %t4
}

define i32 @test25(i32 %g, i32 %h) {
; CHECK-LABEL: @test25(
; CHECK-NEXT:    [[T4:%.*]] = and i32 [[G:%.*]], [[H:%.*]]
; CHECK-NEXT:    ret i32 [[T4]]
;
  %h2 = xor i32 %h, -1
  %t2 = and i32 %h2, %g
  %t4 = xor i32 %t2, %g
  ret i32 %t4
}

define i32 @test27(i32 %b, i32 %c, i32 %d) {
; CHECK-LABEL: @test27(
; CHECK-NEXT:    [[T6:%.*]] = icmp eq i32 [[B:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[T7:%.*]] = zext i1 [[T6]] to i32
; CHECK-NEXT:    ret i32 [[T7]]
;
  %t2 = xor i32 %d, %b
  %t5 = xor i32 %d, %c
  %t6 = icmp eq i32 %t2, %t5
  %t7 = zext i1 %t6 to i32
  ret i32 %t7
}

define i32 @test28(i32 %indvar) {
; CHECK-LABEL: @test28(
; CHECK-NEXT:    [[T214:%.*]] = add i32 [[INDVAR:%.*]], 1
; CHECK-NEXT:    ret i32 [[T214]]
;
  %t7 = add i32 %indvar, -2147483647
  %t214 = xor i32 %t7, -2147483648
  ret i32 %t214
}

define <2 x i32> @test28vec(<2 x i32> %indvar) {
; CHECK-LABEL: @test28vec(
; CHECK-NEXT:    [[T214:%.*]] = add <2 x i32> [[INDVAR:%.*]], splat (i32 1)
; CHECK-NEXT:    ret <2 x i32> [[T214]]
;
  %t7 = add <2 x i32> %indvar, <i32 -2147483647, i32 -2147483647>
  %t214 = xor <2 x i32> %t7, <i32 -2147483648, i32 -2147483648>
  ret <2 x i32> %t214
}

define i32 @test28_sub(i32 %indvar) {
; CHECK-LABEL: @test28_sub(
; CHECK-NEXT:    [[T214:%.*]] = sub i32 1, [[INDVAR:%.*]]
; CHECK-NEXT:    ret i32 [[T214]]
;
  %t7 = sub i32 -2147483647, %indvar
  %t214 = xor i32 %t7, -2147483648
  ret i32 %t214
}

define <2 x i32> @test28_subvec(<2 x i32> %indvar) {
; CHECK-LABEL: @test28_subvec(
; CHECK-NEXT:    [[T214:%.*]] = sub <2 x i32> splat (i32 1), [[INDVAR:%.*]]
; CHECK-NEXT:    ret <2 x i32> [[T214]]
;
  %t7 = sub <2 x i32> <i32 -2147483647, i32 -2147483647>, %indvar
  %t214 = xor <2 x i32> %t7, <i32 -2147483648, i32 -2147483648>
  ret <2 x i32> %t214
}

define i32 @test29(i1 %C) {
; CHECK-LABEL: @test29(
; CHECK-NEXT:    [[V:%.*]] = select i1 [[C:%.*]], i32 915, i32 113
; CHECK-NEXT:    ret i32 [[V]]
;
  %A = select i1 %C, i32 1000, i32 10
  %V = xor i32 %A, 123
  ret i32 %V
}

define <2 x i32> @test29vec(i1 %C) {
; CHECK-LABEL: @test29vec(
; CHECK-NEXT:    [[V:%.*]] = select i1 [[C:%.*]], <2 x i32> splat (i32 915), <2 x i32> splat (i32 113)
; CHECK-NEXT:    ret <2 x i32> [[V]]
;
  %A = select i1 %C, <2 x i32> <i32 1000, i32 1000>, <2 x i32> <i32 10, i32 10>
  %V = xor <2 x i32> %A, <i32 123, i32 123>
  ret <2 x i32> %V
}

define <2 x i32> @test29vec2(i1 %C) {
; CHECK-LABEL: @test29vec2(
; CHECK-NEXT:    [[V:%.*]] = select i1 [[C:%.*]], <2 x i32> <i32 915, i32 2185>, <2 x i32> <i32 113, i32 339>
; CHECK-NEXT:    ret <2 x i32> [[V]]
;
  %A = select i1 %C, <2 x i32> <i32 1000, i32 2500>, <2 x i32> <i32 10, i32 30>
  %V = xor <2 x i32> %A, <i32 123, i32 333>
  ret <2 x i32> %V
}

define i32 @test30(i1 %which) {
; CHECK-LABEL: @test30(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[WHICH:%.*]], label [[FINAL:%.*]], label [[DELAY:%.*]]
; CHECK:       delay:
; CHECK-NEXT:    br label [[FINAL]]
; CHECK:       final:
; CHECK-NEXT:    [[A:%.*]] = phi i32 [ 915, [[ENTRY:%.*]] ], [ 113, [[DELAY]] ]
; CHECK-NEXT:    ret i32 [[A]]
;
entry:
  br i1 %which, label %final, label %delay

delay:
  br label %final

final:
  %A = phi i32 [ 1000, %entry ], [ 10, %delay ]
  %value = xor i32 %A, 123
  ret i32 %value
}

define <2 x i32> @test30vec(i1 %which) {
; CHECK-LABEL: @test30vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[WHICH:%.*]], label [[FINAL:%.*]], label [[DELAY:%.*]]
; CHECK:       delay:
; CHECK-NEXT:    br label [[FINAL]]
; CHECK:       final:
; CHECK-NEXT:    [[A:%.*]] = phi <2 x i32> [ splat (i32 915), [[ENTRY:%.*]] ], [ splat (i32 113), [[DELAY]] ]
; CHECK-NEXT:    ret <2 x i32> [[A]]
;
entry:
  br i1 %which, label %final, label %delay

delay:
  br label %final

final:
  %A = phi <2 x i32> [ <i32 1000, i32 1000>, %entry ], [ <i32 10, i32 10>, %delay ]
  %value = xor <2 x i32> %A, <i32 123, i32 123>
  ret <2 x i32> %value
}

define <2 x i32> @test30vec2(i1 %which) {
; CHECK-LABEL: @test30vec2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[WHICH:%.*]], label [[FINAL:%.*]], label [[DELAY:%.*]]
; CHECK:       delay:
; CHECK-NEXT:    br label [[FINAL]]
; CHECK:       final:
; CHECK-NEXT:    [[A:%.*]] = phi <2 x i32> [ <i32 915, i32 2185>, [[ENTRY:%.*]] ], [ <i32 113, i32 339>, [[DELAY]] ]
; CHECK-NEXT:    ret <2 x i32> [[A]]
;
entry:
  br i1 %which, label %final, label %delay

delay:
  br label %final

final:
  %A = phi <2 x i32> [ <i32 1000, i32 2500>, %entry ], [ <i32 10, i32 30>, %delay ]
  %value = xor <2 x i32> %A, <i32 123, i32 333>
  ret <2 x i32> %value
}

; B ^ (B | A) --> A & ~B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @or_xor_commute1(i32 %p1, i32 %p2) {
; CHECK-LABEL: @or_xor_commute1(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[B]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = or i32 %b, %a
  %r = xor i32 %b, %o
  ret i32 %r
}

; B ^ (B | A) --> A & ~B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @or_xor_commute2(i32 %p1, i32 %p2) {
; CHECK-LABEL: @or_xor_commute2(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[B]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = or i32 %a, %b
  %r = xor i32 %o, %b
  ret i32 %r
}

; B ^ (B | A) --> A & ~B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @or_xor_commute3(i32 %p1, i32 %p2) {
; CHECK-LABEL: @or_xor_commute3(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[B]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = or i32 %b, %a
  %r = xor i32 %o, %b
  ret i32 %r
}

; B ^ (B | A) --> A & ~B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @or_xor_commute4(i32 %p1, i32 %p2) {
; CHECK-LABEL: @or_xor_commute4(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[B]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[A]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = or i32 %a, %b
  %r = xor i32 %b, %o
  ret i32 %r
}

define i32 @or_xor_extra_use(i32 %a, i32 %b, ptr %p) {
; CHECK-LABEL: @or_xor_extra_use(
; CHECK-NEXT:    [[O:%.*]] = or i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    store i32 [[O]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[B]], [[O]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %o = or i32 %a, %b
  store i32 %o, ptr %p
  %r = xor i32 %b, %o
  ret i32 %r
}

; B ^ (B & A) --> ~A & B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @and_xor_commute1(i32 %p1, i32 %p2) {
; CHECK-LABEL: @and_xor_commute1(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[O1:%.*]] = xor i32 [[A]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[B]], [[O1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = and i32 %b, %a
  %r = xor i32 %b, %o
  ret i32 %r
}

; B ^ (B & A) --> ~A & B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @and_xor_commute2(i32 %p1, i32 %p2) {
; CHECK-LABEL: @and_xor_commute2(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[O1:%.*]] = xor i32 [[A]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[B]], [[O1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = and i32 %a, %b
  %r = xor i32 %o, %b
  ret i32 %r
}

; B ^ (B & A) --> ~A & B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @and_xor_commute3(i32 %p1, i32 %p2) {
; CHECK-LABEL: @and_xor_commute3(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[B1:%.*]] = xor i32 [[A]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[B]], [[B1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = and i32 %b, %a
  %r = xor i32 %o, %b
  ret i32 %r
}

; B ^ (B & A) --> ~A & B
; The division ops are here to thwart complexity-based canonicalization: all ops are binops.

define i32 @and_xor_commute4(i32 %p1, i32 %p2) {
; CHECK-LABEL: @and_xor_commute4(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[P1:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[P2:%.*]]
; CHECK-NEXT:    [[O1:%.*]] = xor i32 [[A]], -1
; CHECK-NEXT:    [[R:%.*]] = and i32 [[B]], [[O1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = udiv i32 42, %p1
  %b = udiv i32 42, %p2
  %o = and i32 %a, %b
  %r = xor i32 %b, %o
  ret i32 %r
}

define i32 @and_xor_extra_use(i32 %a, i32 %b, ptr %p) {
; CHECK-LABEL: @and_xor_extra_use(
; CHECK-NEXT:    [[O:%.*]] = and i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    store i32 [[O]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[B]], [[O]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %o = and i32 %a, %b
  store i32 %o, ptr %p
  %r = xor i32 %b, %o
  ret i32 %r
}

; (~X | C2) ^ C1 --> ((X & ~C2) ^ -1) ^ C1 --> (X & ~C2) ^ ~C1
; The extra use (store) is here because the simpler case
; may be transformed using demanded bits.

define i8 @xor_or_not(i8 %x, ptr %p) {
; CHECK-LABEL: @xor_or_not(
; CHECK-NEXT:    [[NX:%.*]] = xor i8 [[X:%.*]], -1
; CHECK-NEXT:    store i8 [[NX]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X]], -8
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[TMP1]], -13
; CHECK-NEXT:    ret i8 [[R]]
;
  %nx = xor i8 %x, -1
  store i8 %nx, ptr %p
  %or = or i8 %nx, 7
  %r = xor i8 %or, 12
  ret i8 %r
}

; Don't do this if the 'or' has extra uses.

define i8 @xor_or_not_uses(i8 %x, ptr %p) {
; CHECK-LABEL: @xor_or_not_uses(
; CHECK-NEXT:    [[NX:%.*]] = xor i8 [[X:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[NX]], 7
; CHECK-NEXT:    store i8 [[OR]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[OR]], 12
; CHECK-NEXT:    ret i8 [[R]]
;
  %nx = xor i8 %x, -1
  %or = or i8 %nx, 7
  store i8 %or, ptr %p
  %r = xor i8 %or, 12
  ret i8 %r
}

; (~X & C2) ^ C1 --> ((X | ~C2) ^ -1) ^ C1 --> (X | ~C2) ^ ~C1
; The extra use (store) is here because the simpler case
; may be transformed using demanded bits.

define i8 @xor_and_not(i8 %x, ptr %p) {
; CHECK-LABEL: @xor_and_not(
; CHECK-NEXT:    [[NX:%.*]] = xor i8 [[X:%.*]], -1
; CHECK-NEXT:    store i8 [[NX]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[X]], 42
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[TMP1]], 53
; CHECK-NEXT:    ret i8 [[R]]
;
  %nx = xor i8 %x, -1
  store i8 %nx, ptr %p
  %and = and i8 %nx, 42
  %r = xor i8 %and, 31
  ret i8 %r
}

; Don't do this if the 'and' has extra uses.

define i8 @xor_and_not_uses(i8 %x, ptr %p) {
; CHECK-LABEL: @xor_and_not_uses(
; CHECK-NEXT:    [[NX:%.*]] = and i8 [[X:%.*]], 42
; CHECK-NEXT:    [[AND:%.*]] = xor i8 [[NX]], 42
; CHECK-NEXT:    store i8 [[AND]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[NX]], 53
; CHECK-NEXT:    ret i8 [[R]]
;
  %nx = xor i8 %x, -1
  %and = and i8 %nx, 42
  store i8 %and, ptr %p
  %r = xor i8 %and, 31
  ret i8 %r
}

; The tests 39-47 are related to the canonicalization:
; %notx = xor i32 %x, -1
; %cmp = icmp sgt i32 %notx, %y
; %smax = select i1 %cmp, i32 %notx, i32 %y
; %res = xor i32 %smax, -1
;   =>
; %noty = xor i32 %y, -1
; %cmp2 = icmp slt %x, %noty
; %res = select i1 %cmp2, i32 %x, i32 %noty
;
; Same transformations is valid for smin/umax/umin.

define i32 @test39(i32 %x) {
; CHECK-LABEL: @test39(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.smin.i32(i32 [[X:%.*]], i32 255)
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %1 = xor i32 %x, -1
  %2 = icmp sgt i32 %1, -256
  %3 = select i1 %2, i32 %1, i32 -256
  %res = xor i32 %3, -1
  ret i32 %res
}

define i32 @test40(i32 %x, i32 %y) {
; CHECK-LABEL: @test40(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[Y:%.*]], -1
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.smin.i32(i32 [[X:%.*]], i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RES]]
;
  %notx = xor i32 %x, -1
  %cmp1 = icmp sgt i32 %notx, %y
  %smax = select i1 %cmp1, i32 %notx, i32 %y
  %res = xor i32 %smax, -1
  ret i32 %res
}

define i32 @test41(i32 %x, i32 %y) {
; CHECK-LABEL: @test41(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[Y:%.*]], -1
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.smax.i32(i32 [[X:%.*]], i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RES]]
;
  %notx = xor i32 %x, -1
  %cmp1 = icmp slt i32 %notx, %y
  %smin = select i1 %cmp1, i32 %notx, i32 %y
  %res = xor i32 %smin, -1
  ret i32 %res
}

define i32 @test42(i32 %x, i32 %y) {
; CHECK-LABEL: @test42(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[Y:%.*]], -1
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.umin.i32(i32 [[X:%.*]], i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RES]]
;
  %notx = xor i32 %x, -1
  %cmp1 = icmp ugt i32 %notx, %y
  %umax = select i1 %cmp1, i32 %notx, i32 %y
  %res = xor i32 %umax, -1
  ret i32 %res
}

define i32 @test43(i32 %x, i32 %y) {
; CHECK-LABEL: @test43(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[Y:%.*]], -1
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.umax.i32(i32 [[X:%.*]], i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[RES]]
;
  %notx = xor i32 %x, -1
  %cmp1 = icmp ult i32 %notx, %y
  %umin = select i1 %cmp1, i32 %notx, i32 %y
  %res = xor i32 %umin, -1
  ret i32 %res
}

define i32 @test44(i32 %x, i32 %y) {
; CHECK-LABEL: @test44(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 -4, [[Y:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = call i32 @llvm.umax.i32(i32 [[X:%.*]], i32 [[TMP1]])
; CHECK-NEXT:    ret i32 [[TMP2]]
;
  %z = add i32 %y, 3 ; thwart complexity-based canonicalization
  %notx = xor i32 %x, -1
  %cmp1 = icmp ult i32 %z, %notx
  %umin = select i1 %cmp1, i32 %z, i32 %notx
  %res = xor i32 %umin, -1
  ret i32 %res
}

define i32 @test45(i32 %x, i32 %y) {
; CHECK-LABEL: @test45(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @llvm.umax.i32(i32 [[Y:%.*]], i32 [[X:%.*]])
; CHECK-NEXT:    ret i32 [[TMP1]]
;
  %z = xor i32 %y, -1
  %notx = xor i32 %x, -1
  %cmp1 = icmp ult i32 %z, %notx
  %umin = select i1 %cmp1, i32 %z, i32 %notx
  %res = xor i32 %umin, -1
  ret i32 %res
}

; Check that we work with splat vectors also.
define <4 x i32> @test46(<4 x i32> %x) {
; CHECK-LABEL: @test46(
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.smin.v4i32(<4 x i32> [[X:%.*]], <4 x i32> splat (i32 255))
; CHECK-NEXT:    ret <4 x i32> [[TMP1]]
;
  %1 = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %2 = icmp sgt <4 x i32> %1, <i32 -256, i32 -256, i32 -256, i32 -256>
  %3 = select <4 x i1> %2, <4 x i32> %1, <4 x i32> <i32 -256, i32 -256, i32 -256, i32 -256>
  %4 = xor <4 x i32> %3, <i32 -1, i32 -1, i32 -1, i32 -1>
  ret <4 x i32> %4
}

; Test case when select pattern has more than one use.
define i32 @test47(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @test47(
; CHECK-NEXT:    [[NOTX:%.*]] = xor i32 [[X:%.*]], -1
; CHECK-NEXT:    [[UMAX:%.*]] = call i32 @llvm.umax.i32(i32 [[Y:%.*]], i32 [[NOTX]])
; CHECK-NEXT:    [[UMIN:%.*]] = xor i32 [[UMAX]], -1
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[UMAX]], [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[ADD]], [[UMIN]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %notx = xor i32 %x, -1
  %cmp1 = icmp ugt i32 %notx, %y
  %umax = select i1 %cmp1, i32 %notx, i32 %y
  %umin = xor i32 %umax, -1
  %add = add i32 %umax, %z
  %res = mul i32 %umin, %add
  ret i32 %res
}

define i32 @test48(i32 %x) {
; CHECK-LABEL: @test48(
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[X:%.*]], 1
; CHECK-NEXT:    [[D:%.*]] = call i32 @llvm.smin.i32(i32 [[TMP1]], i32 -1)
; CHECK-NEXT:    ret i32 [[D]]
;
  %a = sub i32 -2, %x
  %b = icmp sgt i32 %a, 0
  %c = select i1 %b, i32 %a, i32 0
  %d = xor i32 %c, -1
  ret i32 %d
}

define <2 x i32> @test48vec(<2 x i32> %x) {
; CHECK-LABEL: @test48vec(
; CHECK-NEXT:    [[TMP1:%.*]] = add <2 x i32> [[X:%.*]], splat (i32 1)
; CHECK-NEXT:    [[D:%.*]] = call <2 x i32> @llvm.smin.v2i32(<2 x i32> [[TMP1]], <2 x i32> splat (i32 -1))
; CHECK-NEXT:    ret <2 x i32> [[D]]
;
  %a = sub <2 x i32> <i32 -2, i32 -2>, %x
  %b = icmp sgt <2 x i32> %a, zeroinitializer
  %c = select <2 x i1> %b, <2 x i32> %a, <2 x i32> zeroinitializer
  %d = xor <2 x i32> %c, <i32 -1, i32 -1>
  ret <2 x i32> %d
}

define i32 @test49(i32 %x) {
; CHECK-LABEL: @test49(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 1, [[X:%.*]]
; CHECK-NEXT:    [[D:%.*]] = call i32 @llvm.smax.i32(i32 [[TMP1]], i32 0)
; CHECK-NEXT:    ret i32 [[D]]
;
  %a = add i32 %x, -2
  %b = icmp slt i32 %a, -1
  %c = select i1 %b, i32 %a, i32 -1
  %d = xor i32 %c, -1
  ret i32 %d
}

define <2 x i32> @test49vec(<2 x i32> %x) {
; CHECK-LABEL: @test49vec(
; CHECK-NEXT:    [[TMP1:%.*]] = sub <2 x i32> splat (i32 1), [[X:%.*]]
; CHECK-NEXT:    [[D:%.*]] = call <2 x i32> @llvm.smax.v2i32(<2 x i32> [[TMP1]], <2 x i32> zeroinitializer)
; CHECK-NEXT:    ret <2 x i32> [[D]]
;
  %a = add <2 x i32> %x, <i32 -2, i32 -2>
  %b = icmp slt <2 x i32> %a, <i32 -1, i32 -1>
  %c = select <2 x i1> %b, <2 x i32> %a, <2 x i32> <i32 -1, i32 -1>
  %d = xor <2 x i32> %c, <i32 -1, i32 -1>
  ret <2 x i32> %d
}

define i32 @test50(i32 %x, i32 %y) {
; CHECK-LABEL: @test50(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 1, [[X:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = add i32 [[Y:%.*]], 1
; CHECK-NEXT:    [[E:%.*]] = call i32 @llvm.smax.i32(i32 [[TMP1]], i32 [[TMP2]])
; CHECK-NEXT:    ret i32 [[E]]
;
  %a = add i32 %x, -2
  %b = sub i32 -2, %y
  %c = icmp slt i32 %a, %b
  %d = select i1 %c, i32 %a, i32 %b
  %e = xor i32 %d, -1
  ret i32 %e
}

define <2 x i32> @test50vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @test50vec(
; CHECK-NEXT:    [[TMP1:%.*]] = sub <2 x i32> splat (i32 1), [[X:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = add <2 x i32> [[Y:%.*]], splat (i32 1)
; CHECK-NEXT:    [[E:%.*]] = call <2 x i32> @llvm.smax.v2i32(<2 x i32> [[TMP1]], <2 x i32> [[TMP2]])
; CHECK-NEXT:    ret <2 x i32> [[E]]
;
  %a = add <2 x i32> %x, <i32 -2, i32 -2>
  %b = sub <2 x i32> <i32 -2, i32 -2>, %y
  %c = icmp slt <2 x i32> %a, %b
  %d = select <2 x i1> %c, <2 x i32> %a, <2 x i32> %b
  %e = xor <2 x i32> %d, <i32 -1, i32 -1>
  ret <2 x i32> %e
}

define i32 @test51(i32 %x, i32 %y) {
; CHECK-LABEL: @test51(
; CHECK-NEXT:    [[TMP1:%.*]] = sub i32 -3, [[X:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = add i32 [[Y:%.*]], -3
; CHECK-NEXT:    [[E:%.*]] = call i32 @llvm.smin.i32(i32 [[TMP1]], i32 [[TMP2]])
; CHECK-NEXT:    ret i32 [[E]]
;
  %a = add i32 %x, 2
  %b = sub i32 2, %y
  %c = icmp sgt i32 %a, %b
  %d = select i1 %c, i32 %a, i32 %b
  %e = xor i32 %d, -1
  ret i32 %e
}

define <2 x i32> @test51vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @test51vec(
; CHECK-NEXT:    [[TMP1:%.*]] = sub <2 x i32> splat (i32 -3), [[X:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = add <2 x i32> [[Y:%.*]], splat (i32 -3)
; CHECK-NEXT:    [[E:%.*]] = call <2 x i32> @llvm.smin.v2i32(<2 x i32> [[TMP1]], <2 x i32> [[TMP2]])
; CHECK-NEXT:    ret <2 x i32> [[E]]
;
  %a = add <2 x i32> %x, <i32 2, i32 2>
  %b = sub <2 x i32> <i32 2, i32 2>, %y
  %c = icmp sgt <2 x i32> %a, %b
  %d = select <2 x i1> %c, <2 x i32> %a, <2 x i32> %b
  %e = xor <2 x i32> %d, <i32 -1, i32 -1>
  ret <2 x i32> %e
}

define i4 @or_or_xor(i4 %x, i4 %y, i4 %z) {
; CHECK-LABEL: @or_or_xor(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i4 [[Z:%.*]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = xor i4 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = and i4 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %o1 = or i4 %z, %x
  %o2 = or i4 %z, %y
  %r = xor i4 %o1, %o2
  ret i4 %r
}

define i4 @or_or_xor_commute1(i4 %x, i4 %y, i4 %z) {
; CHECK-LABEL: @or_or_xor_commute1(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i4 [[Z:%.*]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = xor i4 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = and i4 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %o1 = or i4 %x, %z
  %o2 = or i4 %z, %y
  %r = xor i4 %o1, %o2
  ret i4 %r
}

define i4 @or_or_xor_commute2(i4 %x, i4 %y, i4 %z) {
; CHECK-LABEL: @or_or_xor_commute2(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i4 [[Z:%.*]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = xor i4 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = and i4 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %o1 = or i4 %z, %x
  %o2 = or i4 %y, %z
  %r = xor i4 %o1, %o2
  ret i4 %r
}

define <2 x i4> @or_or_xor_commute3(<2 x i4> %x, <2 x i4> %y, <2 x i4> %z) {
; CHECK-LABEL: @or_or_xor_commute3(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i4> [[Z:%.*]], splat (i4 -1)
; CHECK-NEXT:    [[TMP2:%.*]] = xor <2 x i4> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = and <2 x i4> [[TMP2]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i4> [[R]]
;
  %o1 = or <2 x i4> %x, %z
  %o2 = or <2 x i4> %y, %z
  %r = xor <2 x i4> %o1, %o2
  ret <2 x i4> %r
}

define i4 @or_or_xor_use1(i4 %x, i4 %y, i4 %z, ptr %p) {
; CHECK-LABEL: @or_or_xor_use1(
; CHECK-NEXT:    [[O1:%.*]] = or i4 [[Z:%.*]], [[X:%.*]]
; CHECK-NEXT:    store i4 [[O1]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[O2:%.*]] = or i4 [[Z]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = xor i4 [[O1]], [[O2]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %o1 = or i4 %z, %x
  store i4 %o1, ptr %p
  %o2 = or i4 %z, %y
  %r = xor i4 %o1, %o2
  ret i4 %r
}

define i4 @or_or_xor_use2(i4 %x, i4 %y, i4 %z, ptr %p) {
; CHECK-LABEL: @or_or_xor_use2(
; CHECK-NEXT:    [[O1:%.*]] = or i4 [[Z:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[O2:%.*]] = or i4 [[Z]], [[Y:%.*]]
; CHECK-NEXT:    store i4 [[O2]], ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[R:%.*]] = xor i4 [[O1]], [[O2]]
; CHECK-NEXT:    ret i4 [[R]]
;
  %o1 = or i4 %z, %x
  %o2 = or i4 %z, %y
  store i4 %o2, ptr %p
  %r = xor i4 %o1, %o2
  ret i4 %r
}

; PR32706 - https://bugs.llvm.org/show_bug.cgi?id=32706
; Pin an xor constant operand to -1 if possible because 'not' is better for SCEV and codegen.

define i32 @not_is_canonical(i32 %x, i32 %y) {
; CHECK-LABEL: @not_is_canonical(
; CHECK-NEXT:    [[SUB:%.*]] = xor i32 [[X:%.*]], -1
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[Y:%.*]], [[SUB]]
; CHECK-NEXT:    [[MUL:%.*]] = shl i32 [[ADD]], 2
; CHECK-NEXT:    ret i32 [[MUL]]
;
  %sub = xor i32 %x, 1073741823
  %add = add i32 %sub, %y
  %mul = shl i32 %add, 2
  ret i32 %mul
}

define i8 @not_shl(i8 %x) {
; CHECK-LABEL: @not_shl(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X:%.*]], -1
; CHECK-NEXT:    [[R:%.*]] = shl i8 [[TMP1]], 7
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = shl i8 %x, 7
  %r = xor i8 %a, 128
  ret i8 %r
}

define <2 x i8> @not_shl_vec(<2 x i8> %x) {
; CHECK-LABEL: @not_shl_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i8> [[X:%.*]], splat (i8 -1)
; CHECK-NEXT:    [[R:%.*]] = shl <2 x i8> [[TMP1]], splat (i8 5)
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %a = shl <2 x i8> %x, <i8 5, i8 5>
  %r = xor <2 x i8> %a, <i8 224, i8 224>
  ret <2 x i8> %r
}

; negative test

define i8 @not_shl_extra_use(i8 %x) {
; CHECK-LABEL: @not_shl_extra_use(
; CHECK-NEXT:    [[A:%.*]] = shl i8 [[X:%.*]], 7
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[A]], -128
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = shl i8 %x, 7
  call void @use(i8 %a)
  %r = xor i8 %a, 128
  ret i8 %r
}

; negative test

define i8 @not_shl_wrong_const(i8 %x) {
; CHECK-LABEL: @not_shl_wrong_const(
; CHECK-NEXT:    [[A:%.*]] = shl i8 [[X:%.*]], 6
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[A]], -128
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = shl i8 %x, 6
  %r = xor i8 %a, 128
  ret i8 %r
}

define i8 @not_lshr(i8 %x) {
; CHECK-LABEL: @not_lshr(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i8 [[X:%.*]], -1
; CHECK-NEXT:    [[R:%.*]] = lshr i8 [[TMP1]], 5
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = lshr i8 %x, 5
  %r = xor i8 %a, 7
  ret i8 %r
}

define <2 x i8> @not_lshr_vec(<2 x i8> %x) {
; CHECK-LABEL: @not_lshr_vec(
; CHECK-NEXT:    [[ISNOTNEG:%.*]] = icmp sgt <2 x i8> [[X:%.*]], splat (i8 -1)
; CHECK-NEXT:    [[R:%.*]] = zext <2 x i1> [[ISNOTNEG]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %a = lshr <2 x i8> %x, <i8 7, i8 7>
  %r = xor <2 x i8> %a, <i8 1, i8 1>
  ret <2 x i8> %r
}

; negative test

define i8 @not_lshr_extra_use(i8 %x) {
; CHECK-LABEL: @not_lshr_extra_use(
; CHECK-NEXT:    [[A:%.*]] = lshr i8 [[X:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[A]], 7
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = lshr i8 %x, 5
  call void @use(i8 %a)
  %r = xor i8 %a, 7
  ret i8 %r
}

; negative test

define i8 @not_lshr_wrong_const(i8 %x) {
; CHECK-LABEL: @not_lshr_wrong_const(
; CHECK-NEXT:    [[A:%.*]] = lshr i8 [[X:%.*]], 5
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[A]], 3
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = lshr i8 %x, 5
  %r = xor i8 %a, 3
  ret i8 %r
}

define i8 @ashr_not(i8 %x) {
; CHECK-LABEL: @ashr_not(
; CHECK-NEXT:    [[N:%.*]] = ashr i8 [[X:%.*]], 5
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[N]], -1
; CHECK-NEXT:    ret i8 [[R]]
;
  %n = xor i8 %x, -1
  %r = ashr i8 %n, 5
  ret i8 %r
}

; Unlike the logicial shifts, 'not' is canonicalized after ashr.

define i8 @not_ashr(i8 %x) {
; CHECK-LABEL: @not_ashr(
; CHECK-NEXT:    [[A:%.*]] = ashr i8 [[X:%.*]], 5
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[A]], -1
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = ashr i8 %x, 5
  %r = xor i8 %a, -1
  ret i8 %r
}

define <2 x i8> @not_ashr_vec(<2 x i8> %x) {
; CHECK-LABEL: @not_ashr_vec(
; CHECK-NEXT:    [[ISNOTNEG:%.*]] = icmp sgt <2 x i8> [[X:%.*]], splat (i8 -1)
; CHECK-NEXT:    [[R:%.*]] = sext <2 x i1> [[ISNOTNEG]] to <2 x i8>
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %a = ashr <2 x i8> %x, <i8 7, i8 7>
  %r = xor <2 x i8> %a, <i8 -1, i8 -1>
  ret <2 x i8> %r
}

define i8 @not_ashr_extra_use(i8 %x) {
; CHECK-LABEL: @not_ashr_extra_use(
; CHECK-NEXT:    [[A:%.*]] = ashr i8 [[X:%.*]], 5
; CHECK-NEXT:    call void @use(i8 [[A]])
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[A]], -1
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = ashr i8 %x, 5
  call void @use(i8 %a)
  %r = xor i8 %a, -1
  ret i8 %r
}

define i8 @not_ashr_wrong_const(i8 %x) {
; CHECK-LABEL: @not_ashr_wrong_const(
; CHECK-NEXT:    [[A:%.*]] = ashr i8 [[X:%.*]], 5
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[A]], -2
; CHECK-NEXT:    ret i8 [[R]]
;
  %a = ashr i8 %x, 5
  %r = xor i8 %a, -2
  ret i8 %r
}

; (~A & B) ^ A --> A | B

define <2 x i32> @xor_andn_commute1(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: @xor_andn_commute1(
; CHECK-NEXT:    [[Z:%.*]] = or <2 x i32> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret <2 x i32> [[Z]]
;
  %nota = xor <2 x i32> %a, <i32 -1, i32 -1>
  %r = and <2 x i32> %nota, %b
  %z = xor <2 x i32> %r, %a
  ret <2 x i32> %z
}

; (B & ~A) ^ A --> A | B

define i33 @xor_andn_commute2(i33 %a, i33 %pb) {
; CHECK-LABEL: @xor_andn_commute2(
; CHECK-NEXT:    [[B:%.*]] = udiv i33 42, [[PB:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = or i33 [[A:%.*]], [[B]]
; CHECK-NEXT:    ret i33 [[Z]]
;
  %b = udiv i33 42, %pb ; thwart complexity-based canonicalization
  %nota = xor i33 %a, -1
  %r = and i33 %b, %nota
  %z = xor i33 %r, %a
  ret i33 %z
}

; A ^ (~A & B) --> A | B

define i32 @xor_andn_commute3(i32 %pa, i32 %b) {
; CHECK-LABEL: @xor_andn_commute3(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[PA:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = or i32 [[A]], [[B:%.*]]
; CHECK-NEXT:    ret i32 [[Z]]
;
  %a = udiv i32 42, %pa ; thwart complexity-based canonicalization
  %nota = xor i32 %a, -1
  %r = and i32 %nota, %b
  %z = xor i32 %a, %r
  ret i32 %z
}

; A ^ (B & ~A) --> A | B

define i32 @xor_andn_commute4(i32 %pa, i32 %pb) {
; CHECK-LABEL: @xor_andn_commute4(
; CHECK-NEXT:    [[A:%.*]] = udiv i32 42, [[PA:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[PB:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = or i32 [[A]], [[B]]
; CHECK-NEXT:    ret i32 [[Z]]
;
  %a = udiv i32 42, %pa ; thwart complexity-based canonicalization
  %b = udiv i32 42, %pb ; thwart complexity-based canonicalization
  %nota = xor i32 %a, -1
  %r = and i32 %b, %nota
  %z = xor i32 %a, %r
  ret i32 %z
}

; (~A | B) ^ A --> ~(A & B)

define <2 x i64> @xor_orn(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: @xor_orn(
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i64> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = xor <2 x i64> [[TMP1]], splat (i64 -1)
; CHECK-NEXT:    ret <2 x i64> [[Z]]
;
  %nota = xor <2 x i64> %a, <i64 -1, i64 -1>
  %l = or <2 x i64> %nota, %b
  %z = xor <2 x i64> %l, %a
  ret <2 x i64> %z
}

; A  ^ (~A | B) --> ~(A & B)

define i8 @xor_orn_commute1(i8 %pa, i8 %b) {
; CHECK-LABEL: @xor_orn_commute1(
; CHECK-NEXT:    [[A:%.*]] = udiv i8 42, [[PA:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[A]], [[B:%.*]]
; CHECK-NEXT:    [[Z:%.*]] = xor i8 [[TMP1]], -1
; CHECK-NEXT:    ret i8 [[Z]]
;
  %a = udiv i8 42, %pa
  %nota = xor i8 %a, -1
  %l = or i8 %nota, %b
  %z = xor i8 %a, %l
  ret i8 %z
}

; (B | ~A) ^ A --> ~(A & B)

define i32 @xor_orn_commute2(i32 %a, i32 %pb,ptr %s) {
; CHECK-LABEL: @xor_orn_commute2(
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[PB:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A:%.*]], [[B]]
; CHECK-NEXT:    [[Z:%.*]] = xor i32 [[TMP1]], -1
; CHECK-NEXT:    ret i32 [[Z]]
;
  %b = udiv i32 42, %pb
  %nota = xor i32 %a, -1
  %l = or i32 %b, %nota
  %z = xor i32 %l, %a
  ret i32 %z
}

define i32 @xor_orn_commute2_1use(i32 %a, i32 %pb,ptr %s) {
; CHECK-LABEL: @xor_orn_commute2_1use(
; CHECK-NEXT:    [[B:%.*]] = udiv i32 42, [[PB:%.*]]
; CHECK-NEXT:    [[NOTA:%.*]] = xor i32 [[A:%.*]], -1
; CHECK-NEXT:    store i32 [[NOTA]], ptr [[S:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[A]], [[B]]
; CHECK-NEXT:    [[Z:%.*]] = xor i32 [[TMP1]], -1
; CHECK-NEXT:    ret i32 [[Z]]
;
  %b = udiv i32 42, %pb
  %nota = xor i32 %a, -1
  %l = or i32 %b, %nota
  store i32 %nota, ptr %s
  %z = xor i32 %l, %a
  ret i32 %z
}

; A ^ (B | ~A) --> ~(A & B)

define i67 @xor_orn_commute3(i67 %pa, i67 %pb, ptr %s) {
; CHECK-LABEL: @xor_orn_commute3(
; CHECK-NEXT:    [[A:%.*]] = udiv i67 42, [[PA:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i67 42, [[PB:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = and i67 [[A]], [[B]]
; CHECK-NEXT:    [[Z:%.*]] = xor i67 [[TMP1]], -1
; CHECK-NEXT:    ret i67 [[Z]]
;
  %a = udiv i67 42, %pa
  %b = udiv i67 42, %pb
  %nota = xor i67 %a, -1
  %l = or i67 %b, %nota
  %z = xor i67 %a, %l
  ret i67 %z
}

define i67 @xor_orn_commute3_1use(i67 %pa, i67 %pb, ptr %s) {
; CHECK-LABEL: @xor_orn_commute3_1use(
; CHECK-NEXT:    [[A:%.*]] = udiv i67 42, [[PA:%.*]]
; CHECK-NEXT:    [[B:%.*]] = udiv i67 42, [[PB:%.*]]
; CHECK-NEXT:    [[NOTA:%.*]] = xor i67 [[A]], -1
; CHECK-NEXT:    [[L:%.*]] = or i67 [[B]], [[NOTA]]
; CHECK-NEXT:    store i67 [[L]], ptr [[S:%.*]], align 4
; CHECK-NEXT:    [[Z:%.*]] = xor i67 [[A]], [[L]]
; CHECK-NEXT:    ret i67 [[Z]]
;
  %a = udiv i67 42, %pa
  %b = udiv i67 42, %pb
  %nota = xor i67 %a, -1
  %l = or i67 %b, %nota
  store i67 %l, ptr %s
  %z = xor i67 %a, %l
  ret i67 %z
}

define i32 @xor_orn_2use(i32 %a, i32 %b, ptr %s1, ptr %s2) {
; CHECK-LABEL: @xor_orn_2use(
; CHECK-NEXT:    [[NOTA:%.*]] = xor i32 [[A:%.*]], -1
; CHECK-NEXT:    store i32 [[NOTA]], ptr [[S1:%.*]], align 4
; CHECK-NEXT:    [[L:%.*]] = or i32 [[B:%.*]], [[NOTA]]
; CHECK-NEXT:    store i32 [[L]], ptr [[S2:%.*]], align 4
; CHECK-NEXT:    [[Z:%.*]] = xor i32 [[L]], [[A]]
; CHECK-NEXT:    ret i32 [[Z]]
;
  %nota = xor i32 %a, -1
  store i32 %nota, ptr %s1
  %l = or i32 %nota, %b
  store i32 %l, ptr %s2
  %z = xor i32 %l, %a
  ret i32 %z
}

define i32 @ctlz_pow2(i32 %x) {
; CHECK-LABEL: @ctlz_pow2(
; CHECK-NEXT:    [[R:%.*]] = call range(i32 0, 33) i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    ret i32 [[R]]
;
  %n = sub i32 0, %x
  %a = and i32 %n, %x
  %z = call i32 @llvm.ctlz.i32(i32 %a, i1 true) ; 0 is poison
  %r = xor i32 %z, 31
  ret i32 %r
}

; TODO: %d is known not zero, so this should fold even with arg1 set to false.

define <2 x i8> @cttz_pow2(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @cttz_pow2(
; CHECK-NEXT:    [[S:%.*]] = shl nuw <2 x i8> splat (i8 1), [[X:%.*]]
; CHECK-NEXT:    [[D:%.*]] = udiv exact <2 x i8> [[S]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = call range(i8 0, 9) <2 x i8> @llvm.ctlz.v2i8(<2 x i8> [[D]], i1 true)
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %s = shl <2 x i8> <i8 1, i8 1>, %x
  %d = udiv exact <2 x i8> %s, %y
  %z = call <2 x i8> @llvm.cttz.v2i8(<2 x i8> %d, i1 true) ; 0 is poison
  %r = xor <2 x i8> %z, <i8 7, i8 7>
  ret <2 x i8> %r
}

; negative test - 0 input returns 63

define i32 @ctlz_pow2_or_zero(i32 %x) {
; CHECK-LABEL: @ctlz_pow2_or_zero(
; CHECK-NEXT:    [[N:%.*]] = sub i32 0, [[X:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and i32 [[X]], [[N]]
; CHECK-NEXT:    [[Z:%.*]] = call range(i32 0, 33) i32 @llvm.ctlz.i32(i32 [[A]], i1 false)
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[Z]], 31
; CHECK-NEXT:    ret i32 [[R]]
;
  %n = sub i32 0, %x
  %a = and i32 %n, %x
  %z = call i32 @llvm.ctlz.i32(i32 %a, i1 false) ; 0 is not poison
  %r = xor i32 %z, 31
  ret i32 %r
}

; negative test - must xor with (bitwidth - 1)

define i32 @ctlz_pow2_wrong_const(i32 %x) {
; CHECK-LABEL: @ctlz_pow2_wrong_const(
; CHECK-NEXT:    [[N:%.*]] = sub i32 0, [[X:%.*]]
; CHECK-NEXT:    [[A:%.*]] = and i32 [[X]], [[N]]
; CHECK-NEXT:    [[Z:%.*]] = call range(i32 0, 33) i32 @llvm.ctlz.i32(i32 [[A]], i1 true)
; CHECK-NEXT:    [[R:%.*]] = xor i32 [[Z]], 30
; CHECK-NEXT:    ret i32 [[R]]
;
  %n = sub i32 0, %x
  %a = and i32 %n, %x
  %z = call i32 @llvm.ctlz.i32(i32 %a, i1 true) ; 0 is poison
  %r = xor i32 %z, 30
  ret i32 %r
}

; Tests from PR70582
define i32 @tryFactorization_xor_ashr_lshr(i32 %a) {
; CHECK-LABEL: @tryFactorization_xor_ashr_lshr(
; CHECK-NEXT:    [[XOR:%.*]] = ashr i32 -8, [[A:%.*]]
; CHECK-NEXT:    ret i32 [[XOR]]
;
  %not = ashr i32 -3, %a
  %shr1 = lshr i32 5, %a
  %xor = xor i32 %not, %shr1
  ret i32 %xor
}

define i32 @tryFactorization_xor_lshr_ashr(i32 %a) {
; CHECK-LABEL: @tryFactorization_xor_lshr_ashr(
; CHECK-NEXT:    [[XOR:%.*]] = ashr i32 -8, [[A:%.*]]
; CHECK-NEXT:    ret i32 [[XOR]]
;
  %not = ashr i32 -3, %a
  %shr1 = lshr i32 5, %a
  %xor = xor i32 %shr1, %not
  ret i32 %xor
}

define i32 @tryFactorization_xor_ashr_lshr_negative_lhs(i32 %a) {
; CHECK-LABEL: @tryFactorization_xor_ashr_lshr_negative_lhs(
; CHECK-NEXT:    [[NOT:%.*]] = ashr i32 -3, [[A:%.*]]
; CHECK-NEXT:    [[SHR1:%.*]] = lshr i32 -5, [[A]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[NOT]], [[SHR1]]
; CHECK-NEXT:    ret i32 [[XOR]]
;
  %not = ashr i32 -3, %a
  %shr1 = lshr i32 -5, %a
  %xor = xor i32 %not, %shr1
  ret i32 %xor
}

define i32 @tryFactorization_xor_lshr_lshr(i32 %a) {
; CHECK-LABEL: @tryFactorization_xor_lshr_lshr(
; CHECK-NEXT:    [[XOR:%.*]] = lshr i32 -8, [[A:%.*]]
; CHECK-NEXT:    ret i32 [[XOR]]
;
  %not = lshr i32 -3, %a
  %shr1 = lshr i32 5, %a
  %xor = xor i32 %not, %shr1
  ret i32 %xor
}

define i32 @tryFactorization_xor_ashr_ashr(i32 %a) {
; CHECK-LABEL: @tryFactorization_xor_ashr_ashr(
; CHECK-NEXT:    [[XOR:%.*]] = lshr i32 6, [[A:%.*]]
; CHECK-NEXT:    ret i32 [[XOR]]
;
  %not = ashr i32 -3, %a
  %shr1 = ashr i32 -5, %a
  %xor = xor i32 %not, %shr1
  ret i32 %xor
}

; https://alive2.llvm.org/ce/z/SOxv-e
define i4 @PR96857_xor_with_noundef(i4  %val0, i4  %val1, i4 noundef %val2) {
; CHECK-LABEL: @PR96857_xor_with_noundef(
; CHECK-NEXT:    [[VAL4:%.*]] = and i4 [[VAL2:%.*]], [[VAL0:%.*]]
; CHECK-NEXT:    [[VAL5:%.*]] = xor i4 [[VAL2]], -1
; CHECK-NEXT:    [[VAL6:%.*]] = and i4 [[VAL1:%.*]], [[VAL5]]
; CHECK-NEXT:    [[VAL7:%.*]] = or disjoint i4 [[VAL4]], [[VAL6]]
; CHECK-NEXT:    ret i4 [[VAL7]]
;
  %val4 = and i4 %val2, %val0
  %val5 = xor i4 %val2, -1
  %val6 = and i4 %val5, %val1
  %val7 = xor i4 %val4, %val6
  ret i4 %val7
}

; https://alive2.llvm.org/ce/z/whLTaJ
define i4 @PR96857_xor_without_noundef(i4  %val0, i4  %val1, i4 %val2) {
; CHECK-LABEL: @PR96857_xor_without_noundef(
; CHECK-NEXT:    [[VAL4:%.*]] = and i4 [[VAL2:%.*]], [[VAL0:%.*]]
; CHECK-NEXT:    [[VAL5:%.*]] = xor i4 [[VAL2]], -1
; CHECK-NEXT:    [[VAL6:%.*]] = and i4 [[VAL1:%.*]], [[VAL5]]
; CHECK-NEXT:    [[VAL7:%.*]] = or i4 [[VAL4]], [[VAL6]]
; CHECK-NEXT:    ret i4 [[VAL7]]
;
  %val4 = and i4 %val2, %val0
  %val5 = xor i4 %val2, -1
  %val6 = and i4 %val5, %val1
  %val7 = xor i4 %val4, %val6
  ret i4 %val7
}

define i32 @or_disjoint_with_xor(i32 %a, i32 %b) {
; CHECK-LABEL: @or_disjoint_with_xor(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[B:%.*]]
;
entry:
  %or = or disjoint i32 %a, %b
  %xor = xor i32 %or, %a
  ret i32 %xor
}

define i32 @xor_with_or_disjoint_ab(i32 %a, i32 %b) {
; CHECK-LABEL: @xor_with_or_disjoint_ab(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[B:%.*]]
;
entry:
  %or = or disjoint i32 %a, %b
  %xor = xor i32 %a, %or
  ret i32 %xor
}

define i32 @xor_with_or_disjoint_ba(i32 %a, i32 %b) {
; CHECK-LABEL: @xor_with_or_disjoint_ba(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 [[B:%.*]]
;
entry:
  %or = or disjoint i32 %b, %a
  %xor = xor i32 %b, %or
  ret i32 %xor
}

define <2 x i32> @or_disjoint_with_xor_vec(<2 x i32> %a, < 2 x i32> %b) {
; CHECK-LABEL: @or_disjoint_with_xor_vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x i32> [[B:%.*]]
;
entry:
  %or = or disjoint <2 x i32> %a, %b
  %xor = xor <2 x i32> %or, %a
  ret <2 x i32> %xor
}

define <2 x i32> @xor_with_or_disjoint_vec(<2 x i32> %a, < 2 x i32> %b) {
; CHECK-LABEL: @xor_with_or_disjoint_vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x i32> [[B:%.*]]
;
entry:
  %or = or disjoint <2 x i32> %a, %b
  %xor = xor <2 x i32> %a, %or
  ret <2 x i32> %xor
}

define i32 @select_or_disjoint_xor(i32 %a, i1 %c) {
; CHECK-LABEL: @select_or_disjoint_xor(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S:%.*]] = select i1 [[C:%.*]], i32 0, i32 4
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[A:%.*]], 4
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i32 [[S]], [[SHL]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[OR]], 4
; CHECK-NEXT:    ret i32 [[XOR]]
;
entry:
  %s = select i1 %c, i32 0, i32 4
  %shl = shl i32 %a, 4
  %or = or disjoint i32 %s, %shl
  %xor = xor i32 %or, 4
  ret i32 %xor
}

define <2 x i32> @select_or_disjoint_xor_vec(<2 x i32> %a, i1 %c) {
; CHECK-LABEL: @select_or_disjoint_xor_vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S:%.*]] = select i1 [[C:%.*]], <2 x i32> zeroinitializer, <2 x i32> splat (i32 4)
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i32> [[A:%.*]], splat (i32 4)
; CHECK-NEXT:    [[OR:%.*]] = or disjoint <2 x i32> [[S]], [[SHL]]
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i32> [[OR]], splat (i32 4)
; CHECK-NEXT:    ret <2 x i32> [[XOR]]
;
entry:
  %s = select i1 %c, <2 x i32> <i32 0, i32 0>, <2 x i32> <i32 4, i32 4>
  %shl = shl <2 x i32> %a, <i32 4, i32 4>
  %or = or <2 x i32> %s, %shl
  %xor = xor <2 x i32> %or, <i32 4, i32 4>
  ret <2 x i32> %xor
}

define i32 @select_or_disjoint_or(i32 %a, i1 %c) {
; CHECK-LABEL: @select_or_disjoint_or(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S:%.*]] = select i1 [[C:%.*]], i32 0, i32 4
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[A:%.*]], 4
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i32 [[S]], [[SHL]]
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw i32 [[OR]], 4
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  %s = select i1 %c, i32 0, i32 4
  %shl = shl i32 %a, 4
  %or = or disjoint i32 %s, %shl
  %add = add i32 %or, 4
  ret i32 %add
}

define <2 x i32> @select_or_disjoint_or_vec(<2 x i32> %a, i1 %c) {
; CHECK-LABEL: @select_or_disjoint_or_vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S:%.*]] = select i1 [[C:%.*]], <2 x i32> zeroinitializer, <2 x i32> splat (i32 4)
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i32> [[A:%.*]], splat (i32 4)
; CHECK-NEXT:    [[OR:%.*]] = or disjoint <2 x i32> [[S]], [[SHL]]
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw <2 x i32> [[OR]], splat (i32 4)
; CHECK-NEXT:    ret <2 x i32> [[ADD]]
;
entry:
  %s = select i1 %c, <2 x i32> <i32 0, i32 0>, <2 x i32> <i32 4, i32 4>
  %shl = shl <2 x i32> %a, <i32 4, i32 4>
  %or = or <2 x i32> %s, %shl
  %add = add <2 x i32> %or, <i32 4, i32 4>
  ret <2 x i32> %add
}

define i32 @or_multi_use_disjoint_with_xor(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: @or_multi_use_disjoint_with_xor(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[OR:%.*]] = or disjoint i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[OR]], [[C:%.*]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[OR]], [[XOR]]
; CHECK-NEXT:    ret i32 [[ADD]]
;
entry:
  %or = or disjoint i32 %a, %b
  %xor = xor i32 %or, %c
  %add = add i32 %or, %xor
  ret i32 %add
}

define <2 x i32> @or_multi_use_disjoint_with_xor_vec(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c) {
; CHECK-LABEL: @or_multi_use_disjoint_with_xor_vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[OR:%.*]] = or disjoint <2 x i32> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[XOR:%.*]] = xor <2 x i32> [[OR]], [[C:%.*]]
; CHECK-NEXT:    [[ADD:%.*]] = add <2 x i32> [[OR]], [[XOR]]
; CHECK-NEXT:    ret <2 x i32> [[ADD]]
;
entry:
  %or = or disjoint <2 x i32> %a, %b
  %xor = xor <2 x i32> %or, %c
  %add = add <2 x i32> %or, %xor
  ret <2 x i32> %add
}

define i32 @add_with_or(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: @add_with_or(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[ADD]], [[C:%.*]]
; CHECK-NEXT:    ret i32 [[OR]]
;
entry:
  %add = add i32 %a, %b
  %or = or i32 %add, %c
  ret i32 %or
}

define <2 x i32> @add_with_or_vec(<2 x i32> %a, <2 x i32> %b, <2 x i32> %c) {
; CHECK-LABEL: @add_with_or_vec(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add <2 x i32> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i32> [[ADD]], [[C:%.*]]
; CHECK-NEXT:    ret <2 x i32> [[OR]]
;
entry:
  %add = add <2 x i32> %a, %b
  %or = or <2 x i32> %add, %c
  ret <2 x i32> %or
}
