; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test usage of VACC/VSCBI.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

define <16 x i8> @v16i8_subc_1(<16 x i8> %a, <16 x i8> %b) unnamed_addr {
; CHECK-LABEL: v16i8_subc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbib %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %cmp = icmp uge <16 x i8> %a, %b
  %ext = zext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %ext
}

define <16 x i8> @v16i8_subc_2(<16 x i8> %a, <16 x i8> %b) unnamed_addr {
; CHECK-LABEL: v16i8_subc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbib %v24, %v26, %v24
; CHECK-NEXT:    br %r14
  %cmp = icmp ule <16 x i8> %a, %b
  %ext = zext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %ext
}

define <16 x i8> @v16i8_addc_1(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v16i8_addc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <16 x i8> %a, %b
  %cmp = icmp ult <16 x i8> %sum, %a
  %ext = zext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %ext
}

define <16 x i8> @v16i8_addc_2(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v16i8_addc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <16 x i8> %a, %b
  %cmp = icmp ult <16 x i8> %sum, %b
  %ext = zext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %ext
}

define <16 x i8> @v16i8_addc_3(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v16i8_addc_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <16 x i8> %a, %b
  %cmp = icmp ugt <16 x i8> %a, %sum
  %ext = zext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %ext
}

define <16 x i8> @v16i8_addc_4(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v16i8_addc_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <16 x i8> %a, %b
  %cmp = icmp ugt <16 x i8> %b, %sum
  %ext = zext <16 x i1> %cmp to <16 x i8>
  ret <16 x i8> %ext
}

define <8 x i16> @v8i16_subc_1(<8 x i16> %a, <8 x i16> %b) unnamed_addr {
; CHECK-LABEL: v8i16_subc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbih %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %cmp = icmp uge <8 x i16> %a, %b
  %ext = zext <8 x i1> %cmp to <8 x i16>
  ret <8 x i16> %ext
}

define <8 x i16> @v8i16_subc_2(<8 x i16> %a, <8 x i16> %b) unnamed_addr {
; CHECK-LABEL: v8i16_subc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbih %v24, %v26, %v24
; CHECK-NEXT:    br %r14
  %cmp = icmp ule <8 x i16> %a, %b
  %ext = zext <8 x i1> %cmp to <8 x i16>
  ret <8 x i16> %ext
}

define <8 x i16> @v8i16_addc_1(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v8i16_addc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vacch %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <8 x i16> %a, %b
  %cmp = icmp ult <8 x i16> %sum, %a
  %ext = zext <8 x i1> %cmp to <8 x i16>
  ret <8 x i16> %ext
}

define <8 x i16> @v8i16_addc_2(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v8i16_addc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vacch %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <8 x i16> %a, %b
  %cmp = icmp ult <8 x i16> %sum, %b
  %ext = zext <8 x i1> %cmp to <8 x i16>
  ret <8 x i16> %ext
}

define <8 x i16> @v8i16_addc_3(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v8i16_addc_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vacch %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <8 x i16> %a, %b
  %cmp = icmp ugt <8 x i16> %a, %sum
  %ext = zext <8 x i1> %cmp to <8 x i16>
  ret <8 x i16> %ext
}

define <8 x i16> @v8i16_addc_4(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v8i16_addc_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vacch %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <8 x i16> %a, %b
  %cmp = icmp ugt <8 x i16> %b, %sum
  %ext = zext <8 x i1> %cmp to <8 x i16>
  ret <8 x i16> %ext
}

define <4 x i32> @v4i32_subc_1(<4 x i32> %a, <4 x i32> %b) unnamed_addr {
; CHECK-LABEL: v4i32_subc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbif %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %cmp = icmp uge <4 x i32> %a, %b
  %ext = zext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %ext
}

define <4 x i32> @v4i32_subc_2(<4 x i32> %a, <4 x i32> %b) unnamed_addr {
; CHECK-LABEL: v4i32_subc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbif %v24, %v26, %v24
; CHECK-NEXT:    br %r14
  %cmp = icmp ule <4 x i32> %a, %b
  %ext = zext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %ext
}

define <4 x i32> @v4i32_addc_1(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v4i32_addc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <4 x i32> %a, %b
  %cmp = icmp ult <4 x i32> %sum, %a
  %ext = zext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %ext
}

define <4 x i32> @v4i32_addc_2(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v4i32_addc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <4 x i32> %a, %b
  %cmp = icmp ult <4 x i32> %sum, %b
  %ext = zext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %ext
}

define <4 x i32> @v4i32_addc_3(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v4i32_addc_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <4 x i32> %a, %b
  %cmp = icmp ugt <4 x i32> %a, %sum
  %ext = zext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %ext
}

define <4 x i32> @v4i32_addc_4(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v4i32_addc_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <4 x i32> %a, %b
  %cmp = icmp ugt <4 x i32> %b, %sum
  %ext = zext <4 x i1> %cmp to <4 x i32>
  ret <4 x i32> %ext
}

define <2 x i64> @v2i64_subc_1(<2 x i64> %a, <2 x i64> %b) unnamed_addr {
; CHECK-LABEL: v2i64_subc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbig %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %cmp = icmp uge <2 x i64> %a, %b
  %ext = zext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %ext
}

define <2 x i64> @v2i64_subc_2(<2 x i64> %a, <2 x i64> %b) unnamed_addr {
; CHECK-LABEL: v2i64_subc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbig %v24, %v26, %v24
; CHECK-NEXT:    br %r14
  %cmp = icmp ule <2 x i64> %a, %b
  %ext = zext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %ext
}

define <2 x i64> @v2i64_addc_1(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: v2i64_addc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <2 x i64> %a, %b
  %cmp = icmp ult <2 x i64> %sum, %a
  %ext = zext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %ext
}

define <2 x i64> @v2i64_addc_2(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: v2i64_addc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <2 x i64> %a, %b
  %cmp = icmp ult <2 x i64> %sum, %b
  %ext = zext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %ext
}

define <2 x i64> @v2i64_addc_3(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: v2i64_addc_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <2 x i64> %a, %b
  %cmp = icmp ugt <2 x i64> %a, %sum
  %ext = zext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %ext
}

define <2 x i64> @v2i64_addc_4(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: v2i64_addc_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %sum = add <2 x i64> %a, %b
  %cmp = icmp ugt <2 x i64> %b, %sum
  %ext = zext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %ext
}
