; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; FIXME-TRUE16. enable gisel
; XUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-FAKE16 %s
; XUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-FAKE16 %s

define i8 @test_vector_reduce_and_v2i8(<2 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v2i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v2i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v2i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_and_b32_sdwa v1, v1, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v2i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v2i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_and_b32_sdwa v1, v1, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v2i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v2i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_and_b32_sdwa v1, v1, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v2i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v2i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b16 v0.h, 8, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v1.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v0.h, 8, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v2i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b16 v2, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v2i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v2i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b16 v0.h, 8, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v1.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v0.h, 8, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v2i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b16 v2, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v2i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.and.v2i8(<2 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_and_v3i8(<3 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v3i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v3i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v3i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v3i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v3i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v3i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v3i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v3i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v3i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v3i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v3i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v3i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v3i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v3i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.and.v3i8(<3 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_and_v4i8(<4 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v4i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v4i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v4i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v4i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v4i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v4i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v4i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v4i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v4i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v4i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v4i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v4i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v1.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v4i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v4i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.and.v4i8(<4 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_and_v8i8(<8 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v8i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v8i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v8i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v8i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v8i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v8i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v8i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v8i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v8i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v2.l, v6.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v1.h, v3.l, v7.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v8i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v8i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v8i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v2.l, v6.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v1.h, v3.l, v7.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v5.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v8i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v8i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.and.v8i8(<8 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_and_v16i8(<16 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v16i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v16i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v16i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v16i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v16i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v16i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v16i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX10-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v16i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v16i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v1.h, v5.l, v13.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v9.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v5.l, v7.l, v15.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v6.l, v14.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v2.l, v2.l, v10.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v2.h, v3.l, v11.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v3.l, v4.l, v12.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v8.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v2.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v2.l, v2.h, v5.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v16i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v16i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v16i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v1.h, v5.l, v13.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v9.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v5.l, v7.l, v15.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v6.l, v14.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v2.l, v2.l, v10.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v2.h, v3.l, v11.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v3.l, v4.l, v12.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v8.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.h, v2.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v2.l, v2.h, v5.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v1.l, v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v16i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v16i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.and.v16i8(<16 x i8> %v)
  ret i8 %res
}

define i16 @test_vector_reduce_and_v2i16(<2 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v2i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v2i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_and_v2i16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v2i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_alignbit_b32 v1, s0, v0, 16
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v2i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v2i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_alignbit_b32 v1, s4, v0, 16
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v2i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v2i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshl_or_b32 v1, s0, 16, v1
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v2i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_alignbit_b32 v1, s0, v0, 16
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v2i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v2i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_lshl_or_b32 v1, s0, 16, v1
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v2i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_alignbit_b32 v1, s0, v0, 16
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v2i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.and.v2i16(<2 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_and_v3i16(<3 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v3i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v3i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_and_v3i16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_and_v3i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_and_v3i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v3i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.h, 0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v3i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v3i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v3i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.h, 0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v3i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v3i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.and.v3i16(<3 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_and_v4i16(<4 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v4i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v4i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-GISEL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v4i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v4i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX8-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-GISEL-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_and_v4i16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_and_v4i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v4i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v4i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v4i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v4i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v4i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v4i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.and.v4i16(<4 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_and_v8i16(<8 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v8i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v8i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-GISEL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX7-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GFX7-GISEL-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v8i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v8i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v8i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v8i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v8i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v8i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v8i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v8i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v8i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v8i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v8i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v8i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.and.v8i16(<8 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_and_v16i16(<16 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v16i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v16i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-GISEL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, 0xffff, v4
; GFX7-GISEL-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v4, 0xffff, v6
; GFX7-GISEL-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; GFX7-GISEL-NEXT:    v_and_b32_e32 v5, 0xffff, v8
; GFX7-GISEL-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v5, 16, v11
; GFX7-GISEL-NEXT:    v_and_b32_e32 v6, 0xffff, v10
; GFX7-GISEL-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v6, 16, v13
; GFX7-GISEL-NEXT:    v_and_b32_e32 v7, 0xffff, v12
; GFX7-GISEL-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX7-GISEL-NEXT:    v_lshlrev_b32_e32 v7, 16, v15
; GFX7-GISEL-NEXT:    v_and_b32_e32 v8, 0xffff, v14
; GFX7-GISEL-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v16i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v16i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v16i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v16i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v16i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v16i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    v_and_b32_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_and_v16i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_and_v16i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v16i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_and_v16i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_and_v16i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v16i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %v)
  ret i16 %res
}


define i32 @test_vector_reduce_and_v2i32(<2 x i32> %v) {
; GFX7-LABEL: test_vector_reduce_and_v2i32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_and_v2i32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_and_v2i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_and_v2i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_and_v2i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_and_v2i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.and.v2i32(<2 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_and_v3i32(<3 x i32> %v) {
; GFX7-LABEL: test_vector_reduce_and_v3i32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_and_v3i32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_and_v3i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_and_v3i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_and_v3i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_and_v3i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.and.v3i32(<3 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_and_v4i32(<4 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v4i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v4i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v4i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v4i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v4i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v4i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v4i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v4i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_and_v4i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v4i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_and_v4i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v4i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_and_v8i32(<8 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v8i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v8i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v8i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v8i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v8i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v8i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v8i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v8i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_and_v8i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v8i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_and_v8i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v8i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.and.v8i32(<8 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_and_v16i32(<16 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v16i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v16i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v16i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v16i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v16i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v16i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v16i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX10-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v16i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_and_v16i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX11-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v16i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_and_v16i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX12-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v16i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.and.v16i32(<16 x i32> %v)
  ret i32 %res
}

define i64 @test_vector_reduce_and_v2i64(<2 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v2i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v2i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v2i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v2i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v2i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v2i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_and_v2i64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_and_v2i64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_and_v2i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.and.v2i64(<2 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_and_v3i64(<3 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v3i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v3i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v3i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v3i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v3i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v3i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_and_v3i64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_and_v3i64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_and_v3i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.and.v3i64(<3 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_and_v4i64(<4 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v4i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v4i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v4i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v4i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v4i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v4i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v4i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v4i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_and_v4i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v4i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_and_v4i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v4i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.and.v4i64(<4 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_and_v8i64(<8 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v8i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX7-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v8i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v8i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX8-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v8i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v8i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX9-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v8i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v8i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v8i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_and_v8i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v8i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_and_v8i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-SDAG-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v8i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-GISEL-NEXT:    v_and_b32_e32 v7, v7, v15
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.and.v8i64(<8 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_and_v16i64(<16 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_and_v16i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX7-SDAG-NEXT:    buffer_load_dword v20, off, s[0:3], s32
; GFX7-SDAG-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX7-SDAG-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX7-SDAG-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX7-SDAG-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX7-SDAG-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-SDAG-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX7-SDAG-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX7-SDAG-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX7-SDAG-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX7-SDAG-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v15, v20
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, v3, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_and_v16i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX7-GISEL-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX7-GISEL-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX7-GISEL-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX7-GISEL-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX7-GISEL-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX7-GISEL-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX7-GISEL-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX7-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX7-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX7-GISEL-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX7-GISEL-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX7-GISEL-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX7-GISEL-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX7-GISEL-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX7-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX7-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v15, v16
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v2, v3, v2
; GFX7-GISEL-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_and_v16i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX8-SDAG-NEXT:    buffer_load_dword v20, off, s[0:3], s32
; GFX8-SDAG-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX8-SDAG-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX8-SDAG-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX8-SDAG-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX8-SDAG-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX8-SDAG-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX8-SDAG-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX8-SDAG-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX8-SDAG-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX8-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v15, v20
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v2, v3, v2
; GFX8-SDAG-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_and_v16i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX8-GISEL-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX8-GISEL-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX8-GISEL-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX8-GISEL-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX8-GISEL-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX8-GISEL-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX8-GISEL-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX8-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX8-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX8-GISEL-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX8-GISEL-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX8-GISEL-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX8-GISEL-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX8-GISEL-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX8-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX8-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX8-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v15, v16
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v2, v3, v2
; GFX8-GISEL-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_and_v16i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    scratch_load_dword v31, off, s32
; GFX9-SDAG-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX9-SDAG-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX9-SDAG-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX9-SDAG-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX9-SDAG-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX9-SDAG-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX9-SDAG-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX9-SDAG-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX9-SDAG-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX9-SDAG-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX9-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v15, v31
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v2, v3, v2
; GFX9-SDAG-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_and_v16i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    scratch_load_dword v31, off, s32
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX9-GISEL-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX9-GISEL-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX9-GISEL-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX9-GISEL-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX9-GISEL-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX9-GISEL-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX9-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX9-GISEL-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX9-GISEL-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX9-GISEL-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX9-GISEL-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX9-GISEL-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX9-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX9-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v15, v31
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v7, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v2, v3, v2
; GFX9-GISEL-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_and_v16i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX10-SDAG-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX10-SDAG-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX10-SDAG-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX10-SDAG-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX10-SDAG-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX10-SDAG-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX10-SDAG-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX10-SDAG-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX10-SDAG-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX10-SDAG-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX10-SDAG-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_and_b32_e32 v10, v15, v31
; GFX10-SDAG-NEXT:    v_and_b32_e32 v7, v7, v10
; GFX10-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_and_v16i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX10-GISEL-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX10-GISEL-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX10-GISEL-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX10-GISEL-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX10-GISEL-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX10-GISEL-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX10-GISEL-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX10-GISEL-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX10-GISEL-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX10-GISEL-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX10-GISEL-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX10-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX10-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX10-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_and_b32_e32 v8, v15, v31
; GFX10-GISEL-NEXT:    v_and_b32_e32 v7, v7, v8
; GFX10-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_and_v16i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX11-SDAG-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX11-SDAG-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX11-SDAG-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX11-SDAG-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX11-SDAG-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX11-SDAG-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX11-SDAG-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX11-SDAG-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX11-SDAG-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX11-SDAG-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX11-SDAG-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v10, v15, v31
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v7, v7, v10
; GFX11-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_and_v16i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX11-GISEL-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX11-GISEL-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX11-GISEL-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX11-GISEL-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX11-GISEL-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX11-GISEL-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX11-GISEL-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX11-GISEL-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX11-GISEL-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX11-GISEL-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX11-GISEL-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX11-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX11-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX11-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v8, v15, v31
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v7, v7, v8
; GFX11-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_and_v16i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX12-SDAG-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX12-SDAG-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX12-SDAG-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX12-SDAG-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX12-SDAG-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX12-SDAG-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX12-SDAG-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX12-SDAG-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX12-SDAG-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX12-SDAG-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX12-SDAG-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-SDAG-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-SDAG-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-SDAG-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-SDAG-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x0
; GFX12-SDAG-NEXT:    v_and_b32_e32 v10, v15, v31
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v7, v7, v10
; GFX12-SDAG-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_and_v16i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v16
; GFX12-GISEL-NEXT:    v_and_b32_e32 v8, v8, v24
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v17
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v18
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v19
; GFX12-GISEL-NEXT:    v_and_b32_e32 v4, v4, v20
; GFX12-GISEL-NEXT:    v_and_b32_e32 v5, v5, v21
; GFX12-GISEL-NEXT:    v_and_b32_e32 v6, v6, v22
; GFX12-GISEL-NEXT:    v_and_b32_e32 v7, v7, v23
; GFX12-GISEL-NEXT:    v_and_b32_e32 v9, v9, v25
; GFX12-GISEL-NEXT:    v_and_b32_e32 v10, v10, v26
; GFX12-GISEL-NEXT:    v_and_b32_e32 v11, v11, v27
; GFX12-GISEL-NEXT:    v_and_b32_e32 v12, v12, v28
; GFX12-GISEL-NEXT:    v_and_b32_e32 v13, v13, v29
; GFX12-GISEL-NEXT:    v_and_b32_e32 v14, v14, v30
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v8
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v9
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX12-GISEL-NEXT:    v_and_b32_e32 v4, v4, v12
; GFX12-GISEL-NEXT:    v_and_b32_e32 v5, v5, v13
; GFX12-GISEL-NEXT:    v_and_b32_e32 v6, v6, v14
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x0
; GFX12-GISEL-NEXT:    v_and_b32_e32 v8, v15, v31
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v7, v7, v8
; GFX12-GISEL-NEXT:    v_and_b32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.and.v16i64(<16 x i64> %v)
  ret i64 %res
}

declare i8 @llvm.vector.reduce.and.v2i8(<2 x i8>)
declare i8 @llvm.vector.reduce.and.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.and.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.and.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.and.v16i8(<16 x i8>)

declare i16 @llvm.vector.reduce.and.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.and.v3i16(<3 x i16>)
declare i16 @llvm.vector.reduce.and.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.and.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.and.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.and.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.and.v3i32(<3 x i32>)
declare i32 @llvm.vector.reduce.and.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.and.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.and.v16i32(<16 x i32>)

declare i64 @llvm.vector.reduce.and.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.and.v3i64(<3 x i64>)
declare i64 @llvm.vector.reduce.and.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.and.v8i64(<8 x i64>)
declare i64 @llvm.vector.reduce.and.v16i64(<16 x i64>)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-GISEL-FAKE16: {{.*}}
; GFX12-GISEL-FAKE16: {{.*}}
