; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 < %s | FileCheck --check-prefix=GFX942 %s

define <2 x i32> @uniform_masked_load_ptr1_mask_v2i32(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v2i32:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB0_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx2 v[0:1], v0, s[0:1]
; GFX942-NEXT:  .LBB0_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
  %partialmaskvec = insertelement <2 x i1> poison, i1 %mask, i64 0
  %maskvec = shufflevector <2 x i1> %partialmaskvec, <2 x i1> poison, <2 x i32> zeroinitializer
  %result = tail call <2 x i32> @llvm.masked.load.v2i32.p1(ptr addrspace(1) %ptr, i32 2, <2 x i1> %maskvec, <2 x i32> zeroinitializer)
  ret <2 x i32> %result
}

define <4 x i32> @uniform_masked_load_ptr1_mask_v4i32(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v4i32:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB1_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX942-NEXT:  .LBB1_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
  %partialmaskvec = insertelement <4 x i1> poison, i1 %mask, i64 0
  %maskvec = shufflevector <4 x i1> %partialmaskvec, <4 x i1> poison, <4 x i32> zeroinitializer
  %result = tail call <4 x i32> @llvm.masked.load.v4i32.p1(ptr addrspace(1) %ptr, i32 4, <4 x i1> %maskvec, <4 x i32> zeroinitializer)
  ret <4 x i32> %result
}

define <4 x float> @uniform_masked_load_ptr1_mask_v4f32(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v4f32:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB2_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX942-NEXT:  .LBB2_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
  %partialmaskvec = insertelement <4 x i1> poison, i1 %mask, i64 0
  %maskvec = shufflevector <4 x i1> %partialmaskvec, <4 x i1> poison, <4 x i32> zeroinitializer
  %result = tail call <4 x float> @llvm.masked.load.v4f32.p1(ptr addrspace(1) %ptr, i32 4, <4 x i1> %maskvec, <4 x float> zeroinitializer)
  ret <4 x float> %result
}

define <8 x i32> @uniform_masked_load_ptr1_mask_v8i32(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v8i32:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    v_mov_b32_e32 v4, v0
; GFX942-NEXT:    v_mov_b32_e32 v5, v0
; GFX942-NEXT:    v_mov_b32_e32 v6, v0
; GFX942-NEXT:    v_mov_b32_e32 v7, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB3_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx4 v[4:7], v0, s[0:1] offset:16
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX942-NEXT:  .LBB3_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
  %partialmaskvec = insertelement <8 x i1> poison, i1 %mask, i64 0
  %maskvec = shufflevector <8 x i1> %partialmaskvec, <8 x i1> poison, <8 x i32> zeroinitializer
  %result = tail call <8 x i32> @llvm.masked.load.v8i32.p1(ptr addrspace(1) %ptr, i32 4, <8 x i1> %maskvec, <8 x i32> zeroinitializer)
  ret <8 x i32> %result
}

define <8 x float> @uniform_masked_load_ptr1_mask_v8f32(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v8f32:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    v_mov_b32_e32 v4, v0
; GFX942-NEXT:    v_mov_b32_e32 v5, v0
; GFX942-NEXT:    v_mov_b32_e32 v6, v0
; GFX942-NEXT:    v_mov_b32_e32 v7, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB4_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx4 v[4:7], v0, s[0:1] offset:16
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX942-NEXT:  .LBB4_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
  %partialmaskvec = insertelement <8 x i1> poison, i1 %mask, i64 0
  %maskvec = shufflevector <8 x i1> %partialmaskvec, <8 x i1> poison, <8 x i32> zeroinitializer
  %result = tail call <8 x float> @llvm.masked.load.v8f32.p1(ptr addrspace(1) %ptr, i32 4, <8 x i1> %maskvec, <8 x float> zeroinitializer)
  ret <8 x float> %result
}

define <8 x i16> @uniform_masked_load_ptr1_mask_v8i16(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v8i16:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB5_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX942-NEXT:  .LBB5_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
  %partialmaskvec = insertelement <8 x i1> poison, i1 %mask, i16 0
  %maskvec = shufflevector <8 x i1> %partialmaskvec, <8 x i1> poison, <8 x i32> zeroinitializer
  %result = tail call <8 x i16> @llvm.masked.load.v8i16.p1(ptr addrspace(1) %ptr, i32 4, <8 x i1> %maskvec, <8 x i16> zeroinitializer)
  ret <8 x i16> %result
}

define <8 x half> @uniform_masked_load_ptr1_mask_v8f16(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v8f16:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB6_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX942-NEXT:  .LBB6_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
  %partialmaskvec = insertelement <8 x i1> poison, i1 %mask, i16 0
  %maskvec = shufflevector <8 x i1> %partialmaskvec, <8 x i1> poison, <8 x i32> zeroinitializer
  %result = tail call <8 x half> @llvm.masked.load.v8f16.p1(ptr addrspace(1) %ptr, i32 4, <8 x i1> %maskvec, <8 x half> zeroinitializer)
  ret <8 x half> %result
}

define <8 x bfloat> @uniform_masked_load_ptr1_mask_v8bf16(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v8bf16:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB7_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    global_load_dwordx4 v[0:3], v0, s[0:1]
; GFX942-NEXT:  .LBB7_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
 %partialmaskvec = insertelement <8 x i1> poison, i1 %mask, i32 0
 %maskvec = shufflevector <8 x i1> %partialmaskvec, <8 x i1> poison, <8 x i32> zeroinitializer
 %result = tail call <8 x bfloat> @llvm.masked.load.v8bf16.p1(ptr addrspace(1) %ptr, i32 4, <8 x i1> %maskvec, <8 x bfloat> zeroinitializer)
 ret <8 x bfloat> %result
}

define <16 x i8> @uniform_masked_load_ptr1_mask_v16i8(ptr addrspace(1) inreg nocapture readonly %ptr, i1 %mask) {
; GFX942-LABEL: uniform_masked_load_ptr1_mask_v16i8:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX942-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX942-NEXT:    v_mov_b32_e32 v15, 0
; GFX942-NEXT:    v_mov_b32_e32 v16, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v17, 0
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v6, 0
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    v_mov_b32_e32 v18, 0
; GFX942-NEXT:    v_mov_b32_e32 v9, 0
; GFX942-NEXT:    v_mov_b32_e32 v10, 0
; GFX942-NEXT:    v_mov_b32_e32 v11, 0
; GFX942-NEXT:    v_mov_b32_e32 v19, 0
; GFX942-NEXT:    v_mov_b32_e32 v13, 0
; GFX942-NEXT:    v_mov_b32_e32 v14, 0
; GFX942-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX942-NEXT:    s_cbranch_execz .LBB8_2
; GFX942-NEXT:  ; %bb.1: ; %cond.load
; GFX942-NEXT:    v_mov_b32_e32 v0, 0
; GFX942-NEXT:    global_load_dwordx4 v[16:19], v0, s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshrrev_b32_e32 v15, 24, v19
; GFX942-NEXT:    v_lshrrev_b32_e32 v14, 16, v19
; GFX942-NEXT:    v_lshrrev_b32_e32 v13, 8, v19
; GFX942-NEXT:    v_lshrrev_b32_e32 v11, 24, v18
; GFX942-NEXT:    v_lshrrev_b32_e32 v10, 16, v18
; GFX942-NEXT:    v_lshrrev_b32_e32 v9, 8, v18
; GFX942-NEXT:    v_lshrrev_b32_e32 v7, 24, v17
; GFX942-NEXT:    v_lshrrev_b32_e32 v6, 16, v17
; GFX942-NEXT:    v_lshrrev_b32_e32 v5, 8, v17
; GFX942-NEXT:    v_lshrrev_b32_e32 v3, 24, v16
; GFX942-NEXT:    v_lshrrev_b32_e32 v2, 16, v16
; GFX942-NEXT:    v_lshrrev_b32_e32 v1, 8, v16
; GFX942-NEXT:  .LBB8_2:
; GFX942-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX942-NEXT:    v_mov_b32_e32 v0, v16
; GFX942-NEXT:    v_mov_b32_e32 v4, v17
; GFX942-NEXT:    v_mov_b32_e32 v8, v18
; GFX942-NEXT:    v_mov_b32_e32 v12, v19
; GFX942-NEXT:    s_setpc_b64 s[30:31]
entry:
 %partialmaskvec = insertelement <16 x i1> poison, i1 %mask, i32 0
 %maskvec = shufflevector <16 x i1> %partialmaskvec, <16 x i1> poison, <16 x i32> zeroinitializer
 %result = tail call <16 x i8> @llvm.masked.load.v16i8.p1(ptr addrspace(1) %ptr, i32 4, <16 x i1> %maskvec, <16 x i8> zeroinitializer)
 ret <16 x i8> %result
}
