; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/XRINT/lrint/g' %s | llc -mtriple=x86_64-unknown -mattr=avx2,f16c | FileCheck %s --check-prefix=AVX
; RUN: sed 's/XRINT/llrint/g' %s | llc -mtriple=x86_64-unknown -mattr=avx2,f16c | FileCheck %s --check-prefix=AVX
; RUN: sed 's/XRINT/lrint/g' %s | llc -mtriple=x86_64-unknown -mattr=avx512fp16,avx512vl | FileCheck %s --check-prefix=FP16
; RUN: sed 's/XRINT/llrint/g' %s | llc -mtriple=x86_64-unknown -mattr=avx512fp16,avx512vl | FileCheck %s --check-prefix=FP16

define <1 x i64> @llrint_v1i64_v1f16(<1 x half> %x) {
; AVX-LABEL: llrint_v1i64_v1f16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vroundss $4, %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vcvttss2si %xmm0, %rax
; AVX-NEXT:    retq
;
; FP16-LABEL: llrint_v1i64_v1f16:
; FP16:       # %bb.0:
; FP16-NEXT:    vcvttsh2si %xmm0, %rax
; FP16-NEXT:    retq
  %a = call <1 x i64> @llvm.XRINT.v1i64.v1f16(<1 x half> %x)
  ret <1 x i64> %a
}

define <2 x i64> @llrint_v2i64_v2f16(<2 x half> %x) {
; AVX-LABEL: llrint_v2i64_v2f16:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rax
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vroundss $4, %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vcvttss2si %xmm0, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX-NEXT:    retq
;
; FP16-LABEL: llrint_v2i64_v2f16:
; FP16:       # %bb.0:
; FP16-NEXT:    vcvtph2qq %xmm0, %xmm0
; FP16-NEXT:    retq
  %a = call <2 x i64> @llvm.XRINT.v2i64.v2f16(<2 x half> %x)
  ret <2 x i64> %a
}

define <4 x i64> @llrint_v4i64_v4f16(<4 x half> %x) {
; AVX-LABEL: llrint_v4i64_v4f16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rax
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vroundss $4, %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vcvttss2si %xmm2, %rax
; AVX-NEXT:    vmovq %rax, %xmm2
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm2
; AVX-NEXT:    vroundss $4, %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vcvttss2si %xmm2, %rax
; AVX-NEXT:    vmovq %rax, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vroundss $4, %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vcvttss2si %xmm0, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    retq
;
; FP16-LABEL: llrint_v4i64_v4f16:
; FP16:       # %bb.0:
; FP16-NEXT:    vcvtph2qq %xmm0, %ymm0
; FP16-NEXT:    retq
  %a = call <4 x i64> @llvm.XRINT.v4i64.v4f16(<4 x half> %x)
  ret <4 x i64> %a
}

define <8 x i64> @llrint_v8i64_v8f16(<8 x half> %x) {
; AVX-LABEL: llrint_v8i64_v8f16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlq $48, %xmm0, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rax
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vroundss $4, %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vcvttss2si %xmm2, %rax
; AVX-NEXT:    vmovq %rax, %xmm2
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm2
; AVX-NEXT:    vroundss $4, %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vcvttss2si %xmm2, %rax
; AVX-NEXT:    vmovq %rax, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rax
; AVX-NEXT:    vmovq %rax, %xmm3
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm2
; AVX-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rax
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm0[3,3,3,3]
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rax
; AVX-NEXT:    vmovq %rax, %xmm3
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm1[0]
; AVX-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rax
; AVX-NEXT:    vmovq %rax, %xmm3
; AVX-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vroundss $4, %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vcvttss2si %xmm0, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovdqa %ymm2, %ymm0
; AVX-NEXT:    retq
;
; FP16-LABEL: llrint_v8i64_v8f16:
; FP16:       # %bb.0:
; FP16-NEXT:    vcvtph2qq %xmm0, %zmm0
; FP16-NEXT:    retq
  %a = call <8 x i64> @llvm.XRINT.v8i64.v8f16(<8 x half> %x)
  ret <8 x i64> %a
}

define <16 x i64> @llrint_v16i64_v16f16(<16 x half> %x) {
; AVX-LABEL: llrint_v16i64_v16f16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa %ymm0, %ymm2
; AVX-NEXT:    vpsrlq $48, %xmm2, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vroundss $4, %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vcvttss2si %xmm0, %rax
; AVX-NEXT:    vmovq %rax, %xmm0
; AVX-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm2[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rax
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rax
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vpsrld $16, %xmm2, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rax
; AVX-NEXT:    vmovq %rax, %xmm3
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm2[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rax
; AVX-NEXT:    vmovq %rax, %xmm1
; AVX-NEXT:    vshufps {{.*#+}} xmm3 = xmm2[3,3,3,3]
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rax
; AVX-NEXT:    vmovq %rax, %xmm3
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm1[0]
; AVX-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rax
; AVX-NEXT:    vmovq %rax, %xmm3
; AVX-NEXT:    vshufpd {{.*#+}} xmm4 = xmm2[1,0]
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vroundss $4, %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vcvttss2si %xmm4, %rax
; AVX-NEXT:    vmovq %rax, %xmm4
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX-NEXT:    vinserti128 $1, %xmm1, %ymm3, %ymm1
; AVX-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX-NEXT:    vpsrlq $48, %xmm3, %xmm2
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vroundss $4, %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vcvttss2si %xmm2, %rax
; AVX-NEXT:    vmovq %rax, %xmm2
; AVX-NEXT:    vmovshdup {{.*#+}} xmm4 = xmm3[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vroundss $4, %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vcvttss2si %xmm4, %rax
; AVX-NEXT:    vmovq %rax, %xmm4
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm4[0],xmm2[0]
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm4
; AVX-NEXT:    vroundss $4, %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vcvttss2si %xmm4, %rax
; AVX-NEXT:    vmovq %rax, %xmm4
; AVX-NEXT:    vpsrld $16, %xmm3, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vroundss $4, %xmm5, %xmm5, %xmm5
; AVX-NEXT:    vcvtps2ph $4, %xmm5, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vcvttss2si %xmm5, %rax
; AVX-NEXT:    vmovq %rax, %xmm5
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; AVX-NEXT:    vinserti128 $1, %xmm2, %ymm4, %ymm2
; AVX-NEXT:    vpsrldq {{.*#+}} xmm4 = xmm3[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vroundss $4, %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vcvttss2si %xmm4, %rax
; AVX-NEXT:    vmovq %rax, %xmm4
; AVX-NEXT:    vshufps {{.*#+}} xmm5 = xmm3[3,3,3,3]
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vroundss $4, %xmm5, %xmm5, %xmm5
; AVX-NEXT:    vcvtps2ph $4, %xmm5, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vcvttss2si %xmm5, %rax
; AVX-NEXT:    vmovq %rax, %xmm5
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm5[0],xmm4[0]
; AVX-NEXT:    vpsrldq {{.*#+}} xmm5 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vroundss $4, %xmm5, %xmm5, %xmm5
; AVX-NEXT:    vcvtps2ph $4, %xmm5, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vcvttss2si %xmm5, %rax
; AVX-NEXT:    vmovq %rax, %xmm5
; AVX-NEXT:    vshufpd {{.*#+}} xmm3 = xmm3[1,0]
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rax
; AVX-NEXT:    vmovq %rax, %xmm3
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX-NEXT:    vinserti128 $1, %xmm4, %ymm3, %ymm3
; AVX-NEXT:    retq
;
; FP16-LABEL: llrint_v16i64_v16f16:
; FP16:       # %bb.0:
; FP16-NEXT:    vcvtph2qq %xmm0, %zmm2
; FP16-NEXT:    vextractf128 $1, %ymm0, %xmm0
; FP16-NEXT:    vcvtph2qq %xmm0, %zmm1
; FP16-NEXT:    vmovaps %zmm2, %zmm0
; FP16-NEXT:    retq
  %a = call <16 x i64> @llvm.XRINT.v16i64.v16f16(<16 x half> %x)
  ret <16 x i64> %a
}

define <32 x i64> @llrint_v32i64_v32f16(<32 x half> %x) {
; AVX-LABEL: llrint_v32i64_v32f16:
; AVX:       # %bb.0:
; AVX-NEXT:    movq %rdi, %rax
; AVX-NEXT:    vpsrldq {{.*#+}} xmm2 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vroundss $4, %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX-NEXT:    vcvttss2si %xmm2, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vshufpd {{.*#+}} xmm3 = xmm1[1,0]
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX-NEXT:    vmovdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vroundss $4, %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX-NEXT:    vcvttss2si %xmm3, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm3
; AVX-NEXT:    vshufps {{.*#+}} xmm4 = xmm1[3,3,3,3]
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vroundss $4, %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vcvttss2si %xmm4, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm4
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm4
; AVX-NEXT:    vroundss $4, %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX-NEXT:    vcvttss2si %xmm4, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm4
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vroundss $4, %xmm5, %xmm5, %xmm5
; AVX-NEXT:    vcvtps2ph $4, %xmm5, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vcvttss2si %xmm5, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm5
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; AVX-NEXT:    vpsrlq $48, %xmm1, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vroundss $4, %xmm5, %xmm5, %xmm5
; AVX-NEXT:    vcvtps2ph $4, %xmm5, %xmm5
; AVX-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX-NEXT:    vcvttss2si %xmm5, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm5
; AVX-NEXT:    vmovshdup {{.*#+}} xmm6 = xmm1[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX-NEXT:    vroundss $4, %xmm6, %xmm6, %xmm6
; AVX-NEXT:    vcvtps2ph $4, %xmm6, %xmm6
; AVX-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX-NEXT:    vcvttss2si %xmm6, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm6
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm6[0],xmm5[0]
; AVX-NEXT:    vextracti128 $1, %ymm1, %xmm8
; AVX-NEXT:    vpsrldq {{.*#+}} xmm1 = xmm8[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vroundss $4, %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX-NEXT:    vcvttss2si %xmm1, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm1
; AVX-NEXT:    vshufpd {{.*#+}} xmm6 = xmm8[1,0]
; AVX-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX-NEXT:    vroundss $4, %xmm6, %xmm6, %xmm6
; AVX-NEXT:    vcvtps2ph $4, %xmm6, %xmm6
; AVX-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX-NEXT:    vcvttss2si %xmm6, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm6
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm6[0],xmm1[0]
; AVX-NEXT:    vpsrldq {{.*#+}} xmm6 = xmm8[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX-NEXT:    vroundss $4, %xmm6, %xmm6, %xmm6
; AVX-NEXT:    vcvtps2ph $4, %xmm6, %xmm6
; AVX-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX-NEXT:    vcvttss2si %xmm6, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm6
; AVX-NEXT:    vshufps {{.*#+}} xmm7 = xmm8[3,3,3,3]
; AVX-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX-NEXT:    vroundss $4, %xmm7, %xmm7, %xmm7
; AVX-NEXT:    vcvtps2ph $4, %xmm7, %xmm7
; AVX-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX-NEXT:    vcvttss2si %xmm7, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm7
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm7[0],xmm6[0]
; AVX-NEXT:    vcvtph2ps %xmm8, %xmm7
; AVX-NEXT:    vroundss $4, %xmm7, %xmm7, %xmm7
; AVX-NEXT:    vcvtps2ph $4, %xmm7, %xmm7
; AVX-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX-NEXT:    vcvttss2si %xmm7, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm7
; AVX-NEXT:    vpsrld $16, %xmm8, %xmm9
; AVX-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX-NEXT:    vroundss $4, %xmm9, %xmm9, %xmm9
; AVX-NEXT:    vcvtps2ph $4, %xmm9, %xmm9
; AVX-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX-NEXT:    vcvttss2si %xmm9, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm9
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm7 = xmm7[0],xmm9[0]
; AVX-NEXT:    vpsrlq $48, %xmm8, %xmm9
; AVX-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX-NEXT:    vroundss $4, %xmm9, %xmm9, %xmm9
; AVX-NEXT:    vcvtps2ph $4, %xmm9, %xmm9
; AVX-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX-NEXT:    vcvttss2si %xmm9, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm9
; AVX-NEXT:    vmovshdup {{.*#+}} xmm8 = xmm8[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm8, %xmm8
; AVX-NEXT:    vroundss $4, %xmm8, %xmm8, %xmm8
; AVX-NEXT:    vcvtps2ph $4, %xmm8, %xmm8
; AVX-NEXT:    vcvtph2ps %xmm8, %xmm8
; AVX-NEXT:    vcvttss2si %xmm8, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm8
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm8 = xmm8[0],xmm9[0]
; AVX-NEXT:    vpsrldq {{.*#+}} xmm9 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX-NEXT:    vroundss $4, %xmm9, %xmm9, %xmm9
; AVX-NEXT:    vcvtps2ph $4, %xmm9, %xmm9
; AVX-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX-NEXT:    vcvttss2si %xmm9, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm9
; AVX-NEXT:    vshufpd {{.*#+}} xmm10 = xmm0[1,0]
; AVX-NEXT:    vcvtph2ps %xmm10, %xmm10
; AVX-NEXT:    vroundss $4, %xmm10, %xmm10, %xmm10
; AVX-NEXT:    vcvtps2ph $4, %xmm10, %xmm10
; AVX-NEXT:    vcvtph2ps %xmm10, %xmm10
; AVX-NEXT:    vcvttss2si %xmm10, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm10
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm9 = xmm10[0],xmm9[0]
; AVX-NEXT:    vpsrldq {{.*#+}} xmm10 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm10, %xmm10
; AVX-NEXT:    vroundss $4, %xmm10, %xmm10, %xmm10
; AVX-NEXT:    vcvtps2ph $4, %xmm10, %xmm10
; AVX-NEXT:    vcvtph2ps %xmm10, %xmm10
; AVX-NEXT:    vcvttss2si %xmm10, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm10
; AVX-NEXT:    vshufps {{.*#+}} xmm11 = xmm0[3,3,3,3]
; AVX-NEXT:    vcvtph2ps %xmm11, %xmm11
; AVX-NEXT:    vroundss $4, %xmm11, %xmm11, %xmm11
; AVX-NEXT:    vcvtps2ph $4, %xmm11, %xmm11
; AVX-NEXT:    vcvtph2ps %xmm11, %xmm11
; AVX-NEXT:    vcvttss2si %xmm11, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm11
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm10 = xmm11[0],xmm10[0]
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm11
; AVX-NEXT:    vroundss $4, %xmm11, %xmm11, %xmm11
; AVX-NEXT:    vcvtps2ph $4, %xmm11, %xmm11
; AVX-NEXT:    vcvtph2ps %xmm11, %xmm11
; AVX-NEXT:    vcvttss2si %xmm11, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm11
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm12
; AVX-NEXT:    vcvtph2ps %xmm12, %xmm12
; AVX-NEXT:    vroundss $4, %xmm12, %xmm12, %xmm12
; AVX-NEXT:    vcvtps2ph $4, %xmm12, %xmm12
; AVX-NEXT:    vcvtph2ps %xmm12, %xmm12
; AVX-NEXT:    vcvttss2si %xmm12, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm12
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm11[0],xmm12[0]
; AVX-NEXT:    vpsrlq $48, %xmm0, %xmm12
; AVX-NEXT:    vcvtph2ps %xmm12, %xmm12
; AVX-NEXT:    vroundss $4, %xmm12, %xmm12, %xmm12
; AVX-NEXT:    vcvtps2ph $4, %xmm12, %xmm12
; AVX-NEXT:    vcvtph2ps %xmm12, %xmm12
; AVX-NEXT:    vcvttss2si %xmm12, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm12
; AVX-NEXT:    vmovshdup {{.*#+}} xmm13 = xmm0[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm13, %xmm13
; AVX-NEXT:    vroundss $4, %xmm13, %xmm13, %xmm13
; AVX-NEXT:    vcvtps2ph $4, %xmm13, %xmm13
; AVX-NEXT:    vcvtph2ps %xmm13, %xmm13
; AVX-NEXT:    vcvttss2si %xmm13, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm13
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm12 = xmm13[0],xmm12[0]
; AVX-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX-NEXT:    vpsrldq {{.*#+}} xmm13 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm13, %xmm13
; AVX-NEXT:    vroundss $4, %xmm13, %xmm13, %xmm13
; AVX-NEXT:    vcvtps2ph $4, %xmm13, %xmm13
; AVX-NEXT:    vcvtph2ps %xmm13, %xmm13
; AVX-NEXT:    vcvttss2si %xmm13, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm13
; AVX-NEXT:    vshufpd {{.*#+}} xmm14 = xmm0[1,0]
; AVX-NEXT:    vcvtph2ps %xmm14, %xmm14
; AVX-NEXT:    vroundss $4, %xmm14, %xmm14, %xmm14
; AVX-NEXT:    vcvtps2ph $4, %xmm14, %xmm14
; AVX-NEXT:    vcvtph2ps %xmm14, %xmm14
; AVX-NEXT:    vcvttss2si %xmm14, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm14
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm13 = xmm14[0],xmm13[0]
; AVX-NEXT:    vpsrldq {{.*#+}} xmm14 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX-NEXT:    vcvtph2ps %xmm14, %xmm14
; AVX-NEXT:    vroundss $4, %xmm14, %xmm14, %xmm14
; AVX-NEXT:    vcvtps2ph $4, %xmm14, %xmm14
; AVX-NEXT:    vcvtph2ps %xmm14, %xmm14
; AVX-NEXT:    vcvttss2si %xmm14, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm14
; AVX-NEXT:    vshufps {{.*#+}} xmm15 = xmm0[3,3,3,3]
; AVX-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX-NEXT:    vroundss $4, %xmm15, %xmm15, %xmm15
; AVX-NEXT:    vcvtps2ph $4, %xmm15, %xmm15
; AVX-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX-NEXT:    vcvttss2si %xmm15, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm15
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm14 = xmm15[0],xmm14[0]
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm15
; AVX-NEXT:    vroundss $4, %xmm15, %xmm15, %xmm15
; AVX-NEXT:    vcvtps2ph $4, %xmm15, %xmm15
; AVX-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX-NEXT:    vcvttss2si %xmm15, %rcx
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm15
; AVX-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX-NEXT:    vroundss $4, %xmm15, %xmm15, %xmm15
; AVX-NEXT:    vcvtps2ph $4, %xmm15, %xmm15
; AVX-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX-NEXT:    vcvttss2si %xmm15, %rdx
; AVX-NEXT:    vmovq %rcx, %xmm15
; AVX-NEXT:    vmovq %rdx, %xmm2
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm15[0],xmm2[0]
; AVX-NEXT:    vpsrlq $48, %xmm0, %xmm15
; AVX-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX-NEXT:    vroundss $4, %xmm15, %xmm15, %xmm15
; AVX-NEXT:    vcvtps2ph $4, %xmm15, %xmm15
; AVX-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX-NEXT:    vcvttss2si %xmm15, %rcx
; AVX-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vroundss $4, %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX-NEXT:    vcvttss2si %xmm0, %rdx
; AVX-NEXT:    vmovq %rcx, %xmm0
; AVX-NEXT:    vmovq %rdx, %xmm15
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm15[0],xmm0[0]
; AVX-NEXT:    vmovdqa %xmm0, 80(%rdi)
; AVX-NEXT:    vmovdqa %xmm2, 64(%rdi)
; AVX-NEXT:    vmovdqa %xmm14, 112(%rdi)
; AVX-NEXT:    vmovdqa %xmm13, 96(%rdi)
; AVX-NEXT:    vmovdqa %xmm12, 16(%rdi)
; AVX-NEXT:    vmovdqa %xmm11, (%rdi)
; AVX-NEXT:    vmovdqa %xmm10, 48(%rdi)
; AVX-NEXT:    vmovdqa %xmm9, 32(%rdi)
; AVX-NEXT:    vmovdqa %xmm8, 208(%rdi)
; AVX-NEXT:    vmovdqa %xmm7, 192(%rdi)
; AVX-NEXT:    vmovdqa %xmm6, 240(%rdi)
; AVX-NEXT:    vmovdqa %xmm1, 224(%rdi)
; AVX-NEXT:    vmovdqa %xmm5, 144(%rdi)
; AVX-NEXT:    vmovdqa %xmm4, 128(%rdi)
; AVX-NEXT:    vmovdqa %xmm3, 176(%rdi)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 160(%rdi)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; FP16-LABEL: llrint_v32i64_v32f16:
; FP16:       # %bb.0:
; FP16-NEXT:    vcvtph2qq %xmm0, %zmm4
; FP16-NEXT:    vextractf128 $1, %ymm0, %xmm1
; FP16-NEXT:    vcvtph2qq %xmm1, %zmm1
; FP16-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; FP16-NEXT:    vcvtph2qq %xmm0, %zmm2
; FP16-NEXT:    vextractf128 $1, %ymm0, %xmm0
; FP16-NEXT:    vcvtph2qq %xmm0, %zmm3
; FP16-NEXT:    vmovaps %zmm4, %zmm0
; FP16-NEXT:    retq
  %a = call <32 x i64> @llvm.XRINT.v32i64.v32f16(<32 x half> %x)
  ret <32 x i64> %a
}

declare <1 x i64> @llvm.lrint.v1i64.v1f16(<1 x half>)
declare <2 x i64> @llvm.lrint.v2i64.v2f16(<2 x half>)
declare <4 x i64> @llvm.lrint.v4i64.v4f16(<4 x half>)
declare <8 x i64> @llvm.lrint.v8i64.v8f16(<8 x half>)
declare <16 x i64> @llvm.lrint.v16i64.v16f16(<16 x half>)
declare <32 x i64> @llvm.lrint.v32i64.v32f16(<32 x half>)
declare <1 x i64> @llvm.llrint.v1i64.v1f16(<1 x half>)
declare <2 x i64> @llvm.llrint.v2i64.v2f16(<2 x half>)
declare <4 x i64> @llvm.llrint.v4i64.v4f16(<4 x half>)
declare <8 x i64> @llvm.llrint.v8i64.v8f16(<8 x half>)
declare <16 x i64> @llvm.llrint.v16i64.v16f16(<16 x half>)
declare <32 x i64> @llvm.llrint.v32i64.v32f16(<32 x half>)
