; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefix=GFX942 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx90a -O0 < %s | FileCheck -check-prefix=GFX90A %s

@G = addrspace(1) global <2 x i32> splat (i32 5)

define amdgpu_ps void @global_load_lds_dword_saddr(ptr addrspace(1) inreg nocapture %gptr, ptr addrspace(3) nocapture %lptr) {
; GFX942-LABEL: global_load_lds_dword_saddr:
; GFX942:       ; %bb.0: ; %main_body
; GFX942-NEXT:    v_readfirstlane_b32 s2, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    s_mov_b32 m0, s2
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    global_load_lds_dword v2, s[0:1] offset:32 nt
; GFX942-NEXT:    s_getpc_b64 s[0:1]
; GFX942-NEXT:    s_add_u32 s0, s0, G@gotpcrel32@lo+4
; GFX942-NEXT:    s_addc_u32 s1, s1, G@gotpcrel32@hi+12
; GFX942-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_mul_i32 s3, s3, 10
; GFX942-NEXT:    s_mul_i32 s2, s2, 10
; GFX942-NEXT:    v_mov_b32_e32 v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v1, s3
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_endpgm
;
; GFX90A-LABEL: global_load_lds_dword_saddr:
; GFX90A:       ; %bb.0: ; %main_body
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    s_mov_b32 s2, s0
; GFX90A-NEXT:    ; kill: def $sgpr2 killed $sgpr2 def $sgpr2_sgpr3
; GFX90A-NEXT:    s_mov_b32 s3, s1
; GFX90A-NEXT:    ; kill: def $sgpr0_sgpr1 killed $sgpr2_sgpr3
; GFX90A-NEXT:    s_getpc_b64 s[0:1]
; GFX90A-NEXT:    s_add_u32 s0, s0, G@gotpcrel32@lo+4
; GFX90A-NEXT:    s_addc_u32 s1, s1, G@gotpcrel32@hi+12
; GFX90A-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_load_dwordx2 s[8:9], s[0:1], 0x0
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, s9
; GFX90A-NEXT:    s_mov_b32 s6, 10
; GFX90A-NEXT:    s_mul_i32 s4, s4, s6
; GFX90A-NEXT:    s_mov_b32 s5, s8
; GFX90A-NEXT:    s_mul_i32 s5, s5, s6
; GFX90A-NEXT:    v_mov_b32_e32 v2, s5
; GFX90A-NEXT:    v_mov_b32_e32 v4, s4
; GFX90A-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    ; implicit-def: $sgpr4
; GFX90A-NEXT:    v_readfirstlane_b32 s4, v1
; GFX90A-NEXT:    s_mov_b32 m0, s4
; GFX90A-NEXT:    s_nop 0
; GFX90A-NEXT:    global_load_dword v0, s[2:3] offset:32 slc lds
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    global_store_dwordx2 v0, v[2:3], s[0:1]
; GFX90A-NEXT:    s_endpgm
main_body:
  %LGV = load <2 x i32>, ptr addrspace(1) @G, align 8
  %B = mul <2 x i32> %LGV, splat (i32 10)
  call void @llvm.amdgcn.global.load.lds(ptr addrspace(1) %gptr, ptr addrspace(3) %lptr, i32 4, i32 32, i32 2)
  store <2 x i32> %B, ptr addrspace(1) @G, align 8
  ret void
}
