; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=mipsel-linux-gnu < %s | FileCheck %s -check-prefix=MIPS32
; RUN: llc -mtriple=mips64el-linux-gnu < %s | FileCheck %s -check-prefix=MIPS64

define void @test_fadd(ptr %p, ptr %q) nounwind {
; MIPS32-LABEL: test_fadd:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -32
; MIPS32-NEXT:    sdc1 $f20, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $16, $4
; MIPS32-NEXT:    lhu $4, 0($5)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lhu $4, 0($16)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    mov.s $f20, $f0
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    add.s $f12, $f0, $f20
; MIPS32-NEXT:    sh $2, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f20, 24($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-LABEL: test_fadd:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-NEXT:    sdc1 $f24, 24($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $ra, 16($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    move $16, $4
; MIPS64-NEXT:    lhu $4, 0($5)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    lhu $4, 0($16)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    mov.s $f24, $f0
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    add.s $f12, $f0, $f24
; MIPS64-NEXT:    sh $2, 0($16)
; MIPS64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 16($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ldc1 $f24, 24($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 32
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = fadd half %a, %b
  store half %r, ptr %p
  ret void
}

define float @test_fpext_float(ptr %p) nounwind {
; MIPS32-LABEL: test_fpext_float:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    lhu $4, 0($4)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-LABEL: test_fpext_float:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    lhu $4, 0($4)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 16
  %a = load half, ptr %p, align 2
  %r = fpext half %a to float
  ret float %r
}

define double @test_fpext_double(ptr %p) nounwind {
; MIPS32-LABEL: test_fpext_double:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    lhu $4, 0($4)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    cvt.d.s $f0, $f0
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-LABEL: test_fpext_double:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    lhu $4, 0($4)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    cvt.d.s $f0, $f0
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 16
  %a = load half, ptr %p, align 2
  %r = fpext half %a to double
  ret double %r
}

define void @test_fptrunc_float(float %f, ptr %p) nounwind {
; MIPS32-LABEL: test_fptrunc_float:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    move $16, $5
; MIPS32-NEXT:    sh $2, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-LABEL: test_fptrunc_float:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    move $16, $5
; MIPS64-NEXT:    sh $2, 0($16)
; MIPS64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 16
  %a = fptrunc float %f to half
  store half %a, ptr %p
  ret void
}

define void @test_fptrunc_double(double %d, ptr %p) nounwind {
; MIPS32-LABEL: test_fptrunc_double:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    jal __truncdfhf2
; MIPS32-NEXT:    move $16, $6
; MIPS32-NEXT:    sh $2, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-LABEL: test_fptrunc_double:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    jal __truncdfhf2
; MIPS64-NEXT:    move $16, $5
; MIPS64-NEXT:    sh $2, 0($16)
; MIPS64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 16
  %a = fptrunc double %d to half
  store half %a, ptr %p
  ret void
}

define <4 x float> @test_vec_fpext_float(ptr %p) nounwind {
; MIPS32-LABEL: test_vec_fpext_float:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -32
; MIPS32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $17, $4
; MIPS32-NEXT:    lhu $4, 6($5)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    move $16, $5
; MIPS32-NEXT:    lhu $4, 4($16)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    swc1 $f0, 12($17)
; MIPS32-NEXT:    swc1 $f0, 8($17)
; MIPS32-NEXT:    lhu $4, 2($16)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    swc1 $f0, 4($17)
; MIPS32-NEXT:    lhu $4, 0($16)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    swc1 $f0, 0($17)
; MIPS32-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-LABEL: test_vec_fpext_float:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $18, 16($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    move $16, $4
; MIPS64-NEXT:    lhu $4, 2($4)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    lhu $4, 6($16)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    mfc1 $17, $f0
; MIPS64-NEXT:    mfc1 $18, $f0
; MIPS64-NEXT:    lhu $4, 0($16)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    dsll $17, $17, 32
; MIPS64-NEXT:    mfc1 $1, $f0
; MIPS64-NEXT:    dsll $1, $1, 32
; MIPS64-NEXT:    dsrl $1, $1, 32
; MIPS64-NEXT:    or $17, $1, $17
; MIPS64-NEXT:    lhu $4, 4($16)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    dsll $18, $18, 32
; MIPS64-NEXT:    mfc1 $1, $f0
; MIPS64-NEXT:    dsll $1, $1, 32
; MIPS64-NEXT:    dsrl $1, $1, 32
; MIPS64-NEXT:    or $3, $1, $18
; MIPS64-NEXT:    move $2, $17
; MIPS64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $18, 16($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 32
  %a = load <4 x half>, ptr %p, align 8
  %b = fpext <4 x half> %a to <4 x float>
  ret <4 x float> %b
}

define <4 x double> @test_vec_fpext_double(ptr %p) nounwind {
; MIPS32-LABEL: test_vec_fpext_double:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -40
; MIPS32-NEXT:    sdc1 $f20, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $17, $4
; MIPS32-NEXT:    lhu $4, 6($5)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    move $16, $5
; MIPS32-NEXT:    lhu $4, 4($16)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    mov.s $f20, $f0
; MIPS32-NEXT:    lhu $4, 2($16)
; MIPS32-NEXT:    cvt.d.s $f0, $f0
; MIPS32-NEXT:    cvt.d.s $f2, $f20
; MIPS32-NEXT:    sdc1 $f2, 24($17)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    sdc1 $f0, 16($17)
; MIPS32-NEXT:    cvt.d.s $f0, $f0
; MIPS32-NEXT:    sdc1 $f0, 8($17)
; MIPS32-NEXT:    lhu $4, 0($16)
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    cvt.d.s $f0, $f0
; MIPS32-NEXT:    sdc1 $f0, 0($17)
; MIPS32-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f20, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 40
;
; MIPS64-LABEL: test_vec_fpext_double:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-NEXT:    sdc1 $f24, 24($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $ra, 16($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    move $17, $4
; MIPS64-NEXT:    lhu $4, 6($5)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    move $16, $5
; MIPS64-NEXT:    lhu $4, 4($16)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    mov.s $f24, $f0
; MIPS64-NEXT:    lhu $4, 2($16)
; MIPS64-NEXT:    cvt.d.s $f0, $f0
; MIPS64-NEXT:    cvt.d.s $f1, $f24
; MIPS64-NEXT:    sdc1 $f1, 24($17)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    sdc1 $f0, 16($17)
; MIPS64-NEXT:    cvt.d.s $f0, $f0
; MIPS64-NEXT:    sdc1 $f0, 8($17)
; MIPS64-NEXT:    lhu $4, 0($16)
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    cvt.d.s $f0, $f0
; MIPS64-NEXT:    sdc1 $f0, 0($17)
; MIPS64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 16($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ldc1 $f24, 24($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 32
  %a = load <4 x half>, ptr %p, align 8
  %b = fpext <4 x half> %a to <4 x double>
  ret <4 x double> %b
}

define void @test_vec_fptrunc_float(<4 x float> %a, ptr %p) nounwind {
; MIPS32-LABEL: test_vec_fptrunc_float:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -40
; MIPS32-NEXT:    sw $ra, 36($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $19, 32($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $18, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $16, $7
; MIPS32-NEXT:    move $17, $5
; MIPS32-NEXT:    move $18, $4
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    mtc1 $6, $f12
; MIPS32-NEXT:    move $19, $2
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    mtc1 $16, $f12
; MIPS32-NEXT:    mtc1 $17, $f12
; MIPS32-NEXT:    lw $16, 56($sp)
; MIPS32-NEXT:    sh $2, 6($16)
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    sh $19, 4($16)
; MIPS32-NEXT:    sh $2, 2($16)
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    mtc1 $18, $f12
; MIPS32-NEXT:    sh $2, 0($16)
; MIPS32-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $18, 28($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $19, 32($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 36($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 40
;
; MIPS64-LABEL: test_vec_fptrunc_float:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -48
; MIPS64-NEXT:    sd $ra, 40($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $19, 32($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $18, 24($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $17, 16($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    move $16, $6
; MIPS64-NEXT:    move $17, $5
; MIPS64-NEXT:    move $18, $4
; MIPS64-NEXT:    sll $1, $18, 0
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    mtc1 $1, $f12
; MIPS64-NEXT:    move $19, $2
; MIPS64-NEXT:    sll $1, $17, 0
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    mtc1 $1, $f12
; MIPS64-NEXT:    dsrl $1, $17, 32
; MIPS64-NEXT:    sll $1, $1, 0
; MIPS64-NEXT:    mtc1 $1, $f12
; MIPS64-NEXT:    sh $2, 4($16)
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    sh $19, 0($16)
; MIPS64-NEXT:    sh $2, 6($16)
; MIPS64-NEXT:    dsrl $1, $18, 32
; MIPS64-NEXT:    sll $1, $1, 0
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    mtc1 $1, $f12
; MIPS64-NEXT:    sh $2, 2($16)
; MIPS64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $17, 16($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $18, 24($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $19, 32($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 40($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 48
  %b = fptrunc <4 x float> %a to <4 x half>
  store <4 x half> %b, ptr %p, align 8
  ret void
}

define void @test_vec_fptrunc_double(<4 x double> %a, ptr %p) nounwind {
; MIPS32-LABEL: test_vec_fptrunc_double:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -72
; MIPS32-NEXT:    sw $ra, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $19, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $18, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $17, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $16, $5
; MIPS32-NEXT:    move $17, $4
; MIPS32-NEXT:    lw $1, 92($sp)
; MIPS32-NEXT:    sw $1, 36($sp)
; MIPS32-NEXT:    lw $1, 88($sp)
; MIPS32-NEXT:    sw $1, 32($sp)
; MIPS32-NEXT:    lw $1, 96($sp)
; MIPS32-NEXT:    lw $2, 100($sp)
; MIPS32-NEXT:    sw $2, 44($sp)
; MIPS32-NEXT:    sw $1, 40($sp)
; MIPS32-NEXT:    ldc1 $f12, 32($sp)
; MIPS32-NEXT:    sw $7, 28($sp)
; MIPS32-NEXT:    jal __truncdfhf2
; MIPS32-NEXT:    sw $6, 24($sp)
; MIPS32-NEXT:    move $18, $2
; MIPS32-NEXT:    jal __truncdfhf2
; MIPS32-NEXT:    ldc1 $f12, 40($sp)
; MIPS32-NEXT:    ldc1 $f12, 24($sp)
; MIPS32-NEXT:    lw $19, 104($sp)
; MIPS32-NEXT:    sh $2, 6($19)
; MIPS32-NEXT:    jal __truncdfhf2
; MIPS32-NEXT:    sh $18, 4($19)
; MIPS32-NEXT:    sh $2, 2($19)
; MIPS32-NEXT:    sw $16, 20($sp)
; MIPS32-NEXT:    sw $17, 16($sp)
; MIPS32-NEXT:    jal __truncdfhf2
; MIPS32-NEXT:    ldc1 $f12, 16($sp)
; MIPS32-NEXT:    sh $2, 0($19)
; MIPS32-NEXT:    lw $16, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $17, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $18, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $19, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 72
;
; MIPS64-LABEL: test_vec_fptrunc_double:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -48
; MIPS64-NEXT:    sd $ra, 40($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $20, 32($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $19, 24($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $18, 16($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    move $16, $8
; MIPS64-NEXT:    move $17, $7
; MIPS64-NEXT:    move $18, $5
; MIPS64-NEXT:    move $19, $4
; MIPS64-NEXT:    jal __truncdfhf2
; MIPS64-NEXT:    dmtc1 $6, $f12
; MIPS64-NEXT:    move $20, $2
; MIPS64-NEXT:    jal __truncdfhf2
; MIPS64-NEXT:    dmtc1 $17, $f12
; MIPS64-NEXT:    dmtc1 $18, $f12
; MIPS64-NEXT:    sh $2, 6($16)
; MIPS64-NEXT:    jal __truncdfhf2
; MIPS64-NEXT:    sh $20, 4($16)
; MIPS64-NEXT:    sh $2, 2($16)
; MIPS64-NEXT:    jal __truncdfhf2
; MIPS64-NEXT:    dmtc1 $19, $f12
; MIPS64-NEXT:    sh $2, 0($16)
; MIPS64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $18, 16($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $19, 24($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $20, 32($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 40($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 48
  %b = fptrunc <4 x double> %a to <4 x half>
  store <4 x half> %b, ptr %p, align 8
  ret void
}

define half @test_fadd_fadd(half %a, half %b, half %c) nounwind {
; MIPS32-LABEL: test_fadd_fadd:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    addiu $sp, $sp, -40
; MIPS32-NEXT:    sdc1 $f20, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $17, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    move $16, $6
; MIPS32-NEXT:    move $17, $4
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    move $4, $5
; MIPS32-NEXT:    mov.s $f20, $f0
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    move $4, $17
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    add.s $f12, $f0, $f20
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    move $4, $2
; MIPS32-NEXT:    mov.s $f20, $f0
; MIPS32-NEXT:    jal __gnu_h2f_ieee
; MIPS32-NEXT:    move $4, $16
; MIPS32-NEXT:    jal __gnu_f2h_ieee
; MIPS32-NEXT:    add.s $f12, $f20, $f0
; MIPS32-NEXT:    lw $16, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $17, 24($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f20, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 40
;
; MIPS64-LABEL: test_fadd_fadd:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-NEXT:    sdc1 $f24, 24($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $ra, 16($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $17, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    sd $16, 0($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    move $16, $6
; MIPS64-NEXT:    move $17, $4
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    sll $4, $5, 0
; MIPS64-NEXT:    mov.s $f24, $f0
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    sll $4, $17, 0
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    add.s $f12, $f0, $f24
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    sll $4, $2, 0
; MIPS64-NEXT:    mov.s $f24, $f0
; MIPS64-NEXT:    jal __gnu_h2f_ieee
; MIPS64-NEXT:    sll $4, $16, 0
; MIPS64-NEXT:    jal __gnu_f2h_ieee
; MIPS64-NEXT:    add.s $f12, $f24, $f0
; MIPS64-NEXT:    ld $16, 0($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $17, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ld $ra, 16($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    ldc1 $f24, 24($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    daddiu $sp, $sp, 32
  %d = fadd half %a, %b
  %e = fadd half %d, %c
  ret half %e
}

define half @to_half(i16 %bits) nounwind {
; MIPS32-LABEL: to_half:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    move $2, $4
;
; MIPS64-LABEL: to_half:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    sll $2, $4, 0
  %f = bitcast i16 %bits to half
  ret half %f
}

define i16 @from_half(half %f) nounwind {
; MIPS32-LABEL: from_half:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    move $2, $4
;
; MIPS64-LABEL: from_half:
; MIPS64:       # %bb.0:
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    sll $2, $4, 0
  %bits = bitcast half %f to i16
  ret i16 %bits
}
