; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+mve.fp,+fp64 -o - -verify-machineinstrs | FileCheck %s

target triple = "thumbv8.1m.main-none-none-eabi"

; Expected to not transform
define arm_aapcs_vfpcc <2 x double> @complex_mul_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: complex_mul_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmul.f64 d5, d3, d0
; CHECK-NEXT:    vmul.f64 d4, d1, d3
; CHECK-NEXT:    vfma.f64 d5, d2, d1
; CHECK-NEXT:    vfnms.f64 d4, d2, d0
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %a.real   = shufflevector <2 x double> %a, <2 x double> poison, <1 x i32> <i32 0>
  %a.imag = shufflevector <2 x double> %a, <2 x double> poison, <1 x i32> <i32 1>
  %b.real = shufflevector <2 x double> %b, <2 x double> poison, <1 x i32> <i32 0>
  %b.imag = shufflevector <2 x double> %b, <2 x double> poison, <1 x i32> <i32 1>
  %0 = fmul fast <1 x double> %b.imag, %a.real
  %1 = fmul fast <1 x double> %b.real, %a.imag
  %2 = fadd fast <1 x double> %1, %0
  %3 = fmul fast <1 x double> %b.real, %a.real
  %4 = fmul fast <1 x double> %a.imag, %b.imag
  %5 = fsub fast <1 x double> %3, %4
  %interleaved.vec = shufflevector <1 x double> %5, <1 x double> %2, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %interleaved.vec
}

; Expected to not transform
define arm_aapcs_vfpcc <4 x double> @complex_mul_v4f64(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: complex_mul_v4f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vmul.f64 d9, d7, d2
; CHECK-NEXT:    vmov q5, q0
; CHECK-NEXT:    vmul.f64 d8, d3, d7
; CHECK-NEXT:    vfma.f64 d9, d6, d3
; CHECK-NEXT:    vfnms.f64 d8, d6, d2
; CHECK-NEXT:    vmul.f64 d1, d5, d10
; CHECK-NEXT:    vmov q1, q4
; CHECK-NEXT:    vmul.f64 d0, d11, d5
; CHECK-NEXT:    vfma.f64 d1, d4, d11
; CHECK-NEXT:    vfnms.f64 d0, d4, d10
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %a.real   = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %a.imag = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %b.real = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %b.imag = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul fast <2 x double> %b.imag, %a.real
  %1 = fmul fast <2 x double> %b.real, %a.imag
  %2 = fadd fast <2 x double> %1, %0
  %3 = fmul fast <2 x double> %b.real, %a.real
  %4 = fmul fast <2 x double> %a.imag, %b.imag
  %5 = fsub fast <2 x double> %3, %4
  %interleaved.vec = shufflevector <2 x double> %5, <2 x double> %2, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}
