; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1030 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s

define half @v_maximumnum_f16(half %x, half %y) {
; GFX8-LABEL: v_maximumnum_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e32 v1, v1, v1
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call half @llvm.maximumnum.f16(half %x, half %y)
  ret half %result
}

define half @v_maximumnum_f16_nnan(half %x, half %y) {
; GFX8-LABEL: v_maximumnum_f16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan half @llvm.maximumnum.f16(half %x, half %y)
  ret half %result
}

define half @v_maximumnum_f16_1.0(half %x) {
; GFX8-LABEL: v_maximumnum_f16_1.0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v0, 1.0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_1.0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f16_e32 v0, 1.0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_1.0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f16_e32 v0, 1.0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_1.0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_1.0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, 1.0, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call half @llvm.maximumnum.f16(half %x, half 1.0)
  ret half %result
}

define bfloat @v_maximumnum_bf16(bfloat %x, bfloat %y) {
; GFX8-LABEL: v_maximumnum_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX8-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, s4, v3
; GFX8-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX9-NEXT:    v_cmp_gt_f32_e32 vcc, v2, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    s_movk_i32 s4, 0x7fff
; GFX9-NEXT:    v_add3_u32 v3, v3, v2, s4
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX9-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v2
; GFX9-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX10-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v3, v3, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX11-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v3, v3, v2, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v2, v2, v2
; GFX12-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v3, v3, v2, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc_lo
; GFX12-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX12-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX12-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call bfloat @llvm.maximumnum.bf16(bfloat %x, bfloat %y)
  ret bfloat %result
}

define bfloat @v_maximumnum_bf16_nnan(bfloat %x, bfloat %y) {
; GFX8-LABEL: v_maximumnum_bf16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_bf16_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX9-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_bf16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_bf16_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX11-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_bf16_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX12-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX12-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan bfloat @llvm.maximumnum.bf16(bfloat %x, bfloat %y)
  ret bfloat %result
}

define float @v_maximumnum_f32(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v1, v1, v1 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v1, v1, v1 :: v_dual_max_num_f32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.maximumnum.f32(float %x, float %y)
  ret float %result
}

define float @v_maximumnum_f32_nnan(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan float @llvm.maximumnum.f32(float %x, float %y)
  ret float %result
}

define double @v_maximumnum_f64(double %x, double %y) {
; GFX8-LABEL: v_maximumnum_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call double @llvm.maximumnum.f64(double %x, double %y)
  ret double %result
}

define double @v_maximumnum_f64_nnan(double %x, double %y) {
; GFX8-LABEL: v_maximumnum_f64_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f64_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f64_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f64_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f64_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan double @llvm.maximumnum.f64(double %x, double %y)
  ret double %result
}

define float @v_maximumnum_f32_1.0(float %x) {
; GFX8-LABEL: v_maximumnum_f32_1.0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_1.0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_1.0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v0, 1.0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_1.0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_1.0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, 1.0, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.maximumnum.f32(float %x, float 1.0)
  ret float %result
}

define float @v_maximumnum_f32_rhs_not_snan(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_rhs_not_snan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_rhs_not_snan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_rhs_not_snan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_rhs_not_snan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v1, v1, v1 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_rhs_not_snan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v1, v1, v1 :: v_dual_max_num_f32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon.y = call float @llvm.canonicalize.f32(float %y)
  %result = call float @llvm.maximumnum.f32(float %x, float %canon.y)
  ret float %result
}

define float @v_maximumnum_f32_lhs_not_snan(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_lhs_not_snan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_lhs_not_snan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_lhs_not_snan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_lhs_not_snan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_lhs_not_snan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon.x = call float @llvm.canonicalize.f32(float %x)
  %result = call float @llvm.maximumnum.f32(float %canon.x, float %y)
  ret float %result
}

define float @v_maximumnum_f32_both_operands_not_snan(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_both_operands_not_snan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_both_operands_not_snan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_both_operands_not_snan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_both_operands_not_snan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_both_operands_not_snan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %canon.x = call float @llvm.canonicalize.f32(float %x)
  %canon.y = call float @llvm.canonicalize.f32(float %y)
  %result = call float @llvm.maximumnum.f32(float %canon.x, float %canon.y)
  ret float %result
}

define double @v_maximumnum_f64_1.0(double %x) {
; GFX8-LABEL: v_maximumnum_f64_1.0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f64_1.0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f64_1.0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], 1.0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f64_1.0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f64_1.0:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], 1.0, v[0:1]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call double @llvm.maximumnum.f64(double %x, double 1.0)
  ret double %result
}

define half @v_maximumnum_f16_s_v(half inreg %x, half %y) {
; GFX8-LABEL: v_maximumnum_f16_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX8-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX9-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX10-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    v_max_f16_e64 v1, s0, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_s_v:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v0
; GFX12-NEXT:    v_max_num_f16_e64 v1, s0, s0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v1, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call half @llvm.maximumnum.f16(half %x, half %y)
  ret half %result
}

define half @v_maximumnum_f16_v_s(half %x, half inreg %y) {
; GFX8-LABEL: v_maximumnum_f16_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, s0, s0
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_v_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e64 v1, s0, s0
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call half @llvm.maximumnum.f16(half %x, half %y)
  ret half %result
}

define half @v_maximumnum_f16_s_s(half inreg %x, half inreg %y) {
; GFX8-LABEL: v_maximumnum_f16_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e64 v0, s17, s17
; GFX8-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX8-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e64 v0, s17, s17
; GFX9-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX9-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e64 v0, s17, s17
; GFX10-NEXT:    v_max_f16_e64 v1, s16, s16
; GFX10-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v0, s1, s1
; GFX11-NEXT:    v_max_f16_e64 v1, s0, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_s_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e64 v0, s1, s1
; GFX12-NEXT:    v_max_num_f16_e64 v1, s0, s0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v1, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call half @llvm.maximumnum.f16(half %x, half %y)
  ret half %result
}

define float @v_maximumnum_f32_s_v(float inreg %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_mul_f32_e64 v1, 1.0, s16
; GFX8-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e64 v1, s16, s16
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e64 v1, s16, s16
; GFX10-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_max_f32_e64 v1, s0, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_s_v:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v0
; GFX12-NEXT:    v_max_num_f32_e64 v1, s0, s0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v1, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call float @llvm.maximumnum.f32(float %x, float %y)
  ret float %result
}

define float @v_maximumnum_f32_v_s(float %x, float inreg %y) {
; GFX8-LABEL: v_maximumnum_f32_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e64 v1, 1.0, s16
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, s16, s16
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e64 v1, s16, s16
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, s0, s0
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_v_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, s0, s0
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call float @llvm.maximumnum.f32(float %x, float %y)
  ret float %result
}

define float @v_maximumnum_f32_s_s(float inreg %x, float inreg %y) {
; GFX8-LABEL: v_maximumnum_f32_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e64 v0, 1.0, s17
; GFX8-NEXT:    v_mul_f32_e64 v1, 1.0, s16
; GFX8-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v0, s17, s17
; GFX9-NEXT:    v_max_f32_e64 v1, s16, s16
; GFX9-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e64 v0, s17, s17
; GFX10-NEXT:    v_max_f32_e64 v1, s16, s16
; GFX10-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v0, s1, s1
; GFX11-NEXT:    v_max_f32_e64 v1, s0, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_s_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v0, s1, s1
; GFX12-NEXT:    v_max_num_f32_e64 v1, s0, s0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v1, v0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call float @llvm.maximumnum.f32(float %x, float %y)
  ret float %result
}

define double @v_maximumnum_f64_s_v(double inreg %x, double %y) {
; GFX8-LABEL: v_maximumnum_f64_s_v:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX8-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f64_s_v:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f64_s_v:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f64_s_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[2:3], s[0:1], s[0:1]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f64_s_v:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[2:3], s[0:1], s[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[2:3], v[0:1]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call double @llvm.maximumnum.f64(double %x, double %y)
  ret double %result
}

define double @v_maximumnum_f64_v_s(double %x, double inreg %y) {
; GFX8-LABEL: v_maximumnum_f64_v_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f64_v_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f64_v_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f64_v_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[2:3], s[0:1], s[0:1]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f64_v_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[2:3], s[0:1], s[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call double @llvm.maximumnum.f64(double %x, double %y)
  ret double %result
}

define double @v_maximumnum_f64_s_s(double inreg %x, double inreg %y) {
; GFX8-LABEL: v_maximumnum_f64_s_s:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], s[18:19], s[18:19]
; GFX8-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX8-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f64_s_s:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], s[18:19], s[18:19]
; GFX9-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX9-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f64_s_s:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[0:1], s[18:19], s[18:19]
; GFX10-NEXT:    v_max_f64 v[2:3], s[16:17], s[16:17]
; GFX10-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f64_s_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], s[2:3], s[2:3]
; GFX11-NEXT:    v_max_f64 v[2:3], s[0:1], s[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f64 v[0:1], v[2:3], v[0:1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f64_s_s:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[0:1], s[2:3], s[2:3]
; GFX12-NEXT:    v_max_num_f64_e64 v[2:3], s[0:1], s[0:1]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[2:3], v[0:1]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
 %result = call double @llvm.maximumnum.f64(double %x, double %y)
  ret double %result
}

define float @v_maximumnum_f32_fabs_rhs(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_fabs_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e64 v1, 1.0, |v1|
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_fabs_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_fabs_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_fabs_rhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_fabs_rhs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, |v1|, |v1|
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.y = call float @llvm.fabs.f32(float %y)
  %result = call float @llvm.maximumnum.f32(float %x, float %fabs.y)
  ret float %result
}

define float @v_maximumnum_f32_fneg_fabs_rhs(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_fneg_fabs_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e64 v1, -1.0, |v1|
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_fneg_fabs_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, -|v1|, -|v1|
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_fneg_fabs_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e64 v1, -|v1|, -|v1|
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_fneg_fabs_rhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, -|v1|, -|v1|
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_fneg_fabs_rhs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, -|v1|, -|v1|
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.y = call float @llvm.fabs.f32(float %y)
  %fneg.fabs.y = fneg float %fabs.y
  %result = call float @llvm.maximumnum.f32(float %x, float %fneg.fabs.y)
  ret float %result
}

define float @v_maximumnum_f32_fabs(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_fabs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e64 v1, 1.0, |v1|
; GFX8-NEXT:    v_mul_f32_e64 v0, 1.0, |v0|
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX9-NEXT:    v_max_f32_e64 v0, |v0|, |v0|
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_fabs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX10-NEXT:    v_max_f32_e64 v0, |v0|, |v0|
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, |v1|, |v1|
; GFX11-NEXT:    v_max_f32_e64 v0, |v0|, |v0|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_fabs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, |v1|, |v1|
; GFX12-NEXT:    v_max_num_f32_e64 v0, |v0|, |v0|
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call float @llvm.fabs.f32(float %x)
  %fabs.y = call float @llvm.fabs.f32(float %y)
  %result = call float @llvm.maximumnum.f32(float %fabs.x, float %fabs.y)
  ret float %result
}

define float @v_maximumnum_f32_fneg(float %x, float %y) {
; GFX8-LABEL: v_maximumnum_f32_fneg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f32_fneg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX9-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f32_fneg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX10-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f32_fneg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e64 v1, -v1, -v1
; GFX11-NEXT:    v_max_f32_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f32_fneg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f32_e64 v1, -v1, -v1
; GFX12-NEXT:    v_max_num_f32_e64 v0, -v0, -v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fneg.x = fneg float %x
  %fneg.y = fneg float %y
  %result = call float @llvm.maximumnum.f32(float %fneg.x, float %fneg.y)
  ret float %result
}

define half @v_maximumnum_f16_fabs_rhs(half %x, half %y) {
; GFX8-LABEL: v_maximumnum_f16_fabs_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_fabs_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_fabs_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_fabs_rhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_fabs_rhs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e64 v1, |v1|, |v1|
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %result = call half @llvm.maximumnum.f16(half %x, half %fabs.y)
  ret half %result
}

define half @v_maximumnum_f16_fneg_fabs_rhs(half %x, half %y) {
; GFX8-LABEL: v_maximumnum_f16_fneg_fabs_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e64 v1, -|v1|, -|v1|
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_fneg_fabs_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e64 v1, -|v1|, -|v1|
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_fneg_fabs_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e64 v1, -|v1|, -|v1|
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_fneg_fabs_rhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, -|v1|, -|v1|
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_fneg_fabs_rhs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e64 v1, -|v1|, -|v1|
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %fneg.fabs.y = fneg half %fabs.y
  %result = call half @llvm.maximumnum.f16(half %x, half %fneg.fabs.y)
  ret half %result
}

define half @v_maximumnum_f16_fabs(half %x, half %y) {
; GFX8-LABEL: v_maximumnum_f16_fabs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX8-NEXT:    v_max_f16_e64 v0, |v0|, |v0|
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX9-NEXT:    v_max_f16_e64 v0, |v0|, |v0|
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_fabs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX10-NEXT:    v_max_f16_e64 v0, |v0|, |v0|
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, |v1|, |v1|
; GFX11-NEXT:    v_max_f16_e64 v0, |v0|, |v0|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_fabs:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e64 v1, |v1|, |v1|
; GFX12-NEXT:    v_max_num_f16_e64 v0, |v0|, |v0|
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %result = call half @llvm.maximumnum.f16(half %fabs.x, half %fabs.y)
  ret half %result
}

define half @v_maximumnum_f16_fneg(half %x, half %y) {
; GFX8-LABEL: v_maximumnum_f16_fneg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX8-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f16_fneg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX9-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX9-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f16_fneg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX10-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX10-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f16_fneg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e64 v1, -v1, -v1
; GFX11-NEXT:    v_max_f16_e64 v0, -v0, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f16_fneg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f16_e64 v1, -v1, -v1
; GFX12-NEXT:    v_max_num_f16_e64 v0, -v0, -v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f16_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fneg.x = fneg half %x
  %fneg.y = fneg half %y
  %result = call half @llvm.maximumnum.f16(half %fneg.x, half %fneg.y)
  ret half %result
}

define double @v_maximumnum_f64_fneg(double %x, double %y) {
; GFX8-LABEL: v_maximumnum_f64_fneg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[2:3], -v[2:3], -v[2:3]
; GFX8-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_f64_fneg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[2:3], -v[2:3], -v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_f64_fneg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[2:3], -v[2:3], -v[2:3]
; GFX10-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_f64_fneg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[2:3], -v[2:3], -v[2:3]
; GFX11-NEXT:    v_max_f64 v[0:1], -v[0:1], -v[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_f64_fneg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e64 v[2:3], -v[2:3], -v[2:3]
; GFX12-NEXT:    v_max_num_f64_e64 v[0:1], -v[0:1], -v[0:1]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %fneg.x = fneg double %x
  %fneg.y = fneg double %y
  %result = call double @llvm.maximumnum.f64(double %fneg.x, double %fneg.y)
  ret double %result
}

define <2 x half> @v_maximumnum_v2f16(<2 x half> %x, <2 x half> %y) {
; GFX8-LABEL: v_maximumnum_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v2, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v3, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_sdwa v2, v3, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v2f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x half> @llvm.maximumnum.v2f16(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %result
}

define <2 x half> @v_maximumnum_v2f16_nnan(<2 x half> %x, <2 x half> %y) {
; GFX8-LABEL: v_maximumnum_v2f16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v2f16_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2f16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v2f16_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v2f16_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <2 x half> @llvm.maximumnum.v2f16(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %result
}

define <3 x half> @v_maximumnum_v3f16(<3 x half> %x, <3 x half> %y) {
; GFX8-LABEL: v_maximumnum_v3f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v5, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v2
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_sdwa v4, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v3, v3, v3
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v3f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX9-NEXT:    v_pk_max_f16 v2, v3, v3
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v3f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v3f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v2
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    v_pk_max_num_f16 v3, v3, v3
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x half> @llvm.maximumnum.v3f16(<3 x half> %x, <3 x half> %y)
  ret <3 x half> %result
}

define <3 x half> @v_maximumnum_v3f16_nnan(<3 x half> %x, <3 x half> %y) {
; GFX8-LABEL: v_maximumnum_v3f16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v3f16_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3f16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v3f16_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v3f16_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <3 x half> @llvm.maximumnum.v3f16(<3 x half> %x, <3 x half> %y)
  ret <3 x half> %result
}

define <4 x half> @v_maximumnum_v4f16(<4 x half> %x, <4 x half> %y) {
; GFX8-LABEL: v_maximumnum_v4f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v5, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v4, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_sdwa v5, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v6, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v3, v3, v3
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v2
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_sdwa v5, v6, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v4f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX9-NEXT:    v_pk_max_f16 v2, v3, v3
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v4f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v4f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v2
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    v_pk_max_num_f16 v3, v3, v3
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x half> @llvm.maximumnum.v4f16(<4 x half> %x, <4 x half> %y)
  ret <4 x half> %result
}

define <4 x half> @v_maximumnum_v4f16_nnan(<4 x half> %x, <4 x half> %y) {
; GFX8-LABEL: v_maximumnum_v4f16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v4, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v5, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v3
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v4f16_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4f16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v4f16_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v2
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v4f16_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v2
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <4 x half> @llvm.maximumnum.v4f16(<4 x half> %x, <4 x half> %y)
  ret <4 x half> %result
}

define <6 x half> @v_maximumnum_v6f16(<6 x half> %x, <6 x half> %y) {
; GFX8-LABEL: v_maximumnum_v6f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v6, v5, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v7, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v6, v7, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_sdwa v7, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v8, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v7, v8, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_sdwa v8, v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v9, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v5, v5, v5
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v2
; GFX8-NEXT:    v_max_f16_e32 v4, v4, v4
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v3, v3, v3
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_sdwa v8, v9, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v5
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v4
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v7
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v6
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v6f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v3
; GFX9-NEXT:    v_pk_max_f16 v3, v4, v4
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v3
; GFX9-NEXT:    v_pk_max_f16 v3, v5, v5
; GFX9-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX9-NEXT:    v_pk_max_f16 v2, v2, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v6f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v4, v4, v4
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v5, v5, v5
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v3
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v4
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v6f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v4, v4, v4
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_max_f16 v5, v5, v5
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v4
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v6f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v3, v3, v3
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    v_pk_max_num_f16 v4, v4, v4
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    v_pk_max_num_f16 v5, v5, v5
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v2
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v4
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <6 x half> @llvm.maximumnum.v6f16(<6 x half> %x, <6 x half> %y)
  ret <6 x half> %result
}

define <8 x half> @v_maximumnum_v8f16(<8 x half> %x, <8 x half> %y) {
; GFX8-LABEL: v_maximumnum_v8f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f16_sdwa v8, v7, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v9, v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v8, v9, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_sdwa v9, v6, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v10, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v9, v10, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_sdwa v10, v5, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v11, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v10, v11, v10 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_sdwa v11, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_sdwa v12, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_max_f16_e32 v7, v7, v7
; GFX8-NEXT:    v_max_f16_e32 v3, v3, v3
; GFX8-NEXT:    v_max_f16_e32 v6, v6, v6
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v2
; GFX8-NEXT:    v_max_f16_e32 v5, v5, v5
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX8-NEXT:    v_max_f16_e32 v4, v4, v4
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX8-NEXT:    v_max_f16_sdwa v11, v12, v11 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_f16_e32 v3, v3, v7
; GFX8-NEXT:    v_max_f16_e32 v2, v2, v6
; GFX8-NEXT:    v_max_f16_e32 v1, v1, v5
; GFX8-NEXT:    v_max_f16_e32 v0, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v11
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v10
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v9
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v8
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v8f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_max_f16 v4, v4, v4
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX9-NEXT:    v_pk_max_f16 v0, v0, v4
; GFX9-NEXT:    v_pk_max_f16 v4, v5, v5
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX9-NEXT:    v_pk_max_f16 v1, v1, v4
; GFX9-NEXT:    v_pk_max_f16 v4, v6, v6
; GFX9-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX9-NEXT:    v_pk_max_f16 v2, v2, v4
; GFX9-NEXT:    v_pk_max_f16 v4, v7, v7
; GFX9-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX9-NEXT:    v_pk_max_f16 v3, v3, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v8f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_max_f16 v4, v4, v4
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX10-NEXT:    v_pk_max_f16 v5, v5, v5
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX10-NEXT:    v_pk_max_f16 v6, v6, v6
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX10-NEXT:    v_pk_max_f16 v7, v7, v7
; GFX10-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX10-NEXT:    v_pk_max_f16 v0, v0, v4
; GFX10-NEXT:    v_pk_max_f16 v1, v1, v5
; GFX10-NEXT:    v_pk_max_f16 v2, v2, v6
; GFX10-NEXT:    v_pk_max_f16 v3, v3, v7
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v8f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v4, v4, v4
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v5, v5, v5
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_max_f16 v6, v6, v6
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v2
; GFX11-NEXT:    v_pk_max_f16 v7, v7, v7
; GFX11-NEXT:    v_pk_max_f16 v3, v3, v3
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v4
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v5
; GFX11-NEXT:    v_pk_max_f16 v2, v2, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_pk_max_f16 v3, v3, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v8f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_pk_max_num_f16 v4, v4, v4
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v0
; GFX12-NEXT:    v_pk_max_num_f16 v5, v5, v5
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v1
; GFX12-NEXT:    v_pk_max_num_f16 v6, v6, v6
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v2
; GFX12-NEXT:    v_pk_max_num_f16 v7, v7, v7
; GFX12-NEXT:    v_pk_max_num_f16 v3, v3, v3
; GFX12-NEXT:    v_pk_max_num_f16 v0, v0, v4
; GFX12-NEXT:    v_pk_max_num_f16 v1, v1, v5
; GFX12-NEXT:    v_pk_max_num_f16 v2, v2, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_pk_max_num_f16 v3, v3, v7
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <8 x half> @llvm.maximumnum.v8f16(<8 x half> %x, <8 x half> %y)
  ret <8 x half> %result
}

define <2 x float> @v_maximumnum_v2f32(<2 x float> %x, <2 x float> %y) {
; GFX8-LABEL: v_maximumnum_v2f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f32_e32 v2, 1.0, v3
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_max_f32_e32 v2, v3, v3
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v3, v3, v3
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v2 :: v_dual_max_f32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v2f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v2, v2, v2 :: v_dual_max_num_f32 v3, v3, v3
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v2 :: v_dual_max_num_f32 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x float> @llvm.maximumnum.v2f32(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %result
}

define <2 x float> @v_maximumnum_v2f32_nnan(<2 x float> %x, <2 x float> %y) {
; GFX8-LABEL: v_maximumnum_v2f32_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v2f32_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2f32_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v2f32_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v2 :: v_dual_max_f32 v1, v1, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v2f32_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v2 :: v_dual_max_num_f32 v1, v1, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <2 x float> @llvm.maximumnum.v2f32(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %result
}

define <3 x float> @v_maximumnum_v3f32(<3 x float> %x, <3 x float> %y) {
; GFX8-LABEL: v_maximumnum_v3f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_mul_f32_e32 v3, 1.0, v4
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX8-NEXT:    v_mul_f32_e32 v3, 1.0, v5
; GFX8-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX8-NEXT:    v_max_f32_e32 v2, v2, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v3f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX9-NEXT:    v_max_f32_e32 v3, v4, v4
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX9-NEXT:    v_max_f32_e32 v3, v5, v5
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v3f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v3, v3, v3 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    v_dual_max_f32 v4, v4, v4 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_dual_max_f32 v5, v5, v5 :: v_dual_max_f32 v2, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v3 :: v_dual_max_f32 v1, v1, v4
; GFX11-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v3f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v3, v3, v3 :: v_dual_max_num_f32 v0, v0, v0
; GFX12-NEXT:    v_dual_max_num_f32 v4, v4, v4 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    v_dual_max_num_f32 v5, v5, v5 :: v_dual_max_num_f32 v2, v2, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v3 :: v_dual_max_num_f32 v1, v1, v4
; GFX12-NEXT:    v_max_num_f32_e32 v2, v2, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x float> @llvm.maximumnum.v3f32(<3 x float> %x, <3 x float> %y)
  ret <3 x float> %result
}

define <3 x float> @v_maximumnum_v3f32_nnan(<3 x float> %x, <3 x float> %y) {
; GFX8-LABEL: v_maximumnum_v3f32_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX8-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v3f32_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3f32_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v3f32_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v3 :: v_dual_max_f32 v1, v1, v4
; GFX11-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v3f32_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v3 :: v_dual_max_num_f32 v1, v1, v4
; GFX12-NEXT:    v_max_num_f32_e32 v2, v2, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <3 x float> @llvm.maximumnum.v3f32(<3 x float> %x, <3 x float> %y)
  ret <3 x float> %result
}

define <4 x float> @v_maximumnum_v4f32(<4 x float> %x, <4 x float> %y) {
; GFX8-LABEL: v_maximumnum_v4f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX8-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX8-NEXT:    v_mul_f32_e32 v4, 1.0, v5
; GFX8-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX8-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX8-NEXT:    v_mul_f32_e32 v4, 1.0, v6
; GFX8-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX8-NEXT:    v_max_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_mul_f32_e32 v4, 1.0, v7
; GFX8-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX8-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v4f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX9-NEXT:    v_max_f32_e32 v4, v5, v5
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX9-NEXT:    v_max_f32_e32 v4, v6, v6
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v4
; GFX9-NEXT:    v_max_f32_e32 v4, v7, v7
; GFX9-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX9-NEXT:    v_max_f32_e32 v3, v3, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v4, v4, v4
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v0
; GFX10-NEXT:    v_max_f32_e32 v5, v5, v5
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v1
; GFX10-NEXT:    v_max_f32_e32 v6, v6, v6
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v2
; GFX10-NEXT:    v_max_f32_e32 v7, v7, v7
; GFX10-NEXT:    v_max_f32_e32 v3, v3, v3
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v4f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v4, v4, v4 :: v_dual_max_f32 v5, v5, v5
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_dual_max_f32 v6, v6, v6 :: v_dual_max_f32 v7, v7, v7
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v3, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v4 :: v_dual_max_f32 v1, v1, v5
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v6 :: v_dual_max_f32 v3, v3, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v4f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v4, v4, v4 :: v_dual_max_num_f32 v5, v5, v5
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v0 :: v_dual_max_num_f32 v1, v1, v1
; GFX12-NEXT:    v_dual_max_num_f32 v6, v6, v6 :: v_dual_max_num_f32 v7, v7, v7
; GFX12-NEXT:    v_dual_max_num_f32 v2, v2, v2 :: v_dual_max_num_f32 v3, v3, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v4 :: v_dual_max_num_f32 v1, v1, v5
; GFX12-NEXT:    v_dual_max_num_f32 v2, v2, v6 :: v_dual_max_num_f32 v3, v3, v7
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x float> @llvm.maximumnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %result
}

define <4 x float> @v_maximumnum_v4f32_nnan(<4 x float> %x, <4 x float> %y) {
; GFX8-LABEL: v_maximumnum_v4f32_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX8-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX8-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v4f32_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX9-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX9-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX9-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4f32_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX10-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX10-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v4f32_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v4 :: v_dual_max_f32 v1, v1, v5
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v6 :: v_dual_max_f32 v3, v3, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v4f32_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_max_num_f32 v0, v0, v4 :: v_dual_max_num_f32 v1, v1, v5
; GFX12-NEXT:    v_dual_max_num_f32 v2, v2, v6 :: v_dual_max_num_f32 v3, v3, v7
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <4 x float> @llvm.maximumnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %result
}

define <2 x double> @v_maximumnum_v2f64(<2 x double> %x, <2 x double> %y) {
; GFX8-LABEL: v_maximumnum_v2f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v2f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v2f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v2f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[4:5]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[6:7], v[6:7], v[6:7]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[6:7]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x double> @llvm.maximumnum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %result
}

define <2 x double> @v_maximumnum_v2f64_nnan(<2 x double> %x, <2 x double> %y) {
; GFX8-LABEL: v_maximumnum_v2f64_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v2f64_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2f64_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v2f64_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[4:5]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[6:7]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v2f64_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[6:7]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <2 x double> @llvm.maximumnum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %result
}

define <3 x double> @v_maximumnum_v3f64(<3 x double> %x, <3 x double> %y) {
; GFX8-LABEL: v_maximumnum_v3f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX8-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v3f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX10-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v3f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v3f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[6:7], v[6:7], v[6:7]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[8:9], v[8:9], v[8:9]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[10:11], v[10:11], v[10:11]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[4:5]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[6:7]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[8:9]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[10:11]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x double> @llvm.maximumnum.v3f64(<3 x double> %x, <3 x double> %y)
  ret <3 x double> %result
}

define <3 x double> @v_maximumnum_v3f64_nnan(<3 x double> %x, <3 x double> %y) {
; GFX8-LABEL: v_maximumnum_v3f64_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v3f64_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3f64_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v3f64_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[6:7]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[8:9]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[10:11]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v3f64_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[6:7]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[8:9]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[10:11]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <3 x double> @llvm.maximumnum.v3f64(<3 x double> %x, <3 x double> %y)
  ret <3 x double> %result
}

define <4 x double> @v_maximumnum_v4f64(<4 x double> %x, <4 x double> %y) {
; GFX8-LABEL: v_maximumnum_v4f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX8-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX8-NEXT:    v_max_f64 v[12:13], v[12:13], v[12:13]
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX8-NEXT:    v_max_f64 v[14:15], v[14:15], v[14:15]
; GFX8-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX8-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v4f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX9-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX9-NEXT:    v_max_f64 v[12:13], v[12:13], v[12:13]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX9-NEXT:    v_max_f64 v[14:15], v[14:15], v[14:15]
; GFX9-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX9-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX10-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX10-NEXT:    v_max_f64 v[12:13], v[12:13], v[12:13]
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX10-NEXT:    v_max_f64 v[14:15], v[14:15], v[14:15]
; GFX10-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX10-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v4f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[8:9], v[8:9], v[8:9]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[10:11], v[10:11], v[10:11]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[12:13], v[12:13], v[12:13]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[4:5]
; GFX11-NEXT:    v_max_f64 v[14:15], v[14:15], v[14:15]
; GFX11-NEXT:    v_max_f64 v[6:7], v[6:7], v[6:7]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v4f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[8:9], v[8:9], v[8:9]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[0:1]
; GFX12-NEXT:    v_max_num_f64_e32 v[10:11], v[10:11], v[10:11]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[2:3]
; GFX12-NEXT:    v_max_num_f64_e32 v[12:13], v[12:13], v[12:13]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[4:5]
; GFX12-NEXT:    v_max_num_f64_e32 v[14:15], v[14:15], v[14:15]
; GFX12-NEXT:    v_max_num_f64_e32 v[6:7], v[6:7], v[6:7]
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[8:9]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[10:11]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[12:13]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-NEXT:    v_max_num_f64_e32 v[6:7], v[6:7], v[14:15]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x double> @llvm.maximumnum.v4f64(<4 x double> %x, <4 x double> %y)
  ret <4 x double> %result
}

define <4 x double> @v_maximumnum_v4f64_nnan(<4 x double> %x, <4 x double> %y) {
; GFX8-LABEL: v_maximumnum_v4f64_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX8-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX8-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX8-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_maximumnum_v4f64_nnan:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX9-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX9-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX9-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4f64_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX10-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX10-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX10-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_maximumnum_v4f64_nnan:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[8:9]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[10:11]
; GFX11-NEXT:    v_max_f64 v[4:5], v[4:5], v[12:13]
; GFX11-NEXT:    v_max_f64 v[6:7], v[6:7], v[14:15]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: v_maximumnum_v4f64_nnan:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_max_num_f64_e32 v[0:1], v[0:1], v[8:9]
; GFX12-NEXT:    v_max_num_f64_e32 v[2:3], v[2:3], v[10:11]
; GFX12-NEXT:    v_max_num_f64_e32 v[4:5], v[4:5], v[12:13]
; GFX12-NEXT:    v_max_num_f64_e32 v[6:7], v[6:7], v[14:15]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <4 x double> @llvm.maximumnum.v4f64(<4 x double> %x, <4 x double> %y)
  ret <4 x double> %result
}
