; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=aarch64 --mattr=+fullfp16 < %s | FileCheck %s --check-prefix=AARCH64

;;;;;;;;;;;;;;;;  max_f64
define double @max_nnan_f64(double %a, double %b) {
; AARCH64-LABEL: max_nnan_f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm d0, d0, d1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan double @llvm.maximumnum.f64(double %a, double %b)
  ret double %c
}

define <2 x double> @max_nnan_v2f64(<2 x double> %a, <2 x double> %b) {
; AARCH64-LABEL: max_nnan_v2f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v0.2d, v0.2d, v1.2d
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <2 x double> @llvm.maximumnum.v2f64(<2 x double> %a, <2 x double> %b)
  ret <2 x double> %c
}

define <3 x double> @max_nnan_v3f64(<3 x double> %a, <3 x double> %b) {
; AARCH64-LABEL: max_nnan_v3f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $d3 killed $d3 def $q3
; AARCH64-NEXT:    // kill: def $d0 killed $d0 def $q0
; AARCH64-NEXT:    // kill: def $d4 killed $d4 def $q4
; AARCH64-NEXT:    // kill: def $d1 killed $d1 def $q1
; AARCH64-NEXT:    // kill: def $d2 killed $d2 def $q2
; AARCH64-NEXT:    // kill: def $d5 killed $d5 def $q5
; AARCH64-NEXT:    mov v3.d[1], v4.d[0]
; AARCH64-NEXT:    mov v0.d[1], v1.d[0]
; AARCH64-NEXT:    fmaxnm v2.2d, v2.2d, v5.2d
; AARCH64-NEXT:    // kill: def $d2 killed $d2 killed $q2
; AARCH64-NEXT:    fmaxnm v0.2d, v0.2d, v3.2d
; AARCH64-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; AARCH64-NEXT:    // kill: def $d0 killed $d0 killed $q0
; AARCH64-NEXT:    // kill: def $d1 killed $d1 killed $q1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <3 x double> @llvm.maximumnum.v3f64(<3 x double> %a, <3 x double> %b)
  ret <3 x double> %c
}

define <4 x double> @max_nnan_v4f64(<4 x double> %a, <4 x double> %b) {
; AARCH64-LABEL: max_nnan_v4f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v1.2d, v1.2d, v3.2d
; AARCH64-NEXT:    fmaxnm v0.2d, v0.2d, v2.2d
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <4 x double> @llvm.maximumnum.v4f64(<4 x double> %a, <4 x double> %b)
  ret <4 x double> %c
}

;;;;;;;;;;;;;;;;;; max_f32
define float @max_nnan_f32(float %a, float %b) {
; AARCH64-LABEL: max_nnan_f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm s0, s0, s1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan float @llvm.maximumnum.f32(float %a, float %b)
  ret float %c
}

define <2 x float> @max_nnan_v2f32(<2 x float> %a, <2 x float> %b) {
; AARCH64-LABEL: max_nnan_v2f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v0.2s, v0.2s, v1.2s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <2 x float> @llvm.maximumnum.v2f32(<2 x float> %a, <2 x float> %b)
  ret <2 x float> %c
}

define <3 x float> @max_nnan_v3f32(<3 x float> %a, <3 x float> %b) {
; AARCH64-LABEL: max_nnan_v3f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <3 x float> @llvm.maximumnum.v3f32(<3 x float> %a, <3 x float> %b)
  ret <3 x float> %c
}

define <4 x float> @max_nnan_v4f32(<4 x float> %a, <4 x float> %b) {
; AARCH64-LABEL: max_nnan_v4f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <4 x float> @llvm.maximumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define <5 x float> @max_nnan_v5f32(<5 x float> %a, <5 x float> %b) {
; AARCH64-LABEL: max_nnan_v5f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $s0 killed $s0 def $q0
; AARCH64-NEXT:    // kill: def $s5 killed $s5 def $q5
; AARCH64-NEXT:    // kill: def $s1 killed $s1 def $q1
; AARCH64-NEXT:    // kill: def $s6 killed $s6 def $q6
; AARCH64-NEXT:    // kill: def $s2 killed $s2 def $q2
; AARCH64-NEXT:    // kill: def $s7 killed $s7 def $q7
; AARCH64-NEXT:    // kill: def $s3 killed $s3 def $q3
; AARCH64-NEXT:    mov x8, sp
; AARCH64-NEXT:    // kill: def $s4 killed $s4 def $q4
; AARCH64-NEXT:    mov v0.s[1], v1.s[0]
; AARCH64-NEXT:    mov v5.s[1], v6.s[0]
; AARCH64-NEXT:    mov v0.s[2], v2.s[0]
; AARCH64-NEXT:    mov v5.s[2], v7.s[0]
; AARCH64-NEXT:    ldr s2, [sp, #8]
; AARCH64-NEXT:    fmaxnm v4.4s, v4.4s, v2.4s
; AARCH64-NEXT:    // kill: def $s4 killed $s4 killed $q4
; AARCH64-NEXT:    mov v0.s[3], v3.s[0]
; AARCH64-NEXT:    ld1 { v5.s }[3], [x8]
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v5.4s
; AARCH64-NEXT:    mov s1, v0.s[1]
; AARCH64-NEXT:    mov s2, v0.s[2]
; AARCH64-NEXT:    mov s3, v0.s[3]
; AARCH64-NEXT:    // kill: def $s0 killed $s0 killed $q0
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <5 x float> @llvm.maximumnum.v5f32(<5 x float> %a, <5 x float> %b)
  ret <5 x float> %c
}

define <8 x float> @max_nnan_v8f32(<8 x float> %a, <8 x float> %b) {
; AARCH64-LABEL: max_nnan_v8f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v1.4s, v1.4s, v3.4s
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v2.4s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <8 x float> @llvm.maximumnum.v8f32(<8 x float> %a, <8 x float> %b)
  ret <8 x float> %c
}

;;;;;;;;;;;;;;;;;; max_f16
define half @max_nnan_f16(half %a, half %b) {
; AARCH64-LABEL: max_nnan_f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm h0, h0, h1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan half @llvm.maximumnum.f16(half %a, half %b)
  ret half %c
}

define <2 x half> @max_nnan_v2f16(<2 x half> %a, <2 x half> %b) {
; AARCH64-LABEL: max_nnan_v2f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <2 x half> @llvm.maximumnum.v2f16(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %c
}

define <4 x half> @max_nnan_v4f16(<4 x half> %a, <4 x half> %b) {
; AARCH64-LABEL: max_nnan_v4f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <4 x half> @llvm.maximumnum.v4f16(<4 x half> %a, <4 x half> %b)
  ret <4 x half> %c
}

define <8 x half> @max_nnan_v8f16(<8 x half> %a, <8 x half> %b) {
; AARCH64-LABEL: max_nnan_v8f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <8 x half> @llvm.maximumnum.v8f16(<8 x half> %a, <8 x half> %b)
  ret <8 x half> %c
}

define <9 x half> @max_nnan_v9f16(<9 x half> %a, <9 x half> %b) {
; AARCH64-LABEL: max_nnan_v9f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $h0 killed $h0 def $q0
; AARCH64-NEXT:    // kill: def $h1 killed $h1 def $q1
; AARCH64-NEXT:    // kill: def $h2 killed $h2 def $q2
; AARCH64-NEXT:    add x9, sp, #16
; AARCH64-NEXT:    // kill: def $h3 killed $h3 def $q3
; AARCH64-NEXT:    // kill: def $h4 killed $h4 def $q4
; AARCH64-NEXT:    // kill: def $h5 killed $h5 def $q5
; AARCH64-NEXT:    // kill: def $h6 killed $h6 def $q6
; AARCH64-NEXT:    // kill: def $h7 killed $h7 def $q7
; AARCH64-NEXT:    mov v0.h[1], v1.h[0]
; AARCH64-NEXT:    ldr h1, [sp, #8]
; AARCH64-NEXT:    ld1 { v1.h }[1], [x9]
; AARCH64-NEXT:    add x9, sp, #24
; AARCH64-NEXT:    mov v0.h[2], v2.h[0]
; AARCH64-NEXT:    ldr h2, [sp, #72]
; AARCH64-NEXT:    ld1 { v1.h }[2], [x9]
; AARCH64-NEXT:    add x9, sp, #32
; AARCH64-NEXT:    mov v0.h[3], v3.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[3], [x9]
; AARCH64-NEXT:    add x9, sp, #40
; AARCH64-NEXT:    ldr h3, [sp]
; AARCH64-NEXT:    ld1 { v1.h }[4], [x9]
; AARCH64-NEXT:    add x9, sp, #48
; AARCH64-NEXT:    fmaxnm v2.8h, v3.8h, v2.8h
; AARCH64-NEXT:    mov v0.h[4], v4.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[5], [x9]
; AARCH64-NEXT:    add x9, sp, #56
; AARCH64-NEXT:    str h2, [x8, #16]
; AARCH64-NEXT:    mov v0.h[5], v5.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[6], [x9]
; AARCH64-NEXT:    add x9, sp, #64
; AARCH64-NEXT:    mov v0.h[6], v6.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[7], [x9]
; AARCH64-NEXT:    mov v0.h[7], v7.h[0]
; AARCH64-NEXT:    fmaxnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    str q0, [x8]
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <9 x half> @llvm.maximumnum.v9f16(<9 x half> %a, <9 x half> %b)
  ret <9 x half> %c
}

define <16 x half> @max_nnan_v16f16(<16 x half> %a, <16 x half> %b) {
; AARCH64-LABEL: max_nnan_v16f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fmaxnm v1.8h, v1.8h, v3.8h
; AARCH64-NEXT:    fmaxnm v0.8h, v0.8h, v2.8h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <16 x half> @llvm.maximumnum.v16f16(<16 x half> %a, <16 x half> %b)
  ret <16 x half> %c
}

;;;;;;;;;;;;;;;;  min_f64
define double @min_nnan_f64(double %a, double %b) {
; AARCH64-LABEL: min_nnan_f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm d0, d0, d1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan double @llvm.minimumnum.f64(double %a, double %b)
  ret double %c
}

define <2 x double> @min_nnan_v2f64(<2 x double> %a, <2 x double> %b) {
; AARCH64-LABEL: min_nnan_v2f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v1.2d
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <2 x double> @llvm.minimumnum.v2f64(<2 x double> %a, <2 x double> %b)
  ret <2 x double> %c
}

define <3 x double> @min_nnan_v3f64(<3 x double> %a, <3 x double> %b) {
; AARCH64-LABEL: min_nnan_v3f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $d3 killed $d3 def $q3
; AARCH64-NEXT:    // kill: def $d0 killed $d0 def $q0
; AARCH64-NEXT:    // kill: def $d4 killed $d4 def $q4
; AARCH64-NEXT:    // kill: def $d1 killed $d1 def $q1
; AARCH64-NEXT:    // kill: def $d2 killed $d2 def $q2
; AARCH64-NEXT:    // kill: def $d5 killed $d5 def $q5
; AARCH64-NEXT:    mov v3.d[1], v4.d[0]
; AARCH64-NEXT:    mov v0.d[1], v1.d[0]
; AARCH64-NEXT:    fminnm v2.2d, v2.2d, v5.2d
; AARCH64-NEXT:    // kill: def $d2 killed $d2 killed $q2
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v3.2d
; AARCH64-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; AARCH64-NEXT:    // kill: def $d0 killed $d0 killed $q0
; AARCH64-NEXT:    // kill: def $d1 killed $d1 killed $q1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <3 x double> @llvm.minimumnum.v3f64(<3 x double> %a, <3 x double> %b)
  ret <3 x double> %c
}

define <4 x double> @min_nnan_v4f64(<4 x double> %a, <4 x double> %b) {
; AARCH64-LABEL: min_nnan_v4f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.2d, v1.2d, v3.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v2.2d
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <4 x double> @llvm.minimumnum.v4f64(<4 x double> %a, <4 x double> %b)
  ret <4 x double> %c
}

;;;;;;;;;;;;;;;;;; min_f32
define float @min_nnan_f32(float %a, float %b) {
; AARCH64-LABEL: min_nnan_f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm s0, s0, s1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan float @llvm.minimumnum.f32(float %a, float %b)
  ret float %c
}

define <2 x float> @min_nnan_v2f32(<2 x float> %a, <2 x float> %b) {
; AARCH64-LABEL: min_nnan_v2f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v0.2s, v0.2s, v1.2s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <2 x float> @llvm.minimumnum.v2f32(<2 x float> %a, <2 x float> %b)
  ret <2 x float> %c
}

define <3 x float> @min_nnan_v3f32(<3 x float> %a, <3 x float> %b) {
; AARCH64-LABEL: min_nnan_v3f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <3 x float> @llvm.minimumnum.v3f32(<3 x float> %a, <3 x float> %b)
  ret <3 x float> %c
}

define <4 x float> @min_nnan_v4f32(<4 x float> %a, <4 x float> %b) {
; AARCH64-LABEL: min_nnan_v4f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <4 x float> @llvm.minimumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define <5 x float> @min_nnan_v5f32(<5 x float> %a, <5 x float> %b) {
; AARCH64-LABEL: min_nnan_v5f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $s0 killed $s0 def $q0
; AARCH64-NEXT:    // kill: def $s5 killed $s5 def $q5
; AARCH64-NEXT:    // kill: def $s1 killed $s1 def $q1
; AARCH64-NEXT:    // kill: def $s6 killed $s6 def $q6
; AARCH64-NEXT:    // kill: def $s2 killed $s2 def $q2
; AARCH64-NEXT:    // kill: def $s7 killed $s7 def $q7
; AARCH64-NEXT:    // kill: def $s3 killed $s3 def $q3
; AARCH64-NEXT:    mov x8, sp
; AARCH64-NEXT:    // kill: def $s4 killed $s4 def $q4
; AARCH64-NEXT:    mov v0.s[1], v1.s[0]
; AARCH64-NEXT:    mov v5.s[1], v6.s[0]
; AARCH64-NEXT:    mov v0.s[2], v2.s[0]
; AARCH64-NEXT:    mov v5.s[2], v7.s[0]
; AARCH64-NEXT:    ldr s2, [sp, #8]
; AARCH64-NEXT:    fminnm v4.4s, v4.4s, v2.4s
; AARCH64-NEXT:    // kill: def $s4 killed $s4 killed $q4
; AARCH64-NEXT:    mov v0.s[3], v3.s[0]
; AARCH64-NEXT:    ld1 { v5.s }[3], [x8]
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v5.4s
; AARCH64-NEXT:    mov s1, v0.s[1]
; AARCH64-NEXT:    mov s2, v0.s[2]
; AARCH64-NEXT:    mov s3, v0.s[3]
; AARCH64-NEXT:    // kill: def $s0 killed $s0 killed $q0
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <5 x float> @llvm.minimumnum.v5f32(<5 x float> %a, <5 x float> %b)
  ret <5 x float> %c
}

define <8 x float> @min_nnan_v8f32(<8 x float> %a, <8 x float> %b) {
; AARCH64-LABEL: min_nnan_v8f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v3.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v2.4s
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <8 x float> @llvm.minimumnum.v8f32(<8 x float> %a, <8 x float> %b)
  ret <8 x float> %c
}

;;;;;;;;;;;;;;;;;; min_f16
define half @min_nnan_f16(half %a, half %b) {
; AARCH64-LABEL: min_nnan_f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm h0, h0, h1
; AARCH64-NEXT:    ret
entry:
  %c = call nnan half @llvm.minimumnum.f16(half %a, half %b)
  ret half %c
}

define <2 x half> @min_nnan_v2f16(<2 x half> %a, <2 x half> %b) {
; AARCH64-LABEL: min_nnan_v2f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <2 x half> @llvm.minimumnum.v2f16(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %c
}

define <4 x half> @min_nnan_v4f16(<4 x half> %a, <4 x half> %b) {
; AARCH64-LABEL: min_nnan_v4f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <4 x half> @llvm.minimumnum.v4f16(<4 x half> %a, <4 x half> %b)
  ret <4 x half> %c
}

define <8 x half> @min_nnan_v8f16(<8 x half> %a, <8 x half> %b) {
; AARCH64-LABEL: min_nnan_v8f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <8 x half> @llvm.minimumnum.v8f16(<8 x half> %a, <8 x half> %b)
  ret <8 x half> %c
}

define <9 x half> @min_nnan_v9f16(<9 x half> %a, <9 x half> %b) {
; AARCH64-LABEL: min_nnan_v9f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $h0 killed $h0 def $q0
; AARCH64-NEXT:    // kill: def $h1 killed $h1 def $q1
; AARCH64-NEXT:    // kill: def $h2 killed $h2 def $q2
; AARCH64-NEXT:    add x9, sp, #16
; AARCH64-NEXT:    // kill: def $h3 killed $h3 def $q3
; AARCH64-NEXT:    // kill: def $h4 killed $h4 def $q4
; AARCH64-NEXT:    // kill: def $h5 killed $h5 def $q5
; AARCH64-NEXT:    // kill: def $h6 killed $h6 def $q6
; AARCH64-NEXT:    // kill: def $h7 killed $h7 def $q7
; AARCH64-NEXT:    mov v0.h[1], v1.h[0]
; AARCH64-NEXT:    ldr h1, [sp, #8]
; AARCH64-NEXT:    ld1 { v1.h }[1], [x9]
; AARCH64-NEXT:    add x9, sp, #24
; AARCH64-NEXT:    mov v0.h[2], v2.h[0]
; AARCH64-NEXT:    ldr h2, [sp, #72]
; AARCH64-NEXT:    ld1 { v1.h }[2], [x9]
; AARCH64-NEXT:    add x9, sp, #32
; AARCH64-NEXT:    mov v0.h[3], v3.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[3], [x9]
; AARCH64-NEXT:    add x9, sp, #40
; AARCH64-NEXT:    ldr h3, [sp]
; AARCH64-NEXT:    ld1 { v1.h }[4], [x9]
; AARCH64-NEXT:    add x9, sp, #48
; AARCH64-NEXT:    fminnm v2.8h, v3.8h, v2.8h
; AARCH64-NEXT:    mov v0.h[4], v4.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[5], [x9]
; AARCH64-NEXT:    add x9, sp, #56
; AARCH64-NEXT:    str h2, [x8, #16]
; AARCH64-NEXT:    mov v0.h[5], v5.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[6], [x9]
; AARCH64-NEXT:    add x9, sp, #64
; AARCH64-NEXT:    mov v0.h[6], v6.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[7], [x9]
; AARCH64-NEXT:    mov v0.h[7], v7.h[0]
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    str q0, [x8]
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <9 x half> @llvm.minimumnum.v9f16(<9 x half> %a, <9 x half> %b)
  ret <9 x half> %c
}

define <16 x half> @min_nnan_v16f16(<16 x half> %a, <16 x half> %b) {
; AARCH64-LABEL: min_nnan_v16f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v3.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v2.8h
; AARCH64-NEXT:    ret
entry:
  %c = call nnan <16 x half> @llvm.minimumnum.v16f16(<16 x half> %a, <16 x half> %b)
  ret <16 x half> %c
}

;;;;;;;;;;;;;;;;  max_f64
define double @max_f64(double %a, double %b) {
; AARCH64-LABEL: max_f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm d1, d1, d1
; AARCH64-NEXT:    fminnm d0, d0, d0
; AARCH64-NEXT:    fmaxnm d0, d0, d1
; AARCH64-NEXT:    ret
entry:
  %c = call double @llvm.maximumnum.f64(double %a, double %b)
  ret double %c
}

define <2 x double> @max_v2f64(<2 x double> %a, <2 x double> %b) {
; AARCH64-LABEL: max_v2f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.2d, v1.2d, v1.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; AARCH64-NEXT:    fmaxnm v0.2d, v0.2d, v1.2d
; AARCH64-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.maximumnum.v2f64(<2 x double> %a, <2 x double> %b)
  ret <2 x double> %c
}

define <3 x double> @max_v3f64(<3 x double> %a, <3 x double> %b) {
; AARCH64-LABEL: max_v3f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $d3 killed $d3 def $q3
; AARCH64-NEXT:    // kill: def $d0 killed $d0 def $q0
; AARCH64-NEXT:    // kill: def $d4 killed $d4 def $q4
; AARCH64-NEXT:    // kill: def $d1 killed $d1 def $q1
; AARCH64-NEXT:    // kill: def $d2 killed $d2 def $q2
; AARCH64-NEXT:    // kill: def $d5 killed $d5 def $q5
; AARCH64-NEXT:    mov v0.d[1], v1.d[0]
; AARCH64-NEXT:    mov v3.d[1], v4.d[0]
; AARCH64-NEXT:    fminnm v2.2d, v2.2d, v2.2d
; AARCH64-NEXT:    fminnm v1.2d, v3.2d, v3.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; AARCH64-NEXT:    fmaxnm v0.2d, v0.2d, v1.2d
; AARCH64-NEXT:    fminnm v1.2d, v5.2d, v5.2d
; AARCH64-NEXT:    fmaxnm v2.2d, v2.2d, v1.2d
; AARCH64-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; AARCH64-NEXT:    // kill: def $d0 killed $d0 killed $q0
; AARCH64-NEXT:    // kill: def $d1 killed $d1 killed $q1
; AARCH64-NEXT:    // kill: def $d2 killed $d2 killed $q2
; AARCH64-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.maximumnum.v3f64(<3 x double> %a, <3 x double> %b)
  ret <3 x double> %c
}

define <4 x double> @max_v4f64(<4 x double> %a, <4 x double> %b) {
; AARCH64-LABEL: max_v4f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v2.2d, v2.2d, v2.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; AARCH64-NEXT:    fminnm v3.2d, v3.2d, v3.2d
; AARCH64-NEXT:    fminnm v1.2d, v1.2d, v1.2d
; AARCH64-NEXT:    fmaxnm v0.2d, v0.2d, v2.2d
; AARCH64-NEXT:    fmaxnm v1.2d, v1.2d, v3.2d
; AARCH64-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.maximumnum.v4f64(<4 x double> %a, <4 x double> %b)
  ret <4 x double> %c
}

;;;;;;;;;;;;;;;;;; max_f32
define float @max_f32(float %a, float %b) {
; AARCH64-LABEL: max_f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm s1, s1, s1
; AARCH64-NEXT:    fminnm s0, s0, s0
; AARCH64-NEXT:    fmaxnm s0, s0, s1
; AARCH64-NEXT:    ret
entry:
  %c = call float @llvm.maximumnum.f32(float %a, float %b)
  ret float %c
}

define <2 x float> @max_v2f32(<2 x float> %a, <2 x float> %b) {
; AARCH64-LABEL: max_v2f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.2s, v1.2s, v1.2s
; AARCH64-NEXT:    fminnm v0.2s, v0.2s, v0.2s
; AARCH64-NEXT:    fmaxnm v0.2s, v0.2s, v1.2s
; AARCH64-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.maximumnum.v2f32(<2 x float> %a, <2 x float> %b)
  ret <2 x float> %c
}

define <3 x float> @max_v3f32(<3 x float> %a, <3 x float> %b) {
; AARCH64-LABEL: max_v3f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.maximumnum.v3f32(<3 x float> %a, <3 x float> %b)
  ret <3 x float> %c
}

define <4 x float> @max_v4f32(<4 x float> %a, <4 x float> %b) {
; AARCH64-LABEL: max_v4f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.maximumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define <5 x float> @max_v5f32(<5 x float> %a, <5 x float> %b) {
; AARCH64-LABEL: max_v5f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $s0 killed $s0 def $q0
; AARCH64-NEXT:    // kill: def $s5 killed $s5 def $q5
; AARCH64-NEXT:    // kill: def $s1 killed $s1 def $q1
; AARCH64-NEXT:    // kill: def $s6 killed $s6 def $q6
; AARCH64-NEXT:    // kill: def $s2 killed $s2 def $q2
; AARCH64-NEXT:    // kill: def $s7 killed $s7 def $q7
; AARCH64-NEXT:    // kill: def $s3 killed $s3 def $q3
; AARCH64-NEXT:    mov x8, sp
; AARCH64-NEXT:    // kill: def $s4 killed $s4 def $q4
; AARCH64-NEXT:    mov v0.s[1], v1.s[0]
; AARCH64-NEXT:    mov v5.s[1], v6.s[0]
; AARCH64-NEXT:    mov v0.s[2], v2.s[0]
; AARCH64-NEXT:    mov v5.s[2], v7.s[0]
; AARCH64-NEXT:    ldr s2, [sp, #8]
; AARCH64-NEXT:    fminnm v2.4s, v2.4s, v2.4s
; AARCH64-NEXT:    mov v0.s[3], v3.s[0]
; AARCH64-NEXT:    ld1 { v5.s }[3], [x8]
; AARCH64-NEXT:    fminnm v3.4s, v4.4s, v4.4s
; AARCH64-NEXT:    fminnm v1.4s, v5.4s, v5.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fmaxnm v4.4s, v3.4s, v2.4s
; AARCH64-NEXT:    // kill: def $s4 killed $s4 killed $q4
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    mov s1, v0.s[1]
; AARCH64-NEXT:    mov s2, v0.s[2]
; AARCH64-NEXT:    mov s3, v0.s[3]
; AARCH64-NEXT:    // kill: def $s0 killed $s0 killed $q0
; AARCH64-NEXT:    ret
entry:
  %c = call <5 x float> @llvm.maximumnum.v5f32(<5 x float> %a, <5 x float> %b)
  ret <5 x float> %c
}

define <8 x float> @max_v8f32(<8 x float> %a, <8 x float> %b) {
; AARCH64-LABEL: max_v8f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v2.4s, v2.4s, v2.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fminnm v3.4s, v3.4s, v3.4s
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; AARCH64-NEXT:    fmaxnm v0.4s, v0.4s, v2.4s
; AARCH64-NEXT:    fmaxnm v1.4s, v1.4s, v3.4s
; AARCH64-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.maximumnum.v8f32(<8 x float> %a, <8 x float> %b)
  ret <8 x float> %c
}

;;;;;;;;;;;;;;;;;; max_f16
define half @max_f16(half %a, half %b) {
; AARCH64-LABEL: max_f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm h1, h1, h1
; AARCH64-NEXT:    fminnm h0, h0, h0
; AARCH64-NEXT:    fmaxnm h0, h0, h1
; AARCH64-NEXT:    ret
entry:
  %c = call half @llvm.maximumnum.f16(half %a, half %b)
  ret half %c
}

define <2 x half> @max_v2f16(<2 x half> %a, <2 x half> %b) {
; AARCH64-LABEL: max_v2f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4h, v1.4h, v1.4h
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; AARCH64-NEXT:    fmaxnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call <2 x half> @llvm.maximumnum.v2f16(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %c
}

define <4 x half> @max_v4f16(<4 x half> %a, <4 x half> %b) {
; AARCH64-LABEL: max_v4f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4h, v1.4h, v1.4h
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; AARCH64-NEXT:    fmaxnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.maximumnum.v4f16(<4 x half> %a, <4 x half> %b)
  ret <4 x half> %c
}

define <8 x half> @max_v8f16(<8 x half> %a, <8 x half> %b) {
; AARCH64-LABEL: max_v8f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v1.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; AARCH64-NEXT:    fmaxnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.maximumnum.v8f16(<8 x half> %a, <8 x half> %b)
  ret <8 x half> %c
}

define <9 x half> @max_v9f16(<9 x half> %a, <9 x half> %b) {
; AARCH64-LABEL: max_v9f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $h0 killed $h0 def $q0
; AARCH64-NEXT:    // kill: def $h1 killed $h1 def $q1
; AARCH64-NEXT:    // kill: def $h2 killed $h2 def $q2
; AARCH64-NEXT:    add x9, sp, #16
; AARCH64-NEXT:    // kill: def $h3 killed $h3 def $q3
; AARCH64-NEXT:    // kill: def $h4 killed $h4 def $q4
; AARCH64-NEXT:    // kill: def $h5 killed $h5 def $q5
; AARCH64-NEXT:    // kill: def $h6 killed $h6 def $q6
; AARCH64-NEXT:    // kill: def $h7 killed $h7 def $q7
; AARCH64-NEXT:    mov v0.h[1], v1.h[0]
; AARCH64-NEXT:    ldr h1, [sp, #8]
; AARCH64-NEXT:    ld1 { v1.h }[1], [x9]
; AARCH64-NEXT:    add x9, sp, #24
; AARCH64-NEXT:    mov v0.h[2], v2.h[0]
; AARCH64-NEXT:    ldr h2, [sp]
; AARCH64-NEXT:    ld1 { v1.h }[2], [x9]
; AARCH64-NEXT:    add x9, sp, #32
; AARCH64-NEXT:    fminnm v2.8h, v2.8h, v2.8h
; AARCH64-NEXT:    mov v0.h[3], v3.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[3], [x9]
; AARCH64-NEXT:    add x9, sp, #40
; AARCH64-NEXT:    ldr h3, [sp, #72]
; AARCH64-NEXT:    ld1 { v1.h }[4], [x9]
; AARCH64-NEXT:    add x9, sp, #48
; AARCH64-NEXT:    fminnm v3.8h, v3.8h, v3.8h
; AARCH64-NEXT:    mov v0.h[4], v4.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[5], [x9]
; AARCH64-NEXT:    add x9, sp, #56
; AARCH64-NEXT:    fmaxnm v2.8h, v2.8h, v3.8h
; AARCH64-NEXT:    mov v0.h[5], v5.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[6], [x9]
; AARCH64-NEXT:    add x9, sp, #64
; AARCH64-NEXT:    str h2, [x8, #16]
; AARCH64-NEXT:    mov v0.h[6], v6.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[7], [x9]
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v1.8h
; AARCH64-NEXT:    mov v0.h[7], v7.h[0]
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; AARCH64-NEXT:    fmaxnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    str q0, [x8]
; AARCH64-NEXT:    ret
entry:
  %c = call <9 x half> @llvm.maximumnum.v9f16(<9 x half> %a, <9 x half> %b)
  ret <9 x half> %c
}

define <16 x half> @max_v16f16(<16 x half> %a, <16 x half> %b) {
; AARCH64-LABEL: max_v16f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v2.8h, v2.8h, v2.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; AARCH64-NEXT:    fminnm v3.8h, v3.8h, v3.8h
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v1.8h
; AARCH64-NEXT:    fmaxnm v0.8h, v0.8h, v2.8h
; AARCH64-NEXT:    fmaxnm v1.8h, v1.8h, v3.8h
; AARCH64-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.maximumnum.v16f16(<16 x half> %a, <16 x half> %b)
  ret <16 x half> %c
}

;;;;;;;;;;;;;;;;  min_f64
define double @min_f64(double %a, double %b) {
; AARCH64-LABEL: min_f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm d1, d1, d1
; AARCH64-NEXT:    fminnm d0, d0, d0
; AARCH64-NEXT:    fminnm d0, d0, d1
; AARCH64-NEXT:    ret
entry:
  %c = call double @llvm.minimumnum.f64(double %a, double %b)
  ret double %c
}

define <2 x double> @min_v2f64(<2 x double> %a, <2 x double> %b) {
; AARCH64-LABEL: min_v2f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.2d, v1.2d, v1.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v1.2d
; AARCH64-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.minimumnum.v2f64(<2 x double> %a, <2 x double> %b)
  ret <2 x double> %c
}

define <3 x double> @min_v3f64(<3 x double> %a, <3 x double> %b) {
; AARCH64-LABEL: min_v3f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $d3 killed $d3 def $q3
; AARCH64-NEXT:    // kill: def $d0 killed $d0 def $q0
; AARCH64-NEXT:    // kill: def $d4 killed $d4 def $q4
; AARCH64-NEXT:    // kill: def $d1 killed $d1 def $q1
; AARCH64-NEXT:    // kill: def $d2 killed $d2 def $q2
; AARCH64-NEXT:    // kill: def $d5 killed $d5 def $q5
; AARCH64-NEXT:    mov v0.d[1], v1.d[0]
; AARCH64-NEXT:    mov v3.d[1], v4.d[0]
; AARCH64-NEXT:    fminnm v2.2d, v2.2d, v2.2d
; AARCH64-NEXT:    fminnm v1.2d, v3.2d, v3.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v1.2d
; AARCH64-NEXT:    fminnm v1.2d, v5.2d, v5.2d
; AARCH64-NEXT:    fminnm v2.2d, v2.2d, v1.2d
; AARCH64-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; AARCH64-NEXT:    // kill: def $d0 killed $d0 killed $q0
; AARCH64-NEXT:    // kill: def $d1 killed $d1 killed $q1
; AARCH64-NEXT:    // kill: def $d2 killed $d2 killed $q2
; AARCH64-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.minimumnum.v3f64(<3 x double> %a, <3 x double> %b)
  ret <3 x double> %c
}

define <4 x double> @min_v4f64(<4 x double> %a, <4 x double> %b) {
; AARCH64-LABEL: min_v4f64:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v2.2d, v2.2d, v2.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v0.2d
; AARCH64-NEXT:    fminnm v3.2d, v3.2d, v3.2d
; AARCH64-NEXT:    fminnm v1.2d, v1.2d, v1.2d
; AARCH64-NEXT:    fminnm v0.2d, v0.2d, v2.2d
; AARCH64-NEXT:    fminnm v1.2d, v1.2d, v3.2d
; AARCH64-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.minimumnum.v4f64(<4 x double> %a, <4 x double> %b)
  ret <4 x double> %c
}

;;;;;;;;;;;;;;;;;; min_f32
define float @min_f32(float %a, float %b) {
; AARCH64-LABEL: min_f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm s1, s1, s1
; AARCH64-NEXT:    fminnm s0, s0, s0
; AARCH64-NEXT:    fminnm s0, s0, s1
; AARCH64-NEXT:    ret
entry:
  %c = call float @llvm.minimumnum.f32(float %a, float %b)
  ret float %c
}

define <2 x float> @min_v2f32(<2 x float> %a, <2 x float> %b) {
; AARCH64-LABEL: min_v2f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.2s, v1.2s, v1.2s
; AARCH64-NEXT:    fminnm v0.2s, v0.2s, v0.2s
; AARCH64-NEXT:    fminnm v0.2s, v0.2s, v1.2s
; AARCH64-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.minimumnum.v2f32(<2 x float> %a, <2 x float> %b)
  ret <2 x float> %c
}

define <3 x float> @min_v3f32(<3 x float> %a, <3 x float> %b) {
; AARCH64-LABEL: min_v3f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.minimumnum.v3f32(<3 x float> %a, <3 x float> %b)
  ret <3 x float> %c
}

define <4 x float> @min_v4f32(<4 x float> %a, <4 x float> %b) {
; AARCH64-LABEL: min_v4f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.minimumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define <5 x float> @min_v5f32(<5 x float> %a, <5 x float> %b) {
; AARCH64-LABEL: min_v5f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $s0 killed $s0 def $q0
; AARCH64-NEXT:    // kill: def $s5 killed $s5 def $q5
; AARCH64-NEXT:    // kill: def $s1 killed $s1 def $q1
; AARCH64-NEXT:    // kill: def $s6 killed $s6 def $q6
; AARCH64-NEXT:    // kill: def $s2 killed $s2 def $q2
; AARCH64-NEXT:    // kill: def $s7 killed $s7 def $q7
; AARCH64-NEXT:    // kill: def $s3 killed $s3 def $q3
; AARCH64-NEXT:    mov x8, sp
; AARCH64-NEXT:    // kill: def $s4 killed $s4 def $q4
; AARCH64-NEXT:    mov v0.s[1], v1.s[0]
; AARCH64-NEXT:    mov v5.s[1], v6.s[0]
; AARCH64-NEXT:    mov v0.s[2], v2.s[0]
; AARCH64-NEXT:    mov v5.s[2], v7.s[0]
; AARCH64-NEXT:    ldr s2, [sp, #8]
; AARCH64-NEXT:    fminnm v2.4s, v2.4s, v2.4s
; AARCH64-NEXT:    mov v0.s[3], v3.s[0]
; AARCH64-NEXT:    ld1 { v5.s }[3], [x8]
; AARCH64-NEXT:    fminnm v3.4s, v4.4s, v4.4s
; AARCH64-NEXT:    fminnm v1.4s, v5.4s, v5.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fminnm v4.4s, v3.4s, v2.4s
; AARCH64-NEXT:    // kill: def $s4 killed $s4 killed $q4
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; AARCH64-NEXT:    mov s1, v0.s[1]
; AARCH64-NEXT:    mov s2, v0.s[2]
; AARCH64-NEXT:    mov s3, v0.s[3]
; AARCH64-NEXT:    // kill: def $s0 killed $s0 killed $q0
; AARCH64-NEXT:    ret
entry:
  %c = call <5 x float> @llvm.minimumnum.v5f32(<5 x float> %a, <5 x float> %b)
  ret <5 x float> %c
}

define <8 x float> @min_v8f32(<8 x float> %a, <8 x float> %b) {
; AARCH64-LABEL: min_v8f32:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v2.4s, v2.4s, v2.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; AARCH64-NEXT:    fminnm v3.4s, v3.4s, v3.4s
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; AARCH64-NEXT:    fminnm v0.4s, v0.4s, v2.4s
; AARCH64-NEXT:    fminnm v1.4s, v1.4s, v3.4s
; AARCH64-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.minimumnum.v8f32(<8 x float> %a, <8 x float> %b)
  ret <8 x float> %c
}

;;;;;;;;;;;;;;;;;; min_f16
define half @min_f16(half %a, half %b) {
; AARCH64-LABEL: min_f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm h1, h1, h1
; AARCH64-NEXT:    fminnm h0, h0, h0
; AARCH64-NEXT:    fminnm h0, h0, h1
; AARCH64-NEXT:    ret
entry:
  %c = call half @llvm.minimumnum.f16(half %a, half %b)
  ret half %c
}

define <2 x half> @min_v2f16(<2 x half> %a, <2 x half> %b) {
; AARCH64-LABEL: min_v2f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4h, v1.4h, v1.4h
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call <2 x half> @llvm.minimumnum.v2f16(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %c
}

define <4 x half> @min_v4f16(<4 x half> %a, <4 x half> %b) {
; AARCH64-LABEL: min_v4f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.4h, v1.4h, v1.4h
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v0.4h
; AARCH64-NEXT:    fminnm v0.4h, v0.4h, v1.4h
; AARCH64-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.minimumnum.v4f16(<4 x half> %a, <4 x half> %b)
  ret <4 x half> %c
}

define <8 x half> @min_v8f16(<8 x half> %a, <8 x half> %b) {
; AARCH64-LABEL: min_v8f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v1.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.minimumnum.v8f16(<8 x half> %a, <8 x half> %b)
  ret <8 x half> %c
}

define <9 x half> @min_v9f16(<9 x half> %a, <9 x half> %b) {
; AARCH64-LABEL: min_v9f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    // kill: def $h0 killed $h0 def $q0
; AARCH64-NEXT:    // kill: def $h1 killed $h1 def $q1
; AARCH64-NEXT:    // kill: def $h2 killed $h2 def $q2
; AARCH64-NEXT:    add x9, sp, #16
; AARCH64-NEXT:    // kill: def $h3 killed $h3 def $q3
; AARCH64-NEXT:    // kill: def $h4 killed $h4 def $q4
; AARCH64-NEXT:    // kill: def $h5 killed $h5 def $q5
; AARCH64-NEXT:    // kill: def $h6 killed $h6 def $q6
; AARCH64-NEXT:    // kill: def $h7 killed $h7 def $q7
; AARCH64-NEXT:    mov v0.h[1], v1.h[0]
; AARCH64-NEXT:    ldr h1, [sp, #8]
; AARCH64-NEXT:    ld1 { v1.h }[1], [x9]
; AARCH64-NEXT:    add x9, sp, #24
; AARCH64-NEXT:    mov v0.h[2], v2.h[0]
; AARCH64-NEXT:    ldr h2, [sp]
; AARCH64-NEXT:    ld1 { v1.h }[2], [x9]
; AARCH64-NEXT:    add x9, sp, #32
; AARCH64-NEXT:    fminnm v2.8h, v2.8h, v2.8h
; AARCH64-NEXT:    mov v0.h[3], v3.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[3], [x9]
; AARCH64-NEXT:    add x9, sp, #40
; AARCH64-NEXT:    ldr h3, [sp, #72]
; AARCH64-NEXT:    ld1 { v1.h }[4], [x9]
; AARCH64-NEXT:    add x9, sp, #48
; AARCH64-NEXT:    fminnm v3.8h, v3.8h, v3.8h
; AARCH64-NEXT:    mov v0.h[4], v4.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[5], [x9]
; AARCH64-NEXT:    add x9, sp, #56
; AARCH64-NEXT:    fminnm v2.8h, v2.8h, v3.8h
; AARCH64-NEXT:    mov v0.h[5], v5.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[6], [x9]
; AARCH64-NEXT:    add x9, sp, #64
; AARCH64-NEXT:    str h2, [x8, #16]
; AARCH64-NEXT:    mov v0.h[6], v6.h[0]
; AARCH64-NEXT:    ld1 { v1.h }[7], [x9]
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v1.8h
; AARCH64-NEXT:    mov v0.h[7], v7.h[0]
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v1.8h
; AARCH64-NEXT:    str q0, [x8]
; AARCH64-NEXT:    ret
entry:
  %c = call <9 x half> @llvm.minimumnum.v9f16(<9 x half> %a, <9 x half> %b)
  ret <9 x half> %c
}

define <16 x half> @min_v16f16(<16 x half> %a, <16 x half> %b) {
; AARCH64-LABEL: min_v16f16:
; AARCH64:       // %bb.0: // %entry
; AARCH64-NEXT:    fminnm v2.8h, v2.8h, v2.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v0.8h
; AARCH64-NEXT:    fminnm v3.8h, v3.8h, v3.8h
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v1.8h
; AARCH64-NEXT:    fminnm v0.8h, v0.8h, v2.8h
; AARCH64-NEXT:    fminnm v1.8h, v1.8h, v3.8h
; AARCH64-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.minimumnum.v16f16(<16 x half> %a, <16 x half> %b)
  ret <16 x half> %c
}
