; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+v,+zvfbfmin \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+v,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfhmin,+v,+zvfbfmin \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfhmin,+v,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN

define <vscale x 1 x bfloat> @vsitofp_nxv1i1_nxv1bf16(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv1i1_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i1> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vuitofp_nxv1i1_nxv1bf16(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv1i1_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i1> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vsitofp_nxv2i1_nxv2bf16(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv2i1_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i1> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vuitofp_nxv2i1_nxv2bf16(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv2i1_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i1> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vsitofp_nxv4i1_nxv4bf16(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv4i1_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i1> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vuitofp_nxv4i1_nxv4bf16(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv4i1_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i1> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vsitofp_nxv8i1_nxv8bf16(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv8i1_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i1> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vuitofp_nxv8i1_nxv8bf16(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv8i1_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i1> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vsitofp_nxv16i1_nxv16bf16(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv16i1_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i1> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vuitofp_nxv16i1_nxv16bf16(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv16i1_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i1> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 32 x bfloat> @vsitofp_nxv32i1_nxv32bf16(<vscale x 32 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv32i1_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v12, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmerge.vim v8, v12, -1, v0
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    vmerge.vim v12, v12, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v16, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 32 x i1> %va to <vscale x 32 x bfloat>
  ret <vscale x 32 x bfloat> %evec
}

define <vscale x 32 x bfloat> @vuitofp_nxv32i1_nxv32bf16(<vscale x 32 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv32i1_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v12, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmerge.vim v8, v12, 1, v0
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    vmerge.vim v12, v12, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 32 x i1> %va to <vscale x 32 x bfloat>
  ret <vscale x 32 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vsitofp_nxv1i8_nxv1bf16(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv1i8_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i8> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vsitofp_nxv1i7_nxv1bf16(<vscale x 1 x i7> %va) {
; CHECK-LABEL: vsitofp_nxv1i7_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vsra.vi v8, v8, 1
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i7> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vuitofp_nxv1i7_nxv1bf16(<vscale x 1 x i7> %va) {
; CHECK-LABEL: vuitofp_nxv1i7_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 127
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i7> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vuitofp_nxv1i8_nxv1bf16(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv1i8_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i8> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vsitofp_nxv2i8_nxv2bf16(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv2i8_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i8> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vuitofp_nxv2i8_nxv2bf16(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv2i8_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i8> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vsitofp_nxv4i8_nxv4bf16(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv4i8_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i8> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vuitofp_nxv4i8_nxv4bf16(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv4i8_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i8> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vsitofp_nxv8i8_nxv8bf16(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv8i8_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.x.v v12, v10
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i8> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vuitofp_nxv8i8_nxv8bf16(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv8i8_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i8> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vsitofp_nxv16i8_nxv16bf16(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv16i8_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v16, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i8> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vuitofp_nxv16i8_nxv16bf16(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv16i8_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i8> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 32 x bfloat> @vsitofp_nxv32i8_nxv32bf16(<vscale x 32 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv32i8_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vsext.vf2 v16, v10
; CHECK-NEXT:    vfwcvt.f.x.v v24, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v24
; CHECK-NEXT:    vfwcvt.f.x.v v24, v16
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v24
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 32 x i8> %va to <vscale x 32 x bfloat>
  ret <vscale x 32 x bfloat> %evec
}

define <vscale x 32 x bfloat> @vuitofp_nxv32i8_nxv32bf16(<vscale x 32 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv32i8_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vzext.vf2 v16, v10
; CHECK-NEXT:    vfwcvt.f.xu.v v24, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v24
; CHECK-NEXT:    vfwcvt.f.xu.v v24, v16
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v24
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 32 x i8> %va to <vscale x 32 x bfloat>
  ret <vscale x 32 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vsitofp_nxv1i16_nxv1bf16(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv1i16_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i16> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vuitofp_nxv1i16_nxv1bf16(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv1i16_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i16> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vsitofp_nxv2i16_nxv2bf16(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv2i16_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i16> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vuitofp_nxv2i16_nxv2bf16(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv2i16_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i16> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vsitofp_nxv4i16_nxv4bf16(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv4i16_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i16> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vuitofp_nxv4i16_nxv4bf16(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv4i16_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i16> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vsitofp_nxv8i16_nxv8bf16(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv8i16_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i16> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vuitofp_nxv8i16_nxv8bf16(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv8i16_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i16> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vsitofp_nxv16i16_nxv16bf16(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv16i16_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i16> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vuitofp_nxv16i16_nxv16bf16(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv16i16_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i16> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 32 x bfloat> @vsitofp_nxv32i16_nxv32bf16(<vscale x 32 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv32i16_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    vfwcvt.f.x.v v16, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 32 x i16> %va to <vscale x 32 x bfloat>
  ret <vscale x 32 x bfloat> %evec
}

define <vscale x 32 x bfloat> @vuitofp_nxv32i16_nxv32bf16(<vscale x 32 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv32i16_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-NEXT:    vfncvtbf16.f.f.w v12, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 32 x i16> %va to <vscale x 32 x bfloat>
  ret <vscale x 32 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vsitofp_nxv1i32_nxv1bf16(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv1i32_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i32> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vuitofp_nxv1i32_nxv1bf16(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv1i32_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i32> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vsitofp_nxv2i32_nxv2bf16(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv2i32_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i32> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vuitofp_nxv2i32_nxv2bf16(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv2i32_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i32> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vsitofp_nxv4i32_nxv4bf16(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv4i32_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i32> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vuitofp_nxv4i32_nxv4bf16(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv4i32_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i32> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vsitofp_nxv8i32_nxv8bf16(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv8i32_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i32> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vuitofp_nxv8i32_nxv8bf16(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv8i32_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i32> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vsitofp_nxv16i32_nxv16bf16(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv16i32_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i32> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 16 x bfloat> @vuitofp_nxv16i32_nxv16bf16(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv16i32_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i32> %va to <vscale x 16 x bfloat>
  ret <vscale x 16 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vsitofp_nxv1i64_nxv1bf16(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv1i64_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i64> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 1 x bfloat> @vuitofp_nxv1i64_nxv1bf16(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv1i64_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i64> %va to <vscale x 1 x bfloat>
  ret <vscale x 1 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vsitofp_nxv2i64_nxv2bf16(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv2i64_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i64> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 2 x bfloat> @vuitofp_nxv2i64_nxv2bf16(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv2i64_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i64> %va to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vsitofp_nxv4i64_nxv4bf16(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv4i64_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i64> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 4 x bfloat> @vuitofp_nxv4i64_nxv4bf16(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv4i64_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i64> %va to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vsitofp_nxv8i64_nxv8bf16(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv8i64_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i64> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 8 x bfloat> @vuitofp_nxv8i64_nxv8bf16(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv8i64_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvtbf16.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i64> %va to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i1_nxv1f16(<vscale x 1 x i1> %va) {
; ZVFH-LABEL: vsitofp_nxv1i1_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv1i1_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 1 x i1> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i1_nxv1f16(<vscale x 1 x i1> %va) {
; ZVFH-LABEL: vuitofp_nxv1i1_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv1i1_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 1 x i1> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i1_nxv1f32(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv1i1_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i1> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i1_nxv1f32(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv1i1_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i1> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i1_nxv1f64(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv1i1_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i1> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i1_nxv1f64(<vscale x 1 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv1i1_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i1> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i1_nxv2f16(<vscale x 2 x i1> %va) {
; ZVFH-LABEL: vsitofp_nxv2i1_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv2i1_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 2 x i1> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i1_nxv2f16(<vscale x 2 x i1> %va) {
; ZVFH-LABEL: vuitofp_nxv2i1_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv2i1_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 2 x i1> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i1_nxv2f32(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv2i1_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i1> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i1_nxv2f32(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv2i1_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i1> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i1_nxv2f64(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv2i1_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i1> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i1_nxv2f64(<vscale x 2 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv2i1_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i1> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i1_nxv4f16(<vscale x 4 x i1> %va) {
; ZVFH-LABEL: vsitofp_nxv4i1_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv4i1_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 4 x i1> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i1_nxv4f16(<vscale x 4 x i1> %va) {
; ZVFH-LABEL: vuitofp_nxv4i1_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v9, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv4i1_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 4 x i1> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i1_nxv4f32(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv4i1_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i1> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i1_nxv4f32(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv4i1_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i1> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i1_nxv4f64(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv4i1_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i1> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i1_nxv4f64(<vscale x 4 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv4i1_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i1> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i1_nxv8f16(<vscale x 8 x i1> %va) {
; ZVFH-LABEL: vsitofp_nxv8i1_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v10, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv8i1_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 8 x i1> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i1_nxv8f16(<vscale x 8 x i1> %va) {
; ZVFH-LABEL: vuitofp_nxv8i1_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v10, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv8i1_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 8 x i1> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i1_nxv8f32(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv8i1_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i1> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i1_nxv8f32(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv8i1_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i1> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i1_nxv8f64(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv8i1_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v16, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i1> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i1_nxv8f64(<vscale x 8 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv8i1_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v16, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i1> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i1_nxv16f16(<vscale x 16 x i1> %va) {
; ZVFH-LABEL: vsitofp_nxv16i1_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v12, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv16i1_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 16 x i1> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i1_nxv16f16(<vscale x 16 x i1> %va) {
; ZVFH-LABEL: vuitofp_nxv16i1_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v12, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv16i1_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v8, 0
; ZVFHMIN-NEXT:    vmerge.vim v8, v8, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 16 x i1> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i1_nxv16f32(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vsitofp_nxv16i1_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v16, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i1> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i1_nxv16f32(<vscale x 16 x i1> %va) {
; CHECK-LABEL: vuitofp_nxv16i1_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v16, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i1> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 32 x half> @vsitofp_nxv32i1_nxv32f16(<vscale x 32 x i1> %va) {
; ZVFH-LABEL: vsitofp_nxv32i1_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v16, v8, -1, v0
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv32i1_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v12, 0
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    vmerge.vim v8, v12, -1, v0
; ZVFHMIN-NEXT:    srli a0, a0, 2
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v16, v8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v0, v0, a0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    vmerge.vim v12, v12, -1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v16
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 32 x i1> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 32 x half> @vuitofp_nxv32i1_nxv32f16(<vscale x 32 x i1> %va) {
; ZVFH-LABEL: vuitofp_nxv32i1_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vmv.v.i v8, 0
; ZVFH-NEXT:    vmerge.vim v16, v8, 1, v0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv32i1_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vmv.v.i v12, 0
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    vmerge.vim v8, v12, 1, v0
; ZVFHMIN-NEXT:    srli a0, a0, 2
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v16, v8
; ZVFHMIN-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslidedown.vx v0, v0, a0
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    vmerge.vim v12, v12, 1, v0
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v16
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 32 x i1> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i8_nxv1f16(<vscale x 1 x i8> %va) {
; ZVFH-LABEL: vsitofp_nxv1i8_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv1i8_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vsext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 1 x i8> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i7_nxv1f16(<vscale x 1 x i7> %va) {
; ZVFH-LABEL: vsitofp_nxv1i7_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vadd.vv v8, v8, v8
; ZVFH-NEXT:    vsra.vi v9, v8, 1
; ZVFH-NEXT:    vfwcvt.f.x.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv1i7_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFHMIN-NEXT:    vadd.vv v8, v8, v8
; ZVFHMIN-NEXT:    vsra.vi v8, v8, 1
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vsext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 1 x i7> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i7_nxv1f16(<vscale x 1 x i7> %va) {
; ZVFH-LABEL: vuitofp_nxv1i7_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    li a0, 127
; ZVFH-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vand.vx v9, v8, a0
; ZVFH-NEXT:    vfwcvt.f.xu.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv1i7_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    li a0, 127
; ZVFHMIN-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; ZVFHMIN-NEXT:    vand.vx v8, v8, a0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vzext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 1 x i7> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i8_nxv1f16(<vscale x 1 x i8> %va) {
; ZVFH-LABEL: vuitofp_nxv1i8_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv1i8_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vzext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 1 x i8> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i8_nxv1f32(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv1i8_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i8> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i8_nxv1f32(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv1i8_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i8> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i8_nxv1f64(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv1i8_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i8> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i8_nxv1f64(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv1i8_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf4 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i8> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i8_nxv2f16(<vscale x 2 x i8> %va) {
; ZVFH-LABEL: vsitofp_nxv2i8_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv2i8_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vsext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 2 x i8> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i8_nxv2f16(<vscale x 2 x i8> %va) {
; ZVFH-LABEL: vuitofp_nxv2i8_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv2i8_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vzext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 2 x i8> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i8_nxv2f32(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv2i8_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i8> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i8_nxv2f32(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv2i8_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i8> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i8_nxv2f64(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv2i8_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i8> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i8_nxv2f64(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv2i8_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf4 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i8> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i8_nxv4f16(<vscale x 4 x i8> %va) {
; ZVFH-LABEL: vsitofp_nxv4i8_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv4i8_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vsext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 4 x i8> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i8_nxv4f16(<vscale x 4 x i8> %va) {
; ZVFH-LABEL: vuitofp_nxv4i8_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv4i8_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vzext.vf2 v9, v8
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v10, v9
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 4 x i8> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i8_nxv4f32(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv4i8_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i8> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i8_nxv4f32(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv4i8_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i8> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i8_nxv4f64(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv4i8_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i8> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i8_nxv4f64(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv4i8_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf4 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i8> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i8_nxv8f16(<vscale x 8 x i8> %va) {
; ZVFH-LABEL: vsitofp_nxv8i8_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vfwcvt.f.x.v v10, v8
; ZVFH-NEXT:    vmv2r.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv8i8_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vsext.vf2 v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v12, v10
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 8 x i8> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i8_nxv8f16(<vscale x 8 x i8> %va) {
; ZVFH-LABEL: vuitofp_nxv8i8_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vfwcvt.f.xu.v v10, v8
; ZVFH-NEXT:    vmv2r.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv8i8_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vzext.vf2 v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v12, v10
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 8 x i8> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i8_nxv8f32(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv8i8_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i8> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i8_nxv8f32(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv8i8_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i8> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i8_nxv8f64(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv8i8_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v16, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i8> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i8_nxv8f64(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv8i8_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf4 v16, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i8> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i8_nxv16f16(<vscale x 16 x i8> %va) {
; ZVFH-LABEL: vsitofp_nxv16i8_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vfwcvt.f.x.v v12, v8
; ZVFH-NEXT:    vmv4r.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv16i8_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vsext.vf2 v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 16 x i8> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i8_nxv16f16(<vscale x 16 x i8> %va) {
; ZVFH-LABEL: vuitofp_nxv16i8_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vfwcvt.f.xu.v v12, v8
; ZVFH-NEXT:    vmv4r.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv16i8_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vzext.vf2 v12, v8
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 16 x i8> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i8_nxv16f32(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vsitofp_nxv16i8_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v16, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i8> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i8_nxv16f32(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vuitofp_nxv16i8_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v16, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i8> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 32 x half> @vsitofp_nxv32i8_nxv32f16(<vscale x 32 x i8> %va) {
; ZVFH-LABEL: vsitofp_nxv32i8_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vfwcvt.f.x.v v16, v8
; ZVFH-NEXT:    vmv8r.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv32i8_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vsext.vf2 v12, v8
; ZVFHMIN-NEXT:    vsext.vf2 v16, v10
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v24, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v24
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v24, v16
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v24
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 32 x i8> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 32 x half> @vuitofp_nxv32i8_nxv32f16(<vscale x 32 x i8> %va) {
; ZVFH-LABEL: vuitofp_nxv32i8_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vfwcvt.f.xu.v v16, v8
; ZVFH-NEXT:    vmv8r.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv32i8_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vzext.vf2 v12, v8
; ZVFHMIN-NEXT:    vzext.vf2 v16, v10
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v24, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v24
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v24, v16
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v24
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 32 x i8> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i16_nxv1f16(<vscale x 1 x i16> %va) {
; ZVFH-LABEL: vsitofp_nxv1i16_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfcvt.f.x.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv1i16_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 1 x i16> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i16_nxv1f16(<vscale x 1 x i16> %va) {
; ZVFH-LABEL: vuitofp_nxv1i16_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfcvt.f.xu.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv1i16_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 1 x i16> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i16_nxv1f32(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv1i16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i16> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i16_nxv1f32(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv1i16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i16> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i16_nxv1f64(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv1i16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i16> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i16_nxv1f64(<vscale x 1 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv1i16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i16> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i16_nxv2f16(<vscale x 2 x i16> %va) {
; ZVFH-LABEL: vsitofp_nxv2i16_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfcvt.f.x.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv2i16_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 2 x i16> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i16_nxv2f16(<vscale x 2 x i16> %va) {
; ZVFH-LABEL: vuitofp_nxv2i16_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfcvt.f.xu.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv2i16_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 2 x i16> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i16_nxv2f32(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv2i16_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i16> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i16_nxv2f32(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv2i16_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i16> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i16_nxv2f64(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv2i16_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i16> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i16_nxv2f64(<vscale x 2 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv2i16_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i16> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i16_nxv4f16(<vscale x 4 x i16> %va) {
; ZVFH-LABEL: vsitofp_nxv4i16_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfcvt.f.x.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv4i16_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 4 x i16> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i16_nxv4f16(<vscale x 4 x i16> %va) {
; ZVFH-LABEL: vuitofp_nxv4i16_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfcvt.f.xu.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv4i16_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 4 x i16> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i16_nxv4f32(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv4i16_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i16> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i16_nxv4f32(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv4i16_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i16> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i16_nxv4f64(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv4i16_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i16> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i16_nxv4f64(<vscale x 4 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv4i16_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i16> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i16_nxv8f16(<vscale x 8 x i16> %va) {
; ZVFH-LABEL: vsitofp_nxv8i16_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfcvt.f.x.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv8i16_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 8 x i16> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i16_nxv8f16(<vscale x 8 x i16> %va) {
; ZVFH-LABEL: vuitofp_nxv8i16_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfcvt.f.xu.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv8i16_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 8 x i16> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i16_nxv8f32(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv8i16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i16> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i16_nxv8f32(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv8i16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i16> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i16_nxv8f64(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv8i16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v16, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i16> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i16_nxv8f64(<vscale x 8 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv8i16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v16, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i16> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i16_nxv16f16(<vscale x 16 x i16> %va) {
; ZVFH-LABEL: vsitofp_nxv16i16_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfcvt.f.x.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv16i16_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 16 x i16> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i16_nxv16f16(<vscale x 16 x i16> %va) {
; ZVFH-LABEL: vuitofp_nxv16i16_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfcvt.f.xu.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv16i16_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 16 x i16> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i16_nxv16f32(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vsitofp_nxv16i16_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i16> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i16_nxv16f32(<vscale x 16 x i16> %va) {
; CHECK-LABEL: vuitofp_nxv16i16_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i16> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 32 x half> @vsitofp_nxv32i16_nxv32f16(<vscale x 32 x i16> %va) {
; ZVFH-LABEL: vsitofp_nxv32i16_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfcvt.f.x.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv32i16_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    vfwcvt.f.x.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v16
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 32 x i16> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 32 x half> @vuitofp_nxv32i16_nxv32f16(<vscale x 32 x i16> %va) {
; ZVFH-LABEL: vuitofp_nxv32i16_nxv32f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfcvt.f.xu.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv32i16_nxv32f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    vfwcvt.f.xu.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.f.f.w v12, v16
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 32 x i16> %va to <vscale x 32 x half>
  ret <vscale x 32 x half> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i32_nxv1f16(<vscale x 1 x i32> %va) {
; ZVFH-LABEL: vsitofp_nxv1i32_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.x.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv1i32_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.x.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 1 x i32> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i32_nxv1f16(<vscale x 1 x i32> %va) {
; ZVFH-LABEL: vuitofp_nxv1i32_nxv1f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.f.xu.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv1i32_nxv1f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.xu.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 1 x i32> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i32_nxv1f32(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv1i32_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i32> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i32_nxv1f32(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv1i32_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i32> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i32_nxv1f64(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv1i32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i32> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i32_nxv1f64(<vscale x 1 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv1i32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i32> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i32_nxv2f16(<vscale x 2 x i32> %va) {
; ZVFH-LABEL: vsitofp_nxv2i32_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.f.x.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv2i32_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.x.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 2 x i32> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i32_nxv2f16(<vscale x 2 x i32> %va) {
; ZVFH-LABEL: vuitofp_nxv2i32_nxv2f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.f.xu.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv2i32_nxv2f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.xu.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 2 x i32> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i32_nxv2f32(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv2i32_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i32> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i32_nxv2f32(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv2i32_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i32> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i32_nxv2f64(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv2i32_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i32> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i32_nxv2f64(<vscale x 2 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv2i32_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i32> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i32_nxv4f16(<vscale x 4 x i32> %va) {
; ZVFH-LABEL: vsitofp_nxv4i32_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfncvt.f.x.w v10, v8
; ZVFH-NEXT:    vmv.v.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv4i32_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.x.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 4 x i32> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i32_nxv4f16(<vscale x 4 x i32> %va) {
; ZVFH-LABEL: vuitofp_nxv4i32_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfncvt.f.xu.w v10, v8
; ZVFH-NEXT:    vmv.v.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv4i32_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.xu.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 4 x i32> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i32_nxv4f32(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv4i32_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i32> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i32_nxv4f32(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv4i32_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i32> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i32_nxv4f64(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv4i32_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i32> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i32_nxv4f64(<vscale x 4 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv4i32_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i32> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i32_nxv8f16(<vscale x 8 x i32> %va) {
; ZVFH-LABEL: vsitofp_nxv8i32_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.x.w v12, v8
; ZVFH-NEXT:    vmv.v.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv8i32_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.x.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 8 x i32> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i32_nxv8f16(<vscale x 8 x i32> %va) {
; ZVFH-LABEL: vuitofp_nxv8i32_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfncvt.f.xu.w v12, v8
; ZVFH-NEXT:    vmv.v.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv8i32_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.xu.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 8 x i32> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i32_nxv8f32(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv8i32_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i32> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i32_nxv8f32(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv8i32_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i32> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i32_nxv8f64(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv8i32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i32> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i32_nxv8f64(<vscale x 8 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv8i32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-NEXT:    vmv8r.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i32> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 16 x half> @vsitofp_nxv16i32_nxv16f16(<vscale x 16 x i32> %va) {
; ZVFH-LABEL: vsitofp_nxv16i32_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfncvt.f.x.w v16, v8
; ZVFH-NEXT:    vmv.v.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsitofp_nxv16i32_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.x.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = sitofp <vscale x 16 x i32> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x half> @vuitofp_nxv16i32_nxv16f16(<vscale x 16 x i32> %va) {
; ZVFH-LABEL: vuitofp_nxv16i32_nxv16f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfncvt.f.xu.w v16, v8
; ZVFH-NEXT:    vmv.v.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vuitofp_nxv16i32_nxv16f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.f.xu.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = uitofp <vscale x 16 x i32> %va to <vscale x 16 x half>
  ret <vscale x 16 x half> %evec
}

define <vscale x 16 x float> @vsitofp_nxv16i32_nxv16f32(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vsitofp_nxv16i32_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 16 x i32> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 16 x float> @vuitofp_nxv16i32_nxv16f32(<vscale x 16 x i32> %va) {
; CHECK-LABEL: vuitofp_nxv16i32_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 16 x i32> %va to <vscale x 16 x float>
  ret <vscale x 16 x float> %evec
}

define <vscale x 1 x half> @vsitofp_nxv1i64_nxv1f16(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv1i64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i64> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x half> @vuitofp_nxv1i64_nxv1f16(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv1i64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i64> %va to <vscale x 1 x half>
  ret <vscale x 1 x half> %evec
}

define <vscale x 1 x float> @vsitofp_nxv1i64_nxv1f32(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv1i64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i64> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x float> @vuitofp_nxv1i64_nxv1f32(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv1i64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i64> %va to <vscale x 1 x float>
  ret <vscale x 1 x float> %evec
}

define <vscale x 1 x double> @vsitofp_nxv1i64_nxv1f64(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv1i64_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 1 x i64> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 1 x double> @vuitofp_nxv1i64_nxv1f64(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv1i64_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 1 x i64> %va to <vscale x 1 x double>
  ret <vscale x 1 x double> %evec
}

define <vscale x 2 x half> @vsitofp_nxv2i64_nxv2f16(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv2i64_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i64> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x half> @vuitofp_nxv2i64_nxv2f16(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv2i64_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i64> %va to <vscale x 2 x half>
  ret <vscale x 2 x half> %evec
}

define <vscale x 2 x float> @vsitofp_nxv2i64_nxv2f32(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv2i64_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i64> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x float> @vuitofp_nxv2i64_nxv2f32(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv2i64_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i64> %va to <vscale x 2 x float>
  ret <vscale x 2 x float> %evec
}

define <vscale x 2 x double> @vsitofp_nxv2i64_nxv2f64(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv2i64_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 2 x i64> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 2 x double> @vuitofp_nxv2i64_nxv2f64(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv2i64_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 2 x i64> %va to <vscale x 2 x double>
  ret <vscale x 2 x double> %evec
}

define <vscale x 4 x half> @vsitofp_nxv4i64_nxv4f16(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv4i64_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i64> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x half> @vuitofp_nxv4i64_nxv4f16(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv4i64_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i64> %va to <vscale x 4 x half>
  ret <vscale x 4 x half> %evec
}

define <vscale x 4 x float> @vsitofp_nxv4i64_nxv4f32(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv4i64_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i64> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x float> @vuitofp_nxv4i64_nxv4f32(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv4i64_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i64> %va to <vscale x 4 x float>
  ret <vscale x 4 x float> %evec
}

define <vscale x 4 x double> @vsitofp_nxv4i64_nxv4f64(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv4i64_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 4 x i64> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 4 x double> @vuitofp_nxv4i64_nxv4f64(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv4i64_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 4 x i64> %va to <vscale x 4 x double>
  ret <vscale x 4 x double> %evec
}

define <vscale x 8 x half> @vsitofp_nxv8i64_nxv8f16(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv8i64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i64> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x half> @vuitofp_nxv8i64_nxv8f16(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv8i64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i64> %va to <vscale x 8 x half>
  ret <vscale x 8 x half> %evec
}

define <vscale x 8 x float> @vsitofp_nxv8i64_nxv8f32(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv8i64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i64> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x float> @vuitofp_nxv8i64_nxv8f32(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv8i64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i64> %va to <vscale x 8 x float>
  ret <vscale x 8 x float> %evec
}

define <vscale x 8 x double> @vsitofp_nxv8i64_nxv8f64(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vsitofp_nxv8i64_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = sitofp <vscale x 8 x i64> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}

define <vscale x 8 x double> @vuitofp_nxv8i64_nxv8f64(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vuitofp_nxv8i64_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = uitofp <vscale x 8 x i64> %va to <vscale x 8 x double>
  ret <vscale x 8 x double> %evec
}
