; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=aarch64 -mattr=+sve %s | FileCheck --check-prefixes=CHECK,CHECK-SVE %s
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=aarch64 -mattr=+sve -force-streaming-compatible %s | FileCheck --check-prefixes=CHECK,SVE128-NO-NEON %s
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=aarch64 -mattr=+sve -aarch64-sve-vector-bits-min=256 %s | FileCheck --check-prefixes=CHECK,FIXED-MIN-256 %s
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=aarch64 -mattr=+sve -aarch64-sve-vector-bits-min=2048 %s | FileCheck --check-prefixes=CHECK,FIXED-MIN-2048 %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @ext() {
; CHECK-SVE-LABEL: 'ext'
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i1 undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i1 undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i1 undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i1 undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i1 undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i1 undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i1 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i1 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = sext i8 undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = zext i8 undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = sext i8 undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r12 = zext i8 undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r13 = sext i8 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r14 = zext i8 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r17 = sext i16 undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r18 = zext i16 undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r19 = sext i16 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r20 = zext i16 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r24 = sext i32 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r25 = zext i32 undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i16 = sext <2 x i8> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i16 = zext <2 x i8> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i32 = sext <2 x i8> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i32 = zext <2 x i8> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i64 = sext <2 x i8> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i64 = zext <2 x i8> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i32 = sext <2 x i16> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i32 = zext <2 x i16> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i64 = sext <2 x i16> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i64 = zext <2 x i16> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i32i64 = sext <2 x i32> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i32i64 = zext <2 x i32> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i16 = sext <4 x i8> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i16 = zext <4 x i8> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i32 = sext <4 x i8> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i32 = zext <4 x i8> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %s4i8i64 = sext <4 x i8> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %z4i8i64 = zext <4 x i8> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i32 = sext <4 x i16> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i16i32 = zext <4 x i16> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %s4i16i64 = sext <4 x i16> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %z4i16i64 = zext <4 x i16> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s4i32i64 = sext <4 x i32> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z4i32i64 = zext <4 x i32> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i16 = sext <8 x i8> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i8i16 = zext <8 x i8> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %s8i8i32 = sext <8 x i8> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %z8i8i32 = zext <8 x i8> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %s8i8i64 = sext <8 x i8> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %z8i8i64 = zext <8 x i8> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i16i32 = sext <8 x i16> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z8i16i32 = zext <8 x i16> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %s8i16i64 = sext <8 x i16> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %z8i16i64 = zext <8 x i16> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s8i32i64 = sext <8 x i32> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z8i32i64 = zext <8 x i32> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s16i8i16 = sext <16 x i8> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z16i8i16 = zext <16 x i8> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %s16i8i32 = sext <16 x i8> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %z16i8i32 = zext <16 x i8> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %s16i8i64 = sext <16 x i8> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %z16i8i64 = zext <16 x i8> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s16i16i32 = sext <16 x i16> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z16i16i32 = zext <16 x i16> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %s16i16i64 = sext <16 x i16> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %z16i16i64 = zext <16 x i16> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %s16i32i64 = sext <16 x i32> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %z16i32i64 = zext <16 x i32> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SVE128-NO-NEON-LABEL: 'ext'
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i1 undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i1 undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i1 undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i1 undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i1 undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i1 undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i1 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i1 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = sext i8 undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = zext i8 undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = sext i8 undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r12 = zext i8 undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r13 = sext i8 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r14 = zext i8 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r17 = sext i16 undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r18 = zext i16 undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r19 = sext i16 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r20 = zext i16 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r24 = sext i32 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r25 = zext i32 undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i16 = sext <2 x i8> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i16 = zext <2 x i8> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i32 = sext <2 x i8> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i32 = zext <2 x i8> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i64 = sext <2 x i8> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i64 = zext <2 x i8> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i32 = sext <2 x i16> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i32 = zext <2 x i16> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i64 = sext <2 x i16> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i64 = zext <2 x i16> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i32i64 = sext <2 x i32> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i32i64 = zext <2 x i32> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i16 = sext <4 x i8> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i16 = zext <4 x i8> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i32 = sext <4 x i8> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i32 = zext <4 x i8> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s4i8i64 = sext <4 x i8> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z4i8i64 = zext <4 x i8> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i32 = sext <4 x i16> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i16i32 = zext <4 x i16> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s4i16i64 = sext <4 x i16> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z4i16i64 = zext <4 x i16> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s4i32i64 = sext <4 x i32> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z4i32i64 = zext <4 x i32> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i16 = sext <8 x i8> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i8i16 = zext <8 x i8> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i8i32 = sext <8 x i8> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z8i8i32 = zext <8 x i8> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s8i8i64 = sext <8 x i8> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z8i8i64 = zext <8 x i8> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i16i32 = sext <8 x i16> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z8i16i32 = zext <8 x i16> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s8i16i64 = sext <8 x i16> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z8i16i64 = zext <8 x i16> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s8i32i64 = sext <8 x i32> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z8i32i64 = zext <8 x i32> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s16i8i16 = sext <16 x i8> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z16i8i16 = zext <16 x i8> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s16i8i32 = sext <16 x i8> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z16i8i32 = zext <16 x i8> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %s16i8i64 = sext <16 x i8> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %z16i8i64 = zext <16 x i8> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s16i16i32 = sext <16 x i16> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z16i16i32 = zext <16 x i16> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %s16i16i64 = sext <16 x i16> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %z16i16i64 = zext <16 x i16> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %s16i32i64 = sext <16 x i32> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %z16i32i64 = zext <16 x i32> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; FIXED-MIN-256-LABEL: 'ext'
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i1 undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i1 undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i1 undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i1 undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i1 undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i1 undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i1 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i1 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = sext i8 undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = zext i8 undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = sext i8 undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r12 = zext i8 undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r13 = sext i8 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r14 = zext i8 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r17 = sext i16 undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r18 = zext i16 undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r19 = sext i16 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r20 = zext i16 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r24 = sext i32 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r25 = zext i32 undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i16 = sext <2 x i8> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i16 = zext <2 x i8> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i32 = sext <2 x i8> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i32 = zext <2 x i8> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i64 = sext <2 x i8> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i64 = zext <2 x i8> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i32 = sext <2 x i16> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i32 = zext <2 x i16> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i64 = sext <2 x i16> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i64 = zext <2 x i16> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i32i64 = sext <2 x i32> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i32i64 = zext <2 x i32> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i16 = sext <4 x i8> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i16 = zext <4 x i8> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i32 = sext <4 x i8> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i32 = zext <4 x i8> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i64 = sext <4 x i8> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i64 = zext <4 x i8> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i32 = sext <4 x i16> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i16i32 = zext <4 x i16> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i64 = sext <4 x i16> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i16i64 = zext <4 x i16> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i32i64 = sext <4 x i32> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i32i64 = zext <4 x i32> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i16 = sext <8 x i8> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i8i16 = zext <8 x i8> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i32 = sext <8 x i8> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i8i32 = zext <8 x i8> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i8i64 = sext <8 x i8> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z8i8i64 = zext <8 x i8> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i16i32 = sext <8 x i16> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i16i32 = zext <8 x i16> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i16i64 = sext <8 x i16> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z8i16i64 = zext <8 x i16> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i32i64 = sext <8 x i32> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z8i32i64 = zext <8 x i32> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i8i16 = sext <16 x i8> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16i8i16 = zext <16 x i8> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s16i8i32 = sext <16 x i8> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z16i8i32 = zext <16 x i8> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s16i8i64 = sext <16 x i8> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z16i8i64 = zext <16 x i8> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s16i16i32 = sext <16 x i16> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %z16i16i32 = zext <16 x i16> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s16i16i64 = sext <16 x i16> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z16i16i64 = zext <16 x i16> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s16i32i64 = sext <16 x i32> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %z16i32i64 = zext <16 x i32> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; FIXED-MIN-2048-LABEL: 'ext'
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i1 undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i1 undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i1 undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i1 undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i1 undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i1 undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i1 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i1 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = sext i8 undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = zext i8 undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = sext i8 undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r12 = zext i8 undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r13 = sext i8 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r14 = zext i8 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r17 = sext i16 undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r18 = zext i16 undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r19 = sext i16 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r20 = zext i16 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r24 = sext i32 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r25 = zext i32 undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i16 = sext <2 x i8> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i16 = zext <2 x i8> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i32 = sext <2 x i8> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i32 = zext <2 x i8> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i64 = sext <2 x i8> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i8i64 = zext <2 x i8> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i32 = sext <2 x i16> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i32 = zext <2 x i16> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i64 = sext <2 x i16> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i16i64 = zext <2 x i16> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i32i64 = sext <2 x i32> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z2i32i64 = zext <2 x i32> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i16 = sext <4 x i8> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i16 = zext <4 x i8> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i32 = sext <4 x i8> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i32 = zext <4 x i8> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i64 = sext <4 x i8> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i8i64 = zext <4 x i8> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i32 = sext <4 x i16> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i16i32 = zext <4 x i16> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i64 = sext <4 x i16> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i16i64 = zext <4 x i16> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i32i64 = sext <4 x i32> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z4i32i64 = zext <4 x i32> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i16 = sext <8 x i8> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i8i16 = zext <8 x i8> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i32 = sext <8 x i8> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i8i32 = zext <8 x i8> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i64 = sext <8 x i8> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i8i64 = zext <8 x i8> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i16i32 = sext <8 x i16> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i16i32 = zext <8 x i16> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i16i64 = sext <8 x i16> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i16i64 = zext <8 x i16> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i32i64 = sext <8 x i32> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8i32i64 = zext <8 x i32> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i8i16 = sext <16 x i8> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16i8i16 = zext <16 x i8> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i8i32 = sext <16 x i8> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16i8i32 = zext <16 x i8> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i8i64 = sext <16 x i8> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16i8i64 = zext <16 x i8> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i16i32 = sext <16 x i16> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16i16i32 = zext <16 x i16> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i16i64 = sext <16 x i16> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16i16i64 = zext <16 x i16> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i32i64 = sext <16 x i32> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16i32i64 = zext <16 x i32> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %r0 = sext i1 undef to i8
  %r1 = zext i1 undef to i8
  %r2 = sext i1 undef to i16
  %r3 = zext i1 undef to i16
  %r4 = sext i1 undef to i32
  %r5 = zext i1 undef to i32
  %r6 = sext i1 undef to i64
  %r7 = zext i1 undef to i64
  %r9 = sext i8 undef to i16
  %r10 = zext i8 undef to i16
  %r11 = sext i8 undef to i32
  %r12 = zext i8 undef to i32
  %r13 = sext i8 undef to i64
  %r14 = zext i8 undef to i64
  %r17 = sext i16 undef to i32
  %r18 = zext i16 undef to i32
  %r19 = sext i16 undef to i64
  %r20 = zext i16 undef to i64
  %r24 = sext i32 undef to i64
  %r25 = zext i32 undef to i64

  %s2i8i16 = sext <2 x i8> undef to <2 x i16>
  %z2i8i16 = zext <2 x i8> undef to <2 x i16>
  %s2i8i32 = sext <2 x i8> undef to <2 x i32>
  %z2i8i32 = zext <2 x i8> undef to <2 x i32>
  %s2i8i64 = sext <2 x i8> undef to <2 x i64>
  %z2i8i64 = zext <2 x i8> undef to <2 x i64>
  %s2i16i32 = sext <2 x i16> undef to <2 x i32>
  %z2i16i32 = zext <2 x i16> undef to <2 x i32>
  %s2i16i64 = sext <2 x i16> undef to <2 x i64>
  %z2i16i64 = zext <2 x i16> undef to <2 x i64>
  %s2i32i64 = sext <2 x i32> undef to <2 x i64>
  %z2i32i64 = zext <2 x i32> undef to <2 x i64>

  %s4i8i16 = sext <4 x i8>  undef to <4 x i16>
  %z4i8i16 = zext <4 x i8>  undef to <4 x i16>
  %s4i8i32 = sext <4 x i8>  undef to <4 x i32>
  %z4i8i32 = zext <4 x i8>  undef to <4 x i32>
  %s4i8i64 = sext <4 x i8>  undef to <4 x i64>
  %z4i8i64 = zext <4 x i8>  undef to <4 x i64>
  %s4i16i32 = sext <4 x i16> undef to <4 x i32>
  %z4i16i32 = zext <4 x i16> undef to <4 x i32>
  %s4i16i64 = sext <4 x i16> undef to <4 x i64>
  %z4i16i64 = zext <4 x i16> undef to <4 x i64>
  %s4i32i64 = sext <4 x i32> undef to <4 x i64>
  %z4i32i64 = zext <4 x i32> undef to <4 x i64>

  %s8i8i16 = sext <8 x i8>  undef to <8 x i16>
  %z8i8i16 = zext <8 x i8>  undef to <8 x i16>
  %s8i8i32 = sext <8 x i8>  undef to <8 x i32>
  %z8i8i32 = zext <8 x i8>  undef to <8 x i32>
  %s8i8i64 = sext <8 x i8>  undef to <8 x i64>
  %z8i8i64 = zext <8 x i8>  undef to <8 x i64>
  %s8i16i32 = sext <8 x i16> undef to <8 x i32>
  %z8i16i32 = zext <8 x i16> undef to <8 x i32>
  %s8i16i64 = sext <8 x i16> undef to <8 x i64>
  %z8i16i64 = zext <8 x i16> undef to <8 x i64>
  %s8i32i64 = sext <8 x i32> undef to <8 x i64>
  %z8i32i64 = zext <8 x i32> undef to <8 x i64>

  %s16i8i16 = sext <16 x i8>  undef to <16 x i16>
  %z16i8i16 = zext <16 x i8>  undef to <16 x i16>
  %s16i8i32 = sext <16 x i8>  undef to <16 x i32>
  %z16i8i32 = zext <16 x i8>  undef to <16 x i32>
  %s16i8i64 = sext <16 x i8>  undef to <16 x i64>
  %z16i8i64 = zext <16 x i8>  undef to <16 x i64>
  %s16i16i32 = sext <16 x i16> undef to <16 x i32>
  %z16i16i32 = zext <16 x i16> undef to <16 x i32>
  %s16i16i64 = sext <16 x i16> undef to <16 x i64>
  %z16i16i64 = zext <16 x i16> undef to <16 x i64>
  %s16i32i64 = sext <16 x i32> undef to <16 x i64>
  %z16i32i64 = zext <16 x i32> undef to <16 x i64>
  ret void
}

define void @trunc() {
; CHECK-SVE-LABEL: 'trunc'
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = trunc i8 undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r15 = trunc i16 undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r16 = trunc i16 undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r21 = trunc i32 undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r22 = trunc i32 undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r23 = trunc i32 undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r26 = trunc i64 undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r27 = trunc i64 undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r28 = trunc i64 undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r29 = trunc i64 undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i16 = trunc <2 x i16> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i32 = trunc <2 x i32> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i64 = trunc <2 x i64> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i16i32 = trunc <2 x i32> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i64 = trunc <2 x i64> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i32i64 = trunc <2 x i64> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i16 = trunc <4 x i16> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i32 = trunc <4 x i32> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %s4i8i64 = trunc <4 x i64> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i32 = trunc <4 x i32> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s4i16i64 = trunc <4 x i64> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i32i64 = trunc <4 x i64> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i16 = trunc <8 x i16> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i8i32 = trunc <8 x i32> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s8i8i64 = trunc <8 x i64> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i16i32 = trunc <8 x i32> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %s8i16i64 = trunc <8 x i64> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s8i32i64 = trunc <8 x i64> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16i8i16 = trunc <16 x i16> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %s16i8i32 = trunc <16 x i32> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %s16i8i64 = trunc <16 x i64> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %s16i16i32 = trunc <16 x i32> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %s16i16i64 = trunc <16 x i64> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %s16i32i64 = trunc <16 x i64> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SVE128-NO-NEON-LABEL: 'trunc'
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = trunc i8 undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r15 = trunc i16 undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r16 = trunc i16 undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r21 = trunc i32 undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r22 = trunc i32 undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r23 = trunc i32 undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r26 = trunc i64 undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r27 = trunc i64 undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r28 = trunc i64 undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r29 = trunc i64 undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i16 = trunc <2 x i16> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i32 = trunc <2 x i32> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i64 = trunc <2 x i64> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i16i32 = trunc <2 x i32> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i16i64 = trunc <2 x i64> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i32i64 = trunc <2 x i64> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i16 = trunc <4 x i16> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i32 = trunc <4 x i32> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i64 = trunc <4 x i64> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i16i32 = trunc <4 x i32> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i16i64 = trunc <4 x i64> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i32i64 = trunc <4 x i64> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i8i16 = trunc <8 x i16> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i8i32 = trunc <8 x i32> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i8i64 = trunc <8 x i64> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i16i32 = trunc <8 x i32> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i16i64 = trunc <8 x i64> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i32i64 = trunc <8 x i64> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i16 = trunc <16 x i16> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i32 = trunc <16 x i32> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i64 = trunc <16 x i64> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i16i32 = trunc <16 x i32> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i16i64 = trunc <16 x i64> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i32i64 = trunc <16 x i64> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; FIXED-MIN-256-LABEL: 'trunc'
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = trunc i8 undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r15 = trunc i16 undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r16 = trunc i16 undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r21 = trunc i32 undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r22 = trunc i32 undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r23 = trunc i32 undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r26 = trunc i64 undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r27 = trunc i64 undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r28 = trunc i64 undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r29 = trunc i64 undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i16 = trunc <2 x i16> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i32 = trunc <2 x i32> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i64 = trunc <2 x i64> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i16i32 = trunc <2 x i32> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i64 = trunc <2 x i64> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i32i64 = trunc <2 x i64> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i16 = trunc <4 x i16> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i32 = trunc <4 x i32> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i64 = trunc <4 x i64> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i32 = trunc <4 x i32> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i16i64 = trunc <4 x i64> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i32i64 = trunc <4 x i64> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i16 = trunc <8 x i16> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i8i32 = trunc <8 x i32> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i8i64 = trunc <8 x i64> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i16i32 = trunc <8 x i32> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i16i64 = trunc <8 x i64> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i32i64 = trunc <8 x i64> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i16 = trunc <16 x i16> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i32 = trunc <16 x i32> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i64 = trunc <16 x i64> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i16i32 = trunc <16 x i32> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i16i64 = trunc <16 x i64> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i32i64 = trunc <16 x i64> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; FIXED-MIN-2048-LABEL: 'trunc'
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = trunc i8 undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r15 = trunc i16 undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r16 = trunc i16 undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r21 = trunc i32 undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r22 = trunc i32 undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r23 = trunc i32 undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r26 = trunc i64 undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r27 = trunc i64 undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r28 = trunc i64 undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r29 = trunc i64 undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i16 = trunc <2 x i16> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i8i32 = trunc <2 x i32> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i8i64 = trunc <2 x i64> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s2i16i32 = trunc <2 x i32> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i16i64 = trunc <2 x i64> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s2i32i64 = trunc <2 x i64> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i16 = trunc <4 x i16> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i8i32 = trunc <4 x i32> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i8i64 = trunc <4 x i64> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s4i16i32 = trunc <4 x i32> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i16i64 = trunc <4 x i64> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s4i32i64 = trunc <4 x i64> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8i8i16 = trunc <8 x i16> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i8i32 = trunc <8 x i32> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i8i64 = trunc <8 x i64> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i16i32 = trunc <8 x i32> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i16i64 = trunc <8 x i64> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s8i32i64 = trunc <8 x i64> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i16 = trunc <16 x i16> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i32 = trunc <16 x i32> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i8i64 = trunc <16 x i64> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i16i32 = trunc <16 x i32> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i16i64 = trunc <16 x i64> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %s16i32i64 = trunc <16 x i64> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %r8 = trunc i8 undef to i1
  %r15 = trunc i16 undef to i1
  %r16 = trunc i16 undef to i8
  %r21 = trunc i32 undef to i1
  %r22 = trunc i32 undef to i8
  %r23 = trunc i32 undef to i16
  %r26 = trunc i64 undef to i1
  %r27 = trunc i64 undef to i8
  %r28 = trunc i64 undef to i16
  %r29 = trunc i64 undef to i32

  %s2i8i16 = trunc <2 x i16> undef to <2 x i8>
  %s2i8i32 = trunc <2 x i32> undef to <2 x i8>
  %s2i8i64 = trunc <2 x i64> undef to <2 x i8>
  %s2i16i32 = trunc <2 x i32> undef to <2 x i16>
  %s2i16i64 = trunc <2 x i64> undef to <2 x i16>
  %s2i32i64 = trunc <2 x i64> undef to <2 x i32>

  %s4i8i16 = trunc <4 x i16> undef to <4 x i8>
  %s4i8i32 = trunc <4 x i32> undef to <4 x i8>
  %s4i8i64 = trunc <4 x i64> undef to <4 x i8>
  %s4i16i32 = trunc <4 x i32> undef to <4 x i16>
  %s4i16i64 = trunc <4 x i64> undef to <4 x i16>
  %s4i32i64 = trunc <4 x i64> undef to <4 x i32>

  %s8i8i16 = trunc <8 x i16> undef to <8 x i8>
  %s8i8i32 = trunc <8 x i32> undef to <8 x i8>
  %s8i8i64 = trunc <8 x i64> undef to <8 x i8>
  %s8i16i32 = trunc <8 x i32> undef to <8 x i16>
  %s8i16i64 = trunc <8 x i64> undef to <8 x i16>
  %s8i32i64 = trunc <8 x i64> undef to <8 x i32>

  %s16i8i16 = trunc <16 x i16> undef to <16 x i8>
  %s16i8i32 = trunc <16 x i32> undef to <16 x i8>
  %s16i8i64 = trunc <16 x i64> undef to <16 x i8>
  %s16i16i32 = trunc <16 x i32> undef to <16 x i16>
  %s16i16i64 = trunc <16 x i64> undef to <16 x i16>
  %s16i32i64 = trunc <16 x i64> undef to <16 x i32>
  ret void
}

define i32 @casts_no_users() {
; CHECK-SVE-LABEL: 'casts_no_users'
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui float undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi float undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui float undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi float undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui float undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi float undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui float undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi float undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui float undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi float undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r40 = fptoui double undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r41 = fptosi double undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r42 = fptoui double undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r43 = fptosi double undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r44 = fptoui double undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r45 = fptosi double undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r46 = fptoui double undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r47 = fptosi double undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r48 = fptoui double undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r49 = fptosi double undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r50 = sitofp i1 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r51 = uitofp i1 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r52 = sitofp i1 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r53 = uitofp i1 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r54 = sitofp i8 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r55 = uitofp i8 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r56 = sitofp i8 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r57 = uitofp i8 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r58 = sitofp i16 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r59 = uitofp i16 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r60 = sitofp i16 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r61 = uitofp i16 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r62 = sitofp i32 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r63 = uitofp i32 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r64 = sitofp i32 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r65 = uitofp i32 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r66 = sitofp i64 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r67 = uitofp i64 undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r68 = sitofp i64 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r69 = uitofp i64 undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r80 = fptrunc double undef to float
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r81 = fptrunc <2 x double> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r82 = fptrunc <4 x double> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r83 = fptrunc <8 x double> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r84 = fptrunc <16 x double> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r85 = fpext float undef to double
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r86 = fpext <2 x float> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r87 = fpext <4 x float> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r88 = fpext <8 x float> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r89 = fpext <16 x float> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x float> undef to <2 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x float> undef to <2 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x float> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x float> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x float> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x float> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x float> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x float> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r98 = fptoui <2 x float> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r99 = fptosi <2 x float> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r100 = fptoui <2 x double> undef to <2 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r101 = fptosi <2 x double> undef to <2 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r102 = fptoui <2 x double> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r103 = fptosi <2 x double> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r104 = fptoui <2 x double> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r105 = fptosi <2 x double> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r106 = fptoui <2 x double> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r107 = fptosi <2 x double> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r108 = fptoui <2 x double> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r109 = fptosi <2 x double> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r110 = fptoui <4 x float> undef to <4 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r111 = fptosi <4 x float> undef to <4 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r112 = fptoui <4 x float> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r113 = fptosi <4 x float> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r114 = fptoui <4 x float> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r115 = fptosi <4 x float> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r116 = fptoui <4 x float> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r117 = fptosi <4 x float> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r118 = fptoui <4 x float> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r119 = fptosi <4 x float> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %r120 = fptoui <4 x double> undef to <4 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %r121 = fptosi <4 x double> undef to <4 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r122 = fptoui <4 x double> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r123 = fptosi <4 x double> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r124 = fptoui <4 x double> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r125 = fptosi <4 x double> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r126 = fptoui <4 x double> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r127 = fptosi <4 x double> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r128 = fptoui <4 x double> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r129 = fptosi <4 x double> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %r130 = fptoui <8 x float> undef to <8 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %r131 = fptosi <8 x float> undef to <8 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r132 = fptoui <8 x float> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r133 = fptosi <8 x float> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r134 = fptoui <8 x float> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r135 = fptosi <8 x float> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r136 = fptoui <8 x float> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r137 = fptosi <8 x float> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r138 = fptoui <8 x float> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r139 = fptosi <8 x float> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 43 for instruction: %r140 = fptoui <8 x double> undef to <8 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 43 for instruction: %r141 = fptosi <8 x double> undef to <8 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %r142 = fptoui <8 x double> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %r143 = fptosi <8 x double> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %r144 = fptoui <8 x double> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %r145 = fptosi <8 x double> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r146 = fptoui <8 x double> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r147 = fptosi <8 x double> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r148 = fptoui <8 x double> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r149 = fptosi <8 x double> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %r150 = fptoui <16 x float> undef to <16 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 83 for instruction: %r151 = fptosi <16 x float> undef to <16 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %r152 = fptoui <16 x float> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %r153 = fptosi <16 x float> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r154 = fptoui <16 x float> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r155 = fptosi <16 x float> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r156 = fptoui <16 x float> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r157 = fptosi <16 x float> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r158 = fptoui <16 x float> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r159 = fptosi <16 x float> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 87 for instruction: %r160 = fptoui <16 x double> undef to <16 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 87 for instruction: %r161 = fptosi <16 x double> undef to <16 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %r162 = fptoui <16 x double> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %r163 = fptosi <16 x double> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %r164 = fptoui <16 x double> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %r165 = fptosi <16 x double> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r166 = fptoui <16 x double> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r167 = fptosi <16 x double> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r168 = fptoui <16 x double> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r169 = fptosi <16 x double> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r170 = uitofp <2 x i1> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r171 = sitofp <2 x i1> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r172 = uitofp <2 x i8> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r173 = sitofp <2 x i8> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r174 = uitofp <2 x i16> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r175 = sitofp <2 x i16> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r176 = uitofp <2 x i32> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r177 = sitofp <2 x i32> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r178 = uitofp <2 x i64> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r179 = sitofp <2 x i64> undef to <2 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r180 = uitofp <2 x i1> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r181 = sitofp <2 x i1> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r182 = uitofp <2 x i8> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r183 = sitofp <2 x i8> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r184 = uitofp <2 x i16> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r185 = sitofp <2 x i16> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r186 = uitofp <2 x i32> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r187 = sitofp <2 x i32> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r188 = uitofp <2 x i64> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r189 = sitofp <2 x i64> undef to <2 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r190 = uitofp <4 x i1> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r191 = sitofp <4 x i1> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r192 = uitofp <4 x i8> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r193 = sitofp <4 x i8> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r194 = uitofp <4 x i16> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r195 = sitofp <4 x i16> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r196 = uitofp <4 x i32> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r197 = sitofp <4 x i32> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r198 = uitofp <4 x i64> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %r199 = sitofp <4 x i64> undef to <4 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r200 = uitofp <4 x i1> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r201 = sitofp <4 x i1> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %r202 = uitofp <4 x i8> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %r203 = sitofp <4 x i8> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %r204 = uitofp <4 x i16> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %r205 = sitofp <4 x i16> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r206 = uitofp <4 x i32> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r207 = sitofp <4 x i32> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r208 = uitofp <4 x i64> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r209 = sitofp <4 x i64> undef to <4 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r210 = uitofp <8 x i1> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r211 = sitofp <8 x i1> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r212 = uitofp <8 x i8> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r213 = sitofp <8 x i8> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r214 = uitofp <8 x i16> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r215 = sitofp <8 x i16> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r216 = uitofp <8 x i32> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r217 = sitofp <8 x i32> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r218 = uitofp <8 x i64> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r219 = sitofp <8 x i64> undef to <8 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %r220 = uitofp <8 x i1> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %r221 = sitofp <8 x i1> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %r222 = uitofp <8 x i8> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %r223 = sitofp <8 x i8> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %r224 = uitofp <8 x i16> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %r225 = sitofp <8 x i16> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %r226 = uitofp <8 x i16> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %r227 = sitofp <8 x i16> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r228 = uitofp <8 x i64> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r229 = sitofp <8 x i64> undef to <8 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %r230 = uitofp <16 x i1> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %r231 = sitofp <16 x i1> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %r232 = uitofp <16 x i8> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %r233 = sitofp <16 x i8> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r234 = uitofp <16 x i16> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r235 = sitofp <16 x i16> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r236 = uitofp <16 x i32> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r237 = sitofp <16 x i32> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r238 = uitofp <16 x i64> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r239 = sitofp <16 x i64> undef to <16 x float>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %r240 = uitofp <16 x i1> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %r241 = sitofp <16 x i1> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 39 for instruction: %r242 = uitofp <16 x i8> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 39 for instruction: %r243 = sitofp <16 x i8> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %r244 = uitofp <16 x i16> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %r245 = sitofp <16 x i16> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %r246 = uitofp <16 x i16> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %r247 = sitofp <16 x i16> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r248 = uitofp <16 x i64> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r249 = sitofp <16 x i64> undef to <16 x double>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SVE128-NO-NEON-LABEL: 'casts_no_users'
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui float undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi float undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui float undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi float undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui float undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi float undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui float undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi float undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui float undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi float undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r40 = fptoui double undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r41 = fptosi double undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r42 = fptoui double undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r43 = fptosi double undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r44 = fptoui double undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r45 = fptosi double undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r46 = fptoui double undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r47 = fptosi double undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r48 = fptoui double undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r49 = fptosi double undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r50 = sitofp i1 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r51 = uitofp i1 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r52 = sitofp i1 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r53 = uitofp i1 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r54 = sitofp i8 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r55 = uitofp i8 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r56 = sitofp i8 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r57 = uitofp i8 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r58 = sitofp i16 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r59 = uitofp i16 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r60 = sitofp i16 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r61 = uitofp i16 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r62 = sitofp i32 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r63 = uitofp i32 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r64 = sitofp i32 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r65 = uitofp i32 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r66 = sitofp i64 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r67 = uitofp i64 undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r68 = sitofp i64 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r69 = uitofp i64 undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r80 = fptrunc double undef to float
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r81 = fptrunc <2 x double> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r82 = fptrunc <4 x double> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r83 = fptrunc <8 x double> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r84 = fptrunc <16 x double> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r85 = fpext float undef to double
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r86 = fpext <2 x float> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r87 = fpext <4 x float> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r88 = fpext <8 x float> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r89 = fpext <16 x float> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x float> undef to <2 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x float> undef to <2 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x float> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x float> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x float> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x float> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x float> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x float> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r98 = fptoui <2 x float> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r99 = fptosi <2 x float> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r100 = fptoui <2 x double> undef to <2 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r101 = fptosi <2 x double> undef to <2 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r102 = fptoui <2 x double> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r103 = fptosi <2 x double> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r104 = fptoui <2 x double> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r105 = fptosi <2 x double> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r106 = fptoui <2 x double> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r107 = fptosi <2 x double> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r108 = fptoui <2 x double> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r109 = fptosi <2 x double> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r110 = fptoui <4 x float> undef to <4 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r111 = fptosi <4 x float> undef to <4 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r112 = fptoui <4 x float> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r113 = fptosi <4 x float> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r114 = fptoui <4 x float> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r115 = fptosi <4 x float> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r116 = fptoui <4 x float> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r117 = fptosi <4 x float> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r118 = fptoui <4 x float> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r119 = fptosi <4 x float> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r120 = fptoui <4 x double> undef to <4 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r121 = fptosi <4 x double> undef to <4 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r122 = fptoui <4 x double> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r123 = fptosi <4 x double> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r124 = fptoui <4 x double> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r125 = fptosi <4 x double> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r126 = fptoui <4 x double> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r127 = fptosi <4 x double> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r128 = fptoui <4 x double> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r129 = fptosi <4 x double> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r130 = fptoui <8 x float> undef to <8 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r131 = fptosi <8 x float> undef to <8 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r132 = fptoui <8 x float> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r133 = fptosi <8 x float> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r134 = fptoui <8 x float> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r135 = fptosi <8 x float> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r136 = fptoui <8 x float> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r137 = fptosi <8 x float> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r138 = fptoui <8 x float> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r139 = fptosi <8 x float> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r140 = fptoui <8 x double> undef to <8 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r141 = fptosi <8 x double> undef to <8 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r142 = fptoui <8 x double> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r143 = fptosi <8 x double> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r144 = fptoui <8 x double> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r145 = fptosi <8 x double> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r146 = fptoui <8 x double> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r147 = fptosi <8 x double> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r148 = fptoui <8 x double> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r149 = fptosi <8 x double> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r150 = fptoui <16 x float> undef to <16 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r151 = fptosi <16 x float> undef to <16 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r152 = fptoui <16 x float> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r153 = fptosi <16 x float> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r154 = fptoui <16 x float> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r155 = fptosi <16 x float> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r156 = fptoui <16 x float> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r157 = fptosi <16 x float> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r158 = fptoui <16 x float> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r159 = fptosi <16 x float> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r160 = fptoui <16 x double> undef to <16 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r161 = fptosi <16 x double> undef to <16 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r162 = fptoui <16 x double> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r163 = fptosi <16 x double> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r164 = fptoui <16 x double> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r165 = fptosi <16 x double> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r166 = fptoui <16 x double> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r167 = fptosi <16 x double> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r168 = fptoui <16 x double> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r169 = fptosi <16 x double> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r170 = uitofp <2 x i1> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r171 = sitofp <2 x i1> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r172 = uitofp <2 x i8> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r173 = sitofp <2 x i8> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r174 = uitofp <2 x i16> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r175 = sitofp <2 x i16> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r176 = uitofp <2 x i32> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r177 = sitofp <2 x i32> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r178 = uitofp <2 x i64> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r179 = sitofp <2 x i64> undef to <2 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r180 = uitofp <2 x i1> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r181 = sitofp <2 x i1> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r182 = uitofp <2 x i8> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r183 = sitofp <2 x i8> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r184 = uitofp <2 x i16> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r185 = sitofp <2 x i16> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r186 = uitofp <2 x i32> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r187 = sitofp <2 x i32> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r188 = uitofp <2 x i64> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r189 = sitofp <2 x i64> undef to <2 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r190 = uitofp <4 x i1> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r191 = sitofp <4 x i1> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r192 = uitofp <4 x i8> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r193 = sitofp <4 x i8> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r194 = uitofp <4 x i16> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r195 = sitofp <4 x i16> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r196 = uitofp <4 x i32> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r197 = sitofp <4 x i32> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r198 = uitofp <4 x i64> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r199 = sitofp <4 x i64> undef to <4 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r200 = uitofp <4 x i1> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r201 = sitofp <4 x i1> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r202 = uitofp <4 x i8> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r203 = sitofp <4 x i8> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r204 = uitofp <4 x i16> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r205 = sitofp <4 x i16> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r206 = uitofp <4 x i32> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r207 = sitofp <4 x i32> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r208 = uitofp <4 x i64> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r209 = sitofp <4 x i64> undef to <4 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r210 = uitofp <8 x i1> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r211 = sitofp <8 x i1> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r212 = uitofp <8 x i8> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r213 = sitofp <8 x i8> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r214 = uitofp <8 x i16> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r215 = sitofp <8 x i16> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r216 = uitofp <8 x i32> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r217 = sitofp <8 x i32> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r218 = uitofp <8 x i64> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r219 = sitofp <8 x i64> undef to <8 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r220 = uitofp <8 x i1> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r221 = sitofp <8 x i1> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r222 = uitofp <8 x i8> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r223 = sitofp <8 x i8> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r224 = uitofp <8 x i16> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r225 = sitofp <8 x i16> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r226 = uitofp <8 x i16> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r227 = sitofp <8 x i16> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r228 = uitofp <8 x i64> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r229 = sitofp <8 x i64> undef to <8 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r230 = uitofp <16 x i1> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r231 = sitofp <16 x i1> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r232 = uitofp <16 x i8> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r233 = sitofp <16 x i8> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r234 = uitofp <16 x i16> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r235 = sitofp <16 x i16> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r236 = uitofp <16 x i32> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r237 = sitofp <16 x i32> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r238 = uitofp <16 x i64> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r239 = sitofp <16 x i64> undef to <16 x float>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r240 = uitofp <16 x i1> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r241 = sitofp <16 x i1> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r242 = uitofp <16 x i8> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r243 = sitofp <16 x i8> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r244 = uitofp <16 x i16> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r245 = sitofp <16 x i16> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r246 = uitofp <16 x i16> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r247 = sitofp <16 x i16> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r248 = uitofp <16 x i64> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r249 = sitofp <16 x i64> undef to <16 x double>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; FIXED-MIN-256-LABEL: 'casts_no_users'
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui float undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi float undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui float undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi float undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui float undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi float undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui float undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi float undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui float undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi float undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r40 = fptoui double undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r41 = fptosi double undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r42 = fptoui double undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r43 = fptosi double undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r44 = fptoui double undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r45 = fptosi double undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r46 = fptoui double undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r47 = fptosi double undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r48 = fptoui double undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r49 = fptosi double undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r50 = sitofp i1 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r51 = uitofp i1 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r52 = sitofp i1 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r53 = uitofp i1 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r54 = sitofp i8 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r55 = uitofp i8 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r56 = sitofp i8 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r57 = uitofp i8 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r58 = sitofp i16 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r59 = uitofp i16 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r60 = sitofp i16 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r61 = uitofp i16 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r62 = sitofp i32 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r63 = uitofp i32 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r64 = sitofp i32 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r65 = uitofp i32 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r66 = sitofp i64 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r67 = uitofp i64 undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r68 = sitofp i64 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r69 = uitofp i64 undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r80 = fptrunc double undef to float
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r81 = fptrunc <2 x double> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r82 = fptrunc <4 x double> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r83 = fptrunc <8 x double> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r84 = fptrunc <16 x double> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r85 = fpext float undef to double
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r86 = fpext <2 x float> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r87 = fpext <4 x float> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r88 = fpext <8 x float> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r89 = fpext <16 x float> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x float> undef to <2 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x float> undef to <2 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x float> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x float> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x float> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x float> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x float> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x float> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r98 = fptoui <2 x float> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r99 = fptosi <2 x float> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r100 = fptoui <2 x double> undef to <2 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r101 = fptosi <2 x double> undef to <2 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r102 = fptoui <2 x double> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r103 = fptosi <2 x double> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r104 = fptoui <2 x double> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r105 = fptosi <2 x double> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r106 = fptoui <2 x double> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r107 = fptosi <2 x double> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r108 = fptoui <2 x double> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r109 = fptosi <2 x double> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r110 = fptoui <4 x float> undef to <4 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r111 = fptosi <4 x float> undef to <4 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r112 = fptoui <4 x float> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r113 = fptosi <4 x float> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r114 = fptoui <4 x float> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r115 = fptosi <4 x float> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r116 = fptoui <4 x float> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r117 = fptosi <4 x float> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r118 = fptoui <4 x float> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r119 = fptosi <4 x float> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r120 = fptoui <4 x double> undef to <4 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r121 = fptosi <4 x double> undef to <4 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r122 = fptoui <4 x double> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r123 = fptosi <4 x double> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r124 = fptoui <4 x double> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r125 = fptosi <4 x double> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r126 = fptoui <4 x double> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r127 = fptosi <4 x double> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r128 = fptoui <4 x double> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r129 = fptosi <4 x double> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r130 = fptoui <8 x float> undef to <8 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r131 = fptosi <8 x float> undef to <8 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r132 = fptoui <8 x float> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r133 = fptosi <8 x float> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r134 = fptoui <8 x float> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r135 = fptosi <8 x float> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r136 = fptoui <8 x float> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r137 = fptosi <8 x float> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r138 = fptoui <8 x float> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r139 = fptosi <8 x float> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r140 = fptoui <8 x double> undef to <8 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r141 = fptosi <8 x double> undef to <8 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r142 = fptoui <8 x double> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r143 = fptosi <8 x double> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r144 = fptoui <8 x double> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r145 = fptosi <8 x double> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r146 = fptoui <8 x double> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r147 = fptosi <8 x double> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r148 = fptoui <8 x double> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r149 = fptosi <8 x double> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r150 = fptoui <16 x float> undef to <16 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r151 = fptosi <16 x float> undef to <16 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r152 = fptoui <16 x float> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r153 = fptosi <16 x float> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r154 = fptoui <16 x float> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r155 = fptosi <16 x float> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r156 = fptoui <16 x float> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r157 = fptosi <16 x float> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r158 = fptoui <16 x float> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r159 = fptosi <16 x float> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r160 = fptoui <16 x double> undef to <16 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r161 = fptosi <16 x double> undef to <16 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r162 = fptoui <16 x double> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r163 = fptosi <16 x double> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r164 = fptoui <16 x double> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r165 = fptosi <16 x double> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r166 = fptoui <16 x double> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r167 = fptosi <16 x double> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r168 = fptoui <16 x double> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r169 = fptosi <16 x double> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r170 = uitofp <2 x i1> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r171 = sitofp <2 x i1> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r172 = uitofp <2 x i8> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r173 = sitofp <2 x i8> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r174 = uitofp <2 x i16> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r175 = sitofp <2 x i16> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r176 = uitofp <2 x i32> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r177 = sitofp <2 x i32> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r178 = uitofp <2 x i64> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r179 = sitofp <2 x i64> undef to <2 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r180 = uitofp <2 x i1> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r181 = sitofp <2 x i1> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r182 = uitofp <2 x i8> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r183 = sitofp <2 x i8> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r184 = uitofp <2 x i16> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r185 = sitofp <2 x i16> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r186 = uitofp <2 x i32> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r187 = sitofp <2 x i32> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r188 = uitofp <2 x i64> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r189 = sitofp <2 x i64> undef to <2 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r190 = uitofp <4 x i1> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r191 = sitofp <4 x i1> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r192 = uitofp <4 x i8> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r193 = sitofp <4 x i8> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r194 = uitofp <4 x i16> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r195 = sitofp <4 x i16> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r196 = uitofp <4 x i32> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r197 = sitofp <4 x i32> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r198 = uitofp <4 x i64> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r199 = sitofp <4 x i64> undef to <4 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r200 = uitofp <4 x i1> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r201 = sitofp <4 x i1> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r202 = uitofp <4 x i8> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r203 = sitofp <4 x i8> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r204 = uitofp <4 x i16> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r205 = sitofp <4 x i16> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r206 = uitofp <4 x i32> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r207 = sitofp <4 x i32> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r208 = uitofp <4 x i64> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r209 = sitofp <4 x i64> undef to <4 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r210 = uitofp <8 x i1> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r211 = sitofp <8 x i1> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r212 = uitofp <8 x i8> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r213 = sitofp <8 x i8> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r214 = uitofp <8 x i16> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r215 = sitofp <8 x i16> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r216 = uitofp <8 x i32> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r217 = sitofp <8 x i32> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r218 = uitofp <8 x i64> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r219 = sitofp <8 x i64> undef to <8 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r220 = uitofp <8 x i1> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r221 = sitofp <8 x i1> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r222 = uitofp <8 x i8> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r223 = sitofp <8 x i8> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r224 = uitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r225 = sitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r226 = uitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r227 = sitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r228 = uitofp <8 x i64> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r229 = sitofp <8 x i64> undef to <8 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r230 = uitofp <16 x i1> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r231 = sitofp <16 x i1> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r232 = uitofp <16 x i8> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r233 = sitofp <16 x i8> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r234 = uitofp <16 x i16> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r235 = sitofp <16 x i16> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r236 = uitofp <16 x i32> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r237 = sitofp <16 x i32> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r238 = uitofp <16 x i64> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r239 = sitofp <16 x i64> undef to <16 x float>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r240 = uitofp <16 x i1> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r241 = sitofp <16 x i1> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r242 = uitofp <16 x i8> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r243 = sitofp <16 x i8> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r244 = uitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r245 = sitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r246 = uitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r247 = sitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r248 = uitofp <16 x i64> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r249 = sitofp <16 x i64> undef to <16 x double>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; FIXED-MIN-2048-LABEL: 'casts_no_users'
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui float undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi float undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui float undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi float undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui float undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi float undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui float undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi float undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui float undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi float undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r40 = fptoui double undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r41 = fptosi double undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r42 = fptoui double undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r43 = fptosi double undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r44 = fptoui double undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r45 = fptosi double undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r46 = fptoui double undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r47 = fptosi double undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r48 = fptoui double undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r49 = fptosi double undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r50 = sitofp i1 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r51 = uitofp i1 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r52 = sitofp i1 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r53 = uitofp i1 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r54 = sitofp i8 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r55 = uitofp i8 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r56 = sitofp i8 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r57 = uitofp i8 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r58 = sitofp i16 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r59 = uitofp i16 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r60 = sitofp i16 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r61 = uitofp i16 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r62 = sitofp i32 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r63 = uitofp i32 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r64 = sitofp i32 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r65 = uitofp i32 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r66 = sitofp i64 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r67 = uitofp i64 undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r68 = sitofp i64 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r69 = uitofp i64 undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r80 = fptrunc double undef to float
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r81 = fptrunc <2 x double> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r82 = fptrunc <4 x double> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r83 = fptrunc <8 x double> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r84 = fptrunc <16 x double> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r85 = fpext float undef to double
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r86 = fpext <2 x float> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r87 = fpext <4 x float> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r88 = fpext <8 x float> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r89 = fpext <16 x float> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x float> undef to <2 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x float> undef to <2 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x float> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x float> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x float> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x float> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x float> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x float> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r98 = fptoui <2 x float> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r99 = fptosi <2 x float> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r100 = fptoui <2 x double> undef to <2 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r101 = fptosi <2 x double> undef to <2 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r102 = fptoui <2 x double> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r103 = fptosi <2 x double> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r104 = fptoui <2 x double> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r105 = fptosi <2 x double> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r106 = fptoui <2 x double> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r107 = fptosi <2 x double> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r108 = fptoui <2 x double> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r109 = fptosi <2 x double> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r110 = fptoui <4 x float> undef to <4 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %r111 = fptosi <4 x float> undef to <4 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r112 = fptoui <4 x float> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r113 = fptosi <4 x float> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r114 = fptoui <4 x float> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r115 = fptosi <4 x float> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r116 = fptoui <4 x float> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r117 = fptosi <4 x float> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r118 = fptoui <4 x float> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r119 = fptosi <4 x float> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r120 = fptoui <4 x double> undef to <4 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r121 = fptosi <4 x double> undef to <4 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r122 = fptoui <4 x double> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r123 = fptosi <4 x double> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r124 = fptoui <4 x double> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r125 = fptosi <4 x double> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r126 = fptoui <4 x double> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r127 = fptosi <4 x double> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r128 = fptoui <4 x double> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r129 = fptosi <4 x double> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r130 = fptoui <8 x float> undef to <8 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r131 = fptosi <8 x float> undef to <8 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r132 = fptoui <8 x float> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r133 = fptosi <8 x float> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r134 = fptoui <8 x float> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r135 = fptosi <8 x float> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r136 = fptoui <8 x float> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r137 = fptosi <8 x float> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r138 = fptoui <8 x float> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r139 = fptosi <8 x float> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r140 = fptoui <8 x double> undef to <8 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r141 = fptosi <8 x double> undef to <8 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r142 = fptoui <8 x double> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r143 = fptosi <8 x double> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r144 = fptoui <8 x double> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r145 = fptosi <8 x double> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r146 = fptoui <8 x double> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r147 = fptosi <8 x double> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r148 = fptoui <8 x double> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r149 = fptosi <8 x double> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r150 = fptoui <16 x float> undef to <16 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r151 = fptosi <16 x float> undef to <16 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r152 = fptoui <16 x float> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r153 = fptosi <16 x float> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r154 = fptoui <16 x float> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r155 = fptosi <16 x float> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r156 = fptoui <16 x float> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r157 = fptosi <16 x float> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r158 = fptoui <16 x float> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r159 = fptosi <16 x float> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r160 = fptoui <16 x double> undef to <16 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r161 = fptosi <16 x double> undef to <16 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r162 = fptoui <16 x double> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r163 = fptosi <16 x double> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r164 = fptoui <16 x double> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r165 = fptosi <16 x double> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r166 = fptoui <16 x double> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r167 = fptosi <16 x double> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r168 = fptoui <16 x double> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r169 = fptosi <16 x double> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r170 = uitofp <2 x i1> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r171 = sitofp <2 x i1> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r172 = uitofp <2 x i8> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r173 = sitofp <2 x i8> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r174 = uitofp <2 x i16> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r175 = sitofp <2 x i16> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r176 = uitofp <2 x i32> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r177 = sitofp <2 x i32> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r178 = uitofp <2 x i64> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r179 = sitofp <2 x i64> undef to <2 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r180 = uitofp <2 x i1> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r181 = sitofp <2 x i1> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r182 = uitofp <2 x i8> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r183 = sitofp <2 x i8> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r184 = uitofp <2 x i16> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r185 = sitofp <2 x i16> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r186 = uitofp <2 x i32> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r187 = sitofp <2 x i32> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r188 = uitofp <2 x i64> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r189 = sitofp <2 x i64> undef to <2 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r190 = uitofp <4 x i1> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r191 = sitofp <4 x i1> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r192 = uitofp <4 x i8> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r193 = sitofp <4 x i8> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r194 = uitofp <4 x i16> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r195 = sitofp <4 x i16> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r196 = uitofp <4 x i32> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r197 = sitofp <4 x i32> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r198 = uitofp <4 x i64> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r199 = sitofp <4 x i64> undef to <4 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r200 = uitofp <4 x i1> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r201 = sitofp <4 x i1> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r202 = uitofp <4 x i8> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r203 = sitofp <4 x i8> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r204 = uitofp <4 x i16> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r205 = sitofp <4 x i16> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r206 = uitofp <4 x i32> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r207 = sitofp <4 x i32> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r208 = uitofp <4 x i64> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r209 = sitofp <4 x i64> undef to <4 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r210 = uitofp <8 x i1> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r211 = sitofp <8 x i1> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r212 = uitofp <8 x i8> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r213 = sitofp <8 x i8> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r214 = uitofp <8 x i16> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r215 = sitofp <8 x i16> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r216 = uitofp <8 x i32> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r217 = sitofp <8 x i32> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r218 = uitofp <8 x i64> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r219 = sitofp <8 x i64> undef to <8 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r220 = uitofp <8 x i1> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r221 = sitofp <8 x i1> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r222 = uitofp <8 x i8> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r223 = sitofp <8 x i8> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r224 = uitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r225 = sitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r226 = uitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r227 = sitofp <8 x i16> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r228 = uitofp <8 x i64> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r229 = sitofp <8 x i64> undef to <8 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r230 = uitofp <16 x i1> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r231 = sitofp <16 x i1> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r232 = uitofp <16 x i8> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r233 = sitofp <16 x i8> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r234 = uitofp <16 x i16> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r235 = sitofp <16 x i16> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r236 = uitofp <16 x i32> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r237 = sitofp <16 x i32> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r238 = uitofp <16 x i64> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r239 = sitofp <16 x i64> undef to <16 x float>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r240 = uitofp <16 x i1> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r241 = sitofp <16 x i1> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r242 = uitofp <16 x i8> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r243 = sitofp <16 x i8> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r244 = uitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r245 = sitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r246 = uitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r247 = sitofp <16 x i16> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r248 = uitofp <16 x i64> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r249 = sitofp <16 x i64> undef to <16 x double>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %r30 = fptoui float undef to i1
  %r31 = fptosi float undef to i1
  %r32 = fptoui float undef to i8
  %r33 = fptosi float undef to i8
  %r34 = fptoui float undef to i16
  %r35 = fptosi float undef to i16
  %r36 = fptoui float undef to i32
  %r37 = fptosi float undef to i32
  %r38 = fptoui float undef to i64
  %r39 = fptosi float undef to i64
  %r40 = fptoui double undef to i1
  %r41 = fptosi double undef to i1
  %r42 = fptoui double undef to i8
  %r43 = fptosi double undef to i8
  %r44 = fptoui double undef to i16
  %r45 = fptosi double undef to i16
  %r46 = fptoui double undef to i32
  %r47 = fptosi double undef to i32
  %r48 = fptoui double undef to i64
  %r49 = fptosi double undef to i64
  %r50 = sitofp i1 undef to float
  %r51 = uitofp i1 undef to float
  %r52 = sitofp i1 undef to double
  %r53 = uitofp i1 undef to double
  %r54 = sitofp i8 undef to float
  %r55 = uitofp i8 undef to float
  %r56 = sitofp i8 undef to double
  %r57 = uitofp i8 undef to double
  %r58 = sitofp i16 undef to float
  %r59 = uitofp i16 undef to float
  %r60 = sitofp i16 undef to double
  %r61 = uitofp i16 undef to double
  %r62 = sitofp i32 undef to float
  %r63 = uitofp i32 undef to float
  %r64 = sitofp i32 undef to double
  %r65 = uitofp i32 undef to double
  %r66 = sitofp i64 undef to float
  %r67 = uitofp i64 undef to float
  %r68 = sitofp i64 undef to double
  %r69 = uitofp i64 undef to double
  %r80 = fptrunc double undef to float
  %r81 = fptrunc <2 x double> undef to <2 x float>
  %r82 = fptrunc <4 x double> undef to <4 x float>
  %r83 = fptrunc <8 x double> undef to <8 x float>
  %r84 = fptrunc <16 x double> undef to <16 x float>
  %r85 = fpext float undef to double
  %r86 = fpext <2 x float> undef to <2 x double>
  %r87 = fpext <4 x float> undef to <4 x double>
  %r88 = fpext <8 x float> undef to <8 x double>
  %r89 = fpext <16 x float> undef to <16 x double>
  %r90 = fptoui <2 x float> undef to <2 x i1>
  %r91 = fptosi <2 x float> undef to <2 x i1>
  %r92 = fptoui <2 x float> undef to <2 x i8>
  %r93 = fptosi <2 x float> undef to <2 x i8>
  %r94 = fptoui <2 x float> undef to <2 x i16>
  %r95 = fptosi <2 x float> undef to <2 x i16>
  %r96 = fptoui <2 x float> undef to <2 x i32>
  %r97 = fptosi <2 x float> undef to <2 x i32>
  %r98 = fptoui <2 x float> undef to <2 x i64>
  %r99 = fptosi <2 x float> undef to <2 x i64>
  %r100 = fptoui <2 x double> undef to <2 x i1>
  %r101 = fptosi <2 x double> undef to <2 x i1>
  %r102 = fptoui <2 x double> undef to <2 x i8>
  %r103 = fptosi <2 x double> undef to <2 x i8>
  %r104 = fptoui <2 x double> undef to <2 x i16>
  %r105 = fptosi <2 x double> undef to <2 x i16>
  %r106 = fptoui <2 x double> undef to <2 x i32>
  %r107 = fptosi <2 x double> undef to <2 x i32>
  %r108 = fptoui <2 x double> undef to <2 x i64>
  %r109 = fptosi <2 x double> undef to <2 x i64>

  %r110 = fptoui <4 x float> undef to <4 x i1>
  %r111 = fptosi <4 x float> undef to <4 x i1>
  %r112 = fptoui <4 x float> undef to <4 x i8>
  %r113 = fptosi <4 x float> undef to <4 x i8>
  %r114 = fptoui <4 x float> undef to <4 x i16>
  %r115 = fptosi <4 x float> undef to <4 x i16>
  %r116 = fptoui <4 x float> undef to <4 x i32>
  %r117 = fptosi <4 x float> undef to <4 x i32>
  %r118 = fptoui <4 x float> undef to <4 x i64>
  %r119 = fptosi <4 x float> undef to <4 x i64>

  %r120 = fptoui <4 x double> undef to <4 x i1>
  %r121 = fptosi <4 x double> undef to <4 x i1>
  %r122 = fptoui <4 x double> undef to <4 x i8>
  %r123 = fptosi <4 x double> undef to <4 x i8>
  %r124 = fptoui <4 x double> undef to <4 x i16>
  %r125 = fptosi <4 x double> undef to <4 x i16>
  %r126 = fptoui <4 x double> undef to <4 x i32>
  %r127 = fptosi <4 x double> undef to <4 x i32>
  %r128 = fptoui <4 x double> undef to <4 x i64>
  %r129 = fptosi <4 x double> undef to <4 x i64>

  %r130 = fptoui <8 x float> undef to <8 x i1>
  %r131 = fptosi <8 x float> undef to <8 x i1>
  %r132 = fptoui <8 x float> undef to <8 x i8>
  %r133 = fptosi <8 x float> undef to <8 x i8>
  %r134 = fptoui <8 x float> undef to <8 x i16>
  %r135 = fptosi <8 x float> undef to <8 x i16>
  %r136 = fptoui <8 x float> undef to <8 x i32>
  %r137 = fptosi <8 x float> undef to <8 x i32>
  %r138 = fptoui <8 x float> undef to <8 x i64>
  %r139 = fptosi <8 x float> undef to <8 x i64>

  %r140 = fptoui <8 x double> undef to <8 x i1>
  %r141 = fptosi <8 x double> undef to <8 x i1>
  %r142 = fptoui <8 x double> undef to <8 x i8>
  %r143 = fptosi <8 x double> undef to <8 x i8>
  %r144 = fptoui <8 x double> undef to <8 x i16>
  %r145 = fptosi <8 x double> undef to <8 x i16>
  %r146 = fptoui <8 x double> undef to <8 x i32>
  %r147 = fptosi <8 x double> undef to <8 x i32>
  %r148 = fptoui <8 x double> undef to <8 x i64>
  %r149 = fptosi <8 x double> undef to <8 x i64>

  %r150 = fptoui <16 x float> undef to <16 x i1>
  %r151 = fptosi <16 x float> undef to <16 x i1>
  %r152 = fptoui <16 x float> undef to <16 x i8>
  %r153 = fptosi <16 x float> undef to <16 x i8>
  %r154 = fptoui <16 x float> undef to <16 x i16>
  %r155 = fptosi <16 x float> undef to <16 x i16>
  %r156 = fptoui <16 x float> undef to <16 x i32>
  %r157 = fptosi <16 x float> undef to <16 x i32>
  %r158 = fptoui <16 x float> undef to <16 x i64>
  %r159 = fptosi <16 x float> undef to <16 x i64>

  %r160 = fptoui <16 x double> undef to <16 x i1>
  %r161 = fptosi <16 x double> undef to <16 x i1>
  %r162 = fptoui <16 x double> undef to <16 x i8>
  %r163 = fptosi <16 x double> undef to <16 x i8>
  %r164 = fptoui <16 x double> undef to <16 x i16>
  %r165 = fptosi <16 x double> undef to <16 x i16>
  %r166 = fptoui <16 x double> undef to <16 x i32>
  %r167 = fptosi <16 x double> undef to <16 x i32>
  %r168 = fptoui <16 x double> undef to <16 x i64>
  %r169 = fptosi <16 x double> undef to <16 x i64>

  %r170 = uitofp <2 x i1> undef to <2 x float>
  %r171 = sitofp <2 x i1> undef to <2 x float>
  %r172 = uitofp <2 x i8> undef to <2 x float>
  %r173 = sitofp <2 x i8> undef to <2 x float>
  %r174 = uitofp <2 x i16> undef to <2 x float>
  %r175 = sitofp <2 x i16> undef to <2 x float>
  %r176 = uitofp <2 x i32> undef to <2 x float>
  %r177 = sitofp <2 x i32> undef to <2 x float>
  %r178 = uitofp <2 x i64> undef to <2 x float>
  %r179 = sitofp <2 x i64> undef to <2 x float>

  %r180 = uitofp <2 x i1> undef to <2 x double>
  %r181 = sitofp <2 x i1> undef to <2 x double>
  %r182 = uitofp <2 x i8> undef to <2 x double>
  %r183 = sitofp <2 x i8> undef to <2 x double>
  %r184 = uitofp <2 x i16> undef to <2 x double>
  %r185 = sitofp <2 x i16> undef to <2 x double>
  %r186 = uitofp <2 x i32> undef to <2 x double>
  %r187 = sitofp <2 x i32> undef to <2 x double>
  %r188 = uitofp <2 x i64> undef to <2 x double>
  %r189 = sitofp <2 x i64> undef to <2 x double>

  %r190 = uitofp <4 x i1> undef to <4 x float>
  %r191 = sitofp <4 x i1> undef to <4 x float>
  %r192 = uitofp <4 x i8> undef to <4 x float>
  %r193 = sitofp <4 x i8> undef to <4 x float>
  %r194 = uitofp <4 x i16> undef to <4 x float>
  %r195 = sitofp <4 x i16> undef to <4 x float>
  %r196 = uitofp <4 x i32> undef to <4 x float>
  %r197 = sitofp <4 x i32> undef to <4 x float>
  %r198 = uitofp <4 x i64> undef to <4 x float>
  %r199 = sitofp <4 x i64> undef to <4 x float>

  %r200 = uitofp <4 x i1> undef to <4 x double>
  %r201 = sitofp <4 x i1> undef to <4 x double>
  %r202 = uitofp <4 x i8> undef to <4 x double>
  %r203 = sitofp <4 x i8> undef to <4 x double>
  %r204 = uitofp <4 x i16> undef to <4 x double>
  %r205 = sitofp <4 x i16> undef to <4 x double>
  %r206 = uitofp <4 x i32> undef to <4 x double>
  %r207 = sitofp <4 x i32> undef to <4 x double>
  %r208 = uitofp <4 x i64> undef to <4 x double>
  %r209 = sitofp <4 x i64> undef to <4 x double>

  %r210 = uitofp <8 x i1> undef to <8 x float>
  %r211 = sitofp <8 x i1> undef to <8 x float>
  %r212 = uitofp <8 x i8> undef to <8 x float>
  %r213 = sitofp <8 x i8> undef to <8 x float>
  %r214 = uitofp <8 x i16> undef to <8 x float>
  %r215 = sitofp <8 x i16> undef to <8 x float>
  %r216 = uitofp <8 x i32> undef to <8 x float>
  %r217 = sitofp <8 x i32> undef to <8 x float>
  %r218 = uitofp <8 x i64> undef to <8 x float>
  %r219 = sitofp <8 x i64> undef to <8 x float>

  %r220 = uitofp <8 x i1> undef to <8 x double>
  %r221 = sitofp <8 x i1> undef to <8 x double>
  %r222 = uitofp <8 x i8> undef to <8 x double>
  %r223 = sitofp <8 x i8> undef to <8 x double>
  %r224 = uitofp <8 x i16> undef to <8 x double>
  %r225 = sitofp <8 x i16> undef to <8 x double>
  %r226 = uitofp <8 x i16> undef to <8 x double>
  %r227 = sitofp <8 x i16> undef to <8 x double>
  %r228 = uitofp <8 x i64> undef to <8 x double>
  %r229 = sitofp <8 x i64> undef to <8 x double>

  %r230 = uitofp <16 x i1> undef to <16 x float>
  %r231 = sitofp <16 x i1> undef to <16 x float>
  %r232 = uitofp <16 x i8> undef to <16 x float>
  %r233 = sitofp <16 x i8> undef to <16 x float>
  %r234 = uitofp <16 x i16> undef to <16 x float>
  %r235 = sitofp <16 x i16> undef to <16 x float>
  %r236 = uitofp <16 x i32> undef to <16 x float>
  %r237 = sitofp <16 x i32> undef to <16 x float>
  %r238 = uitofp <16 x i64> undef to <16 x float>
  %r239 = sitofp <16 x i64> undef to <16 x float>

  %r240 = uitofp <16 x i1> undef to <16 x double>
  %r241 = sitofp <16 x i1> undef to <16 x double>
  %r242 = uitofp <16 x i8> undef to <16 x double>
  %r243 = sitofp <16 x i8> undef to <16 x double>
  %r244 = uitofp <16 x i16> undef to <16 x double>
  %r245 = sitofp <16 x i16> undef to <16 x double>
  %r246 = uitofp <16 x i16> undef to <16 x double>
  %r247 = sitofp <16 x i16> undef to <16 x double>
  %r248 = uitofp <16 x i64> undef to <16 x double>
  %r249 = sitofp <16 x i64> undef to <16 x double>

  ret i32 undef
}

define i32 @casts_with_users(i8 %a, i16 %b, i32 %c, i64 %d, i1 %e) {
; CHECK-LABEL: 'casts_with_users'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r0 = sext i8 %a to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r1 = sext i8 %a to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r2 = sext i8 %a to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r3 = sext i16 %b to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r4 = sext i16 %b to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r5 = sext i32 %c to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 %r0, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %r1, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r2, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %r3, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r4, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r5, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r6 = zext i8 %a to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r7 = zext i8 %a to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = zext i8 %a to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r9 = zext i16 %b to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = zext i16 %b to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = zext i32 %c to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 %r6, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %r7, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r8, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %r9, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r10, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r11, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r12 = trunc i64 %d to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r13 = trunc i64 %d to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r14 = trunc i64 %d to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r15 = trunc i32 %c to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r16 = trunc i32 %c to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r17 = trunc i16 %b to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %tie.trunc.8 = add i8 %r14, %r16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %tie.trunc.8.1 = add i8 %tie.trunc.8, %r17
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %tie.trunc.16 = add i16 %r13, %r15
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %free.trunc.16.8 = trunc i16 %r6 to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %free.trunc.32.8 = trunc i32 %r7 to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %free.trunc.32.16 = trunc i32 %r9 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %free.trunc.64.8 = trunc i64 %r8 to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %free.trunc.64.16 = trunc i64 %r10 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %free.trunc.64.32 = trunc i64 %r11 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r18 = sext i1 %e to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r19 = sext i1 %e to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r20 = sext i1 %e to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r21 = sext i1 %e to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r22 = zext i1 %e to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r23 = zext i1 %e to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r24 = zext i1 %e to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r25 = zext i1 %e to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 %r18, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 %r19, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %r20, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r21, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 %r22, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 %r23, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %r24, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i64 %r25, ptr undef, align 8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 %r12
;
  %r0 = sext i8 %a to i16
  %r1 = sext i8 %a to i32
  %r2 = sext i8 %a to i64
  %r3 = sext i16 %b to i32
  %r4 = sext i16 %b to i64
  %r5 = sext i32 %c to i64
  store i16 %r0, ptr undef
  store i32 %r1, ptr undef
  store i64 %r2, ptr undef
  store i32 %r3, ptr undef
  store i64 %r4, ptr undef
  store i64 %r5, ptr undef

  %r6 = zext i8 %a to i16
  %r7 = zext i8 %a to i32
  %r8 = zext i8 %a to i64
  %r9 = zext i16 %b to i32
  %r10 = zext i16 %b to i64
  %r11 = zext i32 %c to i64
  store i16 %r6, ptr undef
  store i32 %r7, ptr undef
  store i64 %r8, ptr undef
  store i32 %r9, ptr undef
  store i64 %r10, ptr undef
  store i64 %r11, ptr undef

  %r12 = trunc i64 %d to i32
  %r13 = trunc i64 %d to i16
  %r14 = trunc i64 %d to i8
  %r15 = trunc i32 %c to i16
  %r16 = trunc i32 %c to i8
  %r17 = trunc i16 %b to i8
  %tie.trunc.8 = add i8 %r14, %r16
  %tie.trunc.8.1 = add i8 %tie.trunc.8, %r17
  %tie.trunc.16 = add i16 %r13, %r15

  %free.trunc.16.8 = trunc i16 %r6 to i8
  %free.trunc.32.8 = trunc i32 %r7 to i8
  %free.trunc.32.16 = trunc i32 %r9 to i16
  %free.trunc.64.8 = trunc i64 %r8 to i8
  %free.trunc.64.16 = trunc i64 %r10 to i16
  %free.trunc.64.32 = trunc i64 %r11 to i32

  %r18 = sext i1 %e to i8
  %r19 = sext i1 %e to i16
  %r20 = sext i1 %e to i32
  %r21 = sext i1 %e to i64
  %r22 = zext i1 %e to i8
  %r23 = zext i1 %e to i16
  %r24 = zext i1 %e to i32
  %r25 = zext i1 %e to i64
  store i8 %r18, ptr undef
  store i16 %r19, ptr undef
  store i32 %r20, ptr undef
  store i64 %r21, ptr undef
  store i8 %r22, ptr undef
  store i16 %r23, ptr undef
  store i32 %r24, ptr undef
  store i64 %r25, ptr undef
  ret i32 %r12
}

define i32 @bitcasts() {
; CHECK-LABEL: 'bitcasts'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %a = bitcast i32 undef to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %b = bitcast float undef to float
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %c = bitcast i32 undef to float
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %d = bitcast float undef to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = bitcast i64 undef to double
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %f = bitcast double undef to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %g = bitcast half undef to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %h = bitcast i16 undef to half
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %a = bitcast i32 undef to i32
  %b = bitcast float undef to float
  %c = bitcast i32 undef to float
  %d = bitcast float undef to i32
  %e = bitcast i64 undef to double
  %f = bitcast double undef to i64
  %g = bitcast half undef to i16
  %h = bitcast i16 undef to half
  ret i32 undef
}

define i32 @load_extends() #0 {
; CHECK-SVE-LABEL: 'load_extends'
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi8 = load i8, ptr undef, align 1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi16 = load i16, ptr undef, align 2
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi32 = load i32, ptr undef, align 4
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %loadv2i8 = load <2 x i8>, ptr undef, align 2
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %loadv4i8 = load <4 x i8>, ptr undef, align 4
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv8i8 = load <8 x i8>, ptr undef, align 8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %loadv2i16 = load <2 x i16>, ptr undef, align 4
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i16 = load <4 x i16>, ptr undef, align 8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i32 = load <2 x i32>, ptr undef, align 8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i32 = load <4 x i32>, ptr undef, align 16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv2i32 = load <vscale x 2 x i32>, ptr undef, align 8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv4i32 = load <vscale x 4 x i32>, ptr undef, align 16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i8 %loadi8 to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i8 %loadi8 to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i8 %loadi8 to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i8 %loadi8 to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i8 %loadi8 to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i8 %loadi8 to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i16 %loadi16 to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i16 %loadi16 to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = sext i16 %loadi16 to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = zext i16 %loadi16 to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = sext i32 %loadi32 to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = zext i32 %loadi32 to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v0 = sext <8 x i8> %loadv8i8 to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v1 = zext <8 x i8> %loadv8i8 to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2 = sext <4 x i8> %loadv4i8 to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3 = zext <4 x i8> %loadv4i8 to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4 = sext <2 x i8> %loadv2i8 to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5 = zext <2 x i8> %loadv2i8 to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v6 = sext <4 x i16> %loadv4i16 to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v7 = zext <4 x i16> %loadv4i16 to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8 = sext <2 x i16> %loadv2i16 to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v9 = zext <2 x i16> %loadv2i16 to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v10 = sext <2 x i32> %loadv2i32 to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v11 = zext <2 x i32> %loadv2i32 to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v12 = sext <4 x i32> %loadv4i32 to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v13 = zext <4 x i32> %loadv4i32 to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v14 = sext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v15 = zext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16 = sext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v17 = zext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SVE128-NO-NEON-LABEL: 'load_extends'
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi8 = load i8, ptr undef, align 1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi16 = load i16, ptr undef, align 2
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi32 = load i32, ptr undef, align 4
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i8 = load <2 x i8>, ptr undef, align 2
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i8 = load <4 x i8>, ptr undef, align 4
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv8i8 = load <8 x i8>, ptr undef, align 8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i16 = load <2 x i16>, ptr undef, align 4
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i16 = load <4 x i16>, ptr undef, align 8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i32 = load <2 x i32>, ptr undef, align 8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i32 = load <4 x i32>, ptr undef, align 16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv2i32 = load <vscale x 2 x i32>, ptr undef, align 8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv4i32 = load <vscale x 4 x i32>, ptr undef, align 16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i8 %loadi8 to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i8 %loadi8 to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i8 %loadi8 to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i8 %loadi8 to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i8 %loadi8 to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i8 %loadi8 to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i16 %loadi16 to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i16 %loadi16 to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = sext i16 %loadi16 to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = zext i16 %loadi16 to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = sext i32 %loadi32 to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = zext i32 %loadi32 to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v0 = sext <8 x i8> %loadv8i8 to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v1 = zext <8 x i8> %loadv8i8 to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2 = sext <4 x i8> %loadv4i8 to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3 = zext <4 x i8> %loadv4i8 to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4 = sext <2 x i8> %loadv2i8 to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5 = zext <2 x i8> %loadv2i8 to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v6 = sext <4 x i16> %loadv4i16 to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v7 = zext <4 x i16> %loadv4i16 to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8 = sext <2 x i16> %loadv2i16 to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v9 = zext <2 x i16> %loadv2i16 to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v10 = sext <2 x i32> %loadv2i32 to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v11 = zext <2 x i32> %loadv2i32 to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v12 = sext <4 x i32> %loadv4i32 to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v13 = zext <4 x i32> %loadv4i32 to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v14 = sext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v15 = zext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16 = sext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v17 = zext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; FIXED-MIN-256-LABEL: 'load_extends'
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi8 = load i8, ptr undef, align 1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi16 = load i16, ptr undef, align 2
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi32 = load i32, ptr undef, align 4
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i8 = load <2 x i8>, ptr undef, align 2
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i8 = load <4 x i8>, ptr undef, align 4
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv8i8 = load <8 x i8>, ptr undef, align 8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i16 = load <2 x i16>, ptr undef, align 4
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i16 = load <4 x i16>, ptr undef, align 8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i32 = load <2 x i32>, ptr undef, align 8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i32 = load <4 x i32>, ptr undef, align 16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv2i32 = load <vscale x 2 x i32>, ptr undef, align 8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv4i32 = load <vscale x 4 x i32>, ptr undef, align 16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i8 %loadi8 to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i8 %loadi8 to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i8 %loadi8 to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i8 %loadi8 to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i8 %loadi8 to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i8 %loadi8 to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i16 %loadi16 to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i16 %loadi16 to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = sext i16 %loadi16 to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = zext i16 %loadi16 to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = sext i32 %loadi32 to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = zext i32 %loadi32 to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v0 = sext <8 x i8> %loadv8i8 to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v1 = zext <8 x i8> %loadv8i8 to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2 = sext <4 x i8> %loadv4i8 to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3 = zext <4 x i8> %loadv4i8 to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4 = sext <2 x i8> %loadv2i8 to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5 = zext <2 x i8> %loadv2i8 to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v6 = sext <4 x i16> %loadv4i16 to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v7 = zext <4 x i16> %loadv4i16 to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8 = sext <2 x i16> %loadv2i16 to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v9 = zext <2 x i16> %loadv2i16 to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v10 = sext <2 x i32> %loadv2i32 to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v11 = zext <2 x i32> %loadv2i32 to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v12 = sext <4 x i32> %loadv4i32 to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v13 = zext <4 x i32> %loadv4i32 to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v14 = sext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v15 = zext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16 = sext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v17 = zext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; FIXED-MIN-2048-LABEL: 'load_extends'
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi8 = load i8, ptr undef, align 1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi16 = load i16, ptr undef, align 2
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadi32 = load i32, ptr undef, align 4
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i8 = load <2 x i8>, ptr undef, align 2
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i8 = load <4 x i8>, ptr undef, align 4
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv8i8 = load <8 x i8>, ptr undef, align 8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i16 = load <2 x i16>, ptr undef, align 4
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i16 = load <4 x i16>, ptr undef, align 8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv2i32 = load <2 x i32>, ptr undef, align 8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadv4i32 = load <4 x i32>, ptr undef, align 16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv2i32 = load <vscale x 2 x i32>, ptr undef, align 8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %loadnxv4i32 = load <vscale x 4 x i32>, ptr undef, align 16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = sext i8 %loadi8 to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = zext i8 %loadi8 to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = sext i8 %loadi8 to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = zext i8 %loadi8 to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = sext i8 %loadi8 to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = zext i8 %loadi8 to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r6 = sext i16 %loadi16 to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r7 = zext i16 %loadi16 to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r8 = sext i16 %loadi16 to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r9 = zext i16 %loadi16 to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r10 = sext i32 %loadi32 to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r11 = zext i32 %loadi32 to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v0 = sext <8 x i8> %loadv8i8 to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v1 = zext <8 x i8> %loadv8i8 to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2 = sext <4 x i8> %loadv4i8 to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3 = zext <4 x i8> %loadv4i8 to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4 = sext <2 x i8> %loadv2i8 to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5 = zext <2 x i8> %loadv2i8 to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v6 = sext <4 x i16> %loadv4i16 to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v7 = zext <4 x i16> %loadv4i16 to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8 = sext <2 x i16> %loadv2i16 to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v9 = zext <2 x i16> %loadv2i16 to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v10 = sext <2 x i32> %loadv2i32 to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v11 = zext <2 x i32> %loadv2i32 to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v12 = sext <4 x i32> %loadv4i32 to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v13 = zext <4 x i32> %loadv4i32 to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v14 = sext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v15 = zext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16 = sext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v17 = zext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %loadi8 = load i8, ptr undef
  %loadi16 = load i16, ptr undef
  %loadi32 = load i32, ptr undef
  %loadv2i8 = load <2 x i8>, ptr undef
  %loadv4i8 = load <4 x i8>, ptr undef
  %loadv8i8 = load <8 x i8>, ptr undef
  %loadv2i16 = load <2 x i16>, ptr undef
  %loadv4i16 = load <4 x i16>, ptr undef
  %loadv2i32 = load <2 x i32>, ptr undef
  %loadv4i32 = load <4 x i32>, ptr undef
  %loadnxv2i32 = load <vscale x 2 x i32>, ptr undef
  %loadnxv4i32 = load <vscale x 4 x i32>, ptr undef

  %r0 = sext i8 %loadi8 to i16
  %r1 = zext i8 %loadi8 to i16
  %r2 = sext i8 %loadi8 to i32
  %r3 = zext i8 %loadi8 to i32
  %r4 = sext i8 %loadi8 to i64
  %r5 = zext i8 %loadi8 to i64
  %r6 = sext i16 %loadi16 to i32
  %r7 = zext i16 %loadi16 to i32
  %r8 = sext i16 %loadi16 to i64
  %r9 = zext i16 %loadi16 to i64
  %r10 = sext i32 %loadi32 to i64
  %r11 = zext i32 %loadi32 to i64

  %v0 = sext <8 x i8> %loadv8i8 to <8 x i16>
  %v1 = zext <8 x i8> %loadv8i8 to <8 x i16>
  %v2 = sext <4 x i8> %loadv4i8 to <4 x i32>
  %v3 = zext <4 x i8> %loadv4i8 to <4 x i32>
  %v4 = sext <2 x i8> %loadv2i8 to <2 x i64>
  %v5 = zext <2 x i8> %loadv2i8 to <2 x i64>
  %v6 = sext <4 x i16> %loadv4i16 to <4 x i32>
  %v7 = zext <4 x i16> %loadv4i16 to <4 x i32>
  %v8 = sext <2 x i16> %loadv2i16 to <2 x i64>
  %v9 = zext <2 x i16> %loadv2i16 to <2 x i64>
  %v10 = sext <2 x i32> %loadv2i32 to <2 x i64>
  %v11 = zext <2 x i32> %loadv2i32 to <2 x i64>
  %v12 = sext <4 x i32> %loadv4i32 to <4 x i64>
  %v13 = zext <4 x i32> %loadv4i32 to <4 x i64>
  %v14 = sext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
  %v15 = zext <vscale x 2 x i32> %loadnxv2i32 to <vscale x 2 x i64>
  %v16 = sext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>
  %v17 = zext <vscale x 4 x i32> %loadnxv4i32 to <vscale x 4 x i64>

  ret i32 undef
}

define i32 @store_truncs() {
; CHECK-LABEL: 'store_truncs'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r0 = trunc i64 undef to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 %r0, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r1 = trunc i64 undef to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 %r1, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r2 = trunc i64 undef to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i32 %r2, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r3 = trunc i32 undef to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 %r3, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r4 = trunc i32 undef to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i16 %r4, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %r5 = trunc i16 undef to i8
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: store i8 %r5, ptr undef, align 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %r0 = trunc i64 undef to i8
  store i8 %r0, ptr undef
  %r1 = trunc i64 undef to i16
  store i16 %r1, ptr undef
  %r2 = trunc i64 undef to i32
  store i32 %r2, ptr undef
  %r3 = trunc i32 undef to i8
  store i8 %r3, ptr undef
  %r4 = trunc i32 undef to i16
  store i16 %r4, ptr undef
  %r5 = trunc i16 undef to i8
  store i8 %r5, ptr undef
  ret i32 undef
}

define void @extend_extract() {
; CHECK-LABEL: 'extend_extract'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %e8 = extractelement <8 x i8> undef, i32 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %e16 = extractelement <8 x i16> undef, i32 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %e32 = extractelement <8 x i32> undef, i32 1
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8_16 = sext i8 %e8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8_16 = zext i8 %e8 to i16
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8_32 = sext i8 %e8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z8_32 = zext i8 %e8 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s8_64 = sext i8 %e8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %z8_64 = zext i8 %e8 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16_32 = sext i16 %e16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %z16_32 = zext i16 %e16 to i32
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s16_64 = sext i16 %e16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %z16_64 = zext i16 %e16 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %s32_64 = sext i32 %e32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %z32_64 = zext i32 %e32 to i64
; CHECK-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: call void @use(i16 %s8_16, i16 %z8_16, i32 %s8_32, i32 %z8_32, i64 %s8_64, i64 %z8_64, i32 %s16_32, i32 %z16_32, i64 %s16_64, i64 %z16_64, i64 %s32_64, i64 %z32_64)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %e8 = extractelement <8 x i8> undef, i32 1
  %e16 = extractelement <8 x i16> undef, i32 1
  %e32 = extractelement <8 x i32> undef, i32 1
  %s8_16 = sext i8 %e8 to i16
  %z8_16 = zext i8 %e8 to i16
  %s8_32 = sext i8 %e8 to i32
  %z8_32 = zext i8 %e8 to i32
  %s8_64 = sext i8 %e8 to i64
  %z8_64 = zext i8 %e8 to i64
  %s16_32 = sext i16 %e16 to i32
  %z16_32 = zext i16 %e16 to i32
  %s16_64 = sext i16 %e16 to i64
  %z16_64 = zext i16 %e16 to i64
  %s32_64 = sext i32 %e32 to i64
  %z32_64 = zext i32 %e32 to i64
  call void @use(i16 %s8_16, i16 %z8_16, i32 %s8_32, i32 %z8_32, i64 %s8_64, i64 %z8_64, i32 %s16_32, i32 %z16_32, i64 %s16_64, i64 %z16_64, i64 %s32_64, i64 %z32_64)
  ret void
}

declare void @use(i16, i16, i32, i32, i64, i64, i32, i32, i64, i64, i64, i64)

define void @fp16cast() {
; CHECK-SVE-LABEL: 'fp16cast'
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui half undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi half undef to i1
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui half undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi half undef to i8
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui half undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi half undef to i16
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui half undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi half undef to i32
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui half undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi half undef to i64
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x half> undef to <2 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x half> undef to <2 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x half> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x half> undef to <2 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x half> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x half> undef to <2 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x half> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x half> undef to <2 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r98 = fptoui <2 x half> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r99 = fptosi <2 x half> undef to <2 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r110 = fptoui <4 x half> undef to <4 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r111 = fptosi <4 x half> undef to <4 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r112 = fptoui <4 x half> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r113 = fptosi <4 x half> undef to <4 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r114 = fptoui <4 x half> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r115 = fptosi <4 x half> undef to <4 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r116 = fptoui <4 x half> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r117 = fptosi <4 x half> undef to <4 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %r118 = fptoui <4 x half> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %r119 = fptosi <4 x half> undef to <4 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %r130 = fptoui <8 x half> undef to <8 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %r131 = fptosi <8 x half> undef to <8 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r132 = fptoui <8 x half> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r133 = fptosi <8 x half> undef to <8 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r134 = fptoui <8 x half> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r135 = fptosi <8 x half> undef to <8 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r136 = fptoui <8 x half> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r137 = fptosi <8 x half> undef to <8 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 43 for instruction: %r138 = fptoui <8 x half> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 43 for instruction: %r139 = fptosi <8 x half> undef to <8 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 81 for instruction: %r150 = fptoui <16 x half> undef to <16 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 81 for instruction: %r151 = fptosi <16 x half> undef to <16 x i1>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r152 = fptoui <16 x half> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r153 = fptosi <16 x half> undef to <16 x i8>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r154 = fptoui <16 x half> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r155 = fptosi <16 x half> undef to <16 x i16>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r156 = fptoui <16 x half> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r157 = fptosi <16 x half> undef to <16 x i32>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %r158 = fptoui <16 x half> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 86 for instruction: %r159 = fptosi <16 x half> undef to <16 x i64>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r250 = uitofp <8 x i1> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r251 = sitofp <8 x i1> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r252 = uitofp <8 x i8> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r253 = sitofp <8 x i8> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r254 = uitofp <8 x i16> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r255 = sitofp <8 x i16> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r256 = uitofp <8 x i32> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r257 = sitofp <8 x i32> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %r258 = uitofp <8 x i64> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %r259 = sitofp <8 x i64> undef to <8 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r260 = uitofp <16 x i1> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %r261 = sitofp <16 x i1> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r262 = uitofp <16 x i8> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r263 = sitofp <16 x i8> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r264 = uitofp <16 x i16> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r265 = sitofp <16 x i16> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %r266 = uitofp <16 x i32> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %r267 = sitofp <16 x i32> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %r268 = uitofp <16 x i64> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %r269 = sitofp <16 x i64> undef to <16 x half>
; CHECK-SVE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SVE128-NO-NEON-LABEL: 'fp16cast'
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui half undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi half undef to i1
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui half undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi half undef to i8
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui half undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi half undef to i16
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui half undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi half undef to i32
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui half undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi half undef to i64
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x half> undef to <2 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x half> undef to <2 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x half> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x half> undef to <2 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x half> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x half> undef to <2 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x half> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x half> undef to <2 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r98 = fptoui <2 x half> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r99 = fptosi <2 x half> undef to <2 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r110 = fptoui <4 x half> undef to <4 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r111 = fptosi <4 x half> undef to <4 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r112 = fptoui <4 x half> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r113 = fptosi <4 x half> undef to <4 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r114 = fptoui <4 x half> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r115 = fptosi <4 x half> undef to <4 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r116 = fptoui <4 x half> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r117 = fptosi <4 x half> undef to <4 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r118 = fptoui <4 x half> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r119 = fptosi <4 x half> undef to <4 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r130 = fptoui <8 x half> undef to <8 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r131 = fptosi <8 x half> undef to <8 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r132 = fptoui <8 x half> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r133 = fptosi <8 x half> undef to <8 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r134 = fptoui <8 x half> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r135 = fptosi <8 x half> undef to <8 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r136 = fptoui <8 x half> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r137 = fptosi <8 x half> undef to <8 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r138 = fptoui <8 x half> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r139 = fptosi <8 x half> undef to <8 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r150 = fptoui <16 x half> undef to <16 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r151 = fptosi <16 x half> undef to <16 x i1>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r152 = fptoui <16 x half> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r153 = fptosi <16 x half> undef to <16 x i8>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r154 = fptoui <16 x half> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r155 = fptosi <16 x half> undef to <16 x i16>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r156 = fptoui <16 x half> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r157 = fptosi <16 x half> undef to <16 x i32>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r158 = fptoui <16 x half> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r159 = fptosi <16 x half> undef to <16 x i64>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r250 = uitofp <8 x i1> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r251 = sitofp <8 x i1> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r252 = uitofp <8 x i8> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r253 = sitofp <8 x i8> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r254 = uitofp <8 x i16> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r255 = sitofp <8 x i16> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r256 = uitofp <8 x i32> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r257 = sitofp <8 x i32> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r258 = uitofp <8 x i64> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r259 = sitofp <8 x i64> undef to <8 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r260 = uitofp <16 x i1> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r261 = sitofp <16 x i1> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r262 = uitofp <16 x i8> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r263 = sitofp <16 x i8> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r264 = uitofp <16 x i16> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r265 = sitofp <16 x i16> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r266 = uitofp <16 x i32> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r267 = sitofp <16 x i32> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r268 = uitofp <16 x i64> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %r269 = sitofp <16 x i64> undef to <16 x half>
; SVE128-NO-NEON-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; FIXED-MIN-256-LABEL: 'fp16cast'
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui half undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi half undef to i1
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui half undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi half undef to i8
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui half undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi half undef to i16
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui half undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi half undef to i32
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui half undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi half undef to i64
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x half> undef to <2 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x half> undef to <2 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x half> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x half> undef to <2 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x half> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x half> undef to <2 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x half> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x half> undef to <2 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r98 = fptoui <2 x half> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r99 = fptosi <2 x half> undef to <2 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r110 = fptoui <4 x half> undef to <4 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r111 = fptosi <4 x half> undef to <4 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r112 = fptoui <4 x half> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r113 = fptosi <4 x half> undef to <4 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r114 = fptoui <4 x half> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r115 = fptosi <4 x half> undef to <4 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r116 = fptoui <4 x half> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r117 = fptosi <4 x half> undef to <4 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r118 = fptoui <4 x half> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r119 = fptosi <4 x half> undef to <4 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %r130 = fptoui <8 x half> undef to <8 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %r131 = fptosi <8 x half> undef to <8 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r132 = fptoui <8 x half> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r133 = fptosi <8 x half> undef to <8 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r134 = fptoui <8 x half> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r135 = fptosi <8 x half> undef to <8 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r136 = fptoui <8 x half> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r137 = fptosi <8 x half> undef to <8 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r138 = fptoui <8 x half> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r139 = fptosi <8 x half> undef to <8 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r150 = fptoui <16 x half> undef to <16 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r151 = fptosi <16 x half> undef to <16 x i1>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r152 = fptoui <16 x half> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r153 = fptosi <16 x half> undef to <16 x i8>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r154 = fptoui <16 x half> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r155 = fptosi <16 x half> undef to <16 x i16>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r156 = fptoui <16 x half> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r157 = fptosi <16 x half> undef to <16 x i32>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r158 = fptoui <16 x half> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r159 = fptosi <16 x half> undef to <16 x i64>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r250 = uitofp <8 x i1> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r251 = sitofp <8 x i1> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r252 = uitofp <8 x i8> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r253 = sitofp <8 x i8> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r254 = uitofp <8 x i16> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r255 = sitofp <8 x i16> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r256 = uitofp <8 x i32> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r257 = sitofp <8 x i32> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r258 = uitofp <8 x i64> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r259 = sitofp <8 x i64> undef to <8 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r260 = uitofp <16 x i1> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r261 = sitofp <16 x i1> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r262 = uitofp <16 x i8> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r263 = sitofp <16 x i8> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r264 = uitofp <16 x i16> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r265 = sitofp <16 x i16> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r266 = uitofp <16 x i32> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r267 = sitofp <16 x i32> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r268 = uitofp <16 x i64> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %r269 = sitofp <16 x i64> undef to <16 x half>
; FIXED-MIN-256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; FIXED-MIN-2048-LABEL: 'fp16cast'
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r30 = fptoui half undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r31 = fptosi half undef to i1
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r32 = fptoui half undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r33 = fptosi half undef to i8
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r34 = fptoui half undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r35 = fptosi half undef to i16
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r36 = fptoui half undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r37 = fptosi half undef to i32
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r38 = fptoui half undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r39 = fptosi half undef to i64
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r90 = fptoui <2 x half> undef to <2 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r91 = fptosi <2 x half> undef to <2 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r92 = fptoui <2 x half> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r93 = fptosi <2 x half> undef to <2 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r94 = fptoui <2 x half> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r95 = fptosi <2 x half> undef to <2 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r96 = fptoui <2 x half> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r97 = fptosi <2 x half> undef to <2 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r98 = fptoui <2 x half> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %r99 = fptosi <2 x half> undef to <2 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r110 = fptoui <4 x half> undef to <4 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r111 = fptosi <4 x half> undef to <4 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r112 = fptoui <4 x half> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r113 = fptosi <4 x half> undef to <4 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r114 = fptoui <4 x half> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r115 = fptosi <4 x half> undef to <4 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r116 = fptoui <4 x half> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r117 = fptosi <4 x half> undef to <4 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r118 = fptoui <4 x half> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r119 = fptosi <4 x half> undef to <4 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %r130 = fptoui <8 x half> undef to <8 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %r131 = fptosi <8 x half> undef to <8 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r132 = fptoui <8 x half> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r133 = fptosi <8 x half> undef to <8 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r134 = fptoui <8 x half> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r135 = fptosi <8 x half> undef to <8 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r136 = fptoui <8 x half> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r137 = fptosi <8 x half> undef to <8 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r138 = fptoui <8 x half> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r139 = fptosi <8 x half> undef to <8 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r150 = fptoui <16 x half> undef to <16 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r151 = fptosi <16 x half> undef to <16 x i1>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r152 = fptoui <16 x half> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r153 = fptosi <16 x half> undef to <16 x i8>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r154 = fptoui <16 x half> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r155 = fptosi <16 x half> undef to <16 x i16>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r156 = fptoui <16 x half> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r157 = fptosi <16 x half> undef to <16 x i32>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r158 = fptoui <16 x half> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r159 = fptosi <16 x half> undef to <16 x i64>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r250 = uitofp <8 x i1> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r251 = sitofp <8 x i1> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r252 = uitofp <8 x i8> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %r253 = sitofp <8 x i8> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r254 = uitofp <8 x i16> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r255 = sitofp <8 x i16> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r256 = uitofp <8 x i32> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r257 = sitofp <8 x i32> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r258 = uitofp <8 x i64> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r259 = sitofp <8 x i64> undef to <8 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r260 = uitofp <16 x i1> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r261 = sitofp <16 x i1> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r262 = uitofp <16 x i8> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r263 = sitofp <16 x i8> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r264 = uitofp <16 x i16> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r265 = sitofp <16 x i16> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r266 = uitofp <16 x i32> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r267 = sitofp <16 x i32> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r268 = uitofp <16 x i64> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %r269 = sitofp <16 x i64> undef to <16 x half>
; FIXED-MIN-2048-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %r30 = fptoui half undef to i1
  %r31 = fptosi half undef to i1
  %r32 = fptoui half undef to i8
  %r33 = fptosi half undef to i8
  %r34 = fptoui half undef to i16
  %r35 = fptosi half undef to i16
  %r36 = fptoui half undef to i32
  %r37 = fptosi half undef to i32
  %r38 = fptoui half undef to i64
  %r39 = fptosi half undef to i64

  %r90 = fptoui <2 x half> undef to <2 x i1>
  %r91 = fptosi <2 x half> undef to <2 x i1>
  %r92 = fptoui <2 x half> undef to <2 x i8>
  %r93 = fptosi <2 x half> undef to <2 x i8>
  %r94 = fptoui <2 x half> undef to <2 x i16>
  %r95 = fptosi <2 x half> undef to <2 x i16>
  %r96 = fptoui <2 x half> undef to <2 x i32>
  %r97 = fptosi <2 x half> undef to <2 x i32>
  %r98 = fptoui <2 x half> undef to <2 x i64>
  %r99 = fptosi <2 x half> undef to <2 x i64>

  %r110 = fptoui <4 x half> undef to <4 x i1>
  %r111 = fptosi <4 x half> undef to <4 x i1>
  %r112 = fptoui <4 x half> undef to <4 x i8>
  %r113 = fptosi <4 x half> undef to <4 x i8>
  %r114 = fptoui <4 x half> undef to <4 x i16>
  %r115 = fptosi <4 x half> undef to <4 x i16>
  %r116 = fptoui <4 x half> undef to <4 x i32>
  %r117 = fptosi <4 x half> undef to <4 x i32>
  %r118 = fptoui <4 x half> undef to <4 x i64>
  %r119 = fptosi <4 x half> undef to <4 x i64>

  %r130 = fptoui <8 x half> undef to <8 x i1>
  %r131 = fptosi <8 x half> undef to <8 x i1>
  %r132 = fptoui <8 x half> undef to <8 x i8>
  %r133 = fptosi <8 x half> undef to <8 x i8>
  %r134 = fptoui <8 x half> undef to <8 x i16>
  %r135 = fptosi <8 x half> undef to <8 x i16>
  %r136 = fptoui <8 x half> undef to <8 x i32>
  %r137 = fptosi <8 x half> undef to <8 x i32>
  %r138 = fptoui <8 x half> undef to <8 x i64>
  %r139 = fptosi <8 x half> undef to <8 x i64>

  %r150 = fptoui <16 x half> undef to <16 x i1>
  %r151 = fptosi <16 x half> undef to <16 x i1>
  %r152 = fptoui <16 x half> undef to <16 x i8>
  %r153 = fptosi <16 x half> undef to <16 x i8>
  %r154 = fptoui <16 x half> undef to <16 x i16>
  %r155 = fptosi <16 x half> undef to <16 x i16>
  %r156 = fptoui <16 x half> undef to <16 x i32>
  %r157 = fptosi <16 x half> undef to <16 x i32>
  %r158 = fptoui <16 x half> undef to <16 x i64>
  %r159 = fptosi <16 x half> undef to <16 x i64>

  %r250 = uitofp <8 x i1> undef to <8 x half>
  %r251 = sitofp <8 x i1> undef to <8 x half>
  %r252 = uitofp <8 x i8> undef to <8 x half>
  %r253 = sitofp <8 x i8> undef to <8 x half>
  %r254 = uitofp <8 x i16> undef to <8 x half>
  %r255 = sitofp <8 x i16> undef to <8 x half>
  %r256 = uitofp <8 x i32> undef to <8 x half>
  %r257 = sitofp <8 x i32> undef to <8 x half>
  %r258 = uitofp <8 x i64> undef to <8 x half>
  %r259 = sitofp <8 x i64> undef to <8 x half>

  %r260 = uitofp <16 x i1> undef to <16 x half>
  %r261 = sitofp <16 x i1> undef to <16 x half>
  %r262 = uitofp <16 x i8> undef to <16 x half>
  %r263 = sitofp <16 x i8> undef to <16 x half>
  %r264 = uitofp <16 x i16> undef to <16 x half>
  %r265 = sitofp <16 x i16> undef to <16 x half>
  %r266 = uitofp <16 x i32> undef to <16 x half>
  %r267 = sitofp <16 x i32> undef to <16 x half>
  %r268 = uitofp <16 x i64> undef to <16 x half>
  %r269 = sitofp <16 x i64> undef to <16 x half>
  ret void
}
